# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class UserLegacy(BaseModel):
    """
    UserLegacy
    """ # noqa: E501
    blocked_by: Optional[StrictBool] = None
    blocking: Optional[StrictBool] = None
    can_dm: StrictBool
    can_media_tag: StrictBool
    created_at: Annotated[str, Field(strict=True)]
    default_profile: StrictBool
    default_profile_image: StrictBool
    description: StrictStr
    entities: Dict[str, Any]
    fast_followers_count: StrictInt
    favourites_count: StrictInt
    follow_request_sent: Optional[StrictBool] = None
    followed_by: Optional[StrictBool] = None
    followers_count: StrictInt
    following: Optional[StrictBool] = None
    friends_count: StrictInt
    has_custom_timelines: StrictBool
    is_translator: StrictBool
    listed_count: StrictInt
    location: StrictStr
    media_count: StrictInt
    muting: Optional[StrictBool] = None
    name: StrictStr
    normal_followers_count: StrictInt
    notifications: Optional[StrictBool] = None
    pinned_tweet_ids_str: List[StrictStr]
    possibly_sensitive: StrictBool
    profile_banner_extensions: Optional[Dict[str, Any]] = None
    profile_banner_url: Optional[StrictStr] = None
    profile_image_extensions: Optional[Dict[str, Any]] = None
    profile_image_url_https: StrictStr
    profile_interstitial_type: StrictStr
    protected: Optional[StrictBool] = None
    screen_name: StrictStr
    statuses_count: StrictInt
    translator_type: StrictStr
    url: Optional[StrictStr] = None
    verified: StrictBool
    verified_type: Optional[StrictStr] = None
    want_retweets: StrictBool
    withheld_in_countries: Optional[List[StrictStr]] = None
    __properties: ClassVar[List[str]] = ["blocked_by", "blocking", "can_dm", "can_media_tag", "created_at", "default_profile", "default_profile_image", "description", "entities", "fast_followers_count", "favourites_count", "follow_request_sent", "followed_by", "followers_count", "following", "friends_count", "has_custom_timelines", "is_translator", "listed_count", "location", "media_count", "muting", "name", "normal_followers_count", "notifications", "pinned_tweet_ids_str", "possibly_sensitive", "profile_banner_extensions", "profile_banner_url", "profile_image_extensions", "profile_image_url_https", "profile_interstitial_type", "protected", "screen_name", "statuses_count", "translator_type", "url", "verified", "verified_type", "want_retweets", "withheld_in_countries"]

    @field_validator('created_at')
    def created_at_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(Sun|Mon|Tue|Wed|Thu|Fri|Sat) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (0[1-9]|[12][0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3])(: ?)([0-5][0-9])(: ?)([0-5][0-9]) ([+-][0-9]{4}) ([0-9]{4})$", value):
            raise ValueError(r"must validate the regular expression /^(Sun|Mon|Tue|Wed|Thu|Fri|Sat) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (0[1-9]|[12][0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3])(: ?)([0-5][0-9])(: ?)([0-5][0-9]) ([+-][0-9]{4}) ([0-9]{4})$/")
        return value

    @field_validator('verified_type')
    def verified_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Business', 'Government']):
            raise ValueError("must be one of enum values ('Business', 'Government')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UserLegacy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UserLegacy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "blocked_by": obj.get("blocked_by"),
            "blocking": obj.get("blocking"),
            "can_dm": obj.get("can_dm"),
            "can_media_tag": obj.get("can_media_tag"),
            "created_at": obj.get("created_at"),
            "default_profile": obj.get("default_profile"),
            "default_profile_image": obj.get("default_profile_image"),
            "description": obj.get("description"),
            "entities": obj.get("entities"),
            "fast_followers_count": obj.get("fast_followers_count"),
            "favourites_count": obj.get("favourites_count"),
            "follow_request_sent": obj.get("follow_request_sent"),
            "followed_by": obj.get("followed_by"),
            "followers_count": obj.get("followers_count"),
            "following": obj.get("following"),
            "friends_count": obj.get("friends_count"),
            "has_custom_timelines": obj.get("has_custom_timelines"),
            "is_translator": obj.get("is_translator"),
            "listed_count": obj.get("listed_count"),
            "location": obj.get("location"),
            "media_count": obj.get("media_count"),
            "muting": obj.get("muting"),
            "name": obj.get("name"),
            "normal_followers_count": obj.get("normal_followers_count"),
            "notifications": obj.get("notifications"),
            "pinned_tweet_ids_str": obj.get("pinned_tweet_ids_str"),
            "possibly_sensitive": obj.get("possibly_sensitive"),
            "profile_banner_extensions": obj.get("profile_banner_extensions"),
            "profile_banner_url": obj.get("profile_banner_url"),
            "profile_image_extensions": obj.get("profile_image_extensions"),
            "profile_image_url_https": obj.get("profile_image_url_https"),
            "profile_interstitial_type": obj.get("profile_interstitial_type"),
            "protected": obj.get("protected"),
            "screen_name": obj.get("screen_name"),
            "statuses_count": obj.get("statuses_count"),
            "translator_type": obj.get("translator_type"),
            "url": obj.get("url"),
            "verified": obj.get("verified"),
            "verified_type": obj.get("verified_type"),
            "want_retweets": obj.get("want_retweets"),
            "withheld_in_countries": obj.get("withheld_in_countries")
        })
        return _obj


