# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictBool, conlist, constr, validator

class TweetEditControlInitial(BaseModel):
    """
    TweetEditControlInitial
    """
    edit_tweet_ids: conlist(constr(strict=True)) = Field(...)
    editable_until_msecs: constr(strict=True) = Field(...)
    edits_remaining: constr(strict=True) = Field(...)
    is_edit_eligible: StrictBool = Field(...)
    __properties = ["edit_tweet_ids", "editable_until_msecs", "edits_remaining", "is_edit_eligible"]

    @validator('editable_until_msecs')
    def editable_until_msecs_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @validator('edits_remaining')
    def edits_remaining_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TweetEditControlInitial:
        """Create an instance of TweetEditControlInitial from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TweetEditControlInitial:
        """Create an instance of TweetEditControlInitial from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TweetEditControlInitial.parse_obj(obj)

        _obj = TweetEditControlInitial.parse_obj({
            "edit_tweet_ids": obj.get("edit_tweet_ids"),
            "editable_until_msecs": obj.get("editable_until_msecs"),
            "edits_remaining": obj.get("edits_remaining"),
            "is_edit_eligible": obj.get("is_edit_eligible")
        })
        return _obj


