# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictBool, StrictInt, StrictStr

from twitter_openapi_python_generated.api_client import ApiClient, RequestSerialized
from twitter_openapi_python_generated.api_response import ApiResponse
from twitter_openapi_python_generated.rest import RESTResponseType


class V11GetApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_friends_following_list(
        self,
        include_profile_interstitial_type: StrictInt,
        include_blocking: StrictInt,
        include_blocked_by: StrictInt,
        include_followed_by: StrictInt,
        include_want_retweets: StrictInt,
        include_mute_edge: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        skip_status: StrictInt,
        cursor: StrictInt,
        user_id: StrictStr,
        count: StrictInt,
        with_total_count: StrictBool,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """get_friends_following_list

        get friends following list

        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param skip_status: (required)
        :type skip_status: int
        :param cursor: (required)
        :type cursor: int
        :param user_id: (required)
        :type user_id: str
        :param count: (required)
        :type count: int
        :param with_total_count: (required)
        :type with_total_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_friends_following_list_serialize(
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_blocking=include_blocking,
            include_blocked_by=include_blocked_by,
            include_followed_by=include_followed_by,
            include_want_retweets=include_want_retweets,
            include_mute_edge=include_mute_edge,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            skip_status=skip_status,
            cursor=cursor,
            user_id=user_id,
            count=count,
            with_total_count=with_total_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_friends_following_list_with_http_info(
        self,
        include_profile_interstitial_type: StrictInt,
        include_blocking: StrictInt,
        include_blocked_by: StrictInt,
        include_followed_by: StrictInt,
        include_want_retweets: StrictInt,
        include_mute_edge: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        skip_status: StrictInt,
        cursor: StrictInt,
        user_id: StrictStr,
        count: StrictInt,
        with_total_count: StrictBool,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """get_friends_following_list

        get friends following list

        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param skip_status: (required)
        :type skip_status: int
        :param cursor: (required)
        :type cursor: int
        :param user_id: (required)
        :type user_id: str
        :param count: (required)
        :type count: int
        :param with_total_count: (required)
        :type with_total_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_friends_following_list_serialize(
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_blocking=include_blocking,
            include_blocked_by=include_blocked_by,
            include_followed_by=include_followed_by,
            include_want_retweets=include_want_retweets,
            include_mute_edge=include_mute_edge,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            skip_status=skip_status,
            cursor=cursor,
            user_id=user_id,
            count=count,
            with_total_count=with_total_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_friends_following_list_without_preload_content(
        self,
        include_profile_interstitial_type: StrictInt,
        include_blocking: StrictInt,
        include_blocked_by: StrictInt,
        include_followed_by: StrictInt,
        include_want_retweets: StrictInt,
        include_mute_edge: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        skip_status: StrictInt,
        cursor: StrictInt,
        user_id: StrictStr,
        count: StrictInt,
        with_total_count: StrictBool,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_friends_following_list

        get friends following list

        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param skip_status: (required)
        :type skip_status: int
        :param cursor: (required)
        :type cursor: int
        :param user_id: (required)
        :type user_id: str
        :param count: (required)
        :type count: int
        :param with_total_count: (required)
        :type with_total_count: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_friends_following_list_serialize(
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_blocking=include_blocking,
            include_blocked_by=include_blocked_by,
            include_followed_by=include_followed_by,
            include_want_retweets=include_want_retweets,
            include_mute_edge=include_mute_edge,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            skip_status=skip_status,
            cursor=cursor,
            user_id=user_id,
            count=count,
            with_total_count=with_total_count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_friends_following_list_serialize(
        self,
        include_profile_interstitial_type,
        include_blocking,
        include_blocked_by,
        include_followed_by,
        include_want_retweets,
        include_mute_edge,
        include_can_dm,
        include_can_media_tag,
        include_ext_has_nft_avatar,
        include_ext_is_blue_verified,
        include_ext_verified_type,
        include_ext_profile_image_shape,
        skip_status,
        cursor,
        user_id,
        count,
        with_total_count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include_profile_interstitial_type is not None:
            
            _query_params.append(('include_profile_interstitial_type', include_profile_interstitial_type))
            
        if include_blocking is not None:
            
            _query_params.append(('include_blocking', include_blocking))
            
        if include_blocked_by is not None:
            
            _query_params.append(('include_blocked_by', include_blocked_by))
            
        if include_followed_by is not None:
            
            _query_params.append(('include_followed_by', include_followed_by))
            
        if include_want_retweets is not None:
            
            _query_params.append(('include_want_retweets', include_want_retweets))
            
        if include_mute_edge is not None:
            
            _query_params.append(('include_mute_edge', include_mute_edge))
            
        if include_can_dm is not None:
            
            _query_params.append(('include_can_dm', include_can_dm))
            
        if include_can_media_tag is not None:
            
            _query_params.append(('include_can_media_tag', include_can_media_tag))
            
        if include_ext_has_nft_avatar is not None:
            
            _query_params.append(('include_ext_has_nft_avatar', include_ext_has_nft_avatar))
            
        if include_ext_is_blue_verified is not None:
            
            _query_params.append(('include_ext_is_blue_verified', include_ext_is_blue_verified))
            
        if include_ext_verified_type is not None:
            
            _query_params.append(('include_ext_verified_type', include_ext_verified_type))
            
        if include_ext_profile_image_shape is not None:
            
            _query_params.append(('include_ext_profile_image_shape', include_ext_profile_image_shape))
            
        if skip_status is not None:
            
            _query_params.append(('skip_status', skip_status))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if user_id is not None:
            
            _query_params.append(('user_id', user_id))
            
        if count is not None:
            
            _query_params.append(('count', count))
            
        if with_total_count is not None:
            
            _query_params.append(('with_total_count', with_total_count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'Accept', 
            'ClientLanguage', 
            'Referer', 
            'SecFetchDest', 
            'SecChUaPlatform', 
            'SecFetchMode', 
            'CsrfToken', 
            'ClientUuid', 
            'BearerAuth', 
            'GuestToken', 
            'SecChUa', 
            'CookieGt0', 
            'ClientTransactionId', 
            'ActiveUser', 
            'CookieCt0', 
            'UserAgent', 
            'AcceptLanguage', 
            'SecFetchSite', 
            'AuthType', 
            'CookieAuthToken', 
            'SecChUaMobile', 
            'AcceptEncoding'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/1.1/friends/following/list.json',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_search_typeahead(
        self,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        q: StrictStr,
        src: StrictStr,
        result_type: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """get_search_typeahead

        get search typeahead

        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param q: (required)
        :type q: str
        :param src: (required)
        :type src: str
        :param result_type: (required)
        :type result_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_typeahead_serialize(
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            q=q,
            src=src,
            result_type=result_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_search_typeahead_with_http_info(
        self,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        q: StrictStr,
        src: StrictStr,
        result_type: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """get_search_typeahead

        get search typeahead

        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param q: (required)
        :type q: str
        :param src: (required)
        :type src: str
        :param result_type: (required)
        :type result_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_typeahead_serialize(
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            q=q,
            src=src,
            result_type=result_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_search_typeahead_without_preload_content(
        self,
        include_ext_is_blue_verified: StrictInt,
        include_ext_verified_type: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        q: StrictStr,
        src: StrictStr,
        result_type: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """get_search_typeahead

        get search typeahead

        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param q: (required)
        :type q: str
        :param src: (required)
        :type src: str
        :param result_type: (required)
        :type result_type: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_search_typeahead_serialize(
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_verified_type=include_ext_verified_type,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            q=q,
            src=src,
            result_type=result_type,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_search_typeahead_serialize(
        self,
        include_ext_is_blue_verified,
        include_ext_verified_type,
        include_ext_profile_image_shape,
        q,
        src,
        result_type,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if include_ext_is_blue_verified is not None:
            
            _query_params.append(('include_ext_is_blue_verified', include_ext_is_blue_verified))
            
        if include_ext_verified_type is not None:
            
            _query_params.append(('include_ext_verified_type', include_ext_verified_type))
            
        if include_ext_profile_image_shape is not None:
            
            _query_params.append(('include_ext_profile_image_shape', include_ext_profile_image_shape))
            
        if q is not None:
            
            _query_params.append(('q', q))
            
        if src is not None:
            
            _query_params.append(('src', src))
            
        if result_type is not None:
            
            _query_params.append(('result_type', result_type))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'Accept', 
            'ClientLanguage', 
            'Referer', 
            'SecFetchDest', 
            'SecChUaPlatform', 
            'SecFetchMode', 
            'CsrfToken', 
            'ClientUuid', 
            'BearerAuth', 
            'GuestToken', 
            'SecChUa', 
            'CookieGt0', 
            'ClientTransactionId', 
            'ActiveUser', 
            'CookieCt0', 
            'UserAgent', 
            'AcceptLanguage', 
            'SecFetchSite', 
            'AuthType', 
            'CookieAuthToken', 
            'SecChUaMobile', 
            'AcceptEncoding'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/1.1/search/typeahead.json',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


