# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from twitter_openapi_python_generated.models.birdwatch_pivot_call_to_action import BirdwatchPivotCallToAction
from twitter_openapi_python_generated.models.birdwatch_pivot_footer import BirdwatchPivotFooter
from twitter_openapi_python_generated.models.birdwatch_pivot_note import BirdwatchPivotNote
from twitter_openapi_python_generated.models.birdwatch_pivot_subtitle import BirdwatchPivotSubtitle
from typing import Optional, Set
from typing_extensions import Self

class BirdwatchPivot(BaseModel):
    """
    BirdwatchPivot
    """ # noqa: E501
    call_to_action: Optional[BirdwatchPivotCallToAction] = Field(default=None, alias="callToAction")
    destination_url: StrictStr = Field(alias="destinationUrl")
    footer: BirdwatchPivotFooter
    icon_type: StrictStr = Field(alias="iconType")
    note: BirdwatchPivotNote
    shorttitle: StrictStr
    subtitle: BirdwatchPivotSubtitle
    title: StrictStr
    visual_style: Optional[StrictStr] = Field(default=None, alias="visualStyle")
    __properties: ClassVar[List[str]] = ["callToAction", "destinationUrl", "footer", "iconType", "note", "shorttitle", "subtitle", "title", "visualStyle"]

    @field_validator('icon_type')
    def icon_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['BirdwatchV1Icon']):
            raise ValueError("must be one of enum values ('BirdwatchV1Icon')")
        return value

    @field_validator('visual_style')
    def visual_style_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['Default']):
            raise ValueError("must be one of enum values ('Default')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BirdwatchPivot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of call_to_action
        if self.call_to_action:
            _dict['callToAction'] = self.call_to_action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of footer
        if self.footer:
            _dict['footer'] = self.footer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of note
        if self.note:
            _dict['note'] = self.note.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subtitle
        if self.subtitle:
            _dict['subtitle'] = self.subtitle.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BirdwatchPivot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "callToAction": BirdwatchPivotCallToAction.from_dict(obj["callToAction"]) if obj.get("callToAction") is not None else None,
            "destinationUrl": obj.get("destinationUrl"),
            "footer": BirdwatchPivotFooter.from_dict(obj["footer"]) if obj.get("footer") is not None else None,
            "iconType": obj.get("iconType"),
            "note": BirdwatchPivotNote.from_dict(obj["note"]) if obj.get("note") is not None else None,
            "shorttitle": obj.get("shorttitle"),
            "subtitle": BirdwatchPivotSubtitle.from_dict(obj["subtitle"]) if obj.get("subtitle") is not None else None,
            "title": obj.get("title"),
            "visualStyle": obj.get("visualStyle")
        })
        return _obj


