# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from twitter_openapi_python_generated.models.article_cover_media import ArticleCoverMedia
from twitter_openapi_python_generated.models.article_lifecycle_state import ArticleLifecycleState
from twitter_openapi_python_generated.models.article_metadata import ArticleMetadata
from typing import Optional, Set
from typing_extensions import Self

class ArticleResult(BaseModel):
    """
    ArticleResult
    """ # noqa: E501
    cover_media: ArticleCoverMedia
    id: StrictStr
    lifecycle_state: Optional[ArticleLifecycleState] = None
    metadata: ArticleMetadata
    preview_text: StrictStr
    rest_id: Annotated[str, Field(strict=True)]
    title: StrictStr
    __properties: ClassVar[List[str]] = ["cover_media", "id", "lifecycle_state", "metadata", "preview_text", "rest_id", "title"]

    @field_validator('rest_id')
    def rest_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArticleResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cover_media
        if self.cover_media:
            _dict['cover_media'] = self.cover_media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of lifecycle_state
        if self.lifecycle_state:
            _dict['lifecycle_state'] = self.lifecycle_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadata
        if self.metadata:
            _dict['metadata'] = self.metadata.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArticleResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "cover_media": ArticleCoverMedia.from_dict(obj["cover_media"]) if obj.get("cover_media") is not None else None,
            "id": obj.get("id"),
            "lifecycle_state": ArticleLifecycleState.from_dict(obj["lifecycle_state"]) if obj.get("lifecycle_state") is not None else None,
            "metadata": ArticleMetadata.from_dict(obj["metadata"]) if obj.get("metadata") is not None else None,
            "preview_text": obj.get("preview_text"),
            "rest_id": obj.get("rest_id"),
            "title": obj.get("title")
        })
        return _obj


