# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from twitter_openapi_python_generated.models.entities import Entities
from twitter_openapi_python_generated.models.extended_entities import ExtendedEntities
from twitter_openapi_python_generated.models.quoted_status_permalink import QuotedStatusPermalink
from twitter_openapi_python_generated.models.self_thread import SelfThread
from twitter_openapi_python_generated.models.tweet_legacy_scopes import TweetLegacyScopes
from typing import Optional, Set
from typing_extensions import Self

class TweetLegacy(BaseModel):
    """
    TweetLegacy
    """ # noqa: E501
    bookmark_count: StrictInt
    bookmarked: StrictBool
    conversation_control: Optional[Dict[str, Any]] = None
    conversation_id_str: Annotated[str, Field(strict=True)]
    created_at: Annotated[str, Field(strict=True)]
    display_text_range: List[StrictInt]
    entities: Entities
    extended_entities: Optional[ExtendedEntities] = None
    favorite_count: StrictInt
    favorited: StrictBool
    full_text: StrictStr
    id_str: Annotated[str, Field(strict=True)]
    in_reply_to_screen_name: Optional[StrictStr] = None
    in_reply_to_status_id_str: Optional[Annotated[str, Field(strict=True)]] = None
    in_reply_to_user_id_str: Optional[Annotated[str, Field(strict=True)]] = None
    is_quote_status: StrictBool
    lang: StrictStr
    limited_actions: Optional[StrictStr] = None
    place: Optional[Dict[str, Any]] = None
    possibly_sensitive: Optional[StrictBool] = None
    possibly_sensitive_editable: Optional[StrictBool] = None
    quote_count: StrictInt
    quoted_status_id_str: Optional[Annotated[str, Field(strict=True)]] = None
    quoted_status_permalink: Optional[QuotedStatusPermalink] = None
    reply_count: StrictInt
    retweet_count: StrictInt
    retweeted: StrictBool
    retweeted_status_result: Optional[ItemResult] = None
    scopes: Optional[TweetLegacyScopes] = None
    self_thread: Optional[SelfThread] = None
    user_id_str: Annotated[str, Field(strict=True)]
    __properties: ClassVar[List[str]] = ["bookmark_count", "bookmarked", "conversation_control", "conversation_id_str", "created_at", "display_text_range", "entities", "extended_entities", "favorite_count", "favorited", "full_text", "id_str", "in_reply_to_screen_name", "in_reply_to_status_id_str", "in_reply_to_user_id_str", "is_quote_status", "lang", "limited_actions", "place", "possibly_sensitive", "possibly_sensitive_editable", "quote_count", "quoted_status_id_str", "quoted_status_permalink", "reply_count", "retweet_count", "retweeted", "retweeted_status_result", "scopes", "self_thread", "user_id_str"]

    @field_validator('conversation_id_str')
    def conversation_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('created_at')
    def created_at_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(Sun|Mon|Tue|Wed|Thu|Fri|Sat) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (0[1-9]|[12][0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3])(: ?)([0-5][0-9])(: ?)([0-5][0-9]) ([+-][0-9]{4}) ([0-9]{4})$", value):
            raise ValueError(r"must validate the regular expression /^(Sun|Mon|Tue|Wed|Thu|Fri|Sat) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (0[1-9]|[12][0-9]|3[01]) (0[0-9]|1[0-9]|2[0-3])(: ?)([0-5][0-9])(: ?)([0-5][0-9]) ([+-][0-9]{4}) ([0-9]{4})$/")
        return value

    @field_validator('id_str')
    def id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('in_reply_to_status_id_str')
    def in_reply_to_status_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('in_reply_to_user_id_str')
    def in_reply_to_user_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('limited_actions')
    def limited_actions_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['limited_replies', 'non_compliant', 'dynamic_product_ad', 'stale_tweet', 'community_tweet_non_member_public_community', 'community_tweet_non_member_closed_community']):
            raise ValueError("must be one of enum values ('limited_replies', 'non_compliant', 'dynamic_product_ad', 'stale_tweet', 'community_tweet_non_member_public_community', 'community_tweet_non_member_closed_community')")
        return value

    @field_validator('quoted_status_id_str')
    def quoted_status_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('user_id_str')
    def user_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TweetLegacy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of entities
        if self.entities:
            _dict['entities'] = self.entities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of extended_entities
        if self.extended_entities:
            _dict['extended_entities'] = self.extended_entities.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quoted_status_permalink
        if self.quoted_status_permalink:
            _dict['quoted_status_permalink'] = self.quoted_status_permalink.to_dict()
        # override the default output from pydantic by calling `to_dict()` of retweeted_status_result
        if self.retweeted_status_result:
            _dict['retweeted_status_result'] = self.retweeted_status_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of scopes
        if self.scopes:
            _dict['scopes'] = self.scopes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of self_thread
        if self.self_thread:
            _dict['self_thread'] = self.self_thread.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TweetLegacy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bookmark_count": obj.get("bookmark_count"),
            "bookmarked": obj.get("bookmarked"),
            "conversation_control": obj.get("conversation_control"),
            "conversation_id_str": obj.get("conversation_id_str"),
            "created_at": obj.get("created_at"),
            "display_text_range": obj.get("display_text_range"),
            "entities": Entities.from_dict(obj["entities"]) if obj.get("entities") is not None else None,
            "extended_entities": ExtendedEntities.from_dict(obj["extended_entities"]) if obj.get("extended_entities") is not None else None,
            "favorite_count": obj.get("favorite_count"),
            "favorited": obj.get("favorited"),
            "full_text": obj.get("full_text"),
            "id_str": obj.get("id_str"),
            "in_reply_to_screen_name": obj.get("in_reply_to_screen_name"),
            "in_reply_to_status_id_str": obj.get("in_reply_to_status_id_str"),
            "in_reply_to_user_id_str": obj.get("in_reply_to_user_id_str"),
            "is_quote_status": obj.get("is_quote_status"),
            "lang": obj.get("lang"),
            "limited_actions": obj.get("limited_actions"),
            "place": obj.get("place"),
            "possibly_sensitive": obj.get("possibly_sensitive"),
            "possibly_sensitive_editable": obj.get("possibly_sensitive_editable"),
            "quote_count": obj.get("quote_count"),
            "quoted_status_id_str": obj.get("quoted_status_id_str"),
            "quoted_status_permalink": QuotedStatusPermalink.from_dict(obj["quoted_status_permalink"]) if obj.get("quoted_status_permalink") is not None else None,
            "reply_count": obj.get("reply_count"),
            "retweet_count": obj.get("retweet_count"),
            "retweeted": obj.get("retweeted"),
            "retweeted_status_result": ItemResult.from_dict(obj["retweeted_status_result"]) if obj.get("retweeted_status_result") is not None else None,
            "scopes": TweetLegacyScopes.from_dict(obj["scopes"]) if obj.get("scopes") is not None else None,
            "self_thread": SelfThread.from_dict(obj["self_thread"]) if obj.get("self_thread") is not None else None,
            "user_id_str": obj.get("user_id_str")
        })
        return _obj

from twitter_openapi_python_generated.models.item_result import ItemResult
# TODO: Rewrite to not use raise_errors
TweetLegacy.model_rebuild(raise_errors=False)

