# twitter_openapi_python_generated
Twitter OpenAPI(Swagger) specification

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 0.0.25
- Generator version: 7.9.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/fa0311/twitter_openapi_python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/fa0311/twitter_openapi_python.git`)

Then import the package:
```python
import twitter_openapi_python_generated
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import twitter_openapi_python_generated
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import twitter_openapi_python_generated
from twitter_openapi_python_generated.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://x.com/i/api
# See configuration.py for a list of all supported configuration parameters.
configuration = twitter_openapi_python_generated.Configuration(
    host = "https://x.com/i/api"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Accept
configuration.api_key['Accept'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Accept'] = 'Bearer'

# Configure API key authorization: ClientLanguage
configuration.api_key['ClientLanguage'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ClientLanguage'] = 'Bearer'

# Configure API key authorization: Priority
configuration.api_key['Priority'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Priority'] = 'Bearer'

# Configure API key authorization: Referer
configuration.api_key['Referer'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Referer'] = 'Bearer'

# Configure API key authorization: SecFetchDest
configuration.api_key['SecFetchDest'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecFetchDest'] = 'Bearer'

# Configure API key authorization: SecChUaPlatform
configuration.api_key['SecChUaPlatform'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecChUaPlatform'] = 'Bearer'

# Configure API key authorization: SecFetchMode
configuration.api_key['SecFetchMode'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecFetchMode'] = 'Bearer'

# Configure API key authorization: CsrfToken
configuration.api_key['CsrfToken'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CsrfToken'] = 'Bearer'

# Configure API key authorization: ClientUuid
configuration.api_key['ClientUuid'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ClientUuid'] = 'Bearer'

# Configure Bearer authorization: BearerAuth
configuration = twitter_openapi_python_generated.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Configure API key authorization: GuestToken
configuration.api_key['GuestToken'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['GuestToken'] = 'Bearer'

# Configure API key authorization: SecChUa
configuration.api_key['SecChUa'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecChUa'] = 'Bearer'

# Configure API key authorization: CookieGt0
configuration.api_key['CookieGt0'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CookieGt0'] = 'Bearer'

# Configure API key authorization: ClientTransactionId
configuration.api_key['ClientTransactionId'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ClientTransactionId'] = 'Bearer'

# Configure API key authorization: ActiveUser
configuration.api_key['ActiveUser'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ActiveUser'] = 'Bearer'

# Configure API key authorization: CookieCt0
configuration.api_key['CookieCt0'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CookieCt0'] = 'Bearer'

# Configure API key authorization: UserAgent
configuration.api_key['UserAgent'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['UserAgent'] = 'Bearer'

# Configure API key authorization: AcceptLanguage
configuration.api_key['AcceptLanguage'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['AcceptLanguage'] = 'Bearer'

# Configure API key authorization: SecFetchSite
configuration.api_key['SecFetchSite'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecFetchSite'] = 'Bearer'

# Configure API key authorization: AuthType
configuration.api_key['AuthType'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['AuthType'] = 'Bearer'

# Configure API key authorization: CookieAuthToken
configuration.api_key['CookieAuthToken'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CookieAuthToken'] = 'Bearer'

# Configure API key authorization: SecChUaMobile
configuration.api_key['SecChUaMobile'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecChUaMobile'] = 'Bearer'

# Configure API key authorization: AcceptEncoding
configuration.api_key['AcceptEncoding'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['AcceptEncoding'] = 'Bearer'


# Enter a context with an instance of the API client
with twitter_openapi_python_generated.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = twitter_openapi_python_generated.DefaultApi(api_client)
    path_query_id = '-0XdHI-mrHWBQd8-oLo1aA' # str |  (default to '-0XdHI-mrHWBQd8-oLo1aA')
    variables = '{"screen_name": "elonmusk"}' # str |  (default to '{"screen_name": "elonmusk"}')
    features = '{}' # str |  (default to '{}')

    try:
        api_response = api_instance.get_profile_spotlights_query(path_query_id, variables, features)
        print("The response of DefaultApi->get_profile_spotlights_query:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->get_profile_spotlights_query: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://x.com/i/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_profile_spotlights_query**](docs/DefaultApi.md#get_profile_spotlights_query) | **GET** /graphql/{pathQueryId}/ProfileSpotlightsQuery | 
*DefaultApi* | [**get_tweet_result_by_rest_id**](docs/DefaultApi.md#get_tweet_result_by_rest_id) | **GET** /graphql/{pathQueryId}/TweetResultByRestId | 
*OtherApi* | [**other**](docs/OtherApi.md#other) | **GET** /other | 
*PostApi* | [**post_create_bookmark**](docs/PostApi.md#post_create_bookmark) | **POST** /graphql/{pathQueryId}/CreateBookmark | 
*PostApi* | [**post_create_retweet**](docs/PostApi.md#post_create_retweet) | **POST** /graphql/{pathQueryId}/CreateRetweet | 
*PostApi* | [**post_create_tweet**](docs/PostApi.md#post_create_tweet) | **POST** /graphql/{pathQueryId}/CreateTweet | 
*PostApi* | [**post_delete_bookmark**](docs/PostApi.md#post_delete_bookmark) | **POST** /graphql/{pathQueryId}/DeleteBookmark | 
*PostApi* | [**post_delete_retweet**](docs/PostApi.md#post_delete_retweet) | **POST** /graphql/{pathQueryId}/DeleteRetweet | 
*PostApi* | [**post_delete_tweet**](docs/PostApi.md#post_delete_tweet) | **POST** /graphql/{pathQueryId}/DeleteTweet | 
*PostApi* | [**post_favorite_tweet**](docs/PostApi.md#post_favorite_tweet) | **POST** /graphql/{pathQueryId}/FavoriteTweet | 
*PostApi* | [**post_unfavorite_tweet**](docs/PostApi.md#post_unfavorite_tweet) | **POST** /graphql/{pathQueryId}/UnfavoriteTweet | 
*TweetApi* | [**get_bookmarks**](docs/TweetApi.md#get_bookmarks) | **GET** /graphql/{pathQueryId}/Bookmarks | 
*TweetApi* | [**get_home_latest_timeline**](docs/TweetApi.md#get_home_latest_timeline) | **GET** /graphql/{pathQueryId}/HomeLatestTimeline | 
*TweetApi* | [**get_home_timeline**](docs/TweetApi.md#get_home_timeline) | **GET** /graphql/{pathQueryId}/HomeTimeline | 
*TweetApi* | [**get_likes**](docs/TweetApi.md#get_likes) | **GET** /graphql/{pathQueryId}/Likes | 
*TweetApi* | [**get_list_latest_tweets_timeline**](docs/TweetApi.md#get_list_latest_tweets_timeline) | **GET** /graphql/{pathQueryId}/ListLatestTweetsTimeline | 
*TweetApi* | [**get_search_timeline**](docs/TweetApi.md#get_search_timeline) | **GET** /graphql/{pathQueryId}/SearchTimeline | 
*TweetApi* | [**get_tweet_detail**](docs/TweetApi.md#get_tweet_detail) | **GET** /graphql/{pathQueryId}/TweetDetail | 
*TweetApi* | [**get_user_highlights_tweets**](docs/TweetApi.md#get_user_highlights_tweets) | **GET** /graphql/{pathQueryId}/UserHighlightsTweets | 
*TweetApi* | [**get_user_media**](docs/TweetApi.md#get_user_media) | **GET** /graphql/{pathQueryId}/UserMedia | 
*TweetApi* | [**get_user_tweets**](docs/TweetApi.md#get_user_tweets) | **GET** /graphql/{pathQueryId}/UserTweets | 
*TweetApi* | [**get_user_tweets_and_replies**](docs/TweetApi.md#get_user_tweets_and_replies) | **GET** /graphql/{pathQueryId}/UserTweetsAndReplies | 
*UserApi* | [**get_user_by_rest_id**](docs/UserApi.md#get_user_by_rest_id) | **GET** /graphql/{pathQueryId}/UserByRestId | 
*UserApi* | [**get_user_by_screen_name**](docs/UserApi.md#get_user_by_screen_name) | **GET** /graphql/{pathQueryId}/UserByScreenName | 
*UserListApi* | [**get_favoriters**](docs/UserListApi.md#get_favoriters) | **GET** /graphql/{pathQueryId}/Favoriters | 
*UserListApi* | [**get_followers**](docs/UserListApi.md#get_followers) | **GET** /graphql/{pathQueryId}/Followers | 
*UserListApi* | [**get_followers_you_know**](docs/UserListApi.md#get_followers_you_know) | **GET** /graphql/{pathQueryId}/FollowersYouKnow | 
*UserListApi* | [**get_following**](docs/UserListApi.md#get_following) | **GET** /graphql/{pathQueryId}/Following | 
*UserListApi* | [**get_retweeters**](docs/UserListApi.md#get_retweeters) | **GET** /graphql/{pathQueryId}/Retweeters | 
*UsersApi* | [**get_users_by_rest_ids**](docs/UsersApi.md#get_users_by_rest_ids) | **GET** /graphql/{pathQueryId}/UsersByRestIds | 
*V11GetApi* | [**get_friends_following_list**](docs/V11GetApi.md#get_friends_following_list) | **GET** /1.1/friends/following/list.json | 
*V11GetApi* | [**get_search_typeahead**](docs/V11GetApi.md#get_search_typeahead) | **GET** /1.1/search/typeahead.json | 
*V11PostApi* | [**post_create_friendships**](docs/V11PostApi.md#post_create_friendships) | **POST** /1.1/friendships/create.json | 
*V11PostApi* | [**post_destroy_friendships**](docs/V11PostApi.md#post_destroy_friendships) | **POST** /1.1/friendships/destroy.json | 
*V20GetApi* | [**get_search_adaptive**](docs/V20GetApi.md#get_search_adaptive) | **GET** /2/search/adaptive.json | 


## Documentation For Models

 - [AdditionalMediaInfo](docs/AdditionalMediaInfo.md)
 - [AdditionalMediaInfoCallToActions](docs/AdditionalMediaInfoCallToActions.md)
 - [AdditionalMediaInfoCallToActionsUrl](docs/AdditionalMediaInfoCallToActionsUrl.md)
 - [AllowDownloadStatus](docs/AllowDownloadStatus.md)
 - [Article](docs/Article.md)
 - [ArticleCoverMedia](docs/ArticleCoverMedia.md)
 - [ArticleCoverMediaColorInfo](docs/ArticleCoverMediaColorInfo.md)
 - [ArticleCoverMediaColorInfoPalette](docs/ArticleCoverMediaColorInfoPalette.md)
 - [ArticleCoverMediaColorInfoPaletteRGB](docs/ArticleCoverMediaColorInfoPaletteRGB.md)
 - [ArticleCoverMediaInfo](docs/ArticleCoverMediaInfo.md)
 - [ArticleLifecycleState](docs/ArticleLifecycleState.md)
 - [ArticleMetadata](docs/ArticleMetadata.md)
 - [ArticleResult](docs/ArticleResult.md)
 - [ArticleResults](docs/ArticleResults.md)
 - [AuthorCommunityRelationship](docs/AuthorCommunityRelationship.md)
 - [BirdwatchEntity](docs/BirdwatchEntity.md)
 - [BirdwatchEntityRef](docs/BirdwatchEntityRef.md)
 - [BirdwatchPivot](docs/BirdwatchPivot.md)
 - [BirdwatchPivotCallToAction](docs/BirdwatchPivotCallToAction.md)
 - [BirdwatchPivotFooter](docs/BirdwatchPivotFooter.md)
 - [BirdwatchPivotNote](docs/BirdwatchPivotNote.md)
 - [BirdwatchPivotSubtitle](docs/BirdwatchPivotSubtitle.md)
 - [BookmarksResponse](docs/BookmarksResponse.md)
 - [BookmarksResponseData](docs/BookmarksResponseData.md)
 - [BookmarksTimeline](docs/BookmarksTimeline.md)
 - [Callback](docs/Callback.md)
 - [ClientEventInfo](docs/ClientEventInfo.md)
 - [CommunitiesActions](docs/CommunitiesActions.md)
 - [Community](docs/Community.md)
 - [CommunityActions](docs/CommunityActions.md)
 - [CommunityData](docs/CommunityData.md)
 - [CommunityDeleteActionResult](docs/CommunityDeleteActionResult.md)
 - [CommunityInvitesResult](docs/CommunityInvitesResult.md)
 - [CommunityJoinActionResult](docs/CommunityJoinActionResult.md)
 - [CommunityJoinRequestsResult](docs/CommunityJoinRequestsResult.md)
 - [CommunityLeaveActionResult](docs/CommunityLeaveActionResult.md)
 - [CommunityPinActionResult](docs/CommunityPinActionResult.md)
 - [CommunityRelationship](docs/CommunityRelationship.md)
 - [CommunityRule](docs/CommunityRule.md)
 - [CommunityUnpinActionResult](docs/CommunityUnpinActionResult.md)
 - [CommunityUrls](docs/CommunityUrls.md)
 - [CommunityUrlsPermalink](docs/CommunityUrlsPermalink.md)
 - [ContentEntryType](docs/ContentEntryType.md)
 - [ContentItemType](docs/ContentItemType.md)
 - [ContentUnion](docs/ContentUnion.md)
 - [ConversationControl](docs/ConversationControl.md)
 - [CoverCta](docs/CoverCta.md)
 - [CreateBookmarkResponse](docs/CreateBookmarkResponse.md)
 - [CreateBookmarkResponseData](docs/CreateBookmarkResponseData.md)
 - [CreateRetweet](docs/CreateRetweet.md)
 - [CreateRetweetResponse](docs/CreateRetweetResponse.md)
 - [CreateRetweetResponseData](docs/CreateRetweetResponseData.md)
 - [CreateRetweetResponseResult](docs/CreateRetweetResponseResult.md)
 - [CreateTweet](docs/CreateTweet.md)
 - [CreateTweetResponse](docs/CreateTweetResponse.md)
 - [CreateTweetResponseData](docs/CreateTweetResponseData.md)
 - [CreateTweetResponseResult](docs/CreateTweetResponseResult.md)
 - [CtaClientEventInfo](docs/CtaClientEventInfo.md)
 - [CursorType](docs/CursorType.md)
 - [DeleteBookmarkResponse](docs/DeleteBookmarkResponse.md)
 - [DeleteBookmarkResponseData](docs/DeleteBookmarkResponseData.md)
 - [DeleteRetweet](docs/DeleteRetweet.md)
 - [DeleteRetweetResponse](docs/DeleteRetweetResponse.md)
 - [DeleteRetweetResponseData](docs/DeleteRetweetResponseData.md)
 - [DeleteRetweetResponseResult](docs/DeleteRetweetResponseResult.md)
 - [DeleteTweetResponse](docs/DeleteTweetResponse.md)
 - [DeleteTweetResponseData](docs/DeleteTweetResponseData.md)
 - [DeleteTweetResponseResult](docs/DeleteTweetResponseResult.md)
 - [DisplayTreatment](docs/DisplayTreatment.md)
 - [DisplayType](docs/DisplayType.md)
 - [Entities](docs/Entities.md)
 - [ErrorExtensions](docs/ErrorExtensions.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ExtMediaAvailability](docs/ExtMediaAvailability.md)
 - [ExtendedEntities](docs/ExtendedEntities.md)
 - [FavoriteTweet](docs/FavoriteTweet.md)
 - [FavoriteTweetResponse](docs/FavoriteTweetResponse.md)
 - [FeedbackInfo](docs/FeedbackInfo.md)
 - [FollowResponse](docs/FollowResponse.md)
 - [FollowResponseData](docs/FollowResponseData.md)
 - [FollowResponseResult](docs/FollowResponseResult.md)
 - [FollowResponseUser](docs/FollowResponseUser.md)
 - [FollowTimeline](docs/FollowTimeline.md)
 - [Highlight](docs/Highlight.md)
 - [HomeTimelineHome](docs/HomeTimelineHome.md)
 - [HomeTimelineResponseData](docs/HomeTimelineResponseData.md)
 - [InstructionType](docs/InstructionType.md)
 - [InstructionUnion](docs/InstructionUnion.md)
 - [ItemContentUnion](docs/ItemContentUnion.md)
 - [ItemResult](docs/ItemResult.md)
 - [ListLatestTweetsTimelineResponse](docs/ListLatestTweetsTimelineResponse.md)
 - [ListTweetsTimeline](docs/ListTweetsTimeline.md)
 - [ListTweetsTimelineData](docs/ListTweetsTimelineData.md)
 - [ListTweetsTimelineList](docs/ListTweetsTimelineList.md)
 - [Location](docs/Location.md)
 - [Media](docs/Media.md)
 - [MediaExtended](docs/MediaExtended.md)
 - [MediaOriginalInfo](docs/MediaOriginalInfo.md)
 - [MediaOriginalInfoFocusRect](docs/MediaOriginalInfoFocusRect.md)
 - [MediaResult](docs/MediaResult.md)
 - [MediaResults](docs/MediaResults.md)
 - [MediaSize](docs/MediaSize.md)
 - [MediaSizes](docs/MediaSizes.md)
 - [MediaStats](docs/MediaStats.md)
 - [MediaVideoInfo](docs/MediaVideoInfo.md)
 - [MediaVideoInfoVariant](docs/MediaVideoInfoVariant.md)
 - [MediaVisibilityResults](docs/MediaVisibilityResults.md)
 - [MediaVisibilityResultsBlurredImageInterstitial](docs/MediaVisibilityResultsBlurredImageInterstitial.md)
 - [ModuleEntry](docs/ModuleEntry.md)
 - [ModuleItem](docs/ModuleItem.md)
 - [NoteTweet](docs/NoteTweet.md)
 - [NoteTweetResult](docs/NoteTweetResult.md)
 - [NoteTweetResultData](docs/NoteTweetResultData.md)
 - [NoteTweetResultMedia](docs/NoteTweetResultMedia.md)
 - [NoteTweetResultMediaInlineMedia](docs/NoteTweetResultMediaInlineMedia.md)
 - [NoteTweetResultRichText](docs/NoteTweetResultRichText.md)
 - [NoteTweetResultRichTextTag](docs/NoteTweetResultRichTextTag.md)
 - [OneFactorLoginEligibility](docs/OneFactorLoginEligibility.md)
 - [OtherObjectAll](docs/OtherObjectAll.md)
 - [PostCreateBookmarkRequest](docs/PostCreateBookmarkRequest.md)
 - [PostCreateBookmarkRequestVariables](docs/PostCreateBookmarkRequestVariables.md)
 - [PostCreateRetweetRequest](docs/PostCreateRetweetRequest.md)
 - [PostCreateRetweetRequestVariables](docs/PostCreateRetweetRequestVariables.md)
 - [PostCreateTweetRequest](docs/PostCreateTweetRequest.md)
 - [PostCreateTweetRequestFeatures](docs/PostCreateTweetRequestFeatures.md)
 - [PostCreateTweetRequestVariables](docs/PostCreateTweetRequestVariables.md)
 - [PostCreateTweetRequestVariablesConversationControl](docs/PostCreateTweetRequestVariablesConversationControl.md)
 - [PostCreateTweetRequestVariablesMedia](docs/PostCreateTweetRequestVariablesMedia.md)
 - [PostCreateTweetRequestVariablesMediaMediaEntitiesInner](docs/PostCreateTweetRequestVariablesMediaMediaEntitiesInner.md)
 - [PostCreateTweetRequestVariablesReply](docs/PostCreateTweetRequestVariablesReply.md)
 - [PostDeleteBookmarkRequest](docs/PostDeleteBookmarkRequest.md)
 - [PostDeleteRetweetRequest](docs/PostDeleteRetweetRequest.md)
 - [PostDeleteRetweetRequestVariables](docs/PostDeleteRetweetRequestVariables.md)
 - [PostDeleteTweetRequest](docs/PostDeleteTweetRequest.md)
 - [PostFavoriteTweetRequest](docs/PostFavoriteTweetRequest.md)
 - [PostUnfavoriteTweetRequest](docs/PostUnfavoriteTweetRequest.md)
 - [PrimaryCommunityTopic](docs/PrimaryCommunityTopic.md)
 - [ProfileResponse](docs/ProfileResponse.md)
 - [ProfileResponseData](docs/ProfileResponseData.md)
 - [QuotedRefResult](docs/QuotedRefResult.md)
 - [QuotedStatusPermalink](docs/QuotedStatusPermalink.md)
 - [Retweet](docs/Retweet.md)
 - [RetweetLegacy](docs/RetweetLegacy.md)
 - [SearchByRawQuery](docs/SearchByRawQuery.md)
 - [SearchTimeline](docs/SearchTimeline.md)
 - [SearchTimelineData](docs/SearchTimelineData.md)
 - [SearchTimelineResponse](docs/SearchTimelineResponse.md)
 - [SelfThread](docs/SelfThread.md)
 - [SensitiveMediaWarning](docs/SensitiveMediaWarning.md)
 - [Session](docs/Session.md)
 - [SocialContextLandingUrl](docs/SocialContextLandingUrl.md)
 - [SocialContextUnion](docs/SocialContextUnion.md)
 - [SocialContextUnionType](docs/SocialContextUnionType.md)
 - [SuperFollowsReplyUserResult](docs/SuperFollowsReplyUserResult.md)
 - [SuperFollowsReplyUserResultData](docs/SuperFollowsReplyUserResultData.md)
 - [SuperFollowsReplyUserResultLegacy](docs/SuperFollowsReplyUserResultLegacy.md)
 - [Text](docs/Text.md)
 - [TextEntity](docs/TextEntity.md)
 - [TextEntityRef](docs/TextEntityRef.md)
 - [TextHighlight](docs/TextHighlight.md)
 - [Timeline](docs/Timeline.md)
 - [TimelineAddEntries](docs/TimelineAddEntries.md)
 - [TimelineAddEntry](docs/TimelineAddEntry.md)
 - [TimelineAddToModule](docs/TimelineAddToModule.md)
 - [TimelineClearCache](docs/TimelineClearCache.md)
 - [TimelineCommunity](docs/TimelineCommunity.md)
 - [TimelineCoverBehavior](docs/TimelineCoverBehavior.md)
 - [TimelineCoverBehaviorUrl](docs/TimelineCoverBehaviorUrl.md)
 - [TimelineGeneralContext](docs/TimelineGeneralContext.md)
 - [TimelineHalfCover](docs/TimelineHalfCover.md)
 - [TimelineMessagePrompt](docs/TimelineMessagePrompt.md)
 - [TimelinePinEntry](docs/TimelinePinEntry.md)
 - [TimelinePrompt](docs/TimelinePrompt.md)
 - [TimelineReplaceEntry](docs/TimelineReplaceEntry.md)
 - [TimelineResponse](docs/TimelineResponse.md)
 - [TimelineShowAlert](docs/TimelineShowAlert.md)
 - [TimelineShowAlertRichText](docs/TimelineShowAlertRichText.md)
 - [TimelineShowCover](docs/TimelineShowCover.md)
 - [TimelineTerminateTimeline](docs/TimelineTerminateTimeline.md)
 - [TimelineTimelineCursor](docs/TimelineTimelineCursor.md)
 - [TimelineTimelineItem](docs/TimelineTimelineItem.md)
 - [TimelineTimelineModule](docs/TimelineTimelineModule.md)
 - [TimelineTopicContext](docs/TimelineTopicContext.md)
 - [TimelineTweet](docs/TimelineTweet.md)
 - [TimelineUser](docs/TimelineUser.md)
 - [TimelineV2](docs/TimelineV2.md)
 - [Timestamp](docs/Timestamp.md)
 - [TopicContext](docs/TopicContext.md)
 - [Tracing](docs/Tracing.md)
 - [Tweet](docs/Tweet.md)
 - [TweetCard](docs/TweetCard.md)
 - [TweetCardLegacy](docs/TweetCardLegacy.md)
 - [TweetCardLegacyBindingValue](docs/TweetCardLegacyBindingValue.md)
 - [TweetCardLegacyBindingValueData](docs/TweetCardLegacyBindingValueData.md)
 - [TweetCardLegacyBindingValueDataImage](docs/TweetCardLegacyBindingValueDataImage.md)
 - [TweetCardPlatform](docs/TweetCardPlatform.md)
 - [TweetCardPlatformAudience](docs/TweetCardPlatformAudience.md)
 - [TweetCardPlatformData](docs/TweetCardPlatformData.md)
 - [TweetCardPlatformDevice](docs/TweetCardPlatformDevice.md)
 - [TweetDetailResponse](docs/TweetDetailResponse.md)
 - [TweetDetailResponseData](docs/TweetDetailResponseData.md)
 - [TweetEditControl](docs/TweetEditControl.md)
 - [TweetEditControlInitial](docs/TweetEditControlInitial.md)
 - [TweetEditPrespective](docs/TweetEditPrespective.md)
 - [TweetFavoritersResponse](docs/TweetFavoritersResponse.md)
 - [TweetFavoritersResponseData](docs/TweetFavoritersResponseData.md)
 - [TweetInterstitial](docs/TweetInterstitial.md)
 - [TweetInterstitialRevealText](docs/TweetInterstitialRevealText.md)
 - [TweetInterstitialText](docs/TweetInterstitialText.md)
 - [TweetInterstitialTextEntity](docs/TweetInterstitialTextEntity.md)
 - [TweetInterstitialTextEntityRef](docs/TweetInterstitialTextEntityRef.md)
 - [TweetLegacy](docs/TweetLegacy.md)
 - [TweetLegacyScopes](docs/TweetLegacyScopes.md)
 - [TweetPreviousCounts](docs/TweetPreviousCounts.md)
 - [TweetResultByRestIdData](docs/TweetResultByRestIdData.md)
 - [TweetResultByRestIdResponse](docs/TweetResultByRestIdResponse.md)
 - [TweetRetweetersResponse](docs/TweetRetweetersResponse.md)
 - [TweetRetweetersResponseData](docs/TweetRetweetersResponseData.md)
 - [TweetTombstone](docs/TweetTombstone.md)
 - [TweetUnavailable](docs/TweetUnavailable.md)
 - [TweetUnion](docs/TweetUnion.md)
 - [TweetView](docs/TweetView.md)
 - [TweetWithVisibilityResults](docs/TweetWithVisibilityResults.md)
 - [TypeName](docs/TypeName.md)
 - [UnfavoriteTweet](docs/UnfavoriteTweet.md)
 - [UnfavoriteTweetResponse](docs/UnfavoriteTweetResponse.md)
 - [UnifiedCard](docs/UnifiedCard.md)
 - [Url](docs/Url.md)
 - [UrtEndpointOptions](docs/UrtEndpointOptions.md)
 - [UrtEndpointRequestParams](docs/UrtEndpointRequestParams.md)
 - [User](docs/User.md)
 - [UserFeatures](docs/UserFeatures.md)
 - [UserHighlightsInfo](docs/UserHighlightsInfo.md)
 - [UserHighlightsTweetsData](docs/UserHighlightsTweetsData.md)
 - [UserHighlightsTweetsResponse](docs/UserHighlightsTweetsResponse.md)
 - [UserHighlightsTweetsResult](docs/UserHighlightsTweetsResult.md)
 - [UserHighlightsTweetsTimeline](docs/UserHighlightsTweetsTimeline.md)
 - [UserHighlightsTweetsUser](docs/UserHighlightsTweetsUser.md)
 - [UserLegacy](docs/UserLegacy.md)
 - [UserLegacyExtendedProfile](docs/UserLegacyExtendedProfile.md)
 - [UserLegacyExtendedProfileBirthdate](docs/UserLegacyExtendedProfileBirthdate.md)
 - [UserProfessional](docs/UserProfessional.md)
 - [UserProfessionalCategory](docs/UserProfessionalCategory.md)
 - [UserResponse](docs/UserResponse.md)
 - [UserResponseData](docs/UserResponseData.md)
 - [UserResultByScreenName](docs/UserResultByScreenName.md)
 - [UserResultByScreenNameLegacy](docs/UserResultByScreenNameLegacy.md)
 - [UserResultByScreenNameResult](docs/UserResultByScreenNameResult.md)
 - [UserResultCore](docs/UserResultCore.md)
 - [UserResults](docs/UserResults.md)
 - [UserTipJarSettings](docs/UserTipJarSettings.md)
 - [UserTweetsData](docs/UserTweetsData.md)
 - [UserTweetsResponse](docs/UserTweetsResponse.md)
 - [UserTweetsResult](docs/UserTweetsResult.md)
 - [UserTweetsUser](docs/UserTweetsUser.md)
 - [UserUnavailable](docs/UserUnavailable.md)
 - [UserUnion](docs/UserUnion.md)
 - [UserValue](docs/UserValue.md)
 - [UserVerificationInfo](docs/UserVerificationInfo.md)
 - [UserVerificationInfoReason](docs/UserVerificationInfoReason.md)
 - [UserVerificationInfoReasonDescription](docs/UserVerificationInfoReasonDescription.md)
 - [UserVerificationInfoReasonDescriptionEntities](docs/UserVerificationInfoReasonDescriptionEntities.md)
 - [UserVerificationInfoReasonDescriptionEntitiesRef](docs/UserVerificationInfoReasonDescriptionEntitiesRef.md)
 - [UsersResponse](docs/UsersResponse.md)
 - [UsersResponseData](docs/UsersResponseData.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Accept"></a>
### Accept

- **Type**: API key
- **API key parameter name**: Accept
- **Location**: HTTP header

<a id="AcceptEncoding"></a>
### AcceptEncoding

- **Type**: API key
- **API key parameter name**: Accept-Encoding
- **Location**: HTTP header

<a id="AcceptLanguage"></a>
### AcceptLanguage

- **Type**: API key
- **API key parameter name**: Accept-Language
- **Location**: HTTP header

<a id="ActiveUser"></a>
### ActiveUser

- **Type**: API key
- **API key parameter name**: x-twitter-active-user
- **Location**: HTTP header

<a id="AuthType"></a>
### AuthType

- **Type**: API key
- **API key parameter name**: x-twitter-auth-type
- **Location**: HTTP header

<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication

<a id="ClientLanguage"></a>
### ClientLanguage

- **Type**: API key
- **API key parameter name**: x-twitter-client-language
- **Location**: HTTP header

<a id="ClientTransactionId"></a>
### ClientTransactionId

- **Type**: API key
- **API key parameter name**: x-client-transaction-id
- **Location**: HTTP header

<a id="ClientUuid"></a>
### ClientUuid

- **Type**: API key
- **API key parameter name**: x-client-uuid
- **Location**: HTTP header

<a id="CookieAuthToken"></a>
### CookieAuthToken

- **Type**: API key
- **API key parameter name**: auth_token
- **Location**: 

<a id="CookieCt0"></a>
### CookieCt0

- **Type**: API key
- **API key parameter name**: ct0
- **Location**: 

<a id="CookieGt0"></a>
### CookieGt0

- **Type**: API key
- **API key parameter name**: gt0
- **Location**: 

<a id="CsrfToken"></a>
### CsrfToken

- **Type**: API key
- **API key parameter name**: x-csrf-token
- **Location**: HTTP header

<a id="GuestToken"></a>
### GuestToken

- **Type**: API key
- **API key parameter name**: x-guest-token
- **Location**: HTTP header

<a id="Priority"></a>
### Priority

- **Type**: API key
- **API key parameter name**: Priority
- **Location**: HTTP header

<a id="Referer"></a>
### Referer

- **Type**: API key
- **API key parameter name**: Referer
- **Location**: HTTP header

<a id="SecChUa"></a>
### SecChUa

- **Type**: API key
- **API key parameter name**: Sec-Ch-Ua
- **Location**: HTTP header

<a id="SecChUaMobile"></a>
### SecChUaMobile

- **Type**: API key
- **API key parameter name**: Sec-Ch-Ua-Mobile
- **Location**: HTTP header

<a id="SecChUaPlatform"></a>
### SecChUaPlatform

- **Type**: API key
- **API key parameter name**: Sec-Ch-Ua-Platform
- **Location**: HTTP header

<a id="SecFetchDest"></a>
### SecFetchDest

- **Type**: API key
- **API key parameter name**: Sec-Fetch-Dest
- **Location**: HTTP header

<a id="SecFetchMode"></a>
### SecFetchMode

- **Type**: API key
- **API key parameter name**: Sec-Fetch-Mode
- **Location**: HTTP header

<a id="SecFetchSite"></a>
### SecFetchSite

- **Type**: API key
- **API key parameter name**: Sec-Fetch-Site
- **Location**: HTTP header

<a id="UserAgent"></a>
### UserAgent

- **Type**: API key
- **API key parameter name**: user-agent
- **Location**: HTTP header


## Author

yuki@yuki0311.com


