# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from twitter_openapi_python_generated.models.post_create_tweet_request_variables_conversation_control import PostCreateTweetRequestVariablesConversationControl
from twitter_openapi_python_generated.models.post_create_tweet_request_variables_media import PostCreateTweetRequestVariablesMedia
from twitter_openapi_python_generated.models.post_create_tweet_request_variables_reply import PostCreateTweetRequestVariablesReply
from typing import Optional, Set
from typing_extensions import Self

class PostCreateTweetRequestVariables(BaseModel):
    """
    PostCreateTweetRequestVariables
    """ # noqa: E501
    attachment_url: Optional[StrictStr] = 'https://x.com/elonmusk/status/1349129669258448897'
    conversation_control: Optional[PostCreateTweetRequestVariablesConversationControl] = None
    dark_request: StrictBool
    disallowed_reply_options: Optional[Dict[str, Any]] = None
    media: PostCreateTweetRequestVariablesMedia
    reply: Optional[PostCreateTweetRequestVariablesReply] = None
    semantic_annotation_ids: List[Dict[str, Any]]
    tweet_text: StrictStr
    __properties: ClassVar[List[str]] = ["attachment_url", "conversation_control", "dark_request", "disallowed_reply_options", "media", "reply", "semantic_annotation_ids", "tweet_text"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostCreateTweetRequestVariables from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of conversation_control
        if self.conversation_control:
            _dict['conversation_control'] = self.conversation_control.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media
        if self.media:
            _dict['media'] = self.media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reply
        if self.reply:
            _dict['reply'] = self.reply.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostCreateTweetRequestVariables from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "attachment_url": obj.get("attachment_url") if obj.get("attachment_url") is not None else 'https://x.com/elonmusk/status/1349129669258448897',
            "conversation_control": PostCreateTweetRequestVariablesConversationControl.from_dict(obj["conversation_control"]) if obj.get("conversation_control") is not None else None,
            "dark_request": obj.get("dark_request") if obj.get("dark_request") is not None else False,
            "disallowed_reply_options": obj.get("disallowed_reply_options"),
            "media": PostCreateTweetRequestVariablesMedia.from_dict(obj["media"]) if obj.get("media") is not None else None,
            "reply": PostCreateTweetRequestVariablesReply.from_dict(obj["reply"]) if obj.get("reply") is not None else None,
            "semantic_annotation_ids": obj.get("semantic_annotation_ids"),
            "tweet_text": obj.get("tweet_text") if obj.get("tweet_text") is not None else 'test'
        })
        return _obj


