# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist, validator
from twitter_openapi_python_generated.models.callback import Callback
from twitter_openapi_python_generated.models.cover_cta import CoverCta
from twitter_openapi_python_generated.models.text import Text

class TimelineHalfCover(BaseModel):
    """
    TimelineHalfCover
    """
    dismissible: StrictBool = Field(...)
    half_cover_display_type: StrictStr = Field(..., alias="halfCoverDisplayType")
    impression_callbacks: conlist(Callback) = Field(..., alias="impressionCallbacks")
    primary_cover_cta: CoverCta = Field(..., alias="primaryCoverCta")
    primary_text: Text = Field(..., alias="primaryText")
    secondary_text: Text = Field(..., alias="secondaryText")
    type: StrictStr = Field(...)
    __properties = ["dismissible", "halfCoverDisplayType", "impressionCallbacks", "primaryCoverCta", "primaryText", "secondaryText", "type"]

    @validator('half_cover_display_type')
    def half_cover_display_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Cover'):
            raise ValueError("must be one of enum values ('Cover')")
        return value

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('TimelineHalfCover'):
            raise ValueError("must be one of enum values ('TimelineHalfCover')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimelineHalfCover:
        """Create an instance of TimelineHalfCover from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in impression_callbacks (list)
        _items = []
        if self.impression_callbacks:
            for _item in self.impression_callbacks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['impressionCallbacks'] = _items
        # override the default output from pydantic by calling `to_dict()` of primary_cover_cta
        if self.primary_cover_cta:
            _dict['primaryCoverCta'] = self.primary_cover_cta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of primary_text
        if self.primary_text:
            _dict['primaryText'] = self.primary_text.to_dict()
        # override the default output from pydantic by calling `to_dict()` of secondary_text
        if self.secondary_text:
            _dict['secondaryText'] = self.secondary_text.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimelineHalfCover:
        """Create an instance of TimelineHalfCover from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimelineHalfCover.parse_obj(obj)

        _obj = TimelineHalfCover.parse_obj({
            "dismissible": obj.get("dismissible"),
            "half_cover_display_type": obj.get("halfCoverDisplayType"),
            "impression_callbacks": [Callback.from_dict(_item) for _item in obj.get("impressionCallbacks")] if obj.get("impressionCallbacks") is not None else None,
            "primary_cover_cta": CoverCta.from_dict(obj.get("primaryCoverCta")) if obj.get("primaryCoverCta") is not None else None,
            "primary_text": Text.from_dict(obj.get("primaryText")) if obj.get("primaryText") is not None else None,
            "secondary_text": Text.from_dict(obj.get("secondaryText")) if obj.get("secondaryText") is not None else None,
            "type": obj.get("type")
        })
        return _obj


