# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from twitter_openapi_python_generated.models.content_item_type import ContentItemType
from twitter_openapi_python_generated.models.social_context_landing_url import SocialContextLandingUrl
from twitter_openapi_python_generated.models.social_context_union import SocialContextUnion
from twitter_openapi_python_generated.models.thumbnail_image import ThumbnailImage
from twitter_openapi_python_generated.models.trend_image import TrendImage
from twitter_openapi_python_generated.models.trend_metadata import TrendMetadata
from twitter_openapi_python_generated.models.type_name import TypeName
from typing import Optional, Set
from typing_extensions import Self

class TimelineTrend(BaseModel):
    """
    TimelineTrend
    """ # noqa: E501
    typename: TypeName = Field(alias="__typename")
    images: List[TrendImage]
    is_ai_trend: Optional[StrictBool] = None
    item_type: ContentItemType = Field(alias="itemType")
    name: StrictStr
    social_context: Optional[SocialContextUnion] = None
    thumbnail_image: ThumbnailImage
    trend_metadata: TrendMetadata
    trend_url: SocialContextLandingUrl
    __properties: ClassVar[List[str]] = ["__typename", "images", "is_ai_trend", "itemType", "name", "social_context", "thumbnail_image", "trend_metadata", "trend_url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimelineTrend from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item_images in self.images:
                if _item_images:
                    _items.append(_item_images.to_dict())
            _dict['images'] = _items
        # override the default output from pydantic by calling `to_dict()` of social_context
        if self.social_context:
            _dict['social_context'] = self.social_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of thumbnail_image
        if self.thumbnail_image:
            _dict['thumbnail_image'] = self.thumbnail_image.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trend_metadata
        if self.trend_metadata:
            _dict['trend_metadata'] = self.trend_metadata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trend_url
        if self.trend_url:
            _dict['trend_url'] = self.trend_url.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimelineTrend from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "__typename": obj.get("__typename"),
            "images": [TrendImage.from_dict(_item) for _item in obj["images"]] if obj.get("images") is not None else None,
            "is_ai_trend": obj.get("is_ai_trend"),
            "itemType": obj.get("itemType"),
            "name": obj.get("name"),
            "social_context": SocialContextUnion.from_dict(obj["social_context"]) if obj.get("social_context") is not None else None,
            "thumbnail_image": ThumbnailImage.from_dict(obj["thumbnail_image"]) if obj.get("thumbnail_image") is not None else None,
            "trend_metadata": TrendMetadata.from_dict(obj["trend_metadata"]) if obj.get("trend_metadata") is not None else None,
            "trend_url": SocialContextLandingUrl.from_dict(obj["trend_url"]) if obj.get("trend_url") is not None else None
        })
        return _obj


