# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List
from twitter_openapi_python_generated.models.tweet_limited_action_results import TweetLimitedActionResults
from twitter_openapi_python_generated.models.tweet_preview_display_cta import TweetPreviewDisplayCta
from twitter_openapi_python_generated.models.tweet_preview_display_tweet import TweetPreviewDisplayTweet
from twitter_openapi_python_generated.models.type_name import TypeName
from typing import Optional, Set
from typing_extensions import Self

class TweetPreviewDisplay(BaseModel):
    """
    TweetPreviewDisplay
    """ # noqa: E501
    typename: TypeName = Field(alias="__typename")
    cta: TweetPreviewDisplayCta
    limited_action_results: TweetLimitedActionResults
    tweet: TweetPreviewDisplayTweet
    __properties: ClassVar[List[str]] = ["__typename", "cta", "limited_action_results", "tweet"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TweetPreviewDisplay from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of cta
        if self.cta:
            _dict['cta'] = self.cta.to_dict()
        # override the default output from pydantic by calling `to_dict()` of limited_action_results
        if self.limited_action_results:
            _dict['limited_action_results'] = self.limited_action_results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tweet
        if self.tweet:
            _dict['tweet'] = self.tweet.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TweetPreviewDisplay from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "__typename": obj.get("__typename"),
            "cta": TweetPreviewDisplayCta.from_dict(obj["cta"]) if obj.get("cta") is not None else None,
            "limited_action_results": TweetLimitedActionResults.from_dict(obj["limited_action_results"]) if obj.get("limited_action_results") is not None else None,
            "tweet": TweetPreviewDisplayTweet.from_dict(obj["tweet"]) if obj.get("tweet") is not None else None
        })
        return _obj


