# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from twitter_openapi_python_generated.models.content_item_type import ContentItemType
from twitter_openapi_python_generated.models.notification_template import NotificationTemplate
from twitter_openapi_python_generated.models.rich_message import RichMessage
from twitter_openapi_python_generated.models.social_context_landing_url import SocialContextLandingUrl
from twitter_openapi_python_generated.models.type_name import TypeName
from typing import Optional, Set
from typing_extensions import Self

class TimelineNotification(BaseModel):
    """
    TimelineNotification
    """ # noqa: E501
    typename: TypeName = Field(alias="__typename")
    id: StrictStr
    item_type: ContentItemType = Field(alias="itemType")
    notification_icon: StrictStr
    notification_url: SocialContextLandingUrl
    rich_message: RichMessage
    template: NotificationTemplate
    timestamp_ms: StrictStr
    __properties: ClassVar[List[str]] = ["__typename", "id", "itemType", "notification_icon", "notification_url", "rich_message", "template", "timestamp_ms"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TimelineNotification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of notification_url
        if self.notification_url:
            _dict['notification_url'] = self.notification_url.to_dict()
        # override the default output from pydantic by calling `to_dict()` of rich_message
        if self.rich_message:
            _dict['rich_message'] = self.rich_message.to_dict()
        # override the default output from pydantic by calling `to_dict()` of template
        if self.template:
            _dict['template'] = self.template.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TimelineNotification from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "__typename": obj.get("__typename"),
            "id": obj.get("id"),
            "itemType": obj.get("itemType"),
            "notification_icon": obj.get("notification_icon"),
            "notification_url": SocialContextLandingUrl.from_dict(obj["notification_url"]) if obj.get("notification_url") is not None else None,
            "rich_message": RichMessage.from_dict(obj["rich_message"]) if obj.get("rich_message") is not None else None,
            "template": NotificationTemplate.from_dict(obj["template"]) if obj.get("template") is not None else None,
            "timestamp_ms": obj.get("timestamp_ms")
        })
        return _obj


