# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from twitter_openapi_python_generated.models.additional_media_info import AdditionalMediaInfo
from twitter_openapi_python_generated.models.allow_download_status import AllowDownloadStatus
from twitter_openapi_python_generated.models.ext_media_availability import ExtMediaAvailability
from twitter_openapi_python_generated.models.media_original_info import MediaOriginalInfo
from twitter_openapi_python_generated.models.media_results import MediaResults
from twitter_openapi_python_generated.models.media_sizes import MediaSizes
from twitter_openapi_python_generated.models.media_stats import MediaStats
from twitter_openapi_python_generated.models.media_video_info import MediaVideoInfo
from twitter_openapi_python_generated.models.sensitive_media_warning import SensitiveMediaWarning
from typing import Optional, Set
from typing_extensions import Self

class MediaExtended(BaseModel):
    """
    MediaExtended
    """ # noqa: E501
    additional_media_info: Optional[AdditionalMediaInfo] = None
    allow_download_status: Optional[AllowDownloadStatus] = None
    display_url: StrictStr
    expanded_url: StrictStr
    ext_alt_text: Optional[StrictStr] = None
    ext_media_availability: Optional[ExtMediaAvailability] = None
    features: Optional[Dict[str, Any]] = None
    id_str: Annotated[str, Field(strict=True)]
    indices: List[StrictInt]
    media_stats: Optional[MediaStats] = Field(default=None, alias="mediaStats")
    media_key: StrictStr
    media_results: Optional[MediaResults] = None
    media_url_https: StrictStr
    original_info: MediaOriginalInfo
    sensitive_media_warning: Optional[SensitiveMediaWarning] = None
    sizes: MediaSizes
    source_status_id_str: Optional[Annotated[str, Field(strict=True)]] = None
    source_user_id_str: Optional[Annotated[str, Field(strict=True)]] = None
    type: StrictStr
    url: StrictStr
    video_info: Optional[MediaVideoInfo] = None
    __properties: ClassVar[List[str]] = ["additional_media_info", "allow_download_status", "display_url", "expanded_url", "ext_alt_text", "ext_media_availability", "features", "id_str", "indices", "mediaStats", "media_key", "media_results", "media_url_https", "original_info", "sensitive_media_warning", "sizes", "source_status_id_str", "source_user_id_str", "type", "url", "video_info"]

    @field_validator('id_str')
    def id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('source_status_id_str')
    def source_status_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('source_user_id_str')
    def source_user_id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['photo', 'video', 'animated_gif']):
            raise ValueError("must be one of enum values ('photo', 'video', 'animated_gif')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MediaExtended from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of additional_media_info
        if self.additional_media_info:
            _dict['additional_media_info'] = self.additional_media_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of allow_download_status
        if self.allow_download_status:
            _dict['allow_download_status'] = self.allow_download_status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ext_media_availability
        if self.ext_media_availability:
            _dict['ext_media_availability'] = self.ext_media_availability.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media_stats
        if self.media_stats:
            _dict['mediaStats'] = self.media_stats.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media_results
        if self.media_results:
            _dict['media_results'] = self.media_results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of original_info
        if self.original_info:
            _dict['original_info'] = self.original_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sensitive_media_warning
        if self.sensitive_media_warning:
            _dict['sensitive_media_warning'] = self.sensitive_media_warning.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sizes
        if self.sizes:
            _dict['sizes'] = self.sizes.to_dict()
        # override the default output from pydantic by calling `to_dict()` of video_info
        if self.video_info:
            _dict['video_info'] = self.video_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MediaExtended from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "additional_media_info": AdditionalMediaInfo.from_dict(obj["additional_media_info"]) if obj.get("additional_media_info") is not None else None,
            "allow_download_status": AllowDownloadStatus.from_dict(obj["allow_download_status"]) if obj.get("allow_download_status") is not None else None,
            "display_url": obj.get("display_url"),
            "expanded_url": obj.get("expanded_url"),
            "ext_alt_text": obj.get("ext_alt_text"),
            "ext_media_availability": ExtMediaAvailability.from_dict(obj["ext_media_availability"]) if obj.get("ext_media_availability") is not None else None,
            "features": obj.get("features"),
            "id_str": obj.get("id_str"),
            "indices": obj.get("indices"),
            "mediaStats": MediaStats.from_dict(obj["mediaStats"]) if obj.get("mediaStats") is not None else None,
            "media_key": obj.get("media_key"),
            "media_results": MediaResults.from_dict(obj["media_results"]) if obj.get("media_results") is not None else None,
            "media_url_https": obj.get("media_url_https"),
            "original_info": MediaOriginalInfo.from_dict(obj["original_info"]) if obj.get("original_info") is not None else None,
            "sensitive_media_warning": SensitiveMediaWarning.from_dict(obj["sensitive_media_warning"]) if obj.get("sensitive_media_warning") is not None else None,
            "sizes": MediaSizes.from_dict(obj["sizes"]) if obj.get("sizes") is not None else None,
            "source_status_id_str": obj.get("source_status_id_str"),
            "source_user_id_str": obj.get("source_user_id_str"),
            "type": obj.get("type"),
            "url": obj.get("url"),
            "video_info": MediaVideoInfo.from_dict(obj["video_info"]) if obj.get("video_info") is not None else None
        })
        return _obj


