# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from twitter_openapi_python_generated.models.article import Article
from twitter_openapi_python_generated.models.author_community_relationship import AuthorCommunityRelationship
from twitter_openapi_python_generated.models.birdwatch_pivot import BirdwatchPivot
from twitter_openapi_python_generated.models.community import Community
from twitter_openapi_python_generated.models.community_relationship import CommunityRelationship
from twitter_openapi_python_generated.models.note_tweet import NoteTweet
from twitter_openapi_python_generated.models.super_follows_reply_user_result import SuperFollowsReplyUserResult
from twitter_openapi_python_generated.models.trend_results import TrendResults
from twitter_openapi_python_generated.models.tweet_card import TweetCard
from twitter_openapi_python_generated.models.tweet_edit_control import TweetEditControl
from twitter_openapi_python_generated.models.tweet_edit_prespective import TweetEditPrespective
from twitter_openapi_python_generated.models.tweet_previous_counts import TweetPreviousCounts
from twitter_openapi_python_generated.models.tweet_view import TweetView
from twitter_openapi_python_generated.models.type_name import TypeName
from twitter_openapi_python_generated.models.unified_card import UnifiedCard
from twitter_openapi_python_generated.models.user_result_core import UserResultCore
from typing import Optional, Set
from typing_extensions import Self

class Tweet(BaseModel):
    """
    Tweet
    """ # noqa: E501
    typename: Optional[TypeName] = Field(default=None, alias="__typename")
    article: Optional[Article] = None
    author_community_relationship: Optional[AuthorCommunityRelationship] = None
    birdwatch_pivot: Optional[BirdwatchPivot] = None
    card: Optional[TweetCard] = None
    community_relationship: Optional[CommunityRelationship] = None
    community_results: Optional[Community] = None
    core: Optional[UserResultCore] = None
    edit_control: Optional[TweetEditControl] = None
    edit_prespective: Optional[TweetEditPrespective] = None
    grok_analysis_button: Optional[StrictBool] = None
    grok_analysis_followups: Optional[List[StrictStr]] = None
    grok_share_attachment: Optional[GrokShareAttachment] = None
    has_birdwatch_notes: Optional[StrictBool] = None
    is_translatable: Optional[StrictBool] = None
    legacy: Optional[TweetLegacy] = None
    note_tweet: Optional[NoteTweet] = None
    previous_counts: Optional[TweetPreviousCounts] = None
    quick_promote_eligibility: Optional[Dict[str, Any]] = None
    quoted_ref_result: Optional[QuotedRefResult] = Field(default=None, alias="quotedRefResult")
    quoted_status_result: Optional[ItemResult] = None
    rest_id: Annotated[str, Field(strict=True)]
    source: Optional[StrictStr] = None
    super_follows_reply_user_result: Optional[SuperFollowsReplyUserResult] = Field(default=None, alias="superFollowsReplyUserResult")
    trend_results: Optional[TrendResults] = None
    unified_card: Optional[UnifiedCard] = None
    unmention_data: Optional[Dict[str, Any]] = None
    views: Optional[TweetView] = None
    __properties: ClassVar[List[str]] = ["__typename", "article", "author_community_relationship", "birdwatch_pivot", "card", "community_relationship", "community_results", "core", "edit_control", "edit_prespective", "grok_analysis_button", "grok_analysis_followups", "grok_share_attachment", "has_birdwatch_notes", "is_translatable", "legacy", "note_tweet", "previous_counts", "quick_promote_eligibility", "quotedRefResult", "quoted_status_result", "rest_id", "source", "superFollowsReplyUserResult", "trend_results", "unified_card", "unmention_data", "views"]

    @field_validator('rest_id')
    def rest_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Tweet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of article
        if self.article:
            _dict['article'] = self.article.to_dict()
        # override the default output from pydantic by calling `to_dict()` of author_community_relationship
        if self.author_community_relationship:
            _dict['author_community_relationship'] = self.author_community_relationship.to_dict()
        # override the default output from pydantic by calling `to_dict()` of birdwatch_pivot
        if self.birdwatch_pivot:
            _dict['birdwatch_pivot'] = self.birdwatch_pivot.to_dict()
        # override the default output from pydantic by calling `to_dict()` of card
        if self.card:
            _dict['card'] = self.card.to_dict()
        # override the default output from pydantic by calling `to_dict()` of community_relationship
        if self.community_relationship:
            _dict['community_relationship'] = self.community_relationship.to_dict()
        # override the default output from pydantic by calling `to_dict()` of community_results
        if self.community_results:
            _dict['community_results'] = self.community_results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of core
        if self.core:
            _dict['core'] = self.core.to_dict()
        # override the default output from pydantic by calling `to_dict()` of edit_control
        if self.edit_control:
            _dict['edit_control'] = self.edit_control.to_dict()
        # override the default output from pydantic by calling `to_dict()` of edit_prespective
        if self.edit_prespective:
            _dict['edit_prespective'] = self.edit_prespective.to_dict()
        # override the default output from pydantic by calling `to_dict()` of grok_share_attachment
        if self.grok_share_attachment:
            _dict['grok_share_attachment'] = self.grok_share_attachment.to_dict()
        # override the default output from pydantic by calling `to_dict()` of legacy
        if self.legacy:
            _dict['legacy'] = self.legacy.to_dict()
        # override the default output from pydantic by calling `to_dict()` of note_tweet
        if self.note_tweet:
            _dict['note_tweet'] = self.note_tweet.to_dict()
        # override the default output from pydantic by calling `to_dict()` of previous_counts
        if self.previous_counts:
            _dict['previous_counts'] = self.previous_counts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quoted_ref_result
        if self.quoted_ref_result:
            _dict['quotedRefResult'] = self.quoted_ref_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of quoted_status_result
        if self.quoted_status_result:
            _dict['quoted_status_result'] = self.quoted_status_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of super_follows_reply_user_result
        if self.super_follows_reply_user_result:
            _dict['superFollowsReplyUserResult'] = self.super_follows_reply_user_result.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trend_results
        if self.trend_results:
            _dict['trend_results'] = self.trend_results.to_dict()
        # override the default output from pydantic by calling `to_dict()` of unified_card
        if self.unified_card:
            _dict['unified_card'] = self.unified_card.to_dict()
        # override the default output from pydantic by calling `to_dict()` of views
        if self.views:
            _dict['views'] = self.views.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Tweet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "__typename": obj.get("__typename"),
            "article": Article.from_dict(obj["article"]) if obj.get("article") is not None else None,
            "author_community_relationship": AuthorCommunityRelationship.from_dict(obj["author_community_relationship"]) if obj.get("author_community_relationship") is not None else None,
            "birdwatch_pivot": BirdwatchPivot.from_dict(obj["birdwatch_pivot"]) if obj.get("birdwatch_pivot") is not None else None,
            "card": TweetCard.from_dict(obj["card"]) if obj.get("card") is not None else None,
            "community_relationship": CommunityRelationship.from_dict(obj["community_relationship"]) if obj.get("community_relationship") is not None else None,
            "community_results": Community.from_dict(obj["community_results"]) if obj.get("community_results") is not None else None,
            "core": UserResultCore.from_dict(obj["core"]) if obj.get("core") is not None else None,
            "edit_control": TweetEditControl.from_dict(obj["edit_control"]) if obj.get("edit_control") is not None else None,
            "edit_prespective": TweetEditPrespective.from_dict(obj["edit_prespective"]) if obj.get("edit_prespective") is not None else None,
            "grok_analysis_button": obj.get("grok_analysis_button"),
            "grok_analysis_followups": obj.get("grok_analysis_followups"),
            "grok_share_attachment": GrokShareAttachment.from_dict(obj["grok_share_attachment"]) if obj.get("grok_share_attachment") is not None else None,
            "has_birdwatch_notes": obj.get("has_birdwatch_notes"),
            "is_translatable": obj.get("is_translatable"),
            "legacy": TweetLegacy.from_dict(obj["legacy"]) if obj.get("legacy") is not None else None,
            "note_tweet": NoteTweet.from_dict(obj["note_tweet"]) if obj.get("note_tweet") is not None else None,
            "previous_counts": TweetPreviousCounts.from_dict(obj["previous_counts"]) if obj.get("previous_counts") is not None else None,
            "quick_promote_eligibility": obj.get("quick_promote_eligibility"),
            "quotedRefResult": QuotedRefResult.from_dict(obj["quotedRefResult"]) if obj.get("quotedRefResult") is not None else None,
            "quoted_status_result": ItemResult.from_dict(obj["quoted_status_result"]) if obj.get("quoted_status_result") is not None else None,
            "rest_id": obj.get("rest_id"),
            "source": obj.get("source"),
            "superFollowsReplyUserResult": SuperFollowsReplyUserResult.from_dict(obj["superFollowsReplyUserResult"]) if obj.get("superFollowsReplyUserResult") is not None else None,
            "trend_results": TrendResults.from_dict(obj["trend_results"]) if obj.get("trend_results") is not None else None,
            "unified_card": UnifiedCard.from_dict(obj["unified_card"]) if obj.get("unified_card") is not None else None,
            "unmention_data": obj.get("unmention_data"),
            "views": TweetView.from_dict(obj["views"]) if obj.get("views") is not None else None
        })
        return _obj

from twitter_openapi_python_generated.models.grok_share_attachment import GrokShareAttachment
from twitter_openapi_python_generated.models.item_result import ItemResult
from twitter_openapi_python_generated.models.quoted_ref_result import QuotedRefResult
from twitter_openapi_python_generated.models.tweet_legacy import TweetLegacy
# TODO: Rewrite to not use raise_errors
Tweet.model_rebuild(raise_errors=False)

