# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr

from twitter_openapi_python_generated.models.post_create_retweet200_response import PostCreateRetweet200Response
from twitter_openapi_python_generated.models.post_create_retweet_request import PostCreateRetweetRequest
from twitter_openapi_python_generated.models.post_create_tweet200_response import PostCreateTweet200Response
from twitter_openapi_python_generated.models.post_create_tweet_request import PostCreateTweetRequest
from twitter_openapi_python_generated.models.post_delete_retweet200_response import PostDeleteRetweet200Response
from twitter_openapi_python_generated.models.post_delete_retweet_request import PostDeleteRetweetRequest
from twitter_openapi_python_generated.models.post_delete_tweet200_response import PostDeleteTweet200Response
from twitter_openapi_python_generated.models.post_delete_tweet_request import PostDeleteTweetRequest
from twitter_openapi_python_generated.models.post_favorite_tweet200_response import PostFavoriteTweet200Response
from twitter_openapi_python_generated.models.post_favorite_tweet_request import PostFavoriteTweetRequest
from twitter_openapi_python_generated.models.post_unfavorite_tweet200_response import PostUnfavoriteTweet200Response
from twitter_openapi_python_generated.models.post_unfavorite_tweet_request import PostUnfavoriteTweetRequest

from twitter_openapi_python_generated.api_client import ApiClient
from twitter_openapi_python_generated.api_response import ApiResponse
from twitter_openapi_python_generated.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PostApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def post_create_retweet(self, path_query_id : StrictStr, post_create_retweet_request : Annotated[PostCreateRetweetRequest, Field(..., description="body")], **kwargs) -> PostCreateRetweet200Response:  # noqa: E501
        """post_create_retweet  # noqa: E501

        create Retweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_create_retweet(path_query_id, post_create_retweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_create_retweet_request: body (required)
        :type post_create_retweet_request: PostCreateRetweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostCreateRetweet200Response
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the post_create_retweet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.post_create_retweet_with_http_info(path_query_id, post_create_retweet_request, **kwargs)  # noqa: E501

    @validate_arguments
    def post_create_retweet_with_http_info(self, path_query_id : StrictStr, post_create_retweet_request : Annotated[PostCreateRetweetRequest, Field(..., description="body")], **kwargs) -> ApiResponse:  # noqa: E501
        """post_create_retweet  # noqa: E501

        create Retweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_create_retweet_with_http_info(path_query_id, post_create_retweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_create_retweet_request: body (required)
        :type post_create_retweet_request: PostCreateRetweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostCreateRetweet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'path_query_id',
            'post_create_retweet_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_create_retweet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['path_query_id']:
            _path_params['pathQueryId'] = _params['path_query_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['post_create_retweet_request'] is not None:
            _body_params = _params['post_create_retweet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ClientLanguage', 'CookieCt0', 'ActiveUser', 'UserAgent', 'CookieAuthToken', 'AuthType', 'CsrfToken', 'GuestToken', 'BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostCreateRetweet200Response",
        }

        return self.api_client.call_api(
            '/graphql/{pathQueryId}/CreateRetweet', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def post_create_tweet(self, path_query_id : StrictStr, post_create_tweet_request : Annotated[PostCreateTweetRequest, Field(..., description="body")], **kwargs) -> PostCreateTweet200Response:  # noqa: E501
        """post_create_tweet  # noqa: E501

        create Tweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_create_tweet(path_query_id, post_create_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_create_tweet_request: body (required)
        :type post_create_tweet_request: PostCreateTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostCreateTweet200Response
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the post_create_tweet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.post_create_tweet_with_http_info(path_query_id, post_create_tweet_request, **kwargs)  # noqa: E501

    @validate_arguments
    def post_create_tweet_with_http_info(self, path_query_id : StrictStr, post_create_tweet_request : Annotated[PostCreateTweetRequest, Field(..., description="body")], **kwargs) -> ApiResponse:  # noqa: E501
        """post_create_tweet  # noqa: E501

        create Tweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_create_tweet_with_http_info(path_query_id, post_create_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_create_tweet_request: body (required)
        :type post_create_tweet_request: PostCreateTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostCreateTweet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'path_query_id',
            'post_create_tweet_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_create_tweet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['path_query_id']:
            _path_params['pathQueryId'] = _params['path_query_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['post_create_tweet_request'] is not None:
            _body_params = _params['post_create_tweet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ClientLanguage', 'CookieCt0', 'ActiveUser', 'UserAgent', 'CookieAuthToken', 'AuthType', 'CsrfToken', 'GuestToken', 'BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostCreateTweet200Response",
        }

        return self.api_client.call_api(
            '/graphql/{pathQueryId}/CreateTweet', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def post_delete_retweet(self, path_query_id : StrictStr, post_delete_retweet_request : Annotated[PostDeleteRetweetRequest, Field(..., description="body")], **kwargs) -> PostDeleteRetweet200Response:  # noqa: E501
        """post_delete_retweet  # noqa: E501

        delete Retweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_delete_retweet(path_query_id, post_delete_retweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_delete_retweet_request: body (required)
        :type post_delete_retweet_request: PostDeleteRetweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostDeleteRetweet200Response
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the post_delete_retweet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.post_delete_retweet_with_http_info(path_query_id, post_delete_retweet_request, **kwargs)  # noqa: E501

    @validate_arguments
    def post_delete_retweet_with_http_info(self, path_query_id : StrictStr, post_delete_retweet_request : Annotated[PostDeleteRetweetRequest, Field(..., description="body")], **kwargs) -> ApiResponse:  # noqa: E501
        """post_delete_retweet  # noqa: E501

        delete Retweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_delete_retweet_with_http_info(path_query_id, post_delete_retweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_delete_retweet_request: body (required)
        :type post_delete_retweet_request: PostDeleteRetweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostDeleteRetweet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'path_query_id',
            'post_delete_retweet_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_delete_retweet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['path_query_id']:
            _path_params['pathQueryId'] = _params['path_query_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['post_delete_retweet_request'] is not None:
            _body_params = _params['post_delete_retweet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ClientLanguage', 'CookieCt0', 'ActiveUser', 'UserAgent', 'CookieAuthToken', 'AuthType', 'CsrfToken', 'GuestToken', 'BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostDeleteRetweet200Response",
        }

        return self.api_client.call_api(
            '/graphql/{pathQueryId}/DeleteRetweet', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def post_delete_tweet(self, path_query_id : StrictStr, post_delete_tweet_request : Annotated[PostDeleteTweetRequest, Field(..., description="body")], **kwargs) -> PostDeleteTweet200Response:  # noqa: E501
        """post_delete_tweet  # noqa: E501

        delete Retweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_delete_tweet(path_query_id, post_delete_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_delete_tweet_request: body (required)
        :type post_delete_tweet_request: PostDeleteTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostDeleteTweet200Response
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the post_delete_tweet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.post_delete_tweet_with_http_info(path_query_id, post_delete_tweet_request, **kwargs)  # noqa: E501

    @validate_arguments
    def post_delete_tweet_with_http_info(self, path_query_id : StrictStr, post_delete_tweet_request : Annotated[PostDeleteTweetRequest, Field(..., description="body")], **kwargs) -> ApiResponse:  # noqa: E501
        """post_delete_tweet  # noqa: E501

        delete Retweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_delete_tweet_with_http_info(path_query_id, post_delete_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_delete_tweet_request: body (required)
        :type post_delete_tweet_request: PostDeleteTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostDeleteTweet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'path_query_id',
            'post_delete_tweet_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_delete_tweet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['path_query_id']:
            _path_params['pathQueryId'] = _params['path_query_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['post_delete_tweet_request'] is not None:
            _body_params = _params['post_delete_tweet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ClientLanguage', 'CookieCt0', 'ActiveUser', 'UserAgent', 'CookieAuthToken', 'AuthType', 'CsrfToken', 'GuestToken', 'BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostDeleteTweet200Response",
        }

        return self.api_client.call_api(
            '/graphql/{pathQueryId}/DeleteTweet', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def post_favorite_tweet(self, path_query_id : StrictStr, post_favorite_tweet_request : Annotated[PostFavoriteTweetRequest, Field(..., description="body")], **kwargs) -> PostFavoriteTweet200Response:  # noqa: E501
        """post_favorite_tweet  # noqa: E501

        favorite Tweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_favorite_tweet(path_query_id, post_favorite_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_favorite_tweet_request: body (required)
        :type post_favorite_tweet_request: PostFavoriteTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostFavoriteTweet200Response
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the post_favorite_tweet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.post_favorite_tweet_with_http_info(path_query_id, post_favorite_tweet_request, **kwargs)  # noqa: E501

    @validate_arguments
    def post_favorite_tweet_with_http_info(self, path_query_id : StrictStr, post_favorite_tweet_request : Annotated[PostFavoriteTweetRequest, Field(..., description="body")], **kwargs) -> ApiResponse:  # noqa: E501
        """post_favorite_tweet  # noqa: E501

        favorite Tweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_favorite_tweet_with_http_info(path_query_id, post_favorite_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_favorite_tweet_request: body (required)
        :type post_favorite_tweet_request: PostFavoriteTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostFavoriteTweet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'path_query_id',
            'post_favorite_tweet_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_favorite_tweet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['path_query_id']:
            _path_params['pathQueryId'] = _params['path_query_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['post_favorite_tweet_request'] is not None:
            _body_params = _params['post_favorite_tweet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ClientLanguage', 'CookieCt0', 'ActiveUser', 'UserAgent', 'CookieAuthToken', 'AuthType', 'CsrfToken', 'GuestToken', 'BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostFavoriteTweet200Response",
        }

        return self.api_client.call_api(
            '/graphql/{pathQueryId}/FavoriteTweet', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def post_unfavorite_tweet(self, path_query_id : StrictStr, post_unfavorite_tweet_request : Annotated[PostUnfavoriteTweetRequest, Field(..., description="body")], **kwargs) -> PostUnfavoriteTweet200Response:  # noqa: E501
        """post_unfavorite_tweet  # noqa: E501

        unfavorite Tweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_unfavorite_tweet(path_query_id, post_unfavorite_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_unfavorite_tweet_request: body (required)
        :type post_unfavorite_tweet_request: PostUnfavoriteTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostUnfavoriteTweet200Response
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the post_unfavorite_tweet_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.post_unfavorite_tweet_with_http_info(path_query_id, post_unfavorite_tweet_request, **kwargs)  # noqa: E501

    @validate_arguments
    def post_unfavorite_tweet_with_http_info(self, path_query_id : StrictStr, post_unfavorite_tweet_request : Annotated[PostUnfavoriteTweetRequest, Field(..., description="body")], **kwargs) -> ApiResponse:  # noqa: E501
        """post_unfavorite_tweet  # noqa: E501

        unfavorite Tweet  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_unfavorite_tweet_with_http_info(path_query_id, post_unfavorite_tweet_request, async_req=True)
        >>> result = thread.get()

        :param path_query_id: (required)
        :type path_query_id: str
        :param post_unfavorite_tweet_request: body (required)
        :type post_unfavorite_tweet_request: PostUnfavoriteTweetRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostUnfavoriteTweet200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'path_query_id',
            'post_unfavorite_tweet_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_unfavorite_tweet" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['path_query_id']:
            _path_params['pathQueryId'] = _params['path_query_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['post_unfavorite_tweet_request'] is not None:
            _body_params = _params['post_unfavorite_tweet_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ClientLanguage', 'CookieCt0', 'ActiveUser', 'UserAgent', 'CookieAuthToken', 'AuthType', 'CsrfToken', 'GuestToken', 'BearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "PostUnfavoriteTweet200Response",
        }

        return self.api_client.call_api(
            '/graphql/{pathQueryId}/UnfavoriteTweet', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
