# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic import BaseModel, Field, constr, validator
from twitter_openapi_python_generated.models.type_name import TypeName
from twitter_openapi_python_generated.models.user_result_by_screen_name_legacy import UserResultByScreenNameLegacy

class UserResultByScreenNameResult(BaseModel):
    """
    UserResultByScreenNameResult
    """
    typename: TypeName = Field(..., alias="__typename")
    id: constr(strict=True) = Field(...)
    legacy: UserResultByScreenNameLegacy = Field(...)
    profilemodules: Dict[str, Any] = Field(...)
    rest_id: constr(strict=True) = Field(...)
    __properties = ["__typename", "id", "legacy", "profilemodules", "rest_id"]

    @validator('id')
    def id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9a-zA-Z=]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9a-zA-Z=]+$/")
        return value

    @validator('rest_id')
    def rest_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UserResultByScreenNameResult:
        """Create an instance of UserResultByScreenNameResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of legacy
        if self.legacy:
            _dict['legacy'] = self.legacy.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UserResultByScreenNameResult:
        """Create an instance of UserResultByScreenNameResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return UserResultByScreenNameResult.parse_obj(obj)

        _obj = UserResultByScreenNameResult.parse_obj({
            "typename": obj.get("__typename"),
            "id": obj.get("id"),
            "legacy": UserResultByScreenNameLegacy.from_dict(obj.get("legacy")) if obj.get("legacy") is not None else None,
            "profilemodules": obj.get("profilemodules"),
            "rest_id": obj.get("rest_id")
        })
        return _obj


