# twitter_openapi_python_generated
Twitter OpenAPI(Swagger) specification

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.1
- Package version: 0.0.6
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/fa0311/twitter_openapi_python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/fa0311/twitter_openapi_python.git`)

Then import the package:
```python
import twitter_openapi_python_generated
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import twitter_openapi_python_generated
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import twitter_openapi_python_generated
from twitter_openapi_python_generated.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://twitter.com/i/api
# See configuration.py for a list of all supported configuration parameters.
configuration = twitter_openapi_python_generated.Configuration(
    host = "https://twitter.com/i/api"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ClientLanguage
configuration.api_key['ClientLanguage'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ClientLanguage'] = 'Bearer'

# Configure API key authorization: Accept
configuration.api_key['Accept'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Accept'] = 'Bearer'

# Configure API key authorization: SecFetchDest
configuration.api_key['SecFetchDest'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecFetchDest'] = 'Bearer'

# Configure API key authorization: Pragma
configuration.api_key['Pragma'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Pragma'] = 'Bearer'

# Configure API key authorization: SecChUaPlatform
configuration.api_key['SecChUaPlatform'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecChUaPlatform'] = 'Bearer'

# Configure API key authorization: SecFetchMode
configuration.api_key['SecFetchMode'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecFetchMode'] = 'Bearer'

# Configure API key authorization: CsrfToken
configuration.api_key['CsrfToken'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CsrfToken'] = 'Bearer'

# Configure API key authorization: GuestToken
configuration.api_key['GuestToken'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['GuestToken'] = 'Bearer'

# Configure Bearer authorization: BearerAuth
configuration = twitter_openapi_python_generated.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)

# Configure API key authorization: SecChUa
configuration.api_key['SecChUa'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecChUa'] = 'Bearer'

# Configure API key authorization: CookieCt0
configuration.api_key['CookieCt0'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CookieCt0'] = 'Bearer'

# Configure API key authorization: ActiveUser
configuration.api_key['ActiveUser'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ActiveUser'] = 'Bearer'

# Configure API key authorization: UserAgent
configuration.api_key['UserAgent'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['UserAgent'] = 'Bearer'

# Configure API key authorization: AcceptLanguage
configuration.api_key['AcceptLanguage'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['AcceptLanguage'] = 'Bearer'

# Configure API key authorization: SecFetchSite
configuration.api_key['SecFetchSite'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecFetchSite'] = 'Bearer'

# Configure API key authorization: CookieAuthToken
configuration.api_key['CookieAuthToken'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CookieAuthToken'] = 'Bearer'

# Configure API key authorization: AuthType
configuration.api_key['AuthType'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['AuthType'] = 'Bearer'

# Configure API key authorization: CacheControl
configuration.api_key['CacheControl'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['CacheControl'] = 'Bearer'

# Configure API key authorization: SecChUaMobile
configuration.api_key['SecChUaMobile'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['SecChUaMobile'] = 'Bearer'

# Configure API key authorization: AcceptEncoding
configuration.api_key['AcceptEncoding'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['AcceptEncoding'] = 'Bearer'


# Enter a context with an instance of the API client
with twitter_openapi_python_generated.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = twitter_openapi_python_generated.DefaultApi(api_client)
    path_query_id = '_pnlqeTOtnpbIL9o-fS_pg' # str |  (default to '_pnlqeTOtnpbIL9o-fS_pg')
    variables = '{"screen_name": "elonmusk"}' # str |  (default to '{"screen_name": "elonmusk"}')
    features = '{}' # str |  (default to '{}')

    try:
        api_response = api_instance.get_profile_spotlights_query(path_query_id, variables, features)
        print("The response of DefaultApi->get_profile_spotlights_query:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->get_profile_spotlights_query: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://twitter.com/i/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**get_profile_spotlights_query**](docs/DefaultApi.md#get_profile_spotlights_query) | **GET** /graphql/{pathQueryId}/ProfileSpotlightsQuery | 
*DefaultApi* | [**get_tweet_result_by_rest_id**](docs/DefaultApi.md#get_tweet_result_by_rest_id) | **GET** /graphql/{pathQueryId}/TweetResultByRestId | 
*OtherApi* | [**other**](docs/OtherApi.md#other) | **GET** /other | 
*PostApi* | [**post_create_retweet**](docs/PostApi.md#post_create_retweet) | **POST** /graphql/{pathQueryId}/CreateRetweet | 
*PostApi* | [**post_create_tweet**](docs/PostApi.md#post_create_tweet) | **POST** /graphql/{pathQueryId}/CreateTweet | 
*PostApi* | [**post_delete_retweet**](docs/PostApi.md#post_delete_retweet) | **POST** /graphql/{pathQueryId}/DeleteRetweet | 
*PostApi* | [**post_delete_tweet**](docs/PostApi.md#post_delete_tweet) | **POST** /graphql/{pathQueryId}/DeleteTweet | 
*PostApi* | [**post_favorite_tweet**](docs/PostApi.md#post_favorite_tweet) | **POST** /graphql/{pathQueryId}/FavoriteTweet | 
*PostApi* | [**post_unfavorite_tweet**](docs/PostApi.md#post_unfavorite_tweet) | **POST** /graphql/{pathQueryId}/UnfavoriteTweet | 
*TweetApi* | [**get_bookmarks**](docs/TweetApi.md#get_bookmarks) | **GET** /graphql/{pathQueryId}/Bookmarks | 
*TweetApi* | [**get_home_latest_timeline**](docs/TweetApi.md#get_home_latest_timeline) | **GET** /graphql/{pathQueryId}/HomeLatestTimeline | 
*TweetApi* | [**get_home_timeline**](docs/TweetApi.md#get_home_timeline) | **GET** /graphql/{pathQueryId}/HomeTimeline | 
*TweetApi* | [**get_likes**](docs/TweetApi.md#get_likes) | **GET** /graphql/{pathQueryId}/Likes | 
*TweetApi* | [**get_list_latest_tweets_timeline**](docs/TweetApi.md#get_list_latest_tweets_timeline) | **GET** /graphql/{pathQueryId}/ListLatestTweetsTimeline | 
*TweetApi* | [**get_search_timeline**](docs/TweetApi.md#get_search_timeline) | **GET** /graphql/{pathQueryId}/SearchTimeline | 
*TweetApi* | [**get_tweet_detail**](docs/TweetApi.md#get_tweet_detail) | **GET** /graphql/{pathQueryId}/TweetDetail | 
*TweetApi* | [**get_user_highlights_tweets**](docs/TweetApi.md#get_user_highlights_tweets) | **GET** /graphql/{pathQueryId}/UserHighlightsTweets | 
*TweetApi* | [**get_user_media**](docs/TweetApi.md#get_user_media) | **GET** /graphql/{pathQueryId}/UserMedia | 
*TweetApi* | [**get_user_tweets**](docs/TweetApi.md#get_user_tweets) | **GET** /graphql/{pathQueryId}/UserTweets | 
*TweetApi* | [**get_user_tweets_and_replies**](docs/TweetApi.md#get_user_tweets_and_replies) | **GET** /graphql/{pathQueryId}/UserTweetsAndReplies | 
*UserApi* | [**get_user_by_rest_id**](docs/UserApi.md#get_user_by_rest_id) | **GET** /graphql/{pathQueryId}/UserByRestId | 
*UserApi* | [**get_user_by_screen_name**](docs/UserApi.md#get_user_by_screen_name) | **GET** /graphql/{pathQueryId}/UserByScreenName | 
*UserListApi* | [**get_favoriters**](docs/UserListApi.md#get_favoriters) | **GET** /graphql/{pathQueryId}/Favoriters | 
*UserListApi* | [**get_followers**](docs/UserListApi.md#get_followers) | **GET** /graphql/{pathQueryId}/Followers | 
*UserListApi* | [**get_followers_you_know**](docs/UserListApi.md#get_followers_you_know) | **GET** /graphql/{pathQueryId}/FollowersYouKnow | 
*UserListApi* | [**get_following**](docs/UserListApi.md#get_following) | **GET** /graphql/{pathQueryId}/Following | 
*UserListApi* | [**get_retweeters**](docs/UserListApi.md#get_retweeters) | **GET** /graphql/{pathQueryId}/Retweeters | 
*UsersApi* | [**get_users_by_rest_ids**](docs/UsersApi.md#get_users_by_rest_ids) | **GET** /graphql/{pathQueryId}/UsersByRestIds | 
*V11GetApi* | [**get_friends_following_list**](docs/V11GetApi.md#get_friends_following_list) | **GET** /1.1/friends/following/list.json | 
*V11GetApi* | [**get_search_typeahead**](docs/V11GetApi.md#get_search_typeahead) | **GET** /1.1/search/typeahead.json | 
*V11PostApi* | [**post_create_friendships**](docs/V11PostApi.md#post_create_friendships) | **POST** /1.1/friendships/create.json | 
*V11PostApi* | [**post_destroy_friendships**](docs/V11PostApi.md#post_destroy_friendships) | **POST** /1.1/friendships/destroy.json | 
*V20GetApi* | [**get_search_adaptive**](docs/V20GetApi.md#get_search_adaptive) | **GET** /2/search/adaptive.json | 


## Documentation For Models

 - [AdditionalMediaInfo](docs/AdditionalMediaInfo.md)
 - [BookmarksResponse](docs/BookmarksResponse.md)
 - [BookmarksResponseData](docs/BookmarksResponseData.md)
 - [BookmarksTimeline](docs/BookmarksTimeline.md)
 - [Callback](docs/Callback.md)
 - [ClientEventInfo](docs/ClientEventInfo.md)
 - [CommunitiesActions](docs/CommunitiesActions.md)
 - [ContentEntryType](docs/ContentEntryType.md)
 - [ContentItemType](docs/ContentItemType.md)
 - [ContentUnion](docs/ContentUnion.md)
 - [CoverCta](docs/CoverCta.md)
 - [CreateRetweet](docs/CreateRetweet.md)
 - [CreateRetweetResponse](docs/CreateRetweetResponse.md)
 - [CreateRetweetResponseData](docs/CreateRetweetResponseData.md)
 - [CreateRetweetResponseResult](docs/CreateRetweetResponseResult.md)
 - [CreateTweet](docs/CreateTweet.md)
 - [CreateTweetResponse](docs/CreateTweetResponse.md)
 - [CreateTweetResponseData](docs/CreateTweetResponseData.md)
 - [CreateTweetResponseResult](docs/CreateTweetResponseResult.md)
 - [CtaClientEventInfo](docs/CtaClientEventInfo.md)
 - [CursorType](docs/CursorType.md)
 - [DeleteRetweet](docs/DeleteRetweet.md)
 - [DeleteRetweetResponse](docs/DeleteRetweetResponse.md)
 - [DeleteRetweetResponseData](docs/DeleteRetweetResponseData.md)
 - [DeleteRetweetResponseResult](docs/DeleteRetweetResponseResult.md)
 - [DeleteTweetResponse](docs/DeleteTweetResponse.md)
 - [DeleteTweetResponseData](docs/DeleteTweetResponseData.md)
 - [DeleteTweetResponseResult](docs/DeleteTweetResponseResult.md)
 - [Entities](docs/Entities.md)
 - [Error](docs/Error.md)
 - [ErrorExtensions](docs/ErrorExtensions.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [Errors](docs/Errors.md)
 - [ExtMediaAvailability](docs/ExtMediaAvailability.md)
 - [ExtendedEntities](docs/ExtendedEntities.md)
 - [Extensions](docs/Extensions.md)
 - [FavoriteTweet](docs/FavoriteTweet.md)
 - [FavoriteTweetResponseData](docs/FavoriteTweetResponseData.md)
 - [FollowResponse](docs/FollowResponse.md)
 - [FollowResponseData](docs/FollowResponseData.md)
 - [FollowResponseResult](docs/FollowResponseResult.md)
 - [FollowResponseUser](docs/FollowResponseUser.md)
 - [FollowTimeline](docs/FollowTimeline.md)
 - [GetBookmarks200Response](docs/GetBookmarks200Response.md)
 - [GetFavoriters200Response](docs/GetFavoriters200Response.md)
 - [GetFollowers200Response](docs/GetFollowers200Response.md)
 - [GetHomeLatestTimeline200Response](docs/GetHomeLatestTimeline200Response.md)
 - [GetLikes200Response](docs/GetLikes200Response.md)
 - [GetListLatestTweetsTimeline200Response](docs/GetListLatestTweetsTimeline200Response.md)
 - [GetProfileSpotlightsQuery200Response](docs/GetProfileSpotlightsQuery200Response.md)
 - [GetRetweeters200Response](docs/GetRetweeters200Response.md)
 - [GetSearchTimeline200Response](docs/GetSearchTimeline200Response.md)
 - [GetTweetDetail200Response](docs/GetTweetDetail200Response.md)
 - [GetTweetResultByRestId200Response](docs/GetTweetResultByRestId200Response.md)
 - [GetUserByRestId200Response](docs/GetUserByRestId200Response.md)
 - [GetUserHighlightsTweets200Response](docs/GetUserHighlightsTweets200Response.md)
 - [GetUsersByRestIds200Response](docs/GetUsersByRestIds200Response.md)
 - [HomeTimelineHome](docs/HomeTimelineHome.md)
 - [HomeTimelineResponseData](docs/HomeTimelineResponseData.md)
 - [InstructionType](docs/InstructionType.md)
 - [InstructionUnion](docs/InstructionUnion.md)
 - [ItemContentUnion](docs/ItemContentUnion.md)
 - [ItemResult](docs/ItemResult.md)
 - [ListLatestTweetsTimelineResponse](docs/ListLatestTweetsTimelineResponse.md)
 - [ListTweetsTimeline](docs/ListTweetsTimeline.md)
 - [ListTweetsTimelineData](docs/ListTweetsTimelineData.md)
 - [ListTweetsTimelineList](docs/ListTweetsTimelineList.md)
 - [Location](docs/Location.md)
 - [Media](docs/Media.md)
 - [MediaExtended](docs/MediaExtended.md)
 - [MediaOriginalInfo](docs/MediaOriginalInfo.md)
 - [MediaOriginalInfoFocusRect](docs/MediaOriginalInfoFocusRect.md)
 - [MediaSize](docs/MediaSize.md)
 - [MediaSizes](docs/MediaSizes.md)
 - [MediaStats](docs/MediaStats.md)
 - [MediaVideoInfo](docs/MediaVideoInfo.md)
 - [MediaVideoInfoVariant](docs/MediaVideoInfoVariant.md)
 - [ModuleEntry](docs/ModuleEntry.md)
 - [ModuleItem](docs/ModuleItem.md)
 - [OneFactorLoginEligibility](docs/OneFactorLoginEligibility.md)
 - [Other200Response](docs/Other200Response.md)
 - [OtherResponse](docs/OtherResponse.md)
 - [PostCreateRetweet200Response](docs/PostCreateRetweet200Response.md)
 - [PostCreateRetweetRequest](docs/PostCreateRetweetRequest.md)
 - [PostCreateRetweetRequestVariables](docs/PostCreateRetweetRequestVariables.md)
 - [PostCreateTweet200Response](docs/PostCreateTweet200Response.md)
 - [PostCreateTweetRequest](docs/PostCreateTweetRequest.md)
 - [PostCreateTweetRequestFeatures](docs/PostCreateTweetRequestFeatures.md)
 - [PostCreateTweetRequestVariables](docs/PostCreateTweetRequestVariables.md)
 - [PostCreateTweetRequestVariablesMedia](docs/PostCreateTweetRequestVariablesMedia.md)
 - [PostCreateTweetRequestVariablesMediaMediaEntitiesInner](docs/PostCreateTweetRequestVariablesMediaMediaEntitiesInner.md)
 - [PostDeleteRetweet200Response](docs/PostDeleteRetweet200Response.md)
 - [PostDeleteRetweetRequest](docs/PostDeleteRetweetRequest.md)
 - [PostDeleteRetweetRequestVariables](docs/PostDeleteRetweetRequestVariables.md)
 - [PostDeleteTweet200Response](docs/PostDeleteTweet200Response.md)
 - [PostDeleteTweetRequest](docs/PostDeleteTweetRequest.md)
 - [PostFavoriteTweet200Response](docs/PostFavoriteTweet200Response.md)
 - [PostFavoriteTweetRequest](docs/PostFavoriteTweetRequest.md)
 - [PostUnfavoriteTweet200Response](docs/PostUnfavoriteTweet200Response.md)
 - [PostUnfavoriteTweetRequest](docs/PostUnfavoriteTweetRequest.md)
 - [ProfileResponse](docs/ProfileResponse.md)
 - [ProfileResponseData](docs/ProfileResponseData.md)
 - [Retweet](docs/Retweet.md)
 - [RetweetLegacy](docs/RetweetLegacy.md)
 - [SearchByRawQuery](docs/SearchByRawQuery.md)
 - [SearchTimeline](docs/SearchTimeline.md)
 - [SearchTimelineData](docs/SearchTimelineData.md)
 - [SearchTimelineResponse](docs/SearchTimelineResponse.md)
 - [SelfThread](docs/SelfThread.md)
 - [Session](docs/Session.md)
 - [SocialContext](docs/SocialContext.md)
 - [Text](docs/Text.md)
 - [TextEntity](docs/TextEntity.md)
 - [TextEntityRef](docs/TextEntityRef.md)
 - [Timeline](docs/Timeline.md)
 - [TimelineAddEntries](docs/TimelineAddEntries.md)
 - [TimelineAddEntry](docs/TimelineAddEntry.md)
 - [TimelineAddToModule](docs/TimelineAddToModule.md)
 - [TimelineClearCache](docs/TimelineClearCache.md)
 - [TimelineCoverBehavior](docs/TimelineCoverBehavior.md)
 - [TimelineHalfCover](docs/TimelineHalfCover.md)
 - [TimelineMessagePrompt](docs/TimelineMessagePrompt.md)
 - [TimelinePinEntry](docs/TimelinePinEntry.md)
 - [TimelinePrompt](docs/TimelinePrompt.md)
 - [TimelineReplaceEntry](docs/TimelineReplaceEntry.md)
 - [TimelineResponse](docs/TimelineResponse.md)
 - [TimelineShowAlert](docs/TimelineShowAlert.md)
 - [TimelineShowAlertRichText](docs/TimelineShowAlertRichText.md)
 - [TimelineShowCover](docs/TimelineShowCover.md)
 - [TimelineTerminateTimeline](docs/TimelineTerminateTimeline.md)
 - [TimelineTimelineCursor](docs/TimelineTimelineCursor.md)
 - [TimelineTimelineItem](docs/TimelineTimelineItem.md)
 - [TimelineTimelineModule](docs/TimelineTimelineModule.md)
 - [TimelineTweet](docs/TimelineTweet.md)
 - [TimelineUser](docs/TimelineUser.md)
 - [TimelineV2](docs/TimelineV2.md)
 - [Tracing](docs/Tracing.md)
 - [Tweet](docs/Tweet.md)
 - [TweetCard](docs/TweetCard.md)
 - [TweetCardLegacy](docs/TweetCardLegacy.md)
 - [TweetCardLegacyBindingValue](docs/TweetCardLegacyBindingValue.md)
 - [TweetCardLegacyBindingValueData](docs/TweetCardLegacyBindingValueData.md)
 - [TweetDetailResponse](docs/TweetDetailResponse.md)
 - [TweetDetailResponseData](docs/TweetDetailResponseData.md)
 - [TweetEditControl](docs/TweetEditControl.md)
 - [TweetEditControlInitial](docs/TweetEditControlInitial.md)
 - [TweetEditPrespective](docs/TweetEditPrespective.md)
 - [TweetFavoritersResponse](docs/TweetFavoritersResponse.md)
 - [TweetFavoritersResponseData](docs/TweetFavoritersResponseData.md)
 - [TweetLegacy](docs/TweetLegacy.md)
 - [TweetResultByRestIdData](docs/TweetResultByRestIdData.md)
 - [TweetResultByRestIdResponse](docs/TweetResultByRestIdResponse.md)
 - [TweetRetweetersResponse](docs/TweetRetweetersResponse.md)
 - [TweetRetweetersResponseData](docs/TweetRetweetersResponseData.md)
 - [TweetTombstone](docs/TweetTombstone.md)
 - [TweetUnion](docs/TweetUnion.md)
 - [TweetView](docs/TweetView.md)
 - [TweetWithVisibilityResults](docs/TweetWithVisibilityResults.md)
 - [TypeName](docs/TypeName.md)
 - [UnfavoriteTweet](docs/UnfavoriteTweet.md)
 - [UnfavoriteTweetResponseData](docs/UnfavoriteTweetResponseData.md)
 - [Url](docs/Url.md)
 - [User](docs/User.md)
 - [UserFeatures](docs/UserFeatures.md)
 - [UserHighlightsTweetsData](docs/UserHighlightsTweetsData.md)
 - [UserHighlightsTweetsResponse](docs/UserHighlightsTweetsResponse.md)
 - [UserHighlightsTweetsResult](docs/UserHighlightsTweetsResult.md)
 - [UserHighlightsTweetsTimeline](docs/UserHighlightsTweetsTimeline.md)
 - [UserHighlightsTweetsUser](docs/UserHighlightsTweetsUser.md)
 - [UserLegacy](docs/UserLegacy.md)
 - [UserResponse](docs/UserResponse.md)
 - [UserResponseData](docs/UserResponseData.md)
 - [UserResultByScreenName](docs/UserResultByScreenName.md)
 - [UserResultByScreenNameLegacy](docs/UserResultByScreenNameLegacy.md)
 - [UserResultByScreenNameResult](docs/UserResultByScreenNameResult.md)
 - [UserResultCore](docs/UserResultCore.md)
 - [UserResults](docs/UserResults.md)
 - [UserTweetsData](docs/UserTweetsData.md)
 - [UserTweetsResponse](docs/UserTweetsResponse.md)
 - [UserTweetsResult](docs/UserTweetsResult.md)
 - [UserTweetsUser](docs/UserTweetsUser.md)
 - [UserUnavailable](docs/UserUnavailable.md)
 - [UserUnion](docs/UserUnion.md)
 - [UsersResponse](docs/UsersResponse.md)
 - [UsersResponseData](docs/UsersResponseData.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Accept"></a>
### Accept

- **Type**: API key
- **API key parameter name**: Accept
- **Location**: HTTP header

<a id="AcceptEncoding"></a>
### AcceptEncoding

- **Type**: API key
- **API key parameter name**: Accept-Encoding
- **Location**: HTTP header

<a id="AcceptLanguage"></a>
### AcceptLanguage

- **Type**: API key
- **API key parameter name**: Accept-Language
- **Location**: HTTP header

<a id="ActiveUser"></a>
### ActiveUser

- **Type**: API key
- **API key parameter name**: x-twitter-active-user
- **Location**: HTTP header

<a id="AuthType"></a>
### AuthType

- **Type**: API key
- **API key parameter name**: x-twitter-auth-type
- **Location**: HTTP header

<a id="BearerAuth"></a>
### BearerAuth

- **Type**: Bearer authentication

<a id="CacheControl"></a>
### CacheControl

- **Type**: API key
- **API key parameter name**: Cache-Control
- **Location**: HTTP header

<a id="ClientLanguage"></a>
### ClientLanguage

- **Type**: API key
- **API key parameter name**: x-twitter-client-language
- **Location**: HTTP header

<a id="CookieAuthToken"></a>
### CookieAuthToken

- **Type**: API key
- **API key parameter name**: auth_token
- **Location**: 

<a id="CookieCt0"></a>
### CookieCt0

- **Type**: API key
- **API key parameter name**: ct0
- **Location**: 

<a id="CsrfToken"></a>
### CsrfToken

- **Type**: API key
- **API key parameter name**: x-csrf-token
- **Location**: HTTP header

<a id="GuestToken"></a>
### GuestToken

- **Type**: API key
- **API key parameter name**: x-guest-token
- **Location**: HTTP header

<a id="Pragma"></a>
### Pragma

- **Type**: API key
- **API key parameter name**: Pragma
- **Location**: HTTP header

<a id="SecChUa"></a>
### SecChUa

- **Type**: API key
- **API key parameter name**: Sec-Ch-Ua
- **Location**: HTTP header

<a id="SecChUaMobile"></a>
### SecChUaMobile

- **Type**: API key
- **API key parameter name**: Sec-Ch-Ua-Mobile
- **Location**: HTTP header

<a id="SecChUaPlatform"></a>
### SecChUaPlatform

- **Type**: API key
- **API key parameter name**: Sec-Ch-Ua-Platform
- **Location**: HTTP header

<a id="SecFetchDest"></a>
### SecFetchDest

- **Type**: API key
- **API key parameter name**: Sec-Fetch-Dest
- **Location**: HTTP header

<a id="SecFetchMode"></a>
### SecFetchMode

- **Type**: API key
- **API key parameter name**: Sec-Fetch-Mode
- **Location**: HTTP header

<a id="SecFetchSite"></a>
### SecFetchSite

- **Type**: API key
- **API key parameter name**: Sec-Fetch-Site
- **Location**: HTTP header

<a id="UserAgent"></a>
### UserAgent

- **Type**: API key
- **API key parameter name**: user-agent
- **Location**: HTTP header


## Author

yuki@yuki0311.com


