# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator
from twitter_openapi_python_generated.models.birdwatch_pivot_footer import BirdwatchPivotFooter
from twitter_openapi_python_generated.models.birdwatch_pivot_note import BirdwatchPivotNote
from twitter_openapi_python_generated.models.birdwatch_pivot_subtitle import BirdwatchPivotSubtitle

class BirdwatchPivot(BaseModel):
    """
    BirdwatchPivot
    """
    destination_url: StrictStr = Field(..., alias="destinationUrl")
    footer: BirdwatchPivotFooter = Field(...)
    icon_type: StrictStr = Field(..., alias="iconType")
    note: BirdwatchPivotNote = Field(...)
    shorttitle: StrictStr = Field(...)
    subtitle: BirdwatchPivotSubtitle = Field(...)
    title: StrictStr = Field(...)
    visual_style: Optional[StrictStr] = Field(None, alias="visualStyle")
    __properties = ["destinationUrl", "footer", "iconType", "note", "shorttitle", "subtitle", "title", "visualStyle"]

    @validator('icon_type')
    def icon_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('BirdwatchV1Icon'):
            raise ValueError("must be one of enum values ('BirdwatchV1Icon')")
        return value

    @validator('visual_style')
    def visual_style_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Default'):
            raise ValueError("must be one of enum values ('Default')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BirdwatchPivot:
        """Create an instance of BirdwatchPivot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of footer
        if self.footer:
            _dict['footer'] = self.footer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of note
        if self.note:
            _dict['note'] = self.note.to_dict()
        # override the default output from pydantic by calling `to_dict()` of subtitle
        if self.subtitle:
            _dict['subtitle'] = self.subtitle.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BirdwatchPivot:
        """Create an instance of BirdwatchPivot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BirdwatchPivot.parse_obj(obj)

        _obj = BirdwatchPivot.parse_obj({
            "destination_url": obj.get("destinationUrl"),
            "footer": BirdwatchPivotFooter.from_dict(obj.get("footer")) if obj.get("footer") is not None else None,
            "icon_type": obj.get("iconType"),
            "note": BirdwatchPivotNote.from_dict(obj.get("note")) if obj.get("note") is not None else None,
            "shorttitle": obj.get("shorttitle"),
            "subtitle": BirdwatchPivotSubtitle.from_dict(obj.get("subtitle")) if obj.get("subtitle") is not None else None,
            "title": obj.get("title"),
            "visual_style": obj.get("visualStyle")
        })
        return _obj


