# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from twitter_openapi_python_generated.models.entities import Entities
from twitter_openapi_python_generated.models.note_tweet_result_media import NoteTweetResultMedia
from twitter_openapi_python_generated.models.note_tweet_result_rich_text import NoteTweetResultRichText

class NoteTweetResultData(BaseModel):
    """
    NoteTweetResultData
    """
    entity_set: Entities = Field(...)
    id: constr(strict=True) = Field(...)
    media: Optional[NoteTweetResultMedia] = None
    richtext: Optional[NoteTweetResultRichText] = None
    text: StrictStr = Field(...)
    __properties = ["entity_set", "id", "media", "richtext", "text"]

    @validator('id')
    def id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^([A-Za-z0-9+\/]{4})*([A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{2}==)?$", value):
            raise ValueError(r"must validate the regular expression /^([A-Za-z0-9+\/]{4})*([A-Za-z0-9+\/]{3}=|[A-Za-z0-9+\/]{2}==)?$/")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NoteTweetResultData:
        """Create an instance of NoteTweetResultData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of entity_set
        if self.entity_set:
            _dict['entity_set'] = self.entity_set.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media
        if self.media:
            _dict['media'] = self.media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of richtext
        if self.richtext:
            _dict['richtext'] = self.richtext.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NoteTweetResultData:
        """Create an instance of NoteTweetResultData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NoteTweetResultData.parse_obj(obj)

        _obj = NoteTweetResultData.parse_obj({
            "entity_set": Entities.from_dict(obj.get("entity_set")) if obj.get("entity_set") is not None else None,
            "id": obj.get("id"),
            "media": NoteTweetResultMedia.from_dict(obj.get("media")) if obj.get("media") is not None else None,
            "richtext": NoteTweetResultRichText.from_dict(obj.get("richtext")) if obj.get("richtext") is not None else None,
            "text": obj.get("text")
        })
        return _obj


