# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist
from twitter_openapi_python_generated.models.post_create_tweet_request_variables_media import PostCreateTweetRequestVariablesMedia
from twitter_openapi_python_generated.models.post_create_tweet_request_variables_reply import PostCreateTweetRequestVariablesReply

class PostCreateTweetRequestVariables(BaseModel):
    """
    PostCreateTweetRequestVariables
    """
    dark_request: StrictBool = Field(...)
    media: PostCreateTweetRequestVariablesMedia = Field(...)
    reply: Optional[PostCreateTweetRequestVariablesReply] = None
    semantic_annotation_ids: conlist(Dict[str, Any]) = Field(...)
    tweet_text: StrictStr = Field(...)
    __properties = ["dark_request", "media", "reply", "semantic_annotation_ids", "tweet_text"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PostCreateTweetRequestVariables:
        """Create an instance of PostCreateTweetRequestVariables from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of media
        if self.media:
            _dict['media'] = self.media.to_dict()
        # override the default output from pydantic by calling `to_dict()` of reply
        if self.reply:
            _dict['reply'] = self.reply.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PostCreateTweetRequestVariables:
        """Create an instance of PostCreateTweetRequestVariables from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PostCreateTweetRequestVariables.parse_obj(obj)

        _obj = PostCreateTweetRequestVariables.parse_obj({
            "dark_request": obj.get("dark_request") if obj.get("dark_request") is not None else False,
            "media": PostCreateTweetRequestVariablesMedia.from_dict(obj.get("media")) if obj.get("media") is not None else None,
            "reply": PostCreateTweetRequestVariablesReply.from_dict(obj.get("reply")) if obj.get("reply") is not None else None,
            "semantic_annotation_ids": obj.get("semantic_annotation_ids"),
            "tweet_text": obj.get("tweet_text") if obj.get("tweet_text") is not None else 'test'
        })
        return _obj


