# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import io
import warnings

from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Dict, List, Optional, Tuple, Union, Any

try:
    from typing import Annotated
except ImportError:
    from typing_extensions import Annotated

from pydantic import StrictInt, StrictStr


from twitter_openapi_python_generated.api_client import ApiClient
from twitter_openapi_python_generated.api_response import ApiResponse
from twitter_openapi_python_generated.rest import RESTResponseType


class V11PostApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def post_create_friendships(
        self,
        include_blocked_by: StrictInt,
        include_blocking: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        include_ext_verified_type: StrictInt,
        include_followed_by: StrictInt,
        include_mute_edge: StrictInt,
        include_profile_interstitial_type: StrictInt,
        include_want_retweets: StrictInt,
        skip_status: StrictInt,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """post_create_friendships

        post create friendships

        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param skip_status: (required)
        :type skip_status: int
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_create_friendships_serialize(
            include_blocked_by=include_blocked_by,
            include_blocking=include_blocking,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            include_ext_verified_type=include_ext_verified_type,
            include_followed_by=include_followed_by,
            include_mute_edge=include_mute_edge,
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_want_retweets=include_want_retweets,
            skip_status=skip_status,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_create_friendships_with_http_info(
        self,
        include_blocked_by: StrictInt,
        include_blocking: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        include_ext_verified_type: StrictInt,
        include_followed_by: StrictInt,
        include_mute_edge: StrictInt,
        include_profile_interstitial_type: StrictInt,
        include_want_retweets: StrictInt,
        skip_status: StrictInt,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """post_create_friendships

        post create friendships

        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param skip_status: (required)
        :type skip_status: int
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_create_friendships_serialize(
            include_blocked_by=include_blocked_by,
            include_blocking=include_blocking,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            include_ext_verified_type=include_ext_verified_type,
            include_followed_by=include_followed_by,
            include_mute_edge=include_mute_edge,
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_want_retweets=include_want_retweets,
            skip_status=skip_status,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_create_friendships_without_preload_content(
        self,
        include_blocked_by: StrictInt,
        include_blocking: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        include_ext_verified_type: StrictInt,
        include_followed_by: StrictInt,
        include_mute_edge: StrictInt,
        include_profile_interstitial_type: StrictInt,
        include_want_retweets: StrictInt,
        skip_status: StrictInt,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """post_create_friendships

        post create friendships

        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param skip_status: (required)
        :type skip_status: int
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_create_friendships_serialize(
            include_blocked_by=include_blocked_by,
            include_blocking=include_blocking,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            include_ext_verified_type=include_ext_verified_type,
            include_followed_by=include_followed_by,
            include_mute_edge=include_mute_edge,
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_want_retweets=include_want_retweets,
            skip_status=skip_status,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_create_friendships_serialize(
        self,
        include_blocked_by,
        include_blocking,
        include_can_dm,
        include_can_media_tag,
        include_ext_has_nft_avatar,
        include_ext_is_blue_verified,
        include_ext_profile_image_shape,
        include_ext_verified_type,
        include_followed_by,
        include_mute_edge,
        include_profile_interstitial_type,
        include_want_retweets,
        skip_status,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if include_blocked_by is not None:
            _form_params.append(('include_blocked_by', include_blocked_by))
        if include_blocking is not None:
            _form_params.append(('include_blocking', include_blocking))
        if include_can_dm is not None:
            _form_params.append(('include_can_dm', include_can_dm))
        if include_can_media_tag is not None:
            _form_params.append(('include_can_media_tag', include_can_media_tag))
        if include_ext_has_nft_avatar is not None:
            _form_params.append(('include_ext_has_nft_avatar', include_ext_has_nft_avatar))
        if include_ext_is_blue_verified is not None:
            _form_params.append(('include_ext_is_blue_verified', include_ext_is_blue_verified))
        if include_ext_profile_image_shape is not None:
            _form_params.append(('include_ext_profile_image_shape', include_ext_profile_image_shape))
        if include_ext_verified_type is not None:
            _form_params.append(('include_ext_verified_type', include_ext_verified_type))
        if include_followed_by is not None:
            _form_params.append(('include_followed_by', include_followed_by))
        if include_mute_edge is not None:
            _form_params.append(('include_mute_edge', include_mute_edge))
        if include_profile_interstitial_type is not None:
            _form_params.append(('include_profile_interstitial_type', include_profile_interstitial_type))
        if include_want_retweets is not None:
            _form_params.append(('include_want_retweets', include_want_retweets))
        if skip_status is not None:
            _form_params.append(('skip_status', skip_status))
        if user_id is not None:
            _form_params.append(('user_id', user_id))
        # process the body parameter



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ClientLanguage', 
            'Accept', 
            'SecFetchDest', 
            'Pragma', 
            'SecChUaPlatform', 
            'SecFetchMode', 
            'CsrfToken', 
            'GuestToken', 
            'BearerAuth', 
            'SecChUa', 
            'CookieCt0', 
            'ActiveUser', 
            'UserAgent', 
            'AcceptLanguage', 
            'SecFetchSite', 
            'CookieAuthToken', 
            'AuthType', 
            'CacheControl', 
            'SecChUaMobile', 
            'AcceptEncoding'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/1.1/friendships/create.json',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_destroy_friendships(
        self,
        include_blocked_by: StrictInt,
        include_blocking: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        include_ext_verified_type: StrictInt,
        include_followed_by: StrictInt,
        include_mute_edge: StrictInt,
        include_profile_interstitial_type: StrictInt,
        include_want_retweets: StrictInt,
        skip_status: StrictInt,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """post_destroy_friendships

        post destroy friendships

        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param skip_status: (required)
        :type skip_status: int
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_destroy_friendships_serialize(
            include_blocked_by=include_blocked_by,
            include_blocking=include_blocking,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            include_ext_verified_type=include_ext_verified_type,
            include_followed_by=include_followed_by,
            include_mute_edge=include_mute_edge,
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_want_retweets=include_want_retweets,
            skip_status=skip_status,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_destroy_friendships_with_http_info(
        self,
        include_blocked_by: StrictInt,
        include_blocking: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        include_ext_verified_type: StrictInt,
        include_followed_by: StrictInt,
        include_mute_edge: StrictInt,
        include_profile_interstitial_type: StrictInt,
        include_want_retweets: StrictInt,
        skip_status: StrictInt,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """post_destroy_friendships

        post destroy friendships

        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param skip_status: (required)
        :type skip_status: int
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_destroy_friendships_serialize(
            include_blocked_by=include_blocked_by,
            include_blocking=include_blocking,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            include_ext_verified_type=include_ext_verified_type,
            include_followed_by=include_followed_by,
            include_mute_edge=include_mute_edge,
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_want_retweets=include_want_retweets,
            skip_status=skip_status,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_destroy_friendships_without_preload_content(
        self,
        include_blocked_by: StrictInt,
        include_blocking: StrictInt,
        include_can_dm: StrictInt,
        include_can_media_tag: StrictInt,
        include_ext_has_nft_avatar: StrictInt,
        include_ext_is_blue_verified: StrictInt,
        include_ext_profile_image_shape: StrictInt,
        include_ext_verified_type: StrictInt,
        include_followed_by: StrictInt,
        include_mute_edge: StrictInt,
        include_profile_interstitial_type: StrictInt,
        include_want_retweets: StrictInt,
        skip_status: StrictInt,
        user_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """post_destroy_friendships

        post destroy friendships

        :param include_blocked_by: (required)
        :type include_blocked_by: int
        :param include_blocking: (required)
        :type include_blocking: int
        :param include_can_dm: (required)
        :type include_can_dm: int
        :param include_can_media_tag: (required)
        :type include_can_media_tag: int
        :param include_ext_has_nft_avatar: (required)
        :type include_ext_has_nft_avatar: int
        :param include_ext_is_blue_verified: (required)
        :type include_ext_is_blue_verified: int
        :param include_ext_profile_image_shape: (required)
        :type include_ext_profile_image_shape: int
        :param include_ext_verified_type: (required)
        :type include_ext_verified_type: int
        :param include_followed_by: (required)
        :type include_followed_by: int
        :param include_mute_edge: (required)
        :type include_mute_edge: int
        :param include_profile_interstitial_type: (required)
        :type include_profile_interstitial_type: int
        :param include_want_retweets: (required)
        :type include_want_retweets: int
        :param skip_status: (required)
        :type skip_status: int
        :param user_id: (required)
        :type user_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_destroy_friendships_serialize(
            include_blocked_by=include_blocked_by,
            include_blocking=include_blocking,
            include_can_dm=include_can_dm,
            include_can_media_tag=include_can_media_tag,
            include_ext_has_nft_avatar=include_ext_has_nft_avatar,
            include_ext_is_blue_verified=include_ext_is_blue_verified,
            include_ext_profile_image_shape=include_ext_profile_image_shape,
            include_ext_verified_type=include_ext_verified_type,
            include_followed_by=include_followed_by,
            include_mute_edge=include_mute_edge,
            include_profile_interstitial_type=include_profile_interstitial_type,
            include_want_retweets=include_want_retweets,
            skip_status=skip_status,
            user_id=user_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_destroy_friendships_serialize(
        self,
        include_blocked_by,
        include_blocking,
        include_can_dm,
        include_can_media_tag,
        include_ext_has_nft_avatar,
        include_ext_is_blue_verified,
        include_ext_profile_image_shape,
        include_ext_verified_type,
        include_followed_by,
        include_mute_edge,
        include_profile_interstitial_type,
        include_want_retweets,
        skip_status,
        user_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> Tuple:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, str] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if include_blocked_by is not None:
            _form_params.append(('include_blocked_by', include_blocked_by))
        if include_blocking is not None:
            _form_params.append(('include_blocking', include_blocking))
        if include_can_dm is not None:
            _form_params.append(('include_can_dm', include_can_dm))
        if include_can_media_tag is not None:
            _form_params.append(('include_can_media_tag', include_can_media_tag))
        if include_ext_has_nft_avatar is not None:
            _form_params.append(('include_ext_has_nft_avatar', include_ext_has_nft_avatar))
        if include_ext_is_blue_verified is not None:
            _form_params.append(('include_ext_is_blue_verified', include_ext_is_blue_verified))
        if include_ext_profile_image_shape is not None:
            _form_params.append(('include_ext_profile_image_shape', include_ext_profile_image_shape))
        if include_ext_verified_type is not None:
            _form_params.append(('include_ext_verified_type', include_ext_verified_type))
        if include_followed_by is not None:
            _form_params.append(('include_followed_by', include_followed_by))
        if include_mute_edge is not None:
            _form_params.append(('include_mute_edge', include_mute_edge))
        if include_profile_interstitial_type is not None:
            _form_params.append(('include_profile_interstitial_type', include_profile_interstitial_type))
        if include_want_retweets is not None:
            _form_params.append(('include_want_retweets', include_want_retweets))
        if skip_status is not None:
            _form_params.append(('skip_status', skip_status))
        if user_id is not None:
            _form_params.append(('user_id', user_id))
        # process the body parameter



        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/x-www-form-urlencoded'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'ClientLanguage', 
            'Accept', 
            'SecFetchDest', 
            'Pragma', 
            'SecChUaPlatform', 
            'SecFetchMode', 
            'CsrfToken', 
            'GuestToken', 
            'BearerAuth', 
            'SecChUa', 
            'CookieCt0', 
            'ActiveUser', 
            'UserAgent', 
            'AcceptLanguage', 
            'SecFetchSite', 
            'CookieAuthToken', 
            'AuthType', 
            'CacheControl', 
            'SecChUaMobile', 
            'AcceptEncoding'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/1.1/friendships/destroy.json',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


