# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
from pydantic import Field
from typing_extensions import Annotated
from twitter_openapi_python_generated.models.media_original_info import MediaOriginalInfo
from twitter_openapi_python_generated.models.media_sizes import MediaSizes
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Media(BaseModel):
    """
    Media
    """ # noqa: E501
    display_url: StrictStr
    expanded_url: StrictStr
    features: Optional[Dict[str, Any]] = None
    id_str: Annotated[str, Field(strict=True)]
    indices: List[StrictInt]
    media_url_https: StrictStr
    original_info: MediaOriginalInfo
    sizes: MediaSizes
    type: StrictStr
    url: StrictStr
    __properties: ClassVar[List[str]] = ["display_url", "expanded_url", "features", "id_str", "indices", "media_url_https", "original_info", "sizes", "type", "url"]

    @field_validator('id_str')
    def id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('photo', 'video', 'animated_gif'):
            raise ValueError("must be one of enum values ('photo', 'video', 'animated_gif')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Media from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of original_info
        if self.original_info:
            _dict['original_info'] = self.original_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sizes
        if self.sizes:
            _dict['sizes'] = self.sizes.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Media from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "display_url": obj.get("display_url"),
            "expanded_url": obj.get("expanded_url"),
            "features": obj.get("features"),
            "id_str": obj.get("id_str"),
            "indices": obj.get("indices"),
            "media_url_https": obj.get("media_url_https"),
            "original_info": MediaOriginalInfo.from_dict(obj.get("original_info")) if obj.get("original_info") is not None else None,
            "sizes": MediaSizes.from_dict(obj.get("sizes")) if obj.get("sizes") is not None else None,
            "type": obj.get("type"),
            "url": obj.get("url")
        })
        return _obj


