# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List
from pydantic import BaseModel, field_validator
from pydantic import Field
from typing_extensions import Annotated
from twitter_openapi_python_generated.models.content_union import ContentUnion
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class TimelineAddEntry(BaseModel):
    """
    TimelineAddEntry
    """ # noqa: E501
    content: ContentUnion
    entry_id: Annotated[str, Field(strict=True)] = Field(alias="entryId")
    sort_index: Annotated[str, Field(strict=True)] = Field(alias="sortIndex")
    __properties: ClassVar[List[str]] = ["content", "entryId", "sortIndex"]

    @field_validator('entry_id')
    def entry_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^(([a-z]+|[0-9]+|[0-9a-f]+)(-|$))+", value):
            raise ValueError(r"must validate the regular expression /^(([a-z]+|[0-9]+|[0-9a-f]+)(-|$))+/")
        return value

    @field_validator('sort_index')
    def sort_index_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /[0-9]+$/")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TimelineAddEntry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of content
        if self.content:
            _dict['content'] = self.content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of TimelineAddEntry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "content": ContentUnion.from_dict(obj.get("content")) if obj.get("content") is not None else None,
            "entryId": obj.get("entryId"),
            "sortIndex": obj.get("sortIndex")
        })
        return _obj


