# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictInt, StrictStr, field_validator
from pydantic import Field
from twitter_openapi_python_generated.models.instruction_type import InstructionType
from twitter_openapi_python_generated.models.timeline_show_alert_rich_text import TimelineShowAlertRichText
from twitter_openapi_python_generated.models.user_results import UserResults
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class TimelineShowAlert(BaseModel):
    """
    TimelineShowAlert
    """ # noqa: E501
    alert_type: Optional[StrictStr] = Field(default=None, alias="alertType")
    color_config: Optional[Dict[str, Any]] = Field(default=None, alias="colorConfig")
    display_duration_ms: Optional[StrictInt] = Field(default=None, alias="displayDurationMs")
    display_location: Optional[StrictStr] = Field(default=None, alias="displayLocation")
    icon_display_info: Optional[Dict[str, Any]] = Field(default=None, alias="iconDisplayInfo")
    rich_text: TimelineShowAlertRichText = Field(alias="richText")
    trigger_delay_ms: Optional[StrictInt] = Field(default=None, alias="triggerDelayMs")
    type: InstructionType
    users_results: List[UserResults] = Field(alias="usersResults")
    __properties: ClassVar[List[str]] = ["alertType", "colorConfig", "displayDurationMs", "displayLocation", "iconDisplayInfo", "richText", "triggerDelayMs", "type", "usersResults"]

    @field_validator('alert_type')
    def alert_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('NewTweets'):
            raise ValueError("must be one of enum values ('NewTweets')")
        return value

    @field_validator('display_location')
    def display_location_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('Top'):
            raise ValueError("must be one of enum values ('Top')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TimelineShowAlert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of rich_text
        if self.rich_text:
            _dict['richText'] = self.rich_text.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in users_results (list)
        _items = []
        if self.users_results:
            for _item in self.users_results:
                if _item:
                    _items.append(_item.to_dict())
            _dict['usersResults'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of TimelineShowAlert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alertType": obj.get("alertType"),
            "colorConfig": obj.get("colorConfig"),
            "displayDurationMs": obj.get("displayDurationMs"),
            "displayLocation": obj.get("displayLocation"),
            "iconDisplayInfo": obj.get("iconDisplayInfo"),
            "richText": TimelineShowAlertRichText.from_dict(obj.get("richText")) if obj.get("richText") is not None else None,
            "triggerDelayMs": obj.get("triggerDelayMs"),
            "type": obj.get("type"),
            "usersResults": [UserResults.from_dict(_item) for _item in obj.get("usersResults")] if obj.get("usersResults") is not None else None
        })
        return _obj


