# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from twitter_openapi_python_generated.models.content_item_type import ContentItemType
from twitter_openapi_python_generated.models.item_result import ItemResult
from twitter_openapi_python_generated.models.social_context import SocialContext
from twitter_openapi_python_generated.models.type_name import TypeName
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class TimelineTweet(BaseModel):
    """
    TimelineTweet
    """ # noqa: E501
    social_context: Optional[SocialContext] = Field(default=None, alias="SocialContext")
    typename: TypeName = Field(alias="__typename")
    item_type: ContentItemType = Field(alias="itemType")
    promoted_metadata: Optional[Dict[str, Any]] = Field(default=None, alias="promotedMetadata")
    tweet_display_type: StrictStr = Field(alias="tweetDisplayType")
    tweet_results: ItemResult
    __properties: ClassVar[List[str]] = ["SocialContext", "__typename", "itemType", "promotedMetadata", "tweetDisplayType", "tweet_results"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TimelineTweet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of social_context
        if self.social_context:
            _dict['SocialContext'] = self.social_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tweet_results
        if self.tweet_results:
            _dict['tweet_results'] = self.tweet_results.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of TimelineTweet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SocialContext": SocialContext.from_dict(obj.get("SocialContext")) if obj.get("SocialContext") is not None else None,
            "__typename": obj.get("__typename"),
            "itemType": obj.get("itemType"),
            "promotedMetadata": obj.get("promotedMetadata"),
            "tweetDisplayType": obj.get("tweetDisplayType"),
            "tweet_results": ItemResult.from_dict(obj.get("tweet_results")) if obj.get("tweet_results") is not None else None
        })
        return _obj


