# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr, field_validator
from pydantic import Field
from twitter_openapi_python_generated.models.content_item_type import ContentItemType
from twitter_openapi_python_generated.models.social_context import SocialContext
from twitter_openapi_python_generated.models.type_name import TypeName
from twitter_openapi_python_generated.models.user_results import UserResults
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class TimelineUser(BaseModel):
    """
    TimelineUser
    """ # noqa: E501
    social_context: Optional[SocialContext] = Field(default=None, alias="SocialContext")
    typename: TypeName = Field(alias="__typename")
    item_type: ContentItemType = Field(alias="itemType")
    user_display_type: StrictStr = Field(alias="userDisplayType")
    user_results: UserResults
    __properties: ClassVar[List[str]] = ["SocialContext", "__typename", "itemType", "userDisplayType", "user_results"]

    @field_validator('user_display_type')
    def user_display_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('User', 'UserDetailed', 'SubscribableUser'):
            raise ValueError("must be one of enum values ('User', 'UserDetailed', 'SubscribableUser')")
        return value

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of TimelineUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of social_context
        if self.social_context:
            _dict['SocialContext'] = self.social_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user_results
        if self.user_results:
            _dict['user_results'] = self.user_results.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of TimelineUser from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "SocialContext": SocialContext.from_dict(obj.get("SocialContext")) if obj.get("SocialContext") is not None else None,
            "__typename": obj.get("__typename"),
            "itemType": obj.get("itemType"),
            "userDisplayType": obj.get("userDisplayType"),
            "user_results": UserResults.from_dict(obj.get("user_results")) if obj.get("user_results") is not None else None
        })
        return _obj


