import json
from twisted.web.client import Agent, ContentDecoderAgent, GzipDecoder, readBody
from twisted.web.http_headers import Headers
from twisted.internet import reactor,task

class SteemApiNodes(object):
    def __init__(self):
        self.candidates = set([
            b'https://anyx.io',
            b'https://steemd.minnowsupportproject.org',
            b'https://rpc.steemviz.com',
            b'https://api.steemitstage.com',
            b'https://api.steem.house',
            b'https://steemd-appbase.steemit.com',
            b'https://rpc.curiesteem.com',
            b'https://steemd.privex.io'])
        self.agents = dict()
        self.deferreds = dict()
        for candidate in self.candidates:
            self.agents[candidate] = ContentDecoderAgent(Agent(reactor), [(b'gzip', GzipDecoder)])
            self.deferreds[candidate] = None
        self.agent = ContentDecoderAgent(Agent(reactor), [(b'gzip', GzipDecoder)])
        self.deferred = None
        self.loop = task.LoopingCall(self.fetchfullnodeupdate)
        self.loop.start(6) # call every ten minutes
    def fetchfullnodeupdate(self):
        self.deferred = self.agent.request(b"GET",
                                      b"https://steemit.com/@fullnodeupdate.json")
        self.deferred.addCallback(self.process_result)
        self.deferred.addErrback(self.null)
    def null(self,err):
        pass
    def process_result(self,result):
        deferred2 = readBody(result)
        deferred2.addCallback(self.cbBody)
        return deferred2
    def cbBody(self,bodystring):
        o=json.loads(bodystring)
        nodes = set(filter(lambda x: x[:5] == "https",
            o["user"]["json_metadata"]["nodes"] +
            list(o["user"]["json_metadata"]["failing_nodes"].keys()) +
            list(o["user"]["json_metadata"]["failing_nodes"].keys())))
        for node in nodes:
            bnode = node.encode("ascii")
            if not bnode in self.candidates:
                self.agents[bnode] = ContentDecoderAgent(Agent(reactor), [(b'gzip', GzipDecoder)])
                self.deferreds[bnode] = None
                self.candidates.add(bnode)
                print("Added new candidate:",node)

c = SteemApiNodes()
reactor.run()
