from socket import socket
from typing import Callable, Sequence

from OpenSSL.crypto import X509

TLSv1_2_METHOD: int
OP_NO_SSLv2: int
OP_NO_SSLv3: int
OP_NO_TLSv1: int
OP_NO_TLSv1_1: int
OP_NO_TLSv1_2: int
OP_NO_TLSv1_3: int
VERIFY_PEER: int

class Connection:
    def __init__(self, context: Context, _socket: socket | None) -> None: ...
    def connect(self, addr: str | bytes | Sequence[str | int]) -> None: ...
    def do_handshake(self) -> None: ...
    def get_peer_certificate(self) -> X509: ...
    def set_tlsext_host_name(self, name: bytes) -> None: ...

class Context:
    def __init__(self, method: int) -> None: ...
    def load_verify_locations(self, cafile: str | None, capath: str | None) -> None: ...
    def set_options(self, options: int) -> None: ...
    def set_verify(self, mode: int, callback: Callable[[Connection, X509, int, int, int], bool]) -> None: ...
