# -*- coding: utf-8 -*-
from typing import Any, ContextManager, Optional, Union

class HtmlCellEvent(CommandEvent):
    """ This event class is used for the events generated by HtmlWindow.

        Source: https://docs.wxpython.org/wx.html.HtmlCellEvent.html
    """
    def __init__(self, commandType, id, cell, point, ev) -> None:
        """ The constructor is not normally used by the user code.

            Source: https://docs.wxpython.org/wx.html.HtmlCellEvent.html
        """

    def GetCell(self) -> 'html.HtmlCell':
        """ Returns the   wx.html.HtmlCellEvent  associated with the event.

            Source: https://docs.wxpython.org/wx.html.HtmlCellEvent.html
        """

    def GetLinkClicked(self) -> bool:
        """ Returns True if SetLinkClicked(true) has previously been called; False otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlCellEvent.html
        """

    def GetMouseEvent(self) -> MouseEvent:
        """ Returns the   wx.MouseEvent  associated with the event.

            Source: https://docs.wxpython.org/wx.html.HtmlCellEvent.html
        """

    def GetPoint(self) -> Point:
        """ Returns the   wx.Point  associated with the event.

            Source: https://docs.wxpython.org/wx.html.HtmlCellEvent.html
        """

    def SetLinkClicked(self, linkclicked: bool) -> None:
        """ Call this function with linkclicked  set to True if the cell which has been clicked contained a link or False otherwise (which is the default).

            Source: https://docs.wxpython.org/wx.html.HtmlCellEvent.html
        """

    Cell: 'html.HtmlCell'  # See GetCell
    LinkClicked: bool  # See GetLinkClicked and SetLinkClicked
    MouseEvent: MouseEvent  # See GetMouseEvent
    Point: Point  # See GetPoint



EVT_HTML_CELL_HOVER: int  # User moved the mouse over a   wx.html.HtmlCell.

EVT_HTML_CELL_CLICKED: int  # User clicked on a   wx.html.HtmlCell. When handling this event, remember to use HtmlCell.SetLinkClicked(true) if the cell contains a link. ^^

class HtmlLinkEvent(CommandEvent):
    """ This event class is used for the events generated by HtmlWindow.

        Source: https://docs.wxpython.org/wx.html.HtmlLinkEvent.html
    """
    def __init__(self, id, linkinfo) -> None:
        """ The constructor is not normally used by the user code.

            Source: https://docs.wxpython.org/wx.html.HtmlLinkEvent.html
        """

    def GetLinkInfo(self) -> 'html.HtmlLinkInfo':
        """ Returns the   wx.html.HtmlLinkInfo  which contains info about the cell clicked and the hyperlink it contains.

            Source: https://docs.wxpython.org/wx.html.HtmlLinkEvent.html
        """

    LinkInfo: 'html.HtmlLinkInfo'  # See GetLinkInfo



EVT_HTML_LINK_CLICKED: int  # User clicked on a hyperlink. ^^

class HtmlHelpWindow(Window):
    """ This class is used by HtmlHelpController to display help within a
frame or dialog, but you can use it yourself to create an embedded
HTML help window.

        Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def AddToolbarButtons(self, toolBar, style) -> None:
        """ You may override this virtual method to add more buttons to the help windowâs toolbar.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TAB_TRAVERSAL|BORDER_NONE, helpStyle=HF_DEFAULT_STYLE) -> bool:
        """ Creates the help window.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def CreateContents(self) -> None:
        """ Creates contents panel.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def CreateIndex(self) -> None:
        """ Creates index panel.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def CreateSearch(self) -> None:
        """ Creates search panel.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def Display(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def DisplayContents(self) -> bool:
        """ Displays contents panel.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def DisplayIndex(self) -> bool:
        """ Displays index panel.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> VisualAttributes:
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def GetController(self) -> 'html.HtmlHelpController':
        """ wx.html.HtmlHelpController

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def GetData(self) -> 'html.HtmlHelpData':
        """ Returns the   wx.html.HtmlHelpData  object, which is usually a pointer to the controllerâs data.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def KeywordSearch(self, keyword, mode=HELP_SEARCH_ALL) -> bool:
        """ Search for given keyword.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def ReadCustomization(self, cfg, path="") -> None:
        """ Reads the userâs settings for this window.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def RefreshLists(self) -> None:
        """ Refresh all panels.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def SetController(self, controller: 'html.HtmlHelpController') -> None:
        """ controller (wx.html.HtmlHelpController) â

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def UseConfig(self, config, rootpath="") -> None:
        """ Associates a Config object with the help window.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    def WriteCustomization(self, cfg, path="") -> None:
        """ Saves the userâs settings for this window.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpWindow.html
        """

    Controller: 'html.HtmlHelpController'  # See GetController and SetController
    Data: 'html.HtmlHelpData'  # See GetData



HF_EMBEDDED: int

class SimpleHtmlListBox(HtmlListBox,ItemContainer):
    """ SimpleHtmlListBox is an implementation of HtmlListBox which shows
HTML content in the listbox rows.

        Source: https://docs.wxpython.org/wx.html.SimpleHtmlListBox.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.SimpleHtmlListBox.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=HLB_DEFAULT_STYLE, validator=DefaultValidator, name=SimpleHtmlListBoxNameStr) -> bool:
        """ Creates the HTML listbox for two-step construction.

            Source: https://docs.wxpython.org/wx.html.SimpleHtmlListBox.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> VisualAttributes:
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.html.SimpleHtmlListBox.html
        """



HLB_DEFAULT_STYLE: int  # The default style: wx.BORDER_SUNKEN

HLB_MULTIPLE: int  # Multiple-selection list: the user can toggle multiple items on and off. ^^

EVT_LISTBOX: int  # Process a  wxEVT_LISTBOX   event, when an item on the list is selected. See    wx.CommandEvent.

EVT_LISTBOX_DCLICK: int  # Process a  wxEVT_LISTBOX_DCLICK   event, when the listbox is double-clicked. See    wx.CommandEvent.

BORDER_SUNKEN: int

class HtmlHelpDialog(Dialog):
    """ This class is used by HtmlHelpController to display help.

        Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
        """

    def AddToolbarButtons(self, toolBar, style) -> None:
        """ You may override this virtual method to add more buttons to the help windowâs toolbar.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
        """

    def Create(self, parent, id=ID_ANY, title="", style=HF_DEFAULT_STYLE) -> bool:
        """ Creates the dialog.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> VisualAttributes:
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
        """

    def GetController(self) -> 'html.HtmlHelpController':
        """ Returns the help controller associated with the dialog.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
        """

    def SetController(self, controller: 'html.HtmlHelpController') -> None:
        """ Sets the help controller associated with the dialog.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
        """

    def SetTitleFormat(self, format: str) -> None:
        """ Sets the dialogâs title format.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDialog.html
        """

    Controller: 'html.HtmlHelpController'  # See GetController and SetController



class HtmlHelpFrame(Frame):
    """ This class is used by HtmlHelpController to display help.

        Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
        """

    def AddToolbarButtons(self, toolBar, style) -> None:
        """ You may override this virtual method to add more buttons to the help windowâs toolbar.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
        """

    def Create(self, parent, id=ID_ANY, title="", style=HF_DEFAULT_STYLE, config=None, rootpath="") -> bool:
        """ Creates the frame.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> VisualAttributes:
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
        """

    def GetController(self) -> 'html.HtmlHelpController':
        """ Returns the help controller associated with the frame.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
        """

    def SetController(self, controller: 'html.HtmlHelpController') -> None:
        """ Sets the help controller associated with the frame.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
        """

    def SetTitleFormat(self, format: str) -> None:
        """ Sets the frameâs title format.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpFrame.html
        """

    Controller: 'html.HtmlHelpController'  # See GetController and SetController



class HtmlHelpController(HelpControllerBase):
    """ This help controller provides an easy way of displaying HTML help in
your application (see HTML Sample, test example).

        Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def AddBook(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def CreateHelpDialog(self, data: 'html.HtmlHelpData') -> 'html.HtmlHelpDialog':
        """ This protected virtual method may be overridden so that when specifying the  HF_DIALOG   style, the controller uses a different dialog.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def CreateHelpFrame(self, data: 'html.HtmlHelpData') -> 'html.HtmlHelpFrame':
        """ This protected virtual method may be overridden so that the controller uses a different frame.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def Display(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def DisplayContents(self) -> bool:
        """ Displays help window and focuses contents panel.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def DisplayIndex(self) -> bool:
        """ Displays help window and focuses index panel.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def GetDialog(self) -> 'html.HtmlHelpDialog':
        """ Returns the current help dialog.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def GetFrame(self) -> 'html.HtmlHelpFrame':
        """ Returns the current help frame.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def GetHelpWindow(self) -> 'html.HtmlHelpWindow':
        """ Get the current help window.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def KeywordSearch(self, keyword, mode=HELP_SEARCH_ALL) -> bool:
        """ Displays the help window, focuses search panel and starts searching.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def ReadCustomization(self, cfg, path="") -> None:
        """ Reads the controllerâs setting (position of window, etc.)

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def SetHelpWindow(self, helpWindow: 'html.HtmlHelpWindow') -> None:
        """ Set the help window to be managed by this controller.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def SetShouldPreventAppExit(self, enable: bool) -> None:
        """ Sets whether the help frame should prevent application from exiting if itâs the only remaining top level window.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def SetTempDir(self, path: str) -> None:
        """ Sets the path for storing temporary files - cached binary versions of index and contents files.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def SetTitleFormat(self, format: str) -> None:
        """ Sets format of title of the frame.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def UseConfig(self, config, rootpath="") -> None:
        """ Associates the config  object with the controller.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    def WriteCustomization(self, cfg, path="") -> None:
        """ Stores controllers setting (position of window etc.)

            Source: https://docs.wxpython.org/wx.html.HtmlHelpController.html
        """

    Dialog: 'html.HtmlHelpDialog'  # See GetDialog
    Frame: 'html.HtmlHelpFrame'  # See GetFrame
    HelpWindow: 'html.HtmlHelpWindow'  # See GetHelpWindow and SetHelpWindow



HF_TOOLBAR: int

HF_FLAT_TOOLBAR: int

HF_CONTENTS: int

HF_INDEX: int

HF_SEARCH: int

HF_BOOKMARKS: int

HF_OPEN_FILES: int

HF_PRINT: int

HF_MERGE_BOOKS: int

HF_ICONS_BOOK: int

HF_ICONS_FOLDER: int

HF_ICONS_BOOK_CHAPTER: int

HF_DIALOG: int

HF_FRAME: int

HF_MODAL: int

HF_DEFAULT_STYLE: int

class HtmlCell(Object):
    """ Internal data structure.

        Source: https://docs.wxpython.org/wx.html.HtmlCell.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def AdjustPagebreak(self, pagebreak, pageHeight) -> tuple:
        """ This method is called when paginating HTML, e.g. when printing.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def ConvertToText(self, sel: 'html.HtmlSelection') -> str:
        """ Converts the cell into text representation.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def Draw(self, dc, x, y, view_y1, view_y2, info) -> None:
        """ Renders the cell.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def DrawInvisible(self, dc, x, y, info) -> None:
        """ This method is called instead of Draw   when the cell is certainly out of the screen (and thus invisible).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def Find(self, condition, param) -> 'html.HtmlCell':
        """ Returns pointer to itself if this cell matches condition (or if any of the cells following in the list matches), None otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def FindCellByPos(self, x, y, flags=HTML_FIND_EXACT) -> 'html.HtmlCell':
        """ Find a cell inside this cell positioned at the given coordinates (relative to thisâs positions).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetAbsPos(self, rootCell: Optional['html.HtmlCell']=None) -> Point:
        """ rootCell (wx.html.HtmlCell) â

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetDescent(self) -> int:
        """ Returns descent value of the cell (m_Descent member).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetFirstChild(self) -> 'html.HtmlCell':
        """ Returns pointer to the first cell in the list.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetHeight(self) -> int:
        """ Returns height of the cell (m_Height member).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetId(self) -> str:
        """ Returns unique cell identifier if there is any, the empty string otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetLink(self, x=0, y=0) -> 'html.HtmlLinkInfo':
        """ Returns hypertext link if associated with this cell or None otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetMouseCursor(self, window: 'html.HtmlWindowInterface') -> Cursor:
        """ Returns cursor to show when mouse pointer is over the cell.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetMouseCursorAt(self, window, rePos) -> Cursor:
        """ Returns cursor to show when mouse pointer is over the specified point.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetNext(self) -> 'html.HtmlCell':
        """ Returns pointer to the next cell in list (see htmlcell.h       if youâre interested in details).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetParent(self) -> 'html.HtmlContainerCell':
        """ Returns pointer to parent container.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetPosX(self) -> int:
        """ Returns X position within parent (the value is relative to parentâs upper left corner).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetPosY(self) -> int:
        """ Returns Y position within parent (the value is relative to parentâs upper left corner).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetRootCell(self) -> 'html.HtmlCell':
        """ wx.html.HtmlCell

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def GetWidth(self) -> int:
        """ Returns width of the cell (m_Width member).

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def Layout(self, w: int) -> None:
        """ Layouts the cell.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def ProcessMouseClick(self, window, pos, event) -> bool:
        """ This function is simple event handler.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def SetId(self, id: str) -> None:
        """ Sets unique cell identifier.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def SetLink(self, link: 'html.HtmlLinkInfo') -> None:
        """ Sets the hypertext link associated with this cell.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def SetNext(self, cell: 'html.HtmlCell') -> None:
        """ Sets the next cell in the list.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def SetParent(self, p: 'html.HtmlContainerCell') -> None:
        """ Sets parent container of this cell.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    def SetPos(self, x, y) -> None:
        """ Sets the cellâs position within parent container.

            Source: https://docs.wxpython.org/wx.html.HtmlCell.html
        """

    AbsPos: Point  # See GetAbsPos
    Descent: int  # See GetDescent
    FirstChild: 'html.HtmlCell'  # See GetFirstChild
    Height: int  # See GetHeight
    Id: str  # See GetId and SetId
    Link: 'html.HtmlLinkInfo'  # See GetLink and SetLink
    Next: 'html.HtmlCell'  # See GetNext and SetNext
    Parent: 'html.HtmlContainerCell'  # See GetParent and SetParent
    PosX: int  # See GetPosX
    PosY: int  # See GetPosY
    RootCell: 'html.HtmlCell'  # See GetRootCell
    Width: int  # See GetWidth



HTML_COND_ISANCHOR: int

class HtmlDCRenderer(Object):
    """ This class can render HTML document into a specified area of a DC.

        Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def FindNextPageBreak(self, pos: int) -> int:
        """ Finds the next page break after the specified (vertical) position.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def GetTotalHeight(self) -> int:
        """ Returns the height of the HTML text in pixels.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def GetTotalWidth(self) -> int:
        """ Returns the width of the HTML text in pixels.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def Render(self, x, y, from_=0, to_=INT_MAX) -> None:
        """ Renders HTML text to the DC.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def SetDC(self, dc, pixel_scale=1.0) -> None:
        """ Assign DC instance to the renderer.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def SetFonts(self, normal_face, fixed_face, sizes) -> None:
        """ This function sets font sizes and faces.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def SetHtmlCell(self, cell: 'html.HtmlContainerCell') -> None:
        """ Associate the given HTML contents to the renderer.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def SetHtmlText(self, html, basepath="", isdir=True) -> None:
        """ Assign text to the renderer.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def SetSize(self, width, height) -> None:
        """ Set size of output rectangle, in pixels.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    def SetStandardFonts(self, size=-1, normal_face="", fixed_face="") -> None:
        """ Sets font sizes to be relative to the given size or the system default size; use either specified or default font.

            Source: https://docs.wxpython.org/wx.html.HtmlDCRenderer.html
        """

    TotalHeight: int  # See GetTotalHeight
    TotalWidth: int  # See GetTotalWidth



class HtmlEasyPrinting(Object):
    """ This class provides very simple interface to printing architecture.

        Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
    """
    def __init__(self, name="Printing", parentWindow=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def GetName(self) -> str:
        """ Returns the current name being used for preview frames and setup dialogs.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def GetPageSetupData(self) -> PageSetupDialogData:
        """ Returns a pointer to   wx.PageSetupDialogData  instance used by this class.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def GetParentWindow(self) -> Window:
        """ Gets the parent window for dialogs.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def GetPrintData(self) -> PrintData:
        """ Returns pointer to   wx.PrintData  instance used by this class.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def PageSetup(self) -> None:
        """ Display page setup dialog and allows the user to modify settings.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def PreviewFile(self, htmlfile: str) -> bool:
        """ Preview HTML file.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def PreviewText(self, htmltext, basepath="") -> bool:
        """ Preview HTML text (not file!).

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def PrintFile(self, htmlfile: str) -> bool:
        """ Print HTML file.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def PrintText(self, htmltext, basepath="") -> bool:
        """ Print HTML text (not file!).

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def SetFonts(self, normal_face, fixed_face, sizes) -> None:
        """ Sets fonts.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def SetFooter(self, footer, pg=PAGE_ALL) -> None:
        """ Set page footer.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def SetHeader(self, header, pg=PAGE_ALL) -> None:
        """ Set page header.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def SetName(self, name: str) -> None:
        """ Sets the name used for preview frames and setup dialogs.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def SetParentWindow(self, window: 'Window') -> None:
        """ Sets the parent window for dialogs.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def SetPromptMode(self, promptMode: PromptMode) -> None:
        """ Enable or disable showing the dialog before printing.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    def SetStandardFonts(self, size=-1, normal_face="", fixed_face="") -> None:
        """ Sets default font sizes and/or default font size.

            Source: https://docs.wxpython.org/wx.html.HtmlEasyPrinting.html
        """

    Name: str  # See GetName and SetName
    PageSetupData: PageSetupDialogData  # See GetPageSetupData
    ParentWindow: 'Window'  # See GetParentWindow and SetParentWindow
    PrintData: PrintData  # See GetPrintData



PAGE_ODD: int

PAGE_EVEN: int

PAGE_ALL: int

class HtmlFilter(Object):
    """ This class is the parent class of input filters for HtmlWindow.

        Source: https://docs.wxpython.org/wx.html.HtmlFilter.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlFilter.html
        """

    def CanRead(self, file: 'FSFile') -> bool:
        """ Returns True if this filter is capable of reading file file.

            Source: https://docs.wxpython.org/wx.html.HtmlFilter.html
        """

    def ReadFile(self, file: 'FSFile') -> str:
        """ Reads the file and returns string with HTML document.

            Source: https://docs.wxpython.org/wx.html.HtmlFilter.html
        """



class HtmlHelpData(Object):
    """ This class is used by HtmlHelpController and HtmlHelpFrame to
access HTML help items.

        Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    def AddBook(self, book_url: str) -> bool:
        """ Adds new book.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    def FindPageById(self, id: int) -> str:
        """ Returns pageâs URL based on integer ID stored in project.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    def FindPageByName(self, page: str) -> str:
        """ Returns pageâs URL based on its (file)name.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    def GetBookRecArray(self) -> HtmlBookRecArray:
        """ Returns array with help books info.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    def GetContentsArray(self) -> HtmlHelpDataItems:
        """ Returns reference to array with contents entries.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    def GetIndexArray(self) -> HtmlHelpDataItems:
        """ Returns reference to array with index entries.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    def SetTempDir(self, path: str) -> None:
        """ Sets the temporary directory where binary cached versions of MS HTML Workshop files will be stored.

            Source: https://docs.wxpython.org/wx.html.HtmlHelpData.html
        """

    BookRecArray: HtmlBookRecArray  # See GetBookRecArray
    ContentsArray: HtmlHelpDataItems  # See GetContentsArray
    IndexArray: HtmlHelpDataItems  # See GetIndexArray



class HtmlLinkInfo(Object):
    """ This class stores all necessary information about hypertext links (as
represented by <A> tag in HTML documents).

        Source: https://docs.wxpython.org/wx.html.HtmlLinkInfo.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlLinkInfo.html
        """

    def GetEvent(self) -> MouseEvent:
        """ Return pointer to event that generated OnLinkClicked() event.

            Source: https://docs.wxpython.org/wx.html.HtmlLinkInfo.html
        """

    def GetHref(self) -> str:
        """ Return HREF  value of the <A> tag.

            Source: https://docs.wxpython.org/wx.html.HtmlLinkInfo.html
        """

    def GetHtmlCell(self) -> 'html.HtmlCell':
        """ Return pointer to the cell that was clicked.

            Source: https://docs.wxpython.org/wx.html.HtmlLinkInfo.html
        """

    def GetTarget(self) -> str:
        """ Return TARGET  value of the <A> tag (this value is used to specify in which frame should be the page pointed by GetHref   Href opened).

            Source: https://docs.wxpython.org/wx.html.HtmlLinkInfo.html
        """

    Event: MouseEvent  # See GetEvent
    Href: str  # See GetHref
    HtmlCell: 'html.HtmlCell'  # See GetHtmlCell
    Target: str  # See GetTarget



class HtmlTagHandler(Object):
    """ Constructor.

        Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
        """

    def GetParser(self) -> 'html.HtmlParser':
        """ Returns the parser associated with this tag handler.

            Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
        """

    def GetSupportedTags(self) -> str:
        """ Returns list of supported tags.

            Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
        """

    def HandleTag(self, tag: 'html.HtmlTag') -> bool:
        """ This is the core method of each handler.

            Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
        """

    def ParseInner(self, tag: 'html.HtmlTag') -> None:
        """ This method calls parserâs wx.html.HtmlParser.DoParsing   method for the string between this tag and the paired ending tag:

            Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
        """

    def ParseInnerSource(self, source: str) -> None:
        """ Parses given source as if it was tagâs inner code (see HtmlParser.GetInnerSource).

            Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
        """

    def SetParser(self, parser: 'html.HtmlParser') -> None:
        """ Assigns parser  to this handler.

            Source: https://docs.wxpython.org/wx.html.HtmlTagHandler.html
        """

    Parser: 'html.HtmlParser'  # See GetParser and SetParser
    SupportedTags: str  # See GetSupportedTags



class HtmlPrintout(Printout):
    """ This class serves as printout class for HTML documents.

        Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
    """
    def __init__(self, title: str="Printout") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """

    @staticmethod
    def AddFilter(filter: 'html.HtmlFilter') -> None:
        """ Adds a filter to the static list of filters for   wx.html.HtmlPrintout.

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """

    def SetFonts(self, normal_face, fixed_face, sizes) -> None:
        """ This function sets font sizes and faces.

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """

    def SetFooter(self, footer, pg=PAGE_ALL) -> None:
        """ Set page footer.

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """

    def SetHeader(self, header, pg=PAGE_ALL) -> None:
        """ Set page header.

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """

    def SetHtmlFile(self, htmlfile: str) -> None:
        """ Prepare the class for printing this HTML file.

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """

    def SetHtmlText(self, html, basepath="", isdir=True) -> None:
        """ Prepare the class for printing this HTML text.

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """

    def SetMargins(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlPrintout.html
        """



class HtmlWindow(Scrolled,HtmlWindowInterface):
    """ HtmlWindow is probably the only class you will directly use unless
you want to do something special (like adding new tag handlers or MIME
filters).

        Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    @staticmethod
    def AddFilter(filter: 'html.HtmlFilter') -> None:
        """ Adds an input filter  to the static list of available filters.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def AppendToPage(self, source: str) -> bool:
        """ Appends HTML fragment to currently displayed text and refreshes the window.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> VisualAttributes:
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    @staticmethod
    def GetDefaultHTMLCursor(type: HTMLCursor) -> Cursor:
        """ Retrieves the default cursor for a given HTMLCursor type.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def GetInternalRepresentation(self) -> 'html.HtmlContainerCell':
        """ Returns pointer to the top-level container.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def GetOpenedAnchor(self) -> str:
        """ Returns anchor within currently opened page (see wx.html.HtmlWindow.GetOpenedPage ).

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def GetOpenedPage(self) -> str:
        """ Returns full location of the opened page.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def GetOpenedPageTitle(self) -> str:
        """ Returns title of the opened page or ââ if the current page does not contain <TITLE> tag.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def GetParser(self) -> 'html.HtmlWinParser':
        """ Returns a pointer to the current parser.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def GetRelatedFrame(self) -> Frame:
        """ Returns the related frame.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def HistoryBack(self) -> bool:
        """ Moves back to the previous page.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def HistoryCanBack(self) -> bool:
        """ Returns True if it is possible to go back in the history i.e.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def HistoryCanForward(self) -> bool:
        """ Returns True if it is possible to go forward in the history i.e.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def HistoryClear(self) -> None:
        """ Clears history.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def HistoryForward(self) -> bool:
        """ Moves to next page in history.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def LoadFile(self, filename: str) -> bool:
        """ Loads an HTML page from a file and displays it.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def LoadPage(self, location: str) -> bool:
        """ Unlike SetPage   this function first loads the HTML page from location  and then displays it.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def OnCellClicked(self, cell, x, y, event) -> bool:
        """ This method is called when a mouse button is clicked inside   wx.html.HtmlWindow.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def OnCellMouseHover(self, cell, x, y) -> None:
        """ This method is called when a mouse moves over an HTML cell.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def OnLinkClicked(self, link: 'html.HtmlLinkInfo') -> None:
        """ Called when user clicks on hypertext link.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def OnOpeningURL(self, type, url) -> None:
        """ Called when an URL is being opened (either when the user clicks on a link or an image is loaded).

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def OnSetTitle(self, title: str) -> None:
        """ Called on parsing <TITLE> tag.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def ReadCustomization(self, cfg, path="") -> None:
        """ This reads custom settings from Config.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def ScrollToAnchor(self, anchor: str) -> bool:
        """ anchor (String) â

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SelectAll(self) -> None:
        """ Selects all text in the window.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SelectLine(self, pos: Union[tuple[int, int], 'Point']) -> None:
        """ Selects the line of text that pos  points at.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SelectWord(self, pos: Union[tuple[int, int], 'Point']) -> None:
        """ Selects the word at position pos.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SelectionToText(self) -> str:
        """ Returns the current selection as plain text.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SetBorders(self, b: int) -> None:
        """ This function sets the space between border of window and HTML contents.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    @staticmethod
    def SetDefaultHTMLCursor(type, cursor) -> None:
        """ Sets the default cursor for a given HTMLCursor type.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SetFonts(self, normal_face, fixed_face, sizes) -> None:
        """ This function sets font sizes and faces.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SetPage(self, source: str) -> bool:
        """ Sets the source of a page and displays it, for example:

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SetRelatedFrame(self, frame, format) -> None:
        """ Sets the frame in which page title will be displayed.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SetRelatedStatusBar(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def SetStandardFonts(self, size=-1, normal_face="", fixed_face="") -> None:
        """ Sets default font sizes and/or default font size.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def ToText(self) -> str:
        """ Returns content of currently displayed page as plain text.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    def WriteCustomization(self, cfg, path="") -> None:
        """ Saves custom settings into Config.

            Source: https://docs.wxpython.org/wx.html.HtmlWindow.html
        """

    InternalRepresentation: 'html.HtmlContainerCell'  # See GetInternalRepresentation
    OpenedAnchor: str  # See GetOpenedAnchor
    OpenedPage: str  # See GetOpenedPage
    OpenedPageTitle: str  # See GetOpenedPageTitle
    Parser: 'html.HtmlWinParser'  # See GetParser
    RelatedFrame: Frame  # See GetRelatedFrame and SetRelatedFrame



HW_SCROLLBAR_NEVER: int  # Never display scrollbars, not even when the page is larger than the window.

HW_SCROLLBAR_AUTO: int  # Display scrollbars only if pageâs size exceeds windowâs size.

HW_NO_SELECTION: int  # Donât allow the user to select text. ^^

HTML_URL_PAGE: int

HTML_URL_IMAGE: int

HTML_URL_OTHER: int

HTML_OPEN: int

HTML_BLOCK: int

HTML_REDIRECT: int

class HtmlListBox(VListBox):
    """ HtmlListBox is an implementation of VListBox which shows HTML
content in the listbox rows.

        Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=HtmlListBoxNameStr) -> bool:
        """ Creates the control and optionally sets the initial number of items in it (it may also be set or changed later with wx.VListBox.SetItemCount ).

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> VisualAttributes:
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    def GetFileSystem(self) -> FileSystem:
        """ Returns the   wx.FileSystem  used by the HTML parser of this object.

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    def GetSelectedTextBgColour(self, colBg: Union[int, str, 'Colour']) -> Colour:
        """ This virtual function may be overridden to change the appearance of the background of the selected cells in the same way as GetSelectedTextColour .

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    def GetSelectedTextColour(self, colFg: Union[int, str, 'Colour']) -> Colour:
        """ This virtual function may be overridden to customize the appearance of the selected cells.

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    def OnGetItem(self, n: int) -> str:
        """ This method must be implemented in the derived class and should return the body (i.e. without  html   nor   body   tags) of the HTML fragment for the given item.

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    def OnGetItemMarkup(self, n: int) -> str:
        """ This function may be overridden to decorate HTML returned by OnGetItem .

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    def OnLinkClicked(self, n, link) -> None:
        """ Called when the user clicks on hypertext link.

            Source: https://docs.wxpython.org/wx.html.HtmlListBox.html
        """

    FileSystem: FileSystem  # See GetFileSystem



class HtmlModalHelp:
    """ This class uses HtmlHelpController to display help in a modal
dialog.

        Source: https://docs.wxpython.org/wx.html.HtmlModalHelp.html
    """
    def __init__(self, parent, helpFile, topic="", style=HF_DEFAULT_STYLE|HF_DIALOG|HF_MODAL) -> None:
        """ The constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlModalHelp.html
        """



class HtmlParser:
    """ Classes derived from this handle the generic parsing of HTML
documents: it scans the document and divide it into blocks of tags
(where one block consists of beginning and ending tag and of text
between these two tags).

        Source: https://docs.wxpython.org/wx.html.HtmlParser.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def AddTag(self, tag: 'html.HtmlTag') -> None:
        """ This may (and may not) be overwritten in derived class.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def AddTagHandler(self, handler: 'html.HtmlTagHandler') -> None:
        """ Adds handler to the internal list ( hash table) of handlers.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def DoParsing(self) -> None:
        """ Parses the whole m_Source.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def DoneParser(self) -> None:
        """ This must be called after DoParsing .

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def GetFS(self) -> FileSystem:
        """ Returns pointer to the file system.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def GetProduct(self) -> Object:
        """ Returns product of parsing.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def GetSource(self) -> str:
        """ Returns pointer to the source being parsed.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def InitParser(self, source: str) -> None:
        """ Setups the parser for parsing the source  string.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def OpenURL(self, type, url) -> FSFile:
        """ Opens given URL and returns    wx.FSFile  object that can be used to read data from it.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def Parse(self, source: str) -> Object:
        """ Proceeds parsing of the document.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def PopTagHandler(self) -> None:
        """ Restores parserâs state before last call to PushTagHandler .

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def PushTagHandler(self, handler, tags) -> None:
        """ Forces the handler to handle additional tags (not returned by wx.html.HtmlTagHandler.GetSupportedTags ).

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def SetFS(self, fs: 'FileSystem') -> None:
        """ Sets the virtual file system that will be used to request additional files.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    def StopParsing(self) -> None:
        """ Call this function to interrupt parsing from a tag handler.

            Source: https://docs.wxpython.org/wx.html.HtmlParser.html
        """

    FS: 'FileSystem'  # See GetFS and SetFS
    Product: Object  # See GetProduct
    Source: str  # See GetSource



class HtmlWinParser(HtmlParser):
    """ This class is derived from HtmlParser and its main goal is to parse
HTML input so that it can be displayed in HtmlWindow.

        Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
    """
    def __init__(self, wndIface: Optional['html.HtmlWindowInterface']=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def CloseContainer(self) -> 'html.HtmlContainerCell':
        """ Closes the container, sets actual container to the parent one and returns pointer to it (see Cells and Containers).

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def CreateCurrentFont(self) -> Font:
        """ Creates font based on current setting (see SetFontSize , SetFontBold , SetFontItalic , SetFontFixed , wx.html.HtmlWinParser.SetFontUnderlined ) and returns pointer to it.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetActualColor(self) -> Colour:
        """ Returns actual text colour.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetAlign(self) -> int:
        """ Returns default horizontal alignment.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetCharHeight(self) -> int:
        """ Returns (average) int height in standard font.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetCharWidth(self) -> int:
        """ Returns average int width in standard font.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetContainer(self) -> 'html.HtmlContainerCell':
        """ Returns pointer to the currently opened container (see Cells and Containers).

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetDC(self) -> DC:
        """ Returns pointer to the DC used during parsing.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetFontBold(self) -> int:
        """ Returns True if actual font is bold, False otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetFontFace(self) -> str:
        """ Returns actual font face name.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetFontFixed(self) -> int:
        """ Returns True if actual font is fixed face, False otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetFontItalic(self) -> int:
        """ Returns True if actual font is italic, False otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetFontSize(self) -> int:
        """ Returns actual font size (HTML size varies from -2 to +4)

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetFontUnderlined(self) -> int:
        """ Returns True if actual font is underlined, False otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetLink(self) -> 'html.HtmlLinkInfo':
        """ Returns actual hypertext link.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetLinkColor(self) -> Colour:
        """ Returns the colour of hypertext link text.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def GetWindowInterface(self) -> 'html.HtmlWindowInterface':
        """ Returns associated window (  wx.html.HtmlWindow).

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def OpenContainer(self) -> 'html.HtmlContainerCell':
        """ Opens new container and returns pointer to it (see Cells and Containers).

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetActualColor(self, clr: Union[int, str, 'Colour']) -> None:
        """ Sets actual text colour.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetAlign(self, a: int) -> None:
        """ Sets default horizontal alignment (see wx.html.HtmlContainerCell.SetAlignHor ).

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetContainer(self, c: 'html.HtmlContainerCell') -> 'html.HtmlContainerCell':
        """ Allows you to directly set opened container.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetDC(self, dc, pixel_scale=1.0e+0) -> None:
        """ Sets the DC.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetFontBold(self, x: int) -> None:
        """ Sets bold flag of actualfont.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetFontFace(self, face: str) -> None:
        """ Sets current font face to face.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetFontFixed(self, x: int) -> None:
        """ Sets fixed face flag of actualfont.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetFontItalic(self, x: int) -> None:
        """ Sets italic flag of actualfont.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetFontSize(self, s: int) -> None:
        """ Sets actual font size (HTML size varies from 1 to 7).

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetFontUnderlined(self, x: int) -> None:
        """ Sets underlined flag of actualfont.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetFonts(self, normal_face, fixed_face, sizes) -> None:
        """ Sets fonts.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetLink(self, link: 'html.HtmlLinkInfo') -> None:
        """ Sets actual hypertext link.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    def SetLinkColor(self, clr: Union[int, str, 'Colour']) -> None:
        """ Sets colour of hypertext link.

            Source: https://docs.wxpython.org/wx.html.HtmlWinParser.html
        """

    ActualColor: Union[int, str, 'Colour']  # See GetActualColor and SetActualColor
    Align: int  # See GetAlign and SetAlign
    CharHeight: int  # See GetCharHeight
    CharWidth: int  # See GetCharWidth
    Container: 'html.HtmlContainerCell'  # See GetContainer and SetContainer
    DC: DC  # See GetDC and SetDC
    FontBold: int  # See GetFontBold and SetFontBold
    FontFace: str  # See GetFontFace and SetFontFace
    FontFixed: int  # See GetFontFixed and SetFontFixed
    FontItalic: int  # See GetFontItalic and SetFontItalic
    FontSize: int  # See GetFontSize and SetFontSize
    FontUnderlined: int  # See GetFontUnderlined and SetFontUnderlined
    Link: 'html.HtmlLinkInfo'  # See GetLink and SetLink
    LinkColor: Union[int, str, 'Colour']  # See GetLinkColor and SetLinkColor
    WindowInterface: 'html.HtmlWindowInterface'  # See GetWindowInterface



class HtmlContainerCell(HtmlCell):
    """ The HtmlContainerCell class is an implementation of a cell that may
contain more cells in it.

        Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
    """
    def __init__(self, parent: 'html.HtmlContainerCell') -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def Detach(self, cell: 'html.HtmlCell') -> None:
        """ Detach a child cell.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def GetAlignHor(self) -> int:
        """ Returns containerâs horizontal alignment.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def GetAlignVer(self) -> int:
        """ Returns containerâs vertical alignment.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def GetBackgroundColour(self) -> Colour:
        """ Returns the background colour of the container or  NullColour   if no background colour is set.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def GetIndent(self, ind: int) -> int:
        """ Returns the indentation.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def GetIndentUnits(self, ind: int) -> int:
        """ Returns the units of indentation for ind  where ind  is one of the HTML_INDENT_  constants.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def InsertCell(self, cell: 'html.HtmlCell') -> None:
        """ Inserts a new cell into the container.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetAlign(self, tag: 'html.HtmlTag') -> None:
        """ Sets the containerâs alignment (both horizontal and vertical) according to the values stored in tag.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetAlignHor(self, al) -> None:
        """ Sets the containerâs horizontal  alignment.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetAlignVer(self, al) -> None:
        """ Sets the containerâs vertical  alignment.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetBackgroundColour(self, clr: Union[int, str, 'Colour']) -> None:
        """ Sets the background colour for this container.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetBorder(self, clr1, clr2, border=1) -> None:
        """ Sets the border (frame) colours.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetIndent(self, i, what, units=HTML_UNITS_PIXELS) -> None:
        """ Sets the indentation (free space between borders of container and subcells).

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetMinHeight(self, h, align=HTML_ALIGN_TOP) -> None:
        """ Sets minimal height of the container.

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    def SetWidthFloat(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlContainerCell.html
        """

    AlignHor: int  # See GetAlignHor and SetAlignHor
    AlignVer: int  # See GetAlignVer and SetAlignVer
    BackgroundColour: Union[int, str, 'Colour']  # See GetBackgroundColour and SetBackgroundColour



HTML_ALIGN_LEFT: int

HTML_ALIGN_JUSTIFY: int

HTML_ALIGN_CENTER: int

HTML_ALIGN_RIGHT: int

HTML_ALIGN_BOTTOM: int

HTML_ALIGN_TOP: int

OR: int

HTML_INDENT_TOP: int

HTML_INDENT_BOTTOM: int

HTML_INDENT_LEFT: int

HTML_INDENT_RIGHT: int

HTML_INDENT_HORIZONTAL: int

HTML_INDENT_VERTICAL: int

HTML_INDENT_ALL: int

HTML_UNITS_PIXELS: int

HTML_UNITS_PERCENT: int

class HtmlWinTagHandler(HtmlTagHandler):
    """ This is basically HtmlTagHandler except that it is extended with
protected member m_WParser pointing to the HtmlWinParser object
(value of this member is identical to HtmlParserâs m_Parser).

        Source: https://docs.wxpython.org/wx.html.HtmlWinTagHandler.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlWinTagHandler.html
        """

    def GetParser(self) -> 'html.HtmlWinParser':
        """ wx.html.HtmlWinParser

            Source: https://docs.wxpython.org/wx.html.HtmlWinTagHandler.html
        """

    def SetParser(self, parser: 'html.HtmlParser') -> None:
        """ Assigns parser  to this handler.

            Source: https://docs.wxpython.org/wx.html.HtmlWinTagHandler.html
        """

    Parser: 'html.HtmlParser'  # See GetParser and SetParser



class HtmlColourCell(HtmlCell):
    """ This cell changes the colour of either the background or the
foreground.

        Source: https://docs.wxpython.org/wx.html.HtmlColourCell.html
    """
    def __init__(self, clr, flags=HTML_CLR_FOREGROUND) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlColourCell.html
        """



HTML_CLR_FOREGROUND: int

HTML_CLR_BACKGROUND: int

class HtmlFontCell(HtmlCell):
    """ This cell represents a font change in the document stream.

        Source: https://docs.wxpython.org/wx.html.HtmlFontCell.html
    """
    def __init__(self, font: 'Font') -> None:
        """ font (wx.Font) â

            Source: https://docs.wxpython.org/wx.html.HtmlFontCell.html
        """



class HtmlWidgetCell(HtmlCell):
    """ HtmlWidgetCell is a class that provides a connection between HTML
cells and widgets (an object derived from Window).

        Source: https://docs.wxpython.org/wx.html.HtmlWidgetCell.html
    """
    def __init__(self, wnd, w=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlWidgetCell.html
        """



class HtmlWordCell(HtmlCell):
    """ This html cell represents a single word or text fragment in the
document stream.

        Source: https://docs.wxpython.org/wx.html.HtmlWordCell.html
    """
    def __init__(self, word, dc) -> None:
        """ word (string) â

            Source: https://docs.wxpython.org/wx.html.HtmlWordCell.html
        """



class HtmlSelection:
    """ bool

        Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def AreFromToCharacterPosSet(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def ClearFromToCharacterPos(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def GetFromCell(self) -> 'html.HtmlCell':
        """ wx.html.HtmlCell

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def GetFromCharacterPos(self) -> 'Coord':
        """ wx.Coord

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def GetFromPos(self) -> Point:
        """ Point

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def GetToCell(self) -> 'html.HtmlCell':
        """ wx.html.HtmlCell

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def GetToCharacterPos(self) -> 'Coord':
        """ wx.Coord

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def GetToPos(self) -> Point:
        """ Point

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def IsEmpty(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def Set(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def SetFromCharacterPos(self, pos: int) -> None:
        """ pos (int) â

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    def SetToCharacterPos(self, pos: int) -> None:
        """ pos (int) â

            Source: https://docs.wxpython.org/wx.html.HtmlSelection.html
        """

    FromCell: 'html.HtmlCell'  # See GetFromCell
    FromCharacterPos: int  # See GetFromCharacterPos and SetFromCharacterPos
    FromPos: Point  # See GetFromPos
    ToCell: 'html.HtmlCell'  # See GetToCell
    ToCharacterPos: int  # See GetToCharacterPos and SetToCharacterPos
    ToPos: Point  # See GetToPos



class HtmlRenderingInfo:
    """ This class contains information given to cells when drawing them.

        Source: https://docs.wxpython.org/wx.html.HtmlRenderingInfo.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingInfo.html
        """

    def GetSelection(self) -> 'html.HtmlSelection':
        """ Accessors.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingInfo.html
        """

    def GetState(self) -> 'html.HtmlRenderingState':
        """ Accessors.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingInfo.html
        """

    def GetStyle(self) -> 'html.HtmlRenderingStyle':
        """ Accessors.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingInfo.html
        """

    def SetSelection(self, s: 'html.HtmlSelection') -> None:
        """ Accessors.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingInfo.html
        """

    def SetStyle(self, style: 'html.HtmlRenderingStyle') -> None:
        """ Accessors.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingInfo.html
        """

    Selection: 'html.HtmlSelection'  # See GetSelection and SetSelection
    State: 'html.HtmlRenderingState'  # See GetState
    Style: 'html.HtmlRenderingStyle'  # See GetStyle and SetStyle



class HtmlWindowInterface:
    """ Abstract interface to a HTML rendering window (such as HtmlWindow or
HtmlListBox) that is passed to HtmlWinParser.

        Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
    """
    def __init__(self) -> None:
        """ Ctor.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def GetHTMLBackgroundColour(self) -> Colour:
        """ Returns background colour to use by default.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def GetHTMLCursor(self, type: HtmlWindowInterface.HTMLCursor) -> Cursor:
        """ Returns mouse cursor of given type.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def GetHTMLWindow(self) -> Window:
        """ Returns the window used for rendering (may be None).

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def HTMLCoordsToWindow(self, cell, pos) -> Point:
        """ Converts coordinates pos  relative to given cell  to physical coordinates in the window.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def OnHTMLLinkClicked(self, link: 'html.HtmlLinkInfo') -> None:
        """ Called when a link is clicked.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def OnHTMLOpeningURL(self, type, url) -> None:
        """ Called when the parser needs to open another URL (e.g.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def SetHTMLBackgroundColour(self, clr: Union[int, str, 'Colour']) -> None:
        """ Sets windowâs background to colour clr.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def SetHTMLBackgroundImage(self, bmpBg: 'BitmapBundle') -> None:
        """ Sets windowâs background to given bitmap.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def SetHTMLStatusText(self, text: str) -> None:
        """ Sets status bar text.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    def SetHTMLWindowTitle(self, title: str) -> None:
        """ Called by the parser to set windowâs title to given text.

            Source: https://docs.wxpython.org/wx.html.HtmlWindowInterface.html
        """

    HTMLBackgroundColour: Union[int, str, 'Colour']  # See GetHTMLBackgroundColour and SetHTMLBackgroundColour
    HTMLWindow: Window  # See GetHTMLWindow



class HtmlTag:
    """ This class represents a single HTML tag.

        Source: https://docs.wxpython.org/wx.html.HtmlTag.html
    """
    def GetAllParams(self) -> str:
        """ Returns a string containing all parameters.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    def GetName(self) -> str:
        """ Returns tagâs name.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    def GetParam(self, par, with_quotes=False) -> str:
        """ Returns the value of the parameter.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    def GetParamAsColour(self, par: str) -> tuple:
        """ Interprets tag parameter par  as colour specification and saves its value into   wx.Colour  variable pointed by clr.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    def GetParamAsInt(self, par: str) -> tuple:
        """ Interprets tag parameter par  as an integer and saves its value into int variable pointed by value.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    def GetParamAsString(self, par, value) -> bool:
        """ Get the value of the parameter.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    def HasEnding(self) -> bool:
        """ Returns True if this tag is paired with ending tag, False otherwise.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    def HasParam(self, par: str) -> bool:
        """ Returns True if the tag has a parameter of the given name.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    @staticmethod
    def ParseAsColour(str: str) -> tuple:
        """ Parses the given string as an HTML colour.

            Source: https://docs.wxpython.org/wx.html.HtmlTag.html
        """

    AllParams: str  # See GetAllParams
    Name: str  # See GetName



class HtmlBookRecord:
    """ Helper class for HtmlHelpData.

        Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
    """
    def __init__(self, bookfile, basepath, title, start) -> None:
        """ bookfile (string) â

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def GetBasePath(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def GetBookFile(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def GetContentsEnd(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def GetContentsStart(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def GetFullPath(self, page: str) -> str:
        """ page (string) â

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def GetStart(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def GetTitle(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def SetBasePath(self, path: str) -> None:
        """ path (string) â

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def SetContentsRange(self, start, end) -> None:
        """ start (int) â

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def SetStart(self, start: str) -> None:
        """ start (string) â

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    def SetTitle(self, title: str) -> None:
        """ title (string) â

            Source: https://docs.wxpython.org/wx.html.HtmlBookRecord.html
        """

    BasePath: str  # See GetBasePath and SetBasePath
    BookFile: str  # See GetBookFile
    ContentsEnd: int  # See GetContentsEnd
    ContentsStart: int  # See GetContentsStart
    Start: str  # See GetStart and SetStart
    Title: str  # See GetTitle and SetTitle



class HtmlHelpDataItem:
    """ Helper class for HtmlHelpData.

        Source: https://docs.wxpython.org/wx.html.HtmlHelpDataItem.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDataItem.html
        """

    def GetFullPath(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDataItem.html
        """

    def GetIndentedName(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.html.HtmlHelpDataItem.html
        """

    FullPath: str  # See GetFullPath
    IndentedName: str  # See GetIndentedName
    book: Any  # A public C++ attribute of type HtmlBookRecord     .
    id: Any  # A public C++ attribute of type int.
    level: Any  # A public C++ attribute of type int.
    name: Any  # A public C++ attribute of type string.
    page: Any  # A public C++ attribute of type string.
    parent: Any  # A public C++ attribute of type HtmlHelpDataItem     .



class HtmlRenderingState:
    """ Selection state is passed to HtmlCell.Draw so that it can render
itself differently e.g.

        Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def GetBgColour(self) -> Colour:
        """ Colour

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def GetBgMode(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def GetFgColour(self) -> Colour:
        """ Colour

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def GetSelectionState(self) -> 'html.HtmlSelectionState':
        """ wx.html.HtmlSelectionState

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def SetBgColour(self, c: Union[int, str, 'Colour']) -> None:
        """ c (wx.Colour) â

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def SetBgMode(self, m: int) -> None:
        """ m (int) â

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def SetFgColour(self, c: Union[int, str, 'Colour']) -> None:
        """ c (wx.Colour) â

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    def SetSelectionState(self, s: HtmlSelectionState) -> None:
        """ s (HtmlSelectionState) â

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingState.html
        """

    BgColour: Union[int, str, 'Colour']  # See GetBgColour and SetBgColour
    BgMode: int  # See GetBgMode and SetBgMode
    FgColour: Union[int, str, 'Colour']  # See GetFgColour and SetFgColour
    SelectionState: HtmlSelectionState  # See GetSelectionState and SetSelectionState



class HtmlRenderingStyle:
    """ HtmlSelection is data holder with information about text selection.

        Source: https://docs.wxpython.org/wx.html.HtmlRenderingStyle.html
    """
    def GetSelectedTextBgColour(self, clr: Union[int, str, 'Colour']) -> Colour:
        """ Returns the colour to use for the selected textâs background.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingStyle.html
        """

    def GetSelectedTextColour(self, clr: Union[int, str, 'Colour']) -> Colour:
        """ Returns the colour to use for the selected text.

            Source: https://docs.wxpython.org/wx.html.HtmlRenderingStyle.html
        """



class HtmlWordWithTabsCell(HtmlWordCell):
    """ HtmlWordCell is a specialization for storing text fragments with
embedded tab characters.

        Source: https://docs.wxpython.org/wx.html.HtmlWordWithTabsCell.html
    """
    def __init__(self, word, wordOrig, linepos, dc) -> None:
        """ word (string) â

            Source: https://docs.wxpython.org/wx.html.HtmlWordWithTabsCell.html
        """



HTML_SEL_OUT: int

HTML_SEL_IN: int

HTML_SEL_CHANGING: int

