# -*- coding: utf-8 -*-
from typing import Any, ContextManager, Optional, TypeAlias, Union

from .ActivateEvent import Reason
from .ConfigBase import EntryType
from .DateTime import Country, Month, Tm
from .HelpEvent import Origin
from .StandardPaths import FileLayout
from .StockPreferencesPage import Kind

FontFamily: TypeAlias = int  # Enumeration

FONTFAMILY_DEFAULT: int

FONTFAMILY_DECORATIVE: int

FONTFAMILY_ROMAN: int

FONTFAMILY_SCRIPT: int

FONTFAMILY_SWISS: int

FONTFAMILY_MODERN: int

FONTFAMILY_TELETYPE: int

FONTFAMILY_MAX: int

FONTFAMILY_UNKNOWN: int

FontWeight: TypeAlias = int  # Enumeration

FONTWEIGHT_INVALID: int

FONTWEIGHT_THIN: int

FONTWEIGHT_EXTRALIGHT: int

FONTWEIGHT_LIGHT: int

FONTWEIGHT_NORMAL: int

FONTWEIGHT_MEDIUM: int

FONTWEIGHT_SEMIBOLD: int

FONTWEIGHT_BOLD: int

FONTWEIGHT_EXTRABOLD: int

FONTWEIGHT_HEAVY: int

FONTWEIGHT_EXTRAHEAVY: int

FONTWEIGHT_MAX: int

StockCursor: TypeAlias = int  # Enumeration

CURSOR_NONE: int

CURSOR_ARROW: int

CURSOR_RIGHT_ARROW: int

CURSOR_BULLSEYE: int

CURSOR_CHAR: int

CURSOR_CROSS: int

CURSOR_HAND: int

CURSOR_IBEAM: int

CURSOR_LEFT_BUTTON: int

CURSOR_MAGNIFIER: int

CURSOR_MIDDLE_BUTTON: int

CURSOR_NO_ENTRY: int

CURSOR_PAINT_BRUSH: int

CURSOR_PENCIL: int

CURSOR_POINT_LEFT: int

CURSOR_POINT_RIGHT: int

CURSOR_QUESTION_ARROW: int

CURSOR_RIGHT_BUTTON: int

CURSOR_SIZENESW: int

CURSOR_SIZENS: int

CURSOR_SIZENWSE: int

CURSOR_SIZEWE: int

CURSOR_SIZING: int

CURSOR_SPRAYCAN: int

CURSOR_WAIT: int

CURSOR_WATCH: int

CURSOR_BLANK: int

CURSOR_DEFAULT: int

CURSOR_COPY_ARROW: int

CURSOR_ARROWWAIT: int

CURSOR_MAX: int

StandardID: TypeAlias = int  # Enumeration

ID_AUTO_LOWEST: int

ID_ANY: int

ID_AUTO_HIGHEST: int

ID_NONE: int

ID_SEPARATOR: int

ID_LOWEST: int

ID_OPEN: int

ID_CLOSE: int

ID_NEW: int

ID_SAVE: int

ID_SAVEAS: int

ID_REVERT: int

ID_EXIT: int

ID_UNDO: int

ID_REDO: int

ID_HELP: int

ID_PRINT: int

ID_PRINT_SETUP: int

ID_PAGE_SETUP: int

ID_PREVIEW: int

ID_ABOUT: int

ID_HELP_CONTENTS: int

ID_HELP_INDEX: int

ID_HELP_SEARCH: int

ID_HELP_COMMANDS: int

ID_HELP_PROCEDURES: int

ID_HELP_CONTEXT: int

ID_CLOSE_ALL: int

ID_PREFERENCES: int

ID_EDIT: int

ID_CUT: int

ID_COPY: int

ID_PASTE: int

ID_CLEAR: int

ID_FIND: int

ID_DUPLICATE: int

ID_SELECTALL: int

ID_DELETE: int

ID_REPLACE: int

ID_REPLACE_ALL: int

ID_PROPERTIES: int

ID_VIEW_DETAILS: int

ID_VIEW_LARGEICONS: int

ID_VIEW_SMALLICONS: int

ID_VIEW_LIST: int

ID_VIEW_SORTDATE: int

ID_VIEW_SORTNAME: int

ID_VIEW_SORTSIZE: int

ID_VIEW_SORTTYPE: int

ID_FILE: int

ID_FILE1: int

ID_FILE2: int

ID_FILE3: int

ID_FILE4: int

ID_FILE5: int

ID_FILE6: int

ID_FILE7: int

ID_FILE8: int

ID_FILE9: int

ID_OK: int

ID_CANCEL: int

ID_APPLY: int

ID_YES: int

ID_NO: int

ID_STATIC: int

ID_FORWARD: int

ID_BACKWARD: int

ID_DEFAULT: int

ID_MORE: int

ID_SETUP: int

ID_RESET: int

ID_CONTEXT_HELP: int

ID_YESTOALL: int

ID_NOTOALL: int

ID_ABORT: int

ID_RETRY: int

ID_IGNORE: int

ID_ADD: int

ID_REMOVE: int

ID_UP: int

ID_DOWN: int

ID_HOME: int

ID_REFRESH: int

ID_STOP: int

ID_INDEX: int

ID_BOLD: int

ID_ITALIC: int

ID_JUSTIFY_CENTER: int

ID_JUSTIFY_FILL: int

ID_JUSTIFY_RIGHT: int

ID_JUSTIFY_LEFT: int

ID_UNDERLINE: int

ID_INDENT: int

ID_UNINDENT: int

ID_ZOOM_100: int

ID_ZOOM_FIT: int

ID_ZOOM_IN: int

ID_ZOOM_OUT: int

ID_UNDELETE: int

ID_REVERT_TO_SAVED: int

ID_CDROM: int

ID_CONVERT: int

ID_EXECUTE: int

ID_FLOPPY: int

ID_HARDDISK: int

ID_BOTTOM: int

ID_FIRST: int

ID_LAST: int

ID_TOP: int

ID_INFO: int

ID_JUMP_TO: int

ID_NETWORK: int

ID_SELECT_COLOR: int

ID_SELECT_FONT: int

ID_SORT_ASCENDING: int

ID_SORT_DESCENDING: int

ID_SPELL_CHECK: int

ID_STRIKETHROUGH: int

ID_SYSTEM_MENU: int

ID_CLOSE_FRAME: int

ID_MOVE_FRAME: int

ID_RESIZE_FRAME: int

ID_MAXIMIZE_FRAME: int

ID_ICONIZE_FRAME: int

ID_RESTORE_FRAME: int

ID_MDI_WINDOW_FIRST: int

ID_MDI_WINDOW_CASCADE: int

ID_MDI_WINDOW_TILE_HORZ: int

ID_MDI_WINDOW_TILE_VERT: int

ID_MDI_WINDOW_ARRANGE_ICONS: int

ID_MDI_WINDOW_PREV: int

ID_MDI_WINDOW_NEXT: int

ID_MDI_WINDOW_LAST: int

ID_FILEDLGG: int

ID_FILECTRL: int

ID_HIGHEST: int

FontEncoding: TypeAlias = int  # Enumeration

FONTENCODING_SYSTEM: int

FONTENCODING_DEFAULT: int

FONTENCODING_ISO8859_1: int

FONTENCODING_ISO8859_2: int

FONTENCODING_ISO8859_3: int

FONTENCODING_ISO8859_4: int

FONTENCODING_ISO8859_5: int

FONTENCODING_ISO8859_6: int

FONTENCODING_ISO8859_7: int

FONTENCODING_ISO8859_8: int

FONTENCODING_ISO8859_9: int

FONTENCODING_ISO8859_10: int

FONTENCODING_ISO8859_11: int

FONTENCODING_ISO8859_12: int

FONTENCODING_ISO8859_13: int

FONTENCODING_ISO8859_14: int

FONTENCODING_ISO8859_15: int

FONTENCODING_ISO8859_MAX: int

FONTENCODING_KOI8: int

FONTENCODING_KOI8_U: int

FONTENCODING_ALTERNATIVE: int

FONTENCODING_BULGARIAN: int

FONTENCODING_CP437: int

FONTENCODING_CP850: int

FONTENCODING_CP852: int

FONTENCODING_CP855: int

FONTENCODING_CP866: int

FONTENCODING_CP874: int

FONTENCODING_CP932: int

FONTENCODING_CP936: int

FONTENCODING_CP949: int

FONTENCODING_CP950: int

FONTENCODING_CP1250: int

FONTENCODING_CP1251: int

FONTENCODING_CP1252: int

FONTENCODING_CP1253: int

FONTENCODING_CP1254: int

FONTENCODING_CP1255: int

FONTENCODING_CP1256: int

FONTENCODING_CP1257: int

FONTENCODING_CP1258: int

FONTENCODING_CP1361: int

FONTENCODING_CP12_MAX: int

FONTENCODING_UTF7: int

FONTENCODING_UTF8: int

FONTENCODING_EUC_JP: int

FONTENCODING_UTF16BE: int

FONTENCODING_UTF16LE: int

FONTENCODING_UTF32BE: int

FONTENCODING_UTF32LE: int

FONTENCODING_MACROMAN: int

FONTENCODING_MACJAPANESE: int

FONTENCODING_MACCHINESETRAD: int

FONTENCODING_MACKOREAN: int

FONTENCODING_MACARABIC: int

FONTENCODING_MACHEBREW: int

FONTENCODING_MACGREEK: int

FONTENCODING_MACCYRILLIC: int

FONTENCODING_MACDEVANAGARI: int

FONTENCODING_MACGURMUKHI: int

FONTENCODING_MACGUJARATI: int

FONTENCODING_MACORIYA: int

FONTENCODING_MACBENGALI: int

FONTENCODING_MACTAMIL: int

FONTENCODING_MACTELUGU: int

FONTENCODING_MACKANNADA: int

FONTENCODING_MACMALAJALAM: int

FONTENCODING_MACSINHALESE: int

FONTENCODING_MACBURMESE: int

FONTENCODING_MACKHMER: int

FONTENCODING_MACTHAI: int

FONTENCODING_MACLAOTIAN: int

FONTENCODING_MACGEORGIAN: int

FONTENCODING_MACARMENIAN: int

FONTENCODING_MACCHINESESIMP: int

FONTENCODING_MACTIBETAN: int

FONTENCODING_MACMONGOLIAN: int

FONTENCODING_MACETHIOPIC: int

FONTENCODING_MACCENTRALEUR: int

FONTENCODING_MACVIATNAMESE: int

FONTENCODING_MACARABICEXT: int

FONTENCODING_MACSYMBOL: int

FONTENCODING_MACDINGBATS: int

FONTENCODING_MACTURKISH: int

FONTENCODING_MACCROATIAN: int

FONTENCODING_MACICELANDIC: int

FONTENCODING_MACROMANIAN: int

FONTENCODING_MACCELTIC: int

FONTENCODING_MACGAELIC: int

FONTENCODING_MACKEYBOARD: int

FONTENCODING_ISO2022_JP: int

FONTENCODING_MAX: int

FONTENCODING_MACMIN: int

FONTENCODING_MACMAX: int

FONTENCODING_UTF16: int

FONTENCODING_UTF32: int

FONTENCODING_UNICODE: int

FONTENCODING_GB2312: int

FONTENCODING_BIG5: int

FONTENCODING_SHIFT_JIS: int

FONTENCODING_EUC_KR: int

FONTENCODING_JOHAB: int

FONTENCODING_VIETNAMESE: int

FontStyle: TypeAlias = int  # Enumeration

FONTSTYLE_NORMAL: int

FONTSTYLE_ITALIC: int

FONTSTYLE_SLANT: int

FONTSTYLE_MAX: int

def Abort() -> None:
    """ Exits the program immediately.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def AutoBufferedPaintDCFactory(window: 'Window') -> 'DC':
    """ Check if the window is natively double buffered and will return a   wx.PaintDC  if it is, a   wx.BufferedPaintDC  otherwise.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def BeginBusyCursor(cursor: 'Cursor'=HOURGLASS_CURSOR) -> None:
    """ Changes the cursor to the given cursor for all windows in the application.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Bell() -> None:
    """ Ring the system bell.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def BitmapFromBuffer(width, height, dataBuffer, alphaBuffer=None) -> None:
    """ A compatibility wrapper for wx.Bitmap.FromBuffer and wx.Bitmap.FromBufferAndAlpha

        Source: https://docs.wxpython.org/wx.functions.html
    """


def BitmapFromBufferRGBA(width, height, dataBuffer) -> None:
    """ A compatibility wrapper for wx.Bitmap.FromBufferRGBA

        Source: https://docs.wxpython.org/wx.functions.html
    """


def BitmapFromImage(image) -> None:
    """ A compatibility wrapper for the wx.Bitmap(wx.Image) constructor

        Source: https://docs.wxpython.org/wx.functions.html
    """


def CallAfter(callableObj, *args, **kw) -> None:
    """ Call the specified function after the current and pending event
handlers have been completed.  This is also good for making GUI
method calls from non-GUI threads.  Any extra positional or
keyword args are passed on to the callable when it is called.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def CheckOsVersion(majorVsn, minorVsn=0, microVsn=0) -> bool:
    """ Returns True if the version of the operating system on which the program is running under is the same or later than the given version.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def ClientDisplayRect() -> tuple:
    """ Returns the dimensions of the work area on the display.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def ColourDisplay() -> bool:
    """ Returns True if the display is colour, False otherwise.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def date2pydate(date) -> None:
    """ Convert a DateTime object to a Python datetime.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DateTimeFromDMY(day, month, year=DateTime.Inv_Year, hour=0, minute=0, second=0, millisecond=0) -> None:
    """ Compatibility wrapper for DateTime.FromDMY

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DateTimeFromHMS(hour, minute=0, second=0, millisecond=0) -> None:
    """ Compatibility wrapper for DateTime.FromHMS

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DateTimeFromJDN(jdn) -> None:
    """ Compatibility wrapper for DateTime.FromJDN

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DateTimeFromTimeT(timet) -> None:
    """ Compatibility wrapper for DateTime.FromTimeT

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DecToHex(*args, **kw) -> None:
    """ Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DirSelector(message=DirSelectorPromptStr, default_path="", style=0, pos=DefaultPosition, parent=None) -> str:
    """ Pops up a directory selector dialog.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DisableAsserts() -> None:
    """ Disable the condition checks in the assertions.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DisplayDepth() -> int:
    """ Returns the depth of the display (a value of 1 denotes a monochrome display).

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DisplaySize() -> tuple:
    """ Returns the display size in pixels.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DisplaySizeMM() -> tuple:
    """ Returns the display size in millimeters.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def DumpWindow(window: 'Window') -> str:
    """ Return a string with human-readable platform-specific description of the window useful for diagnostic purposes.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def EmptyBitmap(width, height, depth=BITMAP_SCREEN_DEPTH) -> None:
    """ A compatibility wrapper for the wx.Bitmap(width, height, depth) constructor

        Source: https://docs.wxpython.org/wx.functions.html
    """


def EmptyBitmapRGBA(width, height, red=0, green=0, blue=0, alpha=0) -> None:
    """ A compatibility wrapper for wx.Bitmap.FromRGBA

        Source: https://docs.wxpython.org/wx.functions.html
    """


def EmptyIcon() -> None:
    """ A compatibility wrapper for the Icon constructor

        Source: https://docs.wxpython.org/wx.functions.html
    """


def EmptyImage(width=0, height=0, clear=True) -> None:
    """ A compatibility wrapper for the wx.Image(width, height) constructor

        Source: https://docs.wxpython.org/wx.functions.html
    """


def EnableTopLevelWindows(enable: bool=True) -> None:
    """ This function enables or disables all top level windows.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def EndBusyCursor() -> None:
    """ Changes the cursor back to the original cursor, for all windows in the application.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Execute(command, flags=EXEC_ASYNC, callback=None, env=None) -> int:
    """ Executes another program in Unix or Windows.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Exit() -> None:
    """ Exits application after calling wx.App.OnExit .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FFont(pointSize, family, flags=FONTFLAG_DEFAULT, faceName="", encoding=FONTENCODING_DEFAULT) -> None:
    """ 

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FileSelector(message, default_path="", default_filename="", default_extension="", wildcard=FileSelectorDefaultWildcardStr, flags=0, parent=None, x=DefaultCoord, y=DefaultCoord) -> str:
    """ Pops up a file selector box.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FileSelectorEx(message=FileSelectorPromptStr, default_path="", default_filename="", indexDefaultExtension=None, wildcard=FileSelectorDefaultWildcardStr, flags=0, parent=None, x=DefaultCoord, y=DefaultCoord) -> str:
    """ An extended version of wx.FileSelector

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FindMenuItemId(frame, menuString, itemString) -> int:
    """ Find a menu item identifier associated with the given frameâs menu bar.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FindWindowAtPoint(pt: Union[tuple[int, int], 'Point']) -> 'Window':
    """ Find the deepest window at the given mouse position in screen coordinates, returning the window if found, or None if not.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FindWindowAtPointer() -> tuple:
    """ Find the deepest window at the mouse pointer position, returning the window and current pointer position in screen coordinates.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FindWindowById(id, parent=None) -> 'Window':
    """ FindWindowById(id, parent=None) . Window

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FindWindowByLabel(label, parent=None) -> 'Window':
    """ Find a window by its label. Depending on the type of window, the label may be a window title or panel item label. If parent  is None, the search will start from all top-level frames and dialog boxes; if not None, the search will be limited to the given window hierarchy. The search is recursive in both cases.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def FindWindowByName(name, parent=None) -> 'Window':
    """ Find a window by its name (as given in a window constructor or Create  function call). If parent  is None, the search will start from all top-level frames and dialog boxes; if not None, the search will be limited to the given window hierarchy. The search is recursive in both cases.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetAccelFromString(label) -> None:
    """ 

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetActiveWindow() -> 'Window':
    """ Gets the currently active window (implemented for MSW and GTK only currently, always returns None in the other ports).

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetApp() -> 'App':
    """ Returns the current application object.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetBatteryState() -> 'BatteryState':
    """ Returns battery state as one of  BATTERY_NORMAL_STATE ,   BATTERY_LOW_STATE ,   BATTERY_CRITICAL_STATE ,   BATTERY_SHUTDOWN_STATE   or   BATTERY_UNKNOWN_STATE .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetClientDisplayRect() -> 'Rect':
    """ Returns the dimensions of the work area on the display.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetColourFromUser(parent, colInit, caption="", data=None) -> 'Colour':
    """ Shows the colour selection dialog and returns the colour selected by user or invalid colour (use wx.Colour.IsOk   to test whether a colour is valid) if the dialog was cancelled.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetCpuArchitectureName() -> str:
    """ Returns the CPU architecture name.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetDisplayPPI() -> 'Size':
    """ Returns the display resolution in pixels per inch.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetDisplaySize() -> 'Size':
    """ Returns the display size in pixels.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetDisplaySizeMM() -> 'Size':
    """ Returns the display size in millimeters.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetEmailAddress() -> str:
    """ Copies the userâs email address into the supplied buffer, by concatenating the values returned by wx.GetFullHostName       and wx.GetUserId     .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetFontFromUser(parent, fontInit, caption="") -> 'Font':
    """ Shows the font selection dialog and returns the font selected by user or invalid font (use wx.Font.IsOk   to test whether a font is valid) if the dialog was cancelled.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetFullHostName() -> str:
    """ Returns the FQDN (fully qualified domain host name) or an empty string on error.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetHomeDir() -> str:
    """ Return the (current) userâs home directory.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetHostName() -> str:
    """ Copies the current host machineâs name into the supplied buffer.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetKeyState(key: KeyCode) -> bool:
    """ For normal keys, returns True if the specified key is currently down.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetLibraryVersionInfo() -> 'VersionInfo':
    """ Get wxWidgets version information.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetLocale() -> 'Locale':
    """ Get the current locale object (note that it may be None!)

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetMousePosition() -> 'Point':
    """ Returns the mouse position in screen coordinates.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetMouseState() -> 'MouseState':
    """ Returns the current state of the mouse.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetNativeCpuArchitectureName() -> str:
    """ In some situations the current process and native CPU architecture may be different.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetNumberFromUser(message, prompt, caption, value, min=0, max=100, parent=None, pos=DefaultPosition) -> int:
    """ Shows a dialog asking the user for numeric input.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetOsDescription() -> str:
    """ Returns the string containing the description of the current platform in a user-readable form.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetOsVersion(micro: Optional[int]=None) -> tuple:
    """ Gets the version and the operating system ID for currently running OS.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetPasswordFromUser(message, caption=GetPasswordFromUserPromptStr, default_value="", parent=None, x=DefaultCoord, y=DefaultCoord, centre=True) -> str:
    """ Similar to wx.GetTextFromUser       but the text entered in the dialog is not shown on screen but replaced with stars.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetPowerType() -> 'PowerType':
    """ Returns the type of power source as one of  POWER_SOCKET ,   POWER_BATTERY   or   POWER_UNKNOWN .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetProcessId() -> int:
    """ Returns the number uniquely identifying the current process in the system.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetSingleChoice(*args, **kw) -> str:
    """ Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetStockLabel(id, flags=STOCK_WITH_MNEMONIC) -> str:
    """ Returns label that should be used for given id  element.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetTextFromUser(message, caption=GetTextFromUserPromptStr, default_value="", parent=None, x=DefaultCoord, y=DefaultCoord, centre=True) -> str:
    """ Pop up a dialog box with title set to caption,  message , and a   default_value .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetTopLevelParent(window: 'Window') -> 'Window':
    """ Returns the first top level parent of the given window, or in other words, the frame or dialog containing it, or None.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetTopLevelWindows() -> 'WindowList':
    """ Returns a list-like object of the the applicationâs top-level windows, (frames,dialogs, etc.)

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetTranslation(*args, **kw) -> str:
    """ Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetUserHome(user: str="") -> str:
    """ Returns the home directory for the given user.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetUserId() -> str:
    """ This function returns the âuser idâ also known as âlogin nameâ under Unix (i.e.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def GetUserName() -> str:
    """ This function returns the full user name (something like âMr. John Smithâ).

        Source: https://docs.wxpython.org/wx.functions.html
    """


def HandleFatalExceptions(doIt: bool=True) -> bool:
    """ If doIt  is True, the fatal exceptions (also known as general protection faults under Windows or segmentation violations in the Unix world) will be caught and passed to wx.App.OnFatalException .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def HelpController(parentWindow=None) -> None:
    """ Rather than being an alias for some class, the Python version of
HelpController is a factory function that creates and returns an
instance of the best Help Controller for the platform.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def HexToDec(*args, **kw) -> int:
    """ Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.functions.html
    """


def ImageFromBitmap(bitmap) -> None:
    """ Create a Image from a wx.Bitmap

        Source: https://docs.wxpython.org/wx.functions.html
    """


def ImageFromBuffer(width, height, dataBuffer, alphaBuffer=None) -> None:
    """ Creates a Image from the data in dataBuffer.  The dataBuffer
parameter must be a Python object that implements the buffer interface,
such as a string, array, etc.  The dataBuffer object is expected to
contain a series of RGB bytes and be width*height*3 bytes long.  A buffer
object can optionally be supplied for the imageâs alpha channel data, and
it is expected to be width*height bytes long.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def ImageFromData(width, height, data) -> None:
    """ Compatibility wrapper for creating an image from RGB data

        Source: https://docs.wxpython.org/wx.functions.html
    """


def ImageFromDataWithAlpha(width, height, data, alpha) -> None:
    """ Compatibility wrapper for creating an image from RGB and Alpha data

        Source: https://docs.wxpython.org/wx.functions.html
    """


def ImageFromStream(stream, type=BITMAP_TYPE_ANY, index=-1) -> None:
    """ Load an image from a stream (file-like object)

        Source: https://docs.wxpython.org/wx.functions.html
    """


def InfoMessageBox(parent: 'Window') -> None:
    """ Shows a message box with the information about the wxWidgets build used, including its version, most important build parameters and the version of the underlying GUI toolkit.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def InitAllImageHandlers() -> None:
    """ Initializes all available image handlers.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def IntersectRect(r1, r2) -> Any:
    """ Calculate and return the intersection of r1 and r2.  Returns None if there
is no intersection.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def IsBusy() -> bool:
    """ Returns True if between two wx.BeginBusyCursor       and wx.EndBusyCursor       calls.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def IsDragResultOk(res: DragResult) -> bool:
    """ Returns True if res indicates that something was done during a DnD operation, i.e.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def IsMainThread() -> bool:
    """ Returns True if the current thread is what  considers the GUI thread.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def IsPlatform64Bit() -> bool:
    """ Returns True if the operating system the program is running under is 64 bit.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def IsPlatformLittleEndian() -> bool:
    """ Returns True if the current platform is little endian (instead of big endian).

        Source: https://docs.wxpython.org/wx.functions.html
    """


def IsRunningUnderWine() -> bool:
    """ Returns True only for MSW programs running under Wine.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Kill(pid, sig=SIGTERM, rc=None, flags=KILL_NOCHILDREN) -> int:
    """ Equivalent to the Unix kill function: send the given signal sig  to the process with PID pid.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LaunchDefaultApplication(document, flags=0) -> bool:
    """ Opens the document  in the application associated with the files of this type.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LaunchDefaultBrowser(url, flags=0) -> bool:
    """ Opens the url  in userâs default browser.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LoadFileSelector(what, extension, default_name="", parent=None) -> str:
    """ Shows a file dialog asking the user for a file name for opening a file.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogDebug(message: str) -> None:
    """ The right functions for debug output.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogError(message: str) -> None:
    """ The functions to use for error messages, i.e.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogFatalError(message: str) -> None:
    """ Like wx.LogError     , but also terminates the program with the exit code 3.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogGeneric(level, message) -> None:
    """ Logs a message with the given LogLevel.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogInfo(formatString) -> None:
    """ For low priority messages.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogMessage(message: str) -> None:
    """ For all normal, informational messages.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogStatus(*args, **kw) -> None:
    """ Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogSysError(message: str) -> None:
    """ Mostly used by wxWidgets itself, but might be handy for logging errors after system call (API function) failure.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogVerbose(message: str) -> None:
    """ For verbose output.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def LogWarning(message: str) -> None:
    """ For warnings - they are also normally shown to the user, but donât interrupt the program work.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def MacThemeColour(themeBrushID) -> 'Colour':
    """ wx.Colour

        Source: https://docs.wxpython.org/wx.functions.html
    """


def MessageBox(message, caption=MessageBoxCaptionStr, style=OK|CENTRE, parent=None, x=DefaultCoord, y=DefaultCoord) -> int:
    """ Show a general purpose message dialog.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def MicroSleep(microseconds: int) -> None:
    """ Sleeps for the specified number of microseconds.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def MilliSleep(milliseconds: int) -> None:
    """ Sleeps for the specified number of milliseconds.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def NewEventType() -> int:
    """ Generates a new unique event type.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def NewId() -> int:
    """ Generates an integer identifier unique to this run of the program.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def NewIdRef(count=1) -> int:
    """ Reserves a new Window ID (or range of WindowIDs) and returns a
wx.WindowIDRef object (or list of them) that will help
manage the reservation of that ID.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Now() -> str:
    """ Returns a string representing the current date and time.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def PostEvent(dest, event) -> None:
    """ In a GUI application, this function posts event  to the specified dest  object using wx.EvtHandler.AddPendingEvent .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def pydate2wxdate(date) -> None:
    """ Convert a Python date or datetime to a DateTime object

        Source: https://docs.wxpython.org/wx.functions.html
    """


def QueueEvent(dest, event) -> None:
    """ Queue an event for processing on the given object.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def RegisterId(id: int) -> None:
    """ Ensures that Ids subsequently generated by wx.NewId       do not clash with the given id.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SafeShowMessage(title, text) -> bool:
    """ This function shows a message to the user in a safe way and should be safe to call even before the application has been initialized or if it is currently in some other strange state (for example, about to crash).

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SafeYield(win=None, onlyIfNeeded=False) -> bool:
    """ Calls wx.App.SafeYield .

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SaveFileSelector(what, extension, default_name="", parent=None) -> str:
    """ Shows a file dialog asking the user for a file name for saving a file.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SecureZeroMemory(p, n) -> None:
    """ Fills the memory block with zeros in a way that is guaranteed not to be optimized away by the compiler.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SetCursor(cursor: 'Cursor') -> None:
    """ Globally sets the cursor; only has an effect on Windows, Mac and GTK+.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Shell(command: str="") -> bool:
    """ Executes a command in an interactive shell window.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Shutdown(flags: int=SHUTDOWN_POWEROFF) -> bool:
    """ This function shuts down or reboots the computer depending on the value of the flags.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Sleep(secs: int) -> None:
    """ Sleeps for the specified number of seconds.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def StripMenuCodes(str, flags=Strip_All) -> str:
    """ Strips any menu codes from str  and returns the result.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SysErrorCode() -> int:
    """ Returns the error code from the last system call.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SysErrorMsg(errCode: int=0) -> str:
    """ Returns the error message corresponding to the given system error code.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def SysErrorMsgStr(errCode: int=0) -> str:
    """ Returns the error message corresponding to the given system error code.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Trap() -> None:
    """ Generate a debugger exception meaning that the control is passed to the debugger if one is attached to the process.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def version() -> str:
    """ Returns a string containing version and port info

        Source: https://docs.wxpython.org/wx.functions.html
    """


def WakeUpIdle() -> None:
    """ This function wakes up the (internal and platform dependent) idle system, i.e.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def Yield() -> bool:
    """ Calls wx.AppConsole.Yield   if there is an existing application object.

        Source: https://docs.wxpython.org/wx.functions.html
    """


def YieldIfNeeded() -> None:
    """ Convenience function for wx.GetApp().Yield(True)

        Source: https://docs.wxpython.org/wx.functions.html
    """


KILL_CHILDREN: int

EXEC_ASYNC: int

EXEC_SYNC: int

EXEC_SHOW_CONSOLE: int

EXEC_HIDE_CONSOLE: int

EXEC_MAKE_GROUP_LEADER: int

EXEC_NODISABLE: int

EXEC_NOEVENTS: int

EXEC_BLOCK: int

FD_OPEN: int

FD_SAVE: int

FD_OVERWRITE_PROMPT: int

FD_FILE_MUST_EXIST: int

FD_MULTIPLE: int

OK: int

KILL_NOCHILDREN: int

_MenuItem: TypeAlias = MenuItem

class AcceleratorEntry:
    """ An object used by an application wishing to create an accelerator
table (see AcceleratorTable).

        Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def FromString(self, str: str) -> bool:
        """ Parses the given string and sets the accelerator accordingly.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def GetCommand(self) -> int:
        """ Returns the command identifier for the accelerator table entry.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def GetFlags(self) -> int:
        """ Returns the flags for the accelerator table entry.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def GetKeyCode(self) -> int:
        """ Returns the keycode for the accelerator table entry.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def GetMenuItem(self) -> 'MenuItem':
        """ Returns the menu item associated with this accelerator entry.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def IsOk(self) -> bool:
        """ Returns True if this object is correctly initialized.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def Set(self, flags, keyCode, cmd, item=None) -> None:
        """ Sets the accelerator entry parameters.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def ToRawString(self) -> str:
        """ Returns a textual representation of this accelerator which is appropriate for saving in configuration files.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def ToString(self) -> str:
        """ Returns a textual representation of this accelerator.

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def __ne__(self, item: Any) -> bool:
        """ entry (wx.AcceleratorEntry) â

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    def __eq__(self, item: Any) -> bool:
        """ entry (wx.AcceleratorEntry) â

            Source: https://docs.wxpython.org/wx.AcceleratorEntry.html
        """

    Command: int  # See GetCommand
    Flags: int  # See GetFlags
    KeyCode: int  # See GetKeyCode
    MenuItem: '_MenuItem'  # See GetMenuItem



class AcceleratorTable(Object):
    """ An accelerator table allows the application to specify a table of
keyboard shortcuts for menu or button commands.

        Source: https://docs.wxpython.org/wx.AcceleratorTable.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AcceleratorTable.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the accelerator table is valid.

            Source: https://docs.wxpython.org/wx.AcceleratorTable.html
        """



_Window: TypeAlias = Window

class Accessible(Object):
    """ The Accessible class allows wxWidgets applications, and wxWidgets
itself, to return extended information about user interface elements
to client applications such as screen readers.

        Source: https://docs.wxpython.org/wx.Accessible.html
    """
    def __init__(self, win: Optional['Window']=None) -> None:
        """ Constructor, taking an optional window.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def DoDefaultAction(self, childId: int) -> int:
        """ Performs the default action for the object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetChild(self, childId: int) -> tuple:
        """ Gets the specified child (starting from 1).

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetChildCount(self) -> tuple:
        """ Returns the number of children in childCount.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetDefaultAction(self, childId: int) -> tuple:
        """ Gets the default action for this object (0) or a child (greater than 0).

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetDescription(self, childId: int) -> tuple:
        """ Returns the description for this object or a child.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetFocus(self, childId: int) -> tuple:
        """ Gets the window with the keyboard focus.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetHelpText(self, childId: int) -> tuple:
        """ Returns help text for this object or a child, similar to tooltip text.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetKeyboardShortcut(self, childId: int) -> tuple:
        """ Returns the keyboard shortcut for this object or child.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetLocation(self, elementId: int) -> tuple:
        """ Returns the rectangle for this object (id is 0) or a child element (id is greater than 0).

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetName(self, childId: int) -> tuple:
        """ Gets the name of the specified object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetParent(self) -> tuple:
        """ Returns the parent of this object, or None.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetRole(self, childId: int) -> tuple:
        """ Returns a role constant describing this object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetSelections(self) -> tuple:
        """ Gets a variant representing the selected children of this object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetState(self, childId: int) -> tuple:
        """ Returns a state constant.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetValue(self, childId: int) -> tuple:
        """ Returns a localized string representing the value for the object or child.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def GetWindow(self) -> 'Window':
        """ Returns the window associated with this object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def HitTest(self, pt, childId, childObject) -> int:
        """ Returns a status value and object id to indicate whether the given point was on this or a child object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def Navigate(self, navDir, fromId, toId, toObject) -> int:
        """ Navigates from fromId  to toId  or to toObject.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    @staticmethod
    def NotifyEvent(eventType, window, objectType, objectId) -> None:
        """ Allows the application to send an event when something changes in an accessible object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def Select(self, childId, selectFlags) -> int:
        """ Selects the object or child.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    def SetWindow(self, window: 'Window') -> None:
        """ Sets the window associated with this object.

            Source: https://docs.wxpython.org/wx.Accessible.html
        """

    Window: '_Window'  # See GetWindow and SetWindow



ACC_NOT_SUPPORTED: int

ACC_OK: int

class ActivateEvent(Event):
    """ An activate event is sent when a window or application is being
activated or deactivated.

        Source: https://docs.wxpython.org/wx.ActivateEvent.html
    """
    def __init__(self, eventType=wxEVT_NULL, active=True, id=0, ActivationReason=Reason_Unknown) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ActivateEvent.html
        """

    def GetActivationReason(self) -> 'Reason':
        """ Allows checking if the window was activated by clicking it with the mouse or in some other way.

            Source: https://docs.wxpython.org/wx.ActivateEvent.html
        """

    def GetActive(self) -> bool:
        """ Returns True if the application or window is being activated, False otherwise.

            Source: https://docs.wxpython.org/wx.ActivateEvent.html
        """

    Active: bool  # See GetActive



EVT_ACTIVATE: int  # Process a  wxEVT_ACTIVATE   event.

EVT_ACTIVATE_APP: int  # Process a  wxEVT_ACTIVATE_APP   event. This event is received by the App-derived instance only.

EVT_HIBERNATE: int  # Process a hibernate event, supplying the member function. This event applies to   wx.App  only, and only on Windows SmartPhone and PocketPC. It is generated when the system is low on memory; the application should free up as much memory as possible, and restore full working state when it receives a  wxEVT_ACTIVATE   or   wxEVT_ACTIVATE_APP   event. ^^

class ActivityIndicator(Control):
    """ Small control showing an animation indicating that the program is
currently busy performing some background task.

        Source: https://docs.wxpython.org/wx.ActivityIndicator.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ActivityIndicator.html
        """

    def Create(self, parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name="activityindicator") -> bool:
        """ Create the control initialized using the default constructor.

            Source: https://docs.wxpython.org/wx.ActivityIndicator.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ActivityIndicator.html
        """

    def IsRunning(self) -> bool:
        """ Returns True if the control is currently showing activity.

            Source: https://docs.wxpython.org/wx.ActivityIndicator.html
        """

    def Start(self) -> None:
        """ Starts animation of the indicator.

            Source: https://docs.wxpython.org/wx.ActivityIndicator.html
        """

    def Stop(self) -> None:
        """ Stops the animation of the indicator.

            Source: https://docs.wxpython.org/wx.ActivityIndicator.html
        """



class AffineMatrix2D(AffineMatrix2DBase):
    """ A 3x2 matrix representing an affine 2D transformation.

        Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Concat(self, t: 'AffineMatrix2DBase') -> None:
        """ Concatenate this matrix with another one.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Get(self) -> tuple:
        """ Get the component values of the matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Invert(self) -> bool:
        """ Invert this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def IsEqual(self, t: 'AffineMatrix2DBase') -> None:
        """ Check that this matrix is identical with t.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def IsIdentity(self) -> bool:
        """ Check if this is the identity matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Mirror(self, direction: int=HORIZONTAL) -> None:
        """ Add mirroring to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Rotate(self, cRadians: 'Double') -> None:
        """ Add clockwise rotation to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Scale(self, xScale, yScale) -> None:
        """ Add scaling to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Set(self, mat2D, tr) -> None:
        """ Set all elements of this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def TransformDistance(self, *args, **kw) -> 'Point2DDouble':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def TransformPoint(self, *args, **kw) -> 'Point2DDouble':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def Translate(self, dx, dy) -> None:
        """ Add the translation to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Check that this matrix differs from t.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Check that this matrix is identical with t.

            Source: https://docs.wxpython.org/wx.AffineMatrix2D.html
        """



HORIZONTAL: int

VERTICAL: int

BOTH: int

class AffineMatrix2DBase:
    """ A 2x3 matrix representing an affine 2D transformation.

        Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Concat(self, t: 'AffineMatrix2DBase') -> None:
        """ Concatenate this matrix with another one.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Get(self) -> tuple:
        """ Get the component values of the matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Invert(self) -> bool:
        """ Invert this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def IsEqual(self, t: 'AffineMatrix2DBase') -> bool:
        """ Check that this matrix is identical with t.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def IsIdentity(self) -> bool:
        """ Check if this is the identity matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Mirror(self, direction: int=HORIZONTAL) -> None:
        """ Add mirroring to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Rotate(self, cRadians: 'Double') -> None:
        """ Add clockwise rotation to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Scale(self, xScale, yScale) -> None:
        """ Add scaling to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Set(self, mat2D, tr) -> None:
        """ Set all elements of this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def TransformDistance(self, *args, **kw) -> 'Point2DDouble':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def TransformPoint(self, *args, **kw) -> 'Point2DDouble':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def Translate(self, dx, dy) -> None:
        """ Add the translation to this matrix.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Check that this matrix differs from t.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Check that this matrix is identical with t.

            Source: https://docs.wxpython.org/wx.AffineMatrix2DBase.html
        """



class AlphaPixelData:
    """ A class providing direct access to a wx.Bitmapâs
internal data including the alpha channel (RGBA).

        Source: https://docs.wxpython.org/wx.AlphaPixelData.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AlphaPixelData.html
        """

    def GetPixels(self) -> 'AlphaPixelData_Accessor':
        """ wx.AlphaPixelData_Accessor

            Source: https://docs.wxpython.org/wx.AlphaPixelData.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.AlphaPixelData.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.AlphaPixelData.html
        """

    Pixels: 'AlphaPixelData_Accessor'  # See GetPixels



_Mask: TypeAlias = Mask

_Palette: TypeAlias = Palette

_Size: TypeAlias = Size

class Bitmap(GDIObject):
    """ This class encapsulates the concept of a platform-dependent bitmap,
either monochrome or colour or colour with alpha channel support.

        Source: https://docs.wxpython.org/wx.Bitmap.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def ConvertToDisabled(self, brightness: int=255) -> 'Bitmap':
        """ Returns disabled (dimmed) version of the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def ConvertToImage(self) -> 'Image':
        """ Creates an image from a platform-dependent bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def CopyFromBuffer(self, data, format=BitmapBufferFormat_RGB, stride=-1) -> None:
        """ Copy data from a buffer object to replace the bitmap pixel data.
Default format is plain RGB, but other formats are now supported as
well.  The following symbols are used to specify the format of the
bytes in the buffer:

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def CopyFromIcon(self, icon: 'Icon') -> bool:
        """ Creates the bitmap from an icon.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def CopyToBuffer(self, data, format=BitmapBufferFormat_RGB, stride=-1) -> None:
        """ Copy pixel data to a buffer object.  See CopyFromBuffer for buffer
format details.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def Create(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def CreateScaled(self, width, height, depth, logicalScale) -> bool:
        """ Create a bitmap with a scale factor.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def CreateWithDIPSize(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    @staticmethod
    def FromBuffer(width, height, data) -> 'Bitmap':
        """ Creates a wx.Bitmap from in-memory data.  The data parameter
must be a Python object that implements the buffer interface, such
as a string, bytearray, etc.  The data object is expected to contain
a series of RGB bytes and be at least (widthÂ  heightÂ  3) bytes long.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    @staticmethod
    def FromBufferAndAlpha(width, height, data, alpha) -> 'Bitmap':
        """ Creates a wx.Bitmap from in-memory data.  The data and alpha
parameters must be a Python object that implements the buffer
interface, such as a string, bytearray, etc.  The data object
is expected to contain a series of RGB bytes and be at least
(widthÂ  heightÂ  3) bytes long, while the alpha object is expected
to be (widthÂ  height) bytes long and represents the imageâs alpha
channel.  On Windows and Mac the RGB values will be
âpremultipliedâ by the alpha values.  (The other platforms do
the multiplication themselves.)

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    @staticmethod
    def FromBufferRGBA(width, height, data) -> 'Bitmap':
        """ Creates a wx.Bitmap from in-memory data.  The data parameter
must be a Python object that implements the buffer interface, such
as a string, bytearray, etc.  The data object is expected to contain
a series of RGBA bytes and be at least (widthÂ  heightÂ  4) bytes long.
On Windows and Mac the RGB values will be âpremultipliedâ by the
alpha values.  (The other platforms do the multiplication themselves.)

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    @staticmethod
    def FromPNGData(data) -> 'Bitmap':
        """ Like NewFromPNGData, but with a simpler API accepting a Python
buffer-compatible object.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    @staticmethod
    def FromRGBA(width, height, red=0, green=0, blue=0, alpha=0) -> 'Bitmap':
        """ Creates a new empty 32-bit wx.Bitmap where every pixel has been
initialized with the given RGBA values.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetDIPSize(self) -> 'Size':
        """ Returns the size of bitmap in DPI-independent units.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetDepth(self) -> int:
        """ Gets the colour depth of the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetHandle(self) -> int:
        """ MSW-only method to fetch the windows handle for the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetHeight(self) -> int:
        """ Returns the height of the bitmap in physical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetLogicalHeight(self) -> float:
        """ Returns the height of the bitmap in logical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetLogicalSize(self) -> 'Size':
        """ Returns the size of the bitmap in logical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetLogicalWidth(self) -> float:
        """ Returns the width of the bitmap in logical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetMask(self) -> 'Mask':
        """ Gets the associated mask (if any) which may have been loaded from a file or set for the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetPalette(self) -> 'Palette':
        """ Gets the associated palette (if any) which may have been loaded from a file or set for the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetScaleFactor(self) -> float:
        """ Returns the scale factor of this bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetScaledHeight(self) -> float:
        """ Returns the height of the bitmap in logical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetScaledSize(self) -> 'Size':
        """ Returns the size of the bitmap in logical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetScaledWidth(self) -> float:
        """ Returns the width of the bitmap in logical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetSize(self) -> 'Size':
        """ Returns the size of the bitmap in physical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetSubBitmap(self, rect: 'Rect') -> 'Bitmap':
        """ Returns a sub bitmap of the current one as long as the rect belongs entirely to the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def GetWidth(self) -> int:
        """ Returns the width of the bitmap in physical pixels.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def HasAlpha(self) -> bool:
        """ Returns True if the bitmap has an alpha channel.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def IsOk(self) -> bool:
        """ Returns True if bitmap data is present.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def LoadFile(self, name, type=BITMAP_TYPE_ANY) -> bool:
        """ Loads a bitmap from a file or resource.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    @staticmethod
    def NewFromPNGData(data, size) -> 'Bitmap':
        """ Loads a bitmap from the memory containing image data in PNG format.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    @staticmethod
    def Rescale(bmp, sizeNeeded) -> None:
        """ Rescale the given bitmap to the requested size.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def ResetAlpha(self) -> None:
        """ Remove alpha channel from the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SaveFile(self, name, type, palette=None) -> bool:
        """ Saves a bitmap in the named file.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetDepth(self, depth: int) -> None:
        """ Sets the depth member (does not affect the bitmap data).

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetHandle(self, handle) -> None:
        """ MSW-only method to set the windows handle for the bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetHeight(self, height: int) -> None:
        """ Sets the height member (does not affect the bitmap data).

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetMask(self, mask: 'Mask') -> None:
        """ Sets the mask for this bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetMaskColour(self, colour) -> None:
        """ Create a mask for this bitmap based on the pixels with the given colour.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetPalette(self, palette: 'Palette') -> None:
        """ Sets the associated palette.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetScaleFactor(self, scale: float) -> None:
        """ Sets the bitmap scale factor.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetSize(self, size) -> None:
        """ Set the bitmap size (does not alter the existing native bitmap data or image size).

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def SetWidth(self, width: int) -> None:
        """ Sets the width member (does not affect the bitmap data).

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def UseAlpha(self, use: bool=True) -> None:
        """ Enable or disable use of alpha channel in this bitmap.

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Bitmap.html
        """

    DIPSize: 'Size'  # See GetDIPSize
    Depth: int  # See GetDepth and SetDepth
    Handle: int  # See GetHandle and SetHandle
    Height: int  # See GetHeight and SetHeight
    LogicalHeight: float  # See GetLogicalHeight
    LogicalSize: 'Size'  # See GetLogicalSize
    LogicalWidth: float  # See GetLogicalWidth
    Mask: '_Mask'  # See GetMask and SetMask
    Palette: '_Palette'  # See GetPalette and SetPalette
    ScaleFactor: float  # See GetScaleFactor and SetScaleFactor
    ScaledHeight: float  # See GetScaledHeight
    ScaledSize: 'Size'  # See GetScaledSize
    ScaledWidth: float  # See GetScaledWidth
    Size: '_Size'  # See GetSize and SetSize
    Width: int  # See GetWidth and SetWidth



ALPHA_OPAQUE: int

class AlphaPixelData_Accessor:
    """  Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def Get(self) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def IsOk(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def MoveTo(self, data, x, y) -> None:
        """ data (AlphaPixelData) â

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def Offset(self, data, x, y) -> None:
        """ data (AlphaPixelData) â

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def OffsetX(self, data, x) -> None:
        """ data (AlphaPixelData) â

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def OffsetY(self, data, y) -> None:
        """ data (AlphaPixelData) â

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def Reset(self, data: AlphaPixelData) -> None:
        """ data (AlphaPixelData) â

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def Set(self, red, green, blue, alpha) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """

    def nextPixel(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.AlphaPixelData_Accessor.html
        """



_Bitmap: TypeAlias = Bitmap

class AnyButton(Control):
    """ A class for common button functionality used as the base for the
various button classes.

        Source: https://docs.wxpython.org/wx.AnyButton.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def GetBitmap(self) -> 'Bitmap':
        """ Return the bitmap shown by the button.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def GetBitmapCurrent(self) -> 'Bitmap':
        """ Returns the bitmap used when the mouse is over the button.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def GetBitmapDisabled(self) -> 'Bitmap':
        """ Returns the bitmap used for the disabled state.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def GetBitmapFocus(self) -> 'Bitmap':
        """ Returns the bitmap used for the focused state.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def GetBitmapLabel(self) -> 'Bitmap':
        """ Returns the bitmap for the normal state.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def GetBitmapMargins(self) -> 'Size':
        """ Get the margins between the bitmap and the text of the button.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def GetBitmapPressed(self) -> 'Bitmap':
        """ Returns the bitmap used when the button is pressed.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmap(self, bitmap, dir=LEFT) -> None:
        """ Sets the bitmap to display in the button.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmapCurrent(self, bitmap: 'BitmapBundle') -> None:
        """ Sets the bitmap to be shown when the mouse is over the button.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmapDisabled(self, bitmap: 'BitmapBundle') -> None:
        """ Sets the bitmap for the disabled button appearance.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmapFocus(self, bitmap: 'BitmapBundle') -> None:
        """ Sets the bitmap for the button appearance when it has the keyboard focus.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmapLabel(self, bitmap: 'BitmapBundle') -> None:
        """ Sets the bitmap label for the button.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmapMargins(self, *args, **kw) -> None:
        """ Set the margins between the bitmap and the text of the button.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmapPosition(self, dir: int) -> None:
        """ Set the position at which the bitmap is displayed.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    def SetBitmapPressed(self, bitmap: 'BitmapBundle') -> None:
        """ Sets the bitmap for the selected (depressed) button appearance.

            Source: https://docs.wxpython.org/wx.AnyButton.html
        """

    Bitmap: '_Bitmap'  # See GetBitmap and SetBitmap
    BitmapCurrent: 'Bitmap'  # See GetBitmapCurrent and SetBitmapCurrent
    BitmapDisabled: 'Bitmap'  # See GetBitmapDisabled and SetBitmapDisabled
    BitmapFocus: 'Bitmap'  # See GetBitmapFocus and SetBitmapFocus
    BitmapLabel: 'Bitmap'  # See GetBitmapLabel and SetBitmapLabel
    BitmapMargins: 'Size'  # See GetBitmapMargins and SetBitmapMargins
    BitmapPressed: 'Bitmap'  # See GetBitmapPressed and SetBitmapPressed



RIGHT: int

TOP: int

BOTTOM: int

LEFT: int

class App(PyApp,AppConsole):
    """ The wx.App class represents the application and is used to:

        Source: https://docs.wxpython.org/wx.App.html
    """
    def __init__(self, redirect=False, filename=None, useBestVisual=False, clearSigInt=True) -> None:
        """ Construct a wx.App object.

            Source: https://docs.wxpython.org/wx.App.html
        """

    @staticmethod
    def Get() -> 'App':
        """ A staticmethod returning the currently active application object.
Essentially just a more pythonic version of GetApp.

            Source: https://docs.wxpython.org/wx.App.html
        """

    def InitLocale(self) -> None:
        """ Starting with version 3.8 on Windows, Python is now setting the locale
to what is defined by the system as the default locale. This causes
problems with wxWidgets which expects to be able to manage the locale
via the wx.Locale class, so the locale will be reset here to be the
default âCâ locale settings.

            Source: https://docs.wxpython.org/wx.App.html
        """

    def MainLoop(self) -> None:
        """ Execute the main GUI event loop

            Source: https://docs.wxpython.org/wx.App.html
        """

    def OnPreInit(self) -> None:
        """ Things that must be done after _BootstrapApp has done its thing, but
would be nice if they were already done by the time that OnInit is
called.  This can be overridden in derived classes, but be sure to call
this method from there.

            Source: https://docs.wxpython.org/wx.App.html
        """

    def RedirectStdio(self, filename=None) -> None:
        """ Redirect sys.stdout and sys.stderr to a file or a popup window.

            Source: https://docs.wxpython.org/wx.App.html
        """

    def ResetLocale(self) -> None:
        """ This method is now a NOP and will be deprecated.

            Source: https://docs.wxpython.org/wx.App.html
        """

    def RestoreStdio(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.App.html
        """

    def SetOutputWindowAttributes(self, title=None, pos=None, size=None) -> None:
        """ Set the title, position and/or size of the output window if the stdio
has been redirected. This should be called before any output would
cause the output window to be created.

            Source: https://docs.wxpython.org/wx.App.html
        """

    def SetTopWindow(self, frame) -> None:
        """ Set the âmainâ top level window, which will be used for the parent of
the on-demand output window as well as for dialogs that do not have
an explicit parent set.

            Source: https://docs.wxpython.org/wx.App.html
        """

    def __del__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.App.html
        """



class PyApp(AppConsole):
    """ The App class represents the application itself when USE_GUI=1.

        Source: https://docs.wxpython.org/wx.PyApp.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    @staticmethod
    def GTKAllowDiagnosticsControl() -> None:
        """ Allows wxWidgets to selectively suppress some GTK messages.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    @staticmethod
    def GTKSuppressDiagnostics(flags: int=-1) -> None:
        """ Disables the printing of various GTK messages.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def GetAssertMode(self) -> 'AppAssertMode':
        """ Returns the current mode for how the application responds to  asserts.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    @staticmethod
    def GetComCtl32Version() -> int:
        """ Returns 400, 470, 471, etc. for comctl32.dll 4.00, 4.70, 4.71 or 0 if
it wasnât found at all.  Raises an exception on non-Windows platforms.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def GetDisplayMode(self) -> 'VideoMode':
        """ Get display mode that is used use.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def GetExitOnFrameDelete(self) -> bool:
        """ Returns True if the application will exit when the top-level frame is deleted.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def GetLayoutDirection(self) -> int:
        """ Return the layout direction for the current locale or  Layout_Default   if itâs unknown.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    @staticmethod
    def GetMainTopWindow() -> 'Window':
        """ Returns a pointer to the top application window if any.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def GetTopWindow(self) -> 'Window':
        """ Returns a pointer to the top window.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def GetUseBestVisual(self) -> bool:
        """ Returns True if the application will use the best visual on systems that support different visuals, False otherwise.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def IsActive(self) -> bool:
        """ Returns True if the application is active, i.e. if one of its windows is currently in the foreground.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    @staticmethod
    def IsDisplayAvailable() -> bool:
        """ Returns True if the application is able to connect to the systemâs
display, or whatever the equivallent is for the platform.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def MacHideApp(self) -> None:
        """ Hide all application windows just as the user can do with the
system Hide command.  Mac only.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def MacNewFile(self) -> None:
        """ Called in response of an âopen-applicationâ Apple event.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def MacOpenFile(self, fileName: str) -> None:
        """ Called in response of an âopen-documentâ Apple event.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def MacOpenFiles(self, fileNames: list[str]) -> None:
        """ Called in response of an openFiles message.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def MacOpenURL(self, url: str) -> None:
        """ Called in response of a âget-urlâ Apple event.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def MacPrintFile(self, fileName: str) -> None:
        """ Called in response of a âprint-documentâ Apple event.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def MacReopenApp(self) -> None:
        """ Called in response of a âreopen-applicationâ Apple event.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def OSXEnableAutomaticTabbing(self, enable: bool) -> None:
        """ Enable the automatic tabbing features of macOS.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def OSXIsGUIApplication(self) -> bool:
        """ May be overridden to indicate that the application is not a foreground GUI application under macOS.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SafeYield(self, win, onlyIfNeeded) -> bool:
        """ This function is similar to wx.Yield     , except that it disables the user input to all program windows before calling wx.AppConsole.Yield   and re-enables it again afterwards.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SafeYieldFor(self, win, eventsToProcess) -> bool:
        """ Works like wx.SafeYield       with onlyIfNeeded  == True except that it allows the caller to specify a mask of events to be processed.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SetAssertMode(self, wxAppAssertMode: AppAssertMode) -> None:
        """ Set the mode indicating how the application responds to  assertion
statements. Valid settings are a combination of these flags:

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SetDisplayMode(self, info: 'VideoMode') -> bool:
        """ Set display mode to use.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SetExitOnFrameDelete(self, flag: bool) -> None:
        """ Allows the programmer to specify whether the application will exit when the top-level frame is deleted.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SetNativeTheme(self, theme: str) -> bool:
        """ Allows runtime switching of the UI environment theme.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SetTopWindow(self, window: 'Window') -> None:
        """ Sets the âtopâ window.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    def SetUseBestVisual(self, flag, forceTrueColour=False) -> None:
        """ Allows the programmer to specify whether the application will use the best visual on systems that support several visual on the same display.

            Source: https://docs.wxpython.org/wx.PyApp.html
        """

    AssertMode: 'AppAssertMode'  # See GetAssertMode and SetAssertMode
    DisplayMode: 'VideoMode'  # See GetDisplayMode and SetDisplayMode
    ExitOnFrameDelete: bool  # See GetExitOnFrameDelete and SetExitOnFrameDelete
    LayoutDirection: int  # See GetLayoutDirection
    TopWindow: 'Window'  # See GetTopWindow and SetTopWindow
    UseBestVisual: bool  # See GetUseBestVisual and SetUseBestVisual



class AppConsole(EvtHandler,EventFilter):
    """ This class is essential for writing console-only or hybrid apps
without having to define USE_GUI=0.

        Source: https://docs.wxpython.org/wx.AppConsole.html
    """
    def DeletePendingEvents(self) -> None:
        """ Deletes the pending events of all EvtHandlers of this application.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def ExitMainLoop(self) -> None:
        """ Call this to explicitly exit the main message (event) loop.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def FilterEvent(self, event: 'Event') -> int:
        """ Overridden   wx.EventFilter  method.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def GetAppDisplayName(self) -> str:
        """ Returns the user-readable application name.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def GetAppName(self) -> str:
        """ Returns the application name.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def GetClassName(self) -> str:
        """ Gets the class name of the application.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    @staticmethod
    def GetInstance() -> 'AppConsole':
        """ Returns the one and only global application object.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def GetMainLoop(self) -> 'EventLoopBase':
        """ Returns the main event loop instance, i.e. the event loop which is started by OnRun   and which dispatches all events sent from the native toolkit to the application (except when new event loops are temporarily set-up).

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def GetTraits(self) -> 'AppTraits':
        """ Returns a pointer to the   wx.AppTraits  object for the application.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def GetVendorDisplayName(self) -> str:
        """ Returns the user-readable vendor name.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def GetVendorName(self) -> str:
        """ Returns the applicationâs vendor name.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def HasPendingEvents(self) -> bool:
        """ Returns True if there are pending events on the internal pending event list.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    @staticmethod
    def IsMainLoopRunning() -> bool:
        """ Returns True if the main event loop is currently running, i.e. if the application is inside OnRun .

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def IsScheduledForDestruction(self, object: 'Object') -> bool:
        """ Check if the object had been scheduled for destruction with ScheduleForDestruction .

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def MainLoop(self) -> int:
        """ Called by wxWidgets on creation of the application.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def OnEventLoopEnter(self, loop: 'EventLoopBase') -> None:
        """ Called by wx.EventLoopBase.SetActive : you can override this function and put here the code which needs an active event loop.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def OnEventLoopExit(self, loop: 'EventLoopBase') -> None:
        """ Called by wx.EventLoopBase.OnExit   for each event loop which is exited.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def OnExit(self) -> int:
        """ Override this member function for any processing which needs to be done as the application is about to exit.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def OnInit(self) -> bool:
        """ This must be provided by the application, and will usually create the applicationâs main window, optionally calling SetTopWindow().

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def OnRun(self) -> int:
        """ This virtual function is where the execution of a program written in wxWidgets starts.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def ProcessPendingEvents(self) -> None:
        """ Process all pending events; it is necessary to call this function to process events posted with wx.EvtHandler.QueueEvent   or wx.EvtHandler.AddPendingEvent .

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def ResumeProcessingOfPendingEvents(self) -> None:
        """ Resume processing of the pending events previously stopped because of a call to SuspendProcessingOfPendingEvents .

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def ScheduleForDestruction(self, object: 'Object') -> None:
        """ Delayed objects destruction.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def SetAppDisplayName(self, name: str) -> None:
        """ Set the application name to be used in the user-visible places such as window titles.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def SetAppName(self, name: str) -> None:
        """ Sets the name of the application.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def SetCLocale(self) -> None:
        """ Sets the C locale to the default locale for the current environment.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def SetClassName(self, name: str) -> None:
        """ Sets the class name of the application.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    @staticmethod
    def SetInstance(app: 'AppConsole') -> None:
        """ Allows external code to modify global wx.TheApp     , but you should really know what youâre doing if you call it.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def SetVendorDisplayName(self, name: str) -> None:
        """ Set the vendor name to be used in the user-visible places.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def SetVendorName(self, name: str) -> None:
        """ Sets the name of applicationâs vendor.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def SuspendProcessingOfPendingEvents(self) -> None:
        """ Temporary suspends processing of the pending events.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def UsesEventLoop(self) -> bool:
        """ Returns True if the application is using an event loop.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    def Yield(self, onlyIfNeeded: bool=False) -> bool:
        """ Yields control to pending messages in the event loop.

            Source: https://docs.wxpython.org/wx.AppConsole.html
        """

    AppDisplayName: str  # See GetAppDisplayName and SetAppDisplayName
    AppName: str  # See GetAppName and SetAppName
    ClassName: str  # See GetClassName and SetClassName
    Traits: 'AppTraits'  # See GetTraits
    VendorDisplayName: str  # See GetVendorDisplayName and SetVendorDisplayName
    VendorName: str  # See GetVendorName and SetVendorName



_StandardPaths: TypeAlias = StandardPaths

class AppTraits:
    """ The AppTraits class defines various configurable aspects of a App.

        Source: https://docs.wxpython.org/wx.AppTraits.html
    """
    def CreateConfig(self) -> 'ConfigBase':
        """ Called by wxWidgets to create the default configuration object for the application.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def CreateEventLoop(self) -> 'EventLoopBase':
        """ Used by wxWidgets to create the main event loop used by wx.App.OnRun .

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def CreateLogTarget(self) -> 'Log':
        """ Creates a   wx.Log  class for the application to use for logging errors.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def GetAssertStackTrace(self) -> str:
        """ Helper function mostly useful for derived classes ShowAssertDialog   implementation.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def GetDesktopEnvironment(self) -> str:
        """ This method returns the name of the desktop environment currently running in a Unix desktop.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def GetStandardPaths(self) -> 'StandardPaths':
        """ Returns the   wx.StandardPaths  object for the application.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def GetToolkitVersion(self) -> tuple:
        """ Returns the wxWidgets port ID used by the running program and eventually fills the given pointers with the values of the major, minor, and micro digits of the native toolkit currently used.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def HasStderr(self) -> bool:
        """ Returns True if  fprintf(stderr)   goes somewhere, False otherwise.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def IsUsingUniversalWidgets(self) -> bool:
        """ Returns True if the library was built as wxUniversal.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def SafeMessageBox(self, text, title) -> bool:
        """ Shows a message box with the given text and title if possible.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    def ShowAssertDialog(self, msg: str) -> bool:
        """ Shows the assert dialog with the specified message in GUI mode or just prints the string to stderr in console mode.

            Source: https://docs.wxpython.org/wx.AppTraits.html
        """

    AssertStackTrace: str  # See GetAssertStackTrace
    DesktopEnvironment: str  # See GetDesktopEnvironment
    StandardPaths: '_StandardPaths'  # See GetStandardPaths
    ToolkitVersion: tuple  # See GetToolkitVersion



PORT_GTK: int

class ArchiveFSHandler(FileSystemHandler):
    """ A file system handler for accessing files inside of archives.

        Source: https://docs.wxpython.org/wx.ArchiveFSHandler.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ArchiveFSHandler.html
        """

    def Cleanup(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ArchiveFSHandler.html
        """



class ArtProvider(Object):
    """ ArtProvider class is used to customize the look of wxWidgets
application.

        Source: https://docs.wxpython.org/wx.ArtProvider.html
    """
    def CreateBitmap(self, id, client, size) -> 'Bitmap':
        """ Derived art provider classes may override this method to create requested art resource.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    def CreateIconBundle(self, id, client) -> 'IconBundle':
        """ This method is similar to CreateBitmap   but can be used when a bitmap (or an icon) exists in several sizes.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def Delete(provider: 'ArtProvider') -> bool:
        """ Delete the given provider.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetBitmap(id, client=ART_OTHER, size=DefaultSize) -> 'Bitmap':
        """ Query registered providers for bitmap with given ID.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetBitmapBundle(id, client=ART_OTHER, size=DefaultSize) -> 'BitmapBundle':
        """ Query registered providers for a bundle of bitmaps with given ID.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetDIPSizeHint(client: 'ArtClient') -> 'Size':
        """ Returns a suitable size hint for the given ArtClient  in DIPs.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetIcon(id, client=ART_OTHER, size=DefaultSize) -> 'Icon':
        """ Same as wx.ArtProvider.GetBitmap , but return a   wx.Icon  object (or wx.NullIcon       on failure).

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetIconBundle(id, client=ART_OTHER) -> 'IconBundle':
        """ Query registered providers for icon bundle with given ID.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetMessageBoxIcon(flags: int) -> 'Icon':
        """ Helper used by several generic classes: return the icon corresponding to the standard ICON_INFORMATION/WARNING/ERROR/QUESTION flags (only one can be set)

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetMessageBoxIconId(flags: int) -> int:
        """ Helper used by GetMessageBoxIcon : return the art id corresponding to the standard ICON_INFORMATION/WARNING/ERROR/QUESTION flags (only one can be set)

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetNativeDIPSizeHint(client: 'ArtClient') -> 'Size':
        """ Returns native icon size for use specified by client  hint in DIPs.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetNativeSizeHint(client, win=None) -> 'Size':
        """ Returns native icon size for use specified by client  hint.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def GetSizeHint(client, win=None) -> 'Size':
        """ Returns a suitable size hint for the given ArtClient.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def HasNativeProvider() -> bool:
        """ Returns True if the platform uses native icons provider that should take precedence over any customizations.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def Pop() -> bool:
        """ Remove latest added provider and delete it.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def Push(provider: 'ArtProvider') -> None:
        """ Register new art provider and add it to the top of providers stack (i.e.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def PushBack(provider: 'ArtProvider') -> None:
        """ Register new art provider and add it to the bottom of providers stack.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """

    @staticmethod
    def Remove(provider: 'ArtProvider') -> bool:
        """ Remove a provider from the stack if it is on it.

            Source: https://docs.wxpython.org/wx.ArtProvider.html
        """



ART_ERROR: int

ART_GOTO_LAST: int

ART_FILE_SAVE_AS: int

ART_QUESTION: int

ART_PRINT: int

ART_DELETE: int

ART_WARNING: int

ART_HELP: int

ART_COPY: int

ART_INFORMATION: int

ART_TIP: int

ART_CUT: int

ART_ADD_BOOKMARK: int

ART_REPORT_VIEW: int

ART_PASTE: int

ART_DEL_BOOKMARK: int

ART_LIST_VIEW: int

ART_UNDO: int

ART_HELP_SIDE_PANEL: int

ART_NEW_DIR: int

ART_REDO: int

ART_HELP_SETTINGS: int

ART_FOLDER: int

ART_PLUS: int

ART_HELP_BOOK: int

ART_FOLDER_OPEN: int

ART_MINUS: int

ART_HELP_FOLDER: int

ART_GO_DIR_UP: int

ART_CLOSE: int

ART_HELP_PAGE: int

ART_EXECUTABLE_FILE: int

ART_QUIT: int

ART_GO_BACK: int

ART_NORMAL_FILE: int

ART_FIND: int

ART_GO_FORWARD: int

ART_TICK_MARK: int

ART_FIND_AND_REPLACE: int

ART_GO_UP: int

ART_CROSS_MARK: int

ART_HARDDISK: int

ART_GO_DOWN: int

ART_MISSING_IMAGE: int

ART_FLOPPY: int

ART_GO_TO_PARENT: int

ART_NEW: int

ART_CDROM: int

ART_GO_HOME: int

ART_FILE_OPEN: int

ART_GOTO_FIRST: int

ART_FILE_SAVE: int

ART_OTHER: int

ART_FRAME_ICON: int

class AutoBufferedPaintDC(BufferedPaintDC):
    """ This DC derivative can be used inside of an EVT_PAINT() event
handler to achieve double-buffered drawing.

        Source: https://docs.wxpython.org/wx.AutoBufferedPaintDC.html
    """
    def __init__(self, window: 'Window') -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.AutoBufferedPaintDC.html
        """



BG_STYLE_PAINT: int

_Brush: TypeAlias = Brush

_Font: TypeAlias = Font

_FontMetrics: TypeAlias = FontMetrics

_GraphicsContext: TypeAlias = GraphicsContext

_Pen: TypeAlias = Pen

class DC(Object):
    """ A DC is a âdevice contextâ onto which graphics and text can be
drawn.

        Source: https://docs.wxpython.org/wx.DC.html
    """
    def Blit(self, xdest, ydest, width, height, source, xsrc, ysrc, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool:
        """ Copy from a source DC to this DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def CalcBoundingBox(self, x, y) -> None:
        """ Adds the specified point to the bounding box which can be retrieved with MinX , MaxX   and MinY , MaxY   functions.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def CanDrawBitmap(self) -> bool:
        """ Does the DC support drawing bitmaps?

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def CanGetTextExtent(self) -> bool:
        """ Does the DC support calculating the size required to draw text?

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def CanUseTransformMatrix(self) -> bool:
        """ Check if the use of transformation matrix is supported by the current system.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def Clear(self) -> None:
        """ Clears the device context using the current background brush.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def CopyAttributes(self, dc: 'DC') -> None:
        """ Copy attributes from another DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def CrossHair(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DestroyClippingRegion(self) -> None:
        """ Destroys the current clipping region so that none of the DC is clipped.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DeviceToLogical(self, *args, **kw) -> 'Point':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DeviceToLogicalRel(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DeviceToLogicalX(self, x: int) -> 'Coord':
        """ Convert device  X coordinate to logical coordinate, using the current mapping mode, user scale factor, device origin and axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DeviceToLogicalXRel(self, x: int) -> 'Coord':
        """ Convert device  X coordinate to relative logical coordinate, using the current mapping mode and user scale factor but ignoring the axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DeviceToLogicalY(self, y: int) -> 'Coord':
        """ Converts device  Y coordinate to logical coordinate, using the current mapping mode, user scale factor, device origin and axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DeviceToLogicalYRel(self, y: int) -> 'Coord':
        """ Convert device  Y coordinate to relative logical coordinate, using the current mapping mode and user scale factor but ignoring the axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawArc(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawBitmap(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawCheckMark(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawCircle(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawEllipse(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawEllipseList(self, ellipses, pens=None, brushes=None) -> None:
        """ Draw a list of ellipses as quickly as possible.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawEllipticArc(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawIcon(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawLabel(self, *args, **kw) -> 'Rect':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawLine(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawLineList(self, lines, pens=None) -> None:
        """ Draw a list of lines as quickly as possible.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawLines(self, points, xoffset=0, yoffset=0) -> None:
        """ This method uses a list of Points, adding the optional offset coordinate.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawLinesFromBuffer(self, pyBuff: Any) -> None:
        """ Implementation of DrawLines that can use numpy arrays, or anything else that uses the
python buffer protocol directly without any element conversion.  This provides a
significant performance increase over the standard DrawLines function.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawPoint(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawPointList(self, points, pens=None) -> None:
        """ Draw a list of points as quickly as possible.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawPolygon(self, points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE) -> None:
        """ This method draws a filled polygon using a list of Points, adding the optional offset coordinate.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawPolygonList(self, polygons, pens=None, brushes=None) -> None:
        """ Draw a list of polygons, each of which is a list of points.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawRectangle(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawRectangleList(self, rectangles, pens=None, brushes=None) -> None:
        """ Draw a list of rectangles as quickly as possible.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawRotatedText(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawRoundedRectangle(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawSpline(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawText(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def DrawTextList(self, textList, coords, foregrounds=None, backgrounds=None) -> None:
        """ Draw a list of strings using a list of coordinants for positioning each string.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def EndDoc(self) -> None:
        """ Ends a document (only relevant when outputting to a printer).

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def EndPage(self) -> None:
        """ Ends a document page (only relevant when outputting to a printer).

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def FloodFill(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def FromDIP(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetAsBitmap(self, subrect: Optional['Rect']=None) -> 'Bitmap':
        """ If supported by the platform and the type of DC, fetch the contents of the DC, or a subset of it, as a bitmap.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetBackground(self) -> 'Brush':
        """ Gets the brush used for painting the background.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetBackgroundMode(self) -> int:
        """ Returns the current background mode:  BRUSHSTYLE_SOLID   or   BRUSHSTYLE_TRANSPARENT .

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetBoundingBox(self) -> None:
        """ Returns the min and max points used in drawing commands so far.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetBrush(self) -> 'Brush':
        """ Gets the current brush.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetCGContext(self) -> int:
        """ wx.UIntPtr

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetCharHeight(self) -> 'Coord':
        """ Gets the character height of the currently set font.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetCharWidth(self) -> 'Coord':
        """ Gets the average character width of the currently set font.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetClippingBox(self) -> tuple:
        """ Gets the rectangle surrounding the current clipping region.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetClippingRect(self) -> None:
        """ Returns the rectangle surrounding the current clipping region as a wx.Rect.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetContentScaleFactor(self) -> float:
        """ Returns the factor used for converting logical pixels to physical ones.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetDepth(self) -> int:
        """ Returns the depth (number of bits/pixel) of this DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetDeviceOrigin(self) -> 'Point':
        """ Returns the current device origin.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetFont(self) -> 'Font':
        """ Gets the current font.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetFontMetrics(self) -> 'FontMetrics':
        """ Returns the various font characteristics.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetGdkDrawable(self) -> int:
        """ wx.UIntPtr

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetGraphicsContext(self) -> 'GraphicsContext':
        """ If supported by the platform and the  `   wx.DC `   implementation, this method will return the  `   wx.GraphicsContext `   associated with the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetHDC(self) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetHandle(self) -> int:
        """ Returns a value that can be used as a handle to the native drawing context, if this   wx.DC  has something that could be thought of in that way.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetLayoutDirection(self) -> int:
        """ Gets the current layout direction of the device context.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetLogicalFunction(self) -> 'RasterOperationMode':
        """ Gets the current logical function.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetLogicalOrigin(self) -> tuple:
        """ Return the coordinates of the logical point (0, 0).

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetLogicalScale(self) -> tuple:
        """ Return the scale set by the last call to SetLogicalScale .

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetMapMode(self) -> 'MappingMode':
        """ Gets the current mapping mode for the device context.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetFullMultiLineTextExtent(self, string, font=None) -> tuple:
        """ Gets the dimensions of the string as it would be drawn.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetMultiLineTextExtent(self, st: Any) -> None:
        """ Return the dimensions of the given stringâs text extent using the
currently selected font, taking into account multiple lines if
present in the string.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetPPI(self) -> 'Size':
        """ Returns the resolution of the device in pixels per inch.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetPartialTextExtents(self, text) -> None:
        """ Fills the widths  array with the widths from the beginning of text  to the corresponding character of text.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetPen(self) -> 'Pen':
        """ Gets the current pen.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetPixel(self, x, y) -> 'Colour':
        """ Gets the colour at the specified location on the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetSize(self) -> 'Size':
        """ This is an overloaded member function, provided for convenience. It differs from the above function only in what argument(s) it accepts.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetSizeMM(self) -> 'Size':
        """ This is an overloaded member function, provided for convenience. It differs from the above function only in what argument(s) it accepts.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetTextBackground(self) -> 'Colour':
        """ Gets the current text background colour.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetFullTextExtent(self, string, font=None) -> tuple:
        """ Gets the dimensions of the string as it would be drawn.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetTextExtent(self, st: Any) -> None:
        """ Return the dimensions of the given stringâs text extent using the
currently selected font.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetTextForeground(self) -> 'Colour':
        """ Gets the current text foreground colour.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetTransformMatrix(self) -> 'AffineMatrix2D':
        """ Return the transformation matrix used by this device context.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GetUserScale(self) -> None:
        """ Gets the current user scale factor.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GradientFillConcentric(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def GradientFillLinear(self, rect, initialColour, destColour, nDirection=RIGHT) -> None:
        """ Fill the area specified by rect  with a linear gradient, starting from initialColour  and eventually fading to destColour.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the DC is ok to use.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def LogicalToDevice(self, *args, **kw) -> 'Point':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def LogicalToDeviceRel(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def LogicalToDeviceX(self, x: int) -> 'Coord':
        """ Converts logical X coordinate to device coordinate, using the current mapping mode, user scale factor, device origin and axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def LogicalToDeviceXRel(self, x: int) -> 'Coord':
        """ Converts logical X coordinate to relative device coordinate, using the current mapping mode and user scale factor but ignoring the axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def LogicalToDeviceY(self, y: int) -> 'Coord':
        """ Converts logical Y coordinate to device coordinate, using the current mapping mode, user scale factor, device origin and axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def LogicalToDeviceYRel(self, y: int) -> 'Coord':
        """ Converts logical Y coordinate to relative device coordinate, using the current mapping mode and user scale factor but ignoring the axis orientation.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def MaxX(self) -> 'Coord':
        """ Gets the maximum horizontal extent used in drawing commands so far.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def MaxY(self) -> 'Coord':
        """ Gets the maximum vertical extent used in drawing commands so far.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def MinX(self) -> 'Coord':
        """ Gets the minimum horizontal extent used in drawing commands so far.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def MinY(self) -> 'Coord':
        """ Gets the minimum vertical extent used in drawing commands so far.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def ResetBoundingBox(self) -> None:
        """ Resets the bounding box: after a call to this function, the bounding box doesnât contain anything.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def ResetTransformMatrix(self) -> None:
        """ Revert the transformation matrix to identity matrix.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetAxisOrientation(self, xLeftRight, yBottomUp) -> None:
        """ Sets the x and y axis orientation (i.e. the direction from lowest to highest values on the axis).

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetBackground(self, brush: 'Brush') -> None:
        """ Sets the current background brush for the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetBackgroundMode(self, mode: int) -> None:
        """ Change the current background mode.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetBrush(self, brush: 'Brush') -> None:
        """ Sets the current brush for the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetClippingRegion(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetDeviceClippingRegion(self, region: 'Region') -> None:
        """ Sets the clipping region for this device context.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetDeviceOrigin(self, x, y) -> None:
        """ Sets the device origin (i.e. the origin in pixels after scaling has been applied).

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetFont(self, font: 'Font') -> None:
        """ Sets the current font for the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetGraphicsContext(self, ctx: 'GraphicsContext') -> None:
        """ Associate a   wx.GraphicsContext  with the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetLayoutDirection(self, dir: int) -> None:
        """ Sets the current layout direction for the device context.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetLogicalFunction(self, function: RasterOperationMode) -> None:
        """ Sets the current logical function for the device context.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetLogicalOrigin(self, x, y) -> None:
        """ Change the offset used for translating   wx.DC  coordinates.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetLogicalScale(self, x, y) -> None:
        """ Set the scale to use for translating   wx.DC  coordinates to the physical pixels.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetMapMode(self, mode: MappingMode) -> None:
        """ The mapping mode of the device context defines the unit of measurement used to convert logical  units to device  units.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetPalette(self, palette: 'Palette') -> None:
        """ If this is a window DC or memory DC, assigns the given palette to the window or bitmap associated with the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetPen(self, pen: 'Pen') -> None:
        """ Sets the current pen for the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetTextBackground(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the current text background colour for the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetTextForeground(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the current text foreground colour for the DC.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetTransformMatrix(self, matrix: 'AffineMatrix2D') -> bool:
        """ Set the transformation matrix.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def SetUserScale(self, xScale, yScale) -> None:
        """ Sets the user scaling factor, useful for applications which require âzoomingâ.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def StartDoc(self, message: str) -> bool:
        """ Starts a document (only relevant when outputting to a printer).

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def StartPage(self) -> None:
        """ Starts a document page (only relevant when outputting to a printer).

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def StretchBlit(self, xdest, ydest, dstWidth, dstHeight, source, xsrc, ysrc, srcWidth, srcHeight, logicalFunc=COPY, useMask=False, xsrcMask=DefaultCoord, ysrcMask=DefaultCoord) -> bool:
        """ Copy from a source DC to this DC possibly changing the scale.

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def ToDIP(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def _DrawEllipseList(self, pyCoords, pyPens, pyBrushes) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def _DrawLineList(self, pyCoords, pyPens, pyBrushes) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def _DrawLinesFromBuffer(self, pyBuff) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def _DrawPointList(self, pyCoords, pyPens, pyBrushes) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def _DrawPolygonList(self, pyCoords, pyPens, pyBrushes) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def _DrawRectangleList(self, pyCoords, pyPens, pyBrushes) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def _DrawTextList(self, textList, pyPoints, foregroundList, backgroundList) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DC.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.DC.html
        """

    AsBitmap: 'Bitmap'  # See GetAsBitmap
    Background: 'Brush'  # See GetBackground and SetBackground
    BackgroundMode: int  # See GetBackgroundMode and SetBackgroundMode
    BoundingBox: None  # See GetBoundingBox
    Brush: '_Brush'  # See GetBrush and SetBrush
    CGContext: int  # See GetCGContext
    CharHeight: 'Coord'  # See GetCharHeight
    CharWidth: 'Coord'  # See GetCharWidth
    ClippingRect: None  # See GetClippingRect
    ContentScaleFactor: float  # See GetContentScaleFactor
    Depth: int  # See GetDepth
    DeviceOrigin: 'Point'  # See GetDeviceOrigin and SetDeviceOrigin
    Font: '_Font'  # See GetFont and SetFont
    FontMetrics: '_FontMetrics'  # See GetFontMetrics
    GdkDrawable: int  # See GetGdkDrawable
    GraphicsContext: '_GraphicsContext'  # See GetGraphicsContext and SetGraphicsContext
    HDC: int  # See GetHDC
    Handle: int  # See GetHandle
    LayoutDirection: int  # See GetLayoutDirection and SetLayoutDirection
    LogicalFunction: 'RasterOperationMode'  # See GetLogicalFunction and SetLogicalFunction
    MapMode: 'MappingMode'  # See GetMapMode and SetMapMode
    MultiLineTextExtent: None  # See GetMultiLineTextExtent
    PPI: 'Size'  # See GetPPI
    Pen: '_Pen'  # See GetPen and SetPen
    Pixel: 'Colour'  # See GetPixel
    Size: '_Size'  # See GetSize
    SizeMM: 'Size'  # See GetSizeMM
    TextBackground: 'Colour'  # See GetTextBackground and SetTextBackground
    TextExtent: None  # See GetTextExtent
    TextForeground: 'Colour'  # See GetTextForeground and SetTextForeground
    TransformMatrix: 'AffineMatrix2D'  # See GetTransformMatrix and SetTransformMatrix



BLACK: 'Colour'

WHITE: 'Colour'

ODDEVEN_RULE: int

WINDING_RULE: int

FLOOD_SURFACE: int

FLOOD_BORDER: int

class PostScriptDC(DC):
    """ This defines the wxWidgets Encapsulated PostScript device context,
which can write PostScript files on any platform.

        Source: https://docs.wxpython.org/wx.PostScriptDC.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PostScriptDC.html
        """



class MetafileDC(DC):
    """ This is a type of device context that allows a metafile object to be
created (Windows only), and has most of the characteristics of a
normal DC.

        Source: https://docs.wxpython.org/wx.MetafileDC.html
    """
    def __init__(self, filename: str="") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MetafileDC.html
        """

    def Close(self) -> 'Metafile':
        """ This must be called after the device context is finished with.

            Source: https://docs.wxpython.org/wx.MetafileDC.html
        """



NullColour: int

class PaintDC(ClientDC):
    """ A PaintDC must be constructed if an application wishes to paint on
the client area of a window from within an EVT_PAINT() event handler.

        Source: https://docs.wxpython.org/wx.PaintDC.html
    """
    def __init__(self, window: 'Window') -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PaintDC.html
        """



class BitmapBundle:
    """ Contains representations of the same bitmap in different resolutions.

        Source: https://docs.wxpython.org/wx.BitmapBundle.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def Clear(self) -> None:
        """ Clear the existing bundle contents.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromBitmap(bitmap: 'Bitmap') -> 'BitmapBundle':
        """ Create a bundle from a single bitmap.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromBitmaps(*args, **kw) -> 'BitmapBundle':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromFiles(*args, **kw) -> 'BitmapBundle':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromIconBundle(iconBundle: 'IconBundle') -> 'BitmapBundle':
        """ Create a bundle from an icon bundle.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromImage(image: 'Image') -> 'BitmapBundle':
        """ Create a bundle from a single image.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromImpl(impl: 'BitmapBundleImpl') -> 'BitmapBundle':
        """ Create a bundle from a custom bitmap bundle implementation.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromResources(name: str) -> 'BitmapBundle':
        """ Create a bundle from the bitmaps in the application resources.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromSVG(*args, **kw) -> 'BitmapBundle':
        """ This is an overloaded member function, provided for convenience. It differs from the above function only in what argument(s) it accepts.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromSVGFile(path, sizeDef) -> 'BitmapBundle':
        """ Create a bundle from the SVG image loaded from the given file.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    @staticmethod
    def FromSVGResource(name, sizeDef) -> 'BitmapBundle':
        """ Create a bundle from the SVG image loaded from an application resource.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetBitmap(self, size: Union[tuple[int, int], 'Size']) -> 'Bitmap':
        """ Get bitmap of the specified size, creating a new bitmap from the closest available size by rescaling it if necessary.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetBitmapFor(self, window: 'Window') -> 'Bitmap':
        """ Get bitmap of the size appropriate for the DPI scaling used by the given window.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetDefaultSize(self) -> 'Size':
        """ Get the size of the bitmap represented by this bundle in default resolution or, equivalently, at 100% scaling.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetIcon(self, size: Union[tuple[int, int], 'Size']) -> 'Icon':
        """ Get icon of the specified size.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetIconFor(self, window: 'Window') -> 'Icon':
        """ Get icon of the size appropriate for the DPI scaling used by the given window.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetPreferredBitmapSizeAtScale(self, scale: float) -> 'Size':
        """ Get the size that would be best to use for this bundle at the given DPI scaling factor.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetPreferredBitmapSizeFor(self, window: 'Window') -> 'Size':
        """ Get the size that would be best to use for this bundle at the DPI scaling factor used by the given window.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def GetPreferredLogicalSizeFor(self, window: 'Window') -> 'Size':
        """ Get the size that would be best to use for this bundle at the DPI scaling factor used by the given window in logical size.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def IsOk(self) -> bool:
        """ Check if bitmap bundle is non-empty.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    def IsSameAs(self, other: 'BitmapBundle') -> bool:
        """ Check if the two bundles refer to the same object.

            Source: https://docs.wxpython.org/wx.BitmapBundle.html
        """

    DefaultSize: 'Size'  # See GetDefaultSize



class BitmapBundleImpl(RefCounter):
    """ Base class for custom implementations of BitmapBundle.

        Source: https://docs.wxpython.org/wx.BitmapBundleImpl.html
    """
    def DoGetPreferredSize(self, scale: float) -> 'Size':
        """ Helper for implementing GetPreferredBitmapSizeAtScale   in the derived classes.

            Source: https://docs.wxpython.org/wx.BitmapBundleImpl.html
        """

    def GetBitmap(self, size: Union[tuple[int, int], 'Size']) -> 'Bitmap':
        """ Retrieve the bitmap of exactly the given size.

            Source: https://docs.wxpython.org/wx.BitmapBundleImpl.html
        """

    def GetDefaultSize(self) -> 'Size':
        """ Return the size of the bitmaps represented by this bundle in the default DPI.

            Source: https://docs.wxpython.org/wx.BitmapBundleImpl.html
        """

    def GetIndexToUpscale(self, size: Union[tuple[int, int], 'Size']) -> int:
        """ Return the index of the available scale most suitable to be upscaled to the given size.

            Source: https://docs.wxpython.org/wx.BitmapBundleImpl.html
        """

    def GetNextAvailableScale(self, idx: int) -> tuple:
        """ Return information about the available bitmaps.

            Source: https://docs.wxpython.org/wx.BitmapBundleImpl.html
        """

    def GetPreferredBitmapSizeAtScale(self, scale: float) -> 'Size':
        """ Return the preferred size that should be used at the given scale.

            Source: https://docs.wxpython.org/wx.BitmapBundleImpl.html
        """

    DefaultSize: 'Size'  # See GetDefaultSize



class BitmapButton(Button):
    """ A bitmap button is a control that contains a bitmap.

        Source: https://docs.wxpython.org/wx.BitmapButton.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BitmapButton.html
        """

    def Create(self, parent, id=ID_ANY, bitmap=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr) -> bool:
        """ Button creation function for two-step creation.

            Source: https://docs.wxpython.org/wx.BitmapButton.html
        """

    def CreateCloseButton(self, parent, winid, name="") -> bool:
        """ Creation function for two-step creation of âCloseâ button.

            Source: https://docs.wxpython.org/wx.BitmapButton.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.BitmapButton.html
        """

    @staticmethod
    def NewCloseButton(parent, winid, name="") -> 'BitmapButton':
        """ Helper function creating a standard-looking âCloseâ button.

            Source: https://docs.wxpython.org/wx.BitmapButton.html
        """



BU_LEFT: int  # Left-justifies the bitmap label.

BU_TOP: int  # Aligns the bitmap label to the top of the button.

BU_RIGHT: int  # Right-justifies the bitmap label.

BU_BOTTOM: int  # Aligns the bitmap label to the bottom of the button. ^^

EVT_BUTTON: int  # Process a  wxEVT_BUTTON   event, when the button is clicked. ^^

BU_EXACTFIT: int

class BitmapDataObject(DataObjectSimple):
    """ BitmapDataObject is a specialization of DataObject for bitmap
data.

        Source: https://docs.wxpython.org/wx.BitmapDataObject.html
    """
    def __init__(self, bitmap: 'Bitmap'=NullBitmap) -> None:
        """ Constructor, optionally passing a bitmap (otherwise use SetBitmap   later).

            Source: https://docs.wxpython.org/wx.BitmapDataObject.html
        """

    def GetAllFormats(self, dir=DataObject.Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.BitmapDataObject.html
        """

    def GetBitmap(self) -> 'Bitmap':
        """ Returns the bitmap associated with the data object.

            Source: https://docs.wxpython.org/wx.BitmapDataObject.html
        """

    def SetBitmap(self, bitmap: 'Bitmap') -> None:
        """ Sets the bitmap associated with the data object.

            Source: https://docs.wxpython.org/wx.BitmapDataObject.html
        """

    def SetData(self, format, buf) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.BitmapDataObject.html
        """

    AllFormats: None  # See GetAllFormats
    Bitmap: '_Bitmap'  # See GetBitmap and SetBitmap



class DataObject:
    """ A DataObject represents data that can be copied to or from the
clipboard, or dragged and dropped.

        Source: https://docs.wxpython.org/wx.DataObject.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def GetAllFormats(self, dir=Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def GetDataHere(self, format, buf) -> bool:
        """ Copies this data objectâs data in the requested format to the buffer provided.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def GetDataSize(self, format: 'DataFormat') -> int:
        """ Returns the data size of the given format format.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def GetFormatCount(self, dir: int=Get) -> int:
        """ Returns the number of available formats for rendering or setting the data.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def GetPreferredFormat(self, dir: int=Get) -> 'DataFormat':
        """ Returns the preferred format for either rendering the data (if dir  is  Get , its default value) or for setting it.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def IsSupported(self, format, dir=Get) -> bool:
        """ Returns True if this format is supported.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def SetData(self, format, buf) -> bool:
        """ Copies data from the provided buffer to this data object for the specified format.

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    def _testGetAllFormats(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DataObject.html
        """

    AllFormats: None  # See GetAllFormats
    DataHere: bool  # See GetDataHere
    FormatCount: int  # See GetFormatCount
    PreferredFormat: 'DataFormat'  # See GetPreferredFormat



class BitmapToggleButton(ToggleButton):
    """ BitmapToggleButton is a ToggleButton that contains a bitmap
instead of text.

        Source: https://docs.wxpython.org/wx.BitmapToggleButton.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BitmapToggleButton.html
        """

    def Create(self, parent, id=ID_ANY, label=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr) -> bool:
        """ Create method for two-step construction.

            Source: https://docs.wxpython.org/wx.BitmapToggleButton.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.BitmapToggleButton.html
        """

    def GetValue(self) -> bool:
        """ Gets the state of the toggle button.

            Source: https://docs.wxpython.org/wx.BitmapToggleButton.html
        """

    def SetValue(self, state: bool) -> None:
        """ Sets the toggle button to the given state.

            Source: https://docs.wxpython.org/wx.BitmapToggleButton.html
        """

    Value: bool  # See GetValue and SetValue



EVT_TOGGLEBUTTON: int  # Handles a wxEVT_TOGGLEBUTTON event. ^^

class ToggleButton(AnyButton):
    """ ToggleButton is a button that stays pressed when clicked by the
user.

        Source: https://docs.wxpython.org/wx.ToggleButton.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ToggleButton.html
        """

    def Create(self, parent, id=ID_ANY, label="", pos=DefaultPosition, size=DefaultSize, style=0, val=DefaultValidator, name=CheckBoxNameStr) -> bool:
        """ Creates the toggle button for two-step construction.

            Source: https://docs.wxpython.org/wx.ToggleButton.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ToggleButton.html
        """

    def GetValue(self) -> bool:
        """ Gets the state of the toggle button.

            Source: https://docs.wxpython.org/wx.ToggleButton.html
        """

    def SetValue(self, state: bool) -> None:
        """ Sets the toggle button to the given state.

            Source: https://docs.wxpython.org/wx.ToggleButton.html
        """

    Value: bool  # See GetValue and SetValue



class BookCtrlBase(Control,WithImages):
    """ A book control is a convenient way of displaying multiple pages of
information, displayed one page at a time.

        Source: https://docs.wxpython.org/wx.BookCtrlBase.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def AddPage(self, page, text, select=False, imageId=NO_IMAGE) -> bool:
        """ Adds a new page.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def AdvanceSelection(self, forward: bool=True) -> None:
        """ Cycles through the tabs.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def ChangeSelection(self, page: int) -> int:
        """ Changes the selection to the given page, returning the previous selection.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def Create(self, parent, winid, pos=DefaultPosition, size=DefaultSize, style=0, name="") -> bool:
        """ Constructs the book control with the given parameters.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def DeleteAllPages(self) -> bool:
        """ Deletes all pages.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def DeletePage(self, page: int) -> bool:
        """ Deletes the specified page, and the associated window.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def FindPage(self, page: 'Window') -> int:
        """ Returns the index of the specified tab window or  NOT_FOUND   if not found.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def GetControlSizer(self) -> 'Sizer':
        """ Returns the sizer containing the control for page selection, if any.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def GetCurrentPage(self) -> 'Window':
        """ Returns the currently selected page or None.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def GetPage(self, page: int) -> 'Window':
        """ Returns the window at the given page position.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def GetPageCount(self) -> int:
        """ Returns the number of pages in the control.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def GetPageImage(self, nPage: int) -> int:
        """ Returns the image index for the given page.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def GetPageText(self, nPage: int) -> str:
        """ Returns the string for the given page.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def GetSelection(self) -> int:
        """ Returns the currently selected page, or  NOT_FOUND   if none was selected.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def HitTest(self, pt: Union[tuple[int, int], 'Point']) -> tuple:
        """ Returns the index of the tab at the specified position or  NOT_FOUND   if none.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def InsertPage(self, index, page, text, select=False, imageId=NO_IMAGE) -> bool:
        """ Inserts a new page at the specified position.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def RemovePage(self, page: int) -> bool:
        """ Deletes the specified page, without deleting the associated window.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def SetPageImage(self, page, image) -> bool:
        """ Sets the image index for the given page.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def SetPageSize(self, size: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the width and height of the pages.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def SetPageText(self, page, text) -> bool:
        """ Sets the text for the given page.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    def SetSelection(self, page: int) -> int:
        """ Sets the selection to the given page, returning the previous selection.

            Source: https://docs.wxpython.org/wx.BookCtrlBase.html
        """

    ControlSizer: 'Sizer'  # See GetControlSizer
    CurrentPage: 'Window'  # See GetCurrentPage
    PageCount: int  # See GetPageCount
    Selection: int  # See GetSelection and SetSelection



class BookCtrlEvent(NotifyEvent):
    """ This class represents the events generated by book controls
(wxNotebook, Listbook, Choicebook, Treebook, AuiNotebook).

        Source: https://docs.wxpython.org/wx.BookCtrlEvent.html
    """
    def __init__(self, eventType=wxEVT_NULL, id=0, sel=NOT_FOUND, oldSel=NOT_FOUND) -> None:
        """ Constructor (used internally by wxWidgets only).

            Source: https://docs.wxpython.org/wx.BookCtrlEvent.html
        """

    def GetOldSelection(self) -> int:
        """ Returns the page that was selected before the change,  NOT_FOUND   if none was selected.

            Source: https://docs.wxpython.org/wx.BookCtrlEvent.html
        """

    def GetSelection(self) -> int:
        """ Returns the currently selected page, or  NOT_FOUND   if none was selected.

            Source: https://docs.wxpython.org/wx.BookCtrlEvent.html
        """

    def SetOldSelection(self, page: int) -> None:
        """ Sets the id of the page selected before the change.

            Source: https://docs.wxpython.org/wx.BookCtrlEvent.html
        """

    def SetSelection(self, page: int) -> None:
        """ Sets the selection member variable.

            Source: https://docs.wxpython.org/wx.BookCtrlEvent.html
        """

    OldSelection: int  # See GetOldSelection and SetOldSelection
    Selection: int  # See GetSelection and SetSelection



class Notebook(BookCtrlBase):
    """ This class represents a notebook control, which manages multiple
windows with associated tabs.

        Source: https://docs.wxpython.org/wx.Notebook.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def ChangeSelection(self, page: int) -> int:
        """ Changes the selection to the given page, returning the previous selection.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=NotebookNameStr) -> bool:
        """ Creates a notebook control.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def GetPageImage(self, nPage: int) -> int:
        """ Returns the image index for the given page.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def GetPageText(self, nPage: int) -> str:
        """ Returns the string for the given page.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def GetRowCount(self) -> int:
        """ Returns the number of rows in the notebook control.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def GetSelection(self) -> int:
        """ Returns the currently selected page, or  NOT_FOUND   if none was selected.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def GetThemeBackgroundColour(self) -> 'Colour':
        """ If running under Windows and themes are enabled for the application, this function returns a suitable colour for painting the background of a notebook page, and can be passed to SetBackgroundColour .

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def InsertPage(self, index, page, text, select=False, imageId=NO_IMAGE) -> bool:
        """ Inserts a new page at the specified position.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def SetPadding(self, padding: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the amount of space around each pageâs icon and label, in pixels.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def SetPageImage(self, page, image) -> bool:
        """ Sets the image index for the given page.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def SetPageText(self, page, text) -> bool:
        """ Sets the text for the given page.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    def SetSelection(self, page: int) -> int:
        """ Sets the selection to the given page, returning the previous selection.

            Source: https://docs.wxpython.org/wx.Notebook.html
        """

    RowCount: int  # See GetRowCount
    Selection: int  # See GetSelection and SetSelection
    ThemeBackgroundColour: 'Colour'  # See GetThemeBackgroundColour



NB_TOP: int  # Place tabs on the top side.

NB_LEFT: int  # Place tabs on the left side.

NB_RIGHT: int  # Place tabs on the right side.

NB_BOTTOM: int  # Place tabs under instead of above the notebook pages.

NB_FIXEDWIDTH: int  # (Windows only) All tabs will have same width.

NB_MULTILINE: int  # (Windows only) There can be several rows of tabs.

NB_NOPAGETHEME: int  # (Windows only) Display a solid colour on notebook pages, and not a gradient, which can reduce performance. ^^

EVT_NOTEBOOK_PAGE_CHANGED: int  # The page selection was changed. Processes a  wxEVT_NOTEBOOK_PAGE_CHANGED   event.

EVT_NOTEBOOK_PAGE_CHANGING: int  # The page selection is about to be changed. Processes a  wxEVT_NOTEBOOK_PAGE_CHANGING   event. This event can be vetoed. ^^

CLIP_CHILDREN: int

_ListView: TypeAlias = ListView

class Listbook(BookCtrlBase):
    """ Listbook is a class similar to Notebook but which uses a
ListCtrl to show the labels instead of the tabs.

        Source: https://docs.wxpython.org/wx.Listbook.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Listbook.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name="") -> bool:
        """ Create the list book control that has already been constructed with the default constructor.

            Source: https://docs.wxpython.org/wx.Listbook.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Listbook.html
        """

    def GetListView(self, *args, **kw) -> 'ListView':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Listbook.html
        """

    ListView: '_ListView'  # See GetListView



LB_DEFAULT: int  # Choose the default location for the labels depending on the current platform (left everywhere except Mac where it is top).

LB_TOP: int  # Place labels above the page area.

LB_LEFT: int  # Place labels on the left side.

LB_RIGHT: int  # Place labels on the right side.

LB_BOTTOM: int  # Place labels below the page area. ^^

EVT_LISTBOOK_PAGE_CHANGED: int  # The page selection was changed. Processes a  wxEVT_LISTBOOK_PAGE_CHANGED   event.

EVT_LISTBOOK_PAGE_CHANGING: int  # The page selection is about to be changed. Processes a  wxEVT_LISTBOOK_PAGE_CHANGING   event. This event can be vetoed. ^^

class Choicebook(BookCtrlBase):
    """ Choicebook is a class similar to Notebook, but uses a Choice
control to show the labels instead of the tabs.

        Source: https://docs.wxpython.org/wx.Choicebook.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Constructs a choicebook control.

            Source: https://docs.wxpython.org/wx.Choicebook.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name="") -> bool:
        """ Create the choicebook control that has already been constructed with the default constructor.

            Source: https://docs.wxpython.org/wx.Choicebook.html
        """

    def GetChoiceCtrl(self, *args, **kw) -> 'Choice':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Choicebook.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Choicebook.html
        """

    ChoiceCtrl: 'Choice'  # See GetChoiceCtrl



CHB_DEFAULT: int  # Choose the default location for the labels depending on the current platform (but currently itâs the same everywhere, namely wx.CHB_TOP).

CHB_TOP: int  # Place labels above the page area.

CHB_LEFT: int  # Place labels on the left side.

CHB_RIGHT: int  # Place labels on the right side.

CHB_BOTTOM: int  # Place labels below the page area. ^^

EVT_CHOICEBOOK_PAGE_CHANGED: int  # The page selection was changed. Processes a  wxEVT_CHOICEBOOK_PAGE_CHANGED   event.

EVT_CHOICEBOOK_PAGE_CHANGING: int  # The page selection is about to be changed. Processes a  wxEVT_CHOICEBOOK_PAGE_CHANGING   event. This event can be vetoed (using  wx.NotifyEvent.Veto ). ^^

_TreeCtrl: TypeAlias = TreeCtrl

class Treebook(BookCtrlBase):
    """ This class is an extension of the Notebook class that allows a tree
structured set of pages to be shown in a control.

        Source: https://docs.wxpython.org/wx.Treebook.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def AddPage(self, page, text, bSelect=False, imageId=NOT_FOUND) -> bool:
        """ Adds a new page.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def AddSubPage(self, page, text, bSelect=False, imageId=NOT_FOUND) -> bool:
        """ Adds a new child-page to the last top-level page.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def CollapseNode(self, pageId: int) -> bool:
        """ Shortcut for ExpandNode ( pageId, False ).

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=BK_DEFAULT, name="") -> bool:
        """ Creates a treebook control.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def DeletePage(self, pagePos: int) -> bool:
        """ Deletes the page at the specified position and all its children.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def ExpandNode(self, pageId, expand=True) -> bool:
        """ Expands (collapses) the pageId  node.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def GetPageParent(self, page: int) -> int:
        """ Returns the parent page of the given one or  NOT_FOUND   if this is a top-level page.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def GetSelection(self) -> int:
        """ Returns the currently selected page, or  NOT_FOUND   if none was selected.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def GetTreeCtrl(self) -> 'TreeCtrl':
        """ Returns the tree control used for selecting pages.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def InsertPage(self, pagePos, page, text, bSelect=False, imageId=NOT_FOUND) -> bool:
        """ Inserts a new page just before the page indicated by pagePos.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def InsertSubPage(self, pagePos, page, text, bSelect=False, imageId=NOT_FOUND) -> bool:
        """ Inserts a sub page under the specified page.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    def IsNodeExpanded(self, pageId: int) -> bool:
        """ Returns True if the page represented by pageId  is expanded.

            Source: https://docs.wxpython.org/wx.Treebook.html
        """

    Selection: int  # See GetSelection
    TreeCtrl: '_TreeCtrl'  # See GetTreeCtrl



EVT_TREEBOOK_PAGE_CHANGED: int  # The page selection was changed. Processes a  wxEVT_TREEBOOK_PAGE_CHANGED   event.

EVT_TREEBOOK_PAGE_CHANGING: int  # The page selection is about to be changed. Processes a  wxEVT_TREEBOOK_PAGE_CHANGING   event. This event can be  vetoed.

EVT_TREEBOOK_NODE_COLLAPSED: int  # The page node is going to be collapsed. Processes a  wxEVT_TREEBOOK_NODE_COLLAPSED   event.

EVT_TREEBOOK_NODE_EXPANDED: int  # The page node is going to be expanded. Processes a  wxEVT_TREEBOOK_NODE_EXPANDED   event. ^^

class BoxSizer(Sizer):
    """ The basic idea behind a box sizer is that windows will most often be
laid out in rather simple basic geometry, typically in a row or a
column or several hierarchies of either.

        Source: https://docs.wxpython.org/wx.BoxSizer.html
    """
    def __init__(self, orient: int=HORIZONTAL) -> None:
        """ Constructor for a   wx.BoxSizer.

            Source: https://docs.wxpython.org/wx.BoxSizer.html
        """

    def AddSpacer(self, size: int) -> 'SizerItem':
        """ Adds non-stretchable space to the main orientation of the sizer only.

            Source: https://docs.wxpython.org/wx.BoxSizer.html
        """

    def CalcMin(self) -> 'Size':
        """ Implements the calculation of a box sizerâs minimal.

            Source: https://docs.wxpython.org/wx.BoxSizer.html
        """

    def GetOrientation(self) -> int:
        """ Returns the orientation of the box sizer, either wx.VERTICAL or wx.HORIZONTAL.

            Source: https://docs.wxpython.org/wx.BoxSizer.html
        """

    def RepositionChildren(self, minSize: Union[tuple[int, int], 'Size']) -> None:
        """ Method which must be overridden in the derived sizer classes.

            Source: https://docs.wxpython.org/wx.BoxSizer.html
        """

    def SetOrientation(self, orient: int) -> None:
        """ Sets the orientation of the box sizer, either wx.VERTICAL or wx.HORIZONTAL.

            Source: https://docs.wxpython.org/wx.BoxSizer.html
        """

    Orientation: int  # See GetOrientation and SetOrientation



_Colour: TypeAlias = Colour

class Brush(GDIObject):
    """ A brush is a drawing tool for filling in areas.

        Source: https://docs.wxpython.org/wx.Brush.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def GetColour(self) -> 'Colour':
        """ Returns a reference to the brush colour.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def GetStipple(self) -> 'Bitmap':
        """ Gets a pointer to the stipple bitmap.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def GetStyle(self) -> 'BrushStyle':
        """ Returns the brush style, one of the   wx.BrushStyle  values.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def IsHatch(self) -> bool:
        """ Returns True if the style of the brush is any of hatched fills.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def IsNonTransparent(self) -> bool:
        """ Returns True if the brush is a valid non-transparent brush.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the brush is initialised.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def IsTransparent(self) -> bool:
        """ Returns True if the brush is transparent.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def MacSetTheme(self, macThemeBrushID) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def SetColour(self, *args, **kw) -> None:
        """ Sets the brush colour using red, green and blue values.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def SetStipple(self, bitmap: 'Bitmap') -> None:
        """ Sets the stipple bitmap.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def SetStyle(self, style: BrushStyle) -> None:
        """ Sets the brush style.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def _copyFrom(self, other) -> None:
        """ For internal use only.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Inequality operator.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Equality operator.

            Source: https://docs.wxpython.org/wx.Brush.html
        """

    Colour: '_Colour'  # See GetColour and SetColour
    Stipple: 'Bitmap'  # See GetStipple and SetStipple
    Style: 'BrushStyle'  # See GetStyle and SetStyle



BRUSHSTYLE_TRANSPARENT: int

class BrushList:
    """ A brush list is a list containing all brushes which have been created.

        Source: https://docs.wxpython.org/wx.BrushList.html
    """
    def FindOrCreateBrush(self, colour, style=BRUSHSTYLE_SOLID) -> 'Brush':
        """ Finds a brush with the specified attributes and returns it, else creates a new brush, adds it to the brush list, and returns it.

            Source: https://docs.wxpython.org/wx.BrushList.html
        """



class BufferedDC(MemoryDC):
    """ This class provides a simple way to avoid flicker: when drawing on it,
everything is in fact first drawn on an in-memory buffer (a Bitmap)
and then copied to the screen, using the associated DC, only once,
when this object is destroyed.

        Source: https://docs.wxpython.org/wx.BufferedDC.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BufferedDC.html
        """

    def GetStyle(self) -> int:
        """ Get the style.

            Source: https://docs.wxpython.org/wx.BufferedDC.html
        """

    def Init(self, *args, **kw) -> None:
        """ Initializes the object created using the default constructor.

            Source: https://docs.wxpython.org/wx.BufferedDC.html
        """

    def SetStyle(self, style: int) -> None:
        """ Set the style.

            Source: https://docs.wxpython.org/wx.BufferedDC.html
        """

    def UnMask(self) -> None:
        """ Blits the buffer to the dc, and detaches the dc from the buffer (so it can be effectively used once only).

            Source: https://docs.wxpython.org/wx.BufferedDC.html
        """

    Style: int  # See GetStyle and SetStyle



BUFFER_CLIENT_AREA: int

BUFFER_VIRTUAL_AREA: int

class BufferedPaintDC(BufferedDC):
    """ This is a subclass of BufferedDC which can be used inside of an
EVT_PAINT() event handler to achieve double-buffered drawing.

        Source: https://docs.wxpython.org/wx.BufferedPaintDC.html
    """
    def __init__(self, *args, **kw) -> None:
        """ As with   wx.BufferedDC, you may either provide the bitmap to be used for buffering or let this object create one internally (in the latter case, the size of the client part of the window is used).

            Source: https://docs.wxpython.org/wx.BufferedPaintDC.html
        """



class BusyCursor:
    """ This class makes it easy to tell your user that the program is
temporarily busy.

        Source: https://docs.wxpython.org/wx.BusyCursor.html
    """
    def __init__(self, cursor: 'Cursor'=HOURGLASS_CURSOR) -> None:
        """ Constructs a busy cursor object, calling wx.BeginBusyCursor     .

            Source: https://docs.wxpython.org/wx.BusyCursor.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.BusyCursor.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.BusyCursor.html
        """



class BusyInfo:
    """ This class makes it easy to tell your user that the program is
temporarily busy.

        Source: https://docs.wxpython.org/wx.BusyInfo.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.BusyInfo.html
        """

    def UpdateLabel(self, str: str) -> None:
        """ Same as UpdateText   but doesnât interpret the string as containing markup.

            Source: https://docs.wxpython.org/wx.BusyInfo.html
        """

    def UpdateText(self, str: str) -> None:
        """ Update the information text.

            Source: https://docs.wxpython.org/wx.BusyInfo.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.BusyInfo.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.BusyInfo.html
        """



class BusyInfoFlags:
    """ Parameters for BusyInfo.

        Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
    """
    def __init__(self) -> None:
        """ Default constructor initializes all attributes to default values.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Background(self, background: Union[int, str, 'Colour']) -> 'BusyInfoFlags':
        """ Sets the background colour of   wx.BusyInfo  window.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Foreground(self, foreground: Union[int, str, 'Colour']) -> 'BusyInfoFlags':
        """ Sets the foreground colour of the title and text strings.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Icon(self, icon: 'Icon') -> 'BusyInfoFlags':
        """ Sets the icon to show in   wx.BusyInfo.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Label(self, label: str) -> 'BusyInfoFlags':
        """ Same as Text   but doesnât interpret the string as containing markup.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Parent(self, parent: 'Window') -> 'BusyInfoFlags':
        """ Sets the parent for   wx.BusyInfo.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Text(self, text: str) -> 'BusyInfoFlags':
        """ Sets the more detailed text, shown under the title, if any.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Title(self, title: str) -> 'BusyInfoFlags':
        """ Sets the title, shown prominently in   wx.BusyInfo  window.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """

    def Transparency(self, alpha: 'Byte') -> 'BusyInfoFlags':
        """ Sets the transparency of   wx.BusyInfo  window.

            Source: https://docs.wxpython.org/wx.BusyInfoFlags.html
        """



ALPHA_TRANSPARENT: int

class Button(AnyButton):
    """ A button is a control that contains a text string, and is one of the
most common elements of a GUI.

        Source: https://docs.wxpython.org/wx.Button.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Button.html
        """

    def Create(self, parent, id=ID_ANY, label="", pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr) -> bool:
        """ Button creation function for two-step creation.

            Source: https://docs.wxpython.org/wx.Button.html
        """

    def GetAuthNeeded(self) -> bool:
        """ Returns True if an authentication needed symbol is displayed on the button.

            Source: https://docs.wxpython.org/wx.Button.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Button.html
        """

    @staticmethod
    def GetDefaultSize(win: Optional['Window']=None) -> 'Size':
        """ Returns the default size for the buttons.

            Source: https://docs.wxpython.org/wx.Button.html
        """

    def GetLabel(self) -> str:
        """ Returns the string label for the button.

            Source: https://docs.wxpython.org/wx.Button.html
        """

    def SetAuthNeeded(self, needed: bool=True) -> None:
        """ Sets whether an authentication needed symbol should be displayed on the button.

            Source: https://docs.wxpython.org/wx.Button.html
        """

    def SetDefault(self) -> 'Window':
        """ This sets the button to be the default item in its top-level window (e.g.

            Source: https://docs.wxpython.org/wx.Button.html
        """

    def SetLabel(self, label: str) -> None:
        """ Sets the string label for the button.

            Source: https://docs.wxpython.org/wx.Button.html
        """

    AuthNeeded: bool  # See GetAuthNeeded and SetAuthNeeded
    Label: str  # See GetLabel and SetLabel



BU_NOTEXT: int  # Disables the display of the text label in the button even if it has one or its id is one of the standard stock ids with an associated label: without using this style a button which is only supposed to show a bitmap but uses a standard id would display a label too.

BORDER_NONE: int  # Creates a button without border. This is currently implemented in MSW, GTK2 and OSX/Cocoa. ^^

class CallLater:
    """ A convenience class for wx.Timer, that calls the given callable
object once after the given amount of milliseconds, passing any
positional or keyword args.  The return value of the callable is
available after it has been run with the GetResult
method.

        Source: https://docs.wxpython.org/wx.CallLater.html
    """
    def __init__(self, millis, callableObj, *args, **kwargs) -> None:
        """ Constructs a new wx.CallLater object.

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def GetInterval(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def GetResult(self) -> Any:
        """ Returns the value of the callable.

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def HasRun(self) -> bool:
        """ Returns whether or not the callable has run.

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def IsRunning(self) -> bool:
        """ 

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def Notify(self) -> None:
        """ The timer has expired so call the callable.

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def SetArgs(self, *args, **kwargs) -> None:
        """ (Re)set the args passed to the callable object.  This is
useful in conjunction with Start if
you want to schedule a new call to the same callable
object but with different parameters.

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def Start(self, millis=None, *args, **kwargs) -> None:
        """ (Re)start the timer

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def Stop(self) -> None:
        """ Stop and destroy the timer.

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    def __del__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.CallLater.html
        """

    Interval: None  # See GetInterval
    Result: Any  # See GetResult



class Timer(EvtHandler):
    """ The Timer class allows you to execute code at specified intervals.

        Source: https://docs.wxpython.org/wx.Timer.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def GetId(self) -> int:
        """ Returns the ID of the events generated by this timer.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def GetInterval(self) -> int:
        """ Returns the current interval for the timer (in milliseconds).

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def GetOwner(self) -> 'EvtHandler':
        """ Returns the current owner  of the timer.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def IsOneShot(self) -> bool:
        """ Returns True if the timer is one shot, i.e. if it will stop after firing the first notification automatically.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def IsRunning(self) -> bool:
        """ Returns True if the timer is running, False if it is stopped.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def Notify(self) -> None:
        """ This member should be overridden by the user if the default constructor was used and SetOwner   wasnât called.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def SetOwner(self, owner, id=-1) -> None:
        """ Associates the timer with the given owner  object.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def Start(self, milliseconds=-1, oneShot=TIMER_CONTINUOUS) -> bool:
        """ (Re)starts the timer.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def StartOnce(self, milliseconds: int=-1) -> bool:
        """ Starts the timer for a once-only notification.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    def Stop(self) -> None:
        """ Stops the timer.

            Source: https://docs.wxpython.org/wx.Timer.html
        """

    Id: int  # See GetId
    Interval: int  # See GetInterval
    Owner: 'EvtHandler'  # See GetOwner and SetOwner



TIMER_CONTINUOUS: int

TIMER_ONE_SHOT: int

class Caret:
    """ A caret is a blinking cursor showing the position where the typed text
will appear.

        Source: https://docs.wxpython.org/wx.Caret.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def Create(self, *args, **kw) -> bool:
        """ Creates a caret with the given size (in pixels) and associates it with the window  (same as the equivalent constructors).

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    @staticmethod
    def GetBlinkTime() -> int:
        """ Returns the blink time which is measured in milliseconds and is the time elapsed between 2 inversions of the caret (blink time of the caret is the same for all carets, so this functions is static).

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def GetPosition(self) -> None:
        """ Get the caret position (in pixels).

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def GetSize(self) -> None:
        """ Get the caret size.

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def GetWindow(self) -> 'Window':
        """ Get the window the caret is associated with.

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def Hide(self) -> None:
        """ Hides the caret, same as Show(false).

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the caret was created successfully.

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def IsVisible(self) -> bool:
        """ Returns True if the caret is visible and False if it is permanently hidden (if it is blinking and not shown currently but will be after the next blink, this method still returns True).

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def Move(self, *args, **kw) -> None:
        """ Move the caret to given position (in logical coordinates).

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    @staticmethod
    def SetBlinkTime(milliseconds: int) -> None:
        """ Sets the blink time for all the carets.

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def SetSize(self, *args, **kw) -> None:
        """ Changes the size of the caret.

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def Show(self, show: bool=True) -> None:
        """ Shows or hides the caret.

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Caret.html
        """

    Position: None  # See GetPosition
    Size: None  # See GetSize and SetSize
    Window: '_Window'  # See GetWindow



class CheckBox(Control):
    """ A checkbox is a labelled box which by default is either on (checkmark
is visible) or off (no checkmark).

        Source: https://docs.wxpython.org/wx.CheckBox.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def Create(self, parent, id=ID_ANY, label="", pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=CheckBoxNameStr) -> bool:
        """ Creates the checkbox for two-step construction.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def Get3StateValue(self) -> 'CheckBoxState':
        """ Gets the state of a 3-state checkbox.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def GetValue(self) -> bool:
        """ Gets the state of a 2-state checkbox.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def Is3State(self) -> bool:
        """ Returns whether or not the checkbox is a 3-state checkbox.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def Is3rdStateAllowedForUser(self) -> bool:
        """ Returns whether or not the user can set the checkbox to the third state.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def IsChecked(self) -> bool:
        """ This is just a maybe more readable synonym for GetValue : just as the latter, it returns True if the checkbox is checked and False otherwise.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def Set3StateValue(self, state: CheckBoxState) -> None:
        """ Sets the checkbox to the given state.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    def SetValue(self, state: bool) -> None:
        """ Sets the checkbox to the given state.

            Source: https://docs.wxpython.org/wx.CheckBox.html
        """

    ThreeStateValue: Any  # See Get3StateValue and Set3StateValue
    Value: bool  # See GetValue and SetValue



CHK_2STATE: int  # Create a 2-state checkbox. This is the default.

CHK_3STATE: int  # Create a 3-state checkbox.

CHK_ALLOW_3RD_STATE_FOR_USER: int  # By default a user canât set a 3-state checkbox to the third state. It can only be done from code. Using this flags allows the user to set the checkbox to the third state by clicking.

ALIGN_RIGHT: int  # Makes the text appear on the left of the checkbox. ^^

EVT_CHECKBOX: int  # Process a  wxEVT_CHECKBOX   event, when the checkbox is clicked. ^^

CHK_UNDETERMINED: int

class CheckListBox(ListBox):
    """ A CheckListBox is like a ListBox, but allows items to be checked
or unchecked.

        Source: https://docs.wxpython.org/wx.CheckListBox.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def Check(self, item, check=True) -> None:
        """ Checks the given item.

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr) -> bool:
        """ parent (wx.Window) â

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def GetCheckedItems(self) -> None:
        """ GetCheckedItems()

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def GetCheckedStrings(self) -> None:
        """ GetCheckedStrings()

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def GetSelections(self) -> list[int]:
        """ Returns a list of the indices of the currently selected items.

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def IsChecked(self, item: int) -> bool:
        """ Returns True if the given item is checked, False otherwise.

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def SetCheckedItems(self, indexes) -> None:
        """ SetCheckedItems(indexes)

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    def SetCheckedStrings(self, strings) -> None:
        """ SetCheckedStrings(strings)

            Source: https://docs.wxpython.org/wx.CheckListBox.html
        """

    Checked: Any  # See GetChecked and SetChecked
    CheckedItems: None  # See GetCheckedItems and SetCheckedItems
    CheckedStrings: None  # See GetCheckedStrings and SetCheckedStrings



EVT_CHECKLISTBOX: int  # Process a  wxEVT_CHECKLISTBOX   event, when an item in the check list box is checked or unchecked.  wx.CommandEvent.GetInt   will contain the index of the item that was checked or unchecked. wx.CommandEvent.IsChecked   is not valid! Use wx.CheckListBox.IsChecked   instead. ^^

class ListBox(Control,ItemContainer):
    """ A listbox is used to select one or more of a list of strings.

        Source: https://docs.wxpython.org/wx.ListBox.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ListBoxNameStr) -> bool:
        """ Creates the listbox for two-step construction.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def Deselect(self, n: int) -> None:
        """ Deselects an item in the list box.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def EnsureVisible(self, n: int) -> None:
        """ Ensure that the item with the given index is currently shown.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def FindString(self, string, caseSensitive=False) -> int:
        """ Finds an item whose label matches the given string.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def GetCount(self) -> int:
        """ Returns the number of items in the control.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def GetCountPerPage(self) -> int:
        """ Return the number of items that can fit vertically in the visible area of the listbox.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def GetSelection(self) -> int:
        """ Returns the index of the selected item or  NOT_FOUND   if no item is selected.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def GetSelections(self) -> list[int]:
        """ Fill an array of ints with the positions of the currently selected items.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def GetString(self, n: int) -> str:
        """ Returns the label of the item with the given index.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def GetTopItem(self) -> int:
        """ Return the index of the topmost visible item.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def HitTest(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def InsertItems(self, items, pos) -> None:
        """ Insert the given number of strings before the specified position.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def IsSelected(self, n: int) -> bool:
        """ Determines whether an item is selected.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def IsSorted(self) -> bool:
        """ Return True if the listbox has LB_SORT  style.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def MSWSetTabStops(self, tabStops) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def SetFirstItem(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def SetItemBackgroundColour(self, item, c) -> None:
        """ Set the background colour of an item in the ListBox.
Only valid on MSW and if the wx.LB_OWNERDRAW flag is set.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def SetItemFont(self, item, f) -> None:
        """ Set the font of an item in the ListBox.
Only valid on MSW and if the wx.LB_OWNERDRAW flag is set.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def SetItemForegroundColour(self, item, c) -> None:
        """ Set the foreground colour of an item in the ListBox.
Only valid on MSW and if the wx.LB_OWNERDRAW flag is set.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def SetSelection(self, n: int) -> None:
        """ Sets the selection to the given item n  or removes the selection entirely if n  ==  NOT_FOUND .

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def SetString(self, n, string) -> None:
        """ Sets the label for the given item.

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    def SetStringSelection(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListBox.html
        """

    Count: int  # See GetCount
    CountPerPage: int  # See GetCountPerPage
    Selection: int  # See GetSelection and SetSelection
    Selections: list[int]  # See GetSelections
    TopItem: int  # See GetTopItem



LB_SINGLE: int  # Single-selection list.

LB_MULTIPLE: int  # Multiple-selection list: the user can toggle multiple items on and off. This is the same as wx.LB_EXTENDED in wxGTK2 port.

LB_EXTENDED: int  # Extended-selection list: the user can extend the selection by using  SHIFT   or   CTRL   keys together with the cursor movement keys or the mouse.

LB_HSCROLL: int  # Create horizontal scrollbar if contents are too wide (Windows only).

LB_ALWAYS_SB: int  # Always show a vertical scrollbar.

LB_NEEDED_SB: int  # Only create a vertical scrollbar if needed.

LB_NO_SB: int  # Donât create vertical scrollbar (wxMSW and wxGTK only).

LB_SORT: int  # The listbox contents are sorted in alphabetical order. ^^

EVT_LISTBOX: int  # Process a  wxEVT_LISTBOX   event, when an item on the list is selected or the selection changes.

EVT_LISTBOX_DCLICK: int  # Process a  wxEVT_LISTBOX_DCLICK   event, when the listbox is double-clicked. On some platforms (notably wxGTK2) pressing the enter key is handled as an equivalent of a double-click. ^^

NOT_FOUND: int

LB_OWNERDRAW: int

class ChildFocusEvent(CommandEvent):
    """ A child focus event is sent to a (parent-)window when one of its child
windows gains focus, so that the window could restore the focus back
to its corresponding child if it loses it now and regains later.

        Source: https://docs.wxpython.org/wx.ChildFocusEvent.html
    """
    def __init__(self, win: Optional['Window']=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ChildFocusEvent.html
        """

    def GetWindow(self) -> 'Window':
        """ Returns the direct child which receives the focus, or a (grand-)parent of the control receiving the focus.

            Source: https://docs.wxpython.org/wx.ChildFocusEvent.html
        """

    Window: '_Window'  # See GetWindow



EVT_CHILD_FOCUS: int  # Process a  wxEVT_CHILD_FOCUS   event. ^^

class Choice(Control,ItemContainer):
    """ A choice item is used to select one of a list of strings.

        Source: https://docs.wxpython.org/wx.Choice.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ChoiceNameStr) -> bool:
        """ Creates the choice for two-step construction.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def FindString(self, string, caseSensitive=False) -> int:
        """ Finds an item whose label matches the given string.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def GetColumns(self) -> int:
        """ Gets the number of columns in this choice item.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def GetCount(self) -> int:
        """ Returns the number of items in the control.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def GetCurrentSelection(self) -> int:
        """ Unlike wx.ControlWithItems.GetSelection   which only returns the accepted selection value (the selection in the control once the user closes the dropdown list), this function returns the current selection.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def GetSelection(self) -> int:
        """ Returns the index of the selected item or  NOT_FOUND   if no item is selected.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def GetString(self, n: int) -> str:
        """ Returns the label of the item with the given index.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def IsSorted(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def SetColumns(self, n: int=1) -> None:
        """ Sets the number of columns in this choice item.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def SetSelection(self, n: int) -> None:
        """ Sets the selection to the given item n  or removes the selection entirely if n  ==  NOT_FOUND .

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    def SetString(self, n, string) -> None:
        """ Sets the label for the given item.

            Source: https://docs.wxpython.org/wx.Choice.html
        """

    Columns: int  # See GetColumns and SetColumns
    Count: int  # See GetCount
    CurrentSelection: int  # See GetCurrentSelection
    Selection: int  # See GetSelection and SetSelection



CB_SORT: int  # Sorts the entries alphabetically. ^^

EVT_CHOICE: int  # Process a  wxEVT_CHOICE   event, when an item on the list is selected. ^^

class ClassInfo:
    """ This class stores meta-information about classes.

        Source: https://docs.wxpython.org/wx.ClassInfo.html
    """
    def CreateObject(self) -> 'Window':
        """ Creates an object of the appropriate kind.

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    @staticmethod
    def FindClass(className: str) -> 'ClassInfo':
        """ Finds the   wx.ClassInfo  object for a class with the given name.

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    def GetBaseClassName1(self) -> 'Char':
        """ Returns the name of the first base class (None if none).

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    def GetBaseClassName2(self) -> 'Char':
        """ Returns the name of the second base class (None if none).

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    def GetClassName(self) -> 'Char':
        """ Returns the string form of the class name.

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    def GetSize(self) -> int:
        """ Returns the size of the class.

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    def IsDynamic(self) -> bool:
        """ Returns True if this class info can create objects of the associated class.

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    def IsKindOf(self, info: 'ClassInfo') -> bool:
        """ Returns True if this class is a kind of (inherits from) the given class.

            Source: https://docs.wxpython.org/wx.ClassInfo.html
        """

    BaseClassName1: 'Char'  # See GetBaseClassName1
    BaseClassName2: 'Char'  # See GetBaseClassName2
    ClassName: 'Char'  # See GetClassName
    Size: int  # See GetSize



_ClientData: TypeAlias = ClientData

class ClientDataContainer:
    """ This class is a mixin that provides storage and management of âclient
dataâ.

        Source: https://docs.wxpython.org/wx.ClientDataContainer.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.ClientDataContainer.html
        """

    def GetClientData(self) -> 'ClientData':
        """ Get a pointer to the client data object.

            Source: https://docs.wxpython.org/wx.ClientDataContainer.html
        """

    def GetClientObject(self) -> Any:
        """ Alias for GetClientData

            Source: https://docs.wxpython.org/wx.ClientDataContainer.html
        """

    def SetClientData(self, data: ClientData) -> None:
        """ Set the client data object.

            Source: https://docs.wxpython.org/wx.ClientDataContainer.html
        """

    def SetClientObject(self, data) -> Any:
        """ Alias for SetClientData

            Source: https://docs.wxpython.org/wx.ClientDataContainer.html
        """

    ClientData: '_ClientData'  # See GetClientData and SetClientData



class ClientDC(WindowDC):
    """ ClientDC is primarily useful for obtaining information about the
window from outside EVT_PAINT() handler.

        Source: https://docs.wxpython.org/wx.ClientDC.html
    """
    def __init__(self, window: 'Window') -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ClientDC.html
        """



class Clipboard(Object):
    """ A class for manipulating the clipboard.

        Source: https://docs.wxpython.org/wx.Clipboard.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def AddData(self, data: 'DataObject') -> bool:
        """ Call this function to add the data object to the clipboard.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def Clear(self) -> None:
        """ Clears the global clipboard object and the systemâs clipboard if possible.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def Close(self) -> None:
        """ Call this function to close the clipboard, having opened it with Open .

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def Flush(self) -> bool:
        """ Flushes the clipboard: this means that the data which is currently on clipboard will stay available even after the application exits (possibly eating memory), otherwise the clipboard will be emptied on exit.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    @staticmethod
    def Get() -> 'Clipboard':
        """ Returns the global instance (wxTheClipboard) of the clipboard object.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def GetData(self, data: 'DataObject') -> bool:
        """ Call this function to fill data  with data on the clipboard, if available in the required format.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def IsOpened(self) -> bool:
        """ Returns True if the clipboard has been opened.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def IsSupported(self, format: 'DataFormat') -> bool:
        """ Returns True if there is data which matches the data format of the given data object currently available  on the clipboard.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def IsUsingPrimarySelection(self) -> bool:
        """ Returns True if we are using the primary selection, False if clipboard one.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def Open(self) -> bool:
        """ Call this function to open the clipboard before calling SetData   and GetData .

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def SetData(self, data: 'DataObject') -> bool:
        """ Call this function to set the data object to the clipboard.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """

    def UsePrimarySelection(self, primary: bool=False) -> None:
        """ On platforms supporting it (all X11-based ports),   wx.Clipboard  uses the CLIPBOARD X11 selection by default.

            Source: https://docs.wxpython.org/wx.Clipboard.html
        """



class ClipboardTextEvent(CommandEvent):
    """ This class represents the events generated by a control (typically a
TextCtrl but other windows can generate these events as well) when
its content gets copied or cut to, or pasted from the clipboard.

        Source: https://docs.wxpython.org/wx.ClipboardTextEvent.html
    """
    def __init__(self, commandType=wxEVT_NULL, id=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ClipboardTextEvent.html
        """



EVT_TEXT_COPY: int  # Some or all of the controls content was copied to the clipboard.

EVT_TEXT_CUT: int  # Some or all of the controls content was cut (i.e. copied and deleted).

EVT_TEXT_PASTE: int  # Clipboard content was pasted into the control. ^^

COPY: int

CB_READONLY: int

class TextCtrl(Control,TextEntry):
    """ A text control allows text to be displayed and edited.

        Source: https://docs.wxpython.org/wx.TextCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def Create(self, parent, id=ID_ANY, value="", pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=TextCtrlNameStr) -> bool:
        """ Creates the text control for two-step construction.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def DiscardEdits(self) -> None:
        """ Resets the internal modified flag as if the current changes had been saved.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def EmptyUndoBuffer(self) -> None:
        """ Delete the undo history.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def EmulateKeyPress(self, event: 'KeyEvent') -> bool:
        """ This function inserts into the control the character which would have been inserted if the given key event had occurred in the text control.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def GetDefaultStyle(self) -> 'TextAttr':
        """ Returns the style currently used for the new text.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def GetLineLength(self, lineNo: int) -> int:
        """ Gets the length of the specified line, not including any trailing newline character(s).

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def GetLineText(self, lineNo: int) -> str:
        """ Returns the contents of a given line in the text control, not including any trailing newline character(s).

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def GetNumberOfLines(self) -> int:
        """ Returns the number of lines in the text control buffer.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def GetStyle(self, position, style) -> bool:
        """ Returns the style at this position in the text control.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def HideNativeCaret(self) -> bool:
        """ Turn off the widgetâs native caret on Windows.
Ignored on other platforms.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def HitTestPos(self, pt) -> None:
        """ Finds the position of the character at the specified point.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def HitTest(self, pt) -> None:
        """ Finds the row and column of the character at the specified point.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def IsModified(self) -> bool:
        """ Returns True if the text has been modified by user.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def IsMultiLine(self) -> bool:
        """ Returns True if this is a multi line edit control and False otherwise.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def IsSingleLine(self) -> bool:
        """ Returns True if this is a single line edit control and False otherwise.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def LoadFile(self, filename, fileType=TEXT_TYPE_ANY) -> bool:
        """ Loads and displays the named file, if it exists.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def MacCheckSpelling(self, check) -> None:
        """ Turn on the native spell checking for the text widget on
OSX.  Ignored on other platforms.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def MarkDirty(self) -> None:
        """ Mark text as modified (dirty).

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def OSXDisableAllSmartSubstitutions(self) -> None:
        """ Mac-only method to disable all automatic text substitutions.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def OSXEnableAutomaticDashSubstitution(self, enable) -> None:
        """ Mac-only method for turning on/off automatic dash substitutions.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def OSXEnableAutomaticQuoteSubstitution(self, enable) -> None:
        """ Mac-only method for turning on/off automatic quote substitutions.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def OSXEnableNewLineReplacement(self, enable: bool) -> None:
        """ Enable the automatic replacement of new lines characters in a single-line text field with spaces under macOS.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def PositionToCoords(self, pos: int) -> 'Point':
        """ Converts given text position to client coordinates in pixels.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def PositionToXY(self, pos: int) -> tuple:
        """ Converts given position to a zero-based column, line number pair.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def SaveFile(self, filename="", fileType=TEXT_TYPE_ANY) -> bool:
        """ Saves the contents of the control in a text file.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def SetDefaultStyle(self, style: 'TextAttr') -> bool:
        """ Changes the default style to use for the new text which is going to be added to the control.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def SetModified(self, modified: bool) -> None:
        """ Marks the control as being modified by the user or not.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def SetStyle(self, start, end, style) -> bool:
        """ Changes the style of the given range.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def ShowNativeCaret(self, show=True) -> bool:
        """ Turn on the widgetâs native caret on Windows.
Ignored on other platforms.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def ShowPosition(self, pos: int) -> None:
        """ Makes the line containing the given position visible.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def XYToPosition(self, x, y) -> int:
        """ Converts the given zero based column and line number to a position.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def flush(self) -> None:
        """ NOP, for file-like compatibility.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    def write(self, text) -> None:
        """ Append text to the textctrl, for file-like compatibility.

            Source: https://docs.wxpython.org/wx.TextCtrl.html
        """

    DefaultStyle: 'TextAttr'  # See GetDefaultStyle and SetDefaultStyle
    NumberOfLines: int  # See GetNumberOfLines



TE_PROCESS_ENTER: int  # The control will generate the event  wxEVT_TEXT_ENTER   that can be handled by the program. Otherwise, i.e. either if this style not specified at all, or it is used, but there is no event handler for this event or the event handler called  wx.Event.Skip   to avoid overriding the default handling, pressing Enter key is either processed internally by the control or used to activate the default button of the dialog, if any.

TE_PROCESS_TAB: int  # Normally, TAB key is used for keyboard navigation and pressing it in a control switches focus to the next one. With this style, this wonât happen and if the TAB is not otherwise processed (e.g. by  wxEVT_CHAR   event handler), a literal TAB character is inserted into the control. Notice that this style has no effect for single-line text controls when using wxGTK.

TE_MULTILINE: int  # The text control allows multiple lines. If this style is not specified, line break characters should not be used in the controls value.

TE_PASSWORD: int  # The text will be echoed as asterisks.

TE_READONLY: int  # The text will not be user-editable.

TE_RICH: int  # Use rich text control under MSW, this allows having more than 64KB of text in the control. This style is ignored under other platforms and it is recommended to use wx.TE_RICH2 instead of it under MSW.

TE_RICH2: int  # Use rich text control version 2.0 or higher under MSW, this style is ignored under other platforms. Note that this style may be turned on automatically even if it is not used explicitly when creating a text control with a long (i.e. much more than 64KiB) initial text, as creating the control would simply fail in this case under MSW if neither this style nor wx.TE_RICH is used.

TE_AUTO_URL: int  # Highlight the URLs and generate the TextUrlEvents when mouse events occur over them.

TE_NOHIDESEL: int  # By default, the Windows text control doesnât show the selection when it doesnât have focus - use this style to force it to always show it. It doesnât do anything under other platforms.

HSCROLL: int  # A horizontal scrollbar will be created and used, so that text wonât be wrapped.

TE_NO_VSCROLL: int  # For multiline controls only: vertical scrollbar will never be created. This limits the amount of text which can be entered into the control to what can be displayed in it under wxMSW but not under wxGTK or wxOSX. Currently not implemented for the other platforms.

TE_LEFT: int  # The text in the control will be left-justified (default).

TE_CENTRE: int  # The text in the control will be centered (wxMSW, wxGTK, wxOSX).

TE_RIGHT: int  # The text in the control will be right-justified (wxMSW, wxGTK, wxOSX).

TE_DONTWRAP: int  # Same as wx.HSCROLL style: donât wrap at all, show horizontal scrollbar instead.

TE_CHARWRAP: int  # For multiline controls only: wrap the lines too long to be shown entirely at any position (wxUniv, wxGTK, wxOSX).

TE_WORDWRAP: int  # For multiline controls only: wrap the lines too long to be shown entirely at word boundaries (wxUniv, wxMSW, wxGTK, wxOSX).

TE_BESTWRAP: int  # For multiline controls only: wrap the lines at word boundaries or at any other character if there are words longer than the window width (this is the default).

TE_CAPITALIZE: int  # On PocketPC and Smartphone, causes the first letter to be capitalized. ^^

EVT_TEXT: int  # Respond to a  wxEVT_TEXT   event, generated when the text changes. Notice that this event will be sent when the text controls contents changes  â wx.TextCtrl.SetValue   is called); see wx.TextCtrl.ChangeValue   for a function which does not send this event. This event is however not sent during the control creation.

EVT_TEXT_ENTER: int  # Respond to a  wxEVT_TEXT_ENTER   event, generated when enter is pressed in a text control which must have wx.TE_PROCESS_ENTER style for this event to be generated.

EVT_TEXT_URL: int  # A mouse event occurred over an URL in the text control.

EVT_TEXT_MAXLEN: int  # This event is generated when the user tries to enter more text into the control than the limit set by wx.TextCtrl.SetMaxLength , see its description. ^^

class CloseEvent(Event):
    """ This event class contains information about window and session close
events.

        Source: https://docs.wxpython.org/wx.CloseEvent.html
    """
    def __init__(self, commandEventType=wxEVT_NULL, id=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.CloseEvent.html
        """

    def CanVeto(self) -> bool:
        """ Returns True if you can veto a system shutdown or a window close event.

            Source: https://docs.wxpython.org/wx.CloseEvent.html
        """

    def GetLoggingOff(self) -> bool:
        """ Returns True if the user is just logging off or False if the system is shutting down.

            Source: https://docs.wxpython.org/wx.CloseEvent.html
        """

    def GetVeto(self) -> bool:
        """ Returns whether the Veto flag was set.

            Source: https://docs.wxpython.org/wx.CloseEvent.html
        """

    def SetCanVeto(self, canVeto: bool) -> None:
        """ Sets the âcan vetoâ flag.

            Source: https://docs.wxpython.org/wx.CloseEvent.html
        """

    def SetLoggingOff(self, loggingOff: bool) -> None:
        """ Sets the âlogging offâ flag.

            Source: https://docs.wxpython.org/wx.CloseEvent.html
        """

    def Veto(self, veto: bool=True) -> None:
        """ Call this from your event handler to veto a system shutdown or to signal to the calling application that a window close did not happen.

            Source: https://docs.wxpython.org/wx.CloseEvent.html
        """

    LoggingOff: bool  # See GetLoggingOff and SetLoggingOff



EVT_CLOSE: int  # Process a  wxEVT_CLOSE_WINDOW   command event, supplying the member function. This event applies to    wx.Frame  and   wx.Dialog  classes.

EVT_QUERY_END_SESSION: int  # Process a  wxEVT_QUERY_END_SESSION   session event, supplying the member function. This event can be handled in App-derived class only.

EVT_END_SESSION: int  # Process a  wxEVT_END_SESSION   session event, supplying the member function. This event can be handled in App-derived class only. ^^

class CollapsibleHeaderCtrl(Control):
    """ Header control above a collapsible pane.

        Source: https://docs.wxpython.org/wx.CollapsibleHeaderCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.CollapsibleHeaderCtrl.html
        """

    def Create(self, parent, id=ID_ANY, label="", pos=DefaultPosition, size=DefaultSize, style=BORDER_NONE, validator=DefaultValidator, name=CollapsibleHeaderCtrlNameStr) -> bool:
        """ Create the control initialized using the default constructor.

            Source: https://docs.wxpython.org/wx.CollapsibleHeaderCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.CollapsibleHeaderCtrl.html
        """

    def IsCollapsed(self) -> bool:
        """ Returns  true   if the control is collapsed.

            Source: https://docs.wxpython.org/wx.CollapsibleHeaderCtrl.html
        """

    def SetCollapsed(self, collapsed: bool=True) -> None:
        """ Set collapsed state of the header.

            Source: https://docs.wxpython.org/wx.CollapsibleHeaderCtrl.html
        """



EVT_COLLAPSIBLEHEADER_CHANGED: int  # User changed the collapsed state. ^^

class CollapsiblePane(Control):
    """ A collapsible pane is a container with an embedded button-like control
which can be used by the user to collapse or expand the paneâs
contents.

        Source: https://docs.wxpython.org/wx.CollapsiblePane.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    def Collapse(self, collapse: bool=True) -> None:
        """ Collapses or expands the pane window.

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    def Create(self, parent, id=ID_ANY, label="", pos=DefaultPosition, size=DefaultSize, style=CP_DEFAULT_STYLE, validator=DefaultValidator, name=CollapsiblePaneNameStr) -> bool:
        """ parent (wx.Window) â Parent window, must not be not None.

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    def Expand(self) -> None:
        """ Same as calling Collapse(false).

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    def GetPane(self) -> 'Window':
        """ Returns a pointer to the pane window.

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    def IsCollapsed(self) -> bool:
        """ Returns True if the pane window is currently hidden.

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    def IsExpanded(self) -> bool:
        """ Returns True if the pane window is currently shown.

            Source: https://docs.wxpython.org/wx.CollapsiblePane.html
        """

    Pane: 'Window'  # See GetPane



CP_DEFAULT_STYLE: int  # The default style. It includes wx.TAB_TRAVERSAL and wx.BORDER_NONE.

CP_NO_TLW_RESIZE: int  # By default   wx.CollapsiblePane  resizes the top level window containing it when its own size changes. This allows easily implementing dialogs containing an optionally shown part, for example, and so is the default behaviour but can be inconvenient in some specific cases â

EVT_COLLAPSIBLEPANE_CHANGED: int  # The user expanded or collapsed the collapsible pane.

EVT_NAVIGATION_KEY: int  # Process a navigation key event. ^^

TAB_TRAVERSAL: int

class CollapsiblePaneEvent(CommandEvent):
    """ This event class is used for the events generated by
CollapsiblePane.

        Source: https://docs.wxpython.org/wx.CollapsiblePaneEvent.html
    """
    def __init__(self, generator, id, collapsed) -> None:
        """ The constructor is not normally used by the user code.

            Source: https://docs.wxpython.org/wx.CollapsiblePaneEvent.html
        """

    def GetCollapsed(self) -> bool:
        """ Returns True if the pane has been collapsed.

            Source: https://docs.wxpython.org/wx.CollapsiblePaneEvent.html
        """

    def SetCollapsed(self, collapsed: bool) -> None:
        """ Sets this as a collapsed pane event (if collapsed  is True) or as an expanded pane event (if collapsed  is False).

            Source: https://docs.wxpython.org/wx.CollapsiblePaneEvent.html
        """

    Collapsed: bool  # See GetCollapsed and SetCollapsed



class Colour(Object):
    """ A colour is an object representing a combination of Red, Green, and
Blue (RGB) intensity values and an Alpha value, and is used to
determine drawing colours.

        Source: https://docs.wxpython.org/wx.Colour.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def Alpha(self) -> int:
        """ Returns the alpha value, on platforms where alpha is not yet supported, this always returns wx.ALPHA_OPAQUE.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    @staticmethod
    def AlphaBlend(fg, bg, alpha) -> int:
        """ Blend colour, taking alpha into account.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def Blue(self) -> int:
        """ Returns the blue intensity.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def ChangeLightness(self, *args, **kw) -> 'Colour':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def Get(self, includeAlpha=True) -> tuple:
        """ Returns the RGB intensity values as a tuple, optionally the alpha value as well.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetAlpha(self) -> int:
        """ Returns the alpha value, on platforms where alpha is not yet supported, this always returns wx.ALPHA_OPAQUE.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetAsString(self, flags: int=C2S_NAME|C2S_CSS_SYNTAX) -> str:
        """ Converts this colour to a String       using the given flags.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetBlue(self) -> int:
        """ Returns the blue intensity as  int.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetGreen(self) -> int:
        """ Returns the green intensity as  int.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetIM(self) -> None:
        """ Returns an immutable representation of the wx.Colour object, based on namedtuple.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetLuminance(self) -> float:
        """ Return the perceived brightness of the colour.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetPixel(self) -> int:
        """ wx.IntPtr

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetRGB(self) -> int:
        """ Gets the RGB or RGBA colour values as a single 32 bit value.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetRGBA(self) -> int:
        """ Gets the RGB or RGBA colour values as a single 32 bit value.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def GetRed(self) -> int:
        """ Returns the red intensity as  int.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def Green(self) -> int:
        """ Returns the green intensity.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the colour object is valid (the colour has been initialised with RGB values).

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def IsSolid(self) -> bool:
        """ Returns True if the color can be described using RGB values, i.e.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def MakeDisabled(self, *args, **kw) -> 'Colour':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    @staticmethod
    def MakeGrey(*args, **kw) -> tuple:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    @staticmethod
    def MakeMono(on: bool) -> tuple:
        """ Assigns the same value to r, g, b:  0 if on  is  false , 255 otherwise.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def Red(self) -> int:
        """ Returns the red intensity.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def Set(self, *args, **kw) -> None:
        """ Sets the RGB intensity values using the given values (first overload), extracting them from the packed long (second overload), using the given string (third overload).

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def SetRGB(self, colRGB: 'int') -> None:
        """ Sets the RGB or RGBA colour values from a single 32 bit value.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def SetRGBA(self, colRGBA: 'int') -> None:
        """ Sets the RGB or RGBA colour values from a single 32 bit value.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __getitem__(self, idx) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __len__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __reduce__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __repr__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __setitem__(self, idx, val) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __str__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def _copyFrom(self, other) -> None:
        """ For internal use only.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Tests the inequality of two colours by comparing individual red, green, blue intensities and alpha values.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Tests the equality of two colours by comparing individual red, green, blue intensities and alpha values.

            Source: https://docs.wxpython.org/wx.Colour.html
        """

    Pixel: int  # See GetPixel
    RGB: int  # See GetRGB and SetRGB
    RGBA: int  # See GetRGBA and SetRGBA
    alpha: Any  # See Alpha
    blue: Any  # See Blue
    green: Any  # See Green
    red: Any  # See Red



class ColourData(Object):
    """ This class holds a variety of information related to colour dialogs.

        Source: https://docs.wxpython.org/wx.ColourData.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def FromString(self, str: str) -> bool:
        """ Decodes the given string, which should be in the same format returned by wx.ToString     , and sets the internal colours.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def GetChooseAlpha(self) -> bool:
        """ Indicates whether the colour dialog will display alpha values and an opacity selector.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def GetChooseFull(self) -> bool:
        """ Under Windows, determines whether the Windows colour dialog will display the full dialog with custom colour selection controls.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def GetColour(self) -> 'Colour':
        """ Gets the current colour associated with the colour dialog.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def GetCustomColour(self, i: int) -> 'Colour':
        """ Returns custom colours associated with the colour dialog.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def SetChooseAlpha(self, flag: bool) -> None:
        """ Tells the colour dialog to show alpha values and an opacity selector (slider).

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def SetChooseFull(self, flag: bool) -> None:
        """ Under Windows, tells the Windows colour dialog to display the full dialog with custom colour selection controls.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def SetColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the default colour for the colour dialog.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def SetCustomColour(self, i, colour) -> None:
        """ Sets custom colours for the colour dialog.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    def ToString(self) -> str:
        """ Converts the colours saved in this class in a string form, separating the various colours with a comma.

            Source: https://docs.wxpython.org/wx.ColourData.html
        """

    ChooseAlpha: bool  # See GetChooseAlpha and SetChooseAlpha
    ChooseFull: bool  # See GetChooseFull and SetChooseFull
    Colour: '_Colour'  # See GetColour and SetColour



class ColourDatabase:
    """ wxWidgets maintains a database of standard RGB colours for a
predefined set of named colours.

        Source: https://docs.wxpython.org/wx.ColourDatabase.html
    """
    def __init__(self) -> None:
        """ Constructs the colour database.

            Source: https://docs.wxpython.org/wx.ColourDatabase.html
        """

    def AddColour(self, colourName, colour) -> None:
        """ Adds a colour to the database.

            Source: https://docs.wxpython.org/wx.ColourDatabase.html
        """

    def Find(self, colourName: str) -> 'Colour':
        """ Finds a colour given the name.

            Source: https://docs.wxpython.org/wx.ColourDatabase.html
        """

    def FindColour(self, colour) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ColourDatabase.html
        """

    def FindName(self, colour: Union[int, str, 'Colour']) -> str:
        """ Finds a colour name given the colour.

            Source: https://docs.wxpython.org/wx.ColourDatabase.html
        """



_ColourData: TypeAlias = ColourData

class ColourDialog(Dialog):
    """ This class represents the colour chooser dialog.

        Source: https://docs.wxpython.org/wx.ColourDialog.html
    """
    def __init__(self, parent, data=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ColourDialog.html
        """

    def Create(self, parent, data=None) -> bool:
        """ Same as   wx.ColourDialog.

            Source: https://docs.wxpython.org/wx.ColourDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ColourDialog.html
        """

    def GetColourData(self) -> 'ColourData':
        """ Returns the colour data associated with the colour dialog.

            Source: https://docs.wxpython.org/wx.ColourDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning wx.ID_OK if the user pressed wx.OK, and wx.ID_CANCEL otherwise.

            Source: https://docs.wxpython.org/wx.ColourDialog.html
        """

    ColourData: '_ColourData'  # See GetColourData



class ColourDialogEvent(CommandEvent):
    """ This event class is used for the events generated by ColourDialog.

        Source: https://docs.wxpython.org/wx.ColourDialogEvent.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ColourDialogEvent.html
        """

    def GetColour(self) -> 'Colour':
        """ Retrieve the colour the user has just selected.

            Source: https://docs.wxpython.org/wx.ColourDialogEvent.html
        """

    def SetColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Set the colour to be sent with the event.

            Source: https://docs.wxpython.org/wx.ColourDialogEvent.html
        """

    Colour: '_Colour'  # See GetColour and SetColour



EVT_COLOUR_CHANGED: int  # Generated whenever the currently selected colour in the dialog changes. This event is currently only implemented in wxMSW. ^^

class ColourPickerCtrl(PickerBase):
    """ This control allows the user to select a colour.

        Source: https://docs.wxpython.org/wx.ColourPickerCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ColourPickerCtrl.html
        """

    def Create(self, parent, id=ID_ANY, colour=BLACK, pos=DefaultPosition, size=DefaultSize, style=CLRP_DEFAULT_STYLE, validator=DefaultValidator, name=ColourPickerCtrlNameStr) -> bool:
        """ Creates a colour picker with the given arguments.

            Source: https://docs.wxpython.org/wx.ColourPickerCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ColourPickerCtrl.html
        """

    def GetColour(self) -> 'Colour':
        """ Returns the currently selected colour.

            Source: https://docs.wxpython.org/wx.ColourPickerCtrl.html
        """

    def SetColour(self, *args, **kw) -> None:
        """ Sets the currently selected colour.

            Source: https://docs.wxpython.org/wx.ColourPickerCtrl.html
        """

    Colour: '_Colour'  # See GetColour and SetColour



CLRP_DEFAULT_STYLE: int  # The default style: 0.

CLRP_USE_TEXTCTRL: int  # Creates a text control to the left of the picker button which is completely managed by the   wx.ColourPickerCtrl  and which can be used by the user to specify a colour (see SetColour). The text control is automatically synchronized with buttonâs value. Use functions defined in   wx.PickerBase  to modify the text control.

CLRP_SHOW_LABEL: int  # Shows the colour in HTML form (AABBCC) as colour button label (instead of no label at all).

CLRP_SHOW_ALPHA: int  # Allows selecting opacity in the colour-chooser (effective under wxGTK and wxOSX). ^^

EVT_COLOURPICKER_CHANGED: int  # The user changed the colour selected in the control either using the button or using text control (see  CLRP_USE_TEXTCTRL ; note that in this case the event is fired only if the userâs input is valid, i.e. recognizable). When using a popup dialog for changing the colour, this event is sent only when the changes in the dialog are accepted by the user, unlike   EVT_COLOURPICKER_CURRENT_CHANGED .

EVT_COLOURPICKER_CURRENT_CHANGED: int  # The user changed the currently selected colour in the dialog associated with the control. This event is sent immediately when the selection changes and you must also handle  EVT_COLOUR_CANCELLED   to revert to the previously selected colour if the selection ends up not being accepted. This event is new since wxWidgets 3.1.3 and currently is only implemented in wxMSW.

EVT_COLOURPICKER_DIALOG_CANCELLED: int  # The user cancelled the colour dialog associated with the control, i.e. closed it without accepting the selection. This event is new since wxWidgets 3.1.3 and currently is only implemented in wxMSW. ^^

class ColourPickerEvent(CommandEvent):
    """ This event class is used for the events generated by
ColourPickerCtrl.

        Source: https://docs.wxpython.org/wx.ColourPickerEvent.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ColourPickerEvent.html
        """

    def GetColour(self) -> 'Colour':
        """ Retrieve the colour the user has just selected.

            Source: https://docs.wxpython.org/wx.ColourPickerEvent.html
        """

    def SetColour(self, pos: Union[int, str, 'Colour']) -> None:
        """ Set the colour associated with the event.

            Source: https://docs.wxpython.org/wx.ColourPickerEvent.html
        """

    Colour: '_Colour'  # See GetColour and SetColour



class ComboBox(Control,ItemContainer,TextEntry):
    """ A combobox is like a combination of an edit control and a listbox.

        Source: https://docs.wxpython.org/wx.ComboBox.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def Create(self, parent, id=ID_ANY, value="", pos=DefaultPosition, size=DefaultSize, choices=[], style=0, validator=DefaultValidator, name=ComboBoxNameStr) -> bool:
        """ Creates the combobox for two-step construction.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def Dismiss(self) -> None:
        """ Hides the list box portion of the combo box.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def FindString(self, string, caseSensitive=False) -> int:
        """ Finds an item whose label matches the given string.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def GetCount(self) -> int:
        """ Returns the number of items in the control.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def GetCurrentSelection(self) -> int:
        """ Returns the item being selected right now.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def GetInsertionPoint(self) -> int:
        """ Same as wx.TextEntry.GetInsertionPoint .

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def GetSelection(self) -> int:
        """ Returns the index of the selected item or  NOT_FOUND   if no item is selected.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def GetTextSelection(self) -> tuple:
        """ Gets the current selection span.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def GetString(self, n: int) -> str:
        """ Returns the label of the item with the given index.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def GetStringSelection(self) -> str:
        """ Gets the text currently selected in the control.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def IsListEmpty(self) -> bool:
        """ Returns True if the list of combobox choices is empty.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def IsTextEmpty(self) -> bool:
        """ Returns True if the text of the combobox is empty.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def Popup(self) -> None:
        """ Shows the list box portion of the combo box.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def SetSelection(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def SetString(self, n, text) -> None:
        """ Changes the text of the specified combobox item.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def SetTextSelection(self, from_, to_) -> None:
        """ Same as wx.TextEntry.SetSelection .

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    def SetValue(self, text: str) -> None:
        """ Sets the text for the combobox text field.

            Source: https://docs.wxpython.org/wx.ComboBox.html
        """

    Count: int  # See GetCount
    CurrentSelection: int  # See GetCurrentSelection
    InsertionPoint: int  # See GetInsertionPoint
    Selection: int  # See GetSelection and SetSelection
    StringSelection: str  # See GetStringSelection



CB_SIMPLE: int  # Creates a combobox with a permanently displayed list. Windows only.

CB_DROPDOWN: int  # Creates a combobox with a drop-down list. MSW and Motif only.

EVT_COMBOBOX: int  # Process a  wxEVT_COMBOBOX   event, when an item on the list is selected. Note that calling  GetValue  returns the new value of selection.

EVT_COMBOBOX_DROPDOWN: int  # Process a  wxEVT_COMBOBOX_DROPDOWN   event, which is generated when the list box part of the combo box is shown (drops down). Notice that this event is only supported by wxMSW, wxGTK with GTK+ 2.10 or later, and OSX/Cocoa.

EVT_COMBOBOX_CLOSEUP: int  # Process a  wxEVT_COMBOBOX_CLOSEUP   event, which is generated when the list box of the combo box disappears (closes up). This event is only generated for the same platforms as   wxEVT_COMBOBOX_DROPDOWN   above. ^^

_TextCtrl: TypeAlias = TextCtrl

class ComboCtrl(Control,TextEntry):
    """ A combo control is a generic combobox that allows totally custom
popup.

        Source: https://docs.wxpython.org/wx.ComboCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def AnimateShow(self, rect, flags) -> bool:
        """ This member function is not normally called in application code.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Copy(self) -> None:
        """ Copies the selected text to the clipboard.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Create(self, parent, id=ID_ANY, value="", pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ComboBoxNameStr) -> bool:
        """ Creates the combo control for two-step construction.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Cut(self) -> None:
        """ Copies the selected text to the clipboard and removes the selection.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Dismiss(self) -> None:
        """ Dismisses the popup window.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def DoSetPopupControl(self, popup: 'ComboPopup') -> None:
        """ This member function is not normally called in application code.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def DoShowPopup(self, rect, flags) -> None:
        """ This member function is not normally called in application code.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def EnablePopupAnimation(self, enable: bool=True) -> None:
        """ Enables or disables popup animation, if any, depending on the value of the argument.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetBitmapDisabled(self) -> 'Bitmap':
        """ Returns disabled button bitmap that has been set with SetButtonBitmaps .

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetBitmapHover(self) -> 'Bitmap':
        """ Returns button mouse hover bitmap that has been set with SetButtonBitmaps .

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetBitmapNormal(self) -> 'Bitmap':
        """ Returns default button bitmap that has been set with SetButtonBitmaps .

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetBitmapPressed(self) -> 'Bitmap':
        """ Returns depressed button bitmap that has been set with SetButtonBitmaps .

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetButtonSize(self) -> 'Size':
        """ Returns current size of the dropdown button.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetCustomPaintWidth(self) -> int:
        """ Returns custom painted area in control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    @staticmethod
    def GetFeatures() -> int:
        """ Returns features supported by   wx.ComboCtrl.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetHint(self) -> str:
        """ Returns the current hint string.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetInsertionPoint(self) -> int:
        """ Returns the insertion point for the combo controlâs text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetLastPosition(self) -> int:
        """ Returns the last position in the combo control text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetMargins(self) -> 'Point':
        """ Returns the margins used by the control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetPopupControl(self) -> 'ComboPopup':
        """ Returns current popup interface that has been set with SetPopupControl .

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetPopupWindow(self) -> 'Window':
        """ Returns popup window containing the popup control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetTextCtrl(self) -> 'TextCtrl':
        """ Get the text control which is part of the combo control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetTextRect(self) -> 'Rect':
        """ Returns area covered by the text field (includes everything except borders and the dropdown button).

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def GetValue(self) -> str:
        """ Returns text representation of the current value.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def HidePopup(self, generateEvent: bool=False) -> None:
        """ Dismisses the popup window.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def IsKeyPopupToggle(self, event: 'KeyEvent') -> bool:
        """ Returns True if given key combination should toggle the popup.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def IsPopupShown(self) -> bool:
        """ Returns True if the popup is currently shown.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def IsPopupWindowState(self, state: int) -> bool:
        """ Returns True if the popup window is in the given state.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def OnButtonClick(self) -> None:
        """ Implement in a derived class to define what happens on dropdown button click.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Paste(self) -> None:
        """ Pastes text from the clipboard to the text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Popup(self) -> None:
        """ Shows the popup portion of the combo control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def PrepareBackground(self, dc, rect, flags) -> None:
        """ Prepare background of combo control or an item in a dropdown list in a way typical on platform.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Remove(self, frm, to) -> None:
        """ Removes the text between the two positions in the combo control text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Replace(self, frm, to, text) -> None:
        """ Replaces the text between two positions with the given text, in the combo control text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetButtonBitmaps(*args, **kwargs) -> None:
        """ Sets custom dropdown button graphics.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetButtonPosition(self, width=-1, height=-1, side=RIGHT, spacingX=0) -> None:
        """ Sets size and position of dropdown button.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetCustomPaintWidth(self, width: int) -> None:
        """ Set width, in pixels, of custom painted area in control without  CB_READONLY   style.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetHint(self, hint: str) -> bool:
        """ Sets a hint shown in an empty unfocused combo control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetInsertionPoint(self, pos: int) -> None:
        """ Sets the insertion point in the text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetInsertionPointEnd(self) -> None:
        """ Sets the insertion point at the end of the combo control text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetMainControl(self, win: 'Window') -> None:
        """ Uses the given window instead of the default text control as the main window of the combo control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetMargins(self, *args, **kw) -> None:
        """ Attempts to set the control margins.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetPopupAnchor(self, anchorSide: int) -> None:
        """ Set side of the control to which the popup will align itself.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetPopupControl(self, popup: 'ComboPopup') -> None:
        """ Set popup interface class derived from   wx.ComboPopup.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetPopupExtents(self, extLeft, extRight) -> None:
        """ Extends popup size horizontally, relative to the edges of the combo control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetPopupMaxHeight(self, height: int) -> None:
        """ Sets preferred maximum height of the popup.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetPopupMinWidth(self, width: int) -> None:
        """ Sets minimum width of the popup.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetSelection(self, frm, to) -> None:
        """ Selects the text between the two positions, in the combo control text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetText(self, value: str) -> None:
        """ Sets the text for the text field without affecting the popup.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetTextCtrlStyle(self, style: int) -> None:
        """ Set a custom window style for the embedded   wx.TextCtrl.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetValue(self, value: str) -> None:
        """ Sets the text for the combo control text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def SetValueByUser(self, value: str) -> None:
        """ Changes value of the control as if user had done it by selecting an item from a combo box drop-down list.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def ShouldDrawFocus(self) -> bool:
        """ Returns True if focus indicator should be drawn in the control.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def ShowPopup(self) -> None:
        """ Show the popup.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def Undo(self) -> None:
        """ Undoes the last edit in the text field.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    def UseAltPopupWindow(self, enable: bool=True) -> None:
        """ Enable or disable usage of an alternative popup window, which guarantees ability to focus the popup control, and allows common native controls to function normally.

            Source: https://docs.wxpython.org/wx.ComboCtrl.html
        """

    BitmapDisabled: 'Bitmap'  # See GetBitmapDisabled
    BitmapHover: 'Bitmap'  # See GetBitmapHover
    BitmapNormal: 'Bitmap'  # See GetBitmapNormal
    BitmapPressed: 'Bitmap'  # See GetBitmapPressed
    ButtonSize: 'Size'  # See GetButtonSize
    CustomPaintWidth: int  # See GetCustomPaintWidth and SetCustomPaintWidth
    Hint: str  # See GetHint and SetHint
    InsertionPoint: int  # See GetInsertionPoint and SetInsertionPoint
    LastPosition: int  # See GetLastPosition
    Margins: 'Point'  # See GetMargins and SetMargins
    PopupControl: 'ComboPopup'  # See GetPopupControl and SetPopupControl
    PopupWindow: 'Window'  # See GetPopupWindow
    TextCtrl: '_TextCtrl'  # See GetTextCtrl
    TextRect: 'Rect'  # See GetTextRect
    Value: str  # See GetValue and SetValue



CC_SPECIAL_DCLICK: int  # Double-clicking triggers a call to popupâs OnComboDoubleClick. Actual behaviour is defined by a derived class. For instance,   wx.adv.OwnerDrawnComboBox  will cycle an item. This style only applies if wx.CB_READONLY is used as well.

CC_STD_BUTTON: int  # Drop button will behave more like a standard push button. ^^

CONTROL_ISSUBMENU: int

CONTROL_SELECTED: int

CONTROL_DISABLED: int

class ComboCtrlFeatures:
    """ Features enabled for ComboCtrl.

        Source: https://docs.wxpython.org/wx.ComboCtrlFeatures.html
    """


_ComboCtrl: TypeAlias = ComboCtrl

class ComboPopup:
    """ In order to use a custom popup with ComboCtrl, an interface class
must be derived from ComboPopup.

        Source: https://docs.wxpython.org/wx.ComboPopup.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def Create(self, parent: 'Window') -> bool:
        """ The derived class must implement this to create the popup control.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def DestroyPopup(self) -> None:
        """ You only need to implement this member function if you create your popup class in non-standard way.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def Dismiss(self) -> None:
        """ Utility function that hides the popup.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def FindItem(self, item, trueItem=None) -> bool:
        """ Implement to customize matching of value string to an item container entry.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def GetAdjustedSize(self, minWidth, prefHeight, maxHeight) -> 'Size':
        """ The derived class may implement this to return adjusted size for the popup control, according to the variables given.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def GetComboCtrl(self) -> 'ComboCtrl':
        """ Returns pointer to the associated parent   wx.ComboCtrl.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def GetControl(self) -> 'Window':
        """ The derived class must implement this to return pointer to the associated control created in Create .

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def GetStringValue(self) -> str:
        """ The derived class must implement this to return string representation of the value.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def Init(self) -> None:
        """ The derived class must implement this to initialize its internal variables.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def IsCreated(self) -> bool:
        """ Utility method that returns True if Create has been called.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def LazyCreate(self) -> bool:
        """ The derived class may implement this to return True if it wants to delay call to Create   until the popup is shown for the first time.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def OnComboDoubleClick(self) -> None:
        """ The derived class may implement this to do something when the parent   wx.ComboCtrl  gets double-clicked.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def OnComboKeyEvent(self, event: 'KeyEvent') -> None:
        """ The derived class may implement this to receive key events from the parent   wx.ComboCtrl.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def OnDismiss(self) -> None:
        """ The derived class may implement this to do special processing when popup is hidden.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def OnPopup(self) -> None:
        """ The derived class may implement this to do special processing when popup is shown.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def PaintComboControl(self, dc, rect) -> None:
        """ The derived class may implement this to paint the parent   wx.ComboCtrl.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    def SetStringValue(self, value: str) -> None:
        """ The derived class must implement this to receive string value changes from   wx.ComboCtrl.

            Source: https://docs.wxpython.org/wx.ComboPopup.html
        """

    ComboCtrl: '_ComboCtrl'  # See GetComboCtrl
    Control: 'Window'  # See GetControl
    StringValue: str  # See GetStringValue and SetStringValue



class Command(Object):
    """ Command is a base class for modelling an application command, which
is an action usually performed by selecting a menu item, pressing a
toolbar button or any other means provided by the application to
change the data or view.

        Source: https://docs.wxpython.org/wx.Command.html
    """
    def __init__(self, canUndo=False, name="") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.Command.html
        """

    def CanUndo(self) -> bool:
        """ Returns True if the command can be undone, False otherwise.

            Source: https://docs.wxpython.org/wx.Command.html
        """

    def Do(self) -> bool:
        """ Override this member function to execute the appropriate action when called.

            Source: https://docs.wxpython.org/wx.Command.html
        """

    def GetName(self) -> str:
        """ Returns the command name.

            Source: https://docs.wxpython.org/wx.Command.html
        """

    def Undo(self) -> bool:
        """ Override this member function to un-execute a previous Do.

            Source: https://docs.wxpython.org/wx.Command.html
        """

    Name: str  # See GetName



class CommandEvent(Event):
    """ This event class contains information about command events, which
originate from a variety of simple controls.

        Source: https://docs.wxpython.org/wx.CommandEvent.html
    """
    def __init__(self, commandEventType=wxEVT_NULL, id=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def GetClientData(self) -> 'ClientData':
        """ Returns client object pointer for a listbox or choice selection event (not valid for a deselection).

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def GetClientObject(self) -> Any:
        """ Alias for GetClientData

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def GetExtraLong(self) -> int:
        """ Returns extra information dependent on the event objects type.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def GetInt(self) -> int:
        """ Returns the integer identifier corresponding to a listbox, choice or radiobox selection (only if the event was a selection, not a deselection), or a boolean value representing the value of a checkbox.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def GetSelection(self) -> int:
        """ Returns item index for a listbox or choice selection event (not valid for a deselection).

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def GetString(self) -> str:
        """ Returns item string for a listbox or choice selection event.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def IsChecked(self) -> bool:
        """ This method can be used with checkbox and menu events: for the checkboxes, the method returns True for a selection event and False for a deselection one.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def IsSelection(self) -> bool:
        """ For a listbox or similar event, returns True if it is a selection, False if it is a deselection.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def SetClientData(self, data: ClientData) -> None:
        """ Sets the client object for this event.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def SetClientObject(self, data) -> Any:
        """ Alias for SetClientData

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def SetExtraLong(self, extraLong: int) -> None:
        """ Sets the m_extraLong  member.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def SetInt(self, intCommand: int) -> None:
        """ Sets the m_commandInt  member.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    def SetString(self, string: str) -> None:
        """ Sets the m_commandString  member.

            Source: https://docs.wxpython.org/wx.CommandEvent.html
        """

    ClientData: '_ClientData'  # See GetClientData and SetClientData
    ExtraLong: int  # See GetExtraLong and SetExtraLong
    Int: int  # See GetInt and SetInt
    Selection: int  # See GetSelection
    String: str  # See GetString and SetString



EVT_COMMAND: int  # Process a command, supplying the window identifier, command event identifier, and member function.

EVT_COMMAND_RANGE: int  # Process a command for a range of window identifiers, supplying the minimum and maximum window identifiers, command event identifier, and member function.

EVT_MENU: int  # Process a  wxEVT_MENU   command, which is generated by a menu item.

EVT_MENU_RANGE: int  # Process a  wxEVT_MENU   command, which is generated by a range of menu items.

EVT_CONTEXT_MENU: int  # Process the event generated when the user has requested a popup menu to appear by pressing a special keyboard key (under Windows) or by right clicking the mouse.

EVT_RADIOBOX: int  # Process a  wxEVT_RADIOBOX   command, which is generated by a    wx.RadioBox  control.

EVT_RADIOBUTTON: int  # Process a  wxEVT_RADIOBUTTON   command, which is generated by a    wx.RadioButton  control.

EVT_SCROLLBAR: int  # Process a  wxEVT_SCROLLBAR   command, which is generated by a    wx.ScrollBar  control. This is provided for compatibility only; more specific scrollbar event macros should be used instead (see   wx.ScrollEvent).

EVT_SLIDER: int  # Process a  wxEVT_SLIDER   command, which is generated by a    wx.Slider  control.

EVT_TOOL: int  # Process a  wxEVT_TOOL   event (a synonym for   wxEVT_MENU ). Pass the id of the tool.

EVT_TOOL_RANGE: int  # Process a  wxEVT_TOOL   event for a range of identifiers. Pass the ids of the tools.

EVT_TOOL_RCLICKED: int  # Process a  wxEVT_TOOL_RCLICKED   event. Pass the id of the tool. (Not available on wxOSX.)

EVT_TOOL_RCLICKED_RANGE: int  # Process a  wxEVT_TOOL_RCLICKED   event for a range of ids. Pass the ids of the tools. (Not available on wxOSX.)

EVT_TOOL_ENTER: int  # Process a  wxEVT_TOOL_ENTER   event. Pass the id of the toolbar itself. The value of  wx.CommandEvent.GetSelection   is the tool id, or -1 if the mouse cursor has moved off a tool. (Not available on wxOSX.)

EVT_COMMAND_LEFT_CLICK: int  # Process a  wxEVT_COMMAND_LEFT_CLICK   command, which is generated by a control (wxMSW only).

EVT_COMMAND_LEFT_DCLICK: int  # Process a  wxEVT_COMMAND_LEFT_DCLICK   command, which is generated by a control (wxMSW only).

EVT_COMMAND_RIGHT_CLICK: int  # Process a  wxEVT_COMMAND_RIGHT_CLICK   command, which is generated by a control (wxMSW only).

EVT_COMMAND_SET_FOCUS: int  # Process a  wxEVT_COMMAND_SET_FOCUS   command, which is generated by a control (wxMSW only).

EVT_COMMAND_KILL_FOCUS: int  # Process a  wxEVT_COMMAND_KILL_FOCUS   command, which is generated by a control (wxMSW only).

EVT_COMMAND_ENTER: int  # Process a  wxEVT_COMMAND_ENTER   command, which is generated by a control. ^^

class CommandProcessor(Object):
    """ CommandProcessor is a class that maintains a history of Commands,
with undo/redo functionality built-in.

        Source: https://docs.wxpython.org/wx.CommandProcessor.html
    """
    def __init__(self, maxCommands: int=-1) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def CanRedo(self) -> bool:
        """ Returns True if the currently-active command can be redone, False otherwise.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def CanUndo(self) -> bool:
        """ Returns True if the currently-active command can be undone, False otherwise.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def ClearCommands(self) -> None:
        """ Deletes all commands in the list and sets the current command pointer to None.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetCommands(self) -> 'CommandList':
        """ Returns the list of commands.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetCurrentCommand(self) -> 'Command':
        """ Returns the current command.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetEditMenu(self) -> 'Menu':
        """ Returns the edit menu associated with the command processor.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetMaxCommands(self) -> int:
        """ Returns the maximum number of commands that the command processor stores.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetRedoAccelerator(self) -> str:
        """ Returns the string that will be appended to the Redo menu item.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetRedoMenuLabel(self) -> str:
        """ Returns the string that will be shown for the redo menu item.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetUndoAccelerator(self) -> str:
        """ Returns the string that will be appended to the Undo menu item.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def GetUndoMenuLabel(self) -> str:
        """ Returns the string that will be shown for the undo menu item.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def Initialize(self) -> None:
        """ Initializes the command processor, setting the current command to the last in the list (if any), and updating the edit menu (if one has been specified).

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def IsDirty(self) -> bool:
        """ Returns a boolean value that indicates if changes have been made since the last save operation.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def MarkAsSaved(self) -> None:
        """ You must call this method whenever the project is saved if you plan to use IsDirty .

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def Redo(self) -> bool:
        """ Executes (redoes) the current command (the command that has just been undone if any).

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def SetEditMenu(self, menu: 'Menu') -> None:
        """ Tells the command processor to update the Undo and Redo items on this menu as appropriate.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def SetMenuStrings(self) -> None:
        """ Sets the menu labels according to the currently set menu and the current command state.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def SetRedoAccelerator(self, accel: str) -> None:
        """ Sets the string that will be appended to the Redo menu item.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def SetUndoAccelerator(self, accel: str) -> None:
        """ Sets the string that will be appended to the Undo menu item.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def Store(self, command: 'Command') -> None:
        """ Just store the command without executing it.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def Submit(self, command, storeIt=True) -> bool:
        """ Submits a new command to the command processor.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    def Undo(self) -> bool:
        """ Undoes the last command executed.

            Source: https://docs.wxpython.org/wx.CommandProcessor.html
        """

    Commands: 'CommandList'  # See GetCommands
    CurrentCommand: 'Command'  # See GetCurrentCommand
    EditMenu: 'Menu'  # See GetEditMenu and SetEditMenu
    MaxCommands: int  # See GetMaxCommands
    RedoAccelerator: str  # See GetRedoAccelerator and SetRedoAccelerator
    RedoMenuLabel: str  # See GetRedoMenuLabel
    UndoAccelerator: str  # See GetUndoAccelerator and SetUndoAccelerator
    UndoMenuLabel: str  # See GetUndoMenuLabel



class ConfigBase(Object):
    """ ConfigBase defines the basic interface of all config classes.

        Source: https://docs.wxpython.org/wx.ConfigBase.html
    """
    def __init__(self, appName="", vendorName="", localFilename="", globalFilename="", style=0) -> None:
        """ This is the default and only constructor of the   wx.ConfigBase  class, and derived classes.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    @staticmethod
    def Create() -> 'ConfigBase':
        """ Create a new config object and sets it as the current one.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def DeleteAll(self) -> bool:
        """ Delete the whole underlying object (disk file, registry key, â¦).

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def DeleteEntry(self, key, bDeleteGroupIfEmpty=True) -> bool:
        """ Deletes the specified entry and the group it belongs to if it was the last key in it and the second parameter is True.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def DeleteGroup(self, key: str) -> bool:
        """ Delete the group (with all subgroups).

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    @staticmethod
    def DontCreateOnDemand() -> None:
        """ Calling this function will prevent  ` Get  `   from automatically creating a new config object if the current one is None.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def Exists(self, strName: str) -> bool:
        """ strName (string) â

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def Flush(self, bCurrentOnly: bool=False) -> bool:
        """ Permanently writes all changes (otherwise, theyâre only written from objectâs destructor).

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    @staticmethod
    def Get(CreateOnDemand: bool=True) -> 'ConfigBase':
        """ Get the current config object.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetAppName(self) -> str:
        """ Returns the application name.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetEntryType(self, name: str) -> 'EntryType':
        """ Returns the type of the given entry or Unknown  if the entry doesnât exist.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetFirstEntry(self) -> Any:
        """ GetFirstEntry() . (more, value, index)

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetFirstGroup(self) -> Any:
        """ GetFirstGroup() . (more, value, index)

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetNextEntry(self, index) -> Any:
        """ GetNextEntry() . (more, value, index)

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetNextGroup(self, index) -> Any:
        """ GetNextGroup(long index) . (more, value, index)

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetNumberOfEntries(self, bRecursive: bool=False) -> int:
        """ Get number of entries in the current group.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetNumberOfGroups(self, bRecursive: bool=False) -> int:
        """ Get number of entries/subgroups in the current group, with or without its subgroups.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetPath(self) -> str:
        """ Retrieve the current path (always as absolute path).

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def GetVendorName(self) -> str:
        """ Returns the vendor name.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def HasEntry(self, strName: str) -> bool:
        """ strName (string) â

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def HasGroup(self, strName: str) -> bool:
        """ strName (string) â

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def IsExpandingEnvVars(self) -> bool:
        """ Returns True if we are expanding environment variables in key values.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def IsRecordingDefaults(self) -> bool:
        """ Returns True if we are writing defaults back to the config file.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def Read(self, key, defaultVal="") -> None:
        """ Another version of Read , returning the string value directly.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def ReadBool(self, key, defaultVal=False) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def ReadDouble(self, key, defaultVal) -> float:
        """ Reads a float value from the key and returns it.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def ReadFloat(self, key, defaultVal=0.0) -> float:
        """ float

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def ReadInt(self, key, defaultVal=0) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def ReadLong(self, key, defaultVal) -> int:
        """ Reads a long value from the key and returns it.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def ReadLongLong(self, key, defaultVal) -> 'LongLong_t':
        """ Reads a 64-bit long long value from the key and returns it.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def RenameEntry(self, oldName, newName) -> bool:
        """ Renames an entry in the current group.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def RenameGroup(self, oldName, newName) -> bool:
        """ Renames a subgroup of the current group.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    @staticmethod
    def Set(pConfig: 'ConfigBase') -> 'ConfigBase':
        """ Sets the config object as the current one, returns the pointer to the previous current object (both the parameter and returned value may be None).

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def SetExpandEnvVars(self, bDoIt: bool=True) -> None:
        """ Determine whether we wish to expand environment variables in key values.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def SetPath(self, strPath: str) -> None:
        """ Set current path: if the first character is â/â, it is the absolute path, otherwise it is a relative path.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def SetRecordDefaults(self, bDoIt: bool=True) -> None:
        """ Sets whether defaults are recorded to the config file whenever an attempt to read the value which is not present in it is done.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def Write(self, key, value) -> bool:
        """ Writes the String       value to the config file and returns True on success.

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def WriteBool(self, key, value) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def WriteFloat(self, key, value) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def WriteInt(self, key, value) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    def _cpp_ReadInt(self, key, defaultVal=0) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.ConfigBase.html
        """

    AppName: str  # See GetAppName
    FirstEntry: Any  # See GetFirstEntry
    FirstGroup: Any  # See GetFirstGroup
    NextEntry: Any  # See GetNextEntry
    NextGroup: Any  # See GetNextGroup
    NumberOfEntries: int  # See GetNumberOfEntries
    NumberOfGroups: int  # See GetNumberOfGroups
    Path: str  # See GetPath and SetPath
    VendorName: str  # See GetVendorName



class ConfigPathChanger:
    """ A handy little class which changes the current path in a Config
object and restores it in dtor.

        Source: https://docs.wxpython.org/wx.ConfigPathChanger.html
    """
    def __init__(self, pContainer, strEntry) -> None:
        """ Changes the path of the given   wx.ConfigBase  object so that the key strEntry  is accessible (for read or write).

            Source: https://docs.wxpython.org/wx.ConfigPathChanger.html
        """

    def Name(self) -> str:
        """ Returns the name of the key which was passed to the constructor.

            Source: https://docs.wxpython.org/wx.ConfigPathChanger.html
        """

    def UpdateIfDeleted(self) -> None:
        """ This method must be called if the original path inside the Config object (i.e.

            Source: https://docs.wxpython.org/wx.ConfigPathChanger.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ConfigPathChanger.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ConfigPathChanger.html
        """



class ContextHelp(Object):
    """ This class changes the cursor to a query and puts the application into
a âcontext-sensitive help modeâ.

        Source: https://docs.wxpython.org/wx.ContextHelp.html
    """
    def __init__(self, window=None, doNow=True) -> None:
        """ Constructs a context help object, calling BeginContextHelp   if doNow  is True (the default).

            Source: https://docs.wxpython.org/wx.ContextHelp.html
        """

    def BeginContextHelp(self, window: 'Window') -> bool:
        """ Puts the application into context-sensitive help mode.

            Source: https://docs.wxpython.org/wx.ContextHelp.html
        """

    def EndContextHelp(self) -> bool:
        """ Ends context-sensitive help mode.

            Source: https://docs.wxpython.org/wx.ContextHelp.html
        """



DIALOG_EX_CONTEXTHELP: int

class ContextHelpButton(BitmapButton):
    """ Instances of this class may be used to add a question mark button that
when pressed, puts the application into context-help mode.

        Source: https://docs.wxpython.org/wx.ContextHelpButton.html
    """
    def __init__(self, parent, id=ID_CONTEXT_HELP, pos=DefaultPosition, size=DefaultSize, style=0) -> None:
        """ Constructor, creating and showing a context help button.

            Source: https://docs.wxpython.org/wx.ContextHelpButton.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ContextHelpButton.html
        """



class ContextMenuEvent(CommandEvent):
    """ This class is used for context menu events, sent to give the
application a chance to show a context (popup) menu for a Window.

        Source: https://docs.wxpython.org/wx.ContextMenuEvent.html
    """
    def __init__(self, type=wxEVT_NULL, id=0, pos=DefaultPosition) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ContextMenuEvent.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the position in screen coordinates at which the menu should be shown.

            Source: https://docs.wxpython.org/wx.ContextMenuEvent.html
        """

    def SetPosition(self, point: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the position at which the menu should be shown.

            Source: https://docs.wxpython.org/wx.ContextMenuEvent.html
        """

    Position: 'Point'  # See GetPosition and SetPosition



_AcceleratorTable: TypeAlias = AcceleratorTable

_BackgroundStyle: TypeAlias = BackgroundStyle

_Border: TypeAlias = Border

_Caret: TypeAlias = Caret

_Cursor: TypeAlias = Cursor

_DropTarget: TypeAlias = DropTarget

_Rect: TypeAlias = Rect

_Sizer: TypeAlias = Sizer

_ToolTip: TypeAlias = ToolTip

_Validator: TypeAlias = Validator

class Window(EvtHandler):
    """ Window is the base class for all windows and represents any visible
object on screen.

        Source: https://docs.wxpython.org/wx.Window.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def AcceptsFocus(self) -> bool:
        """ This method may be overridden in the derived classes to return False to indicate that this control doesnât accept input at all (i.e. behaves like e.g.   wx.StaticText) and so doesnât need focus.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def AcceptsFocusFromKeyboard(self) -> bool:
        """ This method may be overridden in the derived classes to return False to indicate that while this control can, in principle, have focus if the user clicks it with the mouse, it shouldnât be included in the TAB traversal chain when using the keyboard.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def AcceptsFocusRecursively(self) -> bool:
        """ Overridden to indicate whether this window or one of its children accepts focus.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def AddChild(self, child: 'WindowBase') -> None:
        """ Adds a child window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def AdjustForLayoutDirection(self, x, width, widthTotal) -> 'Coord':
        """ Mirror coordinates for RTL layout if this window uses it and if the mirroring is not done automatically like Win32.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def AlwaysShowScrollbars(self, hflag=True, vflag=True) -> None:
        """ Call this function to force one or both scrollbars to be always shown, even if the window is big enough to show its entire contents without scrolling.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def AssociateHandle(self, handle) -> None:
        """ Associate the window with a new native handle

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def BeginRepositioningChildren(self) -> bool:
        """ Prepare for changing positions of multiple child windows.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CacheBestSize(self, size: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the cached best size value.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CanAcceptFocus(self) -> bool:
        """ Can this window have focus right now?

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CanAcceptFocusFromKeyboard(self) -> bool:
        """ Can this window be assigned focus from keyboard right now?

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CanScroll(self, orient: int) -> bool:
        """ Returns True if this window can have a scroll bar in this orientation.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CanSetTransparent(self) -> bool:
        """ Returns True if the system supports transparent windows and calling SetTransparent   may succeed.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CaptureMouse(self) -> None:
        """ Directs all mouse input to this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Center(self, dir: int=BOTH) -> None:
        """ A synonym for wx.Centre     .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CenterOnParent(self, dir: int=BOTH) -> None:
        """ A synonym for CentreOnParent .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Centre(self, direction: int=BOTH) -> None:
        """ Centres the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def CentreOnParent(self, direction: int=BOTH) -> None:
        """ Centres the window on its parent.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ClearBackground(self) -> None:
        """ Clears the window by filling it with the current background colour.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ClientToScreen(self, *args, **kw) -> tuple:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ClientToWindowSize(self, size: Union[tuple[int, int], 'Size']) -> 'Size':
        """ Converts client area size size  to corresponding window size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Close(self, force: bool=False) -> bool:
        """ This function simply generates a   wx.CloseEvent  whose handler usually tries to close the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ConvertDialogToPixels(self, *args, **kw) -> 'Point':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ConvertPixelsToDialog(self, *args, **kw) -> 'Point':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> bool:
        """ Construct the actual window object after creating the C++ object.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DLG_UNIT(self, dlg_unit) -> None:
        """ A convenience wrapper for ConvertDialogToPixels.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Destroy(self) -> bool:
        """ Destroys the window safely.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DestroyChildren(self) -> bool:
        """ Destroys all children of a window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DestroyLater(self) -> None:
        """ Schedules the window to be destroyed in the near future.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Disable(self) -> bool:
        """ Disables the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DisableFocusFromKeyboard(self) -> None:
        """ Disable giving focus to this window using the keyboard navigation keys.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DissociateHandle(self) -> None:
        """ Dissociate the current native handle from the window

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DoGetBestClientSize(self) -> 'Size':
        """ Override this method to return the best size for a custom control.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DoGetBestSize(self) -> 'Size':
        """ Implementation of GetBestSize   that can be overridden.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DoUpdateWindowUI(self, event: 'UpdateUIEvent') -> None:
        """ Does the window-specific updating after processing the update event.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def DragAcceptFiles(self, accept: bool) -> None:
        """ Enables or disables eligibility for drop file events (OnDropFiles).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Enable(self, enable: bool=True) -> bool:
        """ Enable or disable the window for user input.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def EnableTouchEvents(self, eventsMask: int) -> bool:
        """ Request generation of touch events for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def EnableVisibleFocus(self, enable: bool) -> None:
        """ Enables or disables visible indication of keyboard focus.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def EndRepositioningChildren(self) -> None:
        """ Fix child window positions after setting all of them at once.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def FindFocus() -> 'Window':
        """ Finds the window or control which currently has the keyboard focus.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def FindWindow(self, *args, **kw) -> 'Window':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def FindWindowById(id, parent=None) -> 'Window':
        """ Find the first window with the given id.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def FindWindowByLabel(label, parent=None) -> 'Window':
        """ Find a window by its label.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def FindWindowByName(name, parent=None) -> 'Window':
        """ Find a window by its name (as given in a window constructor or Create   function call).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Fit(self) -> None:
        """ Sizes the window to fit its best size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def FitInside(self) -> None:
        """ Similar to Fit , but sizes the interior (virtual) size of a window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Freeze(self) -> None:
        """ Freezes the window or, in other words, prevents any updates from taking place on screen, the window is not redrawn at all.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def FromDIP(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def FromPhys(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetAcceleratorTable(self) -> 'AcceleratorTable':
        """ Gets the accelerator table for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetAccessible(self) -> 'Accessible':
        """ Returns the accessible object for this window, if any.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetAutoLayout(self) -> bool:
        """ Returns True if Layout   is called automatically when the window is resized.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetBackgroundColour(self) -> 'Colour':
        """ Returns the background colour of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetBackgroundStyle(self) -> 'BackgroundStyle':
        """ Returns the background style of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetBestHeight(self, width: int) -> int:
        """ Returns the best height needed by this window if it had the given width.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetBestSize(self) -> 'Size':
        """ This functions returns the best acceptable minimal size for the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetBestVirtualSize(self) -> 'Size':
        """ Return the largest of ClientSize and BestSize (as determined by a sizer, interior children, or other means)

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetBestWidth(self, height: int) -> int:
        """ Returns the best width needed by this window if it had the given height.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetBorder(self, *args, **kw) -> 'Border':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def GetCapture() -> 'Window':
        """ Returns the currently captured window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetCaret(self) -> 'Caret':
        """ Returns the caret() associated with the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetCharHeight(self) -> int:
        """ Returns the character height for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetCharWidth(self) -> int:
        """ Returns the average character width for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetChildren(self) -> 'WindowList':
        """ Returns a reference to the list of the windowâs children.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ Returns the default font and colours which are used by the control.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetClientAreaOrigin(self) -> 'Point':
        """ Get the origin of the client area of the window relative to the window top left corner (the client area may be shifted because of the borders, scrollbars, other decorationsâ¦)

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetClientRect(self) -> 'Rect':
        """ Get the client rectangle in window (i.e. client) coordinates.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetClientSize(self) -> None:
        """ Returns the size of the window âclient areaâ in pixels.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetConstraints(self) -> 'LayoutConstraints':
        """ Returns a pointer to the windowâs layout constraints, or None if there are none.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetContainingSizer(self) -> 'Sizer':
        """ Returns the sizer of which this window is a member, if any, otherwise None.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetContentScaleFactor(self) -> float:
        """ Returns the factor mapping logical pixels of this window to physical pixels.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetCursor(self) -> 'Cursor':
        """ Return the cursor associated with this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetDPI(self) -> 'Size':
        """ Return the DPI of the display used by this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetDPIScaleFactor(self) -> float:
        """ Returns the ratio of the DPI used by this window to the standard DPI.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetDefaultAttributes(self) -> 'VisualAttributes':
        """ Currently this is the same as calling Window.GetClassDefaultAttributes(wxWindow.GetWindowVariant()).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetDropTarget(self) -> 'DropTarget':
        """ Returns the associated drop target, which may be None.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetEffectiveMinSize(self) -> 'Size':
        """ Merges the windowâs best size into the min size and returns the result.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetEventHandler(self) -> 'EvtHandler':
        """ Returns the event handler for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetExtraStyle(self) -> int:
        """ Returns the extra style bits for the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetFont(self) -> 'Font':
        """ Returns the font for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetForegroundColour(self) -> 'Colour':
        """ Returns the foreground colour of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetGrandParent(self) -> 'Window':
        """ Returns the grandparent of a window, or None if there isnât one.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetGtkWidget(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetHandle(self) -> None:
        """ Returns the platform-specific handle of the physical window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetHelpText(self) -> str:
        """ Gets the help text to be used as context-sensitive help for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetHelpTextAtPoint(self, point, origin) -> str:
        """ Gets the help text to be used as context-sensitive help for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetId(self) -> int:
        """ Returns the identifier of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetLabel(self) -> str:
        """ Generic way of getting a label from any window, for identification purposes.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetLayoutDirection(self) -> int:
        """ Returns the layout direction for this window, Note that  Layout_Default   is returned if layout direction is not supported.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMaxClientSize(self) -> 'Size':
        """ Returns the maximum size of windowâs client area.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMaxHeight(self) -> int:
        """ Returns the vertical component of window maximal size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMaxSize(self) -> 'Size':
        """ Returns the maximum size of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMaxWidth(self) -> int:
        """ Returns the horizontal component of window maximal size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMinClientSize(self) -> 'Size':
        """ Returns the minimum size of windowâs client area, an indication to the sizer layout mechanism that this is the minimum required size of its client area.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMinHeight(self) -> int:
        """ Returns the vertical component of window minimal size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMinSize(self) -> 'Size':
        """ Returns the minimum size of the window, an indication to the sizer layout mechanism that this is the minimum required size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetMinWidth(self) -> int:
        """ Returns the horizontal component of window minimal size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetName(self) -> str:
        """ Returns the windowâs name.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetNextSibling(self) -> 'Window':
        """ Returns the next window after this one among the parentâs children or None if this window is the last child.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetParent(self) -> 'Window':
        """ Returns the parent of the window, or None if there is no parent.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetPopupMenuSelectionFromUser(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetPosition(self) -> 'Point':
        """ This gets the position of the window in pixels, relative to the parent window for the child windows or relative to the display origin for the top level windows.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetPrevSibling(self) -> 'Window':
        """ Returns the previous window before this one among the parentâs children or

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetRect(self) -> 'Rect':
        """ Returns the position and size of the window as a   wx.Rect  object.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetScreenPosition(self) -> 'Point':
        """ Returns the window position in screen coordinates, whether the window is a child window or a top level one.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetScreenRect(self) -> 'Rect':
        """ Returns the position and size of the window on the screen as a   wx.Rect  object.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetScrollPos(self, orientation: int) -> int:
        """ Returns the built-in scrollbar position.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetScrollRange(self, orientation: int) -> int:
        """ Returns the built-in scrollbar range.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetScrollThumb(self, orientation: int) -> int:
        """ Returns the built-in scrollbar thumb size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetSize(self) -> 'Size':
        """ Returns the size of the entire window in pixels, including title bar, border, scrollbars, etc.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetSizer(self) -> 'Sizer':
        """ Returns the sizer associated with the window by a previous call to SetSizer , or None.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetFullTextExtent(self, string, font=None) -> tuple:
        """ Gets the dimensions of the string as it would be drawn on the window with the currently selected font.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetTextExtent(self, string: str) -> 'Size':
        """ Gets the dimensions of the string as it would be drawn on the window with the currently selected font.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetThemeEnabled(self) -> bool:
        """ Returns True if the window uses the system theme for drawing its background.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetToolTip(self) -> 'ToolTip':
        """ Get the associated tooltip or None if none.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetToolTipText(self) -> str:
        """ Get the text of the associated tooltip or empty string if none.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetTopLevelParent(self) -> 'Window':
        """ Returns the first ancestor of this window which is a top-level window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetUpdateClientRect(self) -> 'Rect':
        """ Get the update rectangle bounding box in client coords.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetUpdateRegion(self) -> 'Region':
        """ Returns the region specifying which parts of the window have been damaged.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetValidator(self) -> 'Validator':
        """ Validator functions.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetVirtualSize(self) -> 'Size':
        """ This gets the virtual size of the window in pixels.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetWindowBorderSize(self) -> 'Size':
        """ Returns the size of the left/right and top/bottom borders of this window in x and y components of the result respectively.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetWindowStyle(self) -> int:
        """ See GetWindowStyleFlag   for more info.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetWindowStyleFlag(self) -> int:
        """ Gets the window style that was passed to the constructor or Create   method.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def GetWindowVariant(self) -> int:
        """ Returns the value previously passed to SetWindowVariant .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HandleAsNavigationKey(self, event: 'KeyEvent') -> bool:
        """ This function will generate the appropriate call to Navigate   if the key event is one normally used for keyboard navigation and return True in this case.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HandleWindowEvent(self, event: 'Event') -> bool:
        """ Shorthand for:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HasCapture(self) -> bool:
        """ Returns True if this window has the current mouse capture.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HasExtraStyle(self, exFlag: int) -> bool:
        """ Returns True if the window has the given exFlag  bit set in its extra styles.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HasFlag(self, flag: int) -> bool:
        """ Returns True if the window has the given flag  bit set.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HasFocus(self) -> bool:
        """ Returns True if the window (or in case of composite controls, its main child window) has focus.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HasMultiplePages(self) -> bool:
        """ This method should be overridden to return True if this window has multiple pages.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HasScrollbar(self, orient: int) -> bool:
        """ Returns True if this window currently has a scroll bar for this orientation.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HasTransparentBackground(self) -> bool:
        """ Returns True if this window background is transparent (as, for example, for   wx.StaticText) and should show the parent window background.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Hide(self) -> bool:
        """ Equivalent to calling wx.Window.Show (False).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HideWithEffect(self, effect, timeout=0) -> bool:
        """ This function hides a window, like Hide , but using a special visual effect if possible.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def HitTest(self, *args, **kw) -> 'HitTest':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def InformFirstDirection(self, direction, size, availableOtherDir) -> bool:
        """ wx.Sizer  and friends use this to give a chance to a component to recalc its min size once one of the final size components is known.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def InheritAttributes(self) -> None:
        """ This function is (or should be, in case of custom controls) called during window creation to intelligently set up the window visual attributes, that is the font and the foreground and background colours.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def InheritsBackgroundColour(self) -> bool:
        """ Return True if this window inherits the background colour from its parent.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def InheritsForegroundColour(self) -> bool:
        """ Return True if this window inherits the foreground colour from its parent.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def InitDialog(self) -> None:
        """ Sends an  wxEVT_INIT_DIALOG   event, whose handler usually transfers data to the dialog via validators.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def InvalidateBestSize(self) -> None:
        """ Resets the cached best size value so it will be recalculated the next time it is needed.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsBeingDeleted(self) -> bool:
        """ Returns True if this window is in process of being destroyed.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsDescendant(self, win: 'Window') -> bool:
        """ Check if the specified window is a descendant of this one.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsDoubleBuffered(self) -> bool:
        """ Returns True if the window contents is double-buffered by the system, i.e. if any drawing done on the window is really done on a temporary backing surface and transferred to the screen all at once later.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsEnabled(self) -> bool:
        """ Returns True if the window is enabled, i.e. if it accepts user input, False otherwise.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsExposed(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsFocusable(self) -> bool:
        """ Can this window itself have focus?

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsFrozen(self) -> bool:
        """ Returns True if the window is currently frozen by a call to Freeze .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsRetained(self) -> bool:
        """ Returns True if the window is retained, False otherwise.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsScrollbarAlwaysShown(self, orient: int) -> bool:
        """ Return whether a scrollbar is always shown.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsShown(self) -> bool:
        """ Returns True if the window is shown, False if it has been hidden.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsShownOnScreen(self) -> bool:
        """ Returns True if the window is physically visible on the screen, i.e. it is shown and all its parents up to the toplevel window are shown as well.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsThisEnabled(self) -> bool:
        """ Returns True if this window is intrinsically enabled, False otherwise, i.e. if Enable   Enable(false) had been called.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsTopLevel(self) -> bool:
        """ Returns True if the given window is a top-level one.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def IsTransparentBackgroundSupported(self, reason: Optional[str]=None) -> bool:
        """ Checks whether using transparent background might work.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Layout(self) -> bool:
        """ Lays out the children of this window using the associated sizer.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def LineDown(self) -> bool:
        """ Same as ScrollLines   (1).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def LineUp(self) -> bool:
        """ Same as ScrollLines   (-1).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Lower(self) -> None:
        """ Lowers the window to the bottom of the window hierarchy (Z-order).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def MacIsWindowScrollbar(self, sb) -> None:
        """ Is the given widget one of this windowâs built-in scrollbars?  Only applicable on Mac.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Move(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def MoveAfterInTabOrder(self, win: 'Window') -> None:
        """ Moves this window in the tab navigation order after the specified win.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def MoveBeforeInTabOrder(self, win: 'Window') -> None:
        """ Same as MoveAfterInTabOrder   except that it inserts this window just before win  instead of putting it right after it.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Navigate(self, flags: int=NavigationKeyEvent.IsForward) -> bool:
        """ Performs a keyboard navigation action starting from this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def NavigateIn(self, flags: int=NavigationKeyEvent.IsForward) -> bool:
        """ Performs a keyboard navigation action inside this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def NewControlId(count: int=1) -> int:
        """ Create a new ID or range of IDs that are not currently in use.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def OnInternalIdle(self) -> None:
        """ This virtual function is normally only used internally, but sometimes an application may need it to implement functionality that should not be disabled by an application defining an OnIdle handler in a derived class.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def PageDown(self) -> bool:
        """ Same as ScrollPages   (1).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def PageUp(self) -> bool:
        """ Same as ScrollPages   (-1).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def PopEventHandler(self, deleteHandler: bool=False) -> 'EvtHandler':
        """ Removes and returns the top-most event handler on the event handler stack.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def PopupMenu(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def PostSizeEvent(self) -> None:
        """ Posts a size event to the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def PostSizeEventToParent(self) -> None:
        """ Posts a size event to the parent of this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ProcessEvent(self, event: 'Event') -> bool:
        """ This function is public in   wx.EvtHandler  but protected in   wx.Window  because for Windows you should always call   wx.ProcessEvent  on the pointer returned by GetEventHandler   and not on the   wx.Window  object itself.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ProcessWindowEvent(self, event: 'Event') -> bool:
        """ Convenient wrapper for   wx.ProcessEvent.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ProcessWindowEventLocally(self, event: 'Event') -> bool:
        """ Wrapper for wx.EvtHandler.ProcessEventLocally .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def PushEventHandler(self, handler: 'EvtHandler') -> None:
        """ Pushes this event handler onto the event stack for the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Raise(self) -> None:
        """ Raises the window to the top of the window hierarchy (Z-order).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Refresh(self, eraseBackground=True, rect=None) -> None:
        """ Causes this window, and all of its children recursively, to be repainted.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def RefreshRect(self, rect, eraseBackground=True) -> None:
        """ Redraws the contents of the given rectangle: only the area inside it will be repainted.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def RegisterHotKey(self, hotkeyId, modifiers, virtualKeyCode) -> bool:
        """ Registers a system wide hotkey.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ReleaseMouse(self) -> None:
        """ Releases mouse input captured with CaptureMouse .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def RemoveChild(self, child: 'WindowBase') -> None:
        """ Removes a child window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def RemoveEventHandler(self, handler: 'EvtHandler') -> bool:
        """ Find the given handler  in the windows event handler stack and removes (but does not delete) it from the stack.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Reparent(self, newParent: 'Window') -> bool:
        """ Reparents the window, i.e. the window will be removed from its current parent window (e.g.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ScreenToClient(self, *args, **kw) -> tuple:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ScrollLines(self, lines: int) -> bool:
        """ Scrolls the window by the given number of lines down (if lines  is positive) or up.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ScrollPages(self, pages: int) -> bool:
        """ Scrolls the window by the given number of pages down (if pages  is positive) or up.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ScrollWindow(self, dx, dy, rect=None) -> None:
        """ Physically scrolls the pixels in the window and move child windows accordingly.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SendDestroyEvent(self) -> None:
        """ Generate   wx.WindowDestroyEvent  for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SendIdleEvents(self, event: 'IdleEvent') -> bool:
        """ Send idle event to window and all subwindows.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SendSizeEvent(self, flags: int=0) -> None:
        """ This function sends a dummy size event  to the window allowing it to re-layout its children positions.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SendSizeEventToParent(self, flags: int=0) -> None:
        """ Safe wrapper for GetParent . SendSizeEvent .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetAcceleratorTable(self, accel: 'AcceleratorTable') -> None:
        """ Sets the accelerator table for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetAccessible(self, accessible: 'Accessible') -> None:
        """ Sets the accessible for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetAutoLayout(self, autoLayout: bool) -> None:
        """ Determines whether the Layout   function will be called automatically when the window is resized.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetBackgroundColour(self, colour: Union[int, str, 'Colour']) -> bool:
        """ Sets the background colour of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetBackgroundStyle(self, style: BackgroundStyle) -> bool:
        """ Sets the background style of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetCanFocus(self, canFocus: bool) -> None:
        """ This method is only implemented by ports which have support for native TAB traversal (such as GTK+ 2.0).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetCaret(self, caret: 'Caret') -> None:
        """ Sets the caret() associated with the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetClientRect(self, rect) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetClientSize(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetConstraints(self, constraints: 'LayoutConstraints') -> None:
        """ Sets the window to have the given layout constraints.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetContainingSizer(self, sizer: 'Sizer') -> None:
        """ Used by   wx.Sizer  internally to notify the window about being managed by the given sizer.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetCursor(self, cursor: 'Cursor') -> bool:
        """ Sets the windowâs cursor.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetDimensions(self, x, y, width, height, sizeFlags=SIZE_AUTO) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetDoubleBuffered(self, on: bool) -> None:
        """ Turn on or off double buffering of the window if the system supports it.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetDropTarget(self, target: 'DropTarget') -> None:
        """ Associates a drop target with this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetEventHandler(self, handler: 'EvtHandler') -> None:
        """ Sets the event handler for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetExtraStyle(self, exStyle: int) -> None:
        """ Sets the extra style bits for the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetFocus(self) -> None:
        """ This sets the window to receive keyboard input.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetFocusFromKbd(self) -> None:
        """ This function is called by wxWidgets keyboard navigation code when the user gives the focus to this window from keyboard (e.g. using  TAB   key).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetFont(self, font: 'Font') -> bool:
        """ Sets the font for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetForegroundColour(self, colour: Union[int, str, 'Colour']) -> bool:
        """ Sets the foreground colour of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetHelpText(self, helpText: str) -> None:
        """ Sets the help text to be used as context-sensitive help for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetId(self, winid: int) -> None:
        """ Sets the identifier of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetInitialSize(self, size: Union[tuple[int, int], 'Size']=DefaultSize) -> None:
        """ A smart  SetSize that will fill in default size components with the windowâs best  size values.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetLabel(self, label: str) -> None:
        """ Sets the windowâs label.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetLayoutDirection(self, dir: int) -> None:
        """ Sets the layout direction for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetMaxClientSize(self, size: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the maximum client size of the window, to indicate to the sizer layout mechanism that this is the maximum possible size of its client area.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetMaxSize(self, size: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the maximum size of the window, to indicate to the sizer layout mechanism that this is the maximum possible size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetMinClientSize(self, size: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the minimum client size of the window, to indicate to the sizer layout mechanism that this is the minimum required size of windowâs client area.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetMinSize(self, size: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the minimum size of the window, to indicate to the sizer layout mechanism that this is the minimum required size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetName(self, name: str) -> None:
        """ Sets the windowâs name.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetNextHandler(self, handler: 'EvtHandler') -> None:
        """ Windows cannot be used to form event handler chains; this function thus will assert when called.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetOwnBackgroundColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the background colour of the window but prevents it from being inherited by the children of this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetOwnFont(self, font: 'Font') -> None:
        """ Sets the font of the window but prevents it from being inherited by the children of this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetOwnForegroundColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the foreground colour of the window but prevents it from being inherited by the children of this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetPalette(self, pal: 'Palette') -> None:
        """ pal (wx.Palette) â

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetPosition(self, pt: Union[tuple[int, int], 'Point']) -> None:
        """ Moves the window to the specified position.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetPreviousHandler(self, handler: 'EvtHandler') -> None:
        """ Windows cannot be used to form event handler chains; this function thus will assert when called.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetRect(self, rect) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetScrollPos(self, orientation, pos, refresh=True) -> None:
        """ Sets the position of one of the built-in scrollbars.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetScrollbar(self, orientation, position, thumbSize, range, refresh=True) -> None:
        """ Sets the scrollbar properties of a built-in scrollbar.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetSize(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetSizeHints(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetSizer(self, sizer, deleteOld=True) -> None:
        """ Sets the window to have the given layout sizer.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetSizerAndFit(self, sizer, deleteOld=True) -> None:
        """ Associate the sizer with the window and set the window size and minimal size accordingly.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetThemeEnabled(self, enable: bool) -> None:
        """ This function tells a window if it should use the systemâs âthemeâ code to draw the windowsâ background instead of its own background drawing code.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetToolTip(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetTransparent(self, alpha: 'Byte') -> bool:
        """ Set the transparency of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetValidator(self, validator: 'Validator') -> None:
        """ Deletes the current validator (if any) and sets the window validator, having called wx.Validator.Clone   to create a new validator of this type.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetVirtualSize(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetWindowStyle(self, style: int) -> None:
        """ See SetWindowStyleFlag   for more info.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetWindowStyleFlag(self, style: int) -> None:
        """ Sets the style of the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def SetWindowVariant(self, variant: int) -> None:
        """ Chooses a different variant of the window display to use.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ShouldInheritColours(self) -> bool:
        """ Return True from here to allow the colours of this window to be changed by InheritAttributes .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Show(self, show: bool=True) -> bool:
        """ Shows or hides the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ShowWithEffect(self, effect, timeout=0) -> bool:
        """ This function shows a window, like Show , but using a special visual effect if possible.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Thaw(self) -> None:
        """ Re-enables window updating after a previous call to Freeze .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ToDIP(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ToPhys(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def ToggleWindowStyle(self, flag: int) -> bool:
        """ Turns the given flag  on if itâs currently turned off and vice versa.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def TransferDataFromWindow(self) -> bool:
        """ Transfers values from child controls to data areas specified by their validators.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def TransferDataToWindow(self) -> bool:
        """ Transfers values to child controls from data areas specified by their validators.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def UnregisterHotKey(self, hotkeyId: int) -> bool:
        """ Unregisters a system wide hotkey.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    @staticmethod
    def UnreserveControlId(id, count=1) -> None:
        """ Unreserve an ID or range of IDs that was reserved by NewControlId .

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def UnsetToolTip(self) -> None:
        """ Unset any existing tooltip.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Update(self) -> None:
        """ Calling this method immediately repaints the invalidated area of the window and all of its children recursively (this normally only happens when the flow of control returns to the event loop).

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def UpdateWindowUI(self, flags: int=UPDATE_UI_NONE) -> None:
        """ This function sends one or more   wx.UpdateUIEvent  to the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def UseBackgroundColour(self) -> bool:
        """ Return True if a background colour has been set for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def UseBgCol(self) -> bool:
        """ Return True if a background colour has been set for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def UseForegroundColour(self) -> bool:
        """ Return True if a foreground colour has been set for this window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def Validate(self) -> bool:
        """ Validates the current values of the child controls using their validators.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def WarpPointer(self, x, y) -> None:
        """ Moves the pointer to the given position on the window.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def WindowToClientSize(self, size: Union[tuple[int, int], 'Size']) -> 'Size':
        """ Converts window size size  to corresponding client area size In other words, the returned value is what would GetClientSize   return if this window had given window size.

            Source: https://docs.wxpython.org/wx.Window.html
        """

    def __nonzero__(self) -> None:
        """ Can be used to test if the C++ part of the window still exists, with
code like this:

            Source: https://docs.wxpython.org/wx.Window.html
        """

    AcceleratorTable: '_AcceleratorTable'  # See GetAcceleratorTable and SetAcceleratorTable
    AutoLayout: bool  # See GetAutoLayout and SetAutoLayout
    BackgroundColour: 'Colour'  # See GetBackgroundColour and SetBackgroundColour
    BackgroundStyle: '_BackgroundStyle'  # See GetBackgroundStyle and SetBackgroundStyle
    BestSize: 'Size'  # See GetBestSize
    BestVirtualSize: 'Size'  # See GetBestVirtualSize
    Border: '_Border'  # See GetBorder
    Caret: '_Caret'  # See GetCaret and SetCaret
    CharHeight: int  # See GetCharHeight
    CharWidth: int  # See GetCharWidth
    Children: 'WindowList'  # See GetChildren
    ClientAreaOrigin: 'Point'  # See GetClientAreaOrigin
    ClientRect: 'Rect'  # See GetClientRect and SetClientRect
    ClientSize: None  # See GetClientSize and SetClientSize
    Constraints: 'LayoutConstraints'  # See GetConstraints and SetConstraints
    ContainingSizer: 'Sizer'  # See GetContainingSizer and SetContainingSizer
    Cursor: '_Cursor'  # See GetCursor and SetCursor
    DefaultAttributes: 'VisualAttributes'  # See GetDefaultAttributes
    DropTarget: '_DropTarget'  # See GetDropTarget and SetDropTarget
    EffectiveMinSize: 'Size'  # See GetEffectiveMinSize
    Enabled: Any  # See IsEnabled and Enable
    EventHandler: 'EvtHandler'  # See GetEventHandler and SetEventHandler
    ExtraStyle: int  # See GetExtraStyle and SetExtraStyle
    Font: '_Font'  # See GetFont and SetFont
    ForegroundColour: 'Colour'  # See GetForegroundColour and SetForegroundColour
    GrandParent: 'Window'  # See GetGrandParent
    Handle: None  # See GetHandle
    HelpText: str  # See GetHelpText and SetHelpText
    Id: int  # See GetId and SetId
    Label: str  # See GetLabel and SetLabel
    LayoutDirection: int  # See GetLayoutDirection and SetLayoutDirection
    MaxClientSize: 'Size'  # See GetMaxClientSize and SetMaxClientSize
    MaxHeight: int  # See GetMaxHeight
    MaxSize: 'Size'  # See GetMaxSize and SetMaxSize
    MaxWidth: int  # See GetMaxWidth
    MinClientSize: 'Size'  # See GetMinClientSize and SetMinClientSize
    MinHeight: int  # See GetMinHeight
    MinSize: 'Size'  # See GetMinSize and SetMinSize
    MinWidth: int  # See GetMinWidth
    Name: str  # See GetName and SetName
    Parent: 'Window'  # See GetParent
    Position: 'Point'  # See GetPosition and SetPosition
    Rect: '_Rect'  # See GetRect and SetRect
    ScreenPosition: 'Point'  # See GetScreenPosition
    ScreenRect: 'Rect'  # See GetScreenRect
    Shown: Any  # See IsShown and Show
    Size: '_Size'  # See GetSize and SetSize
    Sizer: '_Sizer'  # See GetSizer and SetSizer
    ThemeEnabled: bool  # See GetThemeEnabled and SetThemeEnabled
    ToolTip: '_ToolTip'  # See GetToolTip and SetToolTip
    TopLevel: Any  # See IsTopLevel
    TopLevelParent: 'Window'  # See GetTopLevelParent
    UpdateClientRect: 'Rect'  # See GetUpdateClientRect
    UpdateRegion: 'Region'  # See GetUpdateRegion
    Validator: '_Validator'  # See GetValidator and SetValidator
    VirtualSize: 'Size'  # See GetVirtualSize and SetVirtualSize
    WindowStyle: int  # See GetWindowStyle and SetWindowStyle
    WindowStyleFlag: int  # See GetWindowStyleFlag and SetWindowStyleFlag
    WindowVariant: int  # See GetWindowVariant and SetWindowVariant



BORDER_DEFAULT: int  # The window class will decide the kind of border to show, if any.

BORDER_SIMPLE: int  # Displays a thin border around the window. wx.SIMPLE_BORDER is the old name for this style.

BORDER_SUNKEN: int  # Displays a sunken border. wx.SUNKEN_BORDER is the old name for this style.

BORDER_RAISED: int  # Displays a raised border. wx.RAISED_BORDER is the old name for this style.

BORDER_STATIC: int  # Displays a border suitable for a static control. wx.STATIC_BORDER is the old name for this style. Windows only.

BORDER_THEME: int  # Displays a native border suitable for a control, on the current platform. On Windows, this will be a themed border; on most other platforms a sunken border will be used. For more information for themed borders on Windows, please see Themed borders on Windows.

BORDER_DOUBLE: int  # This style is obsolete and should not be used.

TRANSPARENT_WINDOW: int  # The window is transparent, that is, it will not receive paint events. Windows only.

WANTS_CHARS: int  # Use this to indicate that the window wants to get all char/key events for all keys - even for keys like TAB or ENTER which are usually used for dialog navigation and which wouldnât be generated without this style. If you need to use this style in order to get the arrows or etc., but would still like to have normal keyboard navigation take place, you should call Navigate in response to the key events for Tab and Shift-Tab.

NO_FULL_REPAINT_ON_RESIZE: int  # On Windows, this style used to disable repainting the window completely when its size is changed. Since this behaviour is now the default, the style is now obsolete and no longer has an effect.

VSCROLL: int  # Use this style to enable a vertical scrollbar. Notice that this style cannot be used with native controls which donât support scrollbars nor with top-level windows in most ports.

ALWAYS_SHOW_SB: int  # If a window has scrollbars, disable them instead of hiding them when they are not needed (i.e. when the size of the window is big enough to not require the scrollbars to navigate it). This style is currently implemented for wxMSW, wxGTK and wxUniversal and does nothing on the other platforms.

FULL_REPAINT_ON_RESIZE: int  # Use this style to force a complete redraw of the window whenever it is resized instead of redrawing just the part of the window affected by resizing. Note that this was the behaviour by default before 2.5.1 release and that if you experience redraw problems with code which previously used to work you may want to try this. Currently this style applies on GTK+ 2 and Windows only, and full repainting is always done on other platforms. ^^

EVT_HELP: int  # Process a  wxEVT_HELP   event. See    wx.HelpEvent.

EVT_HELP_RANGE: int  # Process a  wxEVT_HELP   event for a range of ids. See    wx.HelpEvent.

EVT_DROP_FILES: int  # Process a  wxEVT_DROP_FILES   event. See    wx.DropFilesEvent.

EVT_ERASE_BACKGROUND: int  # Process a  wxEVT_ERASE_BACKGROUND   event. See    wx.EraseEvent.

EVT_SET_FOCUS: int  # Process a  wxEVT_SET_FOCUS   event. See    wx.FocusEvent.

EVT_KILL_FOCUS: int  # Process a  wxEVT_KILL_FOCUS   event. See    wx.FocusEvent.

EVT_IDLE: int  # Process a  wxEVT_IDLE   event. See    wx.IdleEvent.

EVT_KEY_DOWN: int  # Process a  wxEVT_KEY_DOWN   event (any key has been pressed). See    wx.KeyEvent.

EVT_KEY_UP: int  # Process a  wxEVT_KEY_UP   event (any key has been released). See    wx.KeyEvent.

EVT_CHAR: int  # Process a  wxEVT_CHAR   event. See    wx.KeyEvent.

EVT_CHAR_HOOK: int  # Process a  wxEVT_CHAR_HOOK   event. See    wx.KeyEvent.

EVT_MOUSE_CAPTURE_LOST: int  # Process a  wxEVT_MOUSE_CAPTURE_LOST   event. See    wx.MouseCaptureLostEvent.

EVT_MOUSE_CAPTURE_CHANGED: int  # Process a  wxEVT_MOUSE_CAPTURE_CHANGED   event. See    wx.MouseCaptureChangedEvent.

EVT_PAINT: int  # Process a  wxEVT_PAINT   event. See    wx.PaintEvent.

EVT_SET_CURSOR: int  # Process a  wxEVT_SET_CURSOR   event. See    wx.SetCursorEvent.

EVT_SIZE: int  # Process a  wxEVT_SIZE   event. See    wx.SizeEvent.

EVT_SYS_COLOUR_CHANGED: int  # Process a  wxEVT_SYS_COLOUR_CHANGED   event. See    wx.SysColourChangedEvent. ^^

SIMPLE_BORDER: int

SUNKEN_BORDER: int

RAISED_BORDER: int

STATIC_BORDER: int

NO_BORDER: int

WS_EX_BLOCK_EVENTS: int

WS_EX_TRANSIENT: int

WS_EX_CONTEXTHELP: int

WS_EX_PROCESS_IDLE: int

WS_EX_PROCESS_UI_UPDATES: int

BORDER_MASK: int

TOUCH_NONE: int

TOUCH_ALL_GESTURES: int

MOD_SHIFT: int

MOD_CONTROL: int

MOD_ALT: int

MOD_WIN: int

UPDATE_UI_FROMIDLE: int

class Control(Window):
    """ This is the base class for a control or âwidgetâ.

        Source: https://docs.wxpython.org/wx.Control.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def Command(self, event: 'CommandEvent') -> None:
        """ Simulates the effect of the user issuing a command to the item.

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ControlNameStr) -> bool:
        """ parent (wx.Window) â

            Source: https://docs.wxpython.org/wx.Control.html
        """

    @staticmethod
    def Ellipsize(label, dc, mode, maxWidth, flags=ELLIPSIZE_FLAGS_DEFAULT) -> str:
        """ Replaces parts of the label  string with ellipsis, if needed, so that it fits into maxWidth  pixels if possible.

            Source: https://docs.wxpython.org/wx.Control.html
        """

    @staticmethod
    def EscapeMnemonics(text: str) -> str:
        """ Escapes the special mnemonics characters (â&â) in the given string.

            Source: https://docs.wxpython.org/wx.Control.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def GetLabel(self) -> str:
        """ Returns the controlâs label, as it was passed to SetLabel .

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def GetLabelText(self, *args, **kw) -> str:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def GetSizeFromText(self, text: str) -> 'Size':
        """ Determine the minimum size needed by the control to display the given text.

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def GetSizeFromTextSize(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Control.html
        """

    @staticmethod
    def RemoveMnemonics(str: str) -> str:
        """ Returns the given str  string without mnemonics (â&â characters).

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def SetLabel(self, label: str) -> None:
        """ Sets the controlâs label.

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def SetLabelMarkup(self, markup: str) -> bool:
        """ Sets the controls label to a string using markup.

            Source: https://docs.wxpython.org/wx.Control.html
        """

    def SetLabelText(self, text: str) -> None:
        """ Sets the controlâs label to exactly the given string.

            Source: https://docs.wxpython.org/wx.Control.html
        """

    Label: str  # See GetLabel and SetLabel
    LabelText: str  # See GetLabelText and SetLabelText



class ControlWithItems(Control,ItemContainer):
    """ This is convenience class that derives from both Control and
ItemContainer.

        Source: https://docs.wxpython.org/wx.ControlWithItems.html
    """


class ItemContainer(ItemContainerImmutable):
    """ This class is an abstract base class for some wxWidgets controls which
contain several items such as ListBox, CheckListBox, ComboBox or
Choice.

        Source: https://docs.wxpython.org/wx.ItemContainer.html
    """
    def Append(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def AppendItems(self, items) -> Any:
        """ Alias for Append

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def Clear(self) -> None:
        """ Removes all items from the control.

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def Delete(self, n: int) -> None:
        """ Deletes an item from the control.

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def DetachClientObject(self, n: int) -> 'ClientData':
        """ Returns the client object associated with the given item and transfers its ownership to the caller.

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def GetClientData(self, n: int) -> 'ClientData':
        """ Returns a pointer to the client data associated with the given item (if any).

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def GetClientObject(self, n) -> Any:
        """ Alias for GetClientData

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def GetItems(self) -> Any:
        """ Alias for GetStrings

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def HasClientData(self) -> bool:
        """ Returns True, if either untyped data ( void* ) or object data (wxClientData) is associated with the items of the control.

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def HasClientObjectData(self) -> bool:
        """ Returns True, if object data is associated with the items of the control.

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def HasClientUntypedData(self) -> bool:
        """ Returns True, if untyped data ( void* ) is associated with the items of the control.

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def Insert(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def Set(self, items: list[str]) -> None:
        """ Replaces the current control contents with the given items.

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def SetClientData(self, n, data) -> None:
        """ Associates the given typed client data pointer with the given item: the data  object will be deleted when the item is deleted (either explicitly by using Delete   or implicitly when the control itself is destroyed).

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def SetClientObject(self, n, data) -> Any:
        """ Alias for SetClientData

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    def SetItems(self, items) -> Any:
        """ Alias for Set

            Source: https://docs.wxpython.org/wx.ItemContainer.html
        """

    Items: Any  # See GetItems and SetItems



class Cursor(GDIObject):
    """ A cursor is a small bitmap usually used for denoting where the mouse
pointer is, with a picture that might indicate the interpretation of a
mouse click.

        Source: https://docs.wxpython.org/wx.Cursor.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    def GetHandle(self) -> int:
        """ Get the handle for the Cursor.  Windows only.

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    def GetHotSpot(self) -> 'Point':
        """ Returns the coordinates of the cursor hot spot.

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    def IsOk(self) -> bool:
        """ Returns True if cursor data is present.

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    def SetHandle(self, handle) -> None:
        """ Set the handle to use for this Cursor.  Windows only.

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    def _copyFrom(self, other) -> None:
        """ For internal use only.

            Source: https://docs.wxpython.org/wx.Cursor.html
        """

    Handle: int  # See GetHandle and SetHandle
    HotSpot: 'Point'  # See GetHotSpot



class CustomDataObject(DataObjectSimple):
    """ CustomDataObject is a specialization of DataObjectSimple for some
application-specific data in arbitrary (either custom or one of the
standard ones).

        Source: https://docs.wxpython.org/wx.CustomDataObject.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.CustomDataObject.html
        """

    def GetAllFormats(self, dir=DataObject.Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.CustomDataObject.html
        """

    def GetData(self) -> Any:
        """ Returns a reference to the data buffer.

            Source: https://docs.wxpython.org/wx.CustomDataObject.html
        """

    def GetSize(self) -> int:
        """ Returns the data size in bytes.

            Source: https://docs.wxpython.org/wx.CustomDataObject.html
        """

    def SetData(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.CustomDataObject.html
        """

    AllFormats: None  # See GetAllFormats
    Data: Any  # See GetData and SetData
    Size: int  # See GetSize



class DataObjectSimple(DataObject):
    """ This is the simplest possible implementation of the DataObject
class.

        Source: https://docs.wxpython.org/wx.DataObjectSimple.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DataObjectSimple.html
        """

    def GetAllFormats(self, dir=DataObject.Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.DataObjectSimple.html
        """

    def GetDataHere(self, buf) -> bool:
        """ Copies this data objectâs data bytes to the given buffer

            Source: https://docs.wxpython.org/wx.DataObjectSimple.html
        """

    def GetDataSize(self) -> int:
        """ Gets the size of our data.

            Source: https://docs.wxpython.org/wx.DataObjectSimple.html
        """

    def GetFormat(self) -> 'DataFormat':
        """ Returns the (one and only one) format supported by this object.

            Source: https://docs.wxpython.org/wx.DataObjectSimple.html
        """

    def SetData(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DataObjectSimple.html
        """

    def SetFormat(self, format: 'DataFormat') -> None:
        """ Sets the supported format.

            Source: https://docs.wxpython.org/wx.DataObjectSimple.html
        """

    AllFormats: None  # See GetAllFormats
    DataHere: bool  # See GetDataHere
    DataSize: int  # See GetDataSize
    Format: 'DataFormat'  # See GetFormat and SetFormat



class DataFormat:
    """ A DataFormat is an encapsulation of a platform-specific format
handle which is used by the system for the clipboard and drag and drop
operations.

        Source: https://docs.wxpython.org/wx.DataFormat.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DataFormat.html
        """

    def GetId(self) -> str:
        """ Returns the name of a custom format (this function will fail for a standard format).

            Source: https://docs.wxpython.org/wx.DataFormat.html
        """

    def GetType(self) -> 'DataFormatId':
        """ Returns the platform-specific number identifying the format.

            Source: https://docs.wxpython.org/wx.DataFormat.html
        """

    def SetId(self, format: str) -> None:
        """ Sets the format to be the custom format identified by the given name.

            Source: https://docs.wxpython.org/wx.DataFormat.html
        """

    def SetType(self, type: DataFormatId) -> None:
        """ Sets the format to the given value, which should be one of DF_XXX constants.

            Source: https://docs.wxpython.org/wx.DataFormat.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Returns True if the formats are different.

            Source: https://docs.wxpython.org/wx.DataFormat.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Returns True if the formats are equal.

            Source: https://docs.wxpython.org/wx.DataFormat.html
        """

    Id: str  # See GetId and SetId
    Type: 'DataFormatId'  # See GetType and SetType



DF_INVALID: int

DF_TEXT: int

DF_BITMAP: int

DF_METAFILE: int

DF_UNICODETEXT: int

DF_FILENAME: int

DF_HTML: int

DF_PNG: int

class DataObjectComposite(DataObject):
    """ DataObjectComposite is the simplest DataObject derivation which
may be used to support multiple formats.

        Source: https://docs.wxpython.org/wx.DataObjectComposite.html
    """
    def __init__(self) -> None:
        """ The default constructor.

            Source: https://docs.wxpython.org/wx.DataObjectComposite.html
        """

    def Add(self, dataObject, preferred=False) -> None:
        """ Adds the dataObject  to the list of supported objects and it becomes the preferred object if preferred  is True.

            Source: https://docs.wxpython.org/wx.DataObjectComposite.html
        """

    def GetAllFormats(self, dir=DataObject.Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.DataObjectComposite.html
        """

    def GetObject(self, format, dir=DataObject.Get) -> 'DataObjectSimple':
        """ Returns the pointer to the object which supports the passed format for the specified direction.

            Source: https://docs.wxpython.org/wx.DataObjectComposite.html
        """

    def GetReceivedFormat(self) -> 'DataFormat':
        """ Report the format passed to the SetData   method.

            Source: https://docs.wxpython.org/wx.DataObjectComposite.html
        """

    def SetData(self, format, buf) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.DataObjectComposite.html
        """

    AllFormats: None  # See GetAllFormats
    ReceivedFormat: 'DataFormat'  # See GetReceivedFormat



class DateSpan:
    """ This class is a âlogical time spanâ and is useful for implementing
program logic for such things as âadd one month to the dateâ which, in
general, doesnât mean to add 60x60x24x31 seconds to it, but to take
the same date the next month (to understand that this is indeed
different consider adding one month to Feb, 15  we want to get Mar,
15, of course).

        Source: https://docs.wxpython.org/wx.DateSpan.html
    """
    def __init__(self, years=0, months=0, weeks=0, days=0) -> None:
        """ Constructs the date span object for the given number of years, months, weeks and days.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def Add(self, other: 'DateSpan') -> 'DateSpan':
        """ Adds the given   wx.DateSpan  to this   wx.DateSpan  and returns a reference to itself.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Day() -> 'DateSpan':
        """ Returns a date span object corresponding to one day.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Days(days: int) -> 'DateSpan':
        """ Returns a date span object corresponding to the given number of days.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def GetDays(self) -> int:
        """ Returns the number of days (not counting the weeks component) in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def GetMonths(self) -> int:
        """ Returns the number of the months (not counting the years) in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def GetTotalDays(self) -> int:
        """ Returns the combined number of days in this date span, counting both weeks and days.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def GetTotalMonths(self) -> int:
        """ Returns the combined number of months in this date span, counting both years and months.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def GetWeeks(self) -> int:
        """ Returns the number of weeks in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def GetYears(self) -> int:
        """ Returns the number of years in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Month() -> 'DateSpan':
        """ Returns a date span object corresponding to one month.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Months(mon: int) -> 'DateSpan':
        """ Returns a date span object corresponding to the given number of months.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def Multiply(self, factor: int) -> 'DateSpan':
        """ Multiplies this date span by the specified factor.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def Neg(self) -> 'DateSpan':
        """ Changes the sign of this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def Negate(self) -> 'DateSpan':
        """ Returns a date span with the opposite sign.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def SetDays(self, n: int) -> 'DateSpan':
        """ Sets the number of days (without modifying any other components) in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def SetMonths(self, n: int) -> 'DateSpan':
        """ Sets the number of months (without modifying any other components) in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def SetWeeks(self, n: int) -> 'DateSpan':
        """ Sets the number of weeks (without modifying any other components) in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def SetYears(self, n: int) -> 'DateSpan':
        """ Sets the number of years (without modifying any other components) in this date span.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    def Subtract(self, other: 'DateSpan') -> 'DateSpan':
        """ Subtracts the given   wx.DateSpan  to this   wx.DateSpan  and returns a reference to itself.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Week() -> 'DateSpan':
        """ Returns a date span object corresponding to one week.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Weeks(weeks: int) -> 'DateSpan':
        """ Returns a date span object corresponding to the given number of weeks.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Year() -> 'DateSpan':
        """ Returns a date span object corresponding to one year.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """

    @staticmethod
    def Years(years: int) -> 'DateSpan':
        """ Returns a date span object corresponding to the given number of years.

            Source: https://docs.wxpython.org/wx.DateSpan.html
        """



class DateTime:
    """ DateTime class represents an absolute moment in time.

        Source: https://docs.wxpython.org/wx.DateTime.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def Add(self, *args, **kw) -> 'DateTime':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def ConvertYearToBC(year: int) -> int:
        """ Converts the year in absolute notation (i.e. a number which can be negative, positive or zero) to the year in BC/AD notation.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def DiffAsDateSpan(self, dt: 'DateTime') -> 'DateSpan':
        """ Returns the difference between this object and dt  as a   wx.DateSpan.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def Format(self, format=DefaultDateTimeFormat, tz=Local) -> str:
        """ This function does the same as the standard ANSI C  strftime(3)   function (https://cplusplus.com/reference/ctime/strftime/).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def FormatDate(self) -> str:
        """ Identical to calling Format   with  "%x"   argument (which means âpreferred date representation for the current localeâ).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def FormatISOCombined(self, sep: int='T') -> str:
        """ Returns the combined date-time representation in the ISO 8601 format  "YYYY-MM-DDTHH:MM:SS" .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def FormatISODate(self) -> str:
        """ This function returns the date representation in the ISO 8601 format  "YYYY-MM-DD" .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def FormatISOTime(self) -> str:
        """ This function returns the time representation in the ISO 8601 format  "HH:MM:SS" .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def FormatTime(self) -> str:
        """ Identical to calling Format   with  "%X"   argument (which means âpreferred time representation for the current localeâ).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def FromDMY(day, month, year=Inv_Year, hour=0, minute=0, second=0, millisecond=0) -> 'DateTime':
        """ Construct a DateTime using the supplied parameters.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def FromHMS(hour, minute=0, second=0, millisecond=0) -> 'DateTime':
        """ Construct a DateTime equal to Today () with the time set to the supplied parameters.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def FromJDN(jdn) -> 'DateTime':
        """ Construct a DateTime from a Julian Day Number.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def FromTimeT(timet) -> 'DateTime':
        """ Construct a DateTime from a C time_t value, the number of seconds since the epoch.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def FromTimezone(self, tz, noDST=False) -> 'DateTime':
        """ Transform the date from the given time zone to the local one.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetAmPmStrings() -> tuple:
        """ Returns the translations of the strings  AM   and   PM   used for time formatting for the current locale.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetAsDOS(self) -> int:
        """ Returns the date and time in DOS format.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetBeginDST(year=Inv_Year, country=Country_Default) -> 'DateTime':
        """ Get the beginning of DST for the given country in the given year (current one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetCentury(self, tz: 'DateTime.TimeZone'=Local) -> int:
        """ Returns the century of this date.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetCountry() -> 'Country':
        """ Returns the current default country.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetCurrentMonth(cal: Calendar=Gregorian) -> 'Month':
        """ Get the current month in given calendar (only Gregorian is currently supported).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetCurrentYear(cal: Calendar=Gregorian) -> int:
        """ Get the current year in given calendar (only Gregorian is currently supported).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetDateOnly(self) -> 'DateTime':
        """ Returns the object having the same date component as this one but time of 00:00:00.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetDay(self, tz: 'DateTime.TimeZone'=Local) -> 'intshort':
        """ Returns the day in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetDayOfYear(self, tz: 'DateTime.TimeZone'=Local) -> 'intshort':
        """ Returns the day of the year (in 1-366 range) in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetEndDST(year=Inv_Year, country=Country_Default) -> 'DateTime':
        """ Returns the end of DST for the given country in the given year (current one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetEnglishMonthName(month, flags=Name_Full) -> str:
        """ Return the standard English name of the given month.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetEnglishWeekDayName(weekday, flags=Name_Full) -> str:
        """ Return the standard English name of the given week day.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetFirstWeekDay(firstDay: WeekDay) -> bool:
        """ Acquires the first weekday of a week based on locale and/or OS settings.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetHour(self, tz: 'DateTime.TimeZone'=Local) -> 'intshort':
        """ Returns the hour in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetJDN(self) -> float:
        """ Synonym for GetJulianDayNumber .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetJulianDayNumber(self) -> float:
        """ Returns the JDN corresponding to this date.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetLastMonthDay(self, month=Inv_Month, year=Inv_Year) -> 'DateTime':
        """ Returns the copy of this object to which SetToLastMonthDay   was applied.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetLastWeekDay(self, weekday, month=Inv_Month, year=Inv_Year) -> 'DateTime':
        """ Returns the copy of this object to which SetToLastWeekDay   was applied.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetMJD(self) -> float:
        """ Synonym for GetModifiedJulianDayNumber .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetMillisecond(self, tz: 'DateTime.TimeZone'=Local) -> 'intshort':
        """ Returns the milliseconds in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetMinute(self, tz: 'DateTime.TimeZone'=Local) -> 'intshort':
        """ Returns the minute in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetModifiedJulianDayNumber(self) -> float:
        """ Returns the âModified Julian Day Numberâ  (MJD) which is, by definition, is equal to JDN - 2400000.5.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetMonth(self, tz: 'DateTime.TimeZone'=Local) -> 'Month':
        """ Returns the month in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetMonthName(month, flags=Name_Full) -> str:
        """ Gets the full (default) or abbreviated name of the given month.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetNextWeekDay(self, weekday: DateTime.WeekDay) -> 'DateTime':
        """ Returns the copy of this object to which SetToNextWeekDay   was applied.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetNumberOfDays(month, year=Inv_Year, cal=Gregorian) -> 'intshort':
        """ Returns the number of days in the given month of the given year.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetPrevWeekDay(self, weekday: DateTime.WeekDay) -> 'DateTime':
        """ Returns the copy of this object to which SetToPrevWeekDay   was applied.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetRataDie(self) -> float:
        """ Return the Rata  Die number of this date.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetSecond(self, tz: 'DateTime.TimeZone'=Local) -> 'intshort':
        """ Returns the seconds in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetTicks(self) -> int:
        """ Returns the number of seconds since Jan 1, 1970 UTC.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetTimeNow() -> int:
        """ Returns the current time.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetTm(self, tz: 'DateTime.TimeZone'=Local) -> 'Tm':
        """ Returns broken down representation of the date and time.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetValue(self) -> int:
        """ Returns the number of milliseconds since Jan 1, 1970 UTC.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetWeekBasedYear(self, tz: 'DateTime.TimeZone') -> int:
        """ Returns the year to which the week containing this date belongs.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetWeekDay(self, *args, **kw) -> 'WeekDay':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetWeekDayInSameWeek(self, weekday, flags=Monday_First) -> 'DateTime':
        """ Returns the copy of this object to which SetToWeekDayInSameWeek   was applied.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def GetWeekDayName(weekday, flags=Name_Full) -> str:
        """ Gets the full (default) or abbreviated name of the given week day.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetWeekOfMonth(self, flags=Monday_First, tz=Local) -> 'intshort':
        """ Returns the ordinal number of the week in the month (in 1-5 range).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetWeekOfYear(self, flags=Monday_First, tz=Local) -> 'intshort':
        """ Returns the number of the week of the year this date is in.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetYear(self, tz: 'DateTime.TimeZone'=Local) -> int:
        """ Returns the year in the given timezone (local one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def GetYearDay(self, yday: int) -> 'DateTime':
        """ Returns the copy of this object to which SetToYearDay   was applied.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsBetween(self, t1, t2) -> bool:
        """ Returns True if IsStrictlyBetween   is True or if the date is equal to one of the limit values.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsDST(self, country: Country=Country_Default) -> int:
        """ Returns True if the DST is applied for this date in the given country.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def IsDSTApplicable(year=Inv_Year, country=Country_Default) -> bool:
        """ Returns True if DST was used in the given year (the current one by default) in the given country.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsEarlierThan(self, datetime: 'DateTime') -> bool:
        """ Returns True if this date precedes the given one.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsEqualTo(self, datetime: 'DateTime') -> bool:
        """ Returns True if the two dates are strictly identical.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsEqualUpTo(self, dt, ts) -> bool:
        """ Returns True if the date is equal to another one up to the given time interval, i.e. if the absolute difference between the two dates is less than this interval.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsLaterThan(self, datetime: 'DateTime') -> bool:
        """ Returns True if this date is later than the given one.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def IsLeapYear(year=Inv_Year, cal=Gregorian) -> bool:
        """ Returns True if the year  is a leap one in the specified calendar.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsSameDate(self, dt: 'DateTime') -> bool:
        """ Returns True if the date is the same without comparing the time parts.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsSameTime(self, dt: 'DateTime') -> bool:
        """ Returns True if the time is the same (although dates may differ).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsStrictlyBetween(self, t1, t2) -> bool:
        """ Returns True if this date lies strictly between the two given dates.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsValid(self) -> bool:
        """ Returns True if the object represents a valid time moment.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def IsWestEuropeanCountry(country: Country=Country_Default) -> bool:
        """ This function returns True if the specified (or default) country is one of Western European ones.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def IsWorkDay(self, country: Country=Country_Default) -> bool:
        """ Returns True is this day is not a holiday in the given country.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def MakeFromTimezone(self, tz, noDST=False) -> 'DateTime':
        """ Same as FromTimezone   but modifies the object in place.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def MakeTimezone(self, tz, noDST=False) -> 'DateTime':
        """ Modifies the object in place to represent the date in another time zone.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def MakeUTC(self, noDST: bool=False) -> 'DateTime':
        """ This is the same as calling MakeTimezone   with the argument  GMT0 .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def Now() -> 'DateTime':
        """ Returns the object corresponding to the current time in local time zone.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseDate(self, date: str) -> int:
        """ This function is like ParseDateTime , but it only allows the date to be specified.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseDateTime(self, datetime: str) -> int:
        """ Parses the string datetime  containing the date and time in free format.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseFormat(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseISOCombined(self, date, sep='T') -> bool:
        """ This function parses the string containing the date and time in ISO 8601 combined format  "YYYY-MM-DDTHH:MM:SS" .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseISODate(self, date: str) -> bool:
        """ This function parses the date in ISO 8601 format  "YYYY-MM-DD" .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseISOTime(self, date: str) -> bool:
        """ This function parses the time in ISO 8601 format  "HH:MM:SS" .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseRfc822Date(self, date: str) -> int:
        """ Parses the string date  looking for a date formatted according to the RFC 822 in it.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ParseTime(self, time: str) -> int:
        """ This functions is like ParseDateTime , but only allows the time to be specified in the input string.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ResetTime(self) -> 'DateTime':
        """ Reset time to midnight (00:00:00) without changing the date.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def Set(self, day, month, year=Inv_Year, hour=0, minute=0, second=0, millisec=0) -> 'DateTime':
        """ Sets the date and time from the parameters.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetHMS(self, hour, minute=0, second=0, millisec=0) -> 'DateTime':
        """ Sets the date to be equal to Today   and the time from supplied parameters.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetJDN(self, jdn: float) -> 'DateTime':
        """ Sets the date from the so-called Julian Day Number.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetTimeT(self, timet: int) -> 'DateTime':
        """ Constructs the object from timet  value holding the number of seconds since Jan 1, 1970 UTC.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetTm(self, tm: 'DateTime.Tm') -> 'DateTime':
        """ Sets the date and time from the broken down representation in the  ` wx.DateTime.Tm  `   structure.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def SetCountry(country: Country) -> None:
        """ Sets the country to use by default.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetDay(self, day: int) -> 'DateTime':
        """ Sets the day without changing other date components.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetFromDOS(self, ddt: int) -> 'DateTime':
        """ Sets the date from the date and time in DOS format.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetHour(self, hour: int) -> 'DateTime':
        """ Sets the hour without changing other date components.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetMillisecond(self, millisecond: int) -> 'DateTime':
        """ Sets the millisecond without changing other date components.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetMinute(self, minute: int) -> 'DateTime':
        """ Sets the minute without changing other date components.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetMonth(self, month: DateTime.Month) -> 'DateTime':
        """ Sets the month without changing other date components.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetSecond(self, second: int) -> 'DateTime':
        """ Sets the second without changing other date components.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToCurrent(self) -> 'DateTime':
        """ Sets the date and time of to the current values.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToLastMonthDay(self, month=Inv_Month, year=Inv_Year) -> 'DateTime':
        """ Sets the date to the last day in the specified month (the current one by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToLastWeekDay(self, weekday, month=Inv_Month, year=Inv_Year) -> bool:
        """ The effect of calling this function is the same as of calling  SetToWeekDay (-1, weekday, month, year).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToNextWeekDay(self, weekday: DateTime.WeekDay) -> 'DateTime':
        """ Sets the date so that it will be the first weekday  following the current date.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToPrevWeekDay(self, weekday: DateTime.WeekDay) -> 'DateTime':
        """ Sets the date so that it will be the last weekday  before the current date.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToWeekDay(self, weekday, n=1, month=Inv_Month, year=Inv_Year) -> bool:
        """ Sets the date to the n-th weekday  in the given month of the given year (the current month and year are used by default).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToWeekDayInSameWeek(self, weekday, flags=Monday_First) -> 'DateTime':
        """ Adjusts the date so that it will still lie in the same week as before, but its week day will be the given one.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def SetToWeekOfYear(year, numWeek, weekday=Mon) -> 'DateTime':
        """ Set the date to the given weekday  in the week number numWeek  of the given year  .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetToYearDay(self, yday: int) -> 'DateTime':
        """ Sets the date to the day number yday  in the same year (i.e. unlike the other functions, this one does not use the current year).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def SetYear(self, year: int) -> 'DateTime':
        """ Sets the year without changing other date components.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def Subtract(self, *args, **kw) -> 'DateTime':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ToTimezone(self, tz, noDST=False) -> 'DateTime':
        """ Transform the date to the given time zone.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def ToUTC(self, noDST: bool=False) -> 'DateTime':
        """ This is the same as calling ToTimezone   with the argument  GMT0 .

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def Today() -> 'DateTime':
        """ Returns the object corresponding to the midnight of the current day (i.e. the same as wx.Now     , but the time part is set to 0).

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    @staticmethod
    def UNow() -> 'DateTime':
        """ Returns the object corresponding to the current time including the milliseconds.

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def __repr__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    def __str__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DateTime.html
        """

    DayOfYear: 'intshort'  # See GetDayOfYear
    JDN: float  # See GetJDN and SetJDN
    JulianDayNumber: float  # See GetJulianDayNumber
    LastMonthDay: 'DateTime'  # See GetLastMonthDay
    MJD: float  # See GetMJD
    ModifiedJulianDayNumber: float  # See GetModifiedJulianDayNumber
    RataDie: float  # See GetRataDie
    Ticks: int  # See GetTicks
    WeekOfMonth: 'intshort'  # See GetWeekOfMonth
    WeekOfYear: 'intshort'  # See GetWeekOfYear
    day: Any  # See GetDay and SetDay
    hour: Any  # See GetHour and SetHour
    millisecond: Any  # See GetMillisecond and SetMillisecond
    minute: Any  # See GetMinute and SetMinute
    month: Any  # See GetMonth and SetMonth
    second: Any  # See GetSecond and SetSecond
    year: Any  # See GetYear and SetYear



class DCBrushChanger:
    """ DCBrushChanger is a small helper class for setting a brush on a DC
and unsetting it automatically in the destructor, restoring the
previous one.

        Source: https://docs.wxpython.org/wx.DCBrushChanger.html
    """
    def __init__(self, dc, brush) -> None:
        """ Sets brush  on the given dc, storing the old one.

            Source: https://docs.wxpython.org/wx.DCBrushChanger.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCBrushChanger.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCBrushChanger.html
        """



class DCClipper:
    """ DCClipper is a helper class for setting a clipping region on a DC
during its lifetime.

        Source: https://docs.wxpython.org/wx.DCClipper.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Sets the clipping region to the specified region/coordinates.

            Source: https://docs.wxpython.org/wx.DCClipper.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCClipper.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCClipper.html
        """



class DCFontChanger:
    """ DCFontChanger is a small helper class for setting a font on a DC
and unsetting it automatically in the destructor, restoring the
previous one.

        Source: https://docs.wxpython.org/wx.DCFontChanger.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DCFontChanger.html
        """

    def Set(self, font: 'Font') -> None:
        """ Set the font to use.

            Source: https://docs.wxpython.org/wx.DCFontChanger.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCFontChanger.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCFontChanger.html
        """



class DCOverlay:
    """ Connects an overlay with a drawing DC.

        Source: https://docs.wxpython.org/wx.DCOverlay.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DCOverlay.html
        """

    def Clear(self) -> None:
        """ Clears the layer, restoring the state at the last init.

            Source: https://docs.wxpython.org/wx.DCOverlay.html
        """



class DCPenChanger:
    """ DCPenChanger is a small helper class for setting a pen on a DC and
unsetting it automatically in the destructor, restoring the previous
one.

        Source: https://docs.wxpython.org/wx.DCPenChanger.html
    """
    def __init__(self, dc, pen) -> None:
        """ Sets pen  on the given dc, storing the old one.

            Source: https://docs.wxpython.org/wx.DCPenChanger.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCPenChanger.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCPenChanger.html
        """



class DCTextBgColourChanger:
    """ DCTextBgColourChanger is a small helper class for setting a
background text colour on a DC and unsetting it automatically in the
destructor, restoring the previous one.

        Source: https://docs.wxpython.org/wx.DCTextBgColourChanger.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DCTextBgColourChanger.html
        """

    def Set(self, col: Union[int, str, 'Colour']) -> None:
        """ Set the background colour to use.

            Source: https://docs.wxpython.org/wx.DCTextBgColourChanger.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCTextBgColourChanger.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCTextBgColourChanger.html
        """



class DCTextBgModeChanger:
    """ DCTextBgModeChanger is a small helper class for setting a background
text mode on a DC and unsetting it automatically in the destructor,
restoring the previous one.

        Source: https://docs.wxpython.org/wx.DCTextBgModeChanger.html
    """
    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCTextBgModeChanger.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCTextBgModeChanger.html
        """



class DCTextColourChanger:
    """ DCTextColourChanger is a small helper class for setting a foreground
text colour on a DC and unsetting it automatically in the
destructor, restoring the previous one.

        Source: https://docs.wxpython.org/wx.DCTextColourChanger.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DCTextColourChanger.html
        """

    def Set(self, col: Union[int, str, 'Colour']) -> None:
        """ Set the colour to use.

            Source: https://docs.wxpython.org/wx.DCTextColourChanger.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCTextColourChanger.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DCTextColourChanger.html
        """



class DelegateRendererNative(RendererNative):
    """ DelegateRendererNative allows reuse of renderers code by forwarding
all the RendererNative methods to the given object and thus allowing
you to only modify some of its methods  without having to reimplement
all of them.

        Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawCheckBox(self, win, dc, rect, flags=0) -> None:
        """ Draw a check box.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawCheckMark(self, win, dc, rect, flags=0) -> None:
        """ Draw a check mark.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawComboBoxDropButton(self, win, dc, rect, flags=0) -> None:
        """ Draw a button like the one used by   wx.ComboBox  to show a drop down window.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawDropArrow(self, win, dc, rect, flags=0) -> None:
        """ Draw a drop down arrow that is suitable for use outside a combo box.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawFocusRect(self, win, dc, rect, flags=0) -> None:
        """ Draw a focus rectangle using the specified rectangle.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawHeaderButton(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int:
        """ Draw the header control button (used, for example, by   wx.ListCtrl).

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawHeaderButtonContents(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int:
        """ Draw the contents of a header control button (label, sort arrows, etc.).

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawItemSelectionRect(self, win, dc, rect, flags=0) -> None:
        """ Draw a selection rectangle underneath the text as used e.g.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawPushButton(self, win, dc, rect, flags=0) -> None:
        """ Draw a blank push button that looks very similar to   wx.Button.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawSplitterBorder(self, win, dc, rect, flags=0) -> None:
        """ Draw the border for sash window: this border must be such that the sash drawn by DrawSplitterSash   blends into it well.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawSplitterSash(self, win, dc, size, position, orient, flags=0) -> None:
        """ Draw a sash.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawTitleBarBitmap(self, win, dc, rect, button, flags=0) -> None:
        """ Draw a title bar button in the given state.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def DrawTreeItemButton(self, win, dc, rect, flags=0) -> None:
        """ Draw the expanded/collapsed icon for a tree control item.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def GetCheckBoxSize(self, win, flags=0) -> 'Size':
        """ Returns the size of a check box.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def GetCheckMarkSize(self, win: 'Window') -> 'Size':
        """ Returns the size of a check mark.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def GetExpanderSize(self, win: 'Window') -> 'Size':
        """ Returns the size of the expander used in tree-like controls.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def GetHeaderButtonHeight(self, win: 'Window') -> int:
        """ Returns the height of a header button, either a fixed platform height if available, or a generic height based on the win  windowâs font.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def GetHeaderButtonMargin(self, win: 'Window') -> int:
        """ Returns the horizontal margin on the left and right sides of header buttonâs label.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def GetSplitterParams(self, win: 'Window') -> 'SplitterRenderParams':
        """ Get the splitter parameters, see   wx.SplitterRenderParams.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    def GetVersion(self) -> 'RendererVersion':
        """ This function is used for version checking: Load   refuses to load any shared libraries implementing an older or incompatible version.

            Source: https://docs.wxpython.org/wx.DelegateRendererNative.html
        """

    Version: 'RendererVersion'  # See GetVersion



class RendererNative:
    """ First, a brief introduction to RendererNative and why it is needed.

        Source: https://docs.wxpython.org/wx.RendererNative.html
    """
    def DrawCheckBox(self, win, dc, rect, flags=0) -> None:
        """ Draw a check box.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawCheckMark(self, win, dc, rect, flags=0) -> None:
        """ Draw a check mark.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawChoice(self, win, dc, rect, flags=0) -> None:
        """ Draw a native   wx.Choice.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawCollapseButton(self, win, dc, rect, flags=0) -> None:
        """ Draw a collapse button.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawComboBox(self, win, dc, rect, flags=0) -> None:
        """ Draw a native   wx.ComboBox.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawComboBoxDropButton(self, win, dc, rect, flags=0) -> None:
        """ Draw a button like the one used by   wx.ComboBox  to show a drop down window.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawDropArrow(self, win, dc, rect, flags=0) -> None:
        """ Draw a drop down arrow that is suitable for use outside a combo box.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawFocusRect(self, win, dc, rect, flags=0) -> None:
        """ Draw a focus rectangle using the specified rectangle.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawGauge(self, win, dc, rect, value, max, flags=0) -> None:
        """ Draw a progress bar in the specified rectangle.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawHeaderButton(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int:
        """ Draw the header control button (used, for example, by   wx.ListCtrl).

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawHeaderButtonContents(self, win, dc, rect, flags=0, sortArrow=HDR_SORT_ICON_NONE, params=None) -> int:
        """ Draw the contents of a header control button (label, sort arrows, etc.).

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawItemSelectionRect(self, win, dc, rect, flags=0) -> None:
        """ Draw a selection rectangle underneath the text as used e.g.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawItemText(self, win, dc, text, rect, align=ALIGN_LEFT|ALIGN_TOP, flags=0, ellipsizeMode=ELLIPSIZE_END) -> None:
        """ Draw item text in the correct color based on selection status.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawPushButton(self, win, dc, rect, flags=0) -> None:
        """ Draw a blank push button that looks very similar to   wx.Button.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawRadioBitmap(self, win, dc, rect, flags=0) -> None:
        """ Draw a native   wx.RadioButton  bitmap.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawSplitterBorder(self, win, dc, rect, flags=0) -> None:
        """ Draw the border for sash window: this border must be such that the sash drawn by DrawSplitterSash   blends into it well.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawSplitterSash(self, win, dc, size, position, orient, flags=0) -> None:
        """ Draw a sash.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawTextCtrl(self, win, dc, rect, flags=0) -> None:
        """ Draw a native   wx.TextCtrl  frame.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawTitleBarBitmap(self, win, dc, rect, button, flags=0) -> None:
        """ Draw a title bar button in the given state.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def DrawTreeItemButton(self, win, dc, rect, flags=0) -> None:
        """ Draw the expanded/collapsed icon for a tree control item.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    @staticmethod
    def Get() -> 'RendererNative':
        """ Return the currently used renderer.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetCheckBoxSize(self, win, flags=0) -> 'Size':
        """ Returns the size of a check box.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetCheckMarkSize(self, win: 'Window') -> 'Size':
        """ Returns the size of a check mark.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetCollapseButtonSize(self, win, dc) -> 'Size':
        """ Returns the size of a collapse button.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    @staticmethod
    def GetDefault() -> 'RendererNative':
        """ Return the default (native) implementation for this platform â  this is also the one used by default but this may be changed by calling Set   in which case the return value of this method may be different from the return value of Get .

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetExpanderSize(self, win: 'Window') -> 'Size':
        """ Returns the size of the expander used in tree-like controls.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    @staticmethod
    def GetGeneric() -> 'RendererNative':
        """ Return the generic implementation of the renderer.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetHeaderButtonHeight(self, win: 'Window') -> int:
        """ Returns the height of a header button, either a fixed platform height if available, or a generic height based on the win  windowâs font.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetHeaderButtonMargin(self, win: 'Window') -> int:
        """ Returns the horizontal margin on the left and right sides of header buttonâs label.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetSplitterParams(self, win: 'Window') -> 'SplitterRenderParams':
        """ Get the splitter parameters, see   wx.SplitterRenderParams.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    def GetVersion(self) -> 'RendererVersion':
        """ This function is used for version checking: Load   refuses to load any shared libraries implementing an older or incompatible version.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    @staticmethod
    def Load(name: str) -> 'RendererNative':
        """ Load the renderer from the specified DLL, the returned pointer must be deleted by caller if not None when it is not used any more.

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    @staticmethod
    def Set(renderer: 'RendererNative') -> 'RendererNative':
        """ Set the renderer to use, passing None reverts to using the default renderer (the global renderer must always exist).

            Source: https://docs.wxpython.org/wx.RendererNative.html
        """

    Version: 'RendererVersion'  # See GetVersion



class Dialog(TopLevelWindow):
    """ A dialog box is a window with a title bar and sometimes a system menu,
which can be moved around the screen.

        Source: https://docs.wxpython.org/wx.Dialog.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def AddMainButtonId(self, id: int) -> None:
        """ Adds an identifier to be regarded as a main button for the non-scrolling area of a dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def CanDoLayoutAdaptation(self) -> bool:
        """ Returns True if this dialog can and should perform layout adaptation using DoLayoutAdaptation , usually if the dialog is too large to fit on the display.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def Centre(self, direction: int=BOTH) -> None:
        """ Centres the dialog box on the display.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def Create(self, parent, id=ID_ANY, title="", pos=DefaultPosition, size=DefaultSize, style=DEFAULT_DIALOG_STYLE, name=DialogNameStr) -> bool:
        """ Used for two-step dialog box construction.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def CreateButtonSizer(self, flags: int) -> 'Sizer':
        """ Creates a sizer with standard buttons.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def CreateSeparatedButtonSizer(self, flags: int) -> 'Sizer':
        """ Creates a sizer with standard buttons using CreateButtonSizer   separated from the rest of the dialog contents by a horizontal   wx.StaticLine.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def CreateSeparatedSizer(self, sizer: 'Sizer') -> 'Sizer':
        """ Returns the sizer containing the given one with a separating   wx.StaticLine  if necessarily.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def CreateStdDialogButtonSizer(self, flags: int) -> 'StdDialogButtonSizer':
        """ Creates a   wx.StdDialogButtonSizer  with standard buttons.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def CreateTextSizer(self, message, widthMax=-1) -> 'Sizer':
        """ Splits text up at newlines and places the lines into   wx.StaticText  objects with the specified maximum width in a vertical   wx.BoxSizer.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def DoLayoutAdaptation(self) -> bool:
        """ Performs layout adaptation, usually if the dialog is too large to fit on the display.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    @staticmethod
    def EnableLayoutAdaptation(enable: bool) -> None:
        """ A static function enabling or disabling layout adaptation for all dialogs.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def EndModal(self, retCode: int) -> None:
        """ Ends a modal dialog, passing a value to be returned from the ShowModal   invocation.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetAffirmativeId(self) -> int:
        """ Gets the identifier of the button which works like standard wx.OK button in this dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetContentWindow(self) -> 'Window':
        """ Override this to return a window containing the main content of the dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetEscapeId(self) -> int:
        """ Gets the identifier of the button to map presses of  ESC   button to.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetLayoutAdaptationDone(self) -> bool:
        """ Returns True if the dialog has been adapted, usually by making it scrollable to work with a small display.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetLayoutAdaptationLevel(self) -> int:
        """ Gets a value representing the aggressiveness of search for buttons and sizers to be in the non-scrolling part of a layout-adapted dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetLayoutAdaptationMode(self) -> 'DialogLayoutAdaptationMode':
        """ Gets the adaptation mode, overriding the global adaptation flag.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    @staticmethod
    def GetLayoutAdapter() -> 'DialogLayoutAdapter':
        """ A static function getting the current layout adapter object.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetMainButtonIds(self) -> list[int]:
        """ Returns an array of identifiers to be regarded as the main buttons for the non-scrolling area of a dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def GetReturnCode(self) -> int:
        """ Gets the return code for this window.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def Iconize(self, iconize: bool=True) -> None:
        """ Iconizes or restores the dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def IsIconized(self) -> bool:
        """ Returns True if the dialog box is iconized.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    @staticmethod
    def IsLayoutAdaptationEnabled() -> bool:
        """ A static function returning True if layout adaptation is enabled for all dialogs.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def IsMainButtonId(self, id: int) -> bool:
        """ Returns True if id  is in the array of identifiers to be regarded as the main buttons for the non-scrolling area of a dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def IsModal(self) -> bool:
        """ Returns True if the dialog box is modal, False otherwise.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetAffirmativeId(self, id: int) -> None:
        """ Sets the identifier to be used as wx.OK button.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetEscapeId(self, id: int) -> None:
        """ Sets the identifier of the button which should work like the standard âCancelâ button in this dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetIcon(self, icon: 'Icon') -> None:
        """ Sets the icon for this dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetIcons(self, icons: 'IconBundle') -> None:
        """ Sets the icons for this dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetLayoutAdaptationDone(self, done: bool) -> None:
        """ Marks the dialog as having been adapted, usually by making it scrollable to work with a small display.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetLayoutAdaptationLevel(self, level: int) -> None:
        """ Sets the aggressiveness of search for buttons and sizers to be in the non-scrolling part of a layout-adapted dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetLayoutAdaptationMode(self, mode: DialogLayoutAdaptationMode) -> None:
        """ Sets the adaptation mode, overriding the global adaptation flag.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    @staticmethod
    def SetLayoutAdapter(adapter: 'DialogLayoutAdapter') -> 'DialogLayoutAdapter':
        """ A static function for setting the current layout adapter object, returning the old adapter.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def SetReturnCode(self, retCode: int) -> None:
        """ Sets the return code for this window.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def Show(self, show: bool=True) -> bool:
        """ Hides or shows the dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def ShowModal(self) -> int:
        """ Shows an application-modal dialog.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def ShowWindowModal(self) -> None:
        """ Shows a dialog modal to the parent top level window only.

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Dialog.html
        """

    AffirmativeId: int  # See GetAffirmativeId and SetAffirmativeId
    ContentWindow: 'Window'  # See GetContentWindow
    EscapeId: int  # See GetEscapeId and SetEscapeId
    LayoutAdaptationDone: bool  # See GetLayoutAdaptationDone and SetLayoutAdaptationDone
    LayoutAdaptationLevel: int  # See GetLayoutAdaptationLevel and SetLayoutAdaptationLevel
    LayoutAdaptationMode: 'DialogLayoutAdaptationMode'  # See GetLayoutAdaptationMode and SetLayoutAdaptationMode
    MainButtonIds: list[int]  # See GetMainButtonIds
    ReturnCode: int  # See GetReturnCode and SetReturnCode



CAPTION: int  # Puts a caption on the dialog box.

DEFAULT_DIALOG_STYLE: int  # Equivalent to a combination of wx.CAPTION, wx.CLOSE_BOX and wx.SYSTEM_MENU (the last one is not used under Unix).

RESIZE_BORDER: int  # Display a resizable frame around the window.

SYSTEM_MENU: int  # Display a system menu.

CLOSE_BOX: int  # Displays a close box on the frame.

MAXIMIZE_BOX: int  # Displays a maximize box on the dialog.

MINIMIZE_BOX: int  # Displays a minimize box on the dialog.

THICK_FRAME: int  # Display a thick frame around the window.

STAY_ON_TOP: int  # The dialog stays on top of all other windows.

NO_3D: int  # This style is obsolete and doesnât do anything any more, donât use it in any new code.

DIALOG_NO_PARENT: int  # By default, a dialog created with a None parent window will be given the applicationâs top level window  as parent. Use this style to prevent this from happening and create an orphan dialog. This is not recommended for modal dialogs.

DIALOG_EX_METAL: int  # On macOS, frames with this style will be shown with a metallic look. This is an extra style. ^^

EVT_INIT_DIALOG: int  # Process a  wxEVT_INIT_DIALOG   event. See    wx.InitDialogEvent. ^^

CANCEL: int

YES: int

NO: int

APPLY: int

CLOSE: int

HELP: int

NO_DEFAULT: int

class DialogLayoutAdapter:
    """ This abstract class is the base for classes that help wxWidgets
perform run-time layout adaptation of dialogs.

        Source: https://docs.wxpython.org/wx.DialogLayoutAdapter.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.DialogLayoutAdapter.html
        """

    def CanDoLayoutAdaptation(self, dialog: 'Dialog') -> bool:
        """ Override this to returns True if adaptation can and should be done.

            Source: https://docs.wxpython.org/wx.DialogLayoutAdapter.html
        """

    def DoLayoutAdaptation(self, dialog: 'Dialog') -> bool:
        """ Override this to perform layout adaptation, such as making parts of the dialog scroll and resizing the dialog to fit the display.

            Source: https://docs.wxpython.org/wx.DialogLayoutAdapter.html
        """



class DirDialog(Dialog):
    """ This class represents the directory chooser dialog.

        Source: https://docs.wxpython.org/wx.DirDialog.html
    """
    def __init__(self, parent, message=DirSelectorPromptStr, defaultPath="", style=DD_DEFAULT_STYLE, pos=DefaultPosition, size=DefaultSize, name=DirDialogNameStr) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    def GetMessage(self) -> str:
        """ Returns the message that will be displayed on the dialog.

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    def GetPath(self) -> str:
        """ Returns the default or user-selected path.

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    def GetPaths(self, paths: list[str]) -> None:
        """ Fills the array paths  with the full paths of the chosen directories.

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    def SetMessage(self, message: str) -> None:
        """ Sets the message that will be displayed on the dialog.

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    def SetPath(self, path: str) -> None:
        """ Sets the default path.

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning wx.ID_OK if the user pressed wx.OK, and wx.ID_CANCEL otherwise.

            Source: https://docs.wxpython.org/wx.DirDialog.html
        """

    Message: str  # See GetMessage and SetMessage
    Path: str  # See GetPath and SetPath



DD_DEFAULT_STYLE: int  # Equivalent to a combination of wx.DEFAULT_DIALOG_STYLE and wx.RESIZE_BORDER.

DD_DIR_MUST_EXIST: int  # The dialog will allow the user to choose only an existing folder. When this style is not given, a âCreate new directoryâ button is added to the dialog (on Windows) or some other way is provided to the user to type the name of a new folder.

DD_CHANGE_DIR: int  # Change the current working directory to the directory chosen by the user. This flag cannot be used with the  DD_MULTIPLE   style.

DD_MULTIPLE: int  # Allow the user to select multiple directories. This flag is only available since wxWidgets 3.1.4

DD_SHOW_HIDDEN: int  # Show hidden and system folders. This flag is only available since wxWidgets 3.1.4 ^^

class DirFilterListCtrl(Choice):
    """  Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.DirFilterListCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DirFilterListCtrl.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0) -> bool:
        """ parent (wx.GenericDirCtrl) â

            Source: https://docs.wxpython.org/wx.DirFilterListCtrl.html
        """

    def FillFilterList(self, filter, defaultFilter) -> None:
        """ filter (string) â

            Source: https://docs.wxpython.org/wx.DirFilterListCtrl.html
        """

    def Init(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DirFilterListCtrl.html
        """



class DirPickerCtrl(PickerBase):
    """ This control allows the user to select a directory.

        Source: https://docs.wxpython.org/wx.DirPickerCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DirPickerCtrl.html
        """

    def Create(self, parent, id=ID_ANY, path="", message=DirSelectorPromptStr, pos=DefaultPosition, size=DefaultSize, style=DIRP_DEFAULT_STYLE, validator=DefaultValidator, name=DirPickerCtrlNameStr) -> bool:
        """ Creates the widgets with the given parameters.

            Source: https://docs.wxpython.org/wx.DirPickerCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.DirPickerCtrl.html
        """

    def GetPath(self) -> str:
        """ Returns the absolute path of the currently selected directory.

            Source: https://docs.wxpython.org/wx.DirPickerCtrl.html
        """

    def SetInitialDirectory(self, dir: str) -> None:
        """ Set the directory to show when starting to browse for directories.

            Source: https://docs.wxpython.org/wx.DirPickerCtrl.html
        """

    def SetPath(self, dirname: str) -> None:
        """ Sets the absolute path of the currently selected directory.

            Source: https://docs.wxpython.org/wx.DirPickerCtrl.html
        """

    Path: str  # See GetPath and SetPath



DIRP_DEFAULT_STYLE: int  # The default style: includes wx.DIRP_DIR_MUST_EXIST and, under wxMSW only, wx.DIRP_USE_TEXTCTRL.

DIRP_USE_TEXTCTRL: int  # Creates a text control to the left of the picker button which is completely managed by the   wx.DirPickerCtrl  and which can be used by the user to specify a path (see SetPath). The text control is automatically synchronized with buttonâs value. Use functions defined in   wx.PickerBase  to modify the text control.

DIRP_DIR_MUST_EXIST: int  # Creates a picker which allows selecting only existing directories in the popup   wx.DirDialog. Notice that, as with  FLP_FILE_MUST_EXIST , it is still possible to enter a non-existent directory even when this file is specified if   DIRP_USE_TEXTCTRL   style is also used. Also note that if   DIRP_USE_TEXTCTRL   is not used, the native wxGTK implementation always uses this style as it doesnât support selecting non-existent directories.

DIRP_CHANGE_DIR: int  # Change current working directory on each user directory selection change.

DIRP_SMALL: int  # Use smaller version of the control with a small ââ¦â button instead of the normal âBrowseâ one. This flag is new since wxWidgets 2.9.3. ^^

EVT_DIRPICKER_CHANGED: int  # The user changed the directory selected in the control either using the button or using text control (see wx.DIRP_USE_TEXTCTRL; note that in this case the event is fired only if the userâs input is valid, e.g. an existing directory path). ^^

class Display:
    """ Determines the sizes and locations of displays connected to the
system.

        Source: https://docs.wxpython.org/wx.Display.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def ChangeMode(self, mode: 'VideoMode'=DefaultVideoMode) -> bool:
        """ Changes the video mode of this display to the mode specified in the mode parameter.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def GetClientArea(self) -> 'Rect':
        """ Returns the client area of the display.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    @staticmethod
    def GetCount() -> int:
        """ Returns the number of connected displays.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def GetCurrentMode(self) -> 'VideoMode':
        """ Returns the current video mode that this display is in.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    @staticmethod
    def GetFromPoint(pt: Union[tuple[int, int], 'Point']) -> int:
        """ Returns the index of the display on which the given point lies, or  NOT_FOUND   if the point is not on any connected display.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    @staticmethod
    def GetFromWindow(win: 'Window') -> int:
        """ Returns the index of the display on which the given window lies.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def GetGeometry(self) -> 'Rect':
        """ Returns the bounding rectangle of the display whose index was passed to the constructor.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def GetModes(self, mode: 'VideoMode'=DefaultVideoMode) -> 'ArrayVideoModes':
        """ Fills and returns an array with all the video modes that are supported by this display, or video modes that are supported by this display and match the mode parameter (if mode is not DefaultVideoMode).

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def GetName(self) -> str:
        """ Returns the displayâs name.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def GetPPI(self) -> 'Size':
        """ Returns display resolution in pixels per inch.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def GetScaleFactor(self) -> float:
        """ Returns scaling factor used by this display.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    @staticmethod
    def GetStdPPI() -> 'Size':
        """ Returns default display resolution for the current platform as   wx.Size.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    @staticmethod
    def GetStdPPIValue() -> int:
        """ Returns default display resolution for the current platform in pixels per inch.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    def IsPrimary(self) -> bool:
        """ Returns True if the display is the primary display.

            Source: https://docs.wxpython.org/wx.Display.html
        """

    ClientArea: 'Rect'  # See GetClientArea
    CurrentMode: 'VideoMode'  # See GetCurrentMode
    Geometry: 'Rect'  # See GetGeometry
    Name: str  # See GetName



class DisplayChangedEvent(Event):
    """ A display changed event is sent to top-level windows when the display
resolution has changed.

        Source: https://docs.wxpython.org/wx.DisplayChangedEvent.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.DisplayChangedEvent.html
        """



EVT_DISPLAY_CHANGED: int  # Process a  wxEVT_DISPLAY_CHANGED   event. ^^

class DPIChangedEvent(Event):
    """ Event sent when the display scale factor or pixel density (measured in
dots-per-inch, or DPI) of the monitor a window is on changes.

        Source: https://docs.wxpython.org/wx.DPIChangedEvent.html
    """
    def GetNewDPI(self) -> 'Size':
        """ Returns the new DPI.

            Source: https://docs.wxpython.org/wx.DPIChangedEvent.html
        """

    def GetOldDPI(self) -> 'Size':
        """ Returns the old DPI.

            Source: https://docs.wxpython.org/wx.DPIChangedEvent.html
        """

    def Scale(self, sz: Union[tuple[int, int], 'Size']) -> 'Size':
        """ Rescale a value in pixels to match the new DPI.

            Source: https://docs.wxpython.org/wx.DPIChangedEvent.html
        """

    def ScaleX(self, x: int) -> int:
        """ Rescale horizontal component to match the new DPI.

            Source: https://docs.wxpython.org/wx.DPIChangedEvent.html
        """

    def ScaleY(self, y: int) -> int:
        """ Rescale vertical component to match the new DPI.

            Source: https://docs.wxpython.org/wx.DPIChangedEvent.html
        """

    NewDPI: 'Size'  # See GetNewDPI
    OldDPI: 'Size'  # See GetOldDPI



EVT_DPI_CHANGED: int  # Process a  wxEVT_DPI_CHANGED   event. ^^

class DragImage(Object):
    """ This class is used when you wish to drag an object on the screen, and
a simple cursor is not enough.

        Source: https://docs.wxpython.org/wx.DragImage.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DragImage.html
        """

    def BeginDrag(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DragImage.html
        """

    def EndDrag(self) -> bool:
        """ Call this when the drag has finished.

            Source: https://docs.wxpython.org/wx.DragImage.html
        """

    def Hide(self) -> bool:
        """ Hides the image.

            Source: https://docs.wxpython.org/wx.DragImage.html
        """

    def Move(self, pt: Union[tuple[int, int], 'Point']) -> bool:
        """ Call this to move the image to a new position.

            Source: https://docs.wxpython.org/wx.DragImage.html
        """

    def Show(self) -> bool:
        """ Shows the image.

            Source: https://docs.wxpython.org/wx.DragImage.html
        """



class DropFilesEvent(Event):
    """ This class is used for drop files events, that is, when files have
been dropped onto the window.

        Source: https://docs.wxpython.org/wx.DropFilesEvent.html
    """
    def __init__(self, id=0, files=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.DropFilesEvent.html
        """

    def GetFiles(self) -> Any:
        """ Returns an array of filenames.

            Source: https://docs.wxpython.org/wx.DropFilesEvent.html
        """

    def GetNumberOfFiles(self) -> int:
        """ Returns the number of files dropped.

            Source: https://docs.wxpython.org/wx.DropFilesEvent.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the position at which the files were dropped.

            Source: https://docs.wxpython.org/wx.DropFilesEvent.html
        """

    Files: Any  # See GetFiles
    NumberOfFiles: int  # See GetNumberOfFiles
    Position: 'Point'  # See GetPosition



_DataObject: TypeAlias = DataObject

class DropSource:
    """ This class represents a source for a drag and drop operation.

        Source: https://docs.wxpython.org/wx.DropSource.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.DropSource.html
        """

    def DoDragDrop(self, flags: int=Drag_CopyOnly) -> 'DragResult':
        """ Starts the drag-and-drop operation which will terminate when the user releases the mouse.

            Source: https://docs.wxpython.org/wx.DropSource.html
        """

    def GetDataObject(self) -> 'DataObject':
        """ Returns the   wx.DataObject  object that has been assigned previously.

            Source: https://docs.wxpython.org/wx.DropSource.html
        """

    def GiveFeedback(self, effect: DragResult) -> bool:
        """ You may give some custom UI feedback during the drag and drop operation by overriding this function.

            Source: https://docs.wxpython.org/wx.DropSource.html
        """

    def SetCursor(self, res, cursor) -> None:
        """ Set the icon to use for a certain drag result.

            Source: https://docs.wxpython.org/wx.DropSource.html
        """

    def SetData(self, data: 'DataObject') -> None:
        """ Sets the data   wx.DataObject  associated with the drop source.

            Source: https://docs.wxpython.org/wx.DropSource.html
        """

    def SetIcon(self, res, icon) -> None:
        """ Set the icon to use for a certain drag result.

            Source: https://docs.wxpython.org/wx.DropSource.html
        """

    DataObject: '_DataObject'  # See GetDataObject



class DropTarget:
    """ This class represents a target for a drag and drop operation.

        Source: https://docs.wxpython.org/wx.DropTarget.html
    """
    def __init__(self, data: Optional['DataObject']=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def GetData(self) -> bool:
        """ This method may only be called from within OnData .

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def GetDataObject(self) -> 'DataObject':
        """ Returns the data   wx.DataObject  associated with the drop target.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def GetDefaultAction(self) -> 'DragResult':
        """ Returns default action for drag and drop or DragNone if this not specified.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def OnData(self, x, y, defResult) -> 'DragResult':
        """ Called after OnDrop   returns True.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def OnDragOver(self, x, y, defResult) -> 'DragResult':
        """ Called when the mouse is being dragged over the drop target.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def OnDrop(self, x, y) -> bool:
        """ Called when the user drops a data object on the target.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def OnEnter(self, x, y, defResult) -> 'DragResult':
        """ Called when the mouse enters the drop target.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def OnLeave(self) -> None:
        """ Called when the mouse leaves the drop target.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def SetDataObject(self, data: 'DataObject') -> None:
        """ Sets the data   wx.DataObject  associated with the drop target and deletes any previously associated data object.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    def SetDefaultAction(self, action: DragResult) -> None:
        """ Sets the default action for drag and drop.

            Source: https://docs.wxpython.org/wx.DropTarget.html
        """

    Data: bool  # See GetData
    DataObject: '_DataObject'  # See GetDataObject and SetDataObject
    DefaultAction: 'DragResult'  # See GetDefaultAction and SetDefaultAction



_DC: TypeAlias = DC

class EraseEvent(Event):
    """ An erase event is sent when a windowâs background needs to be
repainted.

        Source: https://docs.wxpython.org/wx.EraseEvent.html
    """
    def __init__(self, id=0, dc=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.EraseEvent.html
        """

    def GetDC(self) -> 'DC':
        """ Returns the device context associated with the erase event to draw on.

            Source: https://docs.wxpython.org/wx.EraseEvent.html
        """

    DC: '_DC'  # See GetDC



class Event(Object):
    """ An event is a structure holding information about an event passed to a
callback or member function.

        Source: https://docs.wxpython.org/wx.Event.html
    """
    def __init__(self, id=0, eventType=wxEVT_NULL) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def Clone(self) -> 'Event':
        """ Returns a copy of the event.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def GetEventCategory(self) -> int:
        """ Returns a generic category for this event.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def GetEventObject(self) -> 'Window':
        """ Returns the object (usually a window) associated with the event, if any.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def GetEventType(self) -> int:
        """ Returns the identifier of the given event type, such as  wxEVT_BUTTON .

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def GetId(self) -> int:
        """ Returns the identifier associated with this event, such as a button command id.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def GetSkipped(self) -> bool:
        """ Returns True if the event handler should be skipped, False otherwise.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def GetTimestamp(self) -> int:
        """ Gets the timestamp for the event.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def IsCommandEvent(self) -> bool:
        """ Returns True if the event is or is derived from   wx.CommandEvent  else it returns False.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def ResumePropagation(self, propagationLevel: int) -> None:
        """ Sets the propagation level to the given value (for example returned from an earlier call to wx.Event.StopPropagation ).

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def SetEventObject(self, object: 'Object') -> None:
        """ Sets the originating object.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def SetEventType(self, type: int) -> None:
        """ Sets the event type.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def SetId(self, id: int) -> None:
        """ Sets the identifier associated with this event, such as a button command id.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def SetTimestamp(self, timeStamp: int=0) -> None:
        """ Sets the timestamp for the event.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def ShouldPropagate(self) -> bool:
        """ Test if this event should be propagated or not, i.e. if the propagation level is currently greater than 0.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def Skip(self, skip: bool=True) -> None:
        """ This method can be used inside an event handler to control whether further event handlers bound to this event will be called after the current one returns.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    def StopPropagation(self) -> int:
        """ Stop the event from propagating to its parent window.

            Source: https://docs.wxpython.org/wx.Event.html
        """

    EventObject: 'Window'  # See GetEventObject and SetEventObject
    EventType: int  # See GetEventType and SetEventType
    Id: int  # See GetId and SetId
    Skipped: bool  # See GetSkipped
    Timestamp: int  # See GetTimestamp and SetTimestamp



class EventBlocker(EvtHandler):
    """ This class is a special event handler which allows discarding any
event (or a set of event types) directed to a specific window.

        Source: https://docs.wxpython.org/wx.EventBlocker.html
    """
    def __init__(self, win, type=-1) -> None:
        """ Constructs the blocker for the given window and for the given event type.

            Source: https://docs.wxpython.org/wx.EventBlocker.html
        """

    def Block(self, eventType: int) -> None:
        """ Adds to the list of event types which should be blocked the given eventType.

            Source: https://docs.wxpython.org/wx.EventBlocker.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.EventBlocker.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.EventBlocker.html
        """



class EventFilter:
    """ A global event filter for pre-processing all the events generated in
the program.

        Source: https://docs.wxpython.org/wx.EventFilter.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.EventFilter.html
        """

    def FilterEvent(self, event: 'Event') -> int:
        """ Override this method to implement event pre-processing.

            Source: https://docs.wxpython.org/wx.EventFilter.html
        """



class EventLoopActivator:
    """ Makes an event loop temporarily active.

        Source: https://docs.wxpython.org/wx.EventLoopActivator.html
    """
    def __init__(self, loop: 'EventLoopBase') -> None:
        """ Makes the loop passed as the parameter currently active.

            Source: https://docs.wxpython.org/wx.EventLoopActivator.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.EventLoopActivator.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.EventLoopActivator.html
        """



class EventLoopBase:
    """ Base class for all event loop implementations.

        Source: https://docs.wxpython.org/wx.EventLoopBase.html
    """
    def Dispatch(self) -> bool:
        """ Dispatches the next event in the windowing system event queue.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def DispatchTimeout(self, timeout: int) -> int:
        """ Dispatch an event but not wait longer than the specified timeout for it.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def Exit(self, rc: int=0) -> None:
        """ Exit the currently running loop with the given exit code.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    @staticmethod
    def GetActive() -> 'EventLoopBase':
        """ Return the currently active (running) event loop.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def IsEventAllowedInsideYield(self, cat: int) -> bool:
        """ Returns True if the given event category is allowed inside a YieldFor   call (i.e.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def IsMain(self) -> bool:
        """ Returns True if this is the main loop executed by wx.App.OnRun .

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def IsOk(self) -> bool:
        """ Use this to check whether the event loop was successfully created before using it.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def IsRunning(self) -> bool:
        """ Return True if this event loop is currently running.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def IsYielding(self) -> bool:
        """ Returns True if called from inside wx.Yield       or from inside YieldFor .

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def OnExit(self) -> None:
        """ This function is called before the event loop terminates, whether this happens normally (because of wx.Exit       call) or abnormally (because of an exception thrown from inside the loop).

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def Pending(self) -> bool:
        """ Return True if any events are available.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def ProcessIdle(self) -> bool:
        """ This virtual function is called when the application becomes idle and normally just sends   wx.IdleEvent  to all interested parties.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def Run(self) -> int:
        """ Start the event loop, return the exit code when it is finished.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def ScheduleExit(self, rc: int=0) -> None:
        """ Schedule an exit from the loop with the given exit code.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    @staticmethod
    def SetActive(loop: 'EventLoopBase') -> None:
        """ Set currently active (running) event loop.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def WakeUp(self) -> None:
        """ Called by wxWidgets to wake up the event loop even if it is currently blocked inside Dispatch .

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def WakeUpIdle(self) -> None:
        """ Makes sure that idle events are sent again.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def Yield(self, onlyIfNeeded: bool=False) -> bool:
        """ Yields control to pending messages in the windowing system.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """

    def YieldFor(self, eventsToProcess: int) -> bool:
        """ Works like wx.Yield       with onlyIfNeeded  == True, except that it allows the caller to specify a mask of the   wx.EventCategory  values which indicates which events should be processed and which should instead be âdelayedâ (i.e.

            Source: https://docs.wxpython.org/wx.EventLoopBase.html
        """



class EvtHandler(Object,Trackable):
    """ A class that can handle events from the windowing system.

        Source: https://docs.wxpython.org/wx.EvtHandler.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    @staticmethod
    def AddFilter(filter: 'EventFilter') -> None:
        """ Add an event filter whose FilterEvent() method will be called for each and every event processed by wxWidgets.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def AddPendingEvent(self, event: 'Event') -> None:
        """ Post an event to be processed later.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def Bind(self, event, handler, source=None, id=wx.ID_ANY, id2=wx.ID_ANY) -> None:
        """ Bind an event to an event handler.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def Connect(self, id, lastId, eventType, func) -> None:
        """ Make an entry in the dynamic event table for an event binding.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def DeletePendingEvents(self) -> None:
        """ Deletes all events queued on this event handler using wx.QueueEvent       or AddPendingEvent .

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def Disconnect(self, id, lastId=-1, eventType=wxEVT_NULL, func=None) -> bool:
        """ Remove an event binding by removing its entry in the dynamic event table.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def GetEvtHandlerEnabled(self) -> bool:
        """ Returns True if the event handler is enabled, False otherwise.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def GetNextHandler(self) -> 'EvtHandler':
        """ Returns the pointer to the next handler in the chain.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def GetPreviousHandler(self) -> 'EvtHandler':
        """ Returns the pointer to the previous handler in the chain.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def IsUnlinked(self) -> bool:
        """ Returns True if the next and the previous handler pointers of this event handler instance are None.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def ProcessEvent(self, event: 'Event') -> bool:
        """ Processes an event, searching event tables and calling zero or more suitable event handler function(s).

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def ProcessEventLocally(self, event: 'Event') -> bool:
        """ Try to process the event in this handler and all those chained to it.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def ProcessPendingEvents(self) -> None:
        """ Processes the pending events previously queued using wx.QueueEvent       or AddPendingEvent ; you must call this function only if you are sure there are pending events for this handler, otherwise a  CHECK   will fail.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def QueueEvent(self, event: 'Event') -> None:
        """ Queue event for a later processing.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    @staticmethod
    def RemoveFilter(filter: 'EventFilter') -> None:
        """ Remove a filter previously installed with AddFilter .

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def SafelyProcessEvent(self, event: 'Event') -> bool:
        """ Processes an event by calling   wx.ProcessEvent  and handles any exceptions that occur in the process.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def SetEvtHandlerEnabled(self, enabled: bool) -> None:
        """ Enables or disables the event handler.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def SetNextHandler(self, handler: 'EvtHandler') -> None:
        """ Sets the pointer to the next handler.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def SetPreviousHandler(self, handler: 'EvtHandler') -> None:
        """ Sets the pointer to the previous handler.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def TryAfter(self, event: 'Event') -> bool:
        """ Method called by   wx.ProcessEvent  as last resort.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def TryBefore(self, event: 'Event') -> bool:
        """ Method called by   wx.ProcessEvent  before examining this object event tables.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def Unbind(self, event, source=None, id=wx.ID_ANY, id2=wx.ID_ANY, handler=None) -> None:
        """ Disconnects the event handler binding for event from self.
Returns True if successful.

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    def Unlink(self) -> None:
        """ Unlinks this event handler from the chain itâs part of (if any); then links the âpreviousâ event handler to the ânextâ one (so that the chain wonât be interrupted).

            Source: https://docs.wxpython.org/wx.EvtHandler.html
        """

    EvtHandlerEnabled: bool  # See GetEvtHandlerEnabled and SetEvtHandlerEnabled
    NextHandler: 'EvtHandler'  # See GetNextHandler and SetNextHandler
    PreviousHandler: 'EvtHandler'  # See GetPreviousHandler and SetPreviousHandler



class FileConfig(ConfigBase):
    """ FileConfig implements ConfigBase interface for storing and
retrieving configuration information using plain text files.

        Source: https://docs.wxpython.org/wx.FileConfig.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def DeleteAll(self) -> bool:
        """ Delete the whole underlying object (disk file, registry key, â¦).

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def DeleteEntry(self, key, bDeleteGroupIfEmpty=True) -> bool:
        """ Deletes the specified entry and the group it belongs to if it was the last key in it and the second parameter is True.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def DeleteGroup(self, key: str) -> bool:
        """ Delete the group (with all subgroups).

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def DisableAutoSave(self) -> None:
        """ Prevent this object from saving data to the disk file when it is destroyed.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def EnableAutoSave(self) -> None:
        """ Enables saving data to the disk file when this object is destroyed.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def Flush(self, bCurrentOnly: bool=False) -> bool:
        """ Permanently writes all changes (otherwise, theyâre only written from objectâs destructor).

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    @staticmethod
    def GetGlobalFileName(szFile: str) -> str:
        """ szFile (string) â

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    @staticmethod
    def GetLocalFileName(szFile, style=0) -> str:
        """ szFile (string) â

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def GetNumberOfEntries(self, bRecursive: bool=False) -> int:
        """ Get number of entries in the current group.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def GetNumberOfGroups(self, bRecursive: bool=False) -> int:
        """ Get number of entries/subgroups in the current group, with or without its subgroups.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def GetPath(self) -> str:
        """ Retrieve the current path (always as absolute path).

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def HasEntry(self, strName: str) -> bool:
        """ strName (string) â

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def HasGroup(self, strName: str) -> bool:
        """ strName (string) â

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def RenameEntry(self, oldName, newName) -> bool:
        """ Renames an entry in the current group.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def RenameGroup(self, oldName, newName) -> bool:
        """ Renames a subgroup of the current group.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def Save(self, os) -> bool:
        """ Saves all config data to the given stream, returns True if data was saved successfully or False on error.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def SetPath(self, strPath: str) -> None:
        """ Set current path: if the first character is â/â, it is the absolute path, otherwise it is a relative path.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    def SetUmask(self, mode: int) -> None:
        """ Allows setting the mode to be used for the config file creation.

            Source: https://docs.wxpython.org/wx.FileConfig.html
        """

    NumberOfEntries: int  # See GetNumberOfEntries
    NumberOfGroups: int  # See GetNumberOfGroups
    Path: str  # See GetPath and SetPath



class FileCtrl(Control):
    """ This control allows the user to select a file.

        Source: https://docs.wxpython.org/wx.FileCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def Create(self, parent, id=ID_ANY, defaultDirectory="", defaultFilename="", wildCard=FileSelectorDefaultWildcardStr, style=FC_DEFAULT_STYLE, pos=DefaultPosition, size=DefaultSize, name=FileCtrlNameStr) -> bool:
        """ Create function for two-step construction.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def GetDirectory(self) -> str:
        """ Returns the current directory of the file control (i.e. the directory shown by it).

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def GetFilename(self) -> str:
        """ Returns the currently selected filename.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def GetFilenames(self) -> list[str]:
        """ Returns a list of filenames selected in the control.  This function
should only be used with controls which have the wx.``wx.FC_MULTIPLE`` style,
use GetFilename for the others.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def GetFilterIndex(self) -> int:
        """ Returns the zero-based index of the currently selected filter.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def GetPath(self) -> str:
        """ Returns the full path (directory and filename) of the currently selected file.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def GetPaths(self) -> list[str]:
        """ Returns a list of the full paths (directory and filename) of the files
chosen. This function should only be used with controlss which have
the wx.``wx.FC_MULTIPLE`` style, use GetPath for the others.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def GetWildcard(self) -> str:
        """ Returns the current wildcard.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def SetDirectory(self, directory: str) -> bool:
        """ Sets(changes) the current directory displayed in the control.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def SetFilename(self, filename: str) -> bool:
        """ Selects a certain file.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def SetFilterIndex(self, filterIndex: int) -> None:
        """ Sets the current filter index, starting from zero.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def SetPath(self, path: str) -> bool:
        """ Changes to a certain directory and selects a certain file.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def SetWildcard(self, wildCard: str) -> None:
        """ Sets the wildcard, which can contain multiple file types, for example: âBMP files (.bmp)|.bmp|GIF files (.gif)|.gifâ.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    def ShowHidden(self, show: bool) -> None:
        """ Sets whether hidden files and folders are shown or not.

            Source: https://docs.wxpython.org/wx.FileCtrl.html
        """

    Directory: str  # See GetDirectory and SetDirectory
    Filename: str  # See GetFilename and SetFilename
    Filenames: list[str]  # See GetFilenames
    FilterIndex: int  # See GetFilterIndex and SetFilterIndex
    Path: str  # See GetPath and SetPath
    Paths: list[str]  # See GetPaths
    Wildcard: str  # See GetWildcard and SetWildcard



FC_DEFAULT_STYLE: int  # The default style: wx.FC_OPEN

FC_OPEN: int  # Creates an file control suitable for opening files. Cannot be combined with wx.FC_SAVE.

FC_SAVE: int  # Creates an file control suitable for saving files. Cannot be combined with wx.FC_OPEN.

FC_MULTIPLE: int  # For open control only, Allows selecting multiple files. Cannot be combined with wx.FC_SAVE

FC_NOSHOWHIDDEN: int  # Hides the âShow Hidden Filesâ checkbox (Generic only) ^^

EVT_FILECTRL_FILEACTIVATED: int  # The user activated a file(by double-clicking or pressing Enter)

EVT_FILECTRL_SELECTIONCHANGED: int  # The user changed the current selection(by selecting or deselecting a file)

EVT_FILECTRL_FOLDERCHANGED: int  # The current folder of the file control has been changed

EVT_FILECTRL_FILTERCHANGED: int  # The current file filter of the file control has been changed.

class FileCtrlEvent(CommandEvent):
    """ A file control event holds information about events associated with
FileCtrl objects.

        Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
    """
    def __init__(self, type, evtObject, id) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    def GetDirectory(self) -> str:
        """ Returns the current directory.

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    def GetFile(self) -> str:
        """ Returns the file selected (assuming it is only one file).

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    def GetFiles(self) -> list[str]:
        """ Returns the files selected.

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    def GetFilterIndex(self) -> int:
        """ Returns the current file filter index.

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    def SetDirectory(self, directory: str) -> None:
        """ Sets the directory of this event.

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    def SetFiles(self, files: list[str]) -> None:
        """ Sets the files changed by this event.

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    def SetFilterIndex(self, index: int) -> None:
        """ Sets the filter index changed by this event.

            Source: https://docs.wxpython.org/wx.FileCtrlEvent.html
        """

    Directory: str  # See GetDirectory and SetDirectory
    File: str  # See GetFile
    Files: list[str]  # See GetFiles and SetFiles
    FilterIndex: int  # See GetFilterIndex and SetFilterIndex



class FileDataObject(DataObjectSimple):
    """ FileDataObject is a specialization of DataObject for file names.

        Source: https://docs.wxpython.org/wx.FileDataObject.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FileDataObject.html
        """

    def AddFile(self, file: str) -> None:
        """ Adds a file to the file list represented by this data object (Windows only).

            Source: https://docs.wxpython.org/wx.FileDataObject.html
        """

    def GetAllFormats(self, dir=DataObject.Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.FileDataObject.html
        """

    def GetFilenames(self) -> list[str]:
        """ Returns the array of file names.

            Source: https://docs.wxpython.org/wx.FileDataObject.html
        """

    def SetData(self, format, buf) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.FileDataObject.html
        """

    AllFormats: None  # See GetAllFormats
    Filenames: list[str]  # See GetFilenames



class FileDialog(Dialog):
    """ This class represents the file chooser dialog.

        Source: https://docs.wxpython.org/wx.FileDialog.html
    """
    def __init__(self, parent, message=FileSelectorPromptStr, defaultDir="", defaultFile="", wildcard=FileSelectorDefaultWildcardStr, style=FD_DEFAULT_STYLE, pos=DefaultPosition, size=DefaultSize, name=FileDialogNameStr) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def AddShortcut(self, directory, flags=0) -> bool:
        """ Add a directory to the list of shortcuts shown in the dialog.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetCurrentlySelectedFilename(self) -> str:
        """ Returns the path of the file currently selected in dialog.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetCurrentlySelectedFilterIndex(self) -> int:
        """ Returns the file type filter index currently selected in dialog.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetDirectory(self) -> str:
        """ Returns the default directory.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetExtraControl(self) -> 'Window':
        """ If functions SetExtraControlCreator   and ShowModal   were called, returns the extra window.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetFilename(self) -> str:
        """ Returns the default filename.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetFilenames(self) -> list[str]:
        """ Returns a list of filenames chosen in the dialog.  This function
should only be used with the dialogs which have wx.``MULTIPLE`` style,
use GetFilename for the others.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetFilterIndex(self) -> int:
        """ Returns the index into the list of filters supplied, optionally, in the wildcard parameter.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetMessage(self) -> str:
        """ Returns the message that will be displayed on the dialog.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetPath(self) -> str:
        """ Returns the full path (directory and filename) of the selected file.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetPaths(self) -> list[str]:
        """ Returns a list of the full paths of the files chosen. This function
should only be used with the dialogs which have wx.``MULTIPLE`` style, use
GetPath for the others.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def GetWildcard(self) -> str:
        """ Returns the file dialog wildcard.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def SetCustomizeHook(self, customizeHook: 'FileDialogCustomizeHook') -> bool:
        """ Set the hook to be used for customizing the dialog contents.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def SetDirectory(self, directory: str) -> None:
        """ Sets the default directory.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def SetFilename(self, setfilename: str) -> None:
        """ Sets the default filename.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def SetFilterIndex(self, filterIndex: int) -> None:
        """ Sets the default filter index, starting from zero.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def SetMessage(self, message: str) -> None:
        """ Sets the message that will be displayed on the dialog.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def SetPath(self, path: str) -> None:
        """ Sets the path (the combined directory and filename that will be returned when the dialog is dismissed).

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def SetWildcard(self, wildCard: str) -> None:
        """ Sets the wildcard, which can contain multiple file types, for example: âBMP files (.bmp)|.bmp|GIF files (.gif)|.gifâ.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning  ID_OK   if the user pressed wx.OK, and   ID_CANCEL   otherwise.

            Source: https://docs.wxpython.org/wx.FileDialog.html
        """

    CurrentlySelectedFilename: str  # See GetCurrentlySelectedFilename
    CurrentlySelectedFilterIndex: int  # See GetCurrentlySelectedFilterIndex
    Directory: str  # See GetDirectory and SetDirectory
    ExtraControl: 'Window'  # See GetExtraControl
    Filename: str  # See GetFilename and SetFilename
    Filenames: list[str]  # See GetFilenames
    FilterIndex: int  # See GetFilterIndex and SetFilterIndex
    Message: str  # See GetMessage and SetMessage
    Path: str  # See GetPath and SetPath
    Paths: list[str]  # See GetPaths
    Wildcard: str  # See GetWildcard and SetWildcard



FD_DEFAULT_STYLE: int  # Equivalent to  FD_OPEN .

FD_NO_FOLLOW: int  # Directs the dialog to return the path and file name of the selected shortcut file, not its target as it does by default. Currently this flag is only implemented in wxMSW and wxOSX (where it prevents aliases from being resolved). The non-dereferenced link path is always returned, even without this flag, under Unix and so using it there doesnât do anything. This flag was added in wxWidgets 3.1.0.

FD_CHANGE_DIR: int  # Change the current working directory (when the dialog is dismissed) to the directory where the file(s) chosen by the user are.

FD_PREVIEW: int  # Show the preview of the selected files (currently only supported by wxGTK).

FD_SHOW_HIDDEN: int  # Show hidden files. This flag was added in wxWidgets 3.1.3 ^^

class FileDialogButton(FileDialogCustomControl):
    """ Represents a custom button inside FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogButton.html
    """


class FileDialogCheckBox(FileDialogCustomControl):
    """ Represents a custom checkbox inside FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogCheckBox.html
    """
    def GetValue(self) -> bool:
        """ Return True if the checkbox is checked.

            Source: https://docs.wxpython.org/wx.FileDialogCheckBox.html
        """

    def SetValue(self, value: bool) -> None:
        """ Check or uncheck the checkbox.

            Source: https://docs.wxpython.org/wx.FileDialogCheckBox.html
        """

    Value: bool  # See GetValue and SetValue



class FileDialogChoice(FileDialogCustomControl):
    """ Represents a custom read-only combobox inside FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogChoice.html
    """
    def GetSelection(self) -> int:
        """ Return the index of the selected item, possibly wx.NOT_FOUND.

            Source: https://docs.wxpython.org/wx.FileDialogChoice.html
        """

    def SetSelection(self, n: int) -> None:
        """ Set the selection to the item with the given index.

            Source: https://docs.wxpython.org/wx.FileDialogChoice.html
        """

    Selection: int  # See GetSelection and SetSelection



class FileDialogCustomControl(EvtHandler):
    """ The base class for all FileDialog custom controls.

        Source: https://docs.wxpython.org/wx.FileDialogCustomControl.html
    """
    def Disable(self) -> None:
        """ Disable this control.

            Source: https://docs.wxpython.org/wx.FileDialogCustomControl.html
        """

    def Enable(self, enable: bool=True) -> None:
        """ Enable or disable this control.

            Source: https://docs.wxpython.org/wx.FileDialogCustomControl.html
        """

    def Hide(self) -> None:
        """ Hide this control.

            Source: https://docs.wxpython.org/wx.FileDialogCustomControl.html
        """

    def Show(self, show: bool=True) -> None:
        """ Show or hide this control.

            Source: https://docs.wxpython.org/wx.FileDialogCustomControl.html
        """



class FileDialogCustomize:
    """ Used with FileDialogCustomizeHook to add custom controls to
FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogCustomize.html
    """
    def AddButton(self, label: str) -> 'FileDialogButton':
        """ Add a button with the specified label.

            Source: https://docs.wxpython.org/wx.FileDialogCustomize.html
        """

    def AddCheckBox(self, label: str) -> 'FileDialogCheckBox':
        """ Add a checkbox with the specified label.

            Source: https://docs.wxpython.org/wx.FileDialogCustomize.html
        """

    def AddChoice(self, strings: list[str]) -> 'FileDialogChoice':
        """ Add a read-only combobox with the specified contents.

            Source: https://docs.wxpython.org/wx.FileDialogCustomize.html
        """

    def AddRadioButton(self, label: str) -> 'FileDialogRadioButton':
        """ Add a radio button with the specified label.

            Source: https://docs.wxpython.org/wx.FileDialogCustomize.html
        """

    def AddStaticText(self, label: str) -> 'FileDialogStaticText':
        """ Add a static text with the given contents.

            Source: https://docs.wxpython.org/wx.FileDialogCustomize.html
        """

    def AddTextCtrl(self, label: str="") -> 'FileDialogTextCtrl':
        """ Add a text control with an optional label preceding it.

            Source: https://docs.wxpython.org/wx.FileDialogCustomize.html
        """



class FileDialogCustomizeHook:
    """ Base class for customization hooks used with FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogCustomizeHook.html
    """
    def AddCustomControls(self, customizer: 'FileDialogCustomize') -> None:
        """ Must be overridden to add custom controls to the dialog using the provided customizer object.

            Source: https://docs.wxpython.org/wx.FileDialogCustomizeHook.html
        """

    def TransferDataFromCustomControls(self) -> None:
        """ Should typically be overridden to save the values of the custom controls when the dialog is accepted.

            Source: https://docs.wxpython.org/wx.FileDialogCustomizeHook.html
        """

    def UpdateCustomControls(self) -> None:
        """ May be overridden to update the custom controls whenever something changes in the dialog.

            Source: https://docs.wxpython.org/wx.FileDialogCustomizeHook.html
        """



class FileDialogRadioButton(FileDialogCustomControl):
    """ Represents a custom radio button inside FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogRadioButton.html
    """
    def GetValue(self) -> bool:
        """ Return True if the radio button is selected.

            Source: https://docs.wxpython.org/wx.FileDialogRadioButton.html
        """

    def SetValue(self, value: bool) -> None:
        """ Select the value of the radio button.

            Source: https://docs.wxpython.org/wx.FileDialogRadioButton.html
        """

    Value: bool  # See GetValue and SetValue



class FileDialogStaticText(FileDialogCustomControl):
    """ Represents a custom static text inside FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogStaticText.html
    """
    def SetLabelText(self, text: str) -> None:
        """ Set the text shown in the label.

            Source: https://docs.wxpython.org/wx.FileDialogStaticText.html
        """



class FileDialogTextCtrl(FileDialogCustomControl):
    """ Represents a custom text control inside FileDialog.

        Source: https://docs.wxpython.org/wx.FileDialogTextCtrl.html
    """
    def GetValue(self) -> str:
        """ Get the current value entered into the control.

            Source: https://docs.wxpython.org/wx.FileDialogTextCtrl.html
        """

    def SetValue(self, text: str) -> None:
        """ Set the current control value.

            Source: https://docs.wxpython.org/wx.FileDialogTextCtrl.html
        """

    Value: str  # See GetValue and SetValue



class FileDirPickerEvent(CommandEvent):
    """ This event class is used for the events generated by FilePickerCtrl
and by DirPickerCtrl.

        Source: https://docs.wxpython.org/wx.FileDirPickerEvent.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FileDirPickerEvent.html
        """

    def GetPath(self) -> str:
        """ Retrieve the absolute path of the file/directory the user has just selected.

            Source: https://docs.wxpython.org/wx.FileDirPickerEvent.html
        """

    def SetPath(self, path: str) -> None:
        """ Set the absolute path of the file/directory associated with the event.

            Source: https://docs.wxpython.org/wx.FileDirPickerEvent.html
        """

    Path: str  # See GetPath and SetPath



EVT_FILEPICKER_CHANGED: int  # Generated whenever the selected file changes.

class FilePickerCtrl(PickerBase):
    """ This control allows the user to select a file.

        Source: https://docs.wxpython.org/wx.FilePickerCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FilePickerCtrl.html
        """

    def Create(self, parent, id=ID_ANY, path="", message=FileSelectorPromptStr, wildcard=FileSelectorDefaultWildcardStr, pos=DefaultPosition, size=DefaultSize, style=FLP_DEFAULT_STYLE, validator=DefaultValidator, name=FilePickerCtrlNameStr) -> bool:
        """ Creates this widget with the given parameters.

            Source: https://docs.wxpython.org/wx.FilePickerCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.FilePickerCtrl.html
        """

    def GetPath(self) -> str:
        """ Returns the absolute path of the currently selected file.

            Source: https://docs.wxpython.org/wx.FilePickerCtrl.html
        """

    def SetInitialDirectory(self, dir: str) -> None:
        """ Set the directory to show when starting to browse for files.

            Source: https://docs.wxpython.org/wx.FilePickerCtrl.html
        """

    def SetPath(self, filename: str) -> None:
        """ Sets the absolute path of the currently selected file.

            Source: https://docs.wxpython.org/wx.FilePickerCtrl.html
        """

    Path: str  # See GetPath and SetPath



FLP_DEFAULT_STYLE: int  # The default style: includes wx.FLP_OPEN | wx.FLP_FILE_MUST_EXIST and, under wxMSW and wxOSX, wx.FLP_USE_TEXTCTRL.

FLP_USE_TEXTCTRL: int  # Creates a text control to the left of the picker button which is completely managed by the   wx.FilePickerCtrl  and which can be used by the user to specify a path (see SetPath). The text control is automatically synchronized with buttonâs value. Use functions defined in   wx.PickerBase  to modify the text control.

FLP_OPEN: int  # Creates a picker which allows the user to select a file to open.

FLP_SAVE: int  # Creates a picker which allows the user to select a file to save.

FLP_OVERWRITE_PROMPT: int  # Can be combined with wx.FLP_SAVE only: ask confirmation to the user before selecting a file.

FLP_FILE_MUST_EXIST: int  # Can be combined with wx.FLP_OPEN only: the file selected in the popup   wx.FileDialog  must be an existing file. Notice that it still remains possible for the user to enter a non-existent file name in the text control if  FLP_USE_TEXTCTRL   is also used, this flag is a hint for the user rather than a guarantee that the selected file does exist for the program.

FLP_CHANGE_DIR: int  # Change current working directory on each user file selection change.

FLP_SMALL: int  # Use smaller version of the control with a small ââ¦â button instead of the normal âBrowseâ one. This flag is new since wxWidgets 2.9.3. ^^

class FileDropTarget(DropTarget):
    """ This is a drop target which accepts files (dragged from File Manager
or Explorer).

        Source: https://docs.wxpython.org/wx.FileDropTarget.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FileDropTarget.html
        """

    def OnDrop(self, x, y) -> bool:
        """ See wx.DropTarget.OnDrop .

            Source: https://docs.wxpython.org/wx.FileDropTarget.html
        """

    def OnDropFiles(self, x, y, filenames) -> bool:
        """ Override this function to receive dropped files.

            Source: https://docs.wxpython.org/wx.FileDropTarget.html
        """



class FileHistory(Object):
    """ The FileHistory encapsulates a user interface convenience, the list
of most recently visited files as shown on a menu (usually the File
menu).

        Source: https://docs.wxpython.org/wx.FileHistory.html
    """
    def __init__(self, maxFiles=9, idBase=ID_FILE1) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def AddFileToHistory(self, filename: str) -> None:
        """ Adds a file to the file history list, if the object has a pointer to an appropriate file menu.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def AddFilesToMenu(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def GetBaseId(self) -> int:
        """ Returns the base identifier for the range used for appending items.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def GetCount(self) -> int:
        """ Returns the number of files currently stored in the file history.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def GetHistoryFile(self, index: int) -> str:
        """ Returns the file at this index (zero-based).

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def GetMaxFiles(self) -> int:
        """ Returns the maximum number of files that can be stored.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def GetMenuPathStyle(self) -> 'FileHistoryMenuPathStyle':
        """ Get the current style of the menu item labels.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def GetMenus(self) -> 'FileHistoryMenuList':
        """ Returns the list of menus that are managed by this file history object.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def Load(self, config: 'ConfigBase') -> None:
        """ Loads the file history from the given config object.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def RemoveFileFromHistory(self, i: int) -> None:
        """ Removes the specified file from the history.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def RemoveMenu(self, menu: 'Menu') -> None:
        """ Removes this menu from the list of those managed by this object.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def Save(self, config: 'ConfigBase') -> None:
        """ Saves the file history into the given config object.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def SetBaseId(self, baseId: int) -> None:
        """ Sets the base identifier for the range used for appending items.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def SetMenuPathStyle(self, style: FileHistoryMenuPathStyle) -> None:
        """ Set the style of the menu item labels.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    def UseMenu(self, menu: 'Menu') -> None:
        """ Adds this menu to the list of those menus that are managed by this file history object.

            Source: https://docs.wxpython.org/wx.FileHistory.html
        """

    BaseId: int  # See GetBaseId and SetBaseId
    Count: int  # See GetCount
    MaxFiles: int  # See GetMaxFiles
    MenuPathStyle: 'FileHistoryMenuPathStyle'  # See GetMenuPathStyle and SetMenuPathStyle
    Menus: 'FileHistoryMenuList'  # See GetMenus



class FileSystem(Object):
    """ This class provides an interface for opening files on different file
systems.

        Source: https://docs.wxpython.org/wx.FileSystem.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    @staticmethod
    def AddHandler(handler: 'FileSystemHandler') -> None:
        """ This static function adds new handler into the list of handlers (see   wx.FileSystemHandler) which provide access to virtual FS.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    def ChangePathTo(self, location, is_dir=False) -> None:
        """ Sets the current location.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    @staticmethod
    def FileNameToURL(filename: str) -> str:
        """ Converts a FileName       into an URL.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    def FindFileInPath(self, pStr, path, file) -> bool:
        """ Looks for the file with the given name file  in a colon or semi-colon (depending on the current platform) separated list of directories in path.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    def FindFirst(self, wildcard, flags=0) -> str:
        """ Works like FindFirstFile .

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    def FindNext(self) -> str:
        """ Returns the next filename that matches the parameters passed to FindFirst .

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    def GetPath(self) -> str:
        """ Returns the actual path (set by wx.FileSystem.ChangePathTo ).

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    @staticmethod
    def HasHandlerForPath(location: str) -> bool:
        """ This static function returns True if there is a registered handler which can open the given location.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    def OpenFile(self, location, flags=FS_READ) -> 'FSFile':
        """ Opens the file and returns a pointer to a   wx.FSFile  object or None if failed.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    @staticmethod
    def RemoveHandler(handler: 'FileSystemHandler') -> 'FileSystemHandler':
        """ Remove a filesystem handler from the list of handlers.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    @staticmethod
    def URLToFileName(url: str) -> str:
        """ Converts URL into a well-formed filename.

            Source: https://docs.wxpython.org/wx.FileSystem.html
        """

    Path: str  # See GetPath



FS_READ: int

FS_SEEKABLE: int

class FileSystemHandler(Object):
    """ Classes derived from FileSystemHandler are used to access virtual
file systems.

        Source: https://docs.wxpython.org/wx.FileSystemHandler.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    def CanOpen(self, location: str) -> bool:
        """ Returns True if the handler is able to open this file.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    def FindFirst(self, wildcard, flags=0) -> str:
        """ Works like FindFirstFile .

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    def FindNext(self) -> str:
        """ Returns next filename that matches parameters passed to wx.FileSystem.FindFirst .

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    @staticmethod
    def GetAnchor(location: str) -> str:
        """ Returns the anchor if present in the location.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    @staticmethod
    def GetLeftLocation(location: str) -> str:
        """ Returns the left location string extracted from location.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    @staticmethod
    def GetMimeTypeFromExt(location: str) -> str:
        """ Returns the MIME type based on extension  of location.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    @staticmethod
    def GetProtocol(location: str) -> str:
        """ Returns the protocol string extracted from location.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    @staticmethod
    def GetRightLocation(location: str) -> str:
        """ Returns the right location string extracted from location.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """

    def OpenFile(self, fs, location) -> 'FSFile':
        """ Opens the file and returns   wx.FSFile  pointer or None if failed.

            Source: https://docs.wxpython.org/wx.FileSystemHandler.html
        """



class FileSystemWatcher(EvtHandler):
    """ The FileSystemWatcher class allows receiving notifications of file
system changes.

        Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def Add(self, path, events=FSW_EVENT_ALL) -> bool:
        """ Adds path  to currently watched files.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def AddTree(self, path, events=FSW_EVENT_ALL, filter="") -> bool:
        """ This is the same as Add , but also recursively adds every file/directory in the tree rooted at path.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def GetWatchedPaths(self, paths: list[str]) -> int:
        """ Retrieves all watched paths and places them in paths.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def GetWatchedPathsCount(self) -> int:
        """ Returns the number of currently watched paths.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def Remove(self, path: str) -> bool:
        """ Removes path  from the list of watched paths.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def RemoveAll(self) -> bool:
        """ Clears the list of currently watched paths.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def RemoveTree(self, path: str) -> bool:
        """ This is the same as Remove , but also removes every file/directory belonging to the tree rooted at path.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    def SetOwner(self, handler: 'EvtHandler') -> None:
        """ Associates the file system watcher with the given handler  object.

            Source: https://docs.wxpython.org/wx.FileSystemWatcher.html
        """

    WatchedPathsCount: int  # See GetWatchedPathsCount



class FileSystemWatcherEvent(Event):
    """ A class of events sent when a file system event occurs.

        Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def Clone(self) -> 'Event':
        """ wx.Event

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def GetChangeType(self) -> int:
        """ Returns the type of file system change that occurred.

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def GetErrorDescription(self) -> str:
        """ Return a description of the warning or error if this is an error event.

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def GetNewPath(self) -> str:
        """ Returns the new path of the renamed file/directory if this is a rename event.

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def GetPath(self) -> str:
        """ Returns the path at which the event occurred.

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def GetWarningType(self) -> 'FSWWarningType':
        """ Return the type of the warning if this event is a warning one.

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def IsError(self) -> bool:
        """ Returns  true   if this error is an error event.

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    def ToString(self) -> str:
        """ Returns a String       describing an event, useful for logging, debugging or testing.

            Source: https://docs.wxpython.org/wx.FileSystemWatcherEvent.html
        """

    ChangeType: int  # See GetChangeType
    ErrorDescription: str  # See GetErrorDescription
    NewPath: str  # See GetNewPath
    Path: str  # See GetPath
    WarningType: 'FSWWarningType'  # See GetWarningType



class FileTranslationsLoader(TranslationsLoader):
    """ Standard TranslationsLoader implementation.

        Source: https://docs.wxpython.org/wx.FileTranslationsLoader.html
    """
    @staticmethod
    def AddCatalogLookupPathPrefix(prefix: str) -> None:
        """ Add a prefix to the catalog lookup path: the message catalog files will be looked up under prefix/lang/LC_MESSAGES and prefix/lang directories (in this order).

            Source: https://docs.wxpython.org/wx.FileTranslationsLoader.html
        """



class TranslationsLoader:
    """ Abstraction of translations discovery and loading.

        Source: https://docs.wxpython.org/wx.TranslationsLoader.html
    """
    def __init__(self) -> None:
        """ Trivial default constructor.

            Source: https://docs.wxpython.org/wx.TranslationsLoader.html
        """

    def GetAvailableTranslations(self, domain: str) -> list[str]:
        """ Implements wx.Translations.GetAvailableTranslations .

            Source: https://docs.wxpython.org/wx.TranslationsLoader.html
        """

    def LoadCatalog(self, domain, lang) -> 'MsgCatalog':
        """ Called to load requested catalog.

            Source: https://docs.wxpython.org/wx.TranslationsLoader.html
        """



_Icon: TypeAlias = Icon

_IconLocation: TypeAlias = IconLocation

class FileType:
    """ This class holds information about a given file type.

        Source: https://docs.wxpython.org/wx.FileType.html
    """
    def __init__(self, ftInfo: 'FileTypeInfo') -> None:
        """ Copy constructor.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    @staticmethod
    def ExpandCommand(command, params) -> str:
        """ This function is primarily intended for GetOpenCommand and GetPrintCommand usage but may be also used by the application directly if, for example, you want to use some non-default command to open the file.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetAllCommands(self, params: FileType.MessageParameters) -> tuple:
        """ Returns a tuple containing the verbs and commands arrays, corresponding for the registered information for this mime type.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetDescription(self) -> str:
        """ Returns a brief description for this file type: for example, âtext documentâ for
the âtext/plainâ MIME type.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetExpandedCommand(self, verb, params) -> str:
        """ The returned string is the command to be executed in order to open/print/edit the file of the given type.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetExtensions(self) -> list[str]:
        """ Returns all extensions associated with this file type: for
example, it may contain the following two elements for the MIME
type âtext/htmlâ (notice the absence of the leading dot): âhtmlâ
and âhtmâ.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetIcon(self) -> 'Icon':
        """ Return the icon associated with this mime type, if any.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetIconInfo(self) -> Any:
        """ Returns a tuple containing the Icon for this file type, the file where the
icon is found, and the index of the image in that file, if applicable.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetIconLocation(self) -> 'IconLocation':
        """ Returns a wx.IconLocation that can be used to fetch the icon for this mime type.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetMimeType(self) -> str:
        """ Returns full MIME type specification for this file type: for example, âtext/plainâ.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetMimeTypes(self) -> list[str]:
        """ Same as GetMimeType but returns a list of types.  This will usually contain
only one item, but sometimes, such as on Unix with KDE more than one type
if there are differences between KDE< mailcap and mime.types.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetOpenCommand(self, *args, **kw) -> str:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    def GetPrintCommand(self, params) -> str:
        """ Returns the command which must be executed (see Execute()) in order to
print the file of the given type. The name of the file is retrieved from
the MessageParameters class.

            Source: https://docs.wxpython.org/wx.FileType.html
        """

    Description: str  # See GetDescription
    Extensions: list[str]  # See GetExtensions
    Icon: '_Icon'  # See GetIcon
    IconInfo: Any  # See GetIconInfo
    IconLocation: '_IconLocation'  # See GetIconLocation
    MimeType: str  # See GetMimeType
    MimeTypes: list[str]  # See GetMimeTypes
    OpenCommand: str  # See GetOpenCommand
    PrintCommand: str  # See GetPrintCommand



class FileTypeInfo:
    """ Container of information about FileType.

        Source: https://docs.wxpython.org/wx.FileTypeInfo.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def AddExtension(self, ext: str) -> None:
        """ Add another extension associated with this file type.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetDescription(self) -> str:
        """ Get the long, user visible description.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetExtensions(self) -> list[str]:
        """ Get the array of all extensions.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetExtensionsCount(self) -> int:
        """ Get the number of extensions.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetIconFile(self) -> str:
        """ Get the icon filename.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetIconIndex(self) -> int:
        """ Get the index of the icon within the icon file.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetMimeType(self) -> str:
        """ Get the MIME type.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetOpenCommand(self) -> str:
        """ Get the open command.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetPrintCommand(self) -> str:
        """ Get the print command.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def GetShortDesc(self) -> str:
        """ Get the short description (only used under Win32 so far)

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def SetDescription(self, description: str) -> None:
        """ Set the file type description.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def SetIcon(self, iconFile, iconIndex=0) -> None:
        """ Set the icon information.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def SetOpenCommand(self, command: str) -> None:
        """ Set the command to be used for opening files of this type.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def SetPrintCommand(self, command: str) -> None:
        """ Set the command to be used for printing files of this type.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    def SetShortDesc(self, shortDesc: str) -> None:
        """ Set the short description for the files of this type.

            Source: https://docs.wxpython.org/wx.FileTypeInfo.html
        """

    Description: str  # See GetDescription and SetDescription
    Extensions: list[str]  # See GetExtensions
    ExtensionsCount: int  # See GetExtensionsCount
    IconFile: str  # See GetIconFile
    IconIndex: int  # See GetIconIndex
    MimeType: str  # See GetMimeType
    OpenCommand: str  # See GetOpenCommand and SetOpenCommand
    PrintCommand: str  # See GetPrintCommand and SetPrintCommand
    ShortDesc: str  # See GetShortDesc and SetShortDesc



class FilterFSHandler(FileSystemHandler):
    """ Filter file system handler.

        Source: https://docs.wxpython.org/wx.FilterFSHandler.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.FilterFSHandler.html
        """



class FindDialogEvent(CommandEvent):
    """ FindReplaceDialog events.

        Source: https://docs.wxpython.org/wx.FindDialogEvent.html
    """
    def __init__(self, commandType=wxEVT_NULL, id=0) -> None:
        """ Constructor used by wxWidgets only.

            Source: https://docs.wxpython.org/wx.FindDialogEvent.html
        """

    def GetDialog(self) -> 'FindReplaceDialog':
        """ Return the pointer to the dialog which generated this event.

            Source: https://docs.wxpython.org/wx.FindDialogEvent.html
        """

    def GetFindString(self) -> str:
        """ Return the string to find (never empty).

            Source: https://docs.wxpython.org/wx.FindDialogEvent.html
        """

    def GetFlags(self) -> int:
        """ Get the currently selected flags: this is the combination of the   wx.FindReplaceFlags  enumeration values.

            Source: https://docs.wxpython.org/wx.FindDialogEvent.html
        """

    def GetReplaceString(self) -> str:
        """ Return the string to replace the search string with (only for replace and replace all events).

            Source: https://docs.wxpython.org/wx.FindDialogEvent.html
        """

    Dialog: 'FindReplaceDialog'  # See GetDialog
    FindString: str  # See GetFindString
    Flags: int  # See GetFlags
    ReplaceString: str  # See GetReplaceString



EVT_FIND: int  # Find button was pressed in the dialog.

EVT_FIND_NEXT: int  # Find next button was pressed in the dialog.

EVT_FIND_REPLACE: int  # Replace button was pressed in the dialog.

EVT_FIND_REPLACE_ALL: int  # Replace all button was pressed in the dialog.

EVT_FIND_CLOSE: int  # The dialog is being destroyed, any pointers to it cannot be used any longer. ^^

class FindReplaceDialog(Dialog):
    """ FindReplaceDialog is a standard modeless dialog which is used to
allow the user to search for some text (and possibly replace it with
something else).

        Source: https://docs.wxpython.org/wx.FindReplaceDialog.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FindReplaceDialog.html
        """

    def Create(self, parent, data, title="", style=0) -> bool:
        """ Creates the dialog; use wx.Window.Show   to show it on screen.

            Source: https://docs.wxpython.org/wx.FindReplaceDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.FindReplaceDialog.html
        """

    def GetData(self) -> 'FindReplaceData':
        """ Get the   wx.FindReplaceData  object used by this dialog.

            Source: https://docs.wxpython.org/wx.FindReplaceDialog.html
        """

    Data: 'FindReplaceData'  # See GetData



class FindReplaceData(Object):
    """ FindReplaceData holds the data for FindReplaceDialog.

        Source: https://docs.wxpython.org/wx.FindReplaceData.html
    """
    def __init__(self, flags: 'int'=0) -> None:
        """ Constructor initializes the flags to default value (0).

            Source: https://docs.wxpython.org/wx.FindReplaceData.html
        """

    def GetFindString(self) -> str:
        """ Get the string to find.

            Source: https://docs.wxpython.org/wx.FindReplaceData.html
        """

    def GetFlags(self) -> int:
        """ Get the combination of  FindReplaceFlags   values.

            Source: https://docs.wxpython.org/wx.FindReplaceData.html
        """

    def GetReplaceString(self) -> str:
        """ Get the replacement string.

            Source: https://docs.wxpython.org/wx.FindReplaceData.html
        """

    def SetFindString(self, str: str) -> None:
        """ Set the string to find (used as initial value by the dialog).

            Source: https://docs.wxpython.org/wx.FindReplaceData.html
        """

    def SetFlags(self, flags: 'int') -> None:
        """ Set the flags to use to initialize the controls of the dialog.

            Source: https://docs.wxpython.org/wx.FindReplaceData.html
        """

    def SetReplaceString(self, str: str) -> None:
        """ Set the replacement string (used as initial value by the dialog).

            Source: https://docs.wxpython.org/wx.FindReplaceData.html
        """

    FindString: str  # See GetFindString and SetFindString
    Flags: int  # See GetFlags and SetFlags
    ReplaceString: str  # See GetReplaceString and SetReplaceString



class FlexGridSizer(GridSizer):
    """ A flex grid sizer is a sizer which lays out its children in a two-
dimensional table with all table fields in one row having the same
height and all fields in one column having the same width, but all
rows or all columns are not necessarily the same height or width as in
the GridSizer.

        Source: https://docs.wxpython.org/wx.FlexGridSizer.html
    """
    def __init__(self, *args, **kw) -> None:
        """ wx.FlexGridSizer  constructors.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def AddGrowableCol(self, idx, proportion=0) -> None:
        """ Specifies that column idx  (starting from zero) should be grown if there is extra space available to the sizer.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def AddGrowableRow(self, idx, proportion=0) -> None:
        """ Specifies that row idx (starting from zero) should be grown if there is extra space available to the sizer.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def CalcMin(self) -> 'Size':
        """ This method is abstract and has to be overwritten by any derived class.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def GetColWidths(self) -> list[int]:
        """ Returns a read-only array containing the widths of the columns in the sizer.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def GetFlexibleDirection(self) -> int:
        """ Returns a   wx.Orientation  value that specifies whether the sizer flexibly resizes its columns, rows, or both (default).

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def GetNonFlexibleGrowMode(self) -> 'FlexSizerGrowMode':
        """ Returns the value that specifies how the sizer grows in the ânon-flexibleâ direction if there is one.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def GetRowHeights(self) -> list[int]:
        """ Returns a read-only array containing the heights of the rows in the sizer.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def IsColGrowable(self, idx: int) -> bool:
        """ Returns True if column idx  is growable.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def IsRowGrowable(self, idx: int) -> bool:
        """ Returns True if row idx  is growable.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def RemoveGrowableCol(self, idx: int) -> None:
        """ Specifies that the idx  column index is no longer growable.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def RemoveGrowableRow(self, idx: int) -> None:
        """ Specifies that the idx  row index is no longer growable.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def RepositionChildren(self, minSize: Union[tuple[int, int], 'Size']) -> None:
        """ Method which must be overridden in the derived sizer classes.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def SetFlexibleDirection(self, direction: int) -> None:
        """ Specifies whether the sizer should flexibly resize its columns, rows, or both.

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    def SetNonFlexibleGrowMode(self, mode: FlexSizerGrowMode) -> None:
        """ Specifies how the sizer should grow in the non-flexible direction if there is one (so SetFlexibleDirection   must have been called previously).

            Source: https://docs.wxpython.org/wx.FlexGridSizer.html
        """

    ColWidths: list[int]  # See GetColWidths
    FlexibleDirection: int  # See GetFlexibleDirection and SetFlexibleDirection
    NonFlexibleGrowMode: 'FlexSizerGrowMode'  # See GetNonFlexibleGrowMode and SetNonFlexibleGrowMode
    RowHeights: list[int]  # See GetRowHeights



FLEX_GROWMODE_NONE: int

FLEX_GROWMODE_SPECIFIED: int

FLEX_GROWMODE_ALL: int

class GridSizer(Sizer):
    """ A grid sizer is a sizer which lays out its children in a two-
dimensional table with all table fields having the same size, i.e.

        Source: https://docs.wxpython.org/wx.GridSizer.html
    """
    def __init__(self, *args, **kw) -> None:
        """ wx.GridSizer  constructors.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def CalcMin(self) -> 'Size':
        """ This method is abstract and has to be overwritten by any derived class.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def CalcRowsCols(self) -> None:
        """ Calculates how many rows and columns will be in the sizer based
on the current number of items and also the rows, cols specified
in the constructor.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def GetCols(self) -> int:
        """ Returns the number of columns that has been specified for the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def GetEffectiveColsCount(self) -> int:
        """ Returns the number of columns currently used by the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def GetEffectiveRowsCount(self) -> int:
        """ Returns the number of rows currently used by the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def GetHGap(self) -> int:
        """ Returns the horizontal gap (in pixels) between cells in the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def GetRows(self) -> int:
        """ Returns the number of rows that has been specified for the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def GetVGap(self) -> int:
        """ Returns the vertical gap (in pixels) between the cells in the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def RepositionChildren(self, minSize: Union[tuple[int, int], 'Size']) -> None:
        """ Method which must be overridden in the derived sizer classes.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def SetCols(self, cols: int) -> None:
        """ Sets the number of columns in the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def SetHGap(self, gap: int) -> None:
        """ Sets the horizontal gap (in pixels) between cells in the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def SetRows(self, rows: int) -> None:
        """ Sets the number of rows in the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    def SetVGap(self, gap: int) -> None:
        """ Sets the vertical gap (in pixels) between the cells in the sizer.

            Source: https://docs.wxpython.org/wx.GridSizer.html
        """

    Cols: int  # See GetCols and SetCols
    EffectiveColsCount: int  # See GetEffectiveColsCount
    EffectiveRowsCount: int  # See GetEffectiveRowsCount
    HGap: int  # See GetHGap and SetHGap
    Rows: int  # See GetRows and SetRows
    VGap: int  # See GetVGap and SetVGap



class FocusEvent(Event):
    """ A focus event is sent when a windowâs focus changes.

        Source: https://docs.wxpython.org/wx.FocusEvent.html
    """
    def __init__(self, eventType=wxEVT_NULL, id=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FocusEvent.html
        """

    def GetWindow(self) -> 'Window':
        """ Returns the window associated with this event, that is the window which had the focus before for the  wxEVT_SET_FOCUS   event and the window which is going to receive focus for the   wxEVT_KILL_FOCUS   one.

            Source: https://docs.wxpython.org/wx.FocusEvent.html
        """

    def SetWindow(self, win: 'Window') -> None:
        """ win (wx.Window) â

            Source: https://docs.wxpython.org/wx.FocusEvent.html
        """

    Window: '_Window'  # See GetWindow and SetWindow



class Font(GDIObject):
    """ A font is an object which determines the appearance of text.

        Source: https://docs.wxpython.org/wx.Font.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Font.html
        """

    @staticmethod
    def AddPrivateFont(filename: str) -> bool:
        """ Specify the name of a file containing a TrueType font to be made available to the current application.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Bold(self) -> 'Font':
        """ Returns a bold version of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    @staticmethod
    def CanUsePrivateFont() -> bool:
        """ Returns True if this build of wxPython supports using AddPrivateFont.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetBaseFont(self) -> 'Font':
        """ Returns a font with the same face/size as the given one but with normal weight and style and not underlined nor stricken through.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    @staticmethod
    def GetDefaultEncoding() -> int:
        """ Returns the current applicationâs default encoding.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetEncoding(self) -> int:
        """ Returns the encoding of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetFaceName(self) -> str:
        """ Returns the face name associated with the font, or the empty string if there is no face information.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetFamily(self) -> int:
        """ Gets the font family if possible.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetFractionalPointSize(self) -> float:
        """ Gets the point size as a floating number.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetHFONT(self) -> None:
        """ Returns the fontâs native handle.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetNativeFontInfo(self) -> 'NativeFontInfo':
        """ Returns a font with the same face/size as the given one but with normal weight and style and not underlined nor stricken through.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetNativeFontInfoDesc(self) -> str:
        """ Returns the platform-dependent string completely describing this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetNativeFontInfoUserDesc(self) -> str:
        """ Returns a user-friendly string for this font object.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetNumericWeight(self) -> int:
        """ Gets the font weight as an integer value.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    @staticmethod
    def GetNumericWeightOf(weight: int) -> int:
        """ Get the raw weight value corresponding to the given symbolic constant.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetPangoFontDescription(self) -> None:
        """ Returns the fontâs native handle.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetPixelSize(self) -> 'Size':
        """ Gets the pixel size.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetPointSize(self) -> int:
        """ Gets the point size as an integer number.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetStrikethrough(self) -> bool:
        """ Returns True if the font is stricken-through, False otherwise.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetStyle(self) -> int:
        """ Gets the font style.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetUnderlined(self) -> bool:
        """ Returns True if the font is underlined, False otherwise.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def GetWeight(self) -> int:
        """ Gets the font weight.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def IsFixedWidth(self) -> bool:
        """ Returns True if the font is a fixed width (or monospaced) font, False if it is a proportional one or font is invalid.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def IsOk(self) -> bool:
        """ Returns True if this object is a valid font, False otherwise.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Italic(self) -> 'Font':
        """ Returns an italic version of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Larger(self) -> 'Font':
        """ Returns a larger version of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def MakeBold(self) -> 'Font':
        """ Changes this font to be bold.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def MakeItalic(self) -> 'Font':
        """ Changes this font to be italic.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def MakeLarger(self) -> 'Font':
        """ Changes this font to be larger.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def MakeSmaller(self) -> 'Font':
        """ Changes this font to be smaller.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def MakeStrikethrough(self) -> 'Font':
        """ Changes this font to be stricken-through.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def MakeUnderlined(self) -> 'Font':
        """ Changes this font to be underlined.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    @staticmethod
    def New(*args, **kw) -> 'Font':
        """ This function takes the same parameters as the relative Font constructor  and returns a new font object allocated on the heap.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def OSXGetCGFont(self) -> None:
        """ Returns the fontâs native handle.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Scale(self, x: float) -> 'Font':
        """ Changes the size of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Scaled(self, x: float) -> 'Font':
        """ Returns a scaled version of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    @staticmethod
    def SetDefaultEncoding(encoding: int) -> None:
        """ Sets the default font encoding.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetEncoding(self, encoding: int) -> None:
        """ Sets the encoding for this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetFaceName(self, faceName: str) -> bool:
        """ Sets the facename for the font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetFamily(self, family: int) -> None:
        """ Sets the font family.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetFractionalPointSize(self, pointSize: float) -> None:
        """ Sets the font size in points.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetNativeFontInfo(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetNativeFontInfoUserDesc(self, info: str) -> bool:
        """ Creates the font corresponding to the given native font description string and returns True if the creation was successful.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetNumericWeight(self, weight: int) -> None:
        """ Sets the font weight using an integer value.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetPixelSize(self, pixelSize: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the pixel size.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetPointSize(self, pointSize: int) -> None:
        """ Sets the font size in points to an integer value.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetStrikethrough(self, strikethrough: bool) -> None:
        """ Sets strike-through attribute of the font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetStyle(self, style: int) -> None:
        """ Sets the font style.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetSymbolicSize(self, size: FontSymbolicSize) -> None:
        """ Sets the font size using a predefined symbolic size name.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetSymbolicSizeRelativeTo(self, size, base) -> None:
        """ Sets the font size compared to the base font size.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetUnderlined(self, underlined: bool) -> None:
        """ Sets underlining.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def SetWeight(self, weight: int) -> None:
        """ Sets the font weight.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Smaller(self) -> 'Font':
        """ Returns a smaller version of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Strikethrough(self) -> 'Font':
        """ Returns stricken-through version of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def Underlined(self) -> 'Font':
        """ Returns underlined version of this font.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def _copyFrom(self, other) -> None:
        """ For internal use only.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Inequality operator.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Equality operator.

            Source: https://docs.wxpython.org/wx.Font.html
        """

    Encoding: int  # See GetEncoding and SetEncoding
    FaceName: str  # See GetFaceName and SetFaceName
    Family: int  # See GetFamily and SetFamily
    NativeFontInfoDesc: str  # See GetNativeFontInfoDesc and SetNativeFontInfo
    NativeFontInfoUserDesc: str  # See GetNativeFontInfoUserDesc and SetNativeFontInfoUserDesc
    PixelSize: 'Size'  # See GetPixelSize and SetPixelSize
    PointSize: int  # See GetPointSize and SetPointSize
    Style: int  # See GetStyle and SetStyle
    Weight: int  # See GetWeight and SetWeight



class FontData(Object):
    """ This class holds a variety of information related to font dialogs.

        Source: https://docs.wxpython.org/wx.FontData.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def EnableEffects(self, enable: bool) -> None:
        """ Enables or disables âeffectsâ under Windows or generic only.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def GetAllowSymbols(self) -> bool:
        """ Under Windows, returns a flag determining whether symbol fonts can be selected.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def GetChosenFont(self) -> 'Font':
        """ Gets the font chosen by the user if the user pressed wx.OK ( wx.FontDialog.ShowModal   returned wx.ID_OK).

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def GetColour(self) -> 'Colour':
        """ Gets the colour associated with the font dialog.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def GetEnableEffects(self) -> bool:
        """ Determines whether âeffectsâ are enabled under Windows.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def GetInitialFont(self) -> 'Font':
        """ Gets the font that will be initially used by the font dialog.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def GetRestrictSelection(self) -> int:
        """ Returns the state of the flags restricting the selection.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def GetShowHelp(self) -> bool:
        """ Returns True if the Help button will be shown (Windows only).

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def RestrictSelection(self, flags: int) -> None:
        """ Restricts the selection to a subset of the available fonts.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def SetAllowSymbols(self, allowSymbols: bool) -> None:
        """ Under Windows, determines whether symbol fonts can be selected.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def SetChosenFont(self, font: 'Font') -> None:
        """ Sets the font that will be returned to the user (for internal use only).

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def SetColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the colour that will be used for the font foreground colour.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def SetInitialFont(self, font: 'Font') -> None:
        """ Sets the font that will be initially used by the font dialog.

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def SetRange(self, min, max) -> None:
        """ Sets the valid range for the font point size (Windows only).

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    def SetShowHelp(self, showHelp: bool) -> None:
        """ Determines whether the Help button will be displayed in the font dialog (Windows only).

            Source: https://docs.wxpython.org/wx.FontData.html
        """

    AllowSymbols: bool  # See GetAllowSymbols and SetAllowSymbols
    ChosenFont: 'Font'  # See GetChosenFont and SetChosenFont
    Colour: '_Colour'  # See GetColour and SetColour
    InitialFont: 'Font'  # See GetInitialFont and SetInitialFont
    ShowHelp: bool  # See GetShowHelp and SetShowHelp



_FontData: TypeAlias = FontData

class FontDialog(Dialog):
    """ This class represents the font chooser dialog.

        Source: https://docs.wxpython.org/wx.FontDialog.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FontDialog.html
        """

    def Create(self, *args, **kw) -> None:
        """ Creates the dialog if the   wx.FontDialog  object had been initialized using the default constructor.

            Source: https://docs.wxpython.org/wx.FontDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.FontDialog.html
        """

    def GetFontData(self) -> 'FontData':
        """ Returns the font data  associated with the font dialog.

            Source: https://docs.wxpython.org/wx.FontDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning  ID_OK   if the user pressed Ok, and   ID_CANCEL   otherwise.

            Source: https://docs.wxpython.org/wx.FontDialog.html
        """

    FontData: '_FontData'  # See GetFontData



class FontEnumerator:
    """ FontEnumerator enumerates either all available fonts on the system
or only the ones with given attributes - either only fixed-width
(suited for use in programs such as terminal emulators and the like)
or the fonts available in the given encoding).

        Source: https://docs.wxpython.org/wx.FontEnumerator.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    def EnumerateEncodings(self, font: str="") -> bool:
        """ Call OnFontEncoding   for each encoding supported by the given font - or for each encoding supported by at least some font if font  is not specified.

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    def EnumerateFacenames(self, encoding=FONTENCODING_SYSTEM, fixedWidthOnly=False) -> bool:
        """ Call OnFacename   for each font which supports given encoding (only if it is not  FONTENCODING_SYSTEM ) and is of fixed width (if  fixedWidthOnly  is True).

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    @staticmethod
    def GetEncodings(facename: str="") -> list[str]:
        """ Return array of strings containing all encodings found by EnumerateEncodings .

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    @staticmethod
    def GetFacenames(encoding=FONTENCODING_SYSTEM, fixedWidthOnly=False) -> list[str]:
        """ Return array of strings containing all facenames found by EnumerateFacenames .

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    @staticmethod
    def InvalidateCache() -> None:
        """ Invalidate cache used by some of the methods of this class internally.

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    @staticmethod
    def IsValidFacename(facename: str) -> bool:
        """ Returns True if the given string is valid face name, i.e.

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    def OnFacename(self, font: str) -> bool:
        """ Called by EnumerateFacenames   for each match.

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """

    def OnFontEncoding(self, font, encoding) -> bool:
        """ Called by EnumerateEncodings   for each match.

            Source: https://docs.wxpython.org/wx.FontEnumerator.html
        """



class FontInfo:
    """ This class is a helper used for Font creation using named parameter
idiom: it allows specifying various Font attributes using the
chained calls to its clearly named methods instead of passing them in
the fixed order to Font constructors.

        Source: https://docs.wxpython.org/wx.FontInfo.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def AllFlags(self, flags: int) -> 'FontInfo':
        """ Set all the font attributes at once.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def AntiAliased(self, antiAliased: bool=True) -> 'FontInfo':
        """ Set anti-aliasing flag.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Bold(self, bold: bool=True) -> 'FontInfo':
        """ Use a bold version of the font.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Encoding(self, encoding: int) -> 'FontInfo':
        """ Set the font encoding to use.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def FaceName(self, faceName: str) -> 'FontInfo':
        """ Set the font face name to use.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Family(self, family: int) -> 'FontInfo':
        """ Set the font family.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    @staticmethod
    def GetWeightClosestToNumericValue(numWeight: int) -> int:
        """ Get the symbolic weight closest to the given raw weight value.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Italic(self, italic: bool=True) -> 'FontInfo':
        """ Use an italic version of the font.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Light(self, light: bool=True) -> 'FontInfo':
        """ Use a lighter version of the font.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Slant(self, slant: bool=True) -> 'FontInfo':
        """ Use a slanted version of the font.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Strikethrough(self, strikethrough: bool=True) -> 'FontInfo':
        """ Use a strike-through version of the font.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Style(self, style: int) -> 'FontInfo':
        """ Specify the style of the font using one of FontStyle constants.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Underlined(self, underlined: bool=True) -> 'FontInfo':
        """ Use an underlined version of the font.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """

    def Weight(self, weight: int) -> 'FontInfo':
        """ Specify the weight of the font.

            Source: https://docs.wxpython.org/wx.FontInfo.html
        """



class FontList:
    """ A font list is a list containing all fonts which have been created.

        Source: https://docs.wxpython.org/wx.FontList.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FontList.html
        """

    def FindOrCreateFont(self, *args, **kw) -> 'Font':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FontList.html
        """



class FontMapper:
    """ FontMapper manages user-definable correspondence between logical
font names and the fonts present on the machine.

        Source: https://docs.wxpython.org/wx.FontMapper.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    def CharsetToEncoding(self, charset, interactive=True) -> int:
        """ Returns the encoding for the given charset (in the form of RFC 2046) or  FONTENCODING_SYSTEM   if couldnât decode it.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def Get() -> 'FontMapper':
        """ Get the current font mapper object.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def GetAllEncodingNames(encoding) -> list[str]:
        """ Returns the array of all possible names for the given encoding. If it
isnât empty, the first name in it is the canonical encoding name,
i.e. the same string as returned by GetEncodingName()

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    def GetAltForEncoding(self, encoding, facename="", interactive=True) -> tuple:
        """ Find an alternative for the given encoding (which is supposed to not be available on this system).

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def GetEncoding(n: int) -> int:
        """ Returns the n-th  supported encoding.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def GetEncodingDescription(encoding: int) -> str:
        """ Return user-readable string describing the given encoding.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def GetEncodingFromName(encoding: str) -> int:
        """ Return the encoding corresponding to the given internal name.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def GetEncodingName(encoding: int) -> str:
        """ Return internal string identifier for the encoding (see also wx.FontMapper.GetEncodingDescription ).

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def GetSupportedEncodingsCount() -> int:
        """ Returns the number of the font encodings supported by this class.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    def IsEncodingAvailable(self, encoding, facename="") -> bool:
        """ Check whether given encoding is available in given face or not.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    @staticmethod
    def Set(mapper: 'FontMapper') -> 'FontMapper':
        """ Set the current font mapper object and return previous one (may be None).

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    def SetConfigPath(self, prefix: str) -> None:
        """ Set the root config path to use (should be an absolute path).

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    def SetDialogParent(self, parent: 'Window') -> None:
        """ The parent window for modal dialogs.

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """

    def SetDialogTitle(self, title: str) -> None:
        """ The title for the dialogs (note that default is quite reasonable).

            Source: https://docs.wxpython.org/wx.FontMapper.html
        """



class FontMetrics:
    """ Simple collection of various font metrics.

        Source: https://docs.wxpython.org/wx.FontMetrics.html
    """
    def __init__(self) -> None:
        """ Constructor initializes all fields to 0.

            Source: https://docs.wxpython.org/wx.FontMetrics.html
        """

    ascent: Any  # A public C++ attribute of type int. Part of the height above the baseline.
    averageWidth: Any  # A public C++ attribute of type int. Average font width, a.k.a. âx-widthâ.
    descent: Any  # A public C++ attribute of type int. Part of the height below the baseline.
    externalLeading: Any  # A public C++ attribute of type int. Inter-line spacing.
    height: Any  # A public C++ attribute of type int. Total character height.
    internalLeading: Any  # A public C++ attribute of type int. Intra-line spacing.



class FontPickerCtrl(PickerBase):
    """ This control allows the user to select a font.

        Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def Create(self, parent, id=ID_ANY, font=NullFont, pos=DefaultPosition, size=DefaultSize, style=FNTP_DEFAULT_STYLE, validator=DefaultValidator, name=FontPickerCtrlNameStr) -> bool:
        """ Creates this widget with given parameters.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def GetMaxPointSize(self) -> int:
        """ Returns the maximum point size value allowed for the user-chosen font.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def GetMinPointSize(self) -> int:
        """ Returns the minimum point size value allowed for the user-chosen font.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def GetSelectedColour(self) -> 'Colour':
        """ Returns the currently selected colour.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def GetSelectedFont(self) -> 'Font':
        """ Returns the currently selected font.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def SetMaxPointSize(self, max: int) -> None:
        """ Sets the maximum point size value allowed for the user-chosen font.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def SetMinPointSize(self, min: int) -> None:
        """ Sets the minimum point size value allowed for the user-chosen font.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def SetSelectedColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the font colour.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    def SetSelectedFont(self, font: 'Font') -> None:
        """ Sets the currently selected font.

            Source: https://docs.wxpython.org/wx.FontPickerCtrl.html
        """

    MaxPointSize: int  # See GetMaxPointSize and SetMaxPointSize
    MinPointSize: int  # See GetMinPointSize and SetMinPointSize
    SelectedColour: 'Colour'  # See GetSelectedColour and SetSelectedColour
    SelectedFont: 'Font'  # See GetSelectedFont and SetSelectedFont



FNTP_DEFAULT_STYLE: int  # The default style: wx.FNTP_FONTDESC_AS_LABEL | wx.FNTP_USEFONT_FOR_LABEL.

FNTP_USE_TEXTCTRL: int  # Creates a text control to the left of the picker button which is completely managed by the   wx.FontPickerCtrl  and which can be used by the user to specify a font (see SetSelectedFont). The text control is automatically synchronized with buttonâs value. Use functions defined in   wx.PickerBase  to modify the text control.

FNTP_FONTDESC_AS_LABEL: int  # Keeps the label of the button updated with the fontface name and the font size. E.g. choosing âTimes New Roman bold, italic withsize 10â from the fontdialog, will update the label (overwriting any previous label) with the âTimes New Roman, 10â text.

FNTP_USEFONT_FOR_LABEL: int  # Uses the currently selected font to draw the label of the button. ^^

EVT_FONTPICKER_CHANGED: int  # The user changed the font selected in the control either using the button or using text control (see wx.FNTP_USE_TEXTCTRL; note that in this case the event is fired only if the userâs input is valid, i.e. recognizable). ^^

class FontPickerEvent(CommandEvent):
    """ This event class is used for the events generated by FontPickerCtrl.

        Source: https://docs.wxpython.org/wx.FontPickerEvent.html
    """
    def __init__(self, generator, id, font) -> None:
        """ The constructor is not normally used by the user code.

            Source: https://docs.wxpython.org/wx.FontPickerEvent.html
        """

    def GetFont(self) -> 'Font':
        """ Retrieve the font the user has just selected.

            Source: https://docs.wxpython.org/wx.FontPickerEvent.html
        """

    def SetFont(self: 'Font', f) -> None:
        """ Set the font associated with the event.

            Source: https://docs.wxpython.org/wx.FontPickerEvent.html
        """

    Font: '_Font'  # See GetFont and SetFont



_MenuBar: TypeAlias = MenuBar

_StatusBar: TypeAlias = StatusBar

_ToolBar: TypeAlias = ToolBar

class Frame(TopLevelWindow):
    """ A frame is a window whose size and position can (usually) be changed
by the user.

        Source: https://docs.wxpython.org/wx.Frame.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def Centre(self, direction: int=BOTH) -> None:
        """ Centres the frame on the display.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def Create(self, parent, id=ID_ANY, title="", pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE, name=FrameNameStr) -> bool:
        """ Used in two-step frame construction.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def CreateStatusBar(self, number=1, style=STB_DEFAULT_STYLE, id=0, name=StatusBarNameStr) -> 'StatusBar':
        """ Creates a status bar at the bottom of the frame.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def CreateToolBar(self, style=TB_DEFAULT_STYLE, id=ID_ANY, name=ToolBarNameStr) -> 'ToolBar':
        """ Creates a toolbar at the top or left of the frame.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def DoGiveHelp(self, text, show) -> None:
        """ Method used to show help string of the selected menu toolbar item.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def GetClientAreaOrigin(self) -> 'Point':
        """ Returns the origin of the frame client area (in client coordinates).

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def GetMenuBar(self) -> 'MenuBar':
        """ Returns a pointer to the menubar currently associated with the frame (if any).

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def GetStatusBar(self) -> 'StatusBar':
        """ Returns a pointer to the status bar currently associated with the frame (if any).

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def GetStatusBarPane(self) -> int:
        """ Returns the status bar pane used to display menu and toolbar help.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def GetToolBar(self) -> 'ToolBar':
        """ Returns a pointer to the toolbar currently associated with the frame (if any).

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def OnCreateStatusBar(self, number, style, id, name) -> 'StatusBar':
        """ Virtual function called when a status bar is requested by CreateStatusBar .

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def OnCreateToolBar(self, style, id, name) -> 'ToolBar':
        """ Virtual function called when a toolbar is requested by CreateToolBar .

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def PopStatusText(self, number: int=0) -> None:
        """ number (int) â

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def ProcessCommand(self, id: int) -> bool:
        """ Simulate a menu command.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def PushStatusText(self, text, number=0) -> None:
        """ text (string) â

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def SetMenuBar(self, menuBar: 'MenuBar') -> None:
        """ Tells the frame to show the given menu bar.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def SetStatusBar(self, statusBar: 'StatusBar') -> None:
        """ Associates a status bar with the frame.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def SetStatusBarPane(self, n: int) -> None:
        """ Set the status bar pane used to display menu and toolbar help.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def SetStatusText(self, text, number=0) -> None:
        """ Sets the status bar text and updates the status bar display.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def SetStatusWidths(self, widths: list[int]) -> None:
        """ Sets the widths of the fields in the status bar.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    def SetToolBar(self, toolBar: 'ToolBar') -> None:
        """ Associates a toolbar with the frame.

            Source: https://docs.wxpython.org/wx.Frame.html
        """

    MenuBar: '_MenuBar'  # See GetMenuBar and SetMenuBar
    StatusBar: '_StatusBar'  # See GetStatusBar and SetStatusBar
    StatusBarPane: int  # See GetStatusBarPane and SetStatusBarPane
    ToolBar: '_ToolBar'  # See GetToolBar and SetToolBar



DEFAULT_FRAME_STYLE: int  # Defined as wx.MINIMIZE_BOX | wx.MAXIMIZE_BOX | wx.RESIZE_BORDER | wx.SYSTEM_MENU | wx.CAPTION | wx.CLOSE_BOX | wx.CLIP_CHILDREN.

ICONIZE: int  # Display the frame iconized (minimized). Windows only.

MINIMIZE: int  # Identical to wx.ICONIZE. Windows only.

MAXIMIZE: int  # Displays the frame maximized. Windows and GTK+ only.

FRAME_TOOL_WINDOW: int  # Causes a frame with a small title bar to be created; the frame does not appear in the taskbar under Windows or GTK+.

FRAME_NO_TASKBAR: int  # Creates an otherwise normal frame but it does not appear in the taskbar under Windows or GTK+ (note that it will minimize to the desktop window under Windows which may seem strange to the users and thus it might be better to use this style only without wx.MINIMIZE_BOX style). In wxGTK, the flag is respected only if the window manager supports _NET_WM_STATE_SKIP_TASKBAR hint.

FRAME_FLOAT_ON_PARENT: int  # The frame will always be on top of its parent (unlike wx.STAY_ON_TOP). A frame created with this style must have a not None parent.

FRAME_SHAPED: int  # Windows with this style are allowed to have their shape changed with the SetShape  method. ^^

EVT_ICONIZE: int  # Process a  wxEVT_ICONIZE   event. See    wx.IconizeEvent.

EVT_MENU_OPEN: int  # A menu is about to be opened. See   wx.MenuEvent.

EVT_MENU_CLOSE: int  # A menu has been just closed. See   wx.MenuEvent.

EVT_MENU_HIGHLIGHT: int  # The menu item with the specified id has been highlighted: used to show help prompts in the status bar by   wx.Frame. See   wx.MenuEvent.

EVT_MENU_HIGHLIGHT_ALL: int  # A menu item has been highlighted, i.e. the currently selected menu item has changed. See   wx.MenuEvent. ^^

FRAME_EX_CONTEXTHELP: int

FRAME_EX_METAL: int

class FSFile(Object):
    """ This class represents a single file opened by FileSystem.

        Source: https://docs.wxpython.org/wx.FSFile.html
    """
    def __init__(self, stream, location, mimetype, anchor, modif) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FSFile.html
        """

    def DetachStream(self) -> 'InputStream':
        """ Detaches the stream from the   wx.FSFile  object.

            Source: https://docs.wxpython.org/wx.FSFile.html
        """

    def GetAnchor(self) -> str:
        """ Returns anchor (if present).

            Source: https://docs.wxpython.org/wx.FSFile.html
        """

    def GetLocation(self) -> str:
        """ Returns full location of the file, including path and protocol.

            Source: https://docs.wxpython.org/wx.FSFile.html
        """

    def GetMimeType(self) -> str:
        """ Returns the MIME type of the content of this file.

            Source: https://docs.wxpython.org/wx.FSFile.html
        """

    def GetModificationTime(self) -> 'DateTime':
        """ Returns time when this file was modified.

            Source: https://docs.wxpython.org/wx.FSFile.html
        """

    def GetStream(self) -> 'InputStream':
        """ Returns pointer to the stream.

            Source: https://docs.wxpython.org/wx.FSFile.html
        """

    Anchor: str  # See GetAnchor
    Location: str  # See GetLocation
    MimeType: str  # See GetMimeType
    ModificationTime: 'DateTime'  # See GetModificationTime
    Stream: 'InputStream'  # See GetStream



class FullScreenEvent(Event):
    """ An event being sent when the user enters or exits full screen mode.

        Source: https://docs.wxpython.org/wx.FullScreenEvent.html
    """
    def __init__(self, id=0, fullscreen=True) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.FullScreenEvent.html
        """

    def IsFullScreen(self) -> bool:
        """ Returns True if the frame entered full screen, False if exited full screen.

            Source: https://docs.wxpython.org/wx.FullScreenEvent.html
        """



EVT_FULLSCREEN: int  # Process a  wxEVT_FULLSCREEN   event. ^^

class Gauge(Control):
    """ A gauge is a horizontal or vertical bar which shows a quantity (often
time).

        Source: https://docs.wxpython.org/wx.Gauge.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    def Create(self, parent, id=ID_ANY, range=100, pos=DefaultPosition, size=DefaultSize, style=GA_HORIZONTAL, validator=DefaultValidator, name=GaugeNameStr) -> bool:
        """ Creates the gauge for two-step construction.

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    def GetRange(self) -> int:
        """ Returns the maximum position of the gauge.

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    def GetValue(self) -> int:
        """ Returns the current position of the gauge.

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    def IsVertical(self) -> bool:
        """ Returns True if the gauge is vertical (has  GA_VERTICAL   style) and False otherwise.

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    def Pulse(self) -> None:
        """ Switch the gauge to indeterminate mode (if required) and makes the gauge move a bit to indicate the user that some progress has been made.

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    def SetRange(self, range: int) -> None:
        """ Sets the range (maximum value) of the gauge.

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    def SetValue(self, pos: int) -> None:
        """ Sets the position of the gauge.

            Source: https://docs.wxpython.org/wx.Gauge.html
        """

    Range: int  # See GetRange and SetRange
    Value: int  # See GetValue and SetValue



GA_HORIZONTAL: int  # Creates a horizontal gauge.

GA_VERTICAL: int  # Creates a vertical gauge.

GA_SMOOTH: int  # Creates smooth progress bar with one pixel wide update step (not supported by all platforms).

GA_TEXT: int  # Display the current value in percents in the gauge itself. This style is only supported in Qt and ignored under the other platforms. This flag is only available in wxWidgets 3.1.0 and later.

GA_PROGRESS: int  # Reflect the value of gauge in the application taskbar button under Windows 7 and later and the dock icon under macOS, ignored under the other platforms. This flag is only available in wxWidgets 3.1.0 and later. ^^

class GBPosition:
    """ This class represents the position of an item in a virtual grid of
rows and columns managed by a GridBagSizer.

        Source: https://docs.wxpython.org/wx.GBPosition.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def Get(self) -> tuple:
        """ Return the row and col properties as a tuple.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def GetCol(self) -> int:
        """ Get the current column value.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def GetIM(self) -> None:
        """ Returns an immutable representation of the wx.GBPosition object, based on namedtuple.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def GetRow(self) -> int:
        """ Get the current row value.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def Set(self, row=0, col=0) -> None:
        """ Set both the row and column properties.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def SetCol(self, col: int) -> None:
        """ Set a new column value.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def SetRow(self, row: int) -> None:
        """ Set a new row value.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __bool__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __getitem__(self, idx) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __len__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __nonzero__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __reduce__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __repr__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __setitem__(self, idx, val) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __str__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Compare inequality of two GBPositions.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Compare equality of two GBPositions.

            Source: https://docs.wxpython.org/wx.GBPosition.html
        """

    Col: int  # See GetCol and SetCol
    Row: int  # See GetRow and SetRow
    col: Any  # See GetCol and SetCol
    row: Any  # See GetRow and SetRow



class GridBagSizer(FlexGridSizer):
    """ A Sizer that can lay out items in a virtual grid like a
FlexGridSizer but in this case explicit positioning of the items is
allowed using GBPosition, and items can optionally span more than
one row and/or column using GBSpan.

        Source: https://docs.wxpython.org/wx.GridBagSizer.html
    """
    def __init__(self, vgap=0, hgap=0) -> None:
        """ Constructor, with optional parameters to specify the gap between the rows and columns.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def Add(self, *args, **kw) -> 'SizerItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def CalcMin(self) -> 'Size':
        """ Called when the managed size of the sizer is needed or when layout needs done.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def CheckForIntersection(self, *args, **kw) -> bool:
        """ Look at all items and see if any intersect (or would overlap) the given item.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def FindItem(self, *args, **kw) -> 'GBSizerItem':
        """ Find the sizer item for the given window or subsizer, returns None if not found.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def FindItemAtPoint(self, pt: Union[tuple[int, int], 'Point']) -> 'GBSizerItem':
        """ Return the sizer item located at the point given in pt, or None if there is no item at that point.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def FindItemAtPosition(self, pos: 'GBPosition') -> 'GBSizerItem':
        """ Return the sizer item for the given grid cell, or None if there is no item at that position.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def FindItemWithData(self, userData: 'Object') -> 'GBSizerItem':
        """ Return the sizer item that has a matching user data (it only compares pointer values) or None if not found.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def GetCellSize(self, row, col) -> 'Size':
        """ Get the size of the specified cell, including hgap and vgap.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def GetEmptyCellSize(self) -> 'Size':
        """ Get the size used for cells in the grid with no item.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def GetItemPosition(self, *args, **kw) -> 'GBPosition':
        """ Get the grid position of the specified item.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def GetItemSpan(self, *args, **kw) -> 'GBSpan':
        """ Get the row/col spanning of the specified item.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def RepositionChildren(self, minSize: Union[tuple[int, int], 'Size']) -> None:
        """ Called when the managed size of the sizer is needed or when layout needs done.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def SetEmptyCellSize(self, sz: Union[tuple[int, int], 'Size']) -> None:
        """ Set the size used for cells in the grid with no item.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def SetItemPosition(self, *args, **kw) -> bool:
        """ Set the grid position of the specified item.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    def SetItemSpan(self, *args, **kw) -> bool:
        """ Set the row/col spanning of the specified item.

            Source: https://docs.wxpython.org/wx.GridBagSizer.html
        """

    EmptyCellSize: 'Size'  # See GetEmptyCellSize and SetEmptyCellSize



class GBSizerItem(SizerItem):
    """ The GBSizerItem class is used by the GridBagSizer for tracking the
items in the sizer.

        Source: https://docs.wxpython.org/wx.GBSizerItem.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def GetEndPos(self) -> tuple:
        """ Get the row and column of the endpoint of this item.

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def GetGBSizer(self) -> 'GridBagSizer':
        """ wx.GridBagSizer

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def GetPos(self) -> 'GBPosition':
        """ Get the grid position of the item.

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def GetSpan(self) -> 'GBSpan':
        """ Get the row and column spanning of the item.

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def Intersects(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def SetGBSizer(self, sizer: 'GridBagSizer') -> None:
        """ sizer (wx.GridBagSizer) â

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def SetPos(self, pos: 'GBPosition') -> bool:
        """ If the item is already a member of a sizer then first ensure that there is no other item that would intersect with this one at the new position, then set the new position.

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    def SetSpan(self, span: 'GBSpan') -> bool:
        """ If the item is already a member of a sizer then first ensure that there is no other item that would intersect with this one with its new spanning size, then set the new spanning.

            Source: https://docs.wxpython.org/wx.GBSizerItem.html
        """

    GBSizer: 'GridBagSizer'  # See GetGBSizer and SetGBSizer
    Pos: 'GBPosition'  # See GetPos and SetPos
    Span: 'GBSpan'  # See GetSpan and SetSpan



class GBSpan:
    """ This class is used to hold the row and column spanning attributes of
items in a GridBagSizer.

        Source: https://docs.wxpython.org/wx.GBSpan.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def Get(self) -> tuple:
        """ Return the rowspan and colspan properties as a tuple.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def GetColspan(self) -> int:
        """ Get the current colspan value.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def GetIM(self) -> None:
        """ Returns an immutable representation of the wx.GBSpan object, based on namedtuple.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def GetRowspan(self) -> int:
        """ Get the current rowspan value.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def Set(self, rowspan=0, colspan=0) -> None:
        """ Set both the rowspan and colspan properties.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def SetColspan(self, colspan: int) -> None:
        """ Set a new colspan value.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def SetRowspan(self, rowspan: int) -> None:
        """ Set a new rowspan value.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __bool__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __getitem__(self, idx) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __len__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __nonzero__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __reduce__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __repr__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __setitem__(self, idx, val) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __str__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Compare inequality of two GBSpans.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Compare equality of two GBSpans.

            Source: https://docs.wxpython.org/wx.GBSpan.html
        """

    Colspan: int  # See GetColspan and SetColspan
    Rowspan: int  # See GetRowspan and SetRowspan
    colspan: Any  # See GetColspan and SetColspan
    rowspan: Any  # See GetRowspan and SetRowspan



class GCDC(DC):
    """ GCDC is a device context that draws on a GraphicsContext.

        Source: https://docs.wxpython.org/wx.GCDC.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GCDC.html
        """

    def GetGraphicsContext(self) -> 'GraphicsContext':
        """ Retrieves associated   wx.GraphicsContext.

            Source: https://docs.wxpython.org/wx.GCDC.html
        """

    def SetGraphicsContext(self, context: 'GraphicsContext') -> None:
        """ Set the graphics context to be used for this   wx.GCDC.

            Source: https://docs.wxpython.org/wx.GCDC.html
        """

    GraphicsContext: '_GraphicsContext'  # See GetGraphicsContext and SetGraphicsContext



_AntialiasMode: TypeAlias = AntialiasMode

_CompositionMode: TypeAlias = CompositionMode

_InterpolationQuality: TypeAlias = InterpolationQuality

class GraphicsContext(GraphicsObject):
    """ A GraphicsContext instance is the object that is drawn upon.

        Source: https://docs.wxpython.org/wx.GraphicsContext.html
    """
    def BeginLayer(self, opacity: 'Double') -> None:
        """ All rendering will be done into a fully transparent temporary context.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def Clip(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def ConcatTransform(self, matrix: 'GraphicsMatrix') -> None:
        """ Concatenates the passed in transform with the current transform of this context.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    @staticmethod
    def Create(*args, **kw) -> 'GraphicsContext':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateBitmap(self, bitmap: 'Bitmap') -> 'GraphicsBitmap':
        """ Creates   wx.GraphicsBitmap  from an existing   wx.Bitmap.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateBitmapFromImage(self, image: 'Image') -> 'GraphicsBitmap':
        """ Creates   wx.GraphicsBitmap  from an existing   wx.Image.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateBrush(self, brush: 'Brush') -> 'GraphicsBrush':
        """ Creates a native brush from a   wx.Brush.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateFont(self, *args, **kw) -> 'GraphicsFont':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    @staticmethod
    def CreateFromNative(context: Any) -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  from a native context.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    @staticmethod
    def CreateFromNativeWindow(window: Any) -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  from a native window.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    @staticmethod
    def CreateFromUnknownDC(dc: 'DC') -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  from a DC of unknown specific type.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateLinearGradientBrush(self, *args, **kw) -> 'GraphicsBrush':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateMatrix(self, *args, **kw) -> 'GraphicsMatrix':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreatePath(self) -> 'GraphicsPath':
        """ Creates a native graphics path which is initially empty.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreatePen(self, *args, **kw) -> 'GraphicsPen':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateRadialGradientBrush(self, *args, **kw) -> 'GraphicsBrush':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def CreateSubBitmap(self, bitmap, x, y, w, h) -> 'GraphicsBitmap':
        """ Extracts a sub-bitmap from an existing bitmap.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DisableOffset(self) -> None:
        """ Helper to determine if a 0.5 offset should be applied for the drawing operation.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawBitmap(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawEllipse(self, x, y, w, h) -> None:
        """ Draws an ellipse.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawIcon(self, icon, x, y, w, h) -> None:
        """ Draws the icon.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawLines(self, point2Ds, fillStyle=ODDEVEN_RULE) -> None:
        """ Draws a polygon.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawPath(self, path, fillStyle=ODDEVEN_RULE) -> None:
        """ Draws the path by first filling and then stroking.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawRectangle(self, x, y, w, h) -> None:
        """ Draws a rectangle.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawRoundedRectangle(self, x, y, w, h, radius) -> None:
        """ Draws a rounded rectangle.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def DrawText(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def EnableOffset(self, enable: bool=True) -> None:
        """ Indicates whether the context should try to offset for pixel boundaries.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def EndDoc(self) -> None:
        """ Done with that document (relevant only for printing / pdf etc.)

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def EndLayer(self) -> None:
        """ Composites back the drawings into the context with the opacity given at the BeginLayer   call.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def EndPage(self) -> None:
        """ Ends the current page (relevant only for printing / pdf etc.)

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def FillPath(self, path, fillStyle=ODDEVEN_RULE) -> None:
        """ Fills the path with the current brush.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def Flush(self) -> None:
        """ Make sure that the current content of this context is immediately visible.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def FromDIP(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetAntialiasMode(self) -> 'AntialiasMode':
        """ Returns the current shape antialiasing mode.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetClipBox(self, x, y, w, h) -> None:
        """ Returns bounding box of the current clipping region.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetCompositionMode(self) -> 'CompositionMode':
        """ Returns the current compositing operator.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetDPI(self) -> tuple:
        """ Returns the resolution of the graphics context in device points per inch.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetInterpolationQuality(self) -> 'InterpolationQuality':
        """ Returns the current interpolation quality.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetNativeContext(self) -> None:
        """ Returns the native context (CGContextRef for Core Graphics, Graphics pointer for GDIPlus and cairo_t pointer for cairo).

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetPartialTextExtents(self, text: str) -> list[float]:
        """ Fills the widths  array with the widths from the beginning of text  to the corresponding character of text.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetSize(self) -> tuple:
        """ Returns the size of the graphics context in device coordinates.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetFullTextExtent(self, *args, **kw) -> tuple:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetTransform(self) -> 'GraphicsMatrix':
        """ Gets the current transformation matrix of this context.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def GetWindow(self) -> 'Window':
        """ Returns the associated window if any.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def OffsetEnabled(self) -> bool:
        """ Helper to determine if a 0.5 offset should be applied for the drawing operation.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def PopState(self) -> None:
        """ Sets current state of the context to the state saved by a preceding call to PushState   and removes that state from the stack of saved states.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def PushState(self) -> None:
        """ Push the current state (like transformations, clipping region and quality settings) of the context on a stack.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def ResetClip(self) -> None:
        """ Resets the clipping to original shape.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def Rotate(self, angle: 'Double') -> None:
        """ Rotates the current transformation matrix (in radians).

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def Scale(self, xScale, yScale) -> None:
        """ Scales the current transformation matrix.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def SetAntialiasMode(self, antialias: AntialiasMode) -> bool:
        """ Sets the antialiasing mode, returns True if it supported.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def SetBrush(self, *args, **kw) -> None:
        """ Sets the brush for filling paths.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def SetCompositionMode(self, op: CompositionMode) -> bool:
        """ Sets the compositing operator, returns True if it supported.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def SetFont(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def SetInterpolationQuality(self, interpolation: InterpolationQuality) -> bool:
        """ Sets the interpolation quality, returns True if it is supported.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def SetPen(self, *args, **kw) -> None:
        """ Sets the pen used for stroking.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def SetTransform(self, matrix: 'GraphicsMatrix') -> None:
        """ Sets the current transformation matrix of this context.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def ShouldOffset(self) -> bool:
        """ Helper to determine if a 0.5 offset should be applied for the drawing operation.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def StartDoc(self, message: str) -> bool:
        """ Begin a new document (relevant only for printing / pdf etc.) If there is a progress dialog, message will be shown.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def StartPage(self, width=0, height=0) -> None:
        """ Opens a new page (relevant only for printing / pdf etc.) with the given size in points.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def StrokeLine(self, x1, y1, x2, y2) -> None:
        """ Strokes a single line.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def StrokeLineSegments(self, beginPoint2Ds, endPoint2Ds) -> None:
        """ Stroke disconnected lines from begin to end points.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def StrokeLines(self, point2Ds) -> None:
        """ Stroke lines connecting all the points.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def StrokePath(self, path: 'GraphicsPath') -> None:
        """ Strokes along a path with the current pen.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def ToDIP(self, *args, **kw) -> 'Size':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    def Translate(self, dx, dy) -> None:
        """ Translates the current transformation matrix.

            Source: https://docs.wxpython.org/wx.GraphicsContext.html
        """

    AntialiasMode: '_AntialiasMode'  # See GetAntialiasMode and SetAntialiasMode
    CompositionMode: '_CompositionMode'  # See GetCompositionMode and SetCompositionMode
    InterpolationQuality: '_InterpolationQuality'  # See GetInterpolationQuality and SetInterpolationQuality
    NativeContext: None  # See GetNativeContext
    TextExtent: Any  # See GetTextExtent
    Transform: 'GraphicsMatrix'  # See GetTransform and SetTransform
    Window: '_Window'  # See GetWindow



class GDIObject(Object):
    """ This class allows platforms to implement functionality to optimise GDI
objects, such as Pen, Brush and Font.

        Source: https://docs.wxpython.org/wx.GDIObject.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.GDIObject.html
        """



class Pen(GDIObject):
    """ A pen is a drawing tool for drawing outlines.

        Source: https://docs.wxpython.org/wx.Pen.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetCap(self) -> 'PenCap':
        """ Returns the pen cap style, which may be one of  CAP_ROUND ,   CAP_PROJECTING   and   CAP_BUTT .

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetColour(self) -> 'Colour':
        """ Returns a reference to the pen colour.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetDashes(self) -> list[int]:
        """ Gets an array of dashes (defined as  char   in X,   DWORD   under Windows).

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetJoin(self) -> 'PenJoin':
        """ Returns the pen join style, which may be one of  JOIN_BEVEL ,   JOIN_ROUND   and   JOIN_MITER .

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetQuality(self) -> 'PenQuality':
        """ Returns the pen quality.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetStipple(self) -> 'Bitmap':
        """ Gets a pointer to the stipple bitmap.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetStyle(self) -> 'PenStyle':
        """ Returns the pen style.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def GetWidth(self) -> int:
        """ Returns the pen width.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def IsNonTransparent(self) -> bool:
        """ Returns True if the pen is a valid non-transparent pen.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the pen is initialised.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def IsTransparent(self) -> bool:
        """ Returns True if the pen is transparent.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetCap(self, capStyle: PenCap) -> None:
        """ Sets the pen cap style, which may be one of  CAP_ROUND ,   CAP_PROJECTING   and   CAP_BUTT .

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetColour(self, *args, **kw) -> None:
        """ The penâs colour is changed to the given colour.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetDashes(self, dashes: list[int]) -> None:
        """ Associates an array of dash values (defined as  char   in X,   DWORD   under Windows) with the pen.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetJoin(self, join_style: PenJoin) -> None:
        """ Sets the pen join style, which may be one of  JOIN_BEVEL ,   JOIN_ROUND   and   JOIN_MITER .

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetQuality(self, quality: PenQuality) -> None:
        """ Sets the pen quality.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetStipple(self, stipple: 'Bitmap') -> None:
        """ Sets the bitmap for stippling.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetStyle(self, style: PenStyle) -> None:
        """ Set the pen style.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def SetWidth(self, width: int) -> None:
        """ Sets the pen width.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def _copyFrom(self, other) -> None:
        """ For internal use only.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Inequality operator.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Equality operator.

            Source: https://docs.wxpython.org/wx.Pen.html
        """

    Cap: 'PenCap'  # See GetCap and SetCap
    Colour: '_Colour'  # See GetColour and SetColour
    Dashes: list[int]  # See GetDashes and SetDashes
    Join: 'PenJoin'  # See GetJoin and SetJoin
    Quality: 'PenQuality'  # See GetQuality and SetQuality
    Stipple: 'Bitmap'  # See GetStipple and SetStipple
    Style: 'PenStyle'  # See GetStyle and SetStyle
    Width: int  # See GetWidth and SetWidth



PENSTYLE_TRANSPARENT: int

class GenericDirCtrl(Control):
    """ This control can be used to place a directory listing (with optional
files) on an arbitrary window.

        Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def CollapsePath(self, path: str) -> bool:
        """ Collapse the given path.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def CollapseTree(self) -> None:
        """ Collapses the entire tree.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def Create(self, parent, id=ID_ANY, dir=DirDialogDefaultFolderStr, pos=DefaultPosition, size=DefaultSize, style=DIRCTRL_DEFAULT_STYLE, filter="", defaultFilter=0, name=TreeCtrlNameStr) -> bool:
        """ Create function for two-step construction.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def ExpandPath(self, path: str) -> bool:
        """ Tries to expand as much of the given path  as possible, so that the filename or directory is visible in the tree control.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetDefaultPath(self) -> str:
        """ Gets the default path.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetFilePath(self) -> str:
        """ Gets selected filename path only (else empty string).

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetFilePaths(self, paths: list[str]) -> None:
        """ Fills the array paths  with the currently selected filepaths.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetFilter(self) -> str:
        """ Returns the filter string.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetFilterIndex(self) -> int:
        """ Returns the current filter index (zero-based).

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetFilterListCtrl(self) -> 'DirFilterListCtrl':
        """ Returns a pointer to the filter list control (if present).

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetPath(self, *args, **kw) -> str:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetPaths(self) -> list:
        """ Returns a list of the currently selected paths.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetRootId(self) -> 'TreeItemId':
        """ Returns the root id for the tree control.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def GetTreeCtrl(self) -> 'TreeCtrl':
        """ Returns a pointer to the tree control.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def Init(self) -> None:
        """ Initializes variables.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def ReCreateTree(self) -> None:
        """ Collapse and expand the tree, thus re-creating it from scratch.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def SelectPath(self, path, select=True) -> None:
        """ Selects the given item.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def SelectPaths(self, paths: list[str]) -> None:
        """ Selects only the specified paths, clearing any previous selection.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def SetDefaultPath(self, path: str) -> None:
        """ Sets the default path.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def SetFilter(self, filter: str) -> None:
        """ Sets the filter string.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def SetFilterIndex(self, n: int) -> None:
        """ Sets the current filter index (zero-based).

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def SetPath(self, path: str) -> None:
        """ Sets the current path.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def ShowHidden(self, show: bool) -> None:
        """ show (bool) â If True, hidden folders and files will be displayed by the control. If False, they will not be displayed.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    def UnselectAll(self) -> None:
        """ Removes the selection from all currently selected items.

            Source: https://docs.wxpython.org/wx.GenericDirCtrl.html
        """

    DefaultPath: str  # See GetDefaultPath and SetDefaultPath
    FilePath: str  # See GetFilePath
    Filter: str  # See GetFilter and SetFilter
    FilterIndex: int  # See GetFilterIndex and SetFilterIndex
    FilterListCtrl: 'DirFilterListCtrl'  # See GetFilterListCtrl
    Path: str  # See GetPath and SetPath
    Paths: list  # See GetPaths
    RootId: 'TreeItemId'  # See GetRootId
    TreeCtrl: '_TreeCtrl'  # See GetTreeCtrl



DIRCTRL_DIR_ONLY: int  # Only show directories, and not files.

DIRCTRL_3D_INTERNAL: int  # Use 3D borders for internal controls. This is the default.

DIRCTRL_SELECT_FIRST: int  # When setting the default path, select the first file in the directory.

DIRCTRL_SHOW_FILTERS: int  # Show the drop-down filter list.

DIRCTRL_EDIT_LABELS: int  # Allow the folder and file labels to be editable.

DIRCTRL_MULTIPLE: int  # Allows multiple files and folders to be selected. ^^

EVT_DIRCTRL_SELECTIONCHANGED: int  # Selected directory has changed. Processes a  wxEVT_DIRCTRL_SELECTIONCHANGED   event type. Notice that this event is generated even for the changes done by the program itself and not only those done by the user. Available since wxWidgets 2.9.5.

EVT_DIRCTRL_FILEACTIVATED: int  # The user activated a file by double-clicking or pressing Enter. Available since wxWidgets 2.9.5. ^^

class GenericDragImage(Object):
    """ This class is used when you wish to drag an object on the screen, and
a simple cursor is not enough.

        Source: https://docs.wxpython.org/wx.GenericDragImage.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def BeginDrag(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def DoDrawImage(self, dc, pos) -> bool:
        """ Draws the image on the device context with top-left corner at the given position.

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def EndDrag(self) -> bool:
        """ Call this when the drag has finished.

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def GetImageRect(self, pos: Union[tuple[int, int], 'Point']) -> 'Rect':
        """ Returns the rectangle enclosing the image, assuming that the image is drawn with its top-left corner at the given point.

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def Hide(self) -> bool:
        """ Hides the image.

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def Move(self, pt: Union[tuple[int, int], 'Point']) -> bool:
        """ Call this to move the image to a new position.

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def Show(self) -> bool:
        """ Shows the image.

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """

    def UpdateBackingFromWindow(self, windowDC, destDC, sourceRect, destRect) -> bool:
        """ Override this if you wish to draw the window contents to the backing bitmap yourself.

            Source: https://docs.wxpython.org/wx.GenericDragImage.html
        """



class GenericMessageDialog(Dialog):
    """ This class represents a dialog that shows a single or multi-line
message, with a choice of wx.OK, Yes, No and Cancel buttons.

        Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
    """
    def __init__(self, parent, message, caption=MessageBoxCaptionStr, style=OK|CENTRE, pos=DefaultPosition) -> None:
        """ Constructor specifying the message box properties.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def AddMessageDialogCheckBox(self, sizer: 'Sizer') -> None:
        """ Can be overridden to provide more contents for the dialog

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def AddMessageDialogDetails(self, sizer: 'Sizer') -> None:
        """ Can be overridden to provide more contents for the dialog

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetCancelLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetCaption(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetEffectiveIcon(self) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetExtendedMessage(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetHelpLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetMessage(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetMessageDialogStyle(self) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetNoLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetOKLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def GetYesLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def HasCustomLabels(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def SetExtendedMessage(self, extendedMessage: str) -> None:
        """ Sets the extended message for the dialog: this message is usually an extension of the short message specified in the constructor or set with SetMessage .

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def SetHelpLabel(self, help: MessageDialogButtonLabel) -> bool:
        """ Sets the label for the Help button.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def SetMessage(self, message: str) -> None:
        """ Sets the message shown by the dialog.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def SetOKCancelLabels(self, ok, cancel) -> bool:
        """ Overrides the default labels of the wx.OK and Cancel buttons.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def SetOKLabel(self, ok: MessageDialogButtonLabel) -> bool:
        """ Overrides the default label of the wx.OK button.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def SetYesNoCancelLabels(self, yes, no, cancel) -> bool:
        """ Overrides the default labels of the Yes, No and Cancel buttons.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def SetYesNoLabels(self, yes, no) -> bool:
        """ Overrides the default labels of the Yes and No buttons.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning one of wx.ID_OK, wx.ID_CANCEL, wx.ID_YES, wx.ID_NO or wx.ID_HELP.

            Source: https://docs.wxpython.org/wx.GenericMessageDialog.html
        """

    CancelLabel: str  # See GetCancelLabel
    Caption: str  # See GetCaption
    EffectiveIcon: int  # See GetEffectiveIcon
    ExtendedMessage: str  # See GetExtendedMessage and SetExtendedMessage
    HelpLabel: str  # See GetHelpLabel and SetHelpLabel
    Message: str  # See GetMessage and SetMessage
    MessageDialogStyle: int  # See GetMessageDialogStyle
    NoLabel: str  # See GetNoLabel
    OKLabel: str  # See GetOKLabel and SetOKLabel
    YesLabel: str  # See GetYesLabel



YES_NO: int  # Puts Yes and No buttons in the message box. It is recommended to always use  CANCEL   with this style as otherwise the message box wonât have a close button under wxMSW and the user will be forced to answer it.

CANCEL_DEFAULT: int  # Makes the âCancelâ button default, can only be used with  CANCEL . This style is currently not supported (and ignored) in wxOSX.

YES_DEFAULT: int  # Makes the âYesâ button default, this is the default behaviour and this flag exists solely for symmetry with  NO_DEFAULT .

OK_DEFAULT: int  # Makes the âwx.OKâ button default, this is the default behaviour and this flag exists solely for symmetry with  CANCEL_DEFAULT .

ICON_NONE: int  # Displays no icon in the dialog if possible (an icon might still be displayed if the current platform mandates its use). This style may be used to prevent the dialog from using the default icon based on  YES_NO   presence as explained in   ICON_QUESTION   and   ICON_INFORMATION   documentation below.

ICON_ERROR: int  # Displays an error icon in the dialog.

ICON_WARNING: int  # Displays a warning icon in the dialog. This style should be used for informative warnings or, in combination with  YES_NO   or   CANCEL , for questions that have potentially serious consequences (caution icon is used on macOS in this case).

ICON_QUESTION: int  # Displays a question mark symbol. This icon is automatically used with  YES_NO   so itâs usually unnecessary to specify it explicitly. This style is not supported for message dialogs under wxMSW when a task dialog is used to implement them (i.e. when running under Windows Vista or later) because  Microsoft guidelines  indicate that no icon should be used for routine confirmations. If it is specified, no icon will be displayed.

ICON_INFORMATION: int  # Displays an information symbol. This icon is used by default if  YES_NO   is not given so it is usually unnecessary to specify it explicitly.

ICON_EXCLAMATION: int  # Alias for  ICON_WARNING .

ICON_HAND: int  # Alias for  ICON_ERROR .

ICON_AUTH_NEEDED: int  # Displays an authentication needed symbol. This style is only supported for message dialogs under wxMSW when a task dialog is used to implement them (i.e. when running under Windows Vista or later). In other cases the default icon selection logic will be used. Note this can be combined with other styles to provide a fallback. For instance, using wx.ICON_AUTH_NEEDED | wx.ICON_QUESTION will show a shield symbol on Windows Vista or above and a question symbol on other platforms. Available since wxWidgets 2.9.5

CENTRE: int  # Centre the message box on its parent or on the screen if parent is not specified. Setting this style under MSW makes no differences as the dialog is always centered on the parent. ^^

class GenericProgressDialog(Dialog):
    """ This class represents a dialog that shows a short message and a
progress bar.

        Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
    """
    def __init__(self, title, message, maximum=100, parent=None, style=PD_AUTO_HIDE|PD_APP_MODAL) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def GetMessage(self) -> str:
        """ Returns the last message passed to the Update   function; if you always passed ââ to Update   then the message set through the constructor is returned.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def GetRange(self) -> int:
        """ Returns the maximum value of the progress meter, as passed to the constructor or  NOT_FOUND   if the dialog has no progress bar.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def GetValue(self) -> int:
        """ Returns the last value passed to the Update   function or  NOT_FOUND   if the dialog has no progress bar.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def Pulse(self, newmsg: str="") -> tuple:
        """ Like Update   but makes the gauge control run in indeterminate mode.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def Resume(self) -> None:
        """ Can be used to continue with the dialog, after the user had clicked the âAbortâ button.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def SetRange(self, maximum: int) -> None:
        """ Changes the maximum value of the progress meter given in the constructor.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def Update(self, value, newmsg="") -> tuple:
        """ Updates the dialog, setting the progress bar to the new value and updating the message if new one is specified.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def WasCancelled(self) -> bool:
        """ Returns True if the âCancelâ button was pressed.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    def WasSkipped(self) -> bool:
        """ Returns True if the âSkipâ button was pressed.

            Source: https://docs.wxpython.org/wx.GenericProgressDialog.html
        """

    Message: str  # See GetMessage
    Range: int  # See GetRange and SetRange
    Value: int  # See GetValue



PD_APP_MODAL: int  # Make the progress dialog application-modal, i.e. disable all application windows while it is shown. If this flag is not given, it is only âlocallyâ modal â

PD_AUTO_HIDE: int  # Causes the progress dialog to disappear from screen as soon as the maximum value of the progress meter has been reached. If this style is not present, the dialog will become a modal dialog (see wx.Dialog.ShowModal ) once the maximum value has been reached and wait for the user to dismiss it.

PD_SMOOTH: int  # Causes smooth progress of the gauge control (uses a   wx.Gauge  with the  GA_SMOOTH   style).

PD_CAN_ABORT: int  # This flag tells the dialog that it should have a âCancelâ button which the user may press. If this happens, the next call to Update  will return False.

PD_CAN_SKIP: int  # This flag tells the dialog that it should have a âSkipâ button which the user may press. If this happens, the next call to Update  will return True in its skip parameter.

PD_ELAPSED_TIME: int  # This flag tells the dialog that it should show elapsed time (since creating the dialog).

PD_ESTIMATED_TIME: int  # This flag tells the dialog that it should show estimated time.

PD_REMAINING_TIME: int  # This flag tells the dialog that it should show remaining time. ^^

class GenericStaticBitmap(Control):
    """ A static bitmap control displays a bitmap.

        Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    def Create(self, parent, id=ID_ANY, bitmap=NullBitmap, pos=DefaultPosition, size=DefaultSize, style=0, name=StaticBitmapNameStr) -> bool:
        """ Creation function, for two-step construction.

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    def GetBitmap(self) -> 'Bitmap':
        """ Returns the bitmap currently used in the control.

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    def GetIcon(self) -> 'Icon':
        """ Returns the icon currently used in the control.

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    def GetScaleMode(self) -> 'ScaleMode':
        """ Returns the scale mode currently used in the control.

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    def SetBitmap(self, label: 'BitmapBundle') -> None:
        """ Sets the bitmap label.

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    def SetIcon(self, label: 'Icon') -> None:
        """ Sets the label to the given icon.

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    def SetScaleMode(self, scaleMode: ScaleMode) -> None:
        """ Sets the scale mode.

            Source: https://docs.wxpython.org/wx.GenericStaticBitmap.html
        """

    Bitmap: '_Bitmap'  # See GetBitmap and SetBitmap
    Icon: '_Icon'  # See GetIcon and SetIcon



class GestureEvent(Event):
    """ This is the base class for all supported gesture events.

        Source: https://docs.wxpython.org/wx.GestureEvent.html
    """
    def __init__(self, winid=0, type=wxEVT_NULL) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.GestureEvent.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the position where the event took effect, in client coordinates: position of Pan event, center of zoom for Zoom event, center of rotation for Rotate event, center of box formed by 2 fingers for Two Finger Tap event and position of the pressed finger for Press and Tap Event.

            Source: https://docs.wxpython.org/wx.GestureEvent.html
        """

    def IsGestureEnd(self) -> bool:
        """ Returns True if the event was the last in a gesture sequence.

            Source: https://docs.wxpython.org/wx.GestureEvent.html
        """

    def IsGestureStart(self) -> bool:
        """ Returns True if the event was the first in a gesture sequence.

            Source: https://docs.wxpython.org/wx.GestureEvent.html
        """

    def SetGestureEnd(self, isEnd: bool=True) -> None:
        """ Sets the event to be the last in a gesture sequence.

            Source: https://docs.wxpython.org/wx.GestureEvent.html
        """

    def SetGestureStart(self, isStart: bool=True) -> None:
        """ Sets the event to be the first in a gesture sequence.

            Source: https://docs.wxpython.org/wx.GestureEvent.html
        """

    def SetPosition(self, pos: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the position where the event took effect, in client coordinates: position of Pan event, center of zoom for Zoom event, center of rotation for Rotate event.

            Source: https://docs.wxpython.org/wx.GestureEvent.html
        """

    Position: 'Point'  # See GetPosition and SetPosition



class GIFHandler(ImageHandler):
    """ This is the image handler for the GIF format.

        Source: https://docs.wxpython.org/wx.GIFHandler.html
    """
    def __init__(self) -> None:
        """ Default constructor for   wx.GIFHandler.

            Source: https://docs.wxpython.org/wx.GIFHandler.html
        """

    def DoCanRead(self, stream: 'InputStream') -> bool:
        """ Called to test if this handler can read an image from the given stream.

            Source: https://docs.wxpython.org/wx.GIFHandler.html
        """

    def LoadFile(self, image, stream, verbose=True, index=-1) -> bool:
        """ Loads an image from a stream, putting the resulting data into image.

            Source: https://docs.wxpython.org/wx.GIFHandler.html
        """

    def SaveAnimation(self, images, stream, verbose=True, delayMilliSecs=1000) -> bool:
        """ Save the animated gif.

            Source: https://docs.wxpython.org/wx.GIFHandler.html
        """

    def SaveFile(self, image, stream, verbose=True) -> bool:
        """ Saves an image in the output stream.

            Source: https://docs.wxpython.org/wx.GIFHandler.html
        """



class GraphicsBitmap(GraphicsObject):
    """ Represents a bitmap.

        Source: https://docs.wxpython.org/wx.GraphicsBitmap.html
    """
    def __init__(self) -> None:
        """ Default constructor creates an invalid bitmap.

            Source: https://docs.wxpython.org/wx.GraphicsBitmap.html
        """

    def ConvertToImage(self) -> 'Image':
        """ Return the contents of this bitmap as   wx.Image.

            Source: https://docs.wxpython.org/wx.GraphicsBitmap.html
        """

    def GetNativeBitmap(self) -> None:
        """ Return the pointer to the native bitmap data.

            Source: https://docs.wxpython.org/wx.GraphicsBitmap.html
        """

    NativeBitmap: None  # See GetNativeBitmap



class GraphicsBrush(GraphicsObject):
    """ A GraphicsBrush is a native representation of a brush.

        Source: https://docs.wxpython.org/wx.GraphicsBrush.html
    """


class GraphicsFont(GraphicsObject):
    """ A GraphicsFont is a native representation of a font.

        Source: https://docs.wxpython.org/wx.GraphicsFont.html
    """


class GraphicsGradientStop:
    """ Represents a single gradient stop in a collection of gradient stops as
represented by GraphicsGradientStops.

        Source: https://docs.wxpython.org/wx.GraphicsGradientStop.html
    """
    def __init__(self, col=TransparentColour, pos=0.) -> None:
        """ Creates a stop with the given colour and position.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStop.html
        """

    def GetColour(self) -> 'Colour':
        """ Return the stop colour.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStop.html
        """

    def GetPosition(self) -> float:
        """ Return the stop position.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStop.html
        """

    def SetColour(self, col: Union[int, str, 'Colour']) -> None:
        """ Change the stop colour.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStop.html
        """

    def SetPosition(self, pos: float) -> None:
        """ Change the stop position.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStop.html
        """

    Colour: '_Colour'  # See GetColour and SetColour
    Position: float  # See GetPosition and SetPosition



class GraphicsGradientStops:
    """ Represents a collection of GraphicGradientStop values for use with
CreateLinearGradientBrush and CreateRadialGradientBrush.

        Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
    """
    def __init__(self, startCol=TransparentColour, endCol=TransparentColour) -> None:
        """ Initializes the gradient stops with the given boundary colours.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def Add(self, *args, **kw) -> None:
        """ Add a new stop.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def GetCount(self) -> int:
        """ Returns the number of stops.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def GetEndColour(self) -> 'Colour':
        """ Returns the end colour.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def GetStartColour(self) -> 'Colour':
        """ Returns the start colour.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def Item(self, n: Any) -> 'GraphicsGradientStop':
        """ Returns the stop at the given index.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def SetEndColour(self, col: Union[int, str, 'Colour']) -> None:
        """ Set the end colour to col.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def SetStartColour(self, col: Union[int, str, 'Colour']) -> None:
        """ Set the start colour to col.

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def __getitem__(self, n) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    def __len__(self) -> 'SIP_SSIZE_T':
        """ SIP_SSIZE_T

            Source: https://docs.wxpython.org/wx.GraphicsGradientStops.html
        """

    Count: int  # See GetCount
    EndColour: 'Colour'  # See GetEndColour and SetEndColour
    StartColour: 'Colour'  # See GetStartColour and SetStartColour



class GraphicsMatrix(GraphicsObject):
    """ A GraphicsMatrix is a native representation of an affine matrix.

        Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
    """
    def Concat(self, t: 'GraphicsMatrix') -> None:
        """ Concatenates the matrix passed with the current matrix.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def Get(self) -> tuple:
        """ Returns the component values of the matrix via the argument pointers.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def GetNativeMatrix(self) -> None:
        """ Returns the native representation of the matrix.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def Invert(self) -> None:
        """ Inverts the matrix.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def IsEqual(self, t: 'GraphicsMatrix') -> bool:
        """ Returns True if the elements of the transformation matrix are equal.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def IsIdentity(self) -> bool:
        """ Return True if this is the identity matrix.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def Rotate(self, angle: 'Double') -> None:
        """ Rotates this matrix clockwise (in radians).

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def Scale(self, xScale, yScale) -> None:
        """ Scales this matrix.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def Set(self, a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> None:
        """ Sets the matrix to the respective values (default values are the identity matrix).

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def TransformDistance(self, dx, dy) -> tuple:
        """ Applies this matrix to a distance (ie.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def TransformPoint(self, x, y) -> tuple:
        """ Applies this matrix to a point.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    def Translate(self, dx, dy) -> None:
        """ Translates this matrix.

            Source: https://docs.wxpython.org/wx.GraphicsMatrix.html
        """

    NativeMatrix: None  # See GetNativeMatrix



class GraphicsObject(Object):
    """ This class is the superclass of native graphics objects like pens etc.

        Source: https://docs.wxpython.org/wx.GraphicsObject.html
    """
    def GetRenderer(self) -> 'GraphicsRenderer':
        """ Returns the renderer that was used to create this instance, or None if it has not been initialized yet.

            Source: https://docs.wxpython.org/wx.GraphicsObject.html
        """

    def IsNull(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.GraphicsObject.html
        """

    def IsOk(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.GraphicsObject.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.GraphicsObject.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.GraphicsObject.html
        """

    Renderer: 'GraphicsRenderer'  # See GetRenderer



class GraphicsPath(GraphicsObject):
    """ A GraphicsPath is a native representation of a geometric path.

        Source: https://docs.wxpython.org/wx.GraphicsPath.html
    """
    def AddArc(self, *args, **kw) -> None:
        """ Adds an arc of a circle.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddArcToPoint(self, x1, y1, x2, y2, r) -> None:
        """ Adds an arc (of a circle with radius r) that is tangent to the line connecting current point and (x1, y1) and to the line connecting (x1, y1) and (x2, y2).

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddCircle(self, x, y, r) -> None:
        """ Appends a circle around (x,`y`) with radius r  as a new closed subpath.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddCurveToPoint(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddEllipse(self, x, y, w, h) -> None:
        """ Appends an ellipse fitting into the passed in rectangle as a new closed subpath.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddLineToPoint(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddPath(self, path: 'GraphicsPath') -> None:
        """ Adds another path onto the current path.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddQuadCurveToPoint(self, cx, cy, x, y) -> None:
        """ Adds a quadratic bezier curve from the current point, using a control point and an end point.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddRectangle(self, x, y, w, h) -> None:
        """ Appends a rectangle as a new closed subpath.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def AddRoundedRectangle(self, x, y, w, h, radius) -> None:
        """ Appends a rounded rectangle as a new closed subpath.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def CloseSubpath(self) -> None:
        """ Closes the current sub-path.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def Contains(self, *args, **kw) -> None:
        """ True if the point is within the path.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def GetBox(self) -> 'Rect2D':
        """ Gets the bounding box enclosing all points (possibly including control points).

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def GetCurrentPoint(self) -> 'Point2D':
        """ Gets the last point of the current path, (0,0) if not yet set.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def GetNativePath(self) -> None:
        """ Returns the native path (CGPathRef for Core Graphics, Path pointer for GDIPlus and a cairo_path_t pointer for cairo).

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def MoveToPoint(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def Transform(self, matrix: 'GraphicsMatrix') -> None:
        """ Transforms each point of this path by the matrix.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    def UnGetNativePath(self, p: Any) -> None:
        """ Gives back the native path returned by GetNativePath   because there might be some deallocations necessary (e.g.

            Source: https://docs.wxpython.org/wx.GraphicsPath.html
        """

    Box: 'Rect2D'  # See GetBox
    CurrentPoint: 'Point2D'  # See GetCurrentPoint
    NativePath: None  # See GetNativePath



class GraphicsPen(GraphicsObject):
    """ A GraphicsPen is a native representation of a pen.

        Source: https://docs.wxpython.org/wx.GraphicsPen.html
    """


_GradientType: TypeAlias = GradientType

class GraphicsPenInfo:
    """ This class is a helper used for GraphicsPen creation using named
parameter idiom: it allows specifying various GraphicsPen attributes
using the chained calls to its clearly named methods instead of
passing them in the fixed order to GraphicsPen constructors.

        Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
    """
    def __init__(*args, **kwargs) -> None:
        """ colour (wx.Colour) â

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def Cap(self, cap: PenCap) -> 'GraphicsPenInfo':
        """ cap (PenCap) â

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def Colour(self, col: Union[int, str, 'Colour']) -> 'GraphicsPenInfo':
        """ col (wx.Colour) â

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetCap(self) -> 'PenCap':
        """ wx.PenCap

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetColour(self) -> 'Colour':
        """ wx.Colour

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetEndX(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetEndY(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetGradientType(self) -> 'GradientType':
        """ wx.GradientType

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetJoin(self) -> 'PenJoin':
        """ wx.PenJoin

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetRadius(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetStartX(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetStartY(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetStipple(self) -> 'Bitmap':
        """ wx.Bitmap

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetStops(self) -> 'GraphicsGradientStops':
        """ wx.GraphicsGradientStops

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetStyle(self) -> 'PenStyle':
        """ wx.PenStyle

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetWidth(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetX1(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetX2(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetY1(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def GetY2(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def IsTransparent(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def Join(self, join: PenJoin) -> 'GraphicsPenInfo':
        """ join (PenJoin) â

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def LinearGradient(self, *args, **kw) -> 'GraphicsPenInfo':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def RadialGradient(self, *args, **kw) -> 'GraphicsPenInfo':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def Stipple(self, stipple: 'Bitmap') -> 'GraphicsPenInfo':
        """ stipple (wx.Bitmap) â

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def Style(self, style: PenStyle) -> 'GraphicsPenInfo':
        """ style (PenStyle) â

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    def Width(self, width: 'Double') -> 'GraphicsPenInfo':
        """ width (wx.Double) â

            Source: https://docs.wxpython.org/wx.GraphicsPenInfo.html
        """

    EndX: 'Double'  # See GetEndX
    EndY: 'Double'  # See GetEndY
    GradientType: '_GradientType'  # See GetGradientType
    Radius: 'Double'  # See GetRadius
    StartX: 'Double'  # See GetStartX
    StartY: 'Double'  # See GetStartY
    Stops: 'GraphicsGradientStops'  # See GetStops
    X1: 'Double'  # See GetX1
    X2: 'Double'  # See GetX2
    Y1: 'Double'  # See GetY1
    Y2: 'Double'  # See GetY2



class GraphicsRenderer(Object):
    """ A GraphicsRenderer is the instance corresponding to the rendering
engine used.

        Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
    """
    def CreateBitmap(self, bitmap: 'Bitmap') -> 'GraphicsBitmap':
        """ Creates   wx.GraphicsBitmap  from an existing   wx.Bitmap.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateBitmapFromImage(self, image: 'Image') -> 'GraphicsBitmap':
        """ Creates   wx.GraphicsBitmap  from an existing   wx.Image.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateBitmapFromNativeBitmap(self, bitmap: Any) -> 'GraphicsBitmap':
        """ Creates   wx.GraphicsBitmap  from a native bitmap handle.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateBrush(self, brush: 'Brush') -> 'GraphicsBrush':
        """ Creates a native brush from a   wx.Brush.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateContext(self, *args, **kw) -> 'GraphicsContext':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateContextFromImage(self, image: 'Image') -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  associated with a   wx.Image.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateContextFromNativeContext(self, context: Any) -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  from a native context.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateContextFromNativeWindow(self, window: Any) -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  from a native window.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateContextFromUnknownDC(self, dc: 'DC') -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  from a DC of unknown specific type.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateFont(self, *args, **kw) -> 'GraphicsFont':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateFontAtDPI(self, font, dpi, col=BLACK) -> 'GraphicsFont':
        """ Creates a native graphics font from a   wx.Font  and a text colour.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateImageFromBitmap(self, bmp: 'GraphicsBitmap') -> 'Image':
        """ Creates a   wx.Image  from a   wx.GraphicsBitmap.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateLinearGradientBrush(self, x1, y1, x2, y2, stops, matrix=NullGraphicsMatrix) -> 'GraphicsBrush':
        """ Creates a native brush with a linear gradient.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateMatrix(self, a=1.0, b=0.0, c=0.0, d=1.0, tx=0.0, ty=0.0) -> 'GraphicsMatrix':
        """ Creates a native affine transformation matrix from the passed in values.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateMeasuringContext(self) -> 'GraphicsContext':
        """ Creates a   wx.GraphicsContext  that can be used for measuring texts only.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreatePath(self) -> 'GraphicsPath':
        """ Creates a native graphics path which is initially empty.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreatePen(self, info: 'GraphicsPenInfo') -> 'GraphicsPen':
        """ Creates a native pen from its description.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateRadialGradientBrush(self, startX, startY, endX, endY, radius, stops, matrix=NullGraphicsMatrix) -> 'GraphicsBrush':
        """ Creates a native brush with a radial gradient.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def CreateSubBitmap(self, bitmap, x, y, w, h) -> 'GraphicsBitmap':
        """ Extracts a sub-bitmap from an existing bitmap.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    @staticmethod
    def GetCairoRenderer() -> 'GraphicsRenderer':
        """ Returns Cairo renderer.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    @staticmethod
    def GetDefaultRenderer() -> 'GraphicsRenderer':
        """ Returns the default renderer on this platform.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    @staticmethod
    def GetDirect2DRenderer() -> 'GraphicsRenderer':
        """ Returns Direct2D renderer (MSW and Python3 only).

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    @staticmethod
    def GetGDIPlusRenderer() -> 'GraphicsRenderer':
        """ Returns GDI+ renderer (MSW only).

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def GetName(self) -> str:
        """ Returns the name of the technology used by the renderer.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def GetType(self) -> None:
        """ Returns the name of the GraphicsRenderer class.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    def GetVersion(self, major, minor=None, micro=None) -> None:
        """ Returns the version major, minor and micro/build of the technology used by the renderer.

            Source: https://docs.wxpython.org/wx.GraphicsRenderer.html
        """

    Name: str  # See GetName
    Type: None  # See GetType



class Sizer(Object):
    """ Sizer is the abstract base class used for laying out subwindows in a
window.

        Source: https://docs.wxpython.org/wx.Sizer.html
    """
    def __init__(self) -> None:
        """ The constructor.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Add(self, *args, **kw) -> 'SizerItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def AddMany(self, items) -> None:
        """ AddMany is a convenience method for adding several items to a sizer
at one time. Simply pass it a list of tuples, where each tuple
consists of the parameters that you would normally pass to the Add
method.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def AddSpacer(self, size: int) -> 'SizerItem':
        """ This base function adds non-stretchable space to both the horizontal and vertical orientation of the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def AddStretchSpacer(self, prop: int=1) -> 'SizerItem':
        """ Adds stretchable space to the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def CalcMin(self) -> 'Size':
        """ This method is abstract and has to be overwritten by any derived class.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Clear(self, delete_windows: bool=False) -> None:
        """ Detaches all children from the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def ComputeFittingClientSize(self, window: 'Window') -> 'Size':
        """ Computes client area size for window  so that it matches the sizerâs minimal size.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def ComputeFittingWindowSize(self, window: 'Window') -> 'Size':
        """ Like ComputeFittingClientSize , but converts the result into window size.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Detach(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Fit(self, window: 'Window') -> 'Size':
        """ Tell the sizer to resize the window  so that its client area matches the sizerâs minimal size ( ComputeFittingClientSize   is called to determine it).

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def FitInside(self, window: 'Window') -> None:
        """ Tell the sizer to resize the virtual size of the window  to match the sizerâs minimal size.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetChildren(self) -> 'SizerItemList':
        """ Returns the list of the items in this sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetContainingWindow(self) -> 'Window':
        """ Returns the window this sizer is used in or None if none.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetItem(self, *args, **kw) -> 'SizerItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetItemById(self, id, recursive=False) -> 'SizerItem':
        """ Finds the item in the sizer which has the given id.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetItemCount(self) -> int:
        """ Returns the number of items in the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetMinSize(self) -> 'Size':
        """ Returns the minimal size of the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the current position of the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def GetSize(self) -> 'Size':
        """ Returns the current size of the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Hide(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def InformFirstDirection(self, direction, size, availableOtherDir) -> bool:
        """ Inform sizer about the first direction that has been decided (by parent item).

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Insert(self, *args, **kw) -> 'SizerItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def InsertSpacer(self, index, size) -> 'SizerItem':
        """ Inserts non-stretchable space to the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def InsertStretchSpacer(self, index, prop=1) -> 'SizerItem':
        """ Inserts stretchable space to the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def IsEmpty(self) -> bool:
        """ Return True if the sizer has no elements.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def IsShown(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Layout(self) -> None:
        """ Call this to force layout of the children anew, e.g. after having added a child to or removed a child (window, other sizer or space) from the sizer while keeping the current dimension.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Prepend(self, *args, **kw) -> 'SizerItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def PrependSpacer(self, size: int) -> 'SizerItem':
        """ Prepends non-stretchable space to the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def PrependStretchSpacer(self, prop: int=1) -> 'SizerItem':
        """ Prepends stretchable space to the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def RecalcSizes(self) -> None:
        """ This is a deprecated version of RepositionChildren()

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Remove(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Replace(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def RepositionChildren(self, minSize: Union[tuple[int, int], 'Size']) -> None:
        """ Method which must be overridden in the derived sizer classes.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def SetContainingWindow(self, window: 'Window') -> None:
        """ Set the window this sizer is used in.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def SetDimension(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def SetItemMinSize(self, *args, **kw) -> None:
        """ Set an itemâs minimum size by window, sizer, or position.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def SetMinSize(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def SetSizeHints(self, window: 'Window') -> None:
        """ This method first calls Fit   and then wx.TopLevelWindow.SetSizeHints   on the window  passed to it.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def Show(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def ShowItems(self, show: bool) -> None:
        """ Show or hide all items managed by the sizer.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def __iter__(self) -> None:
        """ A Python convenience method that allows Sizers to act as iterables that will yield their wx.SizerItems.

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    def __nonzero__(self) -> None:
        """ Can be used to test if the C++ part of the sizer still exists, with
code like this:

            Source: https://docs.wxpython.org/wx.Sizer.html
        """

    Children: 'SizerItemList'  # See GetChildren
    ContainingWindow: 'Window'  # See GetContainingWindow and SetContainingWindow
    ItemCount: int  # See GetItemCount
    MinSize: 'Size'  # See GetMinSize and SetMinSize
    Position: 'Point'  # See GetPosition
    Size: '_Size'  # See GetSize



ALL: int

EXPAND: int

SHAPED: int

FIXED_MINSIZE: int

RESERVE_SPACE_EVEN_IF_HIDDEN: int

ALIGN_CENTER: int

ALIGN_CENTRE: int

ALIGN_LEFT: int

ALIGN_TOP: int

ALIGN_BOTTOM: int

ALIGN_CENTER_VERTICAL: int

ALIGN_CENTRE_VERTICAL: int

ALIGN_CENTER_HORIZONTAL: int

ALIGN_CENTRE_HORIZONTAL: int

class GUIEventLoop(EventLoopBase):
    """ A generic implementation of the GUI event loop.

        Source: https://docs.wxpython.org/wx.GUIEventLoop.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.GUIEventLoop.html
        """



class HeaderButtonParams:
    """ This struct can optionally be used with
RendererNative.DrawHeaderButton() to specify custom values used to
draw the text or bitmap label.

        Source: https://docs.wxpython.org/wx.HeaderButtonParams.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.HeaderButtonParams.html
        """

    m_arrowColour: Any  # A public C++ attribute of type Colour     .
    m_labelAlignment: Any  # A public C++ attribute of type int.
    m_labelBitmap: Any  # A public C++ attribute of type Bitmap     .
    m_labelColour: Any  # A public C++ attribute of type Colour     .
    m_labelFont: Any  # A public C++ attribute of type Font     .
    m_labelText: Any  # A public C++ attribute of type string.
    m_selectionColour: Any  # A public C++ attribute of type Colour     .



_BitmapBundle: TypeAlias = BitmapBundle

class HeaderColumn:
    """ Represents a column header in controls displaying tabular data such as
DataViewCtrl or Grid.

        Source: https://docs.wxpython.org/wx.HeaderColumn.html
    """
    def GetAlignment(self) -> int:
        """ Returns the current column alignment.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def GetBitmap(self) -> 'Bitmap':
        """ This function exists only for backwards compatibility, itâs recommended to override GetBitmapBundle   in the new code and override this one to do nothing, as it will never be called if GetBitmapBundle   is overridden.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def GetBitmapBundle(self) -> 'BitmapBundle':
        """ Returns the bitmap in the header of the column, if any.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def GetFlags(self) -> int:
        """ Get the column flags.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def GetMinWidth(self) -> int:
        """ Return the minimal column width.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def GetTitle(self) -> str:
        """ Get the text shown in the column header.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def GetWidth(self) -> int:
        """ Returns the current width of the column.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def HasFlag(self, flag: int) -> bool:
        """ Return True if the specified flag is currently set for this column.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def IsHidden(self) -> bool:
        """ Returns True if the column is currently hidden.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def IsReorderable(self) -> bool:
        """ Returns True if the column can be dragged by user to change its order.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def IsResizeable(self) -> bool:
        """ Return True if the column can be resized by the user.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def IsShown(self) -> bool:
        """ Returns True if the column is currently shown.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def IsSortKey(self) -> bool:
        """ Returns True if the column is currently used for sorting.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def IsSortOrderAscending(self) -> bool:
        """ Returns True, if the sort order is ascending.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    def IsSortable(self) -> bool:
        """ Returns True if the column can be clicked by user to sort the control contents by the field in this column.

            Source: https://docs.wxpython.org/wx.HeaderColumn.html
        """

    Alignment: int  # See GetAlignment
    Bitmap: '_Bitmap'  # See GetBitmap
    BitmapBundle: '_BitmapBundle'  # See GetBitmapBundle
    Flags: int  # See GetFlags
    Hidden: Any  # See IsHidden
    MinWidth: int  # See GetMinWidth
    Reorderable: Any  # See IsReorderable
    Resizeable: Any  # See IsResizeable
    Shown: Any  # See IsShown
    SortKey: Any  # See IsSortKey
    SortOrderAscending: Any  # See IsSortOrderAscending
    Sortable: Any  # See IsSortable
    Title: str  # See GetTitle
    Width: int  # See GetWidth



COL_WIDTH_DEFAULT: int

COL_WIDTH_AUTOSIZE: int

COL_HIDDEN: int

COL_REORDERABLE: int

COL_SORTABLE: int

class HeaderColumnSimple(SettableHeaderColumn):
    """ Simple container for the information about the column.

        Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Constructor for a column header.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def GetAlignment(self) -> int:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def GetBitmap(self) -> 'Bitmap':
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def GetBitmapBundle(self) -> 'BitmapBundle':
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def GetFlags(self) -> int:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def GetMinWidth(self) -> int:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def GetTitle(self) -> str:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def GetWidth(self) -> int:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def IsSortKey(self) -> bool:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def IsSortOrderAscending(self) -> bool:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def SetAlignment(self, align: int) -> None:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def SetBitmap(self, bitmap: 'BitmapBundle') -> None:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def SetFlags(self, flags: int) -> None:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def SetMinWidth(self, minWidth: int) -> None:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def SetSortOrder(self, ascending: bool) -> None:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def SetTitle(self, title: str) -> None:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    def SetWidth(self, width: int) -> None:
        """ Trivial implementations of the base class pure virtual functions.

            Source: https://docs.wxpython.org/wx.HeaderColumnSimple.html
        """

    Alignment: int  # See GetAlignment and SetAlignment
    Bitmap: '_Bitmap'  # See GetBitmap and SetBitmap
    BitmapBundle: '_BitmapBundle'  # See GetBitmapBundle
    Flags: int  # See GetFlags and SetFlags
    MinWidth: int  # See GetMinWidth and SetMinWidth
    Title: str  # See GetTitle and SetTitle
    Width: int  # See GetWidth and SetWidth



class HeaderCtrl(Control):
    """ HeaderCtrl is the control containing the column headings which is
usually used for display of tabular data.

        Source: https://docs.wxpython.org/wx.HeaderCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def AddColumnsItems(self, menu, idColumnsBase=0) -> None:
        """ Helper function appending the checkable items corresponding to all the columns to the given menu.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def Create(self, parent, winid=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=HD_DEFAULT_STYLE, name=HeaderCtrlNameStr) -> bool:
        """ Create the header control window.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def GetColumn(self, idx: int) -> 'HeaderColumn':
        """ Method to be implemented by the derived classes to return the information for the given column.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def GetColumnAt(self, pos: int) -> int:
        """ Return the index of the column displayed at the given position.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def GetColumnCount(self) -> int:
        """ Return the number of columns in the control.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def GetColumnPos(self, idx: int) -> int:
        """ Get the position at which this column is currently displayed.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def GetColumnTitleWidth(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def GetColumnsOrder(self) -> list[int]:
        """ Return the array describing the columns display order.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def IsEmpty(self) -> bool:
        """ Return whether the control has any columns.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    @staticmethod
    def MoveColumnInOrderArray(order, idx, pos) -> None:
        """ Helper function to manipulate the array of column indices.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def OnColumnCountChanging(self, count: int) -> None:
        """ Can be overridden in the derived class to update internal data structures when the number of the columns in the control changes.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def ResetColumnsOrder(self) -> None:
        """ Reset the columns order to the natural one.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def SetColumnCount(self, count: int) -> None:
        """ Set the number of columns in the control.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def SetColumnsOrder(self, order: list[int]) -> None:
        """ Change the columns display order.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def ShowColumnsMenu(self, pt, title="") -> bool:
        """ Show the popup menu allowing the user to show or hide the columns.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def ShowCustomizeDialog(self) -> bool:
        """ Show the column customization dialog.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def UpdateColumn(self, idx: int) -> None:
        """ Update the column with the given index.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def UpdateColumnVisibility(self, idx, show) -> None:
        """ Method called when the column visibility is changed by the user.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def UpdateColumnWidthToFit(self, idx, widthTitle) -> bool:
        """ Method which may be implemented by the derived classes to allow double clicking the column separator to resize the column to fit its contents.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    def UpdateColumnsOrder(self, order: list[int]) -> None:
        """ Method called when the columns order is changed in the customization dialog.

            Source: https://docs.wxpython.org/wx.HeaderCtrl.html
        """

    ColumnCount: int  # See GetColumnCount and SetColumnCount
    ColumnsOrder: list[int]  # See GetColumnsOrder and SetColumnsOrder



HD_ALLOW_REORDER: int  # If this style is specified (it is by default), the user can reorder the control columns by dragging them.

HD_ALLOW_HIDE: int  # If this style is specified, the control shows a popup menu allowing the user to change the columns visibility on right mouse click. Notice that the program can always hide or show the columns, this style only affects the users capability to do it.

HD_BITMAP_ON_RIGHT: int  # The column image, if any, will be shown on the right side if this style is used. Note that this style is only implemented in wxMSW currently and doesnât do anything under the other platforms. It is available since wxWidgets 3.1.1.

HD_DEFAULT_STYLE: int  # Symbolic name for the default control style, currently equal to  HD_ALLOW_REORDER . ^^

EVT_HEADER_CLICK: int  # A column heading was clicked.

EVT_HEADER_RIGHT_CLICK: int  # A column heading was right clicked.

EVT_HEADER_MIDDLE_CLICK: int  # A column heading was clicked with the middle mouse button.

EVT_HEADER_DCLICK: int  # A column heading was double clicked.

EVT_HEADER_RIGHT_DCLICK: int  # A column heading was right double clicked.

EVT_HEADER_MIDDLE_DCLICK: int  # A column heading was double clicked with the middle mouse button.

EVT_HEADER_SEPARATOR_DCLICK: int  # Separator to the right of the specified column was double clicked (this action is commonly used to resize the column to fit its contents width and the control provides UpdateColumnWidthToFit  method to make implementing this easier).

EVT_HEADER_BEGIN_RESIZE: int  # The user started to drag the separator to the right of the column with the specified index (this can only happen for the columns for which wx.HeaderColumn.IsResizeable   returns True). The event can be vetoed to prevent the column from being resized. If it isnât, the resizing and end resize (or dragging cancelled) events will be generated later.

EVT_HEADER_RESIZING: int  # The user is dragging the column with the specified index resizing it and its current width is wx.HeaderCtrlEvent.GetWidth . The event can be vetoed to stop the dragging operation completely at any time.

EVT_HEADER_END_RESIZE: int  # The user stopped dragging the column by releasing the mouse. The column should normally be resized to the value of wx.HeaderCtrlEvent.GetWidth .

EVT_HEADER_BEGIN_REORDER: int  # The user started to drag the column with the specified index (this can only happen for the controls with wx.HD_ALLOW_REORDER style). This event can be vetoed to prevent the column from being reordered, otherwise the end reorder message will be generated later.

EVT_HEADER_END_REORDER: int  # The user dropped the column in its new location. The event can be vetoed to prevent the column from being placed at the new position or handled to update the display of the data in the associated control to match the new column location (available from wx.HeaderCtrlEvent.GetNewOrder ).

EVT_HEADER_DRAGGING_CANCELLED: int  # The resizing or reordering operation currently in progress was cancelled. This can happen if the user pressed Esc key while dragging the mouse or the mouse capture was lost for some other reason. You only need to handle this event if your application entered into some modal mode when resizing or reordering began, in which case it should handle this event in addition to the matching end resizing or reordering ones. ^^

class HeaderCtrlEvent(NotifyEvent):
    """ Event class representing the events generated by HeaderCtrl.

        Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
        """

    def GetColumn(self) -> int:
        """ Return the index of the column affected by this event.

            Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
        """

    def GetNewOrder(self) -> int:
        """ Return the new order of the column.

            Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
        """

    def GetWidth(self) -> int:
        """ Return the current width of the column.

            Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
        """

    def SetColumn(self, col: int) -> None:
        """ col (int) â

            Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
        """

    def SetNewOrder(self, order: int) -> None:
        """ order (int) â

            Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
        """

    def SetWidth(self, width: int) -> None:
        """ width (int) â

            Source: https://docs.wxpython.org/wx.HeaderCtrlEvent.html
        """

    Column: int  # See GetColumn and SetColumn
    NewOrder: int  # See GetNewOrder and SetNewOrder
    Width: int  # See GetWidth and SetWidth



class HeaderCtrlSimple(HeaderCtrl):
    """ HeaderCtrlSimple is a concrete header control which can be used
directly, without inheriting from it as you need to do when using
HeaderCtrl itself.

        Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def AppendColumn(self, col: 'HeaderColumnSimple') -> None:
        """ Append the column to the end of the control.

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def DeleteColumn(self, idx: int) -> None:
        """ Delete the column at the given position.

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def GetBestFittingWidth(self, idx: int) -> int:
        """ This function can be overridden in the classes deriving from this control instead of overriding UpdateColumnWidthToFit .

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def HideColumn(self, idx: int) -> None:
        """ Hide the column with the given index.

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def InsertColumn(self, col, idx) -> None:
        """ Insert the column at the given position.

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def RemoveSortIndicator(self) -> None:
        """ Remove the sort indicator from the column being used as sort key.

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def ShowColumn(self, idx, show=True) -> None:
        """ Show or hide the column.

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """

    def ShowSortIndicator(self, idx, sortOrder=True) -> None:
        """ Update the column sort indicator.

            Source: https://docs.wxpython.org/wx.HeaderCtrlSimple.html
        """



class HelpControllerBase(Object):
    """ This is the abstract base class a family of classes by which
applications may invoke a help viewer to provide on-line help.

        Source: https://docs.wxpython.org/wx.HelpControllerBase.html
    """
    def __init__(self, parentWindow: Optional['Window']=None) -> None:
        """ Constructs a help instance object, but does not invoke the help viewer.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def DisplayBlock(self, blockNo: int) -> bool:
        """ If the help viewer is not running, runs it and displays the file at the given block number.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def DisplayContents(self) -> bool:
        """ If the help viewer is not running, runs it and displays the contents.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def DisplayContextPopup(self, contextId: int) -> bool:
        """ Displays the section as a popup window using a context id.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def DisplaySection(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def DisplayTextPopup(self, text, pos) -> bool:
        """ Displays the text in a popup window, if possible.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def GetFrameParameters(self) -> tuple:
        """ For   wx.html.HtmlHelpController, returns the latest frame size and position settings and whether a new frame is drawn with each invocation.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def GetParentWindow(self) -> 'Window':
        """ Returns the window to be used as the parent for the help window.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def Initialize(self, file: str) -> bool:
        """ Initializes the help instance with a help filename.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def KeywordSearch(self, keyWord, mode=HELP_SEARCH_ALL) -> bool:
        """ If the help viewer is not running, runs it, and searches for sections matching the given keyword.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def LoadFile(self, file: str="") -> bool:
        """ If the help viewer is not running, runs it and loads the given file.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def OnQuit(self) -> None:
        """ Overridable member called when this applicationâs viewer is quit by the user.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def Quit(self) -> bool:
        """ If the viewer is running, quits it by disconnecting.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def SetFrameParameters(self, titleFormat, size, pos=DefaultPosition, newFrameEachTime=False) -> None:
        """ Set the parameters of the frame window.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def SetParentWindow(self, parentWindow: 'Window') -> None:
        """ Sets the window to be used as the parent for the help window.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    def SetViewer(self, viewer, flags=HELP_NETSCAPE) -> None:
        """ Sets detailed viewer information.

            Source: https://docs.wxpython.org/wx.HelpControllerBase.html
        """

    FrameParameters: tuple  # See GetFrameParameters and SetFrameParameters
    ParentWindow: 'Window'  # See GetParentWindow and SetParentWindow



HELP_NETSCAPE: int

class HelpControllerHelpProvider(SimpleHelpProvider):
    """ HelpControllerHelpProvider is an implementation of HelpProvider
which supports both context identifiers and plain text help strings.

        Source: https://docs.wxpython.org/wx.HelpControllerHelpProvider.html
    """
    def __init__(self, hc: Optional['HelpControllerBase']=None) -> None:
        """ Note that the instance doesnât own the help controller.

            Source: https://docs.wxpython.org/wx.HelpControllerHelpProvider.html
        """

    def GetHelpController(self) -> 'HelpControllerBase':
        """ Returns the help controller associated with this help provider.

            Source: https://docs.wxpython.org/wx.HelpControllerHelpProvider.html
        """

    def SetHelpController(self, hc: 'HelpControllerBase') -> None:
        """ Sets the help controller associated with this help provider.

            Source: https://docs.wxpython.org/wx.HelpControllerHelpProvider.html
        """

    HelpController: 'HelpControllerBase'  # See GetHelpController and SetHelpController



class HelpProvider:
    """ HelpProvider is an abstract class used by a program implementing
context-sensitive help to show the help text for the given window.

        Source: https://docs.wxpython.org/wx.HelpProvider.html
    """
    def AddHelp(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HelpProvider.html
        """

    @staticmethod
    def Get() -> 'HelpProvider':
        """ Returns pointer to help provider instance.

            Source: https://docs.wxpython.org/wx.HelpProvider.html
        """

    def GetHelp(self, window: 'Window') -> str:
        """ This version associates the given text with all windows with this id.

            Source: https://docs.wxpython.org/wx.HelpProvider.html
        """

    def RemoveHelp(self, window: 'WindowBase') -> None:
        """ Removes the association between the window pointer and the help text.

            Source: https://docs.wxpython.org/wx.HelpProvider.html
        """

    @staticmethod
    def Set(helpProvider: 'HelpProvider') -> 'HelpProvider':
        """ Set the current, application-wide help provider.

            Source: https://docs.wxpython.org/wx.HelpProvider.html
        """

    def ShowHelp(self, window: 'WindowBase') -> bool:
        """ Shows help for the given window.

            Source: https://docs.wxpython.org/wx.HelpProvider.html
        """

    def ShowHelpAtPoint(self, window, point, origin) -> bool:
        """ This function may be overridden to show help for the window when it should depend on the position inside the window, By default this method forwards to ShowHelp , so it is enough to only implement the latter if the help doesnât depend on the position.

            Source: https://docs.wxpython.org/wx.HelpProvider.html
        """



class HelpEvent(CommandEvent):
    """ A help event is sent when the user has requested context-sensitive
help.

        Source: https://docs.wxpython.org/wx.HelpEvent.html
    """
    def __init__(self, type=wxEVT_NULL, winid=0, pt=DefaultPosition, origin=Origin_Unknown) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.HelpEvent.html
        """

    def GetOrigin(self) -> 'Origin':
        """ Returns the origin of the help event which is one of the   wx.HelpEvent.Origin   values.

            Source: https://docs.wxpython.org/wx.HelpEvent.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the left-click position of the mouse, in screen coordinates.

            Source: https://docs.wxpython.org/wx.HelpEvent.html
        """

    def SetOrigin(self, origin: HelpEvent.Origin) -> None:
        """ Set the help event origin, only used internally by wxWidgets normally.

            Source: https://docs.wxpython.org/wx.HelpEvent.html
        """

    def SetPosition(self, pt: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the left-click position of the mouse, in screen coordinates.

            Source: https://docs.wxpython.org/wx.HelpEvent.html
        """

    Position: 'Point'  # See GetPosition and SetPosition



class HScrolledWindow(Panel,VarHScrollHelper):
    """ In the name of this class, âHâ stands for âhorizontalâ because it can
be used for scrolling columns of variable widths.

        Source: https://docs.wxpython.org/wx.HScrolledWindow.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HScrolledWindow.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> bool:
        """ Same as the non-default constructor, but returns a status code: True if ok, False if the window couldnât be created.

            Source: https://docs.wxpython.org/wx.HScrolledWindow.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.HScrolledWindow.html
        """



class HTMLDataObject(DataObjectSimple):
    """ HTMLDataObject is used for working with HTML-formatted text.

        Source: https://docs.wxpython.org/wx.HTMLDataObject.html
    """
    def __init__(self, html: str="") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.HTMLDataObject.html
        """

    def GetAllFormats(self, dir=DataObject.Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.HTMLDataObject.html
        """

    def GetHTML(self) -> str:
        """ Returns the HTML string.

            Source: https://docs.wxpython.org/wx.HTMLDataObject.html
        """

    def SetData(self, format, buf) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.HTMLDataObject.html
        """

    def SetHTML(self, html: str) -> None:
        """ Sets the HTML string.

            Source: https://docs.wxpython.org/wx.HTMLDataObject.html
        """

    AllFormats: None  # See GetAllFormats
    HTML: str  # See GetHTML and SetHTML



class HVScrolledWindow(Panel,VarHVScrollHelper):
    """ This window inherits all functionality of both vertical and
horizontal, variable scrolled windows.

        Source: https://docs.wxpython.org/wx.HVScrolledWindow.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.HVScrolledWindow.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=0, name=PanelNameStr) -> bool:
        """ Same as the non-default constructor, but returns a status code: True if ok, False if the window couldnât be created.

            Source: https://docs.wxpython.org/wx.HVScrolledWindow.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.HVScrolledWindow.html
        """



class Icon(GDIObject):
    """ An icon is a small rectangular bitmap usually used for denoting a
minimized application.

        Source: https://docs.wxpython.org/wx.Icon.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def CopyFromBitmap(self, bmp: 'Bitmap') -> None:
        """ Copies bmp  bitmap to this icon.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def CreateFromHICON(self, hicon) -> bool:
        """ MSW-only method to create a wx.Icon from a native icon handle.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetDepth(self) -> int:
        """ Gets the colour depth of the icon.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetHandle(self) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetHeight(self) -> int:
        """ Gets the height of the icon in physical pixels.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetLogicalHeight(self) -> float:
        """ Gets the height of the icon in logical pixels.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetLogicalSize(self) -> 'Size':
        """ Gets the size of the icon in logical pixels.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetLogicalWidth(self) -> float:
        """ Gets the width of the icon in logical pixels.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetScaleFactor(self) -> float:
        """ Gets the scale factor of this icon.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetSize(self) -> 'Size':
        """ Gets the size of the icon in physical pixels.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def GetWidth(self) -> int:
        """ Gets the width of the icon in physical pixels.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def IsOk(self) -> bool:
        """ Returns True if icon data is present.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def LoadFile(self, name, type=BITMAP_TYPE_ANY, desiredWidth=-1, desiredHeight=-1) -> bool:
        """ Loads an icon from a file or resource.

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def SetDepth(self, depth: int) -> None:
        """ Sets the depth member (does not affect the icon data).

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def SetHandle(self, handle) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def SetHeight(self, height: int) -> None:
        """ Sets the height member (does not affect the icon data).

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def SetWidth(self, width: int) -> None:
        """ Sets the width member (does not affect the icon data).

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Icon.html
        """

    Depth: int  # See GetDepth and SetDepth
    Handle: int  # See GetHandle and SetHandle
    Height: int  # See GetHeight and SetHeight
    LogicalHeight: float  # See GetLogicalHeight
    LogicalSize: 'Size'  # See GetLogicalSize
    LogicalWidth: float  # See GetLogicalWidth
    ScaleFactor: float  # See GetScaleFactor
    Size: '_Size'  # See GetSize
    Width: int  # See GetWidth and SetWidth



class IconBundle(GDIObject):
    """ This class contains multiple copies of an icon in different sizes.

        Source: https://docs.wxpython.org/wx.IconBundle.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.IconBundle.html
        """

    def AddIcon(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.IconBundle.html
        """

    def GetIcon(self, *args, **kw) -> 'Icon':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.IconBundle.html
        """

    def GetIconByIndex(self, n: int) -> 'Icon':
        """ return the icon at index (must be < GetIconCount )

            Source: https://docs.wxpython.org/wx.IconBundle.html
        """

    def GetIconCount(self) -> int:
        """ return the number of available icons

            Source: https://docs.wxpython.org/wx.IconBundle.html
        """

    def GetIconOfExactSize(self, size: Union[tuple[int, int], 'Size']) -> 'Icon':
        """ Returns the icon with exactly the given size or wx.NullIcon       if this size is not available.

            Source: https://docs.wxpython.org/wx.IconBundle.html
        """

    def IsEmpty(self) -> bool:
        """ Returns True if the bundle doesnât contain any icons, False otherwise (in which case a call to GetIcon   with default parameter should return a valid icon).

            Source: https://docs.wxpython.org/wx.IconBundle.html
        """

    Icon: '_Icon'  # See GetIcon
    IconCount: int  # See GetIconCount



class IconizeEvent(Event):
    """ An event being sent when the frame is iconized (minimized) or
restored.

        Source: https://docs.wxpython.org/wx.IconizeEvent.html
    """
    def __init__(self, id=0, iconized=True) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.IconizeEvent.html
        """

    def IsIconized(self) -> bool:
        """ Returns True if the frame has been iconized, False if it has been restored.

            Source: https://docs.wxpython.org/wx.IconizeEvent.html
        """



class IconLocation:
    """ IconLocation is a tiny class describing the location of an
(external, i.e.

        Source: https://docs.wxpython.org/wx.IconLocation.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    def GetFileName(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    def GetIndex(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the object is valid, i.e. was properly initialized, and False otherwise.

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    def SetFileName(self, filename: str) -> None:
        """ filename (string) â

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    def SetIndex(self, num) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.IconLocation.html
        """

    FileName: str  # See GetFileName and SetFileName
    Index: int  # See GetIndex and SetIndex



class IdleEvent(Event):
    """ This class is used for idle events, which are generated when the
system becomes idle.

        Source: https://docs.wxpython.org/wx.IdleEvent.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.IdleEvent.html
        """

    @staticmethod
    def GetMode() -> 'IdleMode':
        """ Static function returning a value specifying how wxWidgets will send idle events: to all windows, or only to those which specify that they will process the events.

            Source: https://docs.wxpython.org/wx.IdleEvent.html
        """

    def MoreRequested(self) -> bool:
        """ Returns True if the OnIdle function processing this event requested more processing time.

            Source: https://docs.wxpython.org/wx.IdleEvent.html
        """

    def RequestMore(self, needMore: bool=True) -> None:
        """ Tells wxWidgets that more processing is required.

            Source: https://docs.wxpython.org/wx.IdleEvent.html
        """

    @staticmethod
    def SetMode(mode: IdleMode) -> None:
        """ Static function for specifying how wxWidgets will send idle events: to all windows, or only to those which specify that they will process the events.

            Source: https://docs.wxpython.org/wx.IdleEvent.html
        """



IDLE_PROCESS_SPECIFIED: int

IDLE_PROCESS_ALL: int

class IdManager:
    """ IdManager is responsible for allocating and releasing window IDs.

        Source: https://docs.wxpython.org/wx.IdManager.html
    """
    @staticmethod
    def ReserveId(count: int=1) -> int:
        """ Called directly by wx.Window.NewControlId , this function will create a new ID or range of IDs.

            Source: https://docs.wxpython.org/wx.IdManager.html
        """

    @staticmethod
    def UnreserveId(id, count=1) -> None:
        """ Called directly by wx.Window.UnreserveControlId , this function will unreserve an ID or range of IDs that is currently reserved.

            Source: https://docs.wxpython.org/wx.IdManager.html
        """



class IFFHandler(ImageHandler):
    """ This is the image handler for the IFF format.

        Source: https://docs.wxpython.org/wx.IFFHandler.html
    """
    def __init__(self) -> None:
        """ Default constructor for   wx.IFFHandler.

            Source: https://docs.wxpython.org/wx.IFFHandler.html
        """

    def DoCanRead(self, stream: 'InputStream') -> bool:
        """ Called to test if this handler can read an image from the given stream.

            Source: https://docs.wxpython.org/wx.IFFHandler.html
        """

    def LoadFile(self, image, stream, verbose=True, index=-1) -> bool:
        """ Loads an image from a stream, putting the resulting data into image.

            Source: https://docs.wxpython.org/wx.IFFHandler.html
        """

    def SaveFile(self, image, stream, verbose=True) -> bool:
        """ Saves an image in the output stream.

            Source: https://docs.wxpython.org/wx.IFFHandler.html
        """



class Image(Object):
    """ This class encapsulates a platform-independent image.

        Source: https://docs.wxpython.org/wx.Image.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def AddHandler(handler: 'ImageHandler') -> None:
        """ Register an image handler.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def AdjustChannels(self, factor_red, factor_green, factor_blue, factor_alpha=1.0) -> 'Image':
        """ This function muliplies all 4 channels (red, green, blue, alpha) with
a factor (around 1.0). Useful for gamma correction, colour correction
and to add a certain amount of transparency to a image (fade in fade
out effects). If factor_alpha is given but the original image has no
alpha channel then a alpha channel will be added.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Blur(self, blurRadius: int) -> 'Image':
        """ Blurs the image in both horizontal and vertical directions by the specified pixel blurRadius.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def BlurHorizontal(self, blurRadius: int) -> 'Image':
        """ Blurs the image in the horizontal direction only.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def BlurVertical(self, blurRadius: int) -> 'Image':
        """ Blurs the image in the vertical direction only.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def CanRead(*args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ChangeBrightness(self, factor: float) -> None:
        """ Changes the brightness (value) of each pixel in the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ChangeHSV(self, angleH, factorS, factorV) -> None:
        """ Changes the hue, the saturation and the brightness (value) of each pixel in the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ChangeLightness(self, alpha: int) -> 'Image':
        """ Returns a changed version of the image based on the given lightness.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ChangeSaturation(self, factor: float) -> None:
        """ Changes the saturation of each pixel in the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def CleanUpHandlers() -> None:
        """ Deletes all image handlers.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Clear(self, value: int=0) -> None:
        """ Initialize the image data with zeroes (the default) or with the byte value given as value.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ClearAlpha(self) -> None:
        """ Removes the alpha channel from the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ComputeHistogram(self, histogram: 'ImageHistogram') -> int:
        """ Computes the histogram of the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ConvertAlphaToMask(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ConvertToBitmap(self, depth=-1) -> None:
        """ Convert the image to a wx.Bitmap.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ConvertToDisabled(self, brightness: int=255) -> 'Image':
        """ Returns disabled (dimmed) version of the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ConvertToGreyscale(self, *args, **kw) -> 'Image':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ConvertToMono(self, r, g, b) -> 'Image':
        """ Returns monochromatic version of the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ConvertToMonoBitmap(self, red, green, blue) -> None:
        """ Creates a monochrome version of the image and returns it as a wx.Bitmap.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def ConvertToRegion(self, R=-1, G=-1, B=-1, tolerance=0) -> 'Region':
        """ Create a wx.Region where the transparent areas match the given RGB values.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Copy(self) -> 'Image':
        """ Returns an identical copy of this image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Create(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Destroy(self) -> None:
        """ Destroys the image data.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def FindFirstUnusedColour(self, startR=1, startG=0, startB=0) -> tuple:
        """ Finds the first colour that is never used in the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def FindHandler(*args, **kw) -> 'ImageHandler':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def FindHandlerMime(mimetype: str) -> 'ImageHandler':
        """ Finds the handler associated with the given MIME type.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetAlpha(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetAlphaBuffer(self) -> Any:
        """ Returns a writable Python buffer object that is pointing at the Alpha
data buffer inside the Image. You need to ensure that you do
not use this buffer object after the image has been destroyed.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetBlue(self, x, y) -> int:
        """ Returns the blue intensity at the given coordinate.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetData(self) -> Any:
        """ Returns a copy of the RGB bytes of the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetDataBuffer(self) -> Any:
        """ Returns a writable Python buffer object that is pointing at the RGB
image data buffer inside the Image. You need to ensure that you do
not use this buffer object after the image has been destroyed.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def GetDefaultLoadFlags() -> int:
        """ Returns the currently used default file load flags.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetGreen(self, x, y) -> int:
        """ Returns the green intensity at the given coordinate.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetHeight(self) -> int:
        """ Gets the height of the image in pixels.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def GetImageCount(*args, **kw) -> None:
        """ If the image file contains more than one image and the image handler is capable of retrieving these individually, this function will return the number of available images.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def GetImageExtWildcard() -> str:
        """ Iterates all registered   wx.ImageHandler  objects, and returns a string containing file extension masks suitable for passing to file open/save dialog boxes.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetLoadFlags(self) -> int:
        """ Returns the file load flags used for this object.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetMaskBlue(self) -> int:
        """ Gets the blue value of the mask colour.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetMaskGreen(self) -> int:
        """ Gets the green value of the mask colour.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetMaskRed(self) -> int:
        """ Gets the red value of the mask colour.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetOption(self, name: str) -> str:
        """ Gets a user-defined string-valued option.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetOptionInt(self, name: str) -> int:
        """ Gets a user-defined integer-valued option.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetOrFindMaskColour(self) -> tuple:
        """ Get the current mask colour or find a suitable unused colour that could be used as a mask colour.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetPalette(self) -> 'Palette':
        """ Returns the palette associated with the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetRed(self, x, y) -> int:
        """ Returns the red intensity at the given coordinate.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetSize(self) -> 'Size':
        """ Returns the size of the image in pixels.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetSubImage(self, rect: 'Rect') -> 'Image':
        """ Returns a sub image of the current one as long as the rect belongs entirely to the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetType(self) -> 'BitmapType':
        """ Gets the type of image found by LoadFile   or specified with SaveFile .

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def GetWidth(self) -> int:
        """ Gets the width of the image in pixels.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def HSVtoRGB(hsv: HSVValue) -> 'RGBValue':
        """ Converts a color in HSV color space to RGB color space.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def HasAlpha(self) -> bool:
        """ Returns True if this image has alpha channel, False otherwise.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def HasMask(self) -> bool:
        """ Returns True if there is a mask active, False otherwise.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def HasOption(self, name: str) -> bool:
        """ Returns True if the given option is present.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def InitAlpha(self) -> None:
        """ Initializes the image alpha channel data.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def InitStandardHandlers() -> None:
        """ Internal use only.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def InsertHandler(handler: 'ImageHandler') -> None:
        """ Adds a handler at the start of the static list of format handlers.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def IsOk(self) -> bool:
        """ Returns True if image data is present.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def IsTransparent(self, x, y, threshold=IMAGE_ALPHA_THRESHOLD) -> bool:
        """ Returns True if the given pixel is transparent, i.e. either has the mask colour if this image has a mask or if this image has alpha channel and alpha value of this pixel is strictly less than threshold.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def LoadFile(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Mirror(self, horizontally: bool=True) -> 'Image':
        """ Returns a mirrored copy of the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Paste(self, image, x, y, alphaBlend=IMAGE_ALPHA_BLEND_OVER) -> None:
        """ Copy the data of the given image  to the specified position in this image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def RGBtoHSV(rgb: RGBValue) -> 'HSVValue':
        """ Converts a color in RGB color space to HSV color space.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def RemoveHandler(name: str) -> bool:
        """ Finds the handler with the given name, and removes it.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Replace(self, r1, g1, b1, r2, g2, b2) -> None:
        """ Replaces the colour specified by r1,g1,b1 by the colour r2,g2,b2.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Rescale(self, width, height, quality=IMAGE_QUALITY_NORMAL) -> 'Image':
        """ Changes the size of the image in-place by scaling it: after a call to this function,the image will have the given width and height.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Resize(self, size, pos, red=-1, green=-1, blue=-1) -> 'Image':
        """ Changes the size of the image in-place without scaling it by adding either a border with the given colour or cropping as necessary.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Rotate(self, angle, rotationCentre, interpolating=True, offsetAfterRotation=None) -> 'Image':
        """ Rotates the image about the given point, by angle  radians.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Rotate180(self) -> 'Image':
        """ Returns a copy of the image rotated by 180 degrees.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Rotate90(self, clockwise: bool=True) -> 'Image':
        """ Returns a copy of the image rotated 90 degrees in the direction indicated by clockwise.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def RotateHue(self, angle: float) -> None:
        """ Rotates the hue of each pixel in the image by angle, which is a float in the range [-1.0..+1.0], where -1.0 corresponds to -360 degrees and +1.0 corresponds to +360 degrees.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SaveFile(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Scale(self, width, height, quality=IMAGE_QUALITY_NORMAL) -> 'Image':
        """ Returns a scaled version of the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetAlpha(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetAlphaBuffer(self, alpha) -> None:
        """ Sets the internal image alpha pointer to point at a Python buffer
object.  This can save making an extra copy of the data but you must
ensure that the buffer object lives lives at least as long as the
Image does.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetData(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetDataBuffer(self, *args, **kw) -> None:
        """ Sets the internal image data pointer to point at a Python buffer
object.  This can save making an extra copy of the data but you must
ensure that the buffer object lives lives at least as long as the
Image does.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    @staticmethod
    def SetDefaultLoadFlags(flags: int) -> None:
        """ Sets the default value for the flags used for loading image files.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetLoadFlags(self, flags: int) -> None:
        """ Sets the flags used for loading image files by this object.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetMask(self, hasMask: bool=True) -> None:
        """ Specifies whether there is a mask or not.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetMaskColour(self, red, green, blue) -> None:
        """ Sets the mask colour for this image (and tells the image to use the mask).

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetMaskFromImage(self, mask, mr, mg, mb) -> bool:
        """ Sets imageâs mask so that the pixels that have RGB value of mr,mg,mb in mask will be masked in the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetOption(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetPalette(self, palette: 'Palette') -> None:
        """ Associates a palette with the image.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetRGB(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def SetType(self, type: BitmapType) -> None:
        """ Set the type of image returned by GetType .

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def Size(self, size, pos, red=-1, green=-1, blue=-1) -> 'Image':
        """ Returns a resized version of this image without scaling it by adding either a border with the given colour or cropping as necessary.

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Image.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Image.html
        """

    Height: int  # See GetHeight
    MaskBlue: int  # See GetMaskBlue
    MaskGreen: int  # See GetMaskGreen
    MaskRed: int  # See GetMaskRed
    Type: 'BitmapType'  # See GetType and SetType
    Width: int  # See GetWidth



BITMAP_TYPE_BMP: int

BITMAP_TYPE_GIF: int

BITMAP_TYPE_JPEG: int

BITMAP_TYPE_PNG: int

BITMAP_TYPE_PCX: int

BITMAP_TYPE_PNM: int

BITMAP_TYPE_TIFF: int

BITMAP_TYPE_TGA: int

BITMAP_TYPE_XPM: int

BITMAP_TYPE_ICO: int

BITMAP_TYPE_CUR: int

BITMAP_TYPE_ANI: int

BITMAP_TYPE_ANY: int

_Image: TypeAlias = Image

class ImageDataObject(CustomDataObject):
    """ ImageDataObject is a specialization of DataObject for image data.

        Source: https://docs.wxpython.org/wx.ImageDataObject.html
    """
    def __init__(self, image: 'Image'=NullImage) -> None:
        """ Constructor, optionally passing an image (otherwise use SetImage   later).

            Source: https://docs.wxpython.org/wx.ImageDataObject.html
        """

    def GetAllFormats(self, dir=DataObject.Get) -> None:
        """ Returns a list of wx.DataFormat objects which this data object
supports transferring in the given direction.

            Source: https://docs.wxpython.org/wx.ImageDataObject.html
        """

    def GetImage(self) -> 'Image':
        """ Returns the image associated with the data object.

            Source: https://docs.wxpython.org/wx.ImageDataObject.html
        """

    def SetData(self, format, buf) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.ImageDataObject.html
        """

    def SetImage(self, image: 'Image') -> None:
        """ Sets the image stored by the data object.

            Source: https://docs.wxpython.org/wx.ImageDataObject.html
        """

    AllFormats: None  # See GetAllFormats
    Image: '_Image'  # See GetImage and SetImage



class ImageHandler(Object):
    """ This is the base class for implementing image file loading/saving, and
image creation from data.

        Source: https://docs.wxpython.org/wx.ImageHandler.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def CanRead(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def DoCanRead(self, stream: 'InputStream') -> bool:
        """ Called to test if this handler can read an image from the given stream.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def DoGetImageCount(self, stream: 'InputStream') -> int:
        """ Called to get the number of images available in a multi-image file type, if supported.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def GetAltExtensions(self) -> list[str]:
        """ Returns the other file extensions associated with this handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def GetExtension(self) -> str:
        """ Gets the preferred file extension associated with this handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def GetImageCount(self, stream: 'InputStream') -> int:
        """ If the image file contains more than one image and the image handler is capable of retrieving these individually, this function will return the number of available images.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def GetMimeType(self) -> str:
        """ Gets the MIME type associated with this handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def GetName(self) -> str:
        """ Gets the name of this handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def GetType(self) -> 'BitmapType':
        """ Gets the image type associated with this handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def LoadFile(self, image, stream, verbose=True, index=-1) -> bool:
        """ Loads an image from a stream, putting the resulting data into image.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def SaveFile(self, image, stream, verbose=True) -> bool:
        """ Saves an image in the output stream.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def SetAltExtensions(self, extensions: list[str]) -> None:
        """ Sets the alternative file extensions associated with this handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def SetExtension(self, extension: str) -> None:
        """ Sets the preferred file extension associated with this handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def SetMimeType(self, mimetype: str) -> None:
        """ Sets the handler MIME type.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def SetName(self, name: str) -> None:
        """ Sets the handler name.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    def SetType(self, type: BitmapType) -> None:
        """ Sets the bitmap type for the handler.

            Source: https://docs.wxpython.org/wx.ImageHandler.html
        """

    AltExtensions: list[str]  # See GetAltExtensions and SetAltExtensions
    Extension: str  # See GetExtension and SetExtension
    MimeType: str  # See GetMimeType and SetMimeType
    Name: str  # See GetName and SetName
    Type: 'BitmapType'  # See GetType and SetType



class ImageHistogram:
    """ startR (int) â 

        Source: https://docs.wxpython.org/wx.ImageHistogram.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ImageHistogram.html
        """

    def FindFirstUnusedColour(self, startR=1, startG=0, startB=0) -> tuple:
        """ startR (int) â

            Source: https://docs.wxpython.org/wx.ImageHistogram.html
        """

    @staticmethod
    def MakeKey(r, g, b) -> int:
        """ r (int) â

            Source: https://docs.wxpython.org/wx.ImageHistogram.html
        """



class ImageList(Object):
    """ A ImageList contains a list of images, which are stored in an
unspecified form.

        Source: https://docs.wxpython.org/wx.ImageList.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def Add(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def Create(self, width, height, mask=True, initialCount=1) -> bool:
        """ Initializes the list.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def Destroy(self) -> None:
        """ Destroys the current list.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def Draw(self, index, dc, x, y, flags=IMAGELIST_DRAW_NORMAL, solidBackground=False) -> bool:
        """ Draws a specified image onto a device context.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def GetBitmap(self, index: int) -> 'Bitmap':
        """ Returns the bitmap corresponding to the given index.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def GetIcon(self, index: int) -> 'Icon':
        """ Returns the icon corresponding to the given index.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def GetImageCount(self) -> int:
        """ Returns the number of images in the list.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def GetSize(self, *args, **kw) -> tuple:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def Remove(self, index: int) -> bool:
        """ Removes the image at the given position.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def RemoveAll(self) -> bool:
        """ Removes all the images in the list.

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    def Replace(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ImageList.html
        """

    ImageCount: int  # See GetImageCount
    Size: tuple  # See GetSize



IMAGELIST_DRAW_NORMAL: int

IMAGELIST_DRAW_TRANSPARENT: int

IMAGELIST_DRAW_SELECTED: int

IMAGELIST_DRAW_FOCUSED: int

_Relationship: TypeAlias = Relationship

class IndividualLayoutConstraint(Object):
    """ sibling (wx.Window) â 

        Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def Above(self, sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None:
        """ sibling (wx.Window) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def Absolute(self, val: int) -> None:
        """ val (int) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def AsIs(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def Below(self, sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None:
        """ sibling (wx.Window) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetDone(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetEdge(self, which, thisWin, other) -> int:
        """ which (Edge) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetMargin(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetMyEdge(self) -> 'Edge':
        """ wx.Edge

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetOtherEdge(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetOtherWindow(self) -> 'Window':
        """ wx.Window

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetPercent(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetRelationship(self) -> 'Relationship':
        """ wx.Relationship

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def GetValue(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def LeftOf(self, sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None:
        """ sibling (wx.Window) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def PercentOf(self, otherW, wh, per) -> None:
        """ otherW (wx.Window) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def ResetIfWin(self, otherW: 'Window') -> bool:
        """ otherW (wx.Window) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def RightOf(self, sibling, margin=LAYOUT_DEFAULT_MARGIN) -> None:
        """ sibling (wx.Window) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def SameAs(self, otherW, edge, margin=LAYOUT_DEFAULT_MARGIN) -> None:
        """ otherW (wx.Window) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def SatisfyConstraint(self, constraints, win) -> bool:
        """ constraints (wx.LayoutConstraints) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def Set(self, rel, otherW, otherE, val=0, margin=LAYOUT_DEFAULT_MARGIN) -> None:
        """ rel (Relationship) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def SetDone(self, d: bool) -> None:
        """ d (bool) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def SetEdge(self, which: Edge) -> None:
        """ which (Edge) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def SetMargin(self, m: int) -> None:
        """ m (int) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def SetRelationship(self, r: Relationship) -> None:
        """ r (Relationship) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def SetValue(self, v: int) -> None:
        """ v (int) â

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    def Unconstrained(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.IndividualLayoutConstraint.html
        """

    Done: bool  # See GetDone and SetDone
    Margin: int  # See GetMargin and SetMargin
    MyEdge: 'Edge'  # See GetMyEdge
    OtherEdge: int  # See GetOtherEdge
    OtherWindow: 'Window'  # See GetOtherWindow
    Percent: int  # See GetPercent
    Relationship: '_Relationship'  # See GetRelationship and SetRelationship
    Value: int  # See GetValue and SetValue



_ShowEffect: TypeAlias = ShowEffect

class InfoBar(Control):
    """ An info bar is a transient window shown at top or bottom of its parent
window to display non-critical information to the user.

        Source: https://docs.wxpython.org/wx.InfoBar.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def AddButton(self, btnid, label="") -> None:
        """ Add a button to be shown in the info bar.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def Create(self, parent, winid=ID_ANY) -> bool:
        """ Create the info bar window.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def Dismiss(self) -> None:
        """ Hide the info bar window.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def GetButtonCount(self) -> int:
        """ Returns the number of currently shown buttons.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def GetButtonId(self, idx: int) -> int:
        """ Returns the ID of the button at the given position.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def GetEffectDuration(self) -> int:
        """ Return the effect animation duration currently used.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def GetHideEffect(self) -> 'ShowEffect':
        """ Return the effect currently used for hiding the bar.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def GetShowEffect(self) -> 'ShowEffect':
        """ Return the effect currently used for showing the bar.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def HasButtonId(self, btnid: int) -> bool:
        """ Returns whether a button with the given ID is currently shown.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def RemoveButton(self, btnid: int) -> None:
        """ Remove a button previously added by AddButton .

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def SetEffectDuration(self, duration: int) -> None:
        """ Set the duration of the animation used when showing or hiding the bar.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def SetFont(self, font: 'Font') -> bool:
        """ Overridden base class methods changes the font of the text message.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def SetShowHideEffects(self, showEffect, hideEffect) -> None:
        """ Set the effects to use when showing and hiding the bar.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    def ShowMessage(self, msg, flags=ICON_INFORMATION) -> None:
        """ Show a message in the bar.

            Source: https://docs.wxpython.org/wx.InfoBar.html
        """

    ButtonCount: int  # See GetButtonCount
    EffectDuration: int  # See GetEffectDuration and SetEffectDuration
    HideEffect: 'ShowEffect'  # See GetHideEffect
    ShowEffect: '_ShowEffect'  # See GetShowEffect



SHOW_EFFECT_NONE: int

SHOW_EFFECT_SLIDE_TO_BOTTOM: int

SHOW_EFFECT_SLIDE_TO_TOP: int

class InitDialogEvent(Event):
    """ A InitDialogEvent is sent as a dialog or panel is being initialised.

        Source: https://docs.wxpython.org/wx.InitDialogEvent.html
    """
    def __init__(self, id: int=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.InitDialogEvent.html
        """



class InputStream(StreamBase):
    """ InputStream is an abstract base class which may not be used
directly.

        Source: https://docs.wxpython.org/wx.InputStream.html
    """
    def __init__(self) -> None:
        """ Creates a dummy input stream.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def CanRead(self) -> bool:
        """ Returns True if some data is available in the stream right now, so that calling Read   wouldnât block.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def Eof(self) -> bool:
        """ Returns True after an attempt has been made to read past the end of the stream.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def GetC(self) -> int:
        """ Returns the first character in the input queue and removes it, blocking until it appears if necessary.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def LastRead(self) -> int:
        """ Returns the last number of bytes read.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def Peek(self) -> int:
        """ Returns the first character in the input queue without removing it.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def Read(self, *args, **kw) -> 'InputStream':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def ReadAll(self, buffer, size) -> bool:
        """ Reads exactly the specified number of bytes into the buffer.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def SeekI(self, pos, mode=FromStart) -> 'FileOffset':
        """ Changes the stream current position.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def TellI(self) -> 'FileOffset':
        """ Returns the current stream position or InvalidOffset   if itâs not available (e.g.

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def Ungetch(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def close(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def eof(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def flush(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def read(self, *args, **kw) -> Any:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def readline(self, *args, **kw) -> Any:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def readlines(self, *args, **kw) -> Any:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def seek(self, offset, whence=0) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    def tell(self) -> 'FileOffset':
        """ wx.FileOffset

            Source: https://docs.wxpython.org/wx.InputStream.html
        """

    C: int  # See GetC



class InternetFSHandler(FileSystemHandler):
    """ A file system handler for accessing files from internet servers.

        Source: https://docs.wxpython.org/wx.InternetFSHandler.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.InternetFSHandler.html
        """



class ItemAttr:
    """ Represents the attributes (colour, font, â¦) of an item of a control
with multiple items such as e.g.

        Source: https://docs.wxpython.org/wx.ItemAttr.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def GetBackgroundColour(self) -> 'Colour':
        """ Returns the currently set background colour.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def GetFont(self) -> 'Font':
        """ Returns the currently set font.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def GetTextColour(self) -> 'Colour':
        """ Returns the currently set text colour.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def HasBackgroundColour(self) -> bool:
        """ Returns True if the currently set background colour is valid.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def HasColours(self) -> bool:
        """ Returns True if either text or background colour is set.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def HasFont(self) -> bool:
        """ Returns True if the currently set font is valid.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def HasTextColour(self) -> bool:
        """ Returns True if the currently set text colour is valid.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def IsDefault(self) -> bool:
        """ Returns True if this object has no custom attributes set.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def SetBackgroundColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets a new background colour.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def SetFont(self, font: 'Font') -> None:
        """ Sets a new font.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def SetTextColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets a new text colour.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Compare two item attributes for inequality.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Compare two item attributes for equality.

            Source: https://docs.wxpython.org/wx.ItemAttr.html
        """

    BackgroundColour: 'Colour'  # See GetBackgroundColour and SetBackgroundColour
    Font: '_Font'  # See GetFont and SetFont
    TextColour: 'Colour'  # See GetTextColour and SetTextColour



class ItemContainerImmutable:
    """ ItemContainer defines an interface which is implemented by all
controls which have string subitems each of which may be selected.

        Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def FindString(self, string, caseSensitive=False) -> int:
        """ Finds an item whose label matches the given string.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def GetCount(self) -> int:
        """ Returns the number of items in the control.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def GetSelection(self) -> int:
        """ Returns the index of the selected item or  NOT_FOUND   if no item is selected.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def GetString(self, n: int) -> str:
        """ Returns the label of the item with the given index.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def GetStringSelection(self) -> str:
        """ Returns the label of the selected item or an empty string if no item is selected.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def GetStrings(self) -> list[str]:
        """ Returns the array of the labels of all items in the control.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def IsEmpty(self) -> bool:
        """ Returns True if the control is empty or False if it has some items.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def Select(self, n: int) -> None:
        """ This is the same as SetSelection   and exists only because it is slightly more natural for controls which support multiple selection.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def SetSelection(self, n: int) -> None:
        """ Sets the selection to the given item n  or removes the selection entirely if n  ==  NOT_FOUND .

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def SetString(self, n, string) -> None:
        """ Sets the label for the given item.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    def SetStringSelection(self, string: str) -> bool:
        """ Selects the item with the specified string in the control.

            Source: https://docs.wxpython.org/wx.ItemContainerImmutable.html
        """

    Count: int  # See GetCount
    Selection: int  # See GetSelection and SetSelection
    StringSelection: str  # See GetStringSelection and SetStringSelection
    Strings: list[str]  # See GetStrings



class JoystickEvent(Event):
    """ This event class contains information about joystick events,
particularly events received by windows.

        Source: https://docs.wxpython.org/wx.JoystickEvent.html
    """
    def __init__(self, eventType=wxEVT_NULL, state=0, joystick=JOYSTICK1, change=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def ButtonDown(self, button: int=JOY_BUTTON_ANY) -> bool:
        """ Returns True if the event was a down event from the specified button (or any button).

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def ButtonIsDown(self, button: int=JOY_BUTTON_ANY) -> bool:
        """ Returns True if the specified button (or any button) was in a down state.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def ButtonUp(self, button: int=JOY_BUTTON_ANY) -> bool:
        """ Returns True if the event was an up event from the specified button (or any button).

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def GetButtonChange(self) -> int:
        """ Returns the identifier of the button changing state.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def GetButtonOrdinal(self) -> int:
        """ Returns the 0-indexed ordinal of the button changing state.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def GetButtonState(self) -> int:
        """ Returns the down state of the buttons.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def GetJoystick(self) -> int:
        """ Returns the identifier of the joystick generating the event - one of wx.JOYSTICK1 and wx.JOYSTICK2.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the x, y position of the joystick event.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def GetZPosition(self) -> int:
        """ Returns the z position of the joystick event.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def IsButton(self) -> bool:
        """ Returns True if this was a button up or down event (not  âis any button down?â).

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def IsMove(self) -> bool:
        """ Returns True if this was an x, y move event.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    def IsZMove(self) -> bool:
        """ Returns True if this was a z move event.

            Source: https://docs.wxpython.org/wx.JoystickEvent.html
        """

    ButtonChange: int  # See GetButtonChange
    ButtonOrdinal: int  # See GetButtonOrdinal
    ButtonState: int  # See GetButtonState
    Joystick: int  # See GetJoystick
    Position: 'Point'  # See GetPosition
    ZPosition: int  # See GetZPosition



EVT_JOY_BUTTON_DOWN: int  # Process a  wxEVT_JOY_BUTTON_DOWN   event.

EVT_JOY_BUTTON_UP: int  # Process a  wxEVT_JOY_BUTTON_UP   event.

EVT_JOY_MOVE: int  # Process a  wxEVT_JOY_MOVE   event.

EVT_JOY_ZMOVE: int  # Process a  wxEVT_JOY_ZMOVE   event.

EVT_JOYSTICK_EVENTS: int  # Processes all joystick events. ^^

JOYSTICK1: int

JOYSTICK2: int

class JPEGHandler(ImageHandler):
    """ This is the image handler for the JPEG format.

        Source: https://docs.wxpython.org/wx.JPEGHandler.html
    """
    def __init__(self) -> None:
        """ Default constructor for   wx.JPEGHandler.

            Source: https://docs.wxpython.org/wx.JPEGHandler.html
        """

    def DoCanRead(self, stream: 'InputStream') -> bool:
        """ Called to test if this handler can read an image from the given stream.

            Source: https://docs.wxpython.org/wx.JPEGHandler.html
        """

    @staticmethod
    def GetLibraryVersionInfo() -> 'VersionInfo':
        """ Retrieve the version information about the JPEG library used by this handler.

            Source: https://docs.wxpython.org/wx.JPEGHandler.html
        """

    def LoadFile(self, image, stream, verbose=True, index=-1) -> bool:
        """ Loads an image from a stream, putting the resulting data into image.

            Source: https://docs.wxpython.org/wx.JPEGHandler.html
        """

    def SaveFile(self, image, stream, verbose=True) -> bool:
        """ Saves an image in the output stream.

            Source: https://docs.wxpython.org/wx.JPEGHandler.html
        """



class KeyboardState:
    """ Provides methods for testing the state of the keyboard modifier keys.

        Source: https://docs.wxpython.org/wx.KeyboardState.html
    """
    def __init__(self, controlDown=False, shiftDown=False, altDown=False, metaDown=False) -> None:
        """ Constructor initializes the modifier key settings.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def AltDown(self) -> bool:
        """ Returns True if the Alt key is pressed.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def CmdDown(self) -> bool:
        """ Returns True if the key used for command accelerators is pressed.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def ControlDown(self) -> bool:
        """ Returns True if the Control key or Apple/Command key under macOS is pressed.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def GetModifiers(self) -> int:
        """ Return the bit mask of all pressed modifier keys.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def HasAnyModifiers(self) -> bool:
        """ Returns True if any modifiers at all are pressed.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def HasModifiers(self) -> bool:
        """ Returns True if Control or Alt are pressed.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def MetaDown(self) -> bool:
        """ Returns True if the Meta/Windows/Apple key is pressed.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def RawControlDown(self) -> bool:
        """ Returns True if the Control key (also under macOS).

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def SetAltDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def SetControlDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def SetMetaDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def SetRawControlDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def SetShiftDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    def ShiftDown(self) -> bool:
        """ Returns True if the Shift key is pressed.

            Source: https://docs.wxpython.org/wx.KeyboardState.html
        """

    altDown: Any  # See AltDown and SetAltDown
    cmdDown: Any  # See CmdDown
    controlDown: Any  # See ControlDown and SetControlDown
    metaDown: Any  # See MetaDown and SetMetaDown
    rawControlDown: Any  # See RawControlDown and SetRawControlDown
    shiftDown: Any  # See ShiftDown and SetShiftDown



class KeyEvent(Event,KeyboardState):
    """ This event class contains information about key press and release
events.

        Source: https://docs.wxpython.org/wx.KeyEvent.html
    """
    def __init__(self, keyEventType: int=wxEVT_NULL) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def DoAllowNextEvent(self) -> None:
        """ Allow normal key events generation.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def GetKeyCode(self) -> int:
        """ Returns the key code of the key that generated this event.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def GetPosition(self) -> 'Point':
        """ Obtains the position (in client coordinates) at which the key was pressed.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def GetRawKeyCode(self) -> int:
        """ Returns the raw key code for this event.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def GetRawKeyFlags(self) -> int:
        """ Returns the low level key flags for this event.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def GetUnicodeKey(self) -> int:
        """ Returns the Unicode character corresponding to this key event.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def GetX(self) -> 'Coord':
        """ Returns the X position (in client coordinates) of the event.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def GetY(self) -> 'Coord':
        """ Returns the Y position (in client coordinates) of the event.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def IsAutoRepeat(self) -> bool:
        """ Returns True if this event is an auto-repeat of the key, False if this is the initial key press.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def IsKeyInCategory(self, category: int) -> bool:
        """ Returns True if the key is in the given key category.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def IsNextEventAllowed(self) -> bool:
        """ Returns True if DoAllowNextEvent   had been called, False by default.

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def SetKeyCode(self, keyCode) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def SetRawKeyCode(self, rawKeyCode) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def SetRawKeyFlags(self, rawFlags) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    def SetUnicodeKey(self, uniChar) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.KeyEvent.html
        """

    KeyCode: int  # See GetKeyCode and SetKeyCode
    Position: 'Point'  # See GetPosition
    RawKeyCode: int  # See GetRawKeyCode and SetRawKeyCode
    RawKeyFlags: int  # See GetRawKeyFlags and SetRawKeyFlags
    UnicodeKey: int  # See GetUnicodeKey and SetUnicodeKey
    X: 'Coord'  # See GetX
    Y: 'Coord'  # See GetY



class LanguageInfo:
    """ Encapsulates a Language identifier together with OS-specific
information related to that language.

        Source: https://docs.wxpython.org/wx.LanguageInfo.html
    """
    def GetCanonicalWithRegion(self) -> str:
        """ Return the canonical locale name including the region, if known.

            Source: https://docs.wxpython.org/wx.LanguageInfo.html
        """

    def GetLocaleName(self) -> str:
        """ Return the locale name corresponding to this language usable with  setlocale()   on the current system.

            Source: https://docs.wxpython.org/wx.LanguageInfo.html
        """

    CanonicalName: Any  # A public C++ attribute of type string. Canonical name of the language, e.g.  fr_FR .
    CanonicalRef: Any  # A public C++ attribute of type string. Canonical reference including region.
    CanonicalWithRegion: str  # See GetCanonicalWithRegion
    Description: Any  # A public C++ attribute of type string. Human-readable name of the language in English.
    DescriptionNative: Any  # A public C++ attribute of type string. Human-readable name of the language in this language itself.
    Language: Any  # A public C++ attribute of type int.   wx.Language  id.
    LayoutDirection: Any  # A public C++ attribute of type LayoutDirection     . The layout direction used for this language.
    LocaleName: str  # See GetLocaleName
    LocaleTag: Any  # A public C++ attribute of type string. Tag for locale in BCP 47-like notation.



Language: TypeAlias = int  # Enumeration

LANGUAGE_DEFAULT: int

LANGUAGE_UNKNOWN: int

LANGUAGE_ABKHAZIAN: int

LANGUAGE_AFAR: int

LANGUAGE_AFAR_DJIBOUTI: int

LANGUAGE_AFAR_ERITREA: int

LANGUAGE_AFAR_ETHIOPIA: int

LANGUAGE_AFRIKAANS: int

LANGUAGE_AFRIKAANS_NAMIBIA: int

LANGUAGE_AFRIKAANS_SOUTH_AFRICA: int

LANGUAGE_AGHEM: int

LANGUAGE_AGHEM_CAMEROON: int

LANGUAGE_AKAN: int

LANGUAGE_AKAN_GHANA: int

LANGUAGE_ALBANIAN: int

LANGUAGE_ALBANIAN_ALBANIA: int

LANGUAGE_ALBANIAN_KOSOVO: int

LANGUAGE_ALBANIAN_NORTH_MACEDONIA: int

LANGUAGE_ALSATIAN_FRANCE: int

LANGUAGE_AMHARIC: int

LANGUAGE_AMHARIC_ETHIOPIA: int

LANGUAGE_ARABIC: int

LANGUAGE_ARABIC_ALGERIA: int

LANGUAGE_ARABIC_BAHRAIN: int

LANGUAGE_ARABIC_CHAD: int

LANGUAGE_ARABIC_COMOROS: int

LANGUAGE_ARABIC_DJIBOUTI: int

LANGUAGE_ARABIC_EGYPT: int

LANGUAGE_ARABIC_ERITREA: int

LANGUAGE_ARABIC_IRAQ: int

LANGUAGE_ARABIC_ISRAEL: int

LANGUAGE_ARABIC_JORDAN: int

LANGUAGE_ARABIC_KUWAIT: int

LANGUAGE_ARABIC_LEBANON: int

LANGUAGE_ARABIC_LIBYA: int

LANGUAGE_ARABIC_MAURITANIA: int

LANGUAGE_ARABIC_MOROCCO: int

LANGUAGE_ARABIC_OMAN: int

LANGUAGE_ARABIC_PALESTINIAN_AUTHORITY: int

LANGUAGE_ARABIC_QATAR: int

LANGUAGE_ARABIC_SAUDI_ARABIA: int

LANGUAGE_ARABIC_SOMALIA: int

LANGUAGE_ARABIC_SOUTH_SUDAN: int

LANGUAGE_ARABIC_SUDAN: int

LANGUAGE_ARABIC_SYRIA: int

LANGUAGE_ARABIC_TUNISIA: int

LANGUAGE_ARABIC_UAE: int

LANGUAGE_ARABIC_WORLD: int

LANGUAGE_ARABIC_YEMEN: int

LANGUAGE_ARMENIAN: int

LANGUAGE_ARMENIAN_ARMENIA: int

LANGUAGE_ASSAMESE: int

LANGUAGE_ASSAMESE_INDIA: int

LANGUAGE_ASTURIAN: int

LANGUAGE_ASTURIAN_SPAIN: int

LANGUAGE_ASU: int

LANGUAGE_ASU_TANZANIA: int

LANGUAGE_AYMARA: int

LANGUAGE_AZERBAIJANI: int

LANGUAGE_AZERBAIJANI_CYRILLIC: int

LANGUAGE_AZERBAIJANI_CYRILLIC_AZERBAIJAN: int

LANGUAGE_AZERBAIJANI_LATIN: int

LANGUAGE_AZERBAIJANI_LATIN_AZERBAIJAN: int

LANGUAGE_BAFIA: int

LANGUAGE_BAFIA_CAMEROON: int

LANGUAGE_BAMANANKAN: int

LANGUAGE_BAMANANKAN_LATIN: int

LANGUAGE_BAMANANKAN_LATIN_MALI: int

LANGUAGE_BANGLA: int

LANGUAGE_BANGLA_BANGLADESH: int

LANGUAGE_BANGLA_INDIA: int

LANGUAGE_BASAA: int

LANGUAGE_BASAA_CAMEROON: int

LANGUAGE_BASHKIR: int

LANGUAGE_BASHKIR_RUSSIA: int

LANGUAGE_BASQUE: int

LANGUAGE_BASQUE_SPAIN: int

LANGUAGE_BELARUSIAN: int

LANGUAGE_BELARUSIAN_BELARUS: int

LANGUAGE_BEMBA: int

LANGUAGE_BEMBA_ZAMBIA: int

LANGUAGE_BENA: int

LANGUAGE_BENA_TANZANIA: int

LANGUAGE_BIHARI: int

LANGUAGE_BISLAMA: int

LANGUAGE_BLIN: int

LANGUAGE_BLIN_ERITREA: int

LANGUAGE_BODO: int

LANGUAGE_BODO_INDIA: int

LANGUAGE_BOSNIAN: int

LANGUAGE_BOSNIAN_CYRILLIC: int

LANGUAGE_BOSNIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA: int

LANGUAGE_BOSNIAN_LATIN: int

LANGUAGE_BOSNIAN_LATIN_BOSNIA_AND_HERZEGOVINA: int

LANGUAGE_BRETON: int

LANGUAGE_BRETON_FRANCE: int

LANGUAGE_BULGARIAN: int

LANGUAGE_BULGARIAN_BULGARIA: int

LANGUAGE_BURMESE: int

LANGUAGE_BURMESE_MYANMAR: int

LANGUAGE_CATALAN: int

LANGUAGE_CATALAN_ANDORRA: int

LANGUAGE_CATALAN_FRANCE: int

LANGUAGE_CATALAN_ITALY: int

LANGUAGE_CATALAN_SPAIN: int

LANGUAGE_CEBUANO: int

LANGUAGE_CEBUANO_LATIN: int

LANGUAGE_CEBUANO_LATIN_PHILIPPINES: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_ARABIC_MOROCCO: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_ALGERIA: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_LATIN_MOROCCO: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH: int

LANGUAGE_CENTRAL_ATLAS_TAMAZIGHT_TIFINAGH_MOROCCO: int

LANGUAGE_CENTRAL_KURDISH: int

LANGUAGE_CENTRAL_KURDISH_IRAQ: int

LANGUAGE_CHAKMA: int

LANGUAGE_CHAKMA_CHAKMA: int

LANGUAGE_CHAKMA_CHAKMA_BANGLADESH: int

LANGUAGE_CHAKMA_CHAKMA_INDIA: int

LANGUAGE_CHECHEN: int

LANGUAGE_CHECHEN_RUSSIA: int

LANGUAGE_CHEROKEE: int

LANGUAGE_CHEROKEE_CHEROKEE: int

LANGUAGE_CHEROKEE_US: int

LANGUAGE_CHIGA: int

LANGUAGE_CHIGA_UGANDA: int

LANGUAGE_CHINESE: int

LANGUAGE_CHINESE_CHINA: int

LANGUAGE_CHINESE_HONGKONG: int

LANGUAGE_CHINESE_MACAO: int

LANGUAGE_CHINESE_SIMPLIFIED_EXPLICIT: int

LANGUAGE_CHINESE_SIMPLIFIED_HONGKONG: int

LANGUAGE_CHINESE_SIMPLIFIED_MACAO: int

LANGUAGE_CHINESE_SINGAPORE: int

LANGUAGE_CHINESE_TAIWAN: int

LANGUAGE_CHINESE_TRADITIONAL_EXPLICIT: int

LANGUAGE_CHURCH_SLAVIC: int

LANGUAGE_CHURCH_SLAVIC_RUSSIA: int

LANGUAGE_COLOGNIAN: int

LANGUAGE_COLOGNIAN_GERMANY: int

LANGUAGE_CORNISH: int

LANGUAGE_CORNISH_UK: int

LANGUAGE_CORSICAN: int

LANGUAGE_CORSICAN_FRANCE: int

LANGUAGE_CROATIAN: int

LANGUAGE_CROATIAN_BOSNIA_AND_HERZEGOVINA: int

LANGUAGE_CROATIAN_CROATIA: int

LANGUAGE_CZECH: int

LANGUAGE_CZECH_CZECHIA: int

LANGUAGE_DANISH: int

LANGUAGE_DANISH_DENMARK: int

LANGUAGE_DANISH_GREENLAND: int

LANGUAGE_DARI: int

LANGUAGE_DARI_AFGHANISTAN: int

LANGUAGE_DIVEHI: int

LANGUAGE_DIVEHI_MALDIVES: int

LANGUAGE_DUALA: int

LANGUAGE_DUALA_CAMEROON: int

LANGUAGE_DUTCH: int

LANGUAGE_DUTCH_ARUBA: int

LANGUAGE_DUTCH_BELGIAN: int

LANGUAGE_DUTCH_BONAIRE_SINT_EUSTATIUS_AND_SABA: int

LANGUAGE_DUTCH_CURACAO: int

LANGUAGE_DUTCH_NETHERLANDS: int

LANGUAGE_DUTCH_SINT_MAARTEN: int

LANGUAGE_DUTCH_SURINAME: int

LANGUAGE_DZONGKHA: int

LANGUAGE_DZONGKHA_BHUTAN: int

LANGUAGE_EDO: int

LANGUAGE_EDO_NIGERIA: int

LANGUAGE_EMBU: int

LANGUAGE_EMBU_KENYA: int

LANGUAGE_ENGLISH: int

LANGUAGE_ENGLISH_AMERICAN_SAMOA: int

LANGUAGE_ENGLISH_ANGUILLA: int

LANGUAGE_ENGLISH_ANTIGUA_AND_BARBUDA: int

LANGUAGE_ENGLISH_AUSTRALIA: int

LANGUAGE_ENGLISH_AUSTRIA: int

LANGUAGE_ENGLISH_BAHAMAS: int

LANGUAGE_ENGLISH_BARBADOS: int

LANGUAGE_ENGLISH_BELGIUM: int

LANGUAGE_ENGLISH_BELIZE: int

LANGUAGE_ENGLISH_BERMUDA: int

LANGUAGE_ENGLISH_BOTSWANA: int

LANGUAGE_ENGLISH_BRITISH_INDIAN_OCEAN_TERRITORY: int

LANGUAGE_ENGLISH_BRITISH_VIRGIN_ISLANDS: int

LANGUAGE_ENGLISH_BURUNDI: int

LANGUAGE_ENGLISH_CAMEROON: int

LANGUAGE_ENGLISH_CANADA: int

LANGUAGE_ENGLISH_CARIBBEAN: int

LANGUAGE_ENGLISH_CARIBBEAN_CB: int

LANGUAGE_ENGLISH_CAYMAN_ISLANDS: int

LANGUAGE_ENGLISH_CHRISTMAS_ISLAND: int

LANGUAGE_ENGLISH_COCOS_KEELING_ISLANDS: int

LANGUAGE_ENGLISH_COOK_ISLANDS: int

LANGUAGE_ENGLISH_CYPRUS: int

LANGUAGE_ENGLISH_DENMARK: int

LANGUAGE_ENGLISH_DOMINICA: int

LANGUAGE_ENGLISH_EIRE: int

LANGUAGE_ENGLISH_ERITREA: int

LANGUAGE_ENGLISH_ESWATINI: int

LANGUAGE_ENGLISH_EUROPE: int

LANGUAGE_ENGLISH_FALKLAND_ISLANDS: int

LANGUAGE_ENGLISH_FIJI: int

LANGUAGE_ENGLISH_FINLAND: int

LANGUAGE_ENGLISH_GAMBIA: int

LANGUAGE_ENGLISH_GERMANY: int

LANGUAGE_ENGLISH_GHANA: int

LANGUAGE_ENGLISH_GIBRALTAR: int

LANGUAGE_ENGLISH_GRENADA: int

LANGUAGE_ENGLISH_GUAM: int

LANGUAGE_ENGLISH_GUERNSEY: int

LANGUAGE_ENGLISH_GUYANA: int

LANGUAGE_ENGLISH_HONG_KONG_SAR: int

LANGUAGE_ENGLISH_INDIA: int

LANGUAGE_ENGLISH_INDONESIA: int

LANGUAGE_ENGLISH_ISLE_OF_MAN: int

LANGUAGE_ENGLISH_ISRAEL: int

LANGUAGE_ENGLISH_JAMAICA: int

LANGUAGE_ENGLISH_JERSEY: int

LANGUAGE_ENGLISH_KENYA: int

LANGUAGE_ENGLISH_KIRIBATI: int

LANGUAGE_ENGLISH_LESOTHO: int

LANGUAGE_ENGLISH_LIBERIA: int

LANGUAGE_ENGLISH_MACAO_SAR: int

LANGUAGE_ENGLISH_MADAGASCAR: int

LANGUAGE_ENGLISH_MALAWI: int

LANGUAGE_ENGLISH_MALAYSIA: int

LANGUAGE_ENGLISH_MALTA: int

LANGUAGE_ENGLISH_MARSHALL_ISLANDS: int

LANGUAGE_ENGLISH_MAURITIUS: int

LANGUAGE_ENGLISH_MICRONESIA: int

LANGUAGE_ENGLISH_MONTSERRAT: int

LANGUAGE_ENGLISH_NAMIBIA: int

LANGUAGE_ENGLISH_NAURU: int

LANGUAGE_ENGLISH_NETHERLANDS: int

LANGUAGE_ENGLISH_NEW_ZEALAND: int

LANGUAGE_ENGLISH_NIGERIA: int

LANGUAGE_ENGLISH_NIUE: int

LANGUAGE_ENGLISH_NORFOLK_ISLAND: int

LANGUAGE_ENGLISH_NORTHERN_MARIANA_ISLANDS: int

LANGUAGE_ENGLISH_PAKISTAN: int

LANGUAGE_ENGLISH_PALAU: int

LANGUAGE_ENGLISH_PAPUA_NEW_GUINEA: int

LANGUAGE_ENGLISH_PHILIPPINES: int

LANGUAGE_ENGLISH_PITCAIRN_ISLANDS: int

LANGUAGE_ENGLISH_PUERTO_RICO: int

LANGUAGE_ENGLISH_RWANDA: int

LANGUAGE_ENGLISH_SAMOA: int

LANGUAGE_ENGLISH_SEYCHELLES: int

LANGUAGE_ENGLISH_SIERRA_LEONE: int

LANGUAGE_ENGLISH_SINGAPORE: int

LANGUAGE_ENGLISH_SINT_MAARTEN: int

LANGUAGE_ENGLISH_SLOVENIA: int

LANGUAGE_ENGLISH_SOLOMON_ISLANDS: int

LANGUAGE_ENGLISH_SOUTH_AFRICA: int

LANGUAGE_ENGLISH_SOUTH_SUDAN: int

LANGUAGE_ENGLISH_ST_HELENA_ASCENSION_TRISTAN_DA_CUNHA: int

LANGUAGE_ENGLISH_ST_KITTS_AND_NEVIS: int

LANGUAGE_ENGLISH_ST_LUCIA: int

LANGUAGE_ENGLISH_ST_VINCENT_AND_GRENADINES: int

LANGUAGE_ENGLISH_SUDAN: int

LANGUAGE_ENGLISH_SWEDEN: int

LANGUAGE_ENGLISH_SWITZERLAND: int

LANGUAGE_ENGLISH_TANZANIA: int

LANGUAGE_ENGLISH_TOKELAU: int

LANGUAGE_ENGLISH_TONGA: int

LANGUAGE_ENGLISH_TRINIDAD: int

LANGUAGE_ENGLISH_TURKS_AND_CAICOS_ISLANDS: int

LANGUAGE_ENGLISH_TUVALU: int

LANGUAGE_ENGLISH_UGANDA: int

LANGUAGE_ENGLISH_UK: int

LANGUAGE_ENGLISH_UNITED_ARAB_EMIRATES: int

LANGUAGE_ENGLISH_US: int

LANGUAGE_ENGLISH_US_OUTLYING_ISLANDS: int

LANGUAGE_ENGLISH_US_VIRGIN_ISLANDS: int

LANGUAGE_ENGLISH_VANUATU: int

LANGUAGE_ENGLISH_WORLD: int

LANGUAGE_ENGLISH_ZAMBIA: int

LANGUAGE_ENGLISH_ZIMBABWE: int

LANGUAGE_ESPERANTO: int

LANGUAGE_ESPERANTO_WORLD: int

LANGUAGE_ESTONIAN: int

LANGUAGE_ESTONIAN_ESTONIA: int

LANGUAGE_EWE: int

LANGUAGE_EWE_GHANA: int

LANGUAGE_EWE_TOGO: int

LANGUAGE_EWONDO: int

LANGUAGE_EWONDO_CAMEROON: int

LANGUAGE_FAEROESE: int

LANGUAGE_FAEROESE_DENMARK: int

LANGUAGE_FAEROESE_FAROE_ISLANDS: int

LANGUAGE_FARSI: int

LANGUAGE_FIJI: int

LANGUAGE_FILIPINO: int

LANGUAGE_FILIPINO_PHILIPPINES: int

LANGUAGE_FINNISH: int

LANGUAGE_FINNISH_FINLAND: int

LANGUAGE_FRENCH: int

LANGUAGE_FRENCH_ALGERIA: int

LANGUAGE_FRENCH_BELGIAN: int

LANGUAGE_FRENCH_BENIN: int

LANGUAGE_FRENCH_BURKINA_FASO: int

LANGUAGE_FRENCH_BURUNDI: int

LANGUAGE_FRENCH_CAMEROON: int

LANGUAGE_FRENCH_CANADIAN: int

LANGUAGE_FRENCH_CARIBBEAN: int

LANGUAGE_FRENCH_CENTRAL_AFRICAN_REPUBLIC: int

LANGUAGE_FRENCH_CHAD: int

LANGUAGE_FRENCH_COMOROS: int

LANGUAGE_FRENCH_CONGO: int

LANGUAGE_FRENCH_CONGO_DRC: int

LANGUAGE_FRENCH_COTE_DIVOIRE: int

LANGUAGE_FRENCH_DJIBOUTI: int

LANGUAGE_FRENCH_EQUATORIAL_GUINEA: int

LANGUAGE_FRENCH_FRANCE: int

LANGUAGE_FRENCH_FRENCH_GUIANA: int

LANGUAGE_FRENCH_FRENCH_POLYNESIA: int

LANGUAGE_FRENCH_GABON: int

LANGUAGE_FRENCH_GUADELOUPE: int

LANGUAGE_FRENCH_GUINEA: int

LANGUAGE_FRENCH_HAITI: int

LANGUAGE_FRENCH_LUXEMBOURG: int

LANGUAGE_FRENCH_MADAGASCAR: int

LANGUAGE_FRENCH_MALI: int

LANGUAGE_FRENCH_MARTINIQUE: int

LANGUAGE_FRENCH_MAURITANIA: int

LANGUAGE_FRENCH_MAURITIUS: int

LANGUAGE_FRENCH_MAYOTTE: int

LANGUAGE_FRENCH_MONACO: int

LANGUAGE_FRENCH_MOROCCO: int

LANGUAGE_FRENCH_NEW_CALEDONIA: int

LANGUAGE_FRENCH_NIGER: int

LANGUAGE_FRENCH_REUNION: int

LANGUAGE_FRENCH_RWANDA: int

LANGUAGE_FRENCH_SENEGAL: int

LANGUAGE_FRENCH_SEYCHELLES: int

LANGUAGE_FRENCH_ST_BARTHELEMY: int

LANGUAGE_FRENCH_ST_MARTIN: int

LANGUAGE_FRENCH_ST_PIERRE_AND_MIQUELON: int

LANGUAGE_FRENCH_SWISS: int

LANGUAGE_FRENCH_SYRIA: int

LANGUAGE_FRENCH_TOGO: int

LANGUAGE_FRENCH_TUNISIA: int

LANGUAGE_FRENCH_VANUATU: int

LANGUAGE_FRENCH_WALLIS_AND_FUTUNA: int

LANGUAGE_FRISIAN: int

LANGUAGE_FRISIAN_NETHERLANDS: int

LANGUAGE_FRIULIAN: int

LANGUAGE_FRIULIAN_ITALY: int

LANGUAGE_FULAH: int

LANGUAGE_FULAH_LATIN: int

LANGUAGE_FULAH_LATIN_BURKINA_FASO: int

LANGUAGE_FULAH_LATIN_CAMEROON: int

LANGUAGE_FULAH_LATIN_GAMBIA: int

LANGUAGE_FULAH_LATIN_GHANA: int

LANGUAGE_FULAH_LATIN_GUINEA: int

LANGUAGE_FULAH_LATIN_GUINEA_BISSAU: int

LANGUAGE_FULAH_LATIN_LIBERIA: int

LANGUAGE_FULAH_LATIN_MAURITANIA: int

LANGUAGE_FULAH_LATIN_NIGER: int

LANGUAGE_FULAH_LATIN_NIGERIA: int

LANGUAGE_FULAH_LATIN_SENEGAL: int

LANGUAGE_FULAH_LATIN_SIERRA_LEONE: int

LANGUAGE_GALICIAN: int

LANGUAGE_GALICIAN_SPAIN: int

LANGUAGE_GANDA: int

LANGUAGE_GANDA_UGANDA: int

LANGUAGE_GEORGIAN: int

LANGUAGE_GEORGIAN_GEORGIA: int

LANGUAGE_GERMAN: int

LANGUAGE_GERMAN_AUSTRIAN: int

LANGUAGE_GERMAN_BELGIUM: int

LANGUAGE_GERMAN_GERMANY: int

LANGUAGE_GERMAN_ITALY: int

LANGUAGE_GERMAN_LIECHTENSTEIN: int

LANGUAGE_GERMAN_LUXEMBOURG: int

LANGUAGE_GERMAN_SWISS: int

LANGUAGE_GREEK: int

LANGUAGE_GREEK_CYPRUS: int

LANGUAGE_GREEK_GREECE: int

LANGUAGE_GREENLANDIC: int

LANGUAGE_GUARANI: int

LANGUAGE_GUARANI_PARAGUAY: int

LANGUAGE_GUJARATI: int

LANGUAGE_GUJARATI_INDIA: int

LANGUAGE_GUSII: int

LANGUAGE_GUSII_KENYA: int

LANGUAGE_HAUSA: int

LANGUAGE_HAUSA_LATIN: int

LANGUAGE_HAUSA_LATIN_GHANA: int

LANGUAGE_HAUSA_LATIN_NIGER: int

LANGUAGE_HAUSA_LATIN_NIGERIA: int

LANGUAGE_HAWAIIAN: int

LANGUAGE_HAWAIIAN_US: int

LANGUAGE_HEBREW: int

LANGUAGE_HEBREW_ISRAEL: int

LANGUAGE_HINDI: int

LANGUAGE_HINDI_INDIA: int

LANGUAGE_HUNGARIAN: int

LANGUAGE_HUNGARIAN_HUNGARY: int

LANGUAGE_IBIBIO: int

LANGUAGE_IBIBIO_NIGERIA: int

LANGUAGE_ICELANDIC: int

LANGUAGE_ICELANDIC_ICELAND: int

LANGUAGE_IGBO: int

LANGUAGE_IGBO_NIGERIA: int

LANGUAGE_INDONESIAN: int

LANGUAGE_INDONESIAN_INDONESIA: int

LANGUAGE_INTERLINGUA: int

LANGUAGE_INTERLINGUA_WORLD: int

LANGUAGE_INTERLINGUE: int

LANGUAGE_INUKTITUT: int

LANGUAGE_INUKTITUT_LATIN: int

LANGUAGE_INUKTITUT_LATIN_CANADA: int

LANGUAGE_INUKTITUT_SYLLABICS: int

LANGUAGE_INUKTITUT_SYLLABICS_CANADA: int

LANGUAGE_INUPIAK: int

LANGUAGE_IRISH: int

LANGUAGE_IRISH_IRELAND: int

LANGUAGE_ITALIAN: int

LANGUAGE_ITALIAN_ITALY: int

LANGUAGE_ITALIAN_SAN_MARINO: int

LANGUAGE_ITALIAN_SWISS: int

LANGUAGE_ITALIAN_VATICAN_CITY: int

LANGUAGE_JAPANESE: int

LANGUAGE_JAPANESE_JAPAN: int

LANGUAGE_JAVANESE: int

LANGUAGE_JAVANESE_INDONESIA: int

LANGUAGE_JAVANESE_JAVANESE: int

LANGUAGE_JAVANESE_JAVANESE_INDONESIA: int

LANGUAGE_JOLA_FONYI: int

LANGUAGE_JOLA_FONYI_SENEGAL: int

LANGUAGE_KABUVERDIANU: int

LANGUAGE_KABUVERDIANU_CABO_VERDE: int

LANGUAGE_KABYLE: int

LANGUAGE_KABYLE_ALGERIA: int

LANGUAGE_KAKO: int

LANGUAGE_KAKO_CAMEROON: int

LANGUAGE_KALAALLISUT: int

LANGUAGE_KALENJIN: int

LANGUAGE_KALENJIN_KENYA: int

LANGUAGE_KAMBA: int

LANGUAGE_KAMBA_KENYA: int

LANGUAGE_KANNADA: int

LANGUAGE_KANNADA_INDIA: int

LANGUAGE_KANURI: int

LANGUAGE_KANURI_LATIN: int

LANGUAGE_KANURI_NIGERIA: int

LANGUAGE_KASHMIRI: int

LANGUAGE_KASHMIRI_DEVANAGARI: int

LANGUAGE_KASHMIRI_DEVANAGARI_INDIA: int

LANGUAGE_KASHMIRI_INDIA: int

LANGUAGE_KASHMIRI_PERSO_ARABIC: int

LANGUAGE_KASHMIRI_PERSO_ARABIC_INDIA: int

LANGUAGE_KAZAKH: int

LANGUAGE_KAZAKH_KAZAKHSTAN: int

LANGUAGE_KHMER: int

LANGUAGE_KHMER_CAMBODIA: int

LANGUAGE_KICHE: int

LANGUAGE_KICHE_GUATEMALA: int

LANGUAGE_KICHE_LATIN: int

LANGUAGE_KIKUYU: int

LANGUAGE_KIKUYU_KENYA: int

LANGUAGE_KINYARWANDA: int

LANGUAGE_KINYARWANDA_RWANDA: int

LANGUAGE_KIRGHIZ: int

LANGUAGE_KIRGHIZ_KYRGYZSTAN: int

LANGUAGE_KIRUNDI: int

LANGUAGE_KIRUNDI_BURUNDI: int

LANGUAGE_KONKANI: int

LANGUAGE_KONKANI_INDIA: int

LANGUAGE_KOREAN: int

LANGUAGE_KOREAN_KOREA: int

LANGUAGE_KOREAN_NORTH_KOREA: int

LANGUAGE_KOYRABORO_SENNI: int

LANGUAGE_KOYRABORO_SENNI_MALI: int

LANGUAGE_KOYRA_CHIINI: int

LANGUAGE_KOYRA_CHIINI_MALI: int

LANGUAGE_KURDISH: int

LANGUAGE_KURDISH_PERSO_ARABIC_IRAN: int

LANGUAGE_KWASIO: int

LANGUAGE_KWASIO_CAMEROON: int

LANGUAGE_LAKOTA: int

LANGUAGE_LAKOTA_US: int

LANGUAGE_LANGI: int

LANGUAGE_LANGI_TANZANIA: int

LANGUAGE_LAOTHIAN: int

LANGUAGE_LAOTHIAN_LAOS: int

LANGUAGE_LATIN: int

LANGUAGE_LATIN_WORLD: int

LANGUAGE_LATVIAN: int

LANGUAGE_LATVIAN_LATVIA: int

LANGUAGE_LINGALA: int

LANGUAGE_LINGALA_ANGOLA: int

LANGUAGE_LINGALA_CENTRAL_AFRICAN_REPUBLIC: int

LANGUAGE_LINGALA_CONGO: int

LANGUAGE_LINGALA_CONGO_DRC: int

LANGUAGE_LITHUANIAN: int

LANGUAGE_LITHUANIAN_LITHUANIA: int

LANGUAGE_LOWER_SORBIAN: int

LANGUAGE_LOWER_SORBIAN_GERMANY: int

LANGUAGE_LOW_GERMAN: int

LANGUAGE_LOW_GERMAN_GERMANY: int

LANGUAGE_LOW_GERMAN_NETHERLANDS: int

LANGUAGE_LUBA_KATANGA: int

LANGUAGE_LUBA_KATANGA_CONGO_DRC: int

LANGUAGE_LUO: int

LANGUAGE_LUO_KENYA: int

LANGUAGE_LUXEMBOURGISH: int

LANGUAGE_LUXEMBOURGISH_LUXEMBOURG: int

LANGUAGE_LUYIA: int

LANGUAGE_LUYIA_KENYA: int

LANGUAGE_MACEDONIAN: int

LANGUAGE_MACEDONIAN_NORTH_MACEDONIA: int

LANGUAGE_MACHAME: int

LANGUAGE_MACHAME_TANZANIA: int

LANGUAGE_MAKHUWA_MEETTO: int

LANGUAGE_MAKHUWA_MEETTO_MOZAMBIQUE: int

LANGUAGE_MAKONDE: int

LANGUAGE_MAKONDE_TANZANIA: int

LANGUAGE_MALAGASY: int

LANGUAGE_MALAGASY_MADAGASCAR: int

LANGUAGE_MALAY: int

LANGUAGE_MALAYALAM: int

LANGUAGE_MALAYALAM_INDIA: int

LANGUAGE_MALAY_BRUNEI: int

LANGUAGE_MALAY_MALAYSIA: int

LANGUAGE_MALAY_SINGAPORE: int

LANGUAGE_MALTESE: int

LANGUAGE_MALTESE_MALTA: int

LANGUAGE_MANIPURI: int

LANGUAGE_MANIPURI_INDIA: int

LANGUAGE_MANX: int

LANGUAGE_MANX_ISLE_OF_MAN: int

LANGUAGE_MAORI: int

LANGUAGE_MAORI_NEW_ZEALAND: int

LANGUAGE_MAPUCHE: int

LANGUAGE_MAPUCHE_CHILE: int

LANGUAGE_MARATHI: int

LANGUAGE_MARATHI_INDIA: int

LANGUAGE_MASAI: int

LANGUAGE_MASAI_KENYA: int

LANGUAGE_MASAI_TANZANIA: int

LANGUAGE_MAZANDERANI: int

LANGUAGE_MAZANDERANI_IRAN: int

LANGUAGE_MERU: int

LANGUAGE_MERU_KENYA: int

LANGUAGE_META: int

LANGUAGE_META_CAMEROON: int

LANGUAGE_MOHAWK: int

LANGUAGE_MOHAWK_CANADA: int

LANGUAGE_MOLDAVIAN: int

LANGUAGE_MONGOLIAN: int

LANGUAGE_MONGOLIAN_CYRILLIC: int

LANGUAGE_MONGOLIAN_MONGOLIA: int

LANGUAGE_MONGOLIAN_TRADITIONAL: int

LANGUAGE_MONGOLIAN_TRADITIONAL_CHINA: int

LANGUAGE_MONGOLIAN_TRADITIONAL_MONGOLIA: int

LANGUAGE_MORISYEN: int

LANGUAGE_MORISYEN_MAURITIUS: int

LANGUAGE_MUNDANG: int

LANGUAGE_MUNDANG_CAMEROON: int

LANGUAGE_NAMA: int

LANGUAGE_NAMA_NAMIBIA: int

LANGUAGE_NAURU: int

LANGUAGE_NEPALI: int

LANGUAGE_NEPALI_INDIA: int

LANGUAGE_NEPALI_NEPAL: int

LANGUAGE_NGIEMBOON: int

LANGUAGE_NGIEMBOON_CAMEROON: int

LANGUAGE_NGOMBA: int

LANGUAGE_NGOMBA_CAMEROON: int

LANGUAGE_NKO: int

LANGUAGE_NKO_GUINEA: int

LANGUAGE_NORTHERN_LURI: int

LANGUAGE_NORTHERN_LURI_IRAN: int

LANGUAGE_NORTHERN_LURI_IRAQ: int

LANGUAGE_NORTH_NDEBELE: int

LANGUAGE_NORTH_NDEBELE_ZIMBABWE: int

LANGUAGE_NORWEGIAN: int

LANGUAGE_NORWEGIAN_BOKMAL: int

LANGUAGE_NORWEGIAN_BOKMAL_NORWAY: int

LANGUAGE_NORWEGIAN_BOKMAL_SVALBARD_AND_JAN_MAYEN: int

LANGUAGE_NORWEGIAN_NYNORSK: int

LANGUAGE_NORWEGIAN_NYNORSK_NORWAY: int

LANGUAGE_NUER: int

LANGUAGE_NUER_SOUTH_SUDAN: int

LANGUAGE_NYANKOLE: int

LANGUAGE_NYANKOLE_UGANDA: int

LANGUAGE_OCCITAN: int

LANGUAGE_OCCITAN_FRANCE: int

LANGUAGE_ODIA: int

LANGUAGE_ODIA_INDIA: int

LANGUAGE_OROMO: int

LANGUAGE_OROMO_ETHIOPIA: int

LANGUAGE_OROMO_KENYA: int

LANGUAGE_OSSETIC: int

LANGUAGE_OSSETIC_GEORGIA: int

LANGUAGE_OSSETIC_RUSSIA: int

LANGUAGE_PAPIAMENTO: int

LANGUAGE_PAPIAMENTO_CARIBBEAN: int

LANGUAGE_PASHTO: int

LANGUAGE_PASHTO_AFGHANISTAN: int

LANGUAGE_PASHTO_PAKISTAN: int

LANGUAGE_PERSIAN_IRAN: int

LANGUAGE_POLISH: int

LANGUAGE_POLISH_POLAND: int

LANGUAGE_PORTUGUESE: int

LANGUAGE_PORTUGUESE_ANGOLA: int

LANGUAGE_PORTUGUESE_BRAZILIAN: int

LANGUAGE_PORTUGUESE_CABO_VERDE: int

LANGUAGE_PORTUGUESE_EQUATORIAL_GUINEA: int

LANGUAGE_PORTUGUESE_GUINEA_BISSAU: int

LANGUAGE_PORTUGUESE_LUXEMBOURG: int

LANGUAGE_PORTUGUESE_MACAO_SAR: int

LANGUAGE_PORTUGUESE_MOZAMBIQUE: int

LANGUAGE_PORTUGUESE_PORTUGAL: int

LANGUAGE_PORTUGUESE_SAO_TOME_AND_PRINCIPE: int

LANGUAGE_PORTUGUESE_SWITZERLAND: int

LANGUAGE_PORTUGUESE_TIMOR_LESTE: int

LANGUAGE_PRUSSIAN: int

LANGUAGE_PRUSSIAN_WORLD: int

LANGUAGE_PUNJABI: int

LANGUAGE_PUNJABI_ARABIC: int

LANGUAGE_PUNJABI_GURMUKHI: int

LANGUAGE_PUNJABI_INDIA: int

LANGUAGE_PUNJABI_PAKISTAN: int

LANGUAGE_QUECHUA: int

LANGUAGE_QUECHUA_BOLIVIA: int

LANGUAGE_QUECHUA_ECUADOR: int

LANGUAGE_QUECHUA_MACRO: int

LANGUAGE_QUECHUA_PERU: int

LANGUAGE_RHAETO_ROMANCE: int

LANGUAGE_RHAETO_ROMANCE_SWITZERLAND: int

LANGUAGE_ROMANIAN: int

LANGUAGE_ROMANIAN_MOLDOVA: int

LANGUAGE_ROMANIAN_ROMANIA: int

LANGUAGE_ROMBO: int

LANGUAGE_ROMBO_TANZANIA: int

LANGUAGE_RUSSIAN: int

LANGUAGE_RUSSIAN_BELARUS: int

LANGUAGE_RUSSIAN_KAZAKHSTAN: int

LANGUAGE_RUSSIAN_KYRGYZSTAN: int

LANGUAGE_RUSSIAN_MOLDOVA: int

LANGUAGE_RUSSIAN_RUSSIA: int

LANGUAGE_RUSSIAN_UKRAINE: int

LANGUAGE_RWA: int

LANGUAGE_RWA_TANZANIA: int

LANGUAGE_SAHO: int

LANGUAGE_SAHO_ERITREA: int

LANGUAGE_SAKHA: int

LANGUAGE_SAKHA_RUSSIA: int

LANGUAGE_SAMBURU: int

LANGUAGE_SAMBURU_KENYA: int

LANGUAGE_SAMI: int

LANGUAGE_SAMI_FINLAND: int

LANGUAGE_SAMI_INARI: int

LANGUAGE_SAMI_INARI_FINLAND: int

LANGUAGE_SAMI_LULE: int

LANGUAGE_SAMI_LULE_NORWAY: int

LANGUAGE_SAMI_LULE_SWEDEN: int

LANGUAGE_SAMI_NORWAY: int

LANGUAGE_SAMI_SKOLT: int

LANGUAGE_SAMI_SKOLT_FINLAND: int

LANGUAGE_SAMI_SOUTHERN: int

LANGUAGE_SAMI_SOUTHERN_NORWAY: int

LANGUAGE_SAMI_SOUTHERN_SWEDEN: int

LANGUAGE_SAMI_SWEDEN: int

LANGUAGE_SAMOAN: int

LANGUAGE_SANGHO: int

LANGUAGE_SANGHO_CENTRAL_AFRICAN_REPUBLIC: int

LANGUAGE_SANGU: int

LANGUAGE_SANGU_TANZANIA: int

LANGUAGE_SANSKRIT: int

LANGUAGE_SANSKRIT_INDIA: int

LANGUAGE_SCOTS_GAELIC: int

LANGUAGE_SCOTS_GAELIC_UK: int

LANGUAGE_SENA: int

LANGUAGE_SENA_MOZAMBIQUE: int

LANGUAGE_SERBIAN: int

LANGUAGE_SERBIAN_CYRILLIC: int

LANGUAGE_SERBIAN_CYRILLIC_BOSNIA_AND_HERZEGOVINA: int

LANGUAGE_SERBIAN_CYRILLIC_KOSOVO: int

LANGUAGE_SERBIAN_CYRILLIC_MONTENEGRO: int

LANGUAGE_SERBIAN_CYRILLIC_SERBIA: int

LANGUAGE_SERBIAN_CYRILLIC_YU: int

LANGUAGE_SERBIAN_LATIN: int

LANGUAGE_SERBIAN_LATIN_BOSNIA_AND_HERZEGOVINA: int

LANGUAGE_SERBIAN_LATIN_KOSOVO: int

LANGUAGE_SERBIAN_LATIN_MONTENEGRO: int

LANGUAGE_SERBIAN_LATIN_SERBIA: int

LANGUAGE_SERBIAN_LATIN_YU: int

LANGUAGE_SERBIAN_SERBIA: int

LANGUAGE_SERBIAN_YU: int

LANGUAGE_SERBO_CROATIAN: int

LANGUAGE_SESOTHO: int

LANGUAGE_SESOTHO_LESOTHO: int

LANGUAGE_SESOTHO_SA_LEBOA: int

LANGUAGE_SESOTHO_SA_LEBOA_SOUTH_AFRICA: int

LANGUAGE_SESOTHO_SOUTH_AFRICA: int

LANGUAGE_SETSWANA: int

LANGUAGE_SETSWANA_BOTSWANA: int

LANGUAGE_SETSWANA_SOUTH_AFRICA: int

LANGUAGE_SHAMBALA: int

LANGUAGE_SHAMBALA_TANZANIA: int

LANGUAGE_SHONA: int

LANGUAGE_SHONA_LATIN: int

LANGUAGE_SHONA_LATIN_ZIMBABWE: int

LANGUAGE_SINDHI: int

LANGUAGE_SINDHI_ARABIC: int

LANGUAGE_SINDHI_DEVANAGARI: int

LANGUAGE_SINDHI_DEVANAGARI_INDIA: int

LANGUAGE_SINDHI_PAKISTAN: int

LANGUAGE_SINHALESE: int

LANGUAGE_SINHALESE_SRI_LANKA: int

LANGUAGE_SISWATI: int

LANGUAGE_SISWATI_ESWATINI: int

LANGUAGE_SISWATI_SOUTH_AFRICA: int

LANGUAGE_SLOVAK: int

LANGUAGE_SLOVAK_SLOVAKIA: int

LANGUAGE_SLOVENIAN: int

LANGUAGE_SLOVENIAN_SLOVENIA: int

LANGUAGE_SOGA: int

LANGUAGE_SOGA_UGANDA: int

LANGUAGE_SOMALI: int

LANGUAGE_SOMALI_DJIBOUTI: int

LANGUAGE_SOMALI_ETHIOPIA: int

LANGUAGE_SOMALI_KENYA: int

LANGUAGE_SOMALI_SOMALIA: int

LANGUAGE_SOUTH_NDEBELE: int

LANGUAGE_SOUTH_NDEBELE_SOUTH_AFRICA: int

LANGUAGE_SPANISH: int

LANGUAGE_SPANISH_ARGENTINA: int

LANGUAGE_SPANISH_BELIZE: int

LANGUAGE_SPANISH_BOLIVIA: int

LANGUAGE_SPANISH_BRAZIL: int

LANGUAGE_SPANISH_CHILE: int

LANGUAGE_SPANISH_COLOMBIA: int

LANGUAGE_SPANISH_COSTA_RICA: int

LANGUAGE_SPANISH_CUBA: int

LANGUAGE_SPANISH_DOMINICAN_REPUBLIC: int

LANGUAGE_SPANISH_ECUADOR: int

LANGUAGE_SPANISH_EL_SALVADOR: int

LANGUAGE_SPANISH_EQUATORIAL_GUINEA: int

LANGUAGE_SPANISH_GUATEMALA: int

LANGUAGE_SPANISH_HONDURAS: int

LANGUAGE_SPANISH_LATIN_AMERICA: int

LANGUAGE_SPANISH_MEXICAN: int

LANGUAGE_SPANISH_NICARAGUA: int

LANGUAGE_SPANISH_PANAMA: int

LANGUAGE_SPANISH_PARAGUAY: int

LANGUAGE_SPANISH_PERU: int

LANGUAGE_SPANISH_PHILIPPINES: int

LANGUAGE_SPANISH_PUERTO_RICO: int

LANGUAGE_SPANISH_SPAIN: int

LANGUAGE_SPANISH_URUGUAY: int

LANGUAGE_SPANISH_US: int

LANGUAGE_SPANISH_VENEZUELA: int

LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT: int

LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH: int

LANGUAGE_STANDARD_MOROCCAN_TAMAZIGHT_TIFINAGH_MOROCCO: int

LANGUAGE_SUNDANESE: int

LANGUAGE_SWAHILI: int

LANGUAGE_SWAHILI_CONGO_DRC: int

LANGUAGE_SWAHILI_KENYA: int

LANGUAGE_SWAHILI_TANZANIA: int

LANGUAGE_SWAHILI_UGANDA: int

LANGUAGE_SWEDISH: int

LANGUAGE_SWEDISH_ALAND_ISLANDS: int

LANGUAGE_SWEDISH_FINLAND: int

LANGUAGE_SWEDISH_SWEDEN: int

LANGUAGE_SWISS_GERMAN: int

LANGUAGE_SWISS_GERMAN_LIECHTENSTEIN: int

LANGUAGE_SWISS_GERMAN_SWITZERLAND: int

LANGUAGE_SYRIAC: int

LANGUAGE_SYRIAC_SYRIA: int

LANGUAGE_TACHELHIT: int

LANGUAGE_TACHELHIT_LATIN: int

LANGUAGE_TACHELHIT_LATIN_MOROCCO: int

LANGUAGE_TACHELHIT_TIFINAGH: int

LANGUAGE_TACHELHIT_TIFINAGH_MOROCCO: int

LANGUAGE_TAGALOG: int

LANGUAGE_TAITA: int

LANGUAGE_TAITA_KENYA: int

LANGUAGE_TAJIK: int

LANGUAGE_TAJIK_CYRILLIC: int

LANGUAGE_TAJIK_CYRILLIC_TAJIKISTAN: int

LANGUAGE_TAMIL: int

LANGUAGE_TAMIL_INDIA: int

LANGUAGE_TAMIL_MALAYSIA: int

LANGUAGE_TAMIL_SINGAPORE: int

LANGUAGE_TAMIL_SRI_LANKA: int

LANGUAGE_TASAWAQ: int

LANGUAGE_TASAWAQ_NIGER: int

LANGUAGE_TATAR: int

LANGUAGE_TATAR_RUSSIA: int

LANGUAGE_TELUGU: int

LANGUAGE_TELUGU_INDIA: int

LANGUAGE_TESO: int

LANGUAGE_TESO_KENYA: int

LANGUAGE_TESO_UGANDA: int

LANGUAGE_THAI: int

LANGUAGE_THAI_THAILAND: int

LANGUAGE_TIBETAN: int

LANGUAGE_TIBETAN_CHINA: int

LANGUAGE_TIBETAN_INDIA: int

LANGUAGE_TIGRE: int

LANGUAGE_TIGRE_ERITREA: int

LANGUAGE_TIGRINYA: int

LANGUAGE_TIGRINYA_ERITREA: int

LANGUAGE_TIGRINYA_ETHIOPIA: int

LANGUAGE_TONGA: int

LANGUAGE_TONGA_TONGA: int

LANGUAGE_TSONGA: int

LANGUAGE_TSONGA_SOUTH_AFRICA: int

LANGUAGE_TURKISH: int

LANGUAGE_TURKISH_CYPRUS: int

LANGUAGE_TURKISH_TURKEY: int

LANGUAGE_TURKMEN: int

LANGUAGE_TURKMEN_TURKMENISTAN: int

LANGUAGE_TWI: int

LANGUAGE_UIGHUR: int

LANGUAGE_UIGHUR_CHINA: int

LANGUAGE_UKRAINIAN: int

LANGUAGE_UKRAINIAN_UKRAINE: int

LANGUAGE_UPPER_SORBIAN: int

LANGUAGE_UPPER_SORBIAN_GERMANY: int

LANGUAGE_URDU: int

LANGUAGE_URDU_INDIA: int

LANGUAGE_URDU_PAKISTAN: int

LANGUAGE_UZBEK: int

LANGUAGE_UZBEK_CYRILLIC: int

LANGUAGE_UZBEK_CYRILLIC_UZBEKISTAN: int

LANGUAGE_UZBEK_LATIN: int

LANGUAGE_UZBEK_LATIN_UZBEKISTAN: int

LANGUAGE_UZBEK_PERSO_ARABIC: int

LANGUAGE_UZBEK_PERSO_ARABIC_AFGHANISTAN: int

LANGUAGE_VAI: int

LANGUAGE_VAI_LATIN: int

LANGUAGE_VAI_LATIN_LIBERIA: int

LANGUAGE_VAI_VAI: int

LANGUAGE_VAI_VAI_LIBERIA: int

LANGUAGE_VALENCIAN: int

LANGUAGE_VENDA: int

LANGUAGE_VENDA_SOUTH_AFRICA: int

LANGUAGE_VIETNAMESE: int

LANGUAGE_VIETNAMESE_VIETNAM: int

LANGUAGE_VOLAPUK: int

LANGUAGE_VOLAPUK_WORLD: int

LANGUAGE_VUNJO: int

LANGUAGE_VUNJO_TANZANIA: int

LANGUAGE_WALSER: int

LANGUAGE_WALSER_SWITZERLAND: int

LANGUAGE_WELSH: int

LANGUAGE_WELSH_UK: int

LANGUAGE_WOLAYTTA: int

LANGUAGE_WOLAYTTA_ETHIOPIA: int

LANGUAGE_WOLOF: int

LANGUAGE_WOLOF_SENEGAL: int

LANGUAGE_XHOSA: int

LANGUAGE_XHOSA_SOUTH_AFRICA: int

LANGUAGE_YANGBEN: int

LANGUAGE_YANGBEN_CAMEROON: int

LANGUAGE_YI: int

LANGUAGE_YIDDISH: int

LANGUAGE_YIDDISH_WORLD: int

LANGUAGE_YI_CHINA: int

LANGUAGE_YORUBA: int

LANGUAGE_YORUBA_BENIN: int

LANGUAGE_YORUBA_NIGERIA: int

LANGUAGE_ZARMA: int

LANGUAGE_ZARMA_NIGER: int

LANGUAGE_ZHUANG: int

LANGUAGE_ZULU: int

LANGUAGE_ZULU_SOUTH_AFRICA: int

LANGUAGE_USER_DEFINED: int

LANGUAGE_AZERI: int

LANGUAGE_AZERI_CYRILLIC: int

LANGUAGE_AZERI_LATIN: int

LANGUAGE_BENGALI: int

LANGUAGE_BENGALI_BANGLADESH: int

LANGUAGE_BENGALI_INDIA: int

LANGUAGE_BHUTANI: int

LANGUAGE_CHINESE_SIMPLIFIED: int

LANGUAGE_CHINESE_TRADITIONAL: int

LANGUAGE_CHINESE_MACAU: int

LANGUAGE_KERNEWEK: int

LANGUAGE_MALAY_BRUNEI_DARUSSALAM: int

LANGUAGE_ORIYA: int

LANGUAGE_ORIYA_INDIA: int

LANGUAGE_SPANISH_MODERN: int

LANGUAGE_CAMBODIAN: int

class LayoutConstraints(Object):
    """ bool

        Source: https://docs.wxpython.org/wx.LayoutConstraints.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.LayoutConstraints.html
        """

    def AreSatisfied(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.LayoutConstraints.html
        """

    def SatisfyConstraints(self, win, noChanges) -> bool:
        """ win (wx.Window) â

            Source: https://docs.wxpython.org/wx.LayoutConstraints.html
        """

    bottom: Any  # A public C++ attribute of type IndividualLayoutConstraint     .
    centreX: Any  # A public C++ attribute of type IndividualLayoutConstraint     .
    centreY: Any  # A public C++ attribute of type IndividualLayoutConstraint     .
    height: Any  # A public C++ attribute of type IndividualLayoutConstraint     .
    left: Any  # A public C++ attribute of type IndividualLayoutConstraint     .
    right: Any  # A public C++ attribute of type IndividualLayoutConstraint     .
    top: Any  # A public C++ attribute of type IndividualLayoutConstraint     .
    width: Any  # A public C++ attribute of type IndividualLayoutConstraint     .



class LinuxDistributionInfo:
    """ A structure containing information about a Linux distribution as
returned by the lsb_release utility.

        Source: https://docs.wxpython.org/wx.LinuxDistributionInfo.html
    """
    def __ne__(self, item: Any) -> bool:
        """ ldi (wx.LinuxDistributionInfo) â

            Source: https://docs.wxpython.org/wx.LinuxDistributionInfo.html
        """

    def __eq__(self, item: Any) -> bool:
        """ ldi (wx.LinuxDistributionInfo) â

            Source: https://docs.wxpython.org/wx.LinuxDistributionInfo.html
        """

    CodeName: Any  # A public C++ attribute of type string. The code name of the distribution; e.g. âjauntyâ.
    Description: Any  # A public C++ attribute of type string. The description of the distribution; e.g. âUbuntu 9.04â.
    Id: Any  # A public C++ attribute of type string. The id of the distribution; e.g. âUbuntuâ.
    Release: Any  # A public C++ attribute of type string. The version of the distribution; e.g. â9.04â.



class ListCtrl(Control):
    """ A list control presents lists in a number of formats: list view,
report view, icon view and small icon view.

        Source: https://docs.wxpython.org/wx.ListCtrl.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def Append(self, entry) -> None:
        """ Append an item to the list control.  The entry parameter should be a
sequence with an item for each column

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def AppendColumn(self, heading, format=LIST_FORMAT_LEFT, width=-1) -> int:
        """ Adds a new column to the list control in report view mode.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def Arrange(self, flag: int=LIST_ALIGN_DEFAULT) -> bool:
        """ Arranges the items in icon or small icon view.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def AssignImageList(self, imageList, which) -> None:
        """ Sets the image list associated with the control and takes ownership of it.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def CheckItem(self, item, check=True) -> None:
        """ Check or uncheck a   wx.ListItem  in a control using checkboxes.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def ClearAll(self) -> None:
        """ Deletes all items and all columns.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def ClearColumnImage(self, col) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=LC_ICON, validator=DefaultValidator, name=ListCtrlNameStr) -> bool:
        """ Creates the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def DeleteAllColumns(self) -> bool:
        """ Delete all columns in the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def DeleteAllItems(self) -> bool:
        """ Deletes all items in the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def DeleteColumn(self, col: int) -> bool:
        """ Deletes a column.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def DeleteItem(self, item: int) -> bool:
        """ Deletes the specified item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def EditLabel(self, item: int) -> 'TextCtrl':
        """ Starts editing the label of the given item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def EnableAlternateRowColours(self, enable: bool=True) -> None:
        """ Enable alternating row background colours (also called zebra striping).

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def EnableBellOnNoMatch(self, on: bool=True) -> None:
        """ Enable or disable a beep if there is no match for the currently entered text when searching for the item from keyboard.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def EnableCheckBoxes(self, enable: bool=True) -> bool:
        """ Enable or disable checkboxes for list items.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def EnableSystemTheme(self, enable: bool=True) -> None:
        """ Can be used to disable the system theme of controls using it by default.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def EnsureVisible(self, item: int) -> bool:
        """ Ensures this item is visible.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def ExtendRulesAndAlternateColour(self, extend: bool=True) -> None:
        """ Extend rules and alternate rows background to the entire client area.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def FindItem(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def Focus(self, idx) -> None:
        """ Focus and show the given item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetAlternateRowColour(self) -> 'Colour':
        """ Get the alternative row background colour.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetColumn(self, col) -> 'ListItem':
        """ Gets information about this column. See SetItem() for more information.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetColumnCount(self) -> int:
        """ Returns the number of columns.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetColumnIndexFromOrder(self, pos: int) -> int:
        """ Gets the column index from its position in visual order.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetColumnOrder(self, col: int) -> int:
        """ Gets the column visual order position.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetColumnWidth(self, col: int) -> int:
        """ Gets the column width (report view only).

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetColumnsOrder(self) -> list[int]:
        """ Returns the array containing the orders of all columns.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetCountPerPage(self) -> int:
        """ Gets the number of items that can fit vertically in the visible area of the list control (list or report view) or the total number of items in the list control (icon or small icon view).

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetEditControl(self) -> 'TextCtrl':
        """ Returns the edit control being currently used to edit a label.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetFirstSelected(self, *args) -> int:
        """ Returns the first selected item, or -1 when none is selected.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetFocusedItem(self) -> int:
        """ Gets the currently focused item or -1 if none is focused.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetImageList(self, which: int) -> 'ImageList':
        """ Returns the specified image list.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItem(self, itemIdx, col=0) -> 'ListItem':
        """ Gets information about the item. See SetItem() for more information.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemBackgroundColour(self, item: int) -> 'Colour':
        """ Returns the colour for this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemCount(self) -> int:
        """ Returns the number of items in the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemData(self, item: int) -> int:
        """ Gets the application-defined data associated with this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemFont(self, item: int) -> 'Font':
        """ Returns the itemâs font.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemPosition(self, item) -> 'Point':
        """ Returns the position of the item, in icon or small icon view.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemRect(self, item, code=LIST_RECT_BOUNDS) -> 'Rect':
        """ Returns the rectangle representing the itemâs size and position, in physical coordinates.
code is one of wx.``wx.LIST_RECT_BOUNDS``, wx.``wx.LIST_RECT_ICON``, wx.``wx.LIST_RECT_LABEL``.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemSpacing(self) -> 'Size':
        """ Retrieves the spacing between icons in pixels: horizontal spacing is returned as  x   component of the    wx.Size  object and the vertical spacing as its  y   component.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemState(self, item, stateMask) -> int:
        """ Gets the item state.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemText(self, item, col=0) -> str:
        """ Gets the item text for this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetItemTextColour(self, item: int) -> 'Colour':
        """ Returns the colour for this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetMainWindow(self) -> 'Window':
        """ wx.Window

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetNextItem(self, item, geometry=LIST_NEXT_ALL, state=LIST_STATE_DONTCARE) -> int:
        """ Searches for an item with the given geometry or state, starting from item  but excluding the item  itself.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetNextSelected(self, item) -> int:
        """ Returns subsequent selected items, or -1 when no more are selected.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetSelectedItemCount(self) -> int:
        """ Returns the number of selected items in the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetSortIndicator(self) -> int:
        """ Returns the column that shows the sort indicator.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetSubItemRect(self, item, subItem, rect, code=LIST_RECT_BOUNDS) -> bool:
        """ Returns the rectangle representing the size and position, in physical coordinates, of the given subitem, i.e.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetTextColour(self) -> 'Colour':
        """ Gets the text colour of the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetTopItem(self) -> int:
        """ Gets the index of the topmost visible item when in list or report view.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetUpdatedAscendingSortIndicator(self, col: int) -> bool:
        """ Returns the new value to use for sort indicator after clicking a column.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def GetViewRect(self) -> 'Rect':
        """ Returns the rectangle taken by all items in the control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def HasCheckBoxes(self) -> bool:
        """ Returns True if checkboxes are enabled for list items.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def HasColumnOrderSupport(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def HitTest(self, point) -> None:
        """ Determines which item (if any) is at the specified point, giving details in flags.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def HitTestSubItem(self, point) -> tuple:
        """ Determines which item (if any) is at the specified point, giving details in flags.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def InReportView(self) -> bool:
        """ Returns True if the control is currently using LC_REPORT  style.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def InsertColumn(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def InsertItem(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def IsAscendingSortIndicator(self) -> bool:
        """ Returns True if the sort indicator direction is ascending, False when the direction is descending.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def IsEmpty(self) -> bool:
        """ Returns True if the control doesnât currently contain any items.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def IsItemChecked(self, item: int) -> bool:
        """ Return True if the checkbox for the given   wx.ListItem  is checked.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def IsSelected(self, idx) -> None:
        """ Returns True if the item is selected.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def IsVirtual(self) -> bool:
        """ Returns True if the control is currently in virtual report view.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def IsVisible(self, item: int) -> bool:
        """ Check if the item is visible.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def OnGetItemAttr(self, item: int) -> Optional['ItemAttr']:
        """ This function may be overridden in the derived class for a control with  LC_VIRTUAL   style.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def OnGetItemColumnImage(self, item, column) -> int:
        """ Override this function in the derived class for a control with  LC_VIRTUAL   and   LC_REPORT   styles in order to specify the image index for the given line and column.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def OnGetItemImage(self, item: int) -> int:
        """ This function must be overridden in the derived class for a control with  LC_VIRTUAL   style using images.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def OnGetItemIsChecked(self, item: int) -> bool:
        """ This function must  be overridden in the derived class for a control with  LC_VIRTUAL   style that uses checkboxes.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def OnGetItemText(self, item, column) -> str:
        """ This function must  be overridden in the derived class for a control with  LC_VIRTUAL   style.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def RefreshItem(self, item: int) -> None:
        """ Redraws the given item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def RefreshItems(self, itemFrom, itemTo) -> None:
        """ Redraws the items between itemFrom  and itemTo.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def RemoveSortIndicator(self) -> None:
        """ Remove the sort indicator from the column being used as sort key.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def ScrollList(self, dx, dy) -> bool:
        """ Scrolls the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def Select(self, idx, on=1) -> None:
        """ Selects/deselects an item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetAlternateRowColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Set the alternative row background colour to a specific colour.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetBackgroundColour(self, col: Union[int, str, 'Colour']) -> bool:
        """ Sets the background colour.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetColumn(self, col, item) -> bool:
        """ Sets information about this column.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetColumnImage(self, col, image) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetColumnWidth(self, col, width) -> bool:
        """ Sets the column width.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetColumnsOrder(self, orders: list[int]) -> bool:
        """ Changes the order in which the columns are shown.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetHeaderAttr(self, attr: 'ItemAttr') -> bool:
        """ Change the font and the colours used for the list control header.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetImageList(self, imageList, which) -> None:
        """ Sets the image list associated with the control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItem(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemBackgroundColour(self, item, col) -> None:
        """ Sets the background colour for this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemColumnImage(self, item, column, image) -> bool:
        """ Sets the image associated with the item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemCount(self, count: int) -> None:
        """ This method can only be used with virtual list controls.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemData(self, item, data) -> bool:
        """ Associates application-defined data with this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemFont(self, item, font) -> None:
        """ Sets the itemâs font.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemImage(self, item, image, selImage=-1) -> bool:
        """ Sets the unselected and selected images associated with the item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemPosition(self, item, pos) -> bool:
        """ Sets the position of the item, in icon or small icon view.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemState(self, item, state, stateMask) -> bool:
        """ Sets the item state.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemText(self, item, text) -> None:
        """ Sets the item text for this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetItemTextColour(self, item, col) -> None:
        """ Sets the colour for this item.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetNormalImages(self, images: Vector) -> None:
        """ Sets the images to use when showing large, normal icons in this control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetSingleStyle(self, style, add=True) -> None:
        """ Adds or removes a single window style.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetSmallImages(self, images: Vector) -> None:
        """ Sets the images to use when showing small icons in this control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetTextColour(self, col: Union[int, str, 'Colour']) -> None:
        """ Sets the text colour of the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SetWindowStyleFlag(self, style: int) -> None:
        """ Sets the whole window style, deleting all items.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def ShowSortIndicator(self, col, ascending=True) -> None:
        """ Show the sort indicator of a specific column in a specific direction.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    def SortItems(self, fnSortCallBack) -> None:
        """ Call this function to sort the items in the list control.

            Source: https://docs.wxpython.org/wx.ListCtrl.html
        """

    AlternateRowColour: 'Colour'  # See GetAlternateRowColour and SetAlternateRowColour
    Column: 'ListItem'  # See GetColumn and SetColumn
    ColumnCount: int  # See GetColumnCount
    ColumnsOrder: list[int]  # See GetColumnsOrder and SetColumnsOrder
    CountPerPage: int  # See GetCountPerPage
    EditControl: 'TextCtrl'  # See GetEditControl
    FocusedItem: None  # See GetFocusedItem
    Item: 'ListItem'  # See GetItem and SetItem
    ItemCount: int  # See GetItemCount and SetItemCount
    ItemPosition: 'Point'  # See GetItemPosition and SetItemPosition
    ItemRect: 'Rect'  # See GetItemRect
    ItemSpacing: 'Size'  # See GetItemSpacing
    MainWindow: 'Window'  # See GetMainWindow
    SelectedItemCount: int  # See GetSelectedItemCount
    SortIndicator: int  # See GetSortIndicator
    TextColour: 'Colour'  # See GetTextColour and SetTextColour
    TopItem: int  # See GetTopItem
    ViewRect: 'Rect'  # See GetViewRect



LC_LIST: int  # Multicolumn list view, with optional small icons. Columns are computed automatically, i.e. you donât set columns as in  LC_REPORT . In other words, the list wraps, unlike a    wx.ListBox.

LC_REPORT: int  # Single or multicolumn report view, with optional header.

LC_VIRTUAL: int  # The application provides items text on demand. May only be used with  LC_REPORT .

LC_ICON: int  # Large icon view, with optional labels.

LC_SMALL_ICON: int  # Small icon view, with optional labels.

LC_ALIGN_TOP: int  # Icons align to the top. Win32 default, Win32 only.

LC_ALIGN_LEFT: int  # Icons align to the left.

LC_AUTOARRANGE: int  # Icons arrange themselves. Win32 only.

LC_EDIT_LABELS: int  # Labels are editable: the application will be notified when editing starts.

LC_NO_HEADER: int  # No header in report mode.

LC_SINGLE_SEL: int  # Single selection (default is multiple).

LC_SORT_ASCENDING: int  # Sort in ascending order. (You must still supply a comparison callback in wx.ListCtrl.SortItems .)

LC_SORT_DESCENDING: int  # Sort in descending order. (You must still supply a comparison callback in wx.ListCtrl.SortItems .)

LC_HRULES: int  # Draws light horizontal rules between rows in report mode.

LC_VRULES: int  # Draws light vertical rules between columns in report mode. ^^

EVT_LIST_BEGIN_DRAG: int  # Begin dragging with the left mouse button. Processes a  wxEVT_LIST_BEGIN_DRAG   event type.

EVT_LIST_BEGIN_RDRAG: int  # Begin dragging with the right mouse button. Processes a  wxEVT_LIST_BEGIN_RDRAG   event type.

EVT_LIST_BEGIN_LABEL_EDIT: int  # Begin editing a label. This can be prevented by calling Veto(). Processes a  wxEVT_LIST_BEGIN_LABEL_EDIT   event type.

EVT_LIST_END_LABEL_EDIT: int  # Finish editing a label. This can be prevented by calling Veto(). Processes a  wxEVT_LIST_END_LABEL_EDIT   event type.

EVT_LIST_DELETE_ITEM: int  # An item was deleted. Processes a  wxEVT_LIST_DELETE_ITEM   event type.

EVT_LIST_DELETE_ALL_ITEMS: int  # All items were deleted. Processes a  wxEVT_LIST_DELETE_ALL_ITEMS   event type.

EVT_LIST_ITEM_SELECTED: int  # The item has been selected. Notice that the mouse is captured by the control itself when this event is generated, see event handling overview. Processes a  wxEVT_LIST_ITEM_SELECTED   event type.

EVT_LIST_ITEM_DESELECTED: int  # The item has been deselected. Processes a  wxEVT_LIST_ITEM_DESELECTED   event type.

EVT_LIST_ITEM_ACTIVATED: int  # The item has been activated (ENTER or double click). Processes a  wxEVT_LIST_ITEM_ACTIVATED   event type.

EVT_LIST_ITEM_FOCUSED: int  # The currently focused item has changed. Processes a  wxEVT_LIST_ITEM_FOCUSED   event type.

EVT_LIST_ITEM_MIDDLE_CLICK: int  # The middle mouse button has been clicked on an item. This is only supported by the generic control. Processes a  wxEVT_LIST_ITEM_MIDDLE_CLICK   event type.

EVT_LIST_ITEM_RIGHT_CLICK: int  # The right mouse button has been clicked on an item. Processes a  wxEVT_LIST_ITEM_RIGHT_CLICK   event type.

EVT_LIST_KEY_DOWN: int  # A key has been pressed. Processes a  wxEVT_LIST_KEY_DOWN   event type.

EVT_LIST_INSERT_ITEM: int  # An item has been inserted. Processes a  wxEVT_LIST_INSERT_ITEM   event type.

EVT_LIST_COL_CLICK: int  # A column (m_col) has been left-clicked. Processes a  wxEVT_LIST_COL_CLICK   event type.

EVT_LIST_COL_RIGHT_CLICK: int  # A column (m_col) has been right-clicked. Processes a  wxEVT_LIST_COL_RIGHT_CLICK   event type.

EVT_LIST_COL_BEGIN_DRAG: int  # The user started resizing a column - can be vetoed. Processes a  wxEVT_LIST_COL_BEGIN_DRAG   event type.

EVT_LIST_COL_DRAGGING: int  # The divider between columns is being dragged. Processes a  wxEVT_LIST_COL_DRAGGING   event type.

EVT_LIST_COL_END_DRAG: int  # A column has been resized by the user. Processes a  wxEVT_LIST_COL_END_DRAG   event type.

EVT_LIST_CACHE_HINT: int  # Prepare cache for a virtual list control. Processes a  wxEVT_LIST_CACHE_HINT   event type.

EVT_LIST_ITEM_CHECKED: int  # The item has been checked. Processes a  wxEVT_LIST_ITEM_CHECKED   event type (new since wxWidgets 3.1.0).

EVT_LIST_ITEM_UNCHECKED: int  # The item has been unchecked. Processes a  wxEVT_LIST_ITEM_UNCHECKED   event type (new since wxWidgets 3.1.0). ^^

LIST_ALIGN_DEFAULT: int

LIST_ALIGN_LEFT: int

LIST_ALIGN_TOP: int

LIST_ALIGN_SNAP_TO_GRID: int

IMAGE_LIST_NORMAL: int

IMAGE_LIST_SMALL: int

IMAGE_LIST_STATE: int

LIST_NEXT_ABOVE: int

LIST_NEXT_ALL: int

LIST_NEXT_BELOW: int

LIST_NEXT_LEFT: int

LIST_NEXT_RIGHT: int

LIST_STATE_DONTCARE: int

LIST_STATE_DROPHILITED: int

LIST_STATE_FOCUSED: int

LIST_STATE_SELECTED: int

LIST_STATE_CUT: int

LIST_HITTEST_ABOVE: int

LIST_HITTEST_BELOW: int

LIST_HITTEST_TOLEFT: int

LIST_HITTEST_TORIGHT: int

LIST_HITTEST_NOWHERE: int

LIST_HITTEST_ONITEMICON: int

LIST_HITTEST_ONITEMLABEL: int

LIST_HITTEST_ONITEMSTATEICON: int

LIST_HITTEST_ONITEM: int

_Point: TypeAlias = Point

class ListEvent(NotifyEvent):
    """ A list event holds information about events associated with ListCtrl
objects.

        Source: https://docs.wxpython.org/wx.ListEvent.html
    """
    def __init__(self, commandType=wxEVT_NULL, id=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetCacheFrom(self) -> int:
        """ For  EVT_LIST_CACHE_HINT   event only: return the first item which the list control advises us to cache.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetCacheTo(self) -> int:
        """ For  EVT_LIST_CACHE_HINT   event only: return the last item (inclusive) which the list control advises us to cache.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetColumn(self) -> int:
        """ The column position: it is only used with  COL   events.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetData(self) -> int:
        """ The data.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetImage(self) -> int:
        """ The image.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetIndex(self) -> int:
        """ The item index.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetItem(self) -> 'ListItem':
        """ An item object, used by some events.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetKeyCode(self) -> int:
        """ Key code if the event is a keypress event.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetLabel(self) -> str:
        """ The (new) item label for  EVT_LIST_END_LABEL_EDIT   event.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetMask(self) -> int:
        """ The mask.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetPoint(self) -> 'Point':
        """ The position of the mouse pointer if the event is a drag event.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def GetText(self) -> str:
        """ The text.

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def IsEditCancelled(self) -> bool:
        """ This method only makes sense for  EVT_LIST_END_LABEL_EDIT   message and returns True if it the label editing has been cancelled by the user ( GetLabel   returns an empty string in this case but it doesnât allow the application to distinguish between really cancelling the edit and the admittedly rare case when the user wants to rename it to an empty string).

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def SetCacheFrom(self, cacheFrom: int) -> None:
        """ cacheFrom (long) â

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def SetCacheTo(self, cacheTo: int) -> None:
        """ cacheTo (long) â

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def SetColumn(self, col: int) -> None:
        """ col (int) â

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def SetIndex(self, index: int) -> None:
        """ index (long) â

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def SetItem(self, item: 'ListItem') -> None:
        """ item (wx.ListItem) â

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def SetKeyCode(self, code: int) -> None:
        """ code (int) â

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    def SetPoint(self, point: Union[tuple[int, int], 'Point']) -> None:
        """ point (wx.Point) â

            Source: https://docs.wxpython.org/wx.ListEvent.html
        """

    CacheFrom: int  # See GetCacheFrom and SetCacheFrom
    CacheTo: int  # See GetCacheTo and SetCacheTo
    Column: int  # See GetColumn and SetColumn
    Data: int  # See GetData
    Image: int  # See GetImage
    Index: int  # See GetIndex and SetIndex
    Item: 'ListItem'  # See GetItem and SetItem
    KeyCode: int  # See GetKeyCode and SetKeyCode
    Label: str  # See GetLabel
    Mask: int  # See GetMask
    Point: '_Point'  # See GetPoint and SetPoint
    Text: str  # See GetText



class ListItem(Object):
    """ This class stores information about a ListCtrl item or column.

        Source: https://docs.wxpython.org/wx.ListItem.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def Clear(self) -> None:
        """ Resets the item state to the default.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetAlign(self) -> 'ListColumnFormat':
        """ Returns the alignment for this item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetBackgroundColour(self) -> 'Colour':
        """ Returns the background colour for this item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetColumn(self) -> int:
        """ Returns the zero-based column; meaningful only in report mode.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetData(self) -> int:
        """ Returns client data associated with the control.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetFont(self) -> 'Font':
        """ Returns the font used to display the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetId(self) -> int:
        """ Returns the zero-based item position.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetImage(self) -> int:
        """ Returns the zero-based index of the image associated with the item into the image list.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetMask(self) -> int:
        """ Returns a bit mask indicating which fields of the structure are valid.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetState(self) -> int:
        """ Returns a bit field representing the state of the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetText(self) -> str:
        """ Returns the label/header text.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetTextColour(self) -> 'Colour':
        """ Returns the text colour.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def GetWidth(self) -> int:
        """ Meaningful only for column headers in report mode.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetAlign(self, align: ListColumnFormat) -> None:
        """ Sets the alignment for the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetBackgroundColour(self, colBack: Union[int, str, 'Colour']) -> None:
        """ Sets the background colour for the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetColumn(self, col: int) -> None:
        """ Sets the zero-based column.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetData(self, data: int) -> None:
        """ Sets client data for the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetFont(self, font: 'Font') -> None:
        """ Sets the font for the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetId(self, id: int) -> None:
        """ Sets the zero-based item position.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetImage(self, image: int) -> None:
        """ Sets the zero-based index of the image associated with the item into the image list.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetMask(self, mask: int) -> None:
        """ Sets the mask of valid fields.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetState(self, state: int) -> None:
        """ Sets the item state flags (note that the valid state flags are influenced by the value of the state mask, see wx.ListItem.SetStateMask ).

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetStateMask(self, stateMask: int) -> None:
        """ Sets the bitmask that is used to determine which of the state flags are to be set.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetText(self, text: str) -> None:
        """ Sets the text label for the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetTextColour(self, colText: Union[int, str, 'Colour']) -> None:
        """ Sets the text colour for the item.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    def SetWidth(self, width: int) -> None:
        """ Meaningful only for column headers in report mode.

            Source: https://docs.wxpython.org/wx.ListItem.html
        """

    Align: 'ListColumnFormat'  # See GetAlign and SetAlign
    BackgroundColour: 'Colour'  # See GetBackgroundColour and SetBackgroundColour
    Column: int  # See GetColumn and SetColumn
    Data: int  # See GetData and SetData
    Font: '_Font'  # See GetFont and SetFont
    Id: int  # See GetId and SetId
    Image: int  # See GetImage and SetImage
    Mask: int  # See GetMask and SetMask
    State: int  # See GetState and SetState
    Text: str  # See GetText and SetText
    TextColour: 'Colour'  # See GetTextColour and SetTextColour
    Width: int  # See GetWidth and SetWidth



LIST_MASK_STATE: int

LIST_MASK_TEXT: int

LIST_MASK_IMAGE: int

LIST_MASK_DATA: int

LIST_MASK_WIDTH: int

LIST_MASK_FORMAT: int

class ListView(ListCtrl):
    """ This class currently simply presents a simpler to use interface for
the ListCtrl  it can be thought of as a faÃ§ade for that complicated
class.

        Source: https://docs.wxpython.org/wx.ListView.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def ClearColumnImage(self, col: int) -> None:
        """ Resets the column image â  after calling this function, no image will be shown.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def Focus(self, index: int) -> None:
        """ Sets focus to the item with the given index.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def GetFirstSelected(self) -> int:
        """ Returns the first selected item in a (presumably) multiple selection control.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def GetFocusedItem(self) -> int:
        """ Returns the currently focused item or -1 if none.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def GetNextSelected(self, item: int) -> int:
        """ Used together with GetFirstSelected   to iterate over all selected items in the control.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def IsSelected(self, index: int) -> bool:
        """ Returns True if the item with the given index  is selected, False otherwise.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def Select(self, n, on=True) -> None:
        """ Selects or unselects the given item.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    def SetColumnImage(self, col, image) -> None:
        """ Sets the column image for the specified column.

            Source: https://docs.wxpython.org/wx.ListView.html
        """

    FirstSelected: int  # See GetFirstSelected
    FocusedItem: int  # See GetFocusedItem



class Locale:
    """ Locale class encapsulates all language-dependent settings and is a
generalization of the C locale concept.

        Source: https://docs.wxpython.org/wx.Locale.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def AddCatalog(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def AddCatalogLookupPathPrefix(prefix: str) -> None:
        """ Calls wx.FileTranslationsLoader.AddCatalogLookupPathPrefix .

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def AddLanguage(info: 'LanguageInfo') -> None:
        """ Adds custom, user-defined language to the database of known languages.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def FindLanguageInfo(locale: str) -> 'LanguageInfo':
        """ This function may be used to find the language description structure for the given locale, specified either as a two letter ISO language code (for example, âptâ), a language code followed by the country code (âpt_BRâ) or a full, human readable, language description (âPortuguese_Brazilâ).

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def GetCanonicalName(self) -> str:
        """ Returns the canonical form of current locale name.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def GetHeaderValue(self, header, domain="") -> str:
        """ Calls wx.Translations.GetHeaderValue .

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetInfo(index, cat=LOCALE_CAT_DEFAULT) -> str:
        """ Get the values of the given locale-dependent datum.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def GetLanguage(self) -> int:
        """ Returns the   wx.Language  constant of current language.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetLanguageCanonicalName(lang: int) -> str:
        """ Returns canonical name (see GetCanonicalName ) of the given language or empty string if this language is unknown.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetLanguageInfo(lang: int) -> 'LanguageInfo':
        """ Returns a pointer to   wx.LanguageInfo  structure containing information about the given language or None if this language is unknown.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetLanguageName(lang: int) -> str:
        """ Returns English name of the given language or empty string if this language is unknown.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def GetLocale(self) -> str:
        """ Returns the locale name as passed to the constructor or Init .

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def GetName(self) -> str:
        """ Returns the current short name for the locale (as given to the constructor or the Init   function).

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetOSInfo(index, cat=LOCALE_CAT_DEFAULT) -> str:
        """ Get the values of a locale datum in the OS locale.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def GetString(self, *args, **kw) -> str:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def GetSysName(self) -> str:
        """ Returns current platform-specific locale name as passed to setlocale().

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetSystemEncoding() -> int:
        """ Tries to detect the userâs default font encoding.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetSystemEncodingName() -> str:
        """ Tries to detect the name of the userâs default font encoding.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def GetSystemLanguage() -> int:
        """ Tries to detect the userâs default locale setting.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def Init(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    @staticmethod
    def IsAvailable(lang: int) -> bool:
        """ Check whether the operating system and/or C run time environment supports this locale.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def IsLoaded(self, domain: str) -> bool:
        """ Calls wx.Translations.IsLoaded .

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the locale could be set successfully.

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.Locale.html
        """

    CanonicalName: str  # See GetCanonicalName
    Language: int  # See GetLanguage
    Locale: str  # See GetLocale
    Name: str  # See GetName
    SysName: str  # See GetSysName



LOCALE_CAT_DEFAULT: int

LOCALE_LOAD_DEFAULT: int

LOCALE_DONT_LOAD_DEFAULT: int

class Log:
    """ Log class defines the interface for the log targets used by
wxWidgets logging functions as explained in the Logging Overview.

        Source: https://docs.wxpython.org/wx.Log.html
    """
    @staticmethod
    def AddTraceMask(mask: str) -> None:
        """ Add the mask  to the list of allowed masks for wx.LogTrace     .

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def ClearTraceMasks() -> None:
        """ Removes all trace masks previously set with AddTraceMask .

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def DisableTimestamp() -> None:
        """ Disables time stamping of the log messages.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    def DoLogRecord(self, level, msg, info) -> None:
        """ Called to log a new record.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    def DoLogText(self, msg: str) -> None:
        """ Called to log the specified string.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    def DoLogTextAtLevel(self, level, msg) -> None:
        """ Called to log the specified string at given level.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def DontCreateOnDemand() -> None:
        """ Instructs   wx.Log  to not create new log targets on the fly if there is none currently (see GetActiveTarget ).

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def EnableLogging(enable: bool=True) -> bool:
        """ Globally enable or disable logging.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    def Flush(self) -> None:
        """ Show all pending output and clear the buffer.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def FlushActive() -> None:
        """ Flushes the current log target if any, does nothing if there is none.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def GetActiveTarget() -> 'Log':
        """ Returns the pointer to the active log target (may be None).

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def GetLogLevel() -> 'LogLevel':
        """ Returns the current log level limit.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def GetRepetitionCounting() -> bool:
        """ Returns whether the repetition counting mode is enabled.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def GetTimestamp() -> str:
        """ Returns the current timestamp format string.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def GetTraceMasks() -> list[str]:
        """ Returns the currently allowed list of string trace masks.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def GetVerbose() -> bool:
        """ Returns whether the verbose mode is currently active.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def IsAllowedTraceMask(mask: str) -> bool:
        """ Returns True if the mask  is one of allowed masks for wx.LogTrace     .

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def IsEnabled() -> bool:
        """ Returns True if logging is enabled at all now.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def IsLevelEnabled(level, component) -> bool:
        """ Returns True if logging at this level is enabled for the current thread.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    def LogRecord(self, level, msg, info) -> None:
        """ Log the given record.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def RemoveTraceMask(mask: str) -> None:
        """ Remove the mask  from the list of allowed masks for wx.LogTrace     .

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def Resume() -> None:
        """ Resumes logging previously suspended by a call to Suspend .

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def SetActiveTarget(logtarget: 'Log') -> 'Log':
        """ Sets the specified log target as the active one.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def SetComponentLevel(component, level) -> None:
        """ Sets the log level for the given component.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    def SetFormatter(self, formatter: 'LogFormatter') -> 'LogFormatter':
        """ Sets the specified formatter as the active one.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def SetLogLevel(logLevel: 'LogLevel') -> None:
        """ Specifies that log messages with level greater (numerically) than logLevel  should be ignored and not sent to the active log target.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def SetRepetitionCounting(repetCounting: bool=True) -> None:
        """ Enables logging mode in which a log message is logged once, and in case exactly the same message successively repeats one or more times, only the number of repetitions is logged.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def SetThreadActiveTarget(logger: 'Log') -> 'Log':
        """ Sets a thread-specific log target.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def SetTimestamp(format: str) -> None:
        """ Sets the timestamp format prepended by the default log targets to all messages.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def SetVerbose(verbose: bool=True) -> None:
        """ Activates or deactivates verbose mode in which the verbose messages are logged as the normal ones instead of being silently dropped.

            Source: https://docs.wxpython.org/wx.Log.html
        """

    @staticmethod
    def Suspend() -> None:
        """ Suspends the logging until Resume   is called.

            Source: https://docs.wxpython.org/wx.Log.html
        """



LOG_Warning: int

LOG_COMPONENT: int

class LogBuffer(Log):
    """ LogBuffer is a very simple implementation of log sink which simply
collects all the logged messages in a string (except the debug
messages which are output in the usual way immediately as weâre
presumably not interested in collecting them for later).

        Source: https://docs.wxpython.org/wx.LogBuffer.html
    """
    def __init__(self) -> None:
        """ The default constructor does nothing.

            Source: https://docs.wxpython.org/wx.LogBuffer.html
        """

    def Flush(self) -> None:
        """ Shows all the messages collected so far to the user (using a message box in the GUI applications or by printing them out to the console in text mode) and clears the internal buffer.

            Source: https://docs.wxpython.org/wx.LogBuffer.html
        """

    def GetBuffer(self) -> str:
        """ Returns the current buffer contains.

            Source: https://docs.wxpython.org/wx.LogBuffer.html
        """

    Buffer: str  # See GetBuffer



class LogChain(Log):
    """ This simple class allows you to chain log sinks, that is to install a
new sink but keep passing log messages to the old one instead of
replacing it completely as Log.SetActiveTarget does.

        Source: https://docs.wxpython.org/wx.LogChain.html
    """
    def __init__(self, logger: 'Log') -> None:
        """ Sets the specified  logger   (which may be None) as the default log target but the log messages are also passed to the previous log target if any.

            Source: https://docs.wxpython.org/wx.LogChain.html
        """

    def DetachOldLog(self) -> None:
        """ Detaches the old log target so it wonât be destroyed when the   wx.LogChain  object is destroyed.

            Source: https://docs.wxpython.org/wx.LogChain.html
        """

    def GetOldLog(self) -> 'Log':
        """ Returns the pointer to the previously active log target (which may be None).

            Source: https://docs.wxpython.org/wx.LogChain.html
        """

    def IsPassingMessages(self) -> bool:
        """ Returns True if the messages are passed to the previously active log target (default) or False if PassMessages   had been called.

            Source: https://docs.wxpython.org/wx.LogChain.html
        """

    def PassMessages(self, passMessages: bool) -> None:
        """ By default, the log messages are passed to the previously active log target.

            Source: https://docs.wxpython.org/wx.LogChain.html
        """

    def SetLog(self, logger: 'Log') -> None:
        """ Sets another log target to use (may be None).

            Source: https://docs.wxpython.org/wx.LogChain.html
        """

    OldLog: 'Log'  # See GetOldLog



class LogFormatter:
    """ LogFormatter class is used to format the log messages.

        Source: https://docs.wxpython.org/wx.LogFormatter.html
    """
    def __init__(self) -> None:
        """ The default constructor does nothing.

            Source: https://docs.wxpython.org/wx.LogFormatter.html
        """

    def Format(self, level, msg, info) -> str:
        """ This function creates the full log message string.

            Source: https://docs.wxpython.org/wx.LogFormatter.html
        """

    def FormatTime(self, time: int) -> str:
        """ This function formats the time stamp part of the log message.

            Source: https://docs.wxpython.org/wx.LogFormatter.html
        """



class LogGui(Log):
    """ This is the default log target for the GUI wxWidgets applications.

        Source: https://docs.wxpython.org/wx.LogGui.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.LogGui.html
        """

    def Flush(self) -> None:
        """ Presents the accumulated log messages, if any, to the user.

            Source: https://docs.wxpython.org/wx.LogGui.html
        """



class LogInterposer(LogChain):
    """ A special version of LogChain which uses itself as the new log
target.

        Source: https://docs.wxpython.org/wx.LogInterposer.html
    """
    def __init__(self) -> None:
        """ The default constructor installs this object as the current active log target.

            Source: https://docs.wxpython.org/wx.LogInterposer.html
        """



class LogInterposerTemp(LogChain):
    """ A special version of LogChain which uses itself as the new log
target.

        Source: https://docs.wxpython.org/wx.LogInterposerTemp.html
    """
    def __init__(self) -> None:
        """ The default constructor installs this object as the current active log target.

            Source: https://docs.wxpython.org/wx.LogInterposerTemp.html
        """



class LogNull:
    """ This class allows you to temporarily suspend logging.

        Source: https://docs.wxpython.org/wx.LogNull.html
    """
    def __init__(self) -> None:
        """ Suspends logging.

            Source: https://docs.wxpython.org/wx.LogNull.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.LogNull.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.LogNull.html
        """



class LogRecordInfo:
    """ Information about a log record (unit of the log output).

        Source: https://docs.wxpython.org/wx.LogRecordInfo.html
    """
    filename: Any  # A public C++ attribute of type int. The name of the file where this log message was generated.
    func: Any  # A public C++ attribute of type int. The name of the function where the log record was generated.
    line: Any  # A public C++ attribute of type int. The line number at which this log message was generated.
    timestamp: Any  # A public C++ attribute of type int. Time when the log message was generated.
    timestampMS: Any  # A public C++ attribute of type LongLong_t. Time in milliseconds since Epoch when the log message was generated.



class LogStderr(Log):
    """ This class can be used to redirect the log messages to a C file stream
(not to be confused with C++ streams).

        Source: https://docs.wxpython.org/wx.LogStderr.html
    """
    def __init__(self) -> None:
        """ Constructs a log target which sends all the log messages to the given  FILE .

            Source: https://docs.wxpython.org/wx.LogStderr.html
        """



class LogTextCtrl(Log):
    """ Using these target all the log messages can be redirected to a text
control.

        Source: https://docs.wxpython.org/wx.LogTextCtrl.html
    """
    def __init__(self, pTextCtrl: 'TextCtrl') -> None:
        """ Constructs a log target which sends all the log messages to the given text control.

            Source: https://docs.wxpython.org/wx.LogTextCtrl.html
        """



_Frame: TypeAlias = Frame

class LogWindow(LogInterposer):
    """ This class represents a background log window: to be precise, it
collects all log messages in the log frame which it manages but also
passes them on to the log target which was active at the moment of its
creation.

        Source: https://docs.wxpython.org/wx.LogWindow.html
    """
    def __init__(self, pParent, szTitle, show=True, passToOld=True) -> None:
        """ Creates the log frame window and starts collecting the messages in it.

            Source: https://docs.wxpython.org/wx.LogWindow.html
        """

    def GetFrame(self) -> 'Frame':
        """ Returns the associated log frame window.

            Source: https://docs.wxpython.org/wx.LogWindow.html
        """

    def OnFrameClose(self, frame: 'Frame') -> bool:
        """ Called if the user closes the window interactively, will not be called if it is destroyed for another reason (such as when program exits).

            Source: https://docs.wxpython.org/wx.LogWindow.html
        """

    def OnFrameDelete(self, frame: 'Frame') -> None:
        """ Called right before the log frame is going to be deleted: will always be called unlike OnFrameClose .

            Source: https://docs.wxpython.org/wx.LogWindow.html
        """

    def Show(self, show: bool=True) -> None:
        """ Shows or hides the frame.

            Source: https://docs.wxpython.org/wx.LogWindow.html
        """

    Frame: '_Frame'  # See GetFrame



class LongPressEvent(GestureEvent):
    """ This event is generated when one finger touches the surface and
remains stationary.

        Source: https://docs.wxpython.org/wx.LongPressEvent.html
    """
    def __init__(self, windid: int=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.LongPressEvent.html
        """



EVT_LONG_PRESS: int  # Process a  wxEVT_LONG_PRESS . ^^

class Mask(Object):
    """ This class encapsulates a monochrome mask bitmap, where the masked
area is black and the unmasked area is white.

        Source: https://docs.wxpython.org/wx.Mask.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Mask.html
        """

    def GetBitmap(self) -> 'Bitmap':
        """ Returns the mask as a monochrome bitmap.

            Source: https://docs.wxpython.org/wx.Mask.html
        """

    Bitmap: '_Bitmap'  # See GetBitmap



class Matrix2D:
    """ A simple container for 2x2 matrix.

        Source: https://docs.wxpython.org/wx.Matrix2D.html
    """
    def __init__(self, v11=1, v12=0, v21=0, v22=1) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.Matrix2D.html
        """

    m_11: Any  # A public C++ attribute of type Double     . The matrix elements in the usual mathematical notation.
    m_12: Any  # A public C++ attribute of type Double     .
    m_21: Any  # A public C++ attribute of type Double     .
    m_22: Any  # A public C++ attribute of type Double     .



class MaximizeEvent(Event):
    """ An event being sent when a top level window is maximized.

        Source: https://docs.wxpython.org/wx.MaximizeEvent.html
    """
    def __init__(self, id: int=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MaximizeEvent.html
        """



EVT_MAXIMIZE: int  # Process a  wxEVT_MAXIMIZE   event. ^^

class MDIChildFrame(Frame):
    """ An MDI child frame is a frame that can only exist inside a
MDIClientWindow, which is itself a child of MDIParentFrame.

        Source: https://docs.wxpython.org/wx.MDIChildFrame.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    def Activate(self) -> None:
        """ Activates this MDI child frame.

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    def Create(self, parent, id=ID_ANY, title="", pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE, name=FrameNameStr) -> bool:
        """ Used in two-step frame construction.

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    def GetMDIParent(self) -> 'MDIParentFrame':
        """ Returns the MDI parent frame containing this child.

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    def IsAlwaysMaximized(self) -> bool:
        """ Returns True for MDI children in TDI implementations.

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    def Maximize(self, maximize: bool=True) -> None:
        """ Maximizes this MDI child frame.

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    def Restore(self) -> None:
        """ Restores this MDI child frame (unmaximizes).

            Source: https://docs.wxpython.org/wx.MDIChildFrame.html
        """

    MDIParent: 'MDIParentFrame'  # See GetMDIParent



class MDIClientWindow(Window):
    """ An MDI client window is a child of MDIParentFrame, and manages zero
or more MDIChildFrame objects.

        Source: https://docs.wxpython.org/wx.MDIClientWindow.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.MDIClientWindow.html
        """

    def CreateClient(self, parent, style=0) -> bool:
        """ Called by   wx.MDIParentFrame  immediately after creating the client window.

            Source: https://docs.wxpython.org/wx.MDIClientWindow.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.MDIClientWindow.html
        """



class MDIParentFrame(Frame):
    """ An MDI (Multiple Document Interface) parent frame is a window which
can contain MDI child frames in its client area which emulates the
full desktop.

        Source: https://docs.wxpython.org/wx.MDIParentFrame.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def ActivateNext(self) -> None:
        """ Activates the MDI child following the currently active one.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def ActivatePrevious(self) -> None:
        """ Activates the MDI child preceding the currently active one.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def ArrangeIcons(self) -> None:
        """ Arranges any iconized (minimized) MDI child windows.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def Cascade(self) -> None:
        """ Arranges the MDI child windows in a cascade.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def Create(self, parent, id=ID_ANY, title="", pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE|VSCROLL|HSCROLL, name=FrameNameStr) -> bool:
        """ Used in two-step frame construction.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def GetActiveChild(self) -> 'MDIChildFrame':
        """ Returns a pointer to the active MDI child, if there is one.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def GetClientWindow(self) -> 'MDIClientWindow':
        """ Returns a pointer to the client window.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def GetWindowMenu(self) -> 'Menu':
        """ Returns the current MDI Window menu.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    @staticmethod
    def IsTDI() -> bool:
        """ Returns whether the MDI implementation is tab-based.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def OnCreateClient(self) -> 'MDIClientWindow':
        """ Override this to return a different kind of client window.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def SetWindowMenu(self, menu: 'Menu') -> None:
        """ Replace the current MDI Window menu.

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    def Tile(self, orient: Orientation=HORIZONTAL) -> None:
        """ Tiles the MDI child windows either horizontally or vertically depending on whether orient  is  HORIZONTAL   or   VERTICAL .

            Source: https://docs.wxpython.org/wx.MDIParentFrame.html
        """

    ActiveChild: 'MDIChildFrame'  # See GetActiveChild
    ClientWindow: 'MDIClientWindow'  # See GetClientWindow
    WindowMenu: 'Menu'  # See GetWindowMenu and SetWindowMenu



FRAME_NO_WINDOW_MENU: int

class MemoryDC(DC):
    """ A memory device context provides a means to draw graphics onto a
bitmap.

        Source: https://docs.wxpython.org/wx.MemoryDC.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MemoryDC.html
        """

    def GetSelectedBitmap(self) -> 'Bitmap':
        """ wx.Bitmap

            Source: https://docs.wxpython.org/wx.MemoryDC.html
        """

    def SelectObject(self, bitmap: 'Bitmap') -> None:
        """ Allow using this device context object to modify the given bitmap contents.

            Source: https://docs.wxpython.org/wx.MemoryDC.html
        """

    def SelectObjectAsSource(self, bitmap: 'Bitmap') -> None:
        """ Selects the given bitmap into the device context, to use as the memory bitmap.

            Source: https://docs.wxpython.org/wx.MemoryDC.html
        """

    SelectedBitmap: 'Bitmap'  # See GetSelectedBitmap



class MemoryFSHandler(FileSystemHandler):
    """ This FileSystem handler can store arbitrary data in memory stream
and make them accessible via an URL.

        Source: https://docs.wxpython.org/wx.MemoryFSHandler.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MemoryFSHandler.html
        """

    @staticmethod
    def AddFile(*args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MemoryFSHandler.html
        """

    @staticmethod
    def AddFileWithMimeType(*args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MemoryFSHandler.html
        """

    @staticmethod
    def RemoveFile(filename: str) -> None:
        """ Removes a file from memory FS and frees the occupied memory.

            Source: https://docs.wxpython.org/wx.MemoryFSHandler.html
        """



class Menu(EvtHandler):
    """ A menu is a popup (or pull down) list of items, one of which may be
selected before the menu goes away (clicking elsewhere dismisses the
menu).

        Source: https://docs.wxpython.org/wx.Menu.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Append(self, *args, **kw) -> 'MenuItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def AppendCheckItem(self, id, item, help="") -> 'MenuItem':
        """ Adds a checkable item to the end of the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def AppendRadioItem(self, id, item, help="") -> 'MenuItem':
        """ Adds a radio item to the end of the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def AppendSeparator(self) -> 'MenuItem':
        """ Adds a separator to the end of the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def AppendSubMenu(self, submenu, text, help="") -> 'MenuItem':
        """ Adds the given submenu  to this menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Attach(self, menubar: 'MenuBar') -> None:
        """ menubar (wx.MenuBar) â

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Break(self) -> None:
        """ Inserts a break in a menu, causing the next appended item to appear in a new column.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Check(self, id, check) -> None:
        """ Checks or unchecks the menu item.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Delete(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def DestroyItem(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Detach(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Enable(self, id, enable) -> None:
        """ Enables or disables (greys out) a menu item.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def FindChildItem(self, id: int) -> tuple:
        """ Finds the menu item object associated with the given menu item identifier and, optionally, the position of the item in the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def FindItem(self, *args, **kw) -> int:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def FindItemById(self, id) -> 'MenuItem':
        """ FindItemById(id) . MenuItem

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def FindItemByPosition(self, position: int) -> 'MenuItem':
        """ Returns the   wx.MenuItem  given a position in the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetHelpString(self, id: int) -> str:
        """ Returns the help string associated with a menu item.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetInvokingWindow(self) -> 'Window':
        """ wx.Window

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetLabel(self, id: int) -> str:
        """ Returns a menu item label.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetLabelText(self, id: int) -> str:
        """ Returns a menu item label, without any of the original mnemonics and accelerators.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetMenuItemCount(self) -> int:
        """ Returns the number of items in the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetMenuItems(self) -> 'MenuItemList':
        """ Returns the list of items in the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetParent(self) -> 'Menu':
        """ wx.Menu

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetStyle(self) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetTitle(self) -> str:
        """ Returns the title of the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def GetWindow(self) -> 'Window':
        """ wx.Window

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Insert(self, *args, **kw) -> 'MenuItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def InsertCheckItem(self, pos, id, item, helpString="") -> 'MenuItem':
        """ Inserts a checkable item at the given position.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def InsertRadioItem(self, pos, id, item, helpString="") -> 'MenuItem':
        """ Inserts a radio item at the given position.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def InsertSeparator(self, pos: int) -> 'MenuItem':
        """ Inserts a separator at the given position.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def IsAttached(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def IsChecked(self, id: int) -> bool:
        """ Determines whether a menu item is checked.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def IsEnabled(self, id: int) -> bool:
        """ Determines whether a menu item is enabled.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Prepend(self, *args, **kw) -> 'MenuItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def PrependCheckItem(self, id, item, helpString="") -> 'MenuItem':
        """ Inserts a checkable item at position 0.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def PrependRadioItem(self, id, item, helpString="") -> 'MenuItem':
        """ Inserts a radio item at position 0.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def PrependSeparator(self) -> 'MenuItem':
        """ Inserts a separator at position 0.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def Remove(self, *args, **kw) -> 'MenuItem':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def SetHelpString(self, id, helpString) -> None:
        """ Sets an itemâs help string.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def SetInvokingWindow(self, win: 'Window') -> None:
        """ win (wx.Window) â

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def SetLabel(self, id, label) -> None:
        """ Sets the label of a menu item.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def SetParent(self, parent: 'Menu') -> None:
        """ parent (wx.Menu) â

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def SetTitle(self, title: str) -> None:
        """ Sets the title of the menu.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    def UpdateUI(self, source: Optional['EvtHandler']=None) -> None:
        """ Update the state of all menu items, recursively, by generating  wxEVT_UPDATE_UI   events for them.

            Source: https://docs.wxpython.org/wx.Menu.html
        """

    InvokingWindow: 'Window'  # See GetInvokingWindow and SetInvokingWindow
    MenuItemCount: int  # See GetMenuItemCount
    MenuItems: 'MenuItemList'  # See GetMenuItems
    Parent: 'Menu'  # See GetParent and SetParent
    Style: int  # See GetStyle
    Title: str  # See GetTitle and SetTitle
    Window: '_Window'  # See GetWindow



MENU_TEAROFF: int

class MenuBar(Window):
    """ A menu bar is a series of menus accessible from the top of a frame.

        Source: https://docs.wxpython.org/wx.MenuBar.html
    """
    def __init__(self, style: int=0) -> None:
        """ Construct an empty menu bar.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Append(self, menu, title) -> bool:
        """ Adds the item to the end of the menu bar.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Attach(self, frame: 'Frame') -> None:
        """ frame (wx.Frame) â

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Check(self, id, check) -> None:
        """ Checks or unchecks a menu item.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Detach(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Enable(self, id, enable) -> None:
        """ Enables or disables (greys out) a menu item.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def EnableTop(self, pos, enable) -> None:
        """ Enables or disables a whole menu.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def FindItem(self, id: int) -> tuple:
        """ Finds the menu item object associated with the given menu item identifier.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def FindItemById(self, id) -> 'MenuItem':
        """ FindItemById(id) . MenuItem

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def FindMenu(self, title: str) -> int:
        """ Returns the index of the menu with the given title  or  NOT_FOUND   if no such menu exists in this menubar.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def FindMenuItem(self, menuString, itemString) -> int:
        """ Finds the menu item id for a menu name/menu item string pair.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetFrame(self) -> 'Frame':
        """ wx.Frame

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetHelpString(self, id: int) -> str:
        """ Gets the help string associated with the menu item identifier.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetLabel(self, id: int) -> str:
        """ Gets the label associated with a menu item.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetMenu(self, menuIndex: int) -> 'Menu':
        """ Returns the menu at menuIndex  (zero-based).

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetMenuCount(self) -> int:
        """ Returns the number of menus in this menubar.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetMenuLabel(self, pos: int) -> str:
        """ Returns the label of a top-level menu.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetMenuLabelText(self, pos: int) -> str:
        """ Returns the label of a top-level menu.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def GetMenus(self) -> None:
        """ Return a list of (menu, label) items for the menus in the MenuBar.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Insert(self, pos, menu, title) -> bool:
        """ Inserts the menu at the given position into the menu bar.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def IsAttached(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def IsChecked(self, id: int) -> bool:
        """ Determines whether an item is checked.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def IsEnabled(self, id: int) -> bool:
        """ Determines whether an item is enabled.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def IsEnabledTop(self, pos: int) -> bool:
        """ Returns True if the menu with the given index is enabled.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    @staticmethod
    def MacGetCommonMenuBar() -> 'MenuBar':
        """ Enables you to get the global menubar on Mac, that is, the menubar displayed when the app is running without any frames open.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    @staticmethod
    def MacSetCommonMenuBar(menubar: 'MenuBar') -> None:
        """ Enables you to set the global menubar on Mac, that is, the menubar displayed when the app is running without any frames open.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def OSXGetAppleMenu(self) -> 'Menu':
        """ Returns the Apple menu.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Refresh(self, eraseBackground=True, rect=None) -> None:
        """ Redraw the menu bar.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Remove(self, pos: int) -> 'Menu':
        """ Removes the menu from the menu bar and returns the menu object - the caller is responsible for deleting it.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def Replace(self, pos, menu, title) -> 'Menu':
        """ Replaces the menu at the given position with another one.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def SetHelpString(self, id, helpString) -> None:
        """ Sets the help string associated with a menu item.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def SetLabel(self, id, label) -> None:
        """ Sets the label of a menu item.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def SetMenuLabel(self, pos, label) -> None:
        """ Sets the label of a top-level menu.

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    def SetMenus(self, items) -> None:
        """ SetMenus()

            Source: https://docs.wxpython.org/wx.MenuBar.html
        """

    Menus: None  # See GetMenus and SetMenus



MB_DOCKABLE: int

_Menu: TypeAlias = Menu

class MenuEvent(Event):
    """ This class is used for a variety of menu-related events.

        Source: https://docs.wxpython.org/wx.MenuEvent.html
    """
    def __init__(self, type=wxEVT_NULL, id=0, menu=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MenuEvent.html
        """

    def GetMenu(self) -> 'Menu':
        """ Returns the menu which is being opened or closed, or the menu containing the highlighted item.

            Source: https://docs.wxpython.org/wx.MenuEvent.html
        """

    def GetMenuId(self) -> int:
        """ Returns the menu identifier associated with the event.

            Source: https://docs.wxpython.org/wx.MenuEvent.html
        """

    def IsPopup(self) -> bool:
        """ Returns True if the menu which is being opened or closed is a popup menu, False if it is a normal one.

            Source: https://docs.wxpython.org/wx.MenuEvent.html
        """

    Menu: '_Menu'  # See GetMenu
    MenuId: int  # See GetMenuId



class MenuItem(Object):
    """ A menu item represents an item in a menu.

        Source: https://docs.wxpython.org/wx.MenuItem.html
    """
    def __init__(self, parentMenu=None, id=ID_SEPARATOR, text="", helpString="", kind=ITEM_NORMAL, subMenu=None) -> None:
        """ Constructs a   wx.MenuItem  object.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def AddExtraAccel(self, accel: AcceleratorEntry) -> None:
        """ Add an extra accelerator for this menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def Check(self, check: bool=True) -> None:
        """ Checks or unchecks the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def ClearExtraAccels(self) -> None:
        """ Clear the extra accelerators list.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def Enable(self, enable: bool=True) -> None:
        """ Enables or disables the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetAccel(self) -> 'AcceleratorEntry':
        """ Get our accelerator or None (caller must delete the pointer)

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetBackgroundColour(self) -> 'Colour':
        """ Returns the background colour associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetBitmap(self, *args, **kw) -> 'Bitmap':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetBitmapBundle(self) -> 'BitmapBundle':
        """ Returns the bitmap bundle containing the bitmap used for this item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetDisabledBitmap(self) -> 'Bitmap':
        """ Returns the bitmap used for disabled items.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetFont(self) -> 'Font':
        """ Returns the font associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetHelp(self) -> str:
        """ Returns the help string associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetId(self) -> int:
        """ Returns the menu item identifier.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetItemLabel(self) -> str:
        """ Returns the text associated with the menu item including any accelerator characters that were passed to the constructor or SetItemLabel .

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetItemLabelText(self) -> str:
        """ Returns the text associated with the menu item, without any accelerator characters.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetKind(self) -> 'ItemKind':
        """ Returns the item kind, one of  ITEM_SEPARATOR ,   ITEM_NORMAL ,   ITEM_CHECK   or   ITEM_RADIO .

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    @staticmethod
    def GetLabelText(text: str) -> str:
        """ Strips all accelerator characters and mnemonics from the given text.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetMarginWidth(self) -> int:
        """ Gets the width of the menu item checkmark bitmap.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetMenu(self) -> 'Menu':
        """ Returns the menu this menu item is in, or None if this menu item is not attached.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetSubMenu(self) -> 'Menu':
        """ Returns the submenu associated with the menu item, or None if there isnât one.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def GetTextColour(self) -> 'Colour':
        """ Returns the text colour associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def IsCheck(self) -> bool:
        """ Returns True if the item is a check item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def IsCheckable(self) -> bool:
        """ Returns True if the item is checkable.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def IsChecked(self) -> bool:
        """ Returns True if the item is checked.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def IsEnabled(self) -> bool:
        """ Returns True if the item is enabled.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def IsRadio(self) -> bool:
        """ Returns True if the item is a radio button.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def IsSeparator(self) -> bool:
        """ Returns True if the item is a separator.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def IsSubMenu(self) -> bool:
        """ Returns True if the item is a submenu.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetAccel(self, accel: 'AcceleratorEntry') -> None:
        """ Set the accel for this item - this may also be done indirectly with SetText

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetBackgroundColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the background colour associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetBitmap(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetBitmaps(self, checked, unchecked=NullBitmap) -> None:
        """ Sets the checked/unchecked bitmaps for the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetDisabledBitmap(self, disabled: 'BitmapBundle') -> None:
        """ Sets the to be used for disabled menu items.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetFont(self, font: 'Font') -> None:
        """ Sets the font associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetHelp(self, helpString: str) -> None:
        """ Sets the help string.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetItemLabel(self, label: str) -> None:
        """ Sets the label associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetMarginWidth(self, width: int) -> None:
        """ Sets the width of the menu item checkmark bitmap.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetMenu(self, menu: 'Menu') -> None:
        """ Sets the parent menu which will contain this menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetSubMenu(self, menu: 'Menu') -> None:
        """ Sets the submenu of this menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    def SetTextColour(self, colour: Union[int, str, 'Colour']) -> None:
        """ Sets the text colour associated with the menu item.

            Source: https://docs.wxpython.org/wx.MenuItem.html
        """

    Accel: 'AcceleratorEntry'  # See GetAccel and SetAccel
    BackgroundColour: 'Colour'  # See GetBackgroundColour and SetBackgroundColour
    Bitmap: '_Bitmap'  # See GetBitmap and SetBitmap
    BitmapBundle: '_BitmapBundle'  # See GetBitmapBundle
    DisabledBitmap: 'Bitmap'  # See GetDisabledBitmap and SetDisabledBitmap
    Enabled: Any  # See IsEnabled and Enable
    Font: '_Font'  # See GetFont and SetFont
    Help: str  # See GetHelp and SetHelp
    Id: int  # See GetId
    ItemLabel: str  # See GetItemLabel and SetItemLabel
    ItemLabelText: str  # See GetItemLabelText
    Kind: 'ItemKind'  # See GetKind
    MarginWidth: int  # See GetMarginWidth and SetMarginWidth
    Menu: '_Menu'  # See GetMenu and SetMenu
    SubMenu: 'Menu'  # See GetSubMenu and SetSubMenu
    TextColour: 'Colour'  # See GetTextColour and SetTextColour



WXK_DELETE: int

WXK_BACK: int

WXK_INSERT: int

WXK_RETURN: int

WXK_PAGEUP: int

WXK_PAGEDOWN: int

WXK_LEFT: int

WXK_RIGHT: int

WXK_UP: int

WXK_DOWN: int

WXK_HOME: int

WXK_END: int

WXK_SPACE: int

WXK_TAB: int

WXK_ESCAPE: int

WXK_CANCEL: int

WXK_CLEAR: int

WXK_MENU: int

WXK_PAUSE: int

WXK_CAPITAL: int

WXK_SELECT: int

WXK_PRINT: int

WXK_EXECUTE: int

WXK_SNAPSHOT: int

WXK_HELP: int

WXK_ADD: int

WXK_SEPARATOR: int

WXK_SUBTRACT: int

WXK_DECIMAL: int

WXK_DIVIDE: int

WXK_NUMLOCK: int

WXK_SCROLL: int

WXK_NUMPAD_SPACE: int

WXK_NUMPAD_TAB: int

WXK_NUMPAD_ENTER: int

WXK_NUMPAD_HOME: int

WXK_NUMPAD_LEFT: int

WXK_NUMPAD_UP: int

WXK_NUMPAD_RIGHT: int

WXK_NUMPAD_DOWN: int

WXK_NUMPAD_PAGEUP: int

WXK_NUMPAD_PAGEDOWN: int

WXK_NUMPAD_END: int

WXK_NUMPAD_BEGIN: int

WXK_NUMPAD_INSERT: int

WXK_NUMPAD_DELETE: int

WXK_NUMPAD_EQUAL: int

WXK_NUMPAD_MULTIPLY: int

WXK_NUMPAD_ADD: int

WXK_NUMPAD_SEPARATOR: int

WXK_NUMPAD_SUBTRACT: int

WXK_NUMPAD_DECIMAL: int

WXK_NUMPAD_DIVIDE: int

WXK_WINDOWS_LEFT: int

WXK_WINDOWS_RIGHT: int

WXK_WINDOWS_MENU: int

WXK_COMMAND: int

WXK_SHIFT: int

WXK_ALT: int

class MessageDialog(Dialog):
    """ This class represents a dialog that shows a single or multi-line
message, with a choice of wx.OK, Yes, No and Cancel buttons.

        Source: https://docs.wxpython.org/wx.MessageDialog.html
    """
    def __init__(self, parent, message, caption=MessageBoxCaptionStr, style=OK|CENTRE, pos=DefaultPosition) -> None:
        """ Constructor specifying the message box properties.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetCancelLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetCaption(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetEffectiveIcon(self) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetExtendedMessage(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetHelpLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetMessage(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetMessageDialogStyle(self) -> int:
        """ long

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetNoLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetOKLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def GetYesLabel(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def HasCustomLabels(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def SetExtendedMessage(self, extendedMessage: str) -> None:
        """ Sets the extended message for the dialog: this message is usually an extension of the short message specified in the constructor or set with SetMessage .

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def SetHelpLabel(self, help: MessageDialogButtonLabel) -> bool:
        """ Sets the label for the Help button.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def SetMessage(self, message: str) -> None:
        """ Sets the message shown by the dialog.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def SetOKCancelLabels(self, ok, cancel) -> bool:
        """ Overrides the default labels of the wx.OK and Cancel buttons.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def SetOKLabel(self, ok: MessageDialogButtonLabel) -> bool:
        """ Overrides the default label of the wx.OK button.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def SetYesNoCancelLabels(self, yes, no, cancel) -> bool:
        """ Overrides the default labels of the Yes, No and Cancel buttons.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def SetYesNoLabels(self, yes, no) -> bool:
        """ Overrides the default labels of the Yes and No buttons.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning one of wx.ID_OK, wx.ID_CANCEL, wx.ID_YES, wx.ID_NO or wx.ID_HELP.

            Source: https://docs.wxpython.org/wx.MessageDialog.html
        """

    CancelLabel: str  # See GetCancelLabel
    Caption: str  # See GetCaption
    EffectiveIcon: int  # See GetEffectiveIcon
    ExtendedMessage: str  # See GetExtendedMessage and SetExtendedMessage
    HelpLabel: str  # See GetHelpLabel and SetHelpLabel
    Message: str  # See GetMessage and SetMessage
    MessageDialogStyle: int  # See GetMessageDialogStyle
    NoLabel: str  # See GetNoLabel
    OKLabel: str  # See GetOKLabel and SetOKLabel
    YesLabel: str  # See GetYesLabel



class Metafile(Object):
    """ A Metafile represents the MS Windows metafile object, so metafile
operations have no effect in X.

        Source: https://docs.wxpython.org/wx.Metafile.html
    """
    def __init__(self, filename: str="") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.Metafile.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the metafile is valid.

            Source: https://docs.wxpython.org/wx.Metafile.html
        """

    def Play(self, dc: 'DC') -> bool:
        """ Plays the metafile into the given device context, returning True if successful.

            Source: https://docs.wxpython.org/wx.Metafile.html
        """

    def SetClipboard(self, width=0, height=0) -> bool:
        """ Passes the metafile data to the clipboard.

            Source: https://docs.wxpython.org/wx.Metafile.html
        """



class MimeTypesManager:
    """ This class allows the application to retrieve information about all
known MIME types from a system-specific location and the filename
extensions to the MIME types and vice versa.

        Source: https://docs.wxpython.org/wx.MimeTypesManager.html
    """
    def __init__(self) -> None:
        """ Constructor puts the object in the âworkingâ state.

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """

    def AddFallbacks(self, fallbacks: 'FileTypeInfo') -> None:
        """ This function may be used to provide hard-wired fallbacks for the MIME types and extensions that might not be present in the system MIME database.

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """

    def Associate(self, ftInfo: 'FileTypeInfo') -> 'FileType':
        """ Create a new association using the fields of   wx.FileTypeInfo  (at least the MIME type and the extension should be set).

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """

    def EnumAllFileTypes(self) -> list[str]:
        """ Returns a list of all known file types.

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """

    def GetFileTypeFromExtension(self, extension: str) -> 'FileType':
        """ Gather information about the files with given extension and return the corresponding   wx.FileType  object or None if the extension is unknown.

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """

    def GetFileTypeFromMimeType(self, mimeType: str) -> 'FileType':
        """ Gather information about the files with given MIME type and return the corresponding   wx.FileType  object or None if the MIME type is unknown.

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """

    @staticmethod
    def IsOfType(mimeType, wildcard) -> bool:
        """ This function returns True if either the given mimeType  is exactly the same as wildcard  or if it has the same category and the subtype of wildcard  is ââ.

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """

    def Unassociate(self, ft: 'FileType') -> bool:
        """ Undo Associate .

            Source: https://docs.wxpython.org/wx.MimeTypesManager.html
        """



class MiniFrame(Frame):
    """ A miniframe is a frame with a small title bar.

        Source: https://docs.wxpython.org/wx.MiniFrame.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MiniFrame.html
        """

    def Create(self, parent, id=ID_ANY, title="", pos=DefaultPosition, size=DefaultSize, style=CAPTION|RESIZE_BORDER, name=FrameNameStr) -> bool:
        """ Used in two-step frame construction.

            Source: https://docs.wxpython.org/wx.MiniFrame.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.MiniFrame.html
        """



class MirrorDC(DC):
    """ MirrorDC is a simple wrapper class which is always associated with a
real DC object and either forwards all of its operations to it
without changes (no mirroring takes place) or exchanges x and y
coordinates which makes it possible to reuse the same code to draw a
figure and its mirror  i.e.

        Source: https://docs.wxpython.org/wx.MirrorDC.html
    """
    def __init__(self, dc, mirror) -> None:
        """ Creates a (maybe) mirrored DC associated with the real dc.

            Source: https://docs.wxpython.org/wx.MirrorDC.html
        """



class ModalDialogHook:
    """ Allows intercepting all modal dialog calls.

        Source: https://docs.wxpython.org/wx.ModalDialogHook.html
    """
    def __init__(self) -> None:
        """ Default and trivial constructor.

            Source: https://docs.wxpython.org/wx.ModalDialogHook.html
        """

    def Enter(self, dialog: 'Dialog') -> int:
        """ Called by wxWidgets before showing any modal dialogs.

            Source: https://docs.wxpython.org/wx.ModalDialogHook.html
        """

    def Exit(self, dialog: 'Dialog') -> None:
        """ Called by wxWidgets after dismissing the modal dialog.

            Source: https://docs.wxpython.org/wx.ModalDialogHook.html
        """

    def Register(self) -> None:
        """ Register this hook as being active.

            Source: https://docs.wxpython.org/wx.ModalDialogHook.html
        """

    def Unregister(self) -> None:
        """ Unregister this hook.

            Source: https://docs.wxpython.org/wx.ModalDialogHook.html
        """



class MouseCaptureChangedEvent(Event):
    """ A mouse capture changed event is sent to a window that loses its mouse
capture.

        Source: https://docs.wxpython.org/wx.MouseCaptureChangedEvent.html
    """
    def __init__(self, windowId=0, gainedCapture=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MouseCaptureChangedEvent.html
        """

    def GetCapturedWindow(self) -> 'Window':
        """ Returns the window that gained the capture, or None if it was a non-wxWidgets window.

            Source: https://docs.wxpython.org/wx.MouseCaptureChangedEvent.html
        """

    CapturedWindow: 'Window'  # See GetCapturedWindow



class MouseCaptureLostEvent(Event):
    """ A mouse capture lost event is sent to a window that had obtained mouse
capture, which was subsequently lost due to an âexternalâ event (for
example, when a dialog box is shown or if another application captures
the mouse).

        Source: https://docs.wxpython.org/wx.MouseCaptureLostEvent.html
    """
    def __init__(self, windowId: int=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MouseCaptureLostEvent.html
        """



class MouseEvent(Event,MouseState):
    """ This event class contains information about the events generated by
the mouse: they include mouse buttons press and release events and
mouse move events.

        Source: https://docs.wxpython.org/wx.MouseEvent.html
    """
    def __init__(self, mouseEventType: int=wxEVT_NULL) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Aux1DClick(self) -> bool:
        """ Returns True if the event was a first extra button double click.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Aux1Down(self) -> bool:
        """ Returns True if the first extra button mouse button changed to down.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Aux1Up(self) -> bool:
        """ Returns True if the first extra button mouse button changed to up.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Aux2DClick(self) -> bool:
        """ Returns True if the event was a second extra button double click.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Aux2Down(self) -> bool:
        """ Returns True if the second extra button mouse button changed to down.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Aux2Up(self) -> bool:
        """ Returns True if the second extra button mouse button changed to up.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Button(self, but: MouseButton) -> bool:
        """ Returns True if the event was generated by the specified button.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def ButtonDClick(self, but: MouseButton=MOUSE_BTN_ANY) -> bool:
        """ If the argument is omitted, this returns True if the event was a mouse double click event.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def ButtonDown(self, but: MouseButton=MOUSE_BTN_ANY) -> bool:
        """ If the argument is omitted, this returns True if the event was a mouse button down event.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def ButtonUp(self, but: MouseButton=MOUSE_BTN_ANY) -> bool:
        """ If the argument is omitted, this returns True if the event was a mouse button up event.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Dragging(self) -> bool:
        """ Returns True if this was a dragging event (motion while a button is depressed).

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Entering(self) -> bool:
        """ Returns True if the mouse was entering the window.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetButton(self) -> int:
        """ Returns the mouse button which generated this event or  MOUSE_BTN_NONE   if no button is involved (for mouse move, enter or leave event, for example).

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetClickCount(self) -> int:
        """ Returns the number of mouse clicks for this event: 1 for a simple click, 2 for a double-click, 3 for a triple-click and so on.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetColumnsPerAction(self) -> int:
        """ Returns the configured number of columns (or whatever) to be scrolled per wheel action.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetLinesPerAction(self) -> int:
        """ Returns the configured number of lines (or whatever) to be scrolled per wheel action.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetLogicalPosition(self, dc: 'DC') -> 'Point':
        """ Returns the logical mouse position in pixels (i.e. translated according to the translation set for the DC, which usually indicates that the window has been scrolled).

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetMagnification(self) -> float:
        """ For magnify (pinch to zoom) events: returns the change in magnification.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetWheelAxis(self) -> 'MouseWheelAxis':
        """ Gets the axis the wheel operation concerns.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetWheelDelta(self) -> int:
        """ Get wheel delta, normally 120.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def GetWheelRotation(self) -> int:
        """ Get wheel rotation, positive or negative indicates direction of rotation.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def IsButton(self) -> bool:
        """ Returns True if the event was a mouse button event (not necessarily a button down event - that may be tested using ButtonDown ).

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def IsPageScroll(self) -> bool:
        """ Returns True if the system has been setup to do page scrolling with the mouse wheel instead of line scrolling.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def IsWheelInverted(self) -> bool:
        """ On Mac, has the user selected âNaturalâ scrolling in their System Preferences? Currently False on all other OSâs.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Leaving(self) -> bool:
        """ Returns True if the mouse was leaving the window.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def LeftDClick(self) -> bool:
        """ Returns True if the event was a left double click.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def LeftDown(self) -> bool:
        """ Returns True if the left mouse button changed to down.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def LeftUp(self) -> bool:
        """ Returns True if the left mouse button changed to up.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Magnify(self) -> bool:
        """ Returns True if the event is a magnify (i.e. pinch to zoom) event.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def MetaDown(self) -> bool:
        """ Returns True if the Meta key was down at the time of the event.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def MiddleDClick(self) -> bool:
        """ Returns True if the event was a middle double click.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def MiddleDown(self) -> bool:
        """ Returns True if the middle mouse button changed to down.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def MiddleUp(self) -> bool:
        """ Returns True if the middle mouse button changed to up.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def Moving(self) -> bool:
        """ Returns True if this was a motion event and no mouse buttons were pressed.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def RightDClick(self) -> bool:
        """ Returns True if the event was a right double click.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def RightDown(self) -> bool:
        """ Returns True if the right mouse button changed to down.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def RightUp(self) -> bool:
        """ Returns True if the right mouse button changed to up.

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def SetColumnsPerAction(self, columnsPerAction) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def SetLinesPerAction(self, linesPerAction) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def SetWheelAxis(self, wheelAxis) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def SetWheelDelta(self, wheelDelta) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    def SetWheelRotation(self, wheelRotation) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.MouseEvent.html
        """

    ColumnsPerAction: int  # See GetColumnsPerAction and SetColumnsPerAction
    LinesPerAction: int  # See GetLinesPerAction and SetLinesPerAction
    WheelAxis: 'MouseWheelAxis'  # See GetWheelAxis and SetWheelAxis
    WheelDelta: int  # See GetWheelDelta and SetWheelDelta
    WheelRotation: int  # See GetWheelRotation and SetWheelRotation



EVT_LEFT_DOWN: int  # Process a  wxEVT_LEFT_DOWN   event. The handler of this event should normally call event.Skip() to allow the default processing to take place as otherwise the window under mouse wouldnât get the focus.

EVT_LEFT_UP: int  # Process a  wxEVT_LEFT_UP   event.

EVT_LEFT_DCLICK: int  # Process a  wxEVT_LEFT_DCLICK   event.

EVT_MIDDLE_DOWN: int  # Process a  wxEVT_MIDDLE_DOWN   event.

EVT_MIDDLE_UP: int  # Process a  wxEVT_MIDDLE_UP   event.

EVT_MIDDLE_DCLICK: int  # Process a  wxEVT_MIDDLE_DCLICK   event.

EVT_RIGHT_DOWN: int  # Process a  wxEVT_RIGHT_DOWN   event.

EVT_RIGHT_UP: int  # Process a  wxEVT_RIGHT_UP   event.

EVT_RIGHT_DCLICK: int  # Process a  wxEVT_RIGHT_DCLICK   event.

EVT_MOUSE_AUX1_DOWN: int  # Process a  wxEVT_AUX1_DOWN   event.

EVT_MOUSE_AUX1_UP: int  # Process a  wxEVT_AUX1_UP   event.

EVT_MOUSE_AUX1_DCLICK: int  # Process a  wxEVT_AUX1_DCLICK   event.

EVT_MOUSE_AUX2_DOWN: int  # Process a  wxEVT_AUX2_DOWN   event.

EVT_MOUSE_AUX2_UP: int  # Process a  wxEVT_AUX2_UP   event.

EVT_MOUSE_AUX2_DCLICK: int  # Process a  wxEVT_AUX2_DCLICK   event.

EVT_MOTION: int  # Process a  wxEVT_MOTION   event.

EVT_ENTER_WINDOW: int  # Process a  wxEVT_ENTER_WINDOW   event.

EVT_LEAVE_WINDOW: int  # Process a  wxEVT_LEAVE_WINDOW   event.

EVT_MOUSEWHEEL: int  # Process a  wxEVT_MOUSEWHEEL   event.

EVT_MOUSE_EVENTS: int  # Process all mouse events.

EVT_MAGNIFY: int  # Process a  wxEVT_MAGNIFY   event (new since wxWidgets 3.1.0). ^^

class MouseEventsManager(EvtHandler):
    """ Helper for handling mouse input events in windows containing multiple
items.

        Source: https://docs.wxpython.org/wx.MouseEventsManager.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def Create(self, win: 'Window') -> bool:
        """ Finishes initialization of the object created using default constructor.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseClickBegin(self, item: int) -> None:
        """ May be overridden to update the state of an item when it is pressed.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseClickCancelled(self, item: int) -> None:
        """ Must be overridden to reset the item appearance changed by MouseClickBegin .

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseClicked(self, item: int) -> bool:
        """ Must be overridden to react to mouse clicks.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseDragBegin(self, item, pos) -> bool:
        """ Must be overridden to allow or deny dragging of the item.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseDragCancelled(self, item: int) -> None:
        """ Must be overridden to handle cancellation of mouse dragging.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseDragEnd(self, item, pos) -> None:
        """ Must be overridden to handle item drop.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseDragging(self, item, pos) -> None:
        """ Must be overridden to provide feed back while an item is being dragged.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """

    def MouseHitTest(self, pos: Union[tuple[int, int], 'Point']) -> int:
        """ Must be overridden to return the item at the given position.

            Source: https://docs.wxpython.org/wx.MouseEventsManager.html
        """



class MouseState(KeyboardState):
    """ Represents the mouse state.

        Source: https://docs.wxpython.org/wx.MouseState.html
    """
    def __init__(self) -> None:
        """ Default constructor.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def Aux1IsDown(self) -> bool:
        """ Returns True if the first extra button mouse button is currently down.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def Aux2IsDown(self) -> bool:
        """ Returns True if the second extra button mouse button is currently down.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the physical mouse position.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def GetX(self) -> 'Coord':
        """ Returns X coordinate of the physical mouse event position.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def GetY(self) -> 'Coord':
        """ Returns Y coordinate of the physical mouse event position.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def LeftIsDown(self) -> bool:
        """ Returns True if the left mouse button is currently down.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def MiddleIsDown(self) -> bool:
        """ Returns True if the middle mouse button is currently down.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def RightIsDown(self) -> bool:
        """ Returns True if the right mouse button is currently down.

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetAux1Down(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetAux2Down(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetLeftDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetMiddleDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetPosition(self, pos: Union[tuple[int, int], 'Point']) -> None:
        """ pos (wx.Point) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetRightDown(self, down: bool) -> None:
        """ down (bool) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetState(self, state: 'MouseState') -> None:
        """ state (wx.MouseState) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetX(self, x: int) -> None:
        """ x (int) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    def SetY(self, y: int) -> None:
        """ y (int) â

            Source: https://docs.wxpython.org/wx.MouseState.html
        """

    Position: 'Point'  # See GetPosition and SetPosition
    X: 'Coord'  # See GetX and SetX
    Y: 'Coord'  # See GetY and SetY
    aux1IsDown: Any  # See Aux1IsDown and SetAux1Down
    aux2IsDown: Any  # See Aux2IsDown and SetAux2Down
    leftIsDown: Any  # See LeftIsDown and SetLeftDown
    middleIsDown: Any  # See MiddleIsDown and SetMiddleDown
    rightIsDown: Any  # See RightIsDown and SetRightDown
    x: Any  # See GetX and SetX
    y: Any  # See GetY and SetY



class MoveEvent(Event):
    """ A move event holds information about window position change.

        Source: https://docs.wxpython.org/wx.MoveEvent.html
    """
    def __init__(self, pt, id=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.MoveEvent.html
        """

    def GetPosition(self) -> 'Point':
        """ Returns the position of the window generating the move change event.

            Source: https://docs.wxpython.org/wx.MoveEvent.html
        """

    def GetRect(self) -> 'Rect':
        """ wx.Rect

            Source: https://docs.wxpython.org/wx.MoveEvent.html
        """

    def SetPosition(self, pos: Union[tuple[int, int], 'Point']) -> None:
        """ pos (wx.Point) â

            Source: https://docs.wxpython.org/wx.MoveEvent.html
        """

    def SetRect(self, rect: 'Rect') -> None:
        """ rect (wx.Rect) â

            Source: https://docs.wxpython.org/wx.MoveEvent.html
        """

    Position: 'Point'  # See GetPosition and SetPosition
    Rect: '_Rect'  # See GetRect and SetRect



EVT_MOVE: int  # Process a  wxEVT_MOVE   event, which is generated when a window is moved.

EVT_MOVE_START: int  # Process a  wxEVT_MOVE_START   event, which is generated when the user starts to move or size a window. wxMSW only.

EVT_MOVING: int  # Process a  wxEVT_MOVING   event, which is generated while the user is moving the window. wxMSW only.

EVT_MOVE_END: int  # Process a  wxEVT_MOVE_END   event, which is generated when the user stops moving or sizing a window. wxMSW only. ^^

class MultiChoiceDialog(Dialog):
    """ This class represents a dialog that shows a list of strings, and
allows the user to select one or more.

        Source: https://docs.wxpython.org/wx.MultiChoiceDialog.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.MultiChoiceDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.MultiChoiceDialog.html
        """

    def GetSelections(self) -> list[int]:
        """ Returns array with indexes of selected items.

            Source: https://docs.wxpython.org/wx.MultiChoiceDialog.html
        """

    def SetSelections(self, selections: list[int]) -> None:
        """ Sets selected items from the array of selected itemsâ indexes.

            Source: https://docs.wxpython.org/wx.MultiChoiceDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning either wx.ID_OK or wx.ID_CANCEL.

            Source: https://docs.wxpython.org/wx.MultiChoiceDialog.html
        """

    Selections: list[int]  # See GetSelections and SetSelections



class NativeFontInfo:
    """ NativeFontInfo is platform-specific font representation: this class
should be considered as an opaque font description only used by the
native functions, the user code can only get the objects of this type
from somewhere and pass it somewhere else (possibly save them
somewhere using ToString() and restore them using FromString())

        Source: https://docs.wxpython.org/wx.NativeFontInfo.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def FromString(self, s: str) -> bool:
        """ s (string) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def FromUserString(self, s: str) -> bool:
        """ s (string) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetEncoding(self) -> int:
        """ wx.FontEncoding

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetFaceName(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetFamily(self) -> int:
        """ wx.FontFamily

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetFractionalPointSize(self) -> float:
        """ float

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetNumericWeight(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetPointSize(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetStyle(self) -> int:
        """ wx.FontStyle

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetUnderlined(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def GetWeight(self) -> int:
        """ wx.FontWeight

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def Init(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def InitFromFont(self, font: 'Font') -> None:
        """ font (wx.Font) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetEncoding(self, encoding: int) -> None:
        """ encoding (FontEncoding) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetFaceName(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetFamily(self, family: int) -> None:
        """ family (FontFamily) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetFractionalPointSize(self, pointsize: float) -> None:
        """ pointsize (float) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetNumericWeight(self, weight: int) -> None:
        """ weight (int) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetPointSize(self, pointsize: int) -> None:
        """ pointsize (int) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetStyle(self, style: int) -> None:
        """ style (FontStyle) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetUnderlined(self, underlined: bool) -> None:
        """ underlined (bool) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def SetWeight(self, weight: int) -> None:
        """ weight (FontWeight) â

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def ToString(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def ToUserString(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    def __str__(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.NativeFontInfo.html
        """

    Encoding: int  # See GetEncoding and SetEncoding
    FaceName: str  # See GetFaceName and SetFaceName
    Family: int  # See GetFamily and SetFamily
    FractionalPointSize: float  # See GetFractionalPointSize and SetFractionalPointSize
    NumericWeight: int  # See GetNumericWeight and SetNumericWeight
    PointSize: int  # See GetPointSize and SetPointSize
    Style: int  # See GetStyle and SetStyle
    Underlined: bool  # See GetUnderlined and SetUnderlined
    Weight: int  # See GetWeight and SetWeight



class NativePixelData:
    """ A class providing direct access to a wx.Bitmapâs
internal data without alpha channel (RGB).

        Source: https://docs.wxpython.org/wx.NativePixelData.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.NativePixelData.html
        """

    def GetPixels(self) -> 'NativePixelData_Accessor':
        """ wx.NativePixelData_Accessor

            Source: https://docs.wxpython.org/wx.NativePixelData.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.NativePixelData.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.NativePixelData.html
        """

    Pixels: 'NativePixelData_Accessor'  # See GetPixels



class NativePixelData_Accessor:
    """  Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def Get(self) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def IsOk(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def MoveTo(self, data, x, y) -> None:
        """ data (NativePixelData) â

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def Offset(self, data, x, y) -> None:
        """ data (NativePixelData) â

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def OffsetX(self, data, x) -> None:
        """ data (NativePixelData) â

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def OffsetY(self, data, y) -> None:
        """ data (NativePixelData) â

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def Reset(self, data: NativePixelData) -> None:
        """ data (NativePixelData) â

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def Set(self, red, green, blue) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """

    def nextPixel(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.NativePixelData_Accessor.html
        """



class NavigationKeyEvent(Event):
    """ This event class contains information about navigation events,
generated by navigation keys such as tab and page down.

        Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def GetCurrentFocus(self) -> 'Window':
        """ Returns the child that has the focus, or None.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def GetDirection(self) -> bool:
        """ Returns True if the navigation was in the forward direction.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def IsFromTab(self) -> bool:
        """ Returns True if the navigation event was from a tab key.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def IsWindowChange(self) -> bool:
        """ Returns True if the navigation event represents a window change (for example, from Ctrl-Page Down in a notebook).

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def SetCurrentFocus(self, currentFocus: 'Window') -> None:
        """ Sets the current focus window member.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def SetDirection(self, direction: bool) -> None:
        """ Sets the direction to forward if direction  is True, or backward if False.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def SetFlags(self, flags: int) -> None:
        """ Sets the flags for this event.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def SetFromTab(self, fromTab: bool) -> None:
        """ Marks the navigation event as from a tab key.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    def SetWindowChange(self, windowChange: bool) -> None:
        """ Marks the event as a window change event.

            Source: https://docs.wxpython.org/wx.NavigationKeyEvent.html
        """

    CurrentFocus: 'Window'  # See GetCurrentFocus and SetCurrentFocus
    Direction: bool  # See GetDirection and SetDirection



class NonOwnedWindow(Window):
    """ Common base class for all non-child windows.

        Source: https://docs.wxpython.org/wx.NonOwnedWindow.html
    """
    def SetShape(self, *args, **kw) -> bool:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.NonOwnedWindow.html
        """



class NotifyEvent(CommandEvent):
    """ This class is not used by the event handlers by itself, but is a base
class for other event classes (such as BookCtrlEvent).

        Source: https://docs.wxpython.org/wx.NotifyEvent.html
    """
    def __init__(self, eventType=wxEVT_NULL, id=0) -> None:
        """ Constructor (used internally by wxWidgets only).

            Source: https://docs.wxpython.org/wx.NotifyEvent.html
        """

    def Allow(self) -> None:
        """ This is the opposite of Veto : it explicitly allows the event to be processed.

            Source: https://docs.wxpython.org/wx.NotifyEvent.html
        """

    def IsAllowed(self) -> bool:
        """ Returns True if the change is allowed ( Veto   hasnât been called) or False otherwise (if it was).

            Source: https://docs.wxpython.org/wx.NotifyEvent.html
        """

    def Veto(self) -> None:
        """ Prevents the change announced by this event from happening.

            Source: https://docs.wxpython.org/wx.NotifyEvent.html
        """



class NumberEntryDialog(Dialog):
    """ This class represents a dialog that requests a numeric input from the
user.

        Source: https://docs.wxpython.org/wx.NumberEntryDialog.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.NumberEntryDialog.html
        """

    def Create(self, parent, message, prompt, caption, value, min, max, pos=DefaultPosition) -> bool:
        """ parent (wx.Window) â Parent window.

            Source: https://docs.wxpython.org/wx.NumberEntryDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.NumberEntryDialog.html
        """

    def GetValue(self) -> int:
        """ Returns the value that the user has entered if the user has pressed wx.OK, or the original value if the user has pressed Cancel.

            Source: https://docs.wxpython.org/wx.NumberEntryDialog.html
        """

    Value: int  # See GetValue



_ClassInfo: TypeAlias = ClassInfo

class Object:
    """ This is the root class of many of the wxWidgets classes.

        Source: https://docs.wxpython.org/wx.Object.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def Destroy(self) -> bool:
        """ Deletes the C++ object this Python object is a proxy for.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def GetClassInfo(self) -> 'ClassInfo':
        """ This virtual function is redefined for every class that requires run-time type information, when using the DECLARE_CLASS  macro (or similar).

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def GetClassName(self) -> 'Char':
        """ Returns the class name of the C++ class using RTTI.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def GetRefData(self) -> 'ObjectRefData':
        """ Returns the Object.m_refData  pointer, i.e. the data referenced by this object.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def IsSameAs(self, obj: 'Object') -> bool:
        """ Returns True if this object has the same data pointer as obj.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def Ref(self, clone: 'Object') -> None:
        """ Makes this object refer to the data in clone.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def SetRefData(self, data: 'ObjectRefData') -> None:
        """ Sets the Object.m_refData  pointer.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def UnRef(self) -> None:
        """ Decrements the reference count in the associated data, and if it is zero, deletes the data.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    def UnShare(self) -> None:
        """ This is the same of AllocExclusive   but this method is public.

            Source: https://docs.wxpython.org/wx.Object.html
        """

    ClassInfo: '_ClassInfo'  # See GetClassInfo
    ClassName: 'Char'  # See GetClassName
    RefData: 'ObjectRefData'  # See GetRefData and SetRefData



class OutputStream(StreamBase):
    """ OutputStream is an abstract base class which may not be used
directly.

        Source: https://docs.wxpython.org/wx.OutputStream.html
    """
    def __init__(self) -> None:
        """ Creates a dummy   wx.OutputStream  object.

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def Close(self) -> bool:
        """ Closes the stream, returning False if an error occurs.

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def LastWrite(self) -> int:
        """ Returns the number of bytes written during the last Write .

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def PutC(self, c: int) -> None:
        """ Puts the specified character in the output queue and increments the stream position.

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def SeekO(self, pos, mode=FromStart) -> 'FileOffset':
        """ Changes the stream current position.

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def TellO(self) -> 'FileOffset':
        """ Returns the current stream position.

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def Write(self, *args, **kw) -> 'OutputStream':
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def WriteAll(self, buffer, size) -> bool:
        """ Writes exactly the specified number of bytes from the buffer.

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def close(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def eof(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def flush(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def seek(self, offset, whence=0) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def tell(self) -> 'FileOffset':
        """ wx.FileOffset

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """

    def write(self, data) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.OutputStream.html
        """



class Overlay:
    """ Creates an overlay over an existing window, allowing for manipulations
like rubberbanding, etc.

        Source: https://docs.wxpython.org/wx.Overlay.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Overlay.html
        """

    def Reset(self) -> None:
        """ Clears the overlay without restoring the former state.

            Source: https://docs.wxpython.org/wx.Overlay.html
        """



class PageSetupDialog(Object):
    """ This class represents the page setup common dialog.

        Source: https://docs.wxpython.org/wx.PageSetupDialog.html
    """
    def __init__(self, parent, data=None) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PageSetupDialog.html
        """

    def GetPageSetupData(self) -> 'PageSetupDialogData':
        """ Returns the   wx.PageSetupDialogData  object associated with the dialog.

            Source: https://docs.wxpython.org/wx.PageSetupDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning  ID_OK   if the user pressed wx.OK, and   ID_CANCEL   otherwise.

            Source: https://docs.wxpython.org/wx.PageSetupDialog.html
        """

    PageSetupData: 'PageSetupDialogData'  # See GetPageSetupData



_PrintData: TypeAlias = PrintData

class PageSetupDialogData(Object):
    """ This class holds a variety of information related to
PageSetupDialog.

        Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def EnableHelp(self, flag: bool) -> None:
        """ Enables or disables the âHelpâ button (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def EnableMargins(self, flag: bool) -> None:
        """ Enables or disables the margin controls (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def EnableOrientation(self, flag: bool) -> None:
        """ Enables or disables the orientation control (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def EnablePaper(self, flag: bool) -> None:
        """ Enables or disables the paper size control (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def EnablePrinter(self, flag: bool) -> None:
        """ Enables or disables the âPrinterâ button, which invokes a printer setup dialog.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetDefaultInfo(self) -> bool:
        """ Returns True if the dialog will simply return default printer information (such as orientation) instead of showing a dialog (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetDefaultMinMargins(self) -> bool:
        """ Returns True if the page setup dialog will take its minimum margin values from the currently selected printer properties (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetEnableHelp(self) -> bool:
        """ Returns True if the printer setup button is enabled.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetEnableMargins(self) -> bool:
        """ Returns True if the margin controls are enabled (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetEnableOrientation(self) -> bool:
        """ Returns True if the orientation control is enabled (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetEnablePaper(self) -> bool:
        """ Returns True if the paper size control is enabled (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetEnablePrinter(self) -> bool:
        """ Returns True if the printer setup button is enabled.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetMarginBottomRight(self) -> 'Point':
        """ Returns the right (x) and bottom (y) margins in millimetres.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetMarginTopLeft(self) -> 'Point':
        """ Returns the left (x) and top (y) margins in millimetres.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetMinMarginBottomRight(self) -> 'Point':
        """ Returns the right (x) and bottom (y) minimum margins the user can enter (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetMinMarginTopLeft(self) -> 'Point':
        """ Returns the left (x) and top (y) minimum margins the user can enter (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetPaperId(self) -> 'PaperSize':
        """ Returns the paper id (stored in the internal   wx.PrintData  object).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetPaperSize(self) -> 'Size':
        """ Returns the paper size in millimetres.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def GetPrintData(self) -> 'PrintData':
        """ Returns a reference to the print data associated with this object.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the print data associated with the dialog data is valid.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetDefaultInfo(self, flag: bool) -> None:
        """ Pass True if the dialog will simply return default printer information (such as orientation) instead of showing a dialog (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetDefaultMinMargins(self, flag: bool) -> None:
        """ Pass True if the page setup dialog will take its minimum margin values from the currently selected printer properties (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetMarginBottomRight(self, pt: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the right (x) and bottom (y) margins in millimetres.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetMarginTopLeft(self, pt: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the left (x) and top (y) margins in millimetres.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetMinMarginBottomRight(self, pt: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the right (x) and bottom (y) minimum margins the user can enter (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetMinMarginTopLeft(self, pt: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the left (x) and top (y) minimum margins the user can enter (Windows only).

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetPaperId(self, id: PaperSize) -> None:
        """ Sets the paper size id.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetPaperSize(self, size: Union[tuple[int, int], 'Size']) -> None:
        """ Sets the paper size in millimetres.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def SetPrintData(self, printData: 'PrintData') -> None:
        """ Sets the print data associated with this object.

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.PageSetupDialogData.html
        """

    MarginBottomRight: 'Point'  # See GetMarginBottomRight and SetMarginBottomRight
    MarginTopLeft: 'Point'  # See GetMarginTopLeft and SetMarginTopLeft
    MinMarginBottomRight: 'Point'  # See GetMinMarginBottomRight and SetMinMarginBottomRight
    MinMarginTopLeft: 'Point'  # See GetMinMarginTopLeft and SetMinMarginTopLeft
    PaperId: 'PaperSize'  # See GetPaperId and SetPaperId
    PaperSize: 'Size'  # See GetPaperSize and SetPaperSize
    PrintData: '_PrintData'  # See GetPrintData and SetPrintData



class PaintEvent(Event):
    """ A paint event is sent when a windowâs contents needs to be repainted.

        Source: https://docs.wxpython.org/wx.PaintEvent.html
    """
    def __init__(self, window: 'Window') -> None:
        """ Constructor for exclusive use of wxWidgets itself.

            Source: https://docs.wxpython.org/wx.PaintEvent.html
        """



class Palette(GDIObject):
    """ A palette is a table that maps pixel values to RGB colours.

        Source: https://docs.wxpython.org/wx.Palette.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Palette.html
        """

    def Create(self, red, green, blue) -> None:
        """ Creates a palette from 3 sequences of integers, one for each red, blue or green component.

            Source: https://docs.wxpython.org/wx.Palette.html
        """

    def GetColoursCount(self) -> int:
        """ Returns number of entries in palette.

            Source: https://docs.wxpython.org/wx.Palette.html
        """

    def GetPixel(self, red, green, blue) -> int:
        """ Returns a pixel value (index into the palette) for the given RGB values.

            Source: https://docs.wxpython.org/wx.Palette.html
        """

    def GetRGB(self, pixel) -> tuple:
        """ Returns RGB values for a given palette index.

            Source: https://docs.wxpython.org/wx.Palette.html
        """

    def IsOk(self) -> bool:
        """ Returns True if palette data is present.

            Source: https://docs.wxpython.org/wx.Palette.html
        """

    ColoursCount: int  # See GetColoursCount
    RGB: tuple  # See GetRGB



class PaletteChangedEvent(Event):
    """ winid (wx.WindowID) â 

        Source: https://docs.wxpython.org/wx.PaletteChangedEvent.html
    """
    def __init__(self, winid: int=0) -> None:
        """ winid (wx.WindowID) â

            Source: https://docs.wxpython.org/wx.PaletteChangedEvent.html
        """

    def GetChangedWindow(self) -> 'Window':
        """ wx.Window

            Source: https://docs.wxpython.org/wx.PaletteChangedEvent.html
        """

    def SetChangedWindow(self, win: 'Window') -> None:
        """ win (wx.Window) â

            Source: https://docs.wxpython.org/wx.PaletteChangedEvent.html
        """

    ChangedWindow: 'Window'  # See GetChangedWindow and SetChangedWindow



class Panel(Window):
    """ A panel is a window on which controls are placed.

        Source: https://docs.wxpython.org/wx.Panel.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Panel.html
        """

    def AcceptsFocus(self) -> bool:
        """ This method is overridden from wx.Window.AcceptsFocus   and returns True only if there is no child window in the panel which can accept the focus.

            Source: https://docs.wxpython.org/wx.Panel.html
        """

    def Create(self, parent, id=ID_ANY, pos=DefaultPosition, size=DefaultSize, style=TAB_TRAVERSAL, name=PanelNameStr) -> bool:
        """ Used for two-step panel construction.

            Source: https://docs.wxpython.org/wx.Panel.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.Panel.html
        """

    def InitDialog(self) -> None:
        """ Sends a   wx.InitDialogEvent, which in turn transfers data to the dialog via validators.

            Source: https://docs.wxpython.org/wx.Panel.html
        """

    def Layout(self) -> bool:
        """ See wx.Window.SetAutoLayout : when auto layout is on, this function gets called automatically when the window is resized.

            Source: https://docs.wxpython.org/wx.Panel.html
        """

    def SetFocus(self) -> None:
        """ Overrides wx.Window.SetFocus .

            Source: https://docs.wxpython.org/wx.Panel.html
        """

    def SetFocusIgnoringChildren(self) -> None:
        """ In contrast to SetFocus   (see above) this will set the focus to the panel even if there are child windows in the panel.

            Source: https://docs.wxpython.org/wx.Panel.html
        """



class PanGestureEvent(GestureEvent):
    """ This event is generated when the user moves a finger on the surface.

        Source: https://docs.wxpython.org/wx.PanGestureEvent.html
    """
    def __init__(self, winid: int=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PanGestureEvent.html
        """

    def GetDelta(self) -> 'Point':
        """ Returns the distance covered since the previous panning event.

            Source: https://docs.wxpython.org/wx.PanGestureEvent.html
        """

    def SetDelta(self, delta: Union[tuple[int, int], 'Point']) -> None:
        """ Sets the distance covered since the previous panning event.

            Source: https://docs.wxpython.org/wx.PanGestureEvent.html
        """

    Delta: 'Point'  # See GetDelta and SetDelta



EVT_GESTURE_PAN: int  # Process a  wxEVT_GESTURE_PAN . ^^

class PasswordEntryDialog(TextEntryDialog):
    """ This class represents a dialog that requests a one-line password
string from the user.

        Source: https://docs.wxpython.org/wx.PasswordEntryDialog.html
    """
    def __init__(self, parent, message, caption=GetPasswordFromUserPromptStr, defaultValue="", style=TextEntryDialogStyle, pos=DefaultPosition) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PasswordEntryDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.PasswordEntryDialog.html
        """



class PCXHandler(ImageHandler):
    """ This is the image handler for the PCX format.

        Source: https://docs.wxpython.org/wx.PCXHandler.html
    """
    def __init__(self) -> None:
        """ Default constructor for   wx.PCXHandler.

            Source: https://docs.wxpython.org/wx.PCXHandler.html
        """

    def DoCanRead(self, stream: 'InputStream') -> bool:
        """ Called to test if this handler can read an image from the given stream.

            Source: https://docs.wxpython.org/wx.PCXHandler.html
        """

    def LoadFile(self, image, stream, verbose=True, index=-1) -> bool:
        """ Loads an image from a stream, putting the resulting data into image.

            Source: https://docs.wxpython.org/wx.PCXHandler.html
        """

    def SaveFile(self, image, stream, verbose=True) -> bool:
        """ Saves an image in the output stream.

            Source: https://docs.wxpython.org/wx.PCXHandler.html
        """



class PenInfo:
    """ This class is a helper used for Pen creation using named parameter
idiom: it allows specifying various Pen attributes using the chained
calls to its clearly named methods instead of passing them in the
fixed order to Pen constructors.

        Source: https://docs.wxpython.org/wx.PenInfo.html
    """
    def __init__(*args, **kwargs) -> None:
        """ colour (wx.Colour) â

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def Cap(self, cap: PenCap) -> 'PenInfo':
        """ cap (PenCap) â

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def Colour(self, col: Union[int, str, 'Colour']) -> 'PenInfo':
        """ col (wx.Colour) â

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def GetCap(self) -> 'PenCap':
        """ wx.PenCap

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def GetColour(self) -> 'Colour':
        """ wx.Colour

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def GetJoin(self) -> 'PenJoin':
        """ wx.PenJoin

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def GetQuality(self) -> 'PenQuality':
        """ wx.PenQuality

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def GetStipple(self) -> 'Bitmap':
        """ wx.Bitmap

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def GetStyle(self) -> 'PenStyle':
        """ wx.PenStyle

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def GetWidth(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def HighQuality(self) -> 'PenInfo':
        """ Set high pen quality.

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def IsTransparent(self) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def Join(self, join: PenJoin) -> 'PenInfo':
        """ join (PenJoin) â

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def LowQuality(self) -> 'PenInfo':
        """ Set low pen quality.

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def Quality(self, quality: PenQuality) -> 'PenInfo':
        """ Set the pen quality.

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def Stipple(self, stipple: 'Bitmap') -> 'PenInfo':
        """ stipple (wx.Bitmap) â

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def Style(self, style: PenStyle) -> 'PenInfo':
        """ style (PenStyle) â

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """

    def Width(self, width: int) -> 'PenInfo':
        """ width (int) â

            Source: https://docs.wxpython.org/wx.PenInfo.html
        """



class PenList:
    """ There is only one instance of this class: ThePenList.

        Source: https://docs.wxpython.org/wx.PenList.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PenList.html
        """

    def FindOrCreatePen(self, colour, width=1, style=PENSTYLE_SOLID) -> 'Pen':
        """ Finds a pen with the specified attributes and returns it, else creates a new pen, adds it to the pen list, and returns it.

            Source: https://docs.wxpython.org/wx.PenList.html
        """



class PickerBase(Control):
    """ Base abstract class for all pickers which support an auxiliary text
control.

        Source: https://docs.wxpython.org/wx.PickerBase.html
    """
    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def CreateBase(self, parent, id=ID_ANY, text="", pos=DefaultPosition, size=DefaultSize, style=0, validator=DefaultValidator, name=ButtonNameStr) -> bool:
        """ parent (wx.Window) â

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def GetInternalMargin(self) -> int:
        """ Returns the margin (in pixel) between the picker and the text control.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def GetPickerCtrl(self) -> 'Control':
        """ Returns the native implementation of the real picker control.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def GetPickerCtrlProportion(self) -> int:
        """ Returns the proportion value of the picker.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def GetPickerStyle(self, style: int) -> int:
        """ style (long) â

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def GetTextCtrl(self) -> 'TextCtrl':
        """ Returns a pointer to the text control handled by this window or None if the  PB_USE_TEXTCTRL   style was not specified when this control was created.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def GetTextCtrlProportion(self) -> int:
        """ Returns the proportion value of the text control.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def GetTextCtrlStyle(self, style: int) -> int:
        """ style (long) â

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def HasTextCtrl(self) -> bool:
        """ Returns True if this window has a valid text control (i.e. if the  PB_USE_TEXTCTRL   style was given when creating this control).

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def IsPickerCtrlGrowable(self) -> bool:
        """ Returns True if the picker control is growable.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def IsTextCtrlGrowable(self) -> bool:
        """ Returns True if the text control is growable.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def PostCreation(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def SetInternalMargin(self, margin: int) -> None:
        """ Sets the margin (in pixel) between the picker and the text control.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def SetPickerCtrl(self, picker: 'Control') -> None:
        """ picker (wx.Control) â

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def SetPickerCtrlGrowable(self, grow: bool=True) -> None:
        """ Sets the picker control as growable when  grow   is True.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def SetPickerCtrlProportion(self, prop: int) -> None:
        """ Sets the proportion value of the picker.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def SetTextCtrl(self, text: 'TextCtrl') -> None:
        """ text (wx.TextCtrl) â

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def SetTextCtrlGrowable(self, grow: bool=True) -> None:
        """ Sets the text control as growable when  grow   is True.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def SetTextCtrlProportion(self, prop: int) -> None:
        """ Sets the proportion value of the text control.

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def UpdatePickerFromTextCtrl(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    def UpdateTextCtrlFromPicker(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PickerBase.html
        """

    InternalMargin: int  # See GetInternalMargin and SetInternalMargin
    PickerCtrl: 'Control'  # See GetPickerCtrl and SetPickerCtrl
    PickerCtrlProportion: int  # See GetPickerCtrlProportion and SetPickerCtrlProportion
    TextCtrl: '_TextCtrl'  # See GetTextCtrl and SetTextCtrl
    TextCtrlProportion: int  # See GetTextCtrlProportion and SetTextCtrlProportion



PB_USE_TEXTCTRL: int  # Creates a text control to the left of the picker which is completely managed by this   wx.PickerBase  class. ^^

class PixelDataBase:
    """ Return the height of the area this pixel data represents.

        Source: https://docs.wxpython.org/wx.PixelDataBase.html
    """
    def GetHeight(self) -> int:
        """ Return the height of the area this pixel data represents.

            Source: https://docs.wxpython.org/wx.PixelDataBase.html
        """

    def GetOrigin(self) -> 'Point':
        """ Return the origin of the area this pixel data represents.

            Source: https://docs.wxpython.org/wx.PixelDataBase.html
        """

    def GetRowStride(self) -> int:
        """ Returns the distance between the start of one row to the start of the next row.

            Source: https://docs.wxpython.org/wx.PixelDataBase.html
        """

    def GetSize(self) -> 'Size':
        """ Return the size of the area this pixel data represents.

            Source: https://docs.wxpython.org/wx.PixelDataBase.html
        """

    def GetWidth(self) -> int:
        """ Return the width of the area this pixel data represents.

            Source: https://docs.wxpython.org/wx.PixelDataBase.html
        """

    def __iter__(self) -> None:
        """ Create and return an iterator/generator object for traversing
this pixel data object.

            Source: https://docs.wxpython.org/wx.PixelDataBase.html
        """

    def __init__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PixelDataBase.html
        """

    Height: int  # See GetHeight
    Origin: 'Point'  # See GetOrigin
    RowStride: int  # See GetRowStride
    Size: '_Size'  # See GetSize
    Width: int  # See GetWidth



class PlatformId:
    """ Defines a very broad platform categorization.

        Source: https://docs.wxpython.org/wx.PlatformId.html
    """


_Architecture: TypeAlias = Architecture

_Bitness: TypeAlias = Bitness

_Endianness: TypeAlias = Endianness

_LinuxDistributionInfo: TypeAlias = LinuxDistributionInfo

_OperatingSystemId: TypeAlias = OperatingSystemId

_PortId: TypeAlias = PortId

class PlatformInformation:
    """ PlatformInfo()
PlatformInfo(pid, tkMajor=-1, tkMinor=-1, id=OS_UNKNOWN, osMajor=-1, osMinor=-1, bitness=BITNESS_INVALID, endian=ENDIAN_INVALID)

        Source: https://docs.wxpython.org/wx.PlatformInformation.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def CheckOSVersion(self, major, minor, micro=0) -> bool:
        """ Returns True if the OS version is at least  major.minor.micro .

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def CheckToolkitVersion(self, major, minor, micro=0) -> bool:
        """ Returns True if the toolkit version is at least  major.minor.micro .

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    @staticmethod
    def Get() -> 'PlatformInfo':
        """ Returns the global PlatformInfo       object, initialized with the values for the currently running platform.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    @staticmethod
    def GetArch(arch: str) -> 'Architecture':
        """ arch (string) â

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetArchName(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetArchitecture(self) -> 'Architecture':
        """ wx.Architecture

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetBitness(self) -> 'Bitness':
        """ Returns the architecture bitness ID of this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    @staticmethod
    def GetBitnessName(*args, **kw) -> str:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetCpuArchitectureName(self) -> str:
        """ Returns the CPU architecture name, if available.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetDesktopEnvironment(self) -> str:
        """ Returns the desktop environment associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetEndianness(self) -> 'Endianness':
        """ Returns the endianness ID of this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetEndiannessName(self) -> str:
        """ Returns the name for the endianness of this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetLinuxDistributionInfo(self) -> 'LinuxDistributionInfo':
        """ Returns the Linux distribution info associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetNativeCpuArchitectureName(self) -> str:
        """ Returns the native CPU architecture name, if available.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetOSMajorVersion(self) -> int:
        """ Returns the run-time major version of the OS associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetOSMicroVersion(self) -> int:
        """ Returns the run-time micro version of the OS associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetOSMinorVersion(self) -> int:
        """ Returns the run-time minor version of the OS associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetOperatingSystemDescription(self) -> str:
        """ Returns the description of the operating system of this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    @staticmethod
    def GetOperatingSystemDirectory() -> str:
        """ Returns the operating system directory.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetOperatingSystemFamilyName(self) -> str:
        """ Returns the operating system family name of the OS associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetOperatingSystemId(self) -> 'OperatingSystemId':
        """ Returns the operating system ID of this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetOperatingSystemIdName(self) -> str:
        """ Returns the operating system name of the OS associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetPortId(self) -> 'PortId':
        """ Returns the wxWidgets port ID associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetPortIdName(self) -> str:
        """ Returns the name of the wxWidgets port ID associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetPortIdShortName(self) -> str:
        """ Returns the short name of the wxWidgets port ID associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetToolkitMajorVersion(self) -> int:
        """ Returns the run-time major version of the toolkit associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetToolkitMicroVersion(self) -> int:
        """ Returns the run-time micro version of the toolkit associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def GetToolkitMinorVersion(self) -> int:
        """ Returns the run-time minor version of the toolkit associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def IsOk(self) -> bool:
        """ Returns True if this instance is fully initialized with valid values.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def IsUsingUniversalWidgets(self) -> bool:
        """ Returns True if this PlatformInfo       describes wxUniversal build.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetArchitecture(self, n: Architecture) -> None:
        """ n (Architecture) â

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetBitness(self, n: Bitness) -> None:
        """ Sets the architecture bitness enum value associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetDesktopEnvironment(self, de: str) -> None:
        """ Sets the desktop environment associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetEndianness(self, n: Endianness) -> None:
        """ Sets the endianness enum value associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetLinuxDistributionInfo(self, di: 'LinuxDistributionInfo') -> None:
        """ Sets the linux distribution info associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetOSVersion(self, major, minor, micro=0) -> None:
        """ Sets the version of the operating system associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetOperatingSystemDescription(self, desc: str) -> None:
        """ Sets the operating system description associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetOperatingSystemId(self, n: OperatingSystemId) -> None:
        """ Sets the operating system associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetPortId(self, n: PortId) -> None:
        """ Sets the wxWidgets port ID associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def SetToolkitVersion(self, major, minor, micro=0) -> None:
        """ Sets the version of the toolkit associated with this PlatformInfo       instance.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def __ne__(self, item: Any) -> bool:
        """ Inequality operator.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    def __eq__(self, item: Any) -> bool:
        """ Equality operator.

            Source: https://docs.wxpython.org/wx.PlatformInformation.html
        """

    ArchName: str  # See GetArchName
    Architecture: '_Architecture'  # See GetArchitecture and SetArchitecture
    Bitness: '_Bitness'  # See GetBitness and SetBitness
    BitnessName: str  # See GetBitnessName
    CpuArchitectureName: str  # See GetCpuArchitectureName
    DesktopEnvironment: str  # See GetDesktopEnvironment and SetDesktopEnvironment
    Endianness: '_Endianness'  # See GetEndianness and SetEndianness
    EndiannessName: str  # See GetEndiannessName
    LinuxDistributionInfo: '_LinuxDistributionInfo'  # See GetLinuxDistributionInfo and SetLinuxDistributionInfo
    NativeCpuArchitectureName: str  # See GetNativeCpuArchitectureName
    OSMajorVersion: int  # See GetOSMajorVersion
    OSMicroVersion: int  # See GetOSMicroVersion
    OSMinorVersion: int  # See GetOSMinorVersion
    OperatingSystemDescription: str  # See GetOperatingSystemDescription and SetOperatingSystemDescription
    OperatingSystemFamilyName: str  # See GetOperatingSystemFamilyName
    OperatingSystemId: '_OperatingSystemId'  # See GetOperatingSystemId and SetOperatingSystemId
    OperatingSystemIdName: str  # See GetOperatingSystemIdName
    PortId: '_PortId'  # See GetPortId and SetPortId
    PortIdName: str  # See GetPortIdName
    PortIdShortName: str  # See GetPortIdShortName
    ToolkitMajorVersion: int  # See GetToolkitMajorVersion
    ToolkitMicroVersion: int  # See GetToolkitMicroVersion
    ToolkitMinorVersion: int  # See GetToolkitMinorVersion



class PNGHandler(ImageHandler):
    """ This is the image handler for the PNG format.

        Source: https://docs.wxpython.org/wx.PNGHandler.html
    """
    def __init__(self) -> None:
        """ Default constructor for   wx.PNGHandler.

            Source: https://docs.wxpython.org/wx.PNGHandler.html
        """

    def DoCanRead(self, stream: 'InputStream') -> bool:
        """ Called to test if this handler can read an image from the given stream.

            Source: https://docs.wxpython.org/wx.PNGHandler.html
        """

    def LoadFile(self, image, stream, verbose=True, index=-1) -> bool:
        """ Loads an image from a stream, putting the resulting data into image.

            Source: https://docs.wxpython.org/wx.PNGHandler.html
        """

    def SaveFile(self, image, stream, verbose=True) -> bool:
        """ Saves an image in the output stream.

            Source: https://docs.wxpython.org/wx.PNGHandler.html
        """



class PNMHandler(ImageHandler):
    """ This is the image handler for the PNM format.

        Source: https://docs.wxpython.org/wx.PNMHandler.html
    """
    def __init__(self) -> None:
        """ Default constructor for   wx.PNMHandler.

            Source: https://docs.wxpython.org/wx.PNMHandler.html
        """

    def DoCanRead(self, stream: 'InputStream') -> bool:
        """ Called to test if this handler can read an image from the given stream.

            Source: https://docs.wxpython.org/wx.PNMHandler.html
        """

    def LoadFile(self, image, stream, verbose=True, index=-1) -> bool:
        """ Loads an image from a stream, putting the resulting data into image.

            Source: https://docs.wxpython.org/wx.PNMHandler.html
        """

    def SaveFile(self, image, stream, verbose=True) -> bool:
        """ Saves an image in the output stream.

            Source: https://docs.wxpython.org/wx.PNMHandler.html
        """



class Point:
    """ A Point is a useful data structure for graphics operations.

        Source: https://docs.wxpython.org/wx.Point.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def Get(self) -> tuple:
        """ Return the x and y properties as a tuple.

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def GetIM(self) -> None:
        """ Returns an immutable representation of the wx.Point object, based on namedtuple.

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def IsFullySpecified(self) -> bool:
        """ Returns True if neither of the point components is equal to DefaultCoord.

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def SetDefaults(self, pt: Union[tuple[int, int], 'Point']) -> None:
        """ Combine this object with another one replacing the uninitialized values.

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __eq__(self, item: Any) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __getitem__(self, idx) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __len__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __ne__(self, item: Any) -> bool:
        """ bool

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __reduce__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __repr__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __setitem__(self, idx, val) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __str__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __iadd__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Point.html
        """

    def __isub__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Point.html
        """

    IM: None  # See GetIM
    x: Any  # A public C++ attribute of type int. x member.
    y: Any  # A public C++ attribute of type int. y member.



class Point2D:
    """  Overloaded Implementations:

        Source: https://docs.wxpython.org/wx.Point2D.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def Get(self) -> Any:
        """ Get() . (x,y)

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetCrossProduct(self, vec: Point2DDouble) -> 'Double':
        """ vec (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetDistance(self, pt: Point2DDouble) -> 'Double':
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetDistanceSquare(self, pt: Point2DDouble) -> 'Double':
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetDotProduct(self, vec: Point2DDouble) -> 'Double':
        """ vec (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetFloor(self) -> tuple:
        """ tuple

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetIM(self) -> None:
        """ Returns an immutable representation of the wx.Point2D object, based on namedtuple.

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetRounded(self) -> tuple:
        """ tuple

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetVectorAngle(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def GetVectorLength(self) -> 'Double':
        """ wx.Double

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def Normalize(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def SetVectorAngle(self, degrees: 'Double') -> None:
        """ degrees (wx.Double) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def SetVectorLength(self, length: 'Double') -> None:
        """ length (wx.Double) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __bool__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __getitem__(self, idx) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __len__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __nonzero__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __reduce__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __repr__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __setitem__(self, idx, val) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __str__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __ne__(self, item: Any) -> bool:
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __imul__(self) -> None:
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __iadd__(self) -> None:
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __sub__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __isub__(self) -> None:
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __idiv__(self) -> None:
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    def __eq__(self, item: Any) -> bool:
        """ pt (Point2DDouble) â

            Source: https://docs.wxpython.org/wx.Point2D.html
        """

    IM: None  # See GetIM
    VectorAngle: 'Double'  # See GetVectorAngle and SetVectorAngle
    VectorLength: 'Double'  # See GetVectorLength and SetVectorLength
    m_x: Any  # A public C++ attribute of type Double     .
    m_y: Any  # A public C++ attribute of type Double     .



class PopupTransientWindow(PopupWindow):
    """ A PopupWindow which disappears automatically when the user clicks
mouse outside it or if it loses focus in any other way.

        Source: https://docs.wxpython.org/wx.PopupTransientWindow.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PopupTransientWindow.html
        """

    def Dismiss(self) -> None:
        """ Hide the window.

            Source: https://docs.wxpython.org/wx.PopupTransientWindow.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.PopupTransientWindow.html
        """

    def OnDismiss(self) -> None:
        """ This is called when the popup is disappeared because of anything else but direct call to Dismiss .

            Source: https://docs.wxpython.org/wx.PopupTransientWindow.html
        """

    def Popup(self, focus: Optional['Window']=None) -> None:
        """ Popup the window (this will show it too).

            Source: https://docs.wxpython.org/wx.PopupTransientWindow.html
        """

    def ProcessLeftDown(self, event: 'MouseEvent') -> bool:
        """ Called when a mouse is pressed while the popup is shown.

            Source: https://docs.wxpython.org/wx.PopupTransientWindow.html
        """



class PopupWindow(NonOwnedWindow):
    """ A special kind of top level window used for popup menus, combobox
popups and such.

        Source: https://docs.wxpython.org/wx.PopupWindow.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PopupWindow.html
        """

    def Create(self, parent, flags=BORDER_NONE) -> bool:
        """ Create method for two-step creation.

            Source: https://docs.wxpython.org/wx.PopupWindow.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.PopupWindow.html
        """

    def Position(self, ptOrigin, sizePopup) -> None:
        """ Move the popup window to the right position, i.e. such that it is entirely visible.

            Source: https://docs.wxpython.org/wx.PopupWindow.html
        """



PU_CONTAINS_CONTROLS: int  # By default in wxMSW, a popup window will not take focus from its parent window. However many standard controls, including common ones such as   wx.TextCtrl, need focus to function correctly and will not work when placed on a default popup. This flag can be used to make the popup take focus and let all controls work but at the price of not allowing the parent window to keep focus while the popup is shown, which can also be sometimes desirable. This style is currently only implemented in MSW and simply does nothing under the other platforms (itâs new since wxWidgets 3.1.3). ^^

class Position:
    """ This class represents the position of an item in any kind of grid of
rows and columns such as GridBagSizer, or HVScrolledWindow.

        Source: https://docs.wxpython.org/wx.Position.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def Get(self) -> tuple:
        """ Return the row and col properties as a tuple.

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def GetCol(self) -> int:
        """ A synonym for GetColumn .

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def GetColumn(self) -> int:
        """ Get the current row value.

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def GetIM(self) -> None:
        """ Returns an immutable representation of the wx.Position object, based on namedtuple.

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def GetRow(self) -> int:
        """ Get the current row value.

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def SetCol(self, column: int) -> None:
        """ A synonym for SetColumn .

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def SetColumn(self, column: int) -> None:
        """ Set a new column value.

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def SetRow(self, row: int) -> None:
        """ Set a new row value.

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __bool__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __getitem__(self, idx) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __len__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __nonzero__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __reduce__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __repr__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __setitem__(self, idx, val) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __str__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __ne__(self, item: Any) -> bool:
        """ pos (wx.Position) â

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __add__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __iadd__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __sub__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __isub__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.Position.html
        """

    def __eq__(self, item: Any) -> bool:
        """ pos (wx.Position) â

            Source: https://docs.wxpython.org/wx.Position.html
        """

    Col: int  # See GetCol and SetCol
    Column: int  # See GetColumn and SetColumn
    IM: None  # See GetIM
    Row: int  # See GetRow and SetRow



class PowerEvent(Event):
    """ The power events are generated when the system power state changes,
e.g.

        Source: https://docs.wxpython.org/wx.PowerEvent.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PowerEvent.html
        """

    def IsVetoed(self) -> bool:
        """ Returns whether Veto has been called.

            Source: https://docs.wxpython.org/wx.PowerEvent.html
        """

    def Veto(self) -> None:
        """ Call this to prevent suspend from taking place in  wxEVT_POWER_SUSPENDING   handler (it is ignored for all the others).

            Source: https://docs.wxpython.org/wx.PowerEvent.html
        """



EVT_POWER_SUSPENDING: int

EVT_POWER_SUSPENDED: int  # System is about to suspend: normally the application should quickly (i.e. without user intervention) close all the open files and network connections here, possibly remembering them to reopen them later when the system is resumed.

EVT_POWER_SUSPEND_CANCEL: int  # System suspension was cancelled because some application vetoed it.

EVT_POWER_RESUME: int  # System resumed from suspend: normally the application should restore the state in which it had been before the suspension. ^^

class PowerResource:
    """ Helper functions for acquiring and releasing the given power resource.

        Source: https://docs.wxpython.org/wx.PowerResource.html
    """
    @staticmethod
    def Acquire(kind, reason="") -> bool:
        """ Acquire a power resource for the application.

            Source: https://docs.wxpython.org/wx.PowerResource.html
        """

    @staticmethod
    def Release(kind: PowerResourceKind) -> None:
        """ Release a previously acquired power resource.

            Source: https://docs.wxpython.org/wx.PowerResource.html
        """



class PowerResourceBlocker:
    """ Helper RAII class ensuring that power resources are released.

        Source: https://docs.wxpython.org/wx.PowerResourceBlocker.html
    """
    def __init__(self, kind, reason="") -> None:
        """ Acquires the power resource.

            Source: https://docs.wxpython.org/wx.PowerResourceBlocker.html
        """

    def IsInEffect(self) -> bool:
        """ Returns whether the power resource could be acquired.

            Source: https://docs.wxpython.org/wx.PowerResourceBlocker.html
        """

    def __enter__(self) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PowerResourceBlocker.html
        """

    def __exit__(self, exc_type, exc_val, exc_tb) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PowerResourceBlocker.html
        """



class PreferencesEditor:
    """ Manage preferences dialog.

        Source: https://docs.wxpython.org/wx.PreferencesEditor.html
    """
    def __init__(self, title: str="") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PreferencesEditor.html
        """

    def AddPage(self, page: 'PreferencesPage') -> None:
        """ Add a new page to the editor.

            Source: https://docs.wxpython.org/wx.PreferencesEditor.html
        """

    def Dismiss(self) -> None:
        """ Hide the currently shown dialog, if any.

            Source: https://docs.wxpython.org/wx.PreferencesEditor.html
        """

    @staticmethod
    def ShouldApplyChangesImmediately() -> bool:
        """ Returns whether changes to values in preferences pages should be applied immediately or only when the user clicks the wx.OK button.

            Source: https://docs.wxpython.org/wx.PreferencesEditor.html
        """

    def Show(self, parent: 'Window') -> None:
        """ Show the preferences dialog or bring it to the top if itâs already shown.

            Source: https://docs.wxpython.org/wx.PreferencesEditor.html
        """

    @staticmethod
    def ShownModally() -> bool:
        """ Returns whether the preferences dialog is shown modally.

            Source: https://docs.wxpython.org/wx.PreferencesEditor.html
        """



class PreferencesPage:
    """ One page of preferences dialog.

        Source: https://docs.wxpython.org/wx.PreferencesPage.html
    """
    def __init__(self) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PreferencesPage.html
        """

    def CreateWindow(self, parent: 'Window') -> 'Window':
        """ Create a window for this page.

            Source: https://docs.wxpython.org/wx.PreferencesPage.html
        """

    def GetIcon(self) -> 'BitmapBundle':
        """ Return the icon to be used for the page on some platforms.

            Source: https://docs.wxpython.org/wx.PreferencesPage.html
        """

    def GetLargeIcon(self) -> 'Bitmap':
        """ wx.Bitmap

            Source: https://docs.wxpython.org/wx.PreferencesPage.html
        """

    def GetName(self) -> str:
        """ Return name of the page.

            Source: https://docs.wxpython.org/wx.PreferencesPage.html
        """

    Icon: 'BitmapBundle'  # See GetIcon
    LargeIcon: 'Bitmap'  # See GetLargeIcon
    Name: str  # See GetName



class PressAndTapEvent(GestureEvent):
    """ This event is generated when the user press the surface with one
finger and taps with another.

        Source: https://docs.wxpython.org/wx.PressAndTapEvent.html
    """
    def __init__(self, windid: int=0) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PressAndTapEvent.html
        """



EVT_PRESS_AND_TAP: int  # Process a  wxEVT_PRESS_AND_TAP . ^^

class PreviewCanvas(Scrolled):
    """ A preview canvas is the default canvas used by the print preview
system to display the preview.

        Source: https://docs.wxpython.org/wx.PreviewCanvas.html
    """
    def __init__(self, preview, parent, pos=DefaultPosition, size=DefaultSize, style=0, name="canvas") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PreviewCanvas.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.PreviewCanvas.html
        """

    def OnPaint(self, event: 'PaintEvent') -> None:
        """ Calls wx.PrintPreview.PaintPage   to refresh the canvas.

            Source: https://docs.wxpython.org/wx.PreviewCanvas.html
        """



_PrintPreview: TypeAlias = PrintPreview

class PreviewControlBar(Panel):
    """ This is the default implementation of the preview control bar, a panel
with buttons and a zoom control.

        Source: https://docs.wxpython.org/wx.PreviewControlBar.html
    """
    def __init__(self, preview, buttons, parent, pos=DefaultPosition, size=DefaultSize, style=0, name="panel") -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PreviewControlBar.html
        """

    def CreateButtons(self) -> None:
        """ Creates buttons, according to value of the button style flags.

            Source: https://docs.wxpython.org/wx.PreviewControlBar.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.PreviewControlBar.html
        """

    def GetPrintPreview(self) -> 'PrintPreview':
        """ Gets the print preview object associated with the control bar.

            Source: https://docs.wxpython.org/wx.PreviewControlBar.html
        """

    def GetZoomControl(self) -> int:
        """ Gets the current zoom setting in percent.

            Source: https://docs.wxpython.org/wx.PreviewControlBar.html
        """

    def SetZoomControl(self, percent: int) -> None:
        """ Sets the zoom control.

            Source: https://docs.wxpython.org/wx.PreviewControlBar.html
        """

    PrintPreview: '_PrintPreview'  # See GetPrintPreview
    ZoomControl: int  # See GetZoomControl and SetZoomControl



PREVIEW_PRINT: int

PREVIEW_NEXT: int

PREVIEW_PREVIOUS: int

PREVIEW_ZOOM: int

PREVIEW_DEFAULT: int

class PreviewFrame(Frame):
    """ This class provides the default method of managing the print preview
interface.

        Source: https://docs.wxpython.org/wx.PreviewFrame.html
    """
    def __init__(self, preview, parent, title="PrintPreview", pos=DefaultPosition, size=DefaultSize, style=DEFAULT_FRAME_STYLE, name=FrameNameStr) -> None:
        """ Constructor.

            Source: https://docs.wxpython.org/wx.PreviewFrame.html
        """

    def CreateCanvas(self) -> None:
        """ Creates a   wx.PreviewCanvas.

            Source: https://docs.wxpython.org/wx.PreviewFrame.html
        """

    def CreateControlBar(self) -> None:
        """ Creates a   wx.PreviewControlBar.

            Source: https://docs.wxpython.org/wx.PreviewFrame.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.PreviewFrame.html
        """

    def Initialize(self) -> None:
        """ Initializes the frame elements and prepares for showing it.

            Source: https://docs.wxpython.org/wx.PreviewFrame.html
        """

    def InitializeWithModality(self, kind: PreviewFrameModalityKind) -> None:
        """ Initializes the frame elements and prepares for showing it with the given modality kind.

            Source: https://docs.wxpython.org/wx.PreviewFrame.html
        """

    def OnCloseWindow(self, event: 'CloseEvent') -> None:
        """ Enables any disabled frames in the application, and deletes the print preview object, implicitly deleting any printout objects associated with the print preview object.

            Source: https://docs.wxpython.org/wx.PreviewFrame.html
        """



class PrintAbortDialog(Dialog):
    """ The dialog created by default by the print framework that enables
aborting the printing process.

        Source: https://docs.wxpython.org/wx.PrintAbortDialog.html
    """
    def __init__(self, parent, documentTitle, pos=DefaultPosition, size=DefaultSize, style=DEFAULT_DIALOG_STYLE, name="dialog") -> None:
        """ parent (wx.Window) â

            Source: https://docs.wxpython.org/wx.PrintAbortDialog.html
        """

    @staticmethod
    def GetClassDefaultAttributes(variant: int=WINDOW_VARIANT_NORMAL) -> 'VisualAttributes':
        """ variant (WindowVariant) â

            Source: https://docs.wxpython.org/wx.PrintAbortDialog.html
        """

    def SetProgress(self, currentPage, totalPages, currentCopy, totalCopies) -> None:
        """ currentPage (int) â

            Source: https://docs.wxpython.org/wx.PrintAbortDialog.html
        """



_PrintMode: TypeAlias = PrintMode

class PrintData(Object):
    """ This class holds a variety of information related to printers and
printer device contexts.

        Source: https://docs.wxpython.org/wx.PrintData.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetBin(self) -> 'PrintBin':
        """ Returns the current bin (papersource).

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetCollate(self) -> bool:
        """ Returns True if collation is on.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetColour(self) -> bool:
        """ Returns True if colour printing is on.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetDuplex(self) -> 'DuplexMode':
        """ Returns the duplex mode.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetFilename(self) -> str:
        """ string

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetNoCopies(self) -> int:
        """ Returns the number of copies requested by the user.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetOrientation(self) -> 'PrintOrientation':
        """ Gets the orientation.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetPaperId(self) -> 'PaperSize':
        """ Returns the paper size id.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetPaperSize(self) -> 'Size':
        """ wx.Size

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetPrintMode(self) -> 'PrintMode':
        """ wx.PrintMode

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetPrinterName(self) -> str:
        """ Returns the printer name.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetPrivData(self) -> Any:
        """ PyObject

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def GetQuality(self) -> 'PrintQuality':
        """ Returns the current print quality.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def IsOk(self) -> bool:
        """ Returns True if the print data is valid for using in print dialogs.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetBin(self, flag: PrintBin) -> None:
        """ Sets the current bin.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetCollate(self, flag: bool) -> None:
        """ Sets collation to on or off.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetColour(self, flag: bool) -> None:
        """ Sets colour printing on or off.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetDuplex(self, mode: DuplexMode) -> None:
        """ Returns the duplex mode.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetFilename(self, filename: str) -> None:
        """ filename (string) â

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetNoCopies(self, n: int) -> None:
        """ Sets the default number of copies to be printed out.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetOrientation(self, orientation: PrintOrientation) -> None:
        """ Sets the orientation.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetPaperId(self, paperId: PaperSize) -> None:
        """ Sets the paper id.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetPaperSize(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetPrintMode(self, printMode: PrintMode) -> None:
        """ printMode (PrintMode) â

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetPrinterName(self, printerName: str) -> None:
        """ Sets the printer name.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetPrivData(self, data) -> None:
        """ 

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def SetQuality(self, quality: 'PrintQuality') -> None:
        """ Sets the desired print quality.

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def __bool__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    def __nonzero__(self) -> int:
        """ int

            Source: https://docs.wxpython.org/wx.PrintData.html
        """

    Bin: 'PrintBin'  # See GetBin and SetBin
    Collate: bool  # See GetCollate and SetCollate
    Colour: bool  # See GetColour and SetColour
    Duplex: 'DuplexMode'  # See GetDuplex and SetDuplex
    Filename: str  # See GetFilename and SetFilename
    NoCopies: int  # See GetNoCopies and SetNoCopies
    Orientation: 'PrintOrientation'  # See GetOrientation and SetOrientation
    PaperId: 'PaperSize'  # See GetPaperId and SetPaperId
    PaperSize: 'Size'  # See GetPaperSize and SetPaperSize
    PrintMode: '_PrintMode'  # See GetPrintMode and SetPrintMode
    PrinterName: str  # See GetPrinterName and SetPrinterName
    PrivData: Any  # See GetPrivData and SetPrivData
    Quality: 'PrintQuality'  # See GetQuality and SetQuality



DUPLEX_SIMPLEX: int

DUPLEX_HORIZONTAL: int

DUPLEX_VERTICAL: int

LANDSCAPE: int

PORTRAIT: int

PRINT_QUALITY_HIGH: int

PRINT_QUALITY_MEDIUM: int

PRINT_QUALITY_LOW: int

PRINT_QUALITY_DRAFT: int

_PrintDialogData: TypeAlias = PrintDialogData

class PrintDialog(Object):
    """ This class represents the print and print setup common dialogs.

        Source: https://docs.wxpython.org/wx.PrintDialog.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PrintDialog.html
        """

    def GetPrintDC(self) -> 'DC':
        """ Returns the device context created by the print dialog, if any.

            Source: https://docs.wxpython.org/wx.PrintDialog.html
        """

    def GetPrintData(self) -> 'PrintData':
        """ Returns the print data  associated with the print dialog.

            Source: https://docs.wxpython.org/wx.PrintDialog.html
        """

    def GetPrintDialogData(self) -> 'PrintDialogData':
        """ Returns the print dialog data  associated with the print dialog.

            Source: https://docs.wxpython.org/wx.PrintDialog.html
        """

    def ShowModal(self) -> int:
        """ Shows the dialog, returning  ID_OK   if the user pressed wx.OK, and   ID_CANCEL   otherwise.

            Source: https://docs.wxpython.org/wx.PrintDialog.html
        """

    PrintDC: 'DC'  # See GetPrintDC
    PrintData: '_PrintData'  # See GetPrintData
    PrintDialogData: '_PrintDialogData'  # See GetPrintDialogData



class PrintDialogData(Object):
    """ This class holds information related to the visual characteristics of
PrintDialog.

        Source: https://docs.wxpython.org/wx.PrintDialogData.html
    """
    def __init__(self, *args, **kw) -> None:
        """ Overloaded Implementations:

            Source: https://docs.wxpython.org/wx.PrintDialogData.html
        """

    def EnableHelp(self, flag: bool) ->