[![PyPI version](https://badge.fury.io/py/types-wxpython.svg)](https://badge.fury.io/py/types-wxpython)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/types-wxpython)
![GitHub branch checks state](https://img.shields.io/github/checks-status/AlexionSoftware/types-wxpython/main)
![PyPI - Downloads](https://img.shields.io/pypi/dm/types-wxpython)
![GitHub](https://img.shields.io/github/license/AlexionSoftware/types-wxpython)

# Typing stubs for wxPython
Version: wxPython 4.2.0

This package contains typing stubs for [wxPython](https://pypi.org/project/wxPython/).

This package is not maintained by the wxPython maintainers. It is maintained by users of wxPython.

Any help is always appreciated.

## How it works
The base for the stubs is generated from [docs.wxpython.org](https://docs.wxpython.org/). It crawls the documentation looking for Python classes, functions, and literals. This means that changes in the documentation are automatically reflected in the stubs when they are regenerated.

We do not manually update anything in the `wx-stubs' folder. Everything is generated by the generator.

Run `run.bat`/`run.sh` to generate the stubs.

### Overrides
Because we generated things based on online information, sometimes we have to resort to guessing, or sometimes the online documentation does not contain certain information. To fix these problems, we can override the typing.

You can find the overrides in [`generator/overrides.py`](https://github.com/AlexionSoftware/types-wxpython/blob/main/generator/overrides.py).

In this file you can override any parameter by specifying the key and the parameter you want to override. You can change the typing of any class, function, or literal. These are applied after the typing is retrieved from the online documentation.

To update the stubs run: `run.bat`. This will result in newly updated stubs in the `wx-stubs` folder.

### Missing
The online documentation may be incomplete, or sometimes we just can't understand the page. In these cases, we can add typing to the stubs.

You can find this file in [`generator/extras.py`](https://github.com/AlexionSoftware/types-wxpython/blob/main/generator/extras.py).

Here you can add any missing typing.

To update the stubs run: `run.bat`. This will result in newly updated stubs in the `wx-stubs` folder.

## Help is appreciated
We started this project because we use wxPython ourselves and code typing is really helpful for finding bugs.
But there is so much in wxPython. We fixed problems in the stubs as they came up in our code. This can cause things to not work for your code.

We have decided to open source the work we have put into creating the best wxPython typing there is.
We want you to help. You can create an issue if you find problems with the typing. Or create a pull request if you have fixed something.

### Guidelines
* You don't need to commit newly generated stubs to your PR. We will generate them when we release a new version of the stubs.
