# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['wx-stubs',
 'wx-stubs.ActivateEvent',
 'wx-stubs.ConfigBase',
 'wx-stubs.DataObject',
 'wx-stubs.DateTime',
 'wx-stubs.FileType',
 'wx-stubs.HelpEvent',
 'wx-stubs.Image',
 'wx-stubs.StandardPaths',
 'wx-stubs.StaticBitmap',
 'wx-stubs.StockPreferencesPage',
 'wx-stubs.TopLevelWindow',
 'wx-stubs.Window',
 'wx-stubs.adv',
 'wx-stubs.aui',
 'wx-stubs.dataview',
 'wx-stubs.glcanvas',
 'wx-stubs.grid',
 'wx-stubs.grid.Grid',
 'wx-stubs.grid.GridActivationSource',
 'wx-stubs.grid.GridBlocks',
 'wx-stubs.html',
 'wx-stubs.html2',
 'wx-stubs.lib',
 'wx-stubs.lib.agw',
 'wx-stubs.lib.agw.aui',
 'wx-stubs.lib.agw.aui.auibar',
 'wx-stubs.lib.agw.aui.auibook',
 'wx-stubs.lib.agw.aui.framemanager',
 'wx-stubs.lib.agw.aui.tabart',
 'wx-stubs.lib.agw.aui.tabmdi',
 'wx-stubs.lib.agw.customtreectrl',
 'wx-stubs.lib.agw.flatnotebook',
 'wx-stubs.lib.agw.hyperlink',
 'wx-stubs.lib.agw.infobar',
 'wx-stubs.lib.agw.ribbon',
 'wx-stubs.lib.agw.ribbon.buttonbar',
 'wx-stubs.lib.agw.ribbon.gallery',
 'wx-stubs.lib.agw.ribbon.toolbar',
 'wx-stubs.lib.agw.ultimatelistctrl',
 'wx-stubs.lib.analogclock',
 'wx-stubs.lib.analogclock.lib_setup',
 'wx-stubs.lib.analogclock.lib_setup.fontselect',
 'wx-stubs.lib.buttons',
 'wx-stubs.lib.calendar',
 'wx-stubs.lib.colourselect',
 'wx-stubs.lib.dialogs',
 'wx-stubs.lib.expando',
 'wx-stubs.lib.intctrl',
 'wx-stubs.lib.masked',
 'wx-stubs.lib.masked.combobox',
 'wx-stubs.lib.masked.ipaddrctrl',
 'wx-stubs.lib.masked.maskededit',
 'wx-stubs.lib.masked.numctrl',
 'wx-stubs.lib.masked.textctrl',
 'wx-stubs.lib.masked.timectrl',
 'wx-stubs.lib.newevent',
 'wx-stubs.lib.scrolledpanel',
 'wx-stubs.lib.statbmp',
 'wx-stubs.lib.stattext',
 'wx-stubs.lib.wxpTag',
 'wx-stubs.media',
 'wx-stubs.propgrid',
 'wx-stubs.ribbon',
 'wx-stubs.richtext',
 'wx-stubs.stc',
 'wx-stubs.xml',
 'wx-stubs.xrc']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'types-wxpython',
    'version': '0.9.4',
    'description': 'Typing stubs for wxPython',
    'long_description': "[![PyPI version](https://badge.fury.io/py/types-wxpython.svg)](https://badge.fury.io/py/types-wxpython)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/types-wxpython)\n![GitHub branch checks state](https://img.shields.io/github/checks-status/AlexionSoftware/types-wxpython/main)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/types-wxpython)\n![GitHub](https://img.shields.io/github/license/AlexionSoftware/types-wxpython)\n\n# Typing stubs for wxPython\nVersion: wxPython 4.2.0\n\nThis package contains typing stubs for [wxPython](https://pypi.org/project/wxPython/).\n\nThis package is not maintained by the wxPython maintainers. It is maintained by users of wxPython.\n\nAny help is always appreciated.\n\n## How it works\nThe base for the stubs is generated from [docs.wxpython.org](https://docs.wxpython.org/). It crawls the documentation looking for Python classes, functions, and literals. This means that changes in the documentation are automatically reflected in the stubs when they are regenerated.\n\nWe do not manually update anything in the `wx-stubs' folder. Everything is generated by the generator.\n\nRun `run.bat`/`run.sh` to generate the stubs.\n\n### Overrides\nBecause we generated things based on online information, sometimes we have to resort to guessing, or sometimes the online documentation does not contain certain information. To fix these problems, we can override the typing.\n\nYou can find the overrides in [`generator/overrides.py`](https://github.com/AlexionSoftware/types-wxpython/blob/main/generator/overrides.py).\n\nIn this file you can override any parameter by specifying the key and the parameter you want to override. You can change the typing of any class, function, or literal. These are applied after the typing is retrieved from the online documentation.\n\nTo update the stubs run: `run.bat`. This will result in newly updated stubs in the `wx-stubs` folder.\n\n### Missing\nThe online documentation may be incomplete, or sometimes we just can't understand the page. In these cases, we can add typing to the stubs.\n\nYou can find this file in [`generator/extras.py`](https://github.com/AlexionSoftware/types-wxpython/blob/main/generator/extras.py).\n\nHere you can add any missing typing.\n\nTo update the stubs run: `run.bat`. This will result in newly updated stubs in the `wx-stubs` folder.\n\n## Help is appreciated\nWe started this project because we use wxPython ourselves and code typing is really helpful for finding bugs.\nBut there is so much in wxPython. We fixed problems in the stubs as they came up in our code. This can cause things to not work for your code.\n\nWe have decided to open source the work we have put into creating the best wxPython typing there is.\nWe want you to help. You can create an issue if you find problems with the typing. Or create a pull request if you have fixed something.\n\n### Guidelines\n* You don't need to commit newly generated stubs to your PR. We will generate them when we release a new version of the stubs.\n",
    'author': 'Alexion Software',
    'author_email': 'info@alexion.nl',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/AlexionSoftware/types-wxpython',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
