""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ufile.schemas import apis


class UFileClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UFileClient, self).__init__(config, transport, middleware, logger)

    def create_bucket(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateBucket - 创建Bucket

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **BucketName** (str) - (Required) 待创建Bucket的名称，具有全局唯一性
        - **Type** (str) - Bucket访问类型，public或private; 默认为private

        **Response**

        - **BucketId** (str) - 已创建Bucket的ID
        - **BucketName** (str) - 已创建Bucket的名称

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateBucketRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateBucket", d, **kwargs)
        return apis.CreateBucketResponseSchema().loads(resp)

    def create_ufile_token(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUFileToken - 创建US3令牌

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **TokenName** (str) - (Required) 令牌名称
        - **AllowedBuckets** (list) - 令牌允许操作的bucket，默认*表示全部
        - **AllowedOps** (list) - 令牌允许执行的操作，[ TOKEN_ALLOW_NONE , TOKEN_ALLOW_READ , TOKEN_ALLOW_WRITE , TOKEN_ALLOW_DELETE , TOKEN_ALLOW_LIST, TOKEN_ALLOW_IOP , TOKEN_ALLOW_DP  ]。默认TOKEN_ALLOW_NONE
        - **AllowedPrefixes** (list) - 令牌允许操作的key前缀，默认*表示全部
        - **ExpireTime** (int) - Unix 时间戳，精确到秒，为令牌过期时间点。默认过期时间为一天（即当前Unix时间戳+86400）；注意：过期时间不能超过 4102416000

        **Response**

        - **TokenId** (str) - 创建令牌的token_id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUFileTokenRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUFileToken", d, **kwargs)
        return apis.CreateUFileTokenResponseSchema().loads(resp)

    def delete_bucket(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteBucket - 删除Bucket

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **BucketName** (str) - (Required) 待删除Bucket的名称

        **Response**

        - **BucketId** (str) - Bucket的ID
        - **BucketName** (str) - Bucket的名称

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteBucketRequestSchema().dumps(d)

        resp = self.invoke("DeleteBucket", d, **kwargs)
        return apis.DeleteBucketResponseSchema().loads(resp)

    def delete_ufile_token(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUFileToken - 删除令牌

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **TokenId** (str) - (Required) 令牌ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUFileTokenRequestSchema().dumps(d)

        resp = self.invoke("DeleteUFileToken", d, **kwargs)
        return apis.DeleteUFileTokenResponseSchema().loads(resp)

    def describe_bucket(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeBucket - 获取Bucket的描述信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 如果提供此参数，则获取相应地域下所有空间的空间名称(只返回空间名称信息)
        - **BucketName** (str) - 待获取Bucket的名称，若不提供，则获取所有Bucket
        - **Limit** (int) - 获取所有Bucket列表的限制数目，默认为20
        - **Offset** (int) - 获取所有Bucket列表的偏移数目，默认为0

        **Response**

        - **DataSet** (list) - 见 **UFileBucketSet** 模型定义

        **Response Model**

        **UFileDomainSet**
        - **Cdn** (list) - UCDN加速域名
        - **CustomCdn** (list) - 用户自定义CDN加速域名
        - **CustomSrc** (list) - 用户自定义源站域名
        - **Src** (list) - 源站域名


        **UFileBucketSet**
        - **Biz** (str) - Bucket所属业务, general或vod或udb general: 普通业务； vod: 视频云业务; udb: 云数据库业务
        - **BucketId** (str) - Bucket的ID
        - **BucketName** (str) - Bucket名称
        - **CdnDomainId** (list) - 与Bucket关联的CND加速域名的ID列表
        - **CreateTime** (int) - Bucket的创建时间
        - **Domain** (dict) - 见 **UFileDomainSet** 模型定义
        - **HasUserDomain** (int) - 是否存在自定义域名。0不存在，1存在，2错误
        - **ModifyTime** (int) - Bucket的修改时间
        - **Region** (str) - Bucket所属地域
        - **Tag** (str) - 所属业务组
        - **Type** (str) - Bucket访问类型


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeBucketRequestSchema().dumps(d)

        resp = self.invoke("DescribeBucket", d, **kwargs)
        return apis.DescribeBucketResponseSchema().loads(resp)

    def describe_ufile_token(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUFileToken - 获取令牌信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **Display** (int) - 0表示显示部分token信息；不传递和其他情况表示显示全部token信息
        - **TokenId** (str) - 令牌ID，只返回指定ID信息，否则拉取所有令牌
        - **TokenName** (str) - 令牌名称，只返回指定令牌名称信息，否则拉取所有令牌

        **Response**

        - **DataSet** (list) - 见 **UFileTokenSet** 模型定义

        **Response Model**

        **UFileTokenSet**
        - **AllowedBuckets** (list) - 令牌允许操作的bucket
        - **AllowedOps** (list) - 令牌允许执行的操作，[ TOKEN_ALLOW_NONE , TOKEN_ALLOW_READ , TOKEN_ALLOW_WRITE , TOKEN_ALLOW_DELETE , TOKEN_ALLOW_LIST, TOKEN_ALLOW_IOP , TOKEN_ALLOW_DP ]
        - **AllowedPrefixes** (list) - 令牌允许操作的key前缀
        - **CreateTime** (int) - 创建时间
        - **ExpireTime** (int) - 令牌的超时时间点
        - **ModifyTime** (int) - 修改时间
        - **PrivateKey** (str) - 令牌私钥
        - **PublicKey** (str) - 令牌公钥
        - **Region** (str) - 所属地区
        - **TokenId** (str) - 令牌ID
        - **TokenName** (str) - 令牌名称


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUFileTokenRequestSchema().dumps(d)

        resp = self.invoke("DescribeUFileToken", d, **kwargs)
        return apis.DescribeUFileTokenResponseSchema().loads(resp)

    def get_ufile_quota(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUFileQuota - 查看配额状态

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **QuotaType** (str) - (Required) 配额类型，取值为storage-volume, download-traffic或request-count

        **Response**

        - **LeftQuota** (float) - 剩余的配额数值

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUFileQuotaRequestSchema().dumps(d)

        resp = self.invoke("GetUFileQuota", d, **kwargs)
        return apis.GetUFileQuotaResponseSchema().loads(resp)

    def get_ufile_quota_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUFileQuotaInfo - 获取配额信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **QuotaType** (list) - (Required) 配额类型，取值为storage-volume, download-traffic或request-count

        **Response**

        - **DataSet** (list) - 见 **UFileQuotaDataSetItem** 模型定义

        **Response Model**

        **UFileQuotaLeft**
        - **Left** (float) - 配额剩余量


        **UFileQuotaDataSetItem**
        - **DownloadFlow** (dict) - 见 **UFileQuotaLeft** 模型定义
        - **Owe** (int) - 是否欠费：1表示欠费；0表示未欠费
        - **Region** (str) - 可用地域
        - **RequestCnt** (dict) - 见 **UFileQuotaLeft** 模型定义
        - **Storage** (dict) - 见 **UFileQuotaLeft** 模型定义


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetUFileQuotaInfoRequestSchema().dumps(d)

        resp = self.invoke("GetUFileQuotaInfo", d, **kwargs)
        return apis.GetUFileQuotaInfoResponseSchema().loads(resp)

    def get_ufile_quota_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUFileQuotaPrice - 根据US3的购买配额，查询需要支付的价格。

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **DownloadTraffic** (int) - 下载流量，单位: GB，范围: [0, 60 000]，步长：1GB
        - **RequestCount** (int) - 请求次数，单位：万次，范围：[0, 1 000 000]，步长：1万次
        - **StorageVolume** (int) - 存储容量，单位: GB*天，范围: [0, 30 000 000]，步长：100GB*天

        **Response**

        - **Price** (float) - 待支付价格，单位：分

        """
        # build request
        d = {
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetUFileQuotaPriceRequestSchema().dumps(d)

        resp = self.invoke("GetUFileQuotaPrice", d, **kwargs)
        return apis.GetUFileQuotaPriceResponseSchema().loads(resp)

    def get_ufile_report(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUFileReport - 查看配额使用报表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **EndTime** (int) - (Required) 查询结束时间
        - **StartTime** (int) - (Required) 查询开始时间

        **Response**

        - **DataSet** (list) - 见 **UFileReportSet** 模型定义

        **Response Model**

        **UFileReportSet**
        - **DownloadTraffic** (float) - 配额消费当日使用的下载流量，单位：GB
        - **RequestCount** (float) - 配额消费当日使用的请求次数，单位：万次
        - **StorageVolume** (float) - 配额消费当日使用的存储容量，单位：GB*天
        - **Time** (int) - 配额消费时间，unix时间戳，精确到日期


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetUFileReportRequestSchema().dumps(d)

        resp = self.invoke("GetUFileReport", d, **kwargs)
        return apis.GetUFileReportResponseSchema().loads(resp)

    def set_ufile_referer(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """SetUFileReferer - 设置对象存储防盗链

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BucketName** (str) - (Required) 存储空间名称
        - **RefererStatus** (str) - (Required) 开启关闭referer防盗链;关闭防盗链会清空防盗链参数设置，开启防盗链必须指定 RefererType、Referers；开启：on， 关闭：off;
        - **RefererAllowNull** (bool) - RefererType为白名单时，RefererAllowNull为false代表不允许空referer访问，为true代表允许空referer访问;此参数默认为 true;
        - **RefererType** (int) - 防盗链Referer类型，支持两种类型，黑名单和白名单; 1黑名单，2白名单；RefererStatus为"on"时此参数必填；
        - **Referers** (list) - 防盗链Referer规则，支持正则表达式（不支持符号';')

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.SetUFileRefererRequestSchema().dumps(d)

        resp = self.invoke("SetUFileReferer", d, **kwargs)
        return apis.SetUFileRefererResponseSchema().loads(resp)

    def update_bucket(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateBucket - 更改Bucket的属性

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **BucketName** (str) - (Required) 待修改Bucket的名称
        - **Type** (str) - (Required) Bucket访问类型;public或private

        **Response**

        - **BucketId** (str) - Bucket的ID
        - **BucketName** (str) - Bucket的名称

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UpdateBucketRequestSchema().dumps(d)

        resp = self.invoke("UpdateBucket", d, **kwargs)
        return apis.UpdateBucketResponseSchema().loads(resp)

    def update_ufile_token(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateUFileToken - 更新令牌的操作权限，可操作key的前缀，可操作bucket和令牌超时时间点

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **TokenId** (str) - (Required) 令牌ID
        - **AllowedBuckets** (list) - 令牌允许操作的bucket
        - **AllowedOps** (list) - 令牌允许执行的操作，[ TOKEN_ALLOW_NONE , TOKEN_ALLOW_READ , TOKEN_ALLOW_WRITE , TOKEN_ALLOW_DELETE , TOKEN_ALLOW_LIST, TOKEN_ALLOW_IOP , TOKEN_ALLOW_DP ]
        - **AllowedPrefixes** (list) - 令牌允许操作的key前缀
        - **ExpireTime** (int) - 令牌的超时时间点（时间戳）;注意：过期时间不能超过 4102416000
        - **TokenName** (str) - 令牌名称

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpdateUFileTokenRequestSchema().dumps(d)

        resp = self.invoke("UpdateUFileToken", d, **kwargs)
        return apis.UpdateUFileTokenResponseSchema().loads(resp)
