""" Code is generated by ucloud-model, DO NOT EDIT IT. """


from ucloud.core.typesystem import schema, fields
from ucloud.services.cube.schemas import models

""" Cube API Schema
"""


"""
API: CreateCubeDeployment

创建Cube的Deployment
"""


class CreateCubeDeploymentRequestSchema(schema.RequestSchema):
    """CreateCubeDeployment - 创建Cube的Deployment"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CpuPlatform": fields.Str(required=False, dump_to="CpuPlatform"),
        "Deployment": fields.Str(required=True, dump_to="Deployment"),
        "KubeConfig": fields.Str(required=False, dump_to="KubeConfig"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateCubeDeploymentResponseSchema(schema.ResponseSchema):
    """CreateCubeDeployment - 创建Cube的Deployment"""

    fields = {
        "Deployment": fields.Str(required=False, load_from="Deployment"),
        "DeploymentId": fields.Str(required=True, load_from="DeploymentId"),
    }


"""
API: CreateCubePod

创建Pod
"""


class CreateCubePodRequestSchema(schema.RequestSchema):
    """CreateCubePod - 创建Pod"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "CpuPlatform": fields.Str(required=False, dump_to="CpuPlatform"),
        "Group": fields.Str(required=False, dump_to="Group"),
        "KubeConfig": fields.Str(required=False, dump_to="KubeConfig"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "Pod": fields.Str(required=True, dump_to="Pod"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateCubePodResponseSchema(schema.ResponseSchema):
    """CreateCubePod - 创建Pod"""

    fields = {
        "CubeId": fields.Str(required=False, load_from="CubeId"),
        "Pod": fields.Str(required=True, load_from="Pod"),
    }


"""
API: DeleteCubeDeployment

删除Cube的Deployment
"""


class DeleteCubeDeploymentRequestSchema(schema.RequestSchema):
    """DeleteCubeDeployment - 删除Cube的Deployment"""

    fields = {
        "DeploymentId": fields.Str(required=True, dump_to="DeploymentId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DeleteCubeDeploymentResponseSchema(schema.ResponseSchema):
    """DeleteCubeDeployment - 删除Cube的Deployment"""

    fields = {}


"""
API: DeleteCubePod

删除Pod
"""


class DeleteCubePodRequestSchema(schema.RequestSchema):
    """DeleteCubePod - 删除Pod"""

    fields = {
        "CubeId": fields.Str(required=False, dump_to="CubeId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ReleaseEIP": fields.Bool(required=False, dump_to="ReleaseEIP"),
        "Uid": fields.Str(required=False, dump_to="Uid"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DeleteCubePodResponseSchema(schema.ResponseSchema):
    """DeleteCubePod - 删除Pod"""

    fields = {}


"""
API: GetCubeDeployment

获取Deployment的详细信息
"""


class GetCubeDeploymentRequestSchema(schema.RequestSchema):
    """GetCubeDeployment - 获取Deployment的详细信息"""

    fields = {
        "DeploymentId": fields.Str(required=True, dump_to="DeploymentId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class GetCubeDeploymentResponseSchema(schema.ResponseSchema):
    """GetCubeDeployment - 获取Deployment的详细信息"""

    fields = {
        "Deployment": fields.Str(required=True, load_from="Deployment"),
    }


"""
API: GetCubeExecToken

获取登录容器的token
"""


class GetCubeExecTokenRequestSchema(schema.RequestSchema):
    """GetCubeExecToken - 获取登录容器的token"""

    fields = {
        "ContainerName": fields.Str(required=True, dump_to="ContainerName"),
        "CubeId": fields.Str(required=False, dump_to="CubeId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Uid": fields.Str(required=False, dump_to="Uid"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class GetCubeExecTokenResponseSchema(schema.ResponseSchema):
    """GetCubeExecToken - 获取登录容器的token"""

    fields = {
        "TerminalUrl": fields.Str(required=False, load_from="TerminalUrl"),
        "Token": fields.Str(required=True, load_from="Token"),
    }


"""
API: GetCubeExtendInfo

获取Cube的额外信息
"""


class GetCubeExtendInfoRequestSchema(schema.RequestSchema):
    """GetCubeExtendInfo - 获取Cube的额外信息"""

    fields = {
        "CubeIds": fields.Str(required=True, dump_to="CubeIds"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class GetCubeExtendInfoResponseSchema(schema.ResponseSchema):
    """GetCubeExtendInfo - 获取Cube的额外信息"""

    fields = {
        "ExtendInfo": fields.List(
            models.CubeExtendInfoSchema(), required=True, load_from="ExtendInfo"
        ),
    }


"""
API: GetCubeMetrics

获取Cube实例（Pod，PodX，Deploy等）监控数据时间序列
"""


class GetCubeMetricsRequestSchema(schema.RequestSchema):
    """GetCubeMetrics - 获取Cube实例（Pod，PodX，Deploy等）监控数据时间序列"""

    fields = {
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "ContainerName": fields.Str(required=True, dump_to="ContainerName"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "MetricName": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceId": fields.Str(required=True, dump_to="ResourceId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetCubeMetricsResponseSchema(schema.ResponseSchema):
    """GetCubeMetrics - 获取Cube实例（Pod，PodX，Deploy等）监控数据时间序列"""

    fields = {
        "DataSets": fields.List(
            models.MetricDataSetSchema(), required=False, load_from="DataSets"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: GetCubePod

获取Pod的详细信息
"""


class GetCubePodRequestSchema(schema.RequestSchema):
    """GetCubePod - 获取Pod的详细信息"""

    fields = {
        "CubeId": fields.Str(required=False, dump_to="CubeId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Uid": fields.Str(required=False, dump_to="Uid"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class GetCubePodResponseSchema(schema.ResponseSchema):
    """GetCubePod - 获取Pod的详细信息"""

    fields = {
        "Pod": fields.Str(required=True, load_from="Pod"),
    }


"""
API: GetCubePrice

获取cube的价格
"""


class GetCubePriceRequestSchema(schema.RequestSchema):
    """GetCubePrice - 获取cube的价格"""

    fields = {
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "Count": fields.Str(required=True, dump_to="Count"),
        "Cpu": fields.Str(required=True, dump_to="Cpu"),
        "Mem": fields.Str(required=True, dump_to="Mem"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=True, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetCubePriceResponseSchema(schema.ResponseSchema):
    """GetCubePrice - 获取cube的价格"""

    fields = {
        "OriginalPrice": fields.Int(required=True, load_from="OriginalPrice"),
        "Price": fields.Int(required=True, load_from="Price"),
    }


"""
API: ListCubeDeployment

获取Cube的Deployment列表
"""


class ListCubeDeploymentRequestSchema(schema.RequestSchema):
    """ListCubeDeployment - 获取Cube的Deployment列表"""

    fields = {
        "Limit": fields.Int(required=True, dump_to="Limit"),
        "Offset": fields.Int(required=True, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ListCubeDeploymentResponseSchema(schema.ResponseSchema):
    """ListCubeDeployment - 获取Cube的Deployment列表"""

    fields = {
        "Deployments": fields.List(
            fields.Str(), required=True, load_from="Deployments"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: ListCubePod

获取Pods列表
"""


class ListCubePodRequestSchema(schema.RequestSchema):
    """ListCubePod - 获取Pods列表"""

    fields = {
        "DeploymentId": fields.Str(required=False, dump_to="DeploymentId"),
        "Group": fields.Str(required=False, dump_to="Group"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ListCubePodResponseSchema(schema.ResponseSchema):
    """ListCubePod - 获取Pods列表"""

    fields = {
        "Pods": fields.List(fields.Str(), required=True, load_from="Pods"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: ModifyCubeExtendInfo

修改Cube额外信息
"""


class ModifyCubeExtendInfoRequestSchema(schema.RequestSchema):
    """ModifyCubeExtendInfo - 修改Cube额外信息"""

    fields = {
        "CubeId": fields.Str(required=True, dump_to="CubeId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ModifyCubeExtendInfoResponseSchema(schema.ResponseSchema):
    """ModifyCubeExtendInfo - 修改Cube额外信息"""

    fields = {}


"""
API: ModifyCubeTag

修改业务组名字
"""


class ModifyCubeTagRequestSchema(schema.RequestSchema):
    """ModifyCubeTag - 修改业务组名字"""

    fields = {
        "CubeId": fields.Str(required=True, dump_to="CubeId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Tag": fields.Str(required=True, dump_to="Tag"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ModifyCubeTagResponseSchema(schema.ResponseSchema):
    """ModifyCubeTag - 修改业务组名字"""

    fields = {
        "CubeId": fields.Str(required=True, load_from="CubeId"),
    }


"""
API: RenewCubePod

更新Pod
"""


class RenewCubePodRequestSchema(schema.RequestSchema):
    """RenewCubePod - 更新Pod"""

    fields = {
        "CubeId": fields.Str(required=True, dump_to="CubeId"),
        "Pod": fields.Str(required=True, dump_to="Pod"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class RenewCubePodResponseSchema(schema.ResponseSchema):
    """RenewCubePod - 更新Pod"""

    fields = {
        "Pod": fields.Str(required=True, load_from="Pod"),
    }


"""
API: UpdateCubeDeployment

更新Deployment
"""


class UpdateCubeDeploymentRequestSchema(schema.RequestSchema):
    """UpdateCubeDeployment - 更新Deployment"""

    fields = {
        "Deployment": fields.Str(required=True, dump_to="Deployment"),
        "DeploymentId": fields.Str(required=True, dump_to="DeploymentId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class UpdateCubeDeploymentResponseSchema(schema.ResponseSchema):
    """UpdateCubeDeployment - 更新Deployment"""

    fields = {
        "Deployment": fields.Str(required=False, load_from="Deployment"),
    }
