""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.uec.schemas import apis


class UECClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UECClient, self).__init__(config, transport, middleware, logger)

    def bind_u_ec_firewall(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """BindUEcFirewall - 绑定防火墙，应用防火墙规则

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **FirewallId** (str) - (Required) 防火墙Id
        - **ResourceId** (str) - (Required) 虚拟机资源Id或容器组资源id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.BindUEcFirewallRequestSchema().dumps(d)

        resp = self.invoke("BindUEcFirewall", d, **kwargs)
        return apis.BindUEcFirewallResponseSchema().loads(resp)

    def create_u_ec_firewall(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUEcFirewall - 创建外网防火墙

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Name** (str) - (Required) 防火墙名称
        - **Remark** (str) - 描述
        - **Rule** (list) - 见 **CreateUEcFirewallParamRule** 模型定义

        **Response**

        - **FirewallId** (str) - 防火墙Id

        **Request Model**

        **CreateUEcFirewallParamRule**
        - **Action** (str) - ACCEPT（接受）和DROP（拒绝）
        - **Port** (str) - 端口，范围用"-"符号分隔，如：1-65535
        - **Priority** (str) - 优先级：HIGH（高），MEDIUM（中），LOW（低）
        - **ProtocolType** (str) - 协议，可选值：TCP，UDP，ICMP
        - **Remark** (str) - 备注
        - **SrcIp** (str) - 源ip


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.CreateUEcFirewallRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUEcFirewall", d, **kwargs)
        return apis.CreateUEcFirewallResponseSchema().loads(resp)

    def create_u_ec_holder(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUEcHolder - 创建容器组

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **CpuCore** (float) - (Required) 容器组Cpu总核数
        - **IdcId** (str) - (Required) 机房id
        - **MemSize** (int) - (Required) 容器组总内存，单位MB
        - **SubnetId** (str) - (Required) 子网ID
        - **Bandwidth** (int) - 外网绑定的带宽（单位M，默认0，只有当ElasticIp为yes时，默认1）
        - **ChargeQuantity** (int) - 月数或者年数（默认值：1，当为按月计费时，0表示计费到月底，默认值为0）
        - **ChargeType** (int) - 付费方式（2按月、3按年。默认2，默认月付）
        - **ElasticIp** (str) - 绑定外网ip（yes-绑定，no-不绑定，默认no）
        - **FirewallId** (str) - 防火墙ID
        - **Image** (list) - 见 **CreateUEcHolderParamImage** 模型定义
        - **Name** (str) - 容器组名称（默认default）
        - **Pack** (list) - 见 **CreateUEcHolderParamPack** 模型定义
        - **ProductType** (str) - 机型（normal-标准型，hf-高性能型，默认normal）
        - **RestartStrategy** (int) - 重启策略（0总是，1失败是，2永不，默认0）
        - **Storage** (list) - 见 **CreateUEcHolderParamStorage** 模型定义

        **Response**

        - **ResourceId** (str) - 容器组资源id

        **Request Model**

        **CreateUEcHolderParamPack**
        - **Args** (str) - 容器参数（多个用；隔开）
        - **Cmd** (str) - 开启容器的命令
        - **ConfigDict** (str) - 容器配置字典（多个用；隔开，如：/data1:resId1;/data2:resId2）
        - **CpuCore** (float) - 容器Cpu核数
        - **Environment** (str) - 容器环境变量（多个用；隔开,如：key1:value1;key2:value2）
        - **ImageName** (str) - 容器镜像名称
        - **MemSize** (int) - 容器内存，单位MB
        - **Name** (str) - 容器名称
        - **WorkDir** (str) - 容器工作目录


        **CreateUEcHolderParamImage**
        - **Message** (str) - 镜像用户名和密码（如镜像名：密码）
        - **StoreAddress** (str) - 镜像仓库地址


        **CreateUEcHolderParamStorage**
        - **Path** (str) - 存储卷挂载路径
        - **ResourceId** (str) - 存储卷资源id


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.CreateUEcHolderRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUEcHolder", d, **kwargs)
        return apis.CreateUEcHolderResponseSchema().loads(resp)

    def create_u_ec_subnet(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUEcSubnet - 创建子网

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **CIDR** (str) - (Required) 子网cidr
        - **IdcId** (str) - (Required) 机房ID
        - **Comment** (str) - 备注
        - **SubnetName** (str) - 子网名称

        **Response**

        - **SubnetId** (str) - 子网ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.CreateUEcSubnetRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUEcSubnet", d, **kwargs)
        return apis.CreateUEcSubnetResponseSchema().loads(resp)

    def create_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUEcVHost - 创建虚拟机v2.0

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **CpuCore** (int) - (Required) cpu核心数
        - **DiskSize** (int) - (Required) 数据盘大小，单位GB
        - **IdcId** (str) - (Required) 机房id
        - **ImageId** (str) - (Required) 镜像ID
        - **MemSize** (int) - (Required) 内存大小，单位GB
        - **NetLimit** (int) - (Required) 节点带宽限制，单位Mbs
        - **AccountName** (str) - 账户名，默认root
        - **ChargeQuantity** (int) - 月数或者年数，0计费到月底， 默认0
        - **ChargeType** (int) - 付费方式，1按时，2按月，3按年，默认2
        - **FirewallId** (str) - 外网防护墙规则组，默认
        - **IsNeedOuterIp** (str) - （已废弃）是否需要外网ip（yes-是，no-否）
        - **Isp** (list) - 运营商（1-电信，2-联通，4移动）
        - **NodeCount** (int) - 创建节点数量，默认1
        - **NodeName** (str) - 节点名称
        - **PassWord** (str) - 密码
        - **ProductType** (str) - 产品类型：normal（标准型），hf（高频型）
        - **SubnetId** (str) - 子网ID
        - **SysDiskSize** (int) - 系统盘大小，单位GB， 默认20GB

        **Response**

        - **NodeList** (list) - 见 **NodeList** 模型定义

        **Response Model**

        **NodeList**
        - **NodeId** (str) - 虚拟机资源id


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.CreateUEcVHostRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUEcVHost", d, **kwargs)
        return apis.CreateUEcVHostResponseSchema().loads(resp)

    def delete_u_ec_custom_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUEcCustomImage - 删除UEDN客户自定义镜像

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **ImageId** (str) - (Required) 镜像ID
        - **IdcId** (str) - 机房ID，带机房ID表示只删除指定机房镜像

        **Response**

        - **ImageId** (int) - 镜像ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteUEcCustomImageRequestSchema().dumps(d)

        resp = self.invoke("DeleteUEcCustomImage", d, **kwargs)
        return apis.DeleteUEcCustomImageResponseSchema().loads(resp)

    def delete_u_ec_holder(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUEcHolder - 删除容器组

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **HolderId** (list) - (Required) 容器组资源id，n为0，1，2...

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteUEcHolderRequestSchema().dumps(d)

        resp = self.invoke("DeleteUEcHolder", d, **kwargs)
        return apis.DeleteUEcHolderResponseSchema().loads(resp)

    def delete_u_ec_subnet(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUEcSubnet - 删除子网

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **SubnetId** (str) - (Required) 子网ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteUEcSubnetRequestSchema().dumps(d)

        resp = self.invoke("DeleteUEcSubnet", d, **kwargs)
        return apis.DeleteUEcSubnetResponseSchema().loads(resp)

    def delete_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUEcVHost - 删除vhost虚拟机 v2.0

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (list) - (Required) 节点id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteUEcVHostRequestSchema().dumps(d)

        resp = self.invoke("DeleteUEcVHost", d, **kwargs)
        return apis.DeleteUEcVHostResponseSchema().loads(resp)

    def describe_u_ec_firewall(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcFirewall - 获取防火墙信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **FirewallId** (str) - 防火墙ID，默认为返回所有防火墙
        - **Limit** (int) - 返回数据长度，默认为20
        - **Offset** (int) - 列表起始位置偏移量，默认为0
        - **ResourceId** (str) - 绑定防火墙组的虚拟机资源ID

        **Response**

        - **FirewallSet** (list) - 见 **FirewallInfo** 模型定义
        - **TotalCount** (int) - 满足条件的节点总数

        **Response Model**

        **RuleInfo**
        - **Action** (str) - ACCEPT（接受）和DROP（拒绝）
        - **Port** (str) - 端口，范围用"-"符号分隔，如：1-65535
        - **Priority** (str) - 优先级：HIGH（高），MEDIUM（中），LOW（低）
        - **ProtocolType** (str) - 协议，可选值：TCP，UDP，ICMP
        - **Remark** (str) - 备注
        - **SrcIp** (str) - 源ip


        **FirewallInfo**
        - **CreateTime** (int) - 创建时间
        - **FirewallId** (str) - 防火墙Id
        - **Name** (str) - 防火墙名称
        - **Remark** (str) - 描述
        - **ResourceCount** (int) - 防火墙绑定资源数量
        - **Rule** (list) - 见 **RuleInfo** 模型定义
        - **Type** (str) - 防火墙组类型，枚举值为： "user defined", 用户自定义防火墙； "recommend web", 默认Web防火墙； "recommend non web", 默认非Web防火墙


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUEcFirewallRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcFirewall", d, **kwargs)
        return apis.DescribeUEcFirewallResponseSchema().loads(resp)

    def describe_u_ec_firewall_resource(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcFirewallResource - 防火墙绑定的资源列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **FirewallId** (str) - (Required) 防火墙Id

        **Response**

        - **ResourceSet** (list) - 见 **ResourceInfo** 模型定义
        - **TotalCount** (int) - 资源总数

        **Response Model**

        **ResourceInfo**
        - **Name** (str) - 节点名称
        - **PublicIpList** (list) - 节点公网Ip列表
        - **Remark** (str) - 节点备注
        - **ResourceId** (str) - 资源Id
        - **State** (int) - 节点状态，1部署中，2待启动，3启动中，4运行中，5正在停止，6已停止，7正在更新，8正在重启，9正在删除， 10已经删除,11异常


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUEcFirewallResourceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcFirewallResource", d, **kwargs)
        return apis.DescribeUEcFirewallResourceResponseSchema().loads(resp)

    def describe_u_ec_holder(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcHolder - 获得容器组信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **HolderId** (list) - 容器组资源id
        - **Limit** (int) - 返回数据长度，默认为20，非负整数
        - **Offset** (int) - 列表起始位置偏移量，默认为0。非负整数

        **Response**

        - **HolderList** (list) - 见 **HolderList** 模型定义
        - **TotalCount** (int) - 满足条件的容器组总数

        **Response Model**

        **CfgDictList**
        - **MountPath** (str) - 挂载路径
        - **Name** (str) - 名称
        - **ResourceId** (str) - 资源id


        **EnvList**
        - **Key** (str) - 环境变量key值
        - **Value** (str) - 环境变量Value值


        **StorVolumeInfo**
        - **DiskSize** (int) - 容量（单位GB）
        - **MountPoint** (str) - 挂载点
        - **Name** (str) - 名称
        - **ResourceId** (str) - 资源id


        **DockerInfo**
        - **Args** (str) - 参数
        - **CfgDictList** (list) - 见 **CfgDictList** 模型定义
        - **Command** (str) - 命令
        - **CpuCores** (float) - CPU核数（/核）精度0.1核
        - **EnvList** (list) - 见 **EnvList** 模型定义
        - **ImageName** (str) - 镜像名称
        - **MemSize** (float) - 内存大小（Gi）
        - **Name** (str) - 容器名称
        - **State** (int) - 容器状态，0：初始化；1：拉取镜像；2：拉取镜像失败；3：启动中；4：运行中；5：正在停止；6：已停止；7：已删除；8：镜像拉取成功；9：启动失败；99：异常
        - **WorkDir** (str) - 工作目录


        **ImageList**
        - **ImageKey** (str) - 镜像密钥
        - **StoreAddr** (str) - 仓库地址
        - **UserName** (str) - 用户名称


        **IpList**
        - **Ip** (str) - 外网ip
        - **Isp** (str) - 运营商


        **HolderList**
        - **City** (str) - 城市名称
        - **CreateTime** (int) - 创建时间
        - **DockerCount** (int) - 容器数量
        - **DockerInfo** (list) - 见 **DockerInfo** 模型定义
        - **ExpireTime** (int) - 过期时间
        - **FirewallId** (str) - 外网防火墙id
        - **HolderName** (str) - 容器组名称
        - **IdcId** (str) - 机房id
        - **ImageList** (list) - 见 **ImageList** 模型定义
        - **InnerIp** (str) - 容器组内网ip
        - **IpList** (list) - 见 **IpList** 模型定义
        - **NetLimit** (int) - 外网绑定的带宽
        - **OcName** (str) - 机房名称
        - **ProductType** (str) - 机器类型（normal通用型，hf高性能型）
        - **Province** (str) - 省份名称
        - **ResourceId** (str) - 容器组资源id
        - **RestartStrategy** (int) - 0：总是；1：失败是；2：永不
        - **State** (int) - 容器组运行状态0：初始化；1：拉取镜像；2：启动中；3：运行中；4：错误；5：正在重启；6：正在删除；7：已经删除；8：容器运行错误；9：启动失败；99：异常
        - **StorVolumeCount** (int) - 存储卷数量
        - **StorVolumeInfo** (list) - 见 **StorVolumeInfo** 模型定义
        - **SubnetId** (str) - 容器组子网id
        - **Type** (int) - 线路类型（运营商类型： 0-其它, 1-一线城市单线,2-二线城市单线, 3-全国教育网, 4-全国三通）


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUEcHolderRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcHolder", d, **kwargs)
        return apis.DescribeUEcHolderResponseSchema().loads(resp)

    def describe_u_ec_holder_idc(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcHolderIDC - 获取容器组机房信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Cpu** (float) - (Required) 容器组Cpu核数
        - **Memory** (int) - (Required) 容器组内存大小（单位MB）
        - **IdcId** (list) - Idc机房id。默认全部机房
        - **ProductType** (str) - 产品类型，normal标准型，hf高性能型
        - **Type** (int) - 0-其它, 1-一线城市单线,2-二线城市单线, 3-全国教育网, 4-全国三通

        **Response**

        - **IdcList** (list) - 见 **IdcInfo** 模型定义

        **Response Model**

        **IdcInfo**
        - **City** (str) - 城市
        - **IdcId** (str) - 机房ID
        - **Isp** (str) - 运营商
        - **MaxNodeCnt** (int) - 机房可创建节点最大数量
        - **Name** (str) - 机房名称
        - **Province** (str) - 省份
        - **Type** (int) - 运营商类型：0-其它, 1-一线城市单线,2-二线城市单线, 3-全国教育网, 4-全国三通


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUEcHolderIDCRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcHolderIDC", d, **kwargs)
        return apis.DescribeUEcHolderIDCResponseSchema().loads(resp)

    def describe_u_ec_idc(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcIDC - 获取IDC机房列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Cpu** (int) - (Required) 节点cpu核数
        - **Memory** (int) - (Required) 节点内存大小， 单位GB
        - **IdcId** (list) - Idc机房id。默认全部机房
        - **ProductType** (str) - 产品类型：normal（通用型），hf（高主频型）
        - **Type** (int) - 0-其它, 1-一线城市单线,2-二线城市单线, 3-全国教育网, 4-全国三通

        **Response**

        - **Action** (str) - 操作名称
        - **IdcList** (list) - 见 **IdcInfo** 模型定义
        - **RetCode** (int) - 返回码

        **Response Model**

        **IdcInfo**
        - **City** (str) - 城市
        - **IdcId** (str) - 机房ID
        - **Isp** (str) - 运营商
        - **MaxNodeCnt** (int) - 机房可创建节点最大数量
        - **Name** (str) - 机房名称
        - **Province** (str) - 省份
        - **Type** (int) - 运营商类型：0-其它, 1-一线城市单线,2-二线城市单线, 3-全国教育网, 4-全国三通


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUEcIDCRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcIDC", d, **kwargs)
        return apis.DescribeUEcIDCResponseSchema().loads(resp)

    def describe_u_ec_subnet(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcSubnet - 获取子网列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **IdcId** (str) - 机房ID
        - **SubnetId** (str) - 子网ID

        **Response**

        - **SubnetList** (list) - 见 **SubnetInfo** 模型定义

        **Response Model**

        **SubnetInfo**
        - **AvailableIPCnt** (int) - 可用ip数
        - **CIDR** (str) - 子网cidr
        - **Comment** (str) - 备注
        - **CreateTime** (int) - 创建时间
        - **IdcId** (str) - 机房ID
        - **SubnetId** (str) - 子网ID
        - **SubnetName** (str) - 子网名称
        - **TotalIpCnt** (int) - 总ip数


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUEcSubnetRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcSubnet", d, **kwargs)
        return apis.DescribeUEcSubnetResponseSchema().loads(resp)

    def describe_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcVHost - 获取虚拟机列表 2.0

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **IdcId** (list) - Idc机房id。默认全部机房
        - **Limit** (int) - 返回数据长度， 默认20，非负整数
        - **NodeId** (list) - 节点id，创建节点时生成的id。默认全部节点
        - **Offset** (int) - 数据偏移量，默认0，非负整数

        **Response**

        - **NodeList** (list) - 见 **NodeInfo** 模型定义
        - **TotalCount** (int) - 满足条件的节点总数

        **Response Model**

        **NodeIpList**
        - **Ip** (str) - 外网ip
        - **Isp** (str) - 运营商
        - **IspName** (str) - 运营商名称


        **NodeInfo**
        - **ChargeType** (int) - 付费类型：1按时, 2按月,3按年
        - **City** (str) - 城市
        - **CoreNum** (int) - Cpu核数
        - **CreateTime** (int) - 创建时间
        - **DiskSize** (int) - 数据盘大小， 单位GB
        - **ExpiredTime** (int) - 过期时间
        - **FirewallId** (str) - 防火墙Id
        - **IdcId** (str) - 机房ID
        - **ImageName** (str) - 镜像名称
        - **MemSize** (int) - 节点内存大小，单位GB
        - **NetLimit** (int) - 节点带宽限制， 单位Mbs
        - **NodeId** (str) - 节点ID
        - **NodeIpList** (list) - 见 **NodeIpList** 模型定义
        - **NodeName** (str) - 节点名称
        - **OcName** (str) - 机房名称
        - **ProductType** (str) - 机器类型
        - **Province** (str) - 省份
        - **State** (int) - 节点状态，1部署中，2待启动，3启动中，4运行中，5正在停止，6已停止，7正在更新，8正在重启，9正在删除， 10已经删除,11异常
        - **SysDiskSize** (int) - 系统盘大小， 单位GB
        - **Type** (int) - 运营商类型： 0-其它, 1-一线城市单线,2-二线城市单线, 3-全国教育网, 4-全国三通


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DescribeUEcVHostRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcVHost", d, **kwargs)
        return apis.DescribeUEcVHostResponseSchema().loads(resp)

    def describe_u_ec_v_host_isp(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUEcVHostISP - 获取虚拟机运营商信息

        **Request**

        - **City** (str) - 城市
        - **IspName** (str) - 运营商名称
        - **Province** (str) - 省份

        **Response**

        - **NodeIspList** (list) - 见 **NodeIspList** 模型定义

        **Response Model**

        **NodeIspList**
        - **City** (str) - 城市
        - **IdcName** (str) - 机房名称
        - **IspName** (str) - 机房运营商名称
        - **LineType** (str) - 线路类型
        - **Province** (str) - 省份


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.DescribeUEcVHostISPRequestSchema().dumps(d)

        resp = self.invoke("DescribeUEcVHostISP", d, **kwargs)
        return apis.DescribeUEcVHostISPResponseSchema().loads(resp)

    def get_u_ec_holder_log(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcHolderLog - 获取单个容器日志

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **PackName** (str) - (Required) 容器名称
        - **ResourceId** (str) - (Required) 容器组资源id

        **Response**

        - **Data** (str) - 返回的日志数据

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUEcHolderLogRequestSchema().dumps(d)

        resp = self.invoke("GetUEcHolderLog", d, **kwargs)
        return apis.GetUEcHolderLogResponseSchema().loads(resp)

    def get_u_ec_holder_metrics(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcHolderMetrics - 获取容器（CPU利用率，带宽，内存）数据

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **PackName** (str) - (Required) 容器名称
        - **ResourceId** (str) - (Required) 容器组资源id
        - **Type** (list) - (Required) n为0 CPU利用率, 1内存使用率, 2网卡出带宽, 3网卡入带宽, 4网卡出包数, 5网卡入包数
        - **EndTime** (int) - 结束时间
        - **StartTime** (int) - 开始时间

        **Response**

        - **DataSets** (dict) - 见 **MetricisDataSet** 模型定义

        **Response Model**

        **MonitorInfo**
        - **TimeStamp** (int) - 时间戳
        - **Value** (int) - 值


        **MetricisDataSet**
        - **CPUUtilization** (list) - 见 **MonitorInfo** 模型定义
        - **MemUtilization** (list) - 见 **MonitorInfo** 模型定义
        - **NICIn** (list) - 见 **MonitorInfo** 模型定义
        - **NICOut** (list) - 见 **MonitorInfo** 模型定义
        - **NetPacketIn** (list) - 见 **MonitorInfo** 模型定义
        - **NetPacketOut** (list) - 见 **MonitorInfo** 模型定义


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUEcHolderMetricsRequestSchema().dumps(d)

        resp = self.invoke("GetUEcHolderMetrics", d, **kwargs)
        return apis.GetUEcHolderMetricsResponseSchema().loads(resp)

    def get_u_ec_idc_cut_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcIDCCutInfo - 获取机房割接信息

        **Request**


        **Response**

        - **IDCCutInfo** (list) - 见 **IDCCutInfo** 模型定义
        - **TotalCount** (int) - 满足条件的机房总数

        **Response Model**

        **ResourceSet**
        - **NodeId** (str) - 节点id
        - **OuterIps** (list) - 机器外网ip集合


        **IDCCutInfo**
        - **City** (str) - 城市
        - **CutType** (str) - 割接类型（中断、抖动、断电）
        - **EndTime** (int) - 割接结束时间
        - **IDCName** (str) - 机房名称
        - **Province** (str) - 省份
        - **ResourceSet** (list) - 见 **ResourceSet** 模型定义
        - **StartTime** (int) - 割接开始时间


        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetUEcIDCCutInfoRequestSchema().dumps(d)

        resp = self.invoke("GetUEcIDCCutInfo", d, **kwargs)
        return apis.GetUEcIDCCutInfoResponseSchema().loads(resp)

    def get_u_ec_idcv_host_data(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcIDCVHostData - 获取机房虚拟机监控数据

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (list) - (Required) 节点资源id；n为0，1，2...
        - **Type** (list) - (Required) 监控数据类型；n为0,1,2,3,4...,9
        - **BeginTime** (int) - 开始时间戳
        - **EndTime** (int) - 结束时间戳

        **Response**

        - **DataSets** (dict) - 见 **DataSet** 模型定义

        **Response Model**

        **MonitorInfo**
        - **TimeStamp** (int) - 时间戳
        - **Value** (int) - 值


        **DataSet**
        - **CPUUtilization** (list) - 见 **MonitorInfo** 模型定义
        - **DiskReadOps** (list) - 见 **MonitorInfo** 模型定义
        - **DiskWriteOps** (list) - 见 **MonitorInfo** 模型定义
        - **IORead** (list) - 见 **MonitorInfo** 模型定义
        - **IOWrite** (list) - 见 **MonitorInfo** 模型定义
        - **MemUtilization** (list) - 见 **MonitorInfo** 模型定义
        - **NICIn** (list) - 见 **MonitorInfo** 模型定义
        - **NICOut** (list) - 见 **MonitorInfo** 模型定义
        - **NetPacketIn** (list) - 见 **MonitorInfo** 模型定义
        - **NetPacketOut** (list) - 见 **MonitorInfo** 模型定义


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUEcIDCVHostDataRequestSchema().dumps(d)

        resp = self.invoke("GetUEcIDCVHostData", d, **kwargs)
        return apis.GetUEcIDCVHostDataResponseSchema().loads(resp)

    def get_u_ec_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcImage - uec2.0

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **ImageType** (str) - 镜像类型：1标准镜像，2行业镜像，3自定义镜像
        - **Limit** (int) - 返回数据长度， 默认20，非负整数
        - **Offset** (int) - 数据偏移量，默认0，非负整数

        **Response**

        - **ImageList** (list) - 见 **ImageInfo** 模型定义
        - **TotalCount** (int) - 镜像总数

        **Response Model**

        **DeployImageInfo**
        - **IdcId** (str) - 机房ID
        - **State** (int) - 镜像状态 1-可用, 2-不可用, 3-获取中, 4-转换中, 5-部署中


        **ImageInfo**
        - **CreateTime** (int) - 镜像创建时间戳
        - **DeployInfoList** (list) - 见 **DeployImageInfo** 模型定义
        - **ImageDesc** (str) - 镜像描述
        - **ImageId** (str) - 镜像ID
        - **ImageName** (str) - 镜像名称
        - **ImageSize** (int) - 镜像大小，单位GB
        - **ImageType** (int) - 镜像类型：1标准镜像，2行业镜像，3自定义镜像
        - **OcType** (str) - 系统类型：unix, windows
        - **State** (int) - 镜像状态：镜像状态 1可用，2不可用


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUEcImageRequestSchema().dumps(d)

        resp = self.invoke("GetUEcImage", d, **kwargs)
        return apis.GetUEcImageResponseSchema().loads(resp)

    def get_u_ec_pod_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcPodPrice - 获得容器组价格

        **Request**

        - **IdcId** (str) - (Required) 机房id
        - **Bandwidth** (int) - 绑定的带宽，默认0，当绑定外网IP时默认1（单位M）
        - **ChargeQuantity** (int) - 月数或年数（默认值：1，当支付类型为按月时，默认值为0）
        - **ChargeType** (int) - 支付类型（2按月，3按年，默认2）
        - **CpuCore** (float) - 容器组总Cpu核心数
        - **ElasticIp** (str) - 是否绑定外网IP（yes：是，no：否，默认：no）
        - **MemSize** (int) - 容器组总内存大小（单位M）
        - **ProductType** (str) - 产品类型（normal：标准型，hf：高性能型，默认：normal）

        **Response**

        - **HolderPrice** (float) - 容器组价格
        - **IpPrice** (float) - IP和带宽价格

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetUEcPodPriceRequestSchema().dumps(d)

        resp = self.invoke("GetUEcPodPrice", d, **kwargs)
        return apis.GetUEcPodPriceResponseSchema().loads(resp)

    def get_u_ec_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcUpgradePrice - 获取虚拟机调整差价

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (str) - (Required) 虚拟机资源ID
        - **CpuCore** (int) - cpu核心数
        - **DiskSize** (int) - 数据盘大小，单位GB
        - **MemSize** (int) - 内存大小，单位GB
        - **NetLimit** (int) - 节点带宽限制，单位Mbs
        - **SysDiskSize** (int) - 系统盘大小，单位GB

        **Response**

        - **Price** (int) - 规格调整差价

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUEcUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("GetUEcUpgradePrice", d, **kwargs)
        return apis.GetUEcUpgradePriceResponseSchema().loads(resp)

    def get_u_ec_v_host_data(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcVHostData - 获取虚拟机监控数据

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (str) - (Required) 节点id
        - **Type** (list) - (Required) 0CPU使用率, 1内存使用率, 2 网卡出流量, 3网卡入流量, 4网卡出包量, 5网卡入包量, 6磁盘读流量, 7磁盘写流量, 8磁盘读次数, 9磁盘写次数
        - **BeginTime** (int) - 查询起始时间
        - **EndTime** (int) - 查询结束时间

        **Response**

        - **Action** (str) - 操作名称
        - **DataSets** (dict) - 见 **DataSet** 模型定义
        - **RetCode** (int) - 返回码

        **Response Model**

        **MonitorInfo**
        - **TimeStamp** (int) - 时间戳
        - **Value** (int) - 值


        **DataSet**
        - **CPUUtilization** (list) - 见 **MonitorInfo** 模型定义
        - **DiskReadOps** (list) - 见 **MonitorInfo** 模型定义
        - **DiskWriteOps** (list) - 见 **MonitorInfo** 模型定义
        - **IORead** (list) - 见 **MonitorInfo** 模型定义
        - **IOWrite** (list) - 见 **MonitorInfo** 模型定义
        - **MemUtilization** (list) - 见 **MonitorInfo** 模型定义
        - **NICIn** (list) - 见 **MonitorInfo** 模型定义
        - **NICOut** (list) - 见 **MonitorInfo** 模型定义
        - **NetPacketIn** (list) - 见 **MonitorInfo** 模型定义
        - **NetPacketOut** (list) - 见 **MonitorInfo** 模型定义


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUEcVHostDataRequestSchema().dumps(d)

        resp = self.invoke("GetUEcVHostData", d, **kwargs)
        return apis.GetUEcVHostDataResponseSchema().loads(resp)

    def get_u_ec_v_host_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUEcVHostPrice - 获取虚拟机价格

        **Request**

        - **IdcId** (str) - (Required) 机房Id
        - **ChargeQuantity** (int) - 月数或者年数，0计费到月底， 默认0
        - **ChargeType** (int) - 付费方式，1按时，2按月，3按年，默认2
        - **CpuCore** (int) - CPU核数
        - **DiskSize** (int) - 数据盘大小，单位GB
        - **IpCount** (int) - 外网IP的数量，默认1
        - **MemSize** (int) - 内存大小，单位GB
        - **NetLimit** (int) - 网络带宽限速，单位Mbs
        - **NodeCount** (int) - 节点数量，默认1
        - **ProductType** (str) - 产品类型：normal（标准型），hf（高频型），默认normal
        - **SysDiskSize** (int) - 系统盘大小，单位GB

        **Response**

        - **IpPrice** (float) - Ip和带宽价格
        - **NodePrice** (float) - 节点价格

        """
        # build request
        d = {}
        req and d.update(req)
        d = apis.GetUEcVHostPriceRequestSchema().dumps(d)

        resp = self.invoke("GetUEcVHostPrice", d, **kwargs)
        return apis.GetUEcVHostPriceResponseSchema().loads(resp)

    def import_u_ec_custom_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ImportUEcCustomImage - 导入自定义镜像

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Format** (str) - 镜像格式，可选RAW、qcow2， 不带镜像ID时必填
        - **IdcId** (list) - 镜像需要导入机房，默认分发到所有机房
        - **ImageDesc** (str) - 镜像描述
        - **ImageId** (str) - 镜像Id，不传参表示新导入镜像，传参表示已有镜像分发到指定机房
        - **ImageName** (str) - 镜像名称，不带镜像ID时必填
        - **OsType** (str) - 操作系统平台，linux、windows(当前版本暂不支持windows)，不带镜像ID时必填
        - **UFileUrl** (str) - UFile镜像文件下载地址，不带镜像ID时必填

        **Response**

        - **ImageId** (str) - 镜像Id

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ImportUEcCustomImageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("ImportUEcCustomImage", d, **kwargs)
        return apis.ImportUEcCustomImageResponseSchema().loads(resp)

    def login_u_ec_docker(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """LoginUEcDocker - 登录容器

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Name** (str) - (Required) 容器名称
        - **ResourceId** (str) - (Required) 容器组资源id

        **Response**

        - **Link** (str) - 登录地址
        - **LinkPort** (int) - 登录端口
        - **SessionId** (str) - 返回的token

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.LoginUEcDockerRequestSchema().dumps(d)

        resp = self.invoke("LoginUEcDocker", d, **kwargs)
        return apis.LoginUEcDockerResponseSchema().loads(resp)

    def modify_u_ec_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUEcBandwidth - 修改节点带宽限制

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NetLimit** (str) - (Required) 节点带宽限制，单位Mbs
        - **NodeId** (str) - (Required) 节点Id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ModifyUEcBandwidthRequestSchema().dumps(d)

        resp = self.invoke("ModifyUEcBandwidth", d, **kwargs)
        return apis.ModifyUEcBandwidthResponseSchema().loads(resp)

    def modify_u_ec_holder_name(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUEcHolderName - 修改容器组名称

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Name** (str) - (Required) 容器组名称
        - **ResourceId** (str) - (Required) 容器组资源id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ModifyUEcHolderNameRequestSchema().dumps(d)

        resp = self.invoke("ModifyUEcHolderName", d, **kwargs)
        return apis.ModifyUEcHolderNameResponseSchema().loads(resp)

    def modify_u_ec_image_name(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyUEcImageName - 修改镜像名称

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **ImageId** (str) - (Required) 镜像ID
        - **ImageName** (str) - (Required) 镜像名称
        - **ImageDesc** (str) - 镜像描述

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ModifyUEcImageNameRequestSchema().dumps(d)

        resp = self.invoke("ModifyUEcImageName", d, **kwargs)
        return apis.ModifyUEcImageNameResponseSchema().loads(resp)

    def poweroff_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """PoweroffUEcVHost - 虚拟机断电

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (list) - (Required) 虚拟机资源ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.PoweroffUEcVHostRequestSchema().dumps(d)

        resp = self.invoke("PoweroffUEcVHost", d, **kwargs)
        return apis.PoweroffUEcVHostResponseSchema().loads(resp)

    def reinstall_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ReinstallUEcVHost - 虚拟机重装系统

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **ImageId** (str) - (Required) 镜像ID
        - **NodeId** (str) - (Required) 虚拟机资源ID
        - **KeepData** (int) - 是否保留数据盘数据， 0-不保留，1-保留，默认为1
        - **Password** (str) - 节点密码
        - **SysDiskSize** (int) - 系统盘大小，单位GB

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.ReinstallUEcVHostRequestSchema().dumps(d)

        resp = self.invoke("ReinstallUEcVHost", d, **kwargs)
        return apis.ReinstallUEcVHostResponseSchema().loads(resp)

    def restart_u_ec_holder(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RestartUEcHolder - 重启容器组

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **ResourceId** (list) - (Required) 容器组资源id，n为0，1，2...

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.RestartUEcHolderRequestSchema().dumps(d)

        resp = self.invoke("RestartUEcHolder", d, **kwargs)
        return apis.RestartUEcHolderResponseSchema().loads(resp)

    def restart_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RestartUEcVHost - 重启虚拟机v2.0

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (list) - (Required) 节点id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.RestartUEcVHostRequestSchema().dumps(d)

        resp = self.invoke("RestartUEcVHost", d, **kwargs)
        return apis.RestartUEcVHostResponseSchema().loads(resp)

    def start_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StartUEcVHost - 启动UEC虚拟机

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (list) - (Required) 虚拟机资源ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.StartUEcVHostRequestSchema().dumps(d)

        resp = self.invoke("StartUEcVHost", d, **kwargs)
        return apis.StartUEcVHostResponseSchema().loads(resp)

    def stop_u_ec_v_host(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StopUEcVHost - 停止UEC虚拟机

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **NodeId** (list) - (Required) 虚拟机资源ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.StopUEcVHostRequestSchema().dumps(d)

        resp = self.invoke("StopUEcVHost", d, **kwargs)
        return apis.StopUEcVHostResponseSchema().loads(resp)

    def un_bind_u_ec_firewall(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UnBindUEcFirewall - 解绑防火墙

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **FirewallId** (str) - (Required) 防火墙Id
        - **ResourceId** (str) - (Required) 节点Id或容器组资源id

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UnBindUEcFirewallRequestSchema().dumps(d)

        resp = self.invoke("UnBindUEcFirewall", d, **kwargs)
        return apis.UnBindUEcFirewallResponseSchema().loads(resp)

    def update_u_ec_firewall(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateUEcFirewall - 更新防火墙信息，新增和删除规则

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **FirewallId** (str) - (Required) 防火墙Id
        - **Rule** (list) - 见 **UpdateUEcFirewallParamRule** 模型定义

        **Response**


        **Request Model**

        **UpdateUEcFirewallParamRule**
        - **Action** (str) - ACCEPT（接受）和DROP（拒绝）
        - **Port** (str) - 端口，范围用"-"符号分隔，如：1-65535
        - **Priority** (str) - 优先级：HIGH（高），MEDIUM（中），LOW（低）
        - **ProtocolType** (str) - 协议，可选值：TCP，UDP，ICMP
        - **Remark** (str) - 备注
        - **SrcIp** (str) - 源ip


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UpdateUEcFirewallRequestSchema().dumps(d)

        resp = self.invoke("UpdateUEcFirewall", d, **kwargs)
        return apis.UpdateUEcFirewallResponseSchema().loads(resp)

    def update_u_ec_firewall_attribute(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateUEcFirewallAttribute - 更新防火墙名称及描述

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **FirewallId** (str) - (Required) 防火墙Id
        - **Name** (str) - 防火墙名称
        - **Remark** (str) - 描述

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UpdateUEcFirewallAttributeRequestSchema().dumps(d)

        resp = self.invoke("UpdateUEcFirewallAttribute", d, **kwargs)
        return apis.UpdateUEcFirewallAttributeResponseSchema().loads(resp)

    def update_u_ec_subnet(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateUEcSubnet - 更新子网信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **SubnetId** (str) - (Required) 子网ID
        - **Comment** (str) - 备注
        - **SubnetName** (str) - 子网名称

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UpdateUEcSubnetRequestSchema().dumps(d)

        resp = self.invoke("UpdateUEcSubnet", d, **kwargs)
        return apis.UpdateUEcSubnetResponseSchema().loads(resp)
