""" Code is generated by ucloud-model, DO NOT EDIT IT. """


from ucloud.core.typesystem import schema, fields
from ucloud.services.udb.schemas import models

""" UDB API Schema
"""


"""
API: BackupUDBInstance

备份UDB实例
"""


class BackupUDBInstanceRequestSchema(schema.RequestSchema):
    """BackupUDBInstance - 备份UDB实例"""

    fields = {
        "BackupMethod": fields.Str(required=False, dump_to="BackupMethod"),
        "BackupName": fields.Str(required=True, dump_to="BackupName"),
        "Blacklist": fields.Str(required=False, dump_to="Blacklist"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ForceBackup": fields.Bool(required=False, dump_to="ForceBackup"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UseBlacklist": fields.Bool(required=False, dump_to="UseBlacklist"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class BackupUDBInstanceResponseSchema(schema.ResponseSchema):
    """BackupUDBInstance - 备份UDB实例"""

    fields = {}


"""
API: BackupUDBInstanceBinlog

备份UDB指定时间段的binlog列表
"""


class BackupUDBInstanceBinlogRequestSchema(schema.RequestSchema):
    """BackupUDBInstanceBinlog - 备份UDB指定时间段的binlog列表"""

    fields = {
        "BackupFile": fields.Str(required=True, dump_to="BackupFile"),
        "BackupName": fields.Str(required=False, dump_to="BackupName"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class BackupUDBInstanceBinlogResponseSchema(schema.ResponseSchema):
    """BackupUDBInstanceBinlog - 备份UDB指定时间段的binlog列表"""

    fields = {}


"""
API: BackupUDBInstanceErrorLog

备份UDB指定时间段的errorlog
"""


class BackupUDBInstanceErrorLogRequestSchema(schema.RequestSchema):
    """BackupUDBInstanceErrorLog - 备份UDB指定时间段的errorlog"""

    fields = {
        "BackupName": fields.Str(required=True, dump_to="BackupName"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class BackupUDBInstanceErrorLogResponseSchema(schema.ResponseSchema):
    """BackupUDBInstanceErrorLog - 备份UDB指定时间段的errorlog"""

    fields = {}


"""
API: BackupUDBInstanceSlowLog

备份UDB指定时间段的slowlog分析结果
"""


class BackupUDBInstanceSlowLogRequestSchema(schema.RequestSchema):
    """BackupUDBInstanceSlowLog - 备份UDB指定时间段的slowlog分析结果"""

    fields = {
        "BackupName": fields.Str(required=True, dump_to="BackupName"),
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class BackupUDBInstanceSlowLogResponseSchema(schema.ResponseSchema):
    """BackupUDBInstanceSlowLog - 备份UDB指定时间段的slowlog分析结果"""

    fields = {}


"""
API: ChangeUDBParamGroup

修改配置文件
"""


class ChangeUDBParamGroupRequestSchema(schema.RequestSchema):
    """ChangeUDBParamGroup - 修改配置文件"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ChangeUDBParamGroupResponseSchema(schema.ResponseSchema):
    """ChangeUDBParamGroup - 修改配置文件"""

    fields = {}


"""
API: CheckRecoverUDBInstance

核查db是否可以使用回档功能
"""


class CheckRecoverUDBInstanceRequestSchema(schema.RequestSchema):
    """CheckRecoverUDBInstance - 核查db是否可以使用回档功能"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SrcDBId": fields.Str(required=True, dump_to="SrcDBId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class CheckRecoverUDBInstanceResponseSchema(schema.ResponseSchema):
    """CheckRecoverUDBInstance - 核查db是否可以使用回档功能"""

    fields = {
        "LastestTime": fields.Int(required=False, load_from="LastestTime"),
    }


"""
API: CheckUDBInstanceToHAAllowance

核查db是否可以升级为高可用
"""


class CheckUDBInstanceToHAAllowanceRequestSchema(schema.RequestSchema):
    """CheckUDBInstanceToHAAllowance - 核查db是否可以升级为高可用"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class CheckUDBInstanceToHAAllowanceResponseSchema(schema.ResponseSchema):
    """CheckUDBInstanceToHAAllowance - 核查db是否可以升级为高可用"""

    fields = {
        "Allowance": fields.Str(required=False, load_from="Allowance"),
    }


"""
API: ClearUDBLog

清除UDB实例的log
"""


class ClearUDBLogRequestSchema(schema.RequestSchema):
    """ClearUDBLog - 清除UDB实例的log"""

    fields = {
        "BeforeTime": fields.Int(required=False, dump_to="BeforeTime"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "LogType": fields.Int(required=True, dump_to="LogType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ClearUDBLogResponseSchema(schema.ResponseSchema):
    """ClearUDBLog - 清除UDB实例的log"""

    fields = {}


"""
API: CreateMongoDBReplicaSet

一键创建DB副本集
"""


class CreateMongoDBReplicaSetRequestSchema(schema.RequestSchema):
    """CreateMongoDBReplicaSet - 一键创建DB副本集"""

    fields = {
        "AdminPassword": fields.Str(required=True, dump_to="AdminPassword"),
        "AdminUser": fields.Str(required=False, dump_to="AdminUser"),
        "BackupCount": fields.Int(required=False, dump_to="BackupCount"),
        "BackupDuration": fields.Int(required=False, dump_to="BackupDuration"),
        "BackupTime": fields.Int(required=False, dump_to="BackupTime"),
        "CPU": fields.Int(required=False, dump_to="CPU"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ClusterId": fields.Str(required=False, dump_to="ClusterId"),
        "CouponId": fields.List(fields.Str()),
        "DBTypeId": fields.Str(required=True, dump_to="DBTypeId"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "MemoryLimit": fields.Int(required=True, dump_to="MemoryLimit"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ParamGroupId": fields.Int(required=True, dump_to="ParamGroupId"),
        "Port": fields.Int(required=True, dump_to="Port"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSDType": fields.Str(required=False, dump_to="SSDType"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateMongoDBReplicaSetResponseSchema(schema.ResponseSchema):
    """CreateMongoDBReplicaSet - 一键创建DB副本集"""

    fields = {
        "Action": fields.Str(required=True, load_from="Action"),
        "DBIds": fields.List(fields.Str(), required=False, load_from="DBIds"),
        "RetCode": fields.Int(required=True, load_from="RetCode"),
    }


"""
API: CreateUDBInstance

创建UDB实例（包括创建mysql master节点、mongodb primary/configsvr节点和从备份恢复实例）
"""


class CreateUDBInstanceRequestSchema(schema.RequestSchema):
    """CreateUDBInstance - 创建UDB实例（包括创建mysql master节点、mongodb primary/configsvr节点和从备份恢复实例）"""

    fields = {
        "AdminPassword": fields.Str(required=True, dump_to="AdminPassword"),
        "AdminUser": fields.Str(required=False, dump_to="AdminUser"),
        "BackupCount": fields.Int(required=False, dump_to="BackupCount"),
        "BackupDuration": fields.Int(required=False, dump_to="BackupDuration"),
        "BackupId": fields.Int(required=False, dump_to="BackupId"),
        "BackupTime": fields.Int(required=False, dump_to="BackupTime"),
        "BackupZone": fields.Str(required=False, dump_to="BackupZone"),
        "CPU": fields.Int(required=False, dump_to="CPU"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ClusterRole": fields.Str(required=False, dump_to="ClusterRole"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "DBTypeId": fields.Str(required=True, dump_to="DBTypeId"),
        "DisableSemisync": fields.Bool(
            required=False, dump_to="DisableSemisync"
        ),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "EnableIpV6": fields.Bool(required=False, dump_to="EnableIpV6"),
        "HAArch": fields.Str(required=False, dump_to="HAArch"),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "InstanceType": fields.Str(
            required=False, dump_to="InstanceType"
        ),  # Deprecated, will be removed at 1.0
        "MemoryLimit": fields.Int(required=True, dump_to="MemoryLimit"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ParamGroupId": fields.Int(required=True, dump_to="ParamGroupId"),
        "Port": fields.Int(required=True, dump_to="Port"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSDType": fields.Str(required=False, dump_to="SSDType"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UDBCId": fields.Str(required=False, dump_to="UDBCId"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUDBInstanceResponseSchema(schema.ResponseSchema):
    """CreateUDBInstance - 创建UDB实例（包括创建mysql master节点、mongodb primary/configsvr节点和从备份恢复实例）"""

    fields = {
        "DBId": fields.Str(required=False, load_from="DBId"),
    }


"""
API: CreateUDBInstanceByRecovery

创建db，将新创建的db恢复到指定db某个指定时间点
"""


class CreateUDBInstanceByRecoveryRequestSchema(schema.RequestSchema):
    """CreateUDBInstanceByRecovery - 创建db，将新创建的db恢复到指定db某个指定时间点"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "EnableIpV6": fields.Bool(required=False, dump_to="EnableIpV6"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "RecoveryTime": fields.Int(required=True, dump_to="RecoveryTime"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SrcDBId": fields.Str(required=True, dump_to="SrcDBId"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "UDBCId": fields.Str(required=False, dump_to="UDBCId"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class CreateUDBInstanceByRecoveryResponseSchema(schema.ResponseSchema):
    """CreateUDBInstanceByRecovery - 创建db，将新创建的db恢复到指定db某个指定时间点"""

    fields = {
        "DBId": fields.Str(required=False, load_from="DBId"),
    }


"""
API: CreateUDBParamGroup

从已有配置文件创建新配置文件
"""


class CreateUDBParamGroupRequestSchema(schema.RequestSchema):
    """CreateUDBParamGroup - 从已有配置文件创建新配置文件"""

    fields = {
        "DBTypeId": fields.Str(required=True, dump_to="DBTypeId"),
        "Description": fields.Str(required=True, dump_to="Description"),
        "GroupName": fields.Str(required=True, dump_to="GroupName"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "SrcGroupId": fields.Int(required=True, dump_to="SrcGroupId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUDBParamGroupResponseSchema(schema.ResponseSchema):
    """CreateUDBParamGroup - 从已有配置文件创建新配置文件"""

    fields = {
        "GroupId": fields.Int(required=False, load_from="GroupId"),
    }


"""
API: CreateUDBReplicationInstance

创建MongoDB的副本节点（包括仲裁）
"""


class CreateUDBReplicationInstanceRequestSchema(schema.RequestSchema):
    """CreateUDBReplicationInstance - 创建MongoDB的副本节点（包括仲裁）"""

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "IsArbiter": fields.Bool(required=False, dump_to="IsArbiter"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SrcId": fields.Str(required=True, dump_to="SrcId"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class CreateUDBReplicationInstanceResponseSchema(schema.ResponseSchema):
    """CreateUDBReplicationInstance - 创建MongoDB的副本节点（包括仲裁）"""

    fields = {
        "DBId": fields.Str(required=False, load_from="DBId"),
    }


"""
API: CreateUDBRouteInstance

创建mongos实例
"""


class CreateUDBRouteInstanceRequestSchema(schema.RequestSchema):
    """CreateUDBRouteInstance - 创建mongos实例"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ConfigsvrId": fields.List(fields.Str()),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "DBTypeId": fields.Str(required=True, dump_to="DBTypeId"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "MemoryLimit": fields.Int(required=True, dump_to="MemoryLimit"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ParamGroupId": fields.Int(required=True, dump_to="ParamGroupId"),
        "Port": fields.Int(required=True, dump_to="Port"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class CreateUDBRouteInstanceResponseSchema(schema.ResponseSchema):
    """CreateUDBRouteInstance - 创建mongos实例"""

    fields = {
        "DBId": fields.Str(required=False, load_from="DBId"),
    }


"""
API: CreateUDBSlave

创建UDB实例的slave
"""


class CreateUDBSlaveRequestSchema(schema.RequestSchema):
    """CreateUDBSlave - 创建UDB实例的slave"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "DiskSpace": fields.Int(required=False, dump_to="DiskSpace"),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "IsLock": fields.Bool(required=False, dump_to="IsLock"),
        "MemoryLimit": fields.Int(required=False, dump_to="MemoryLimit"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ParamGroupId": fields.Int(required=False, dump_to="ParamGroupId"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSDType": fields.Str(required=False, dump_to="SSDType"),
        "SrcId": fields.Str(required=True, dump_to="SrcId"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class CreateUDBSlaveResponseSchema(schema.ResponseSchema):
    """CreateUDBSlave - 创建UDB实例的slave"""

    fields = {
        "DBId": fields.Str(required=False, load_from="DBId"),
    }


"""
API: DeleteUDBBackup


"""


class DeleteUDBBackupRequestSchema(schema.RequestSchema):
    """DeleteUDBBackup -"""

    fields = {
        "BackupId": fields.Int(required=True, dump_to="BackupId"),
        "BackupZone": fields.Str(required=False, dump_to="BackupZone"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteUDBBackupResponseSchema(schema.ResponseSchema):
    """DeleteUDBBackup -"""

    fields = {}


"""
API: DeleteUDBInstance

删除UDB实例
"""


class DeleteUDBInstanceRequestSchema(schema.RequestSchema):
    """DeleteUDBInstance - 删除UDB实例"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDBCId": fields.Str(required=False, dump_to="UDBCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DeleteUDBInstanceResponseSchema(schema.ResponseSchema):
    """DeleteUDBInstance - 删除UDB实例"""

    fields = {}


"""
API: DeleteUDBLogPackage

删除UDB日志包
"""


class DeleteUDBLogPackageRequestSchema(schema.RequestSchema):
    """DeleteUDBLogPackage - 删除UDB日志包"""

    fields = {
        "BackupId": fields.Int(required=True, dump_to="BackupId"),
        "BackupZone": fields.Str(required=False, dump_to="BackupZone"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteUDBLogPackageResponseSchema(schema.ResponseSchema):
    """DeleteUDBLogPackage - 删除UDB日志包"""

    fields = {}


"""
API: DeleteUDBParamGroup

删除配置参数组
"""


class DeleteUDBParamGroupRequestSchema(schema.RequestSchema):
    """DeleteUDBParamGroup - 删除配置参数组"""

    fields = {
        "GroupId": fields.Int(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteUDBParamGroupResponseSchema(schema.ResponseSchema):
    """DeleteUDBParamGroup - 删除配置参数组"""

    fields = {}


"""
API: DescribeUDBBackup

列表UDB实例备份信息
"""


class DescribeUDBBackupRequestSchema(schema.RequestSchema):
    """DescribeUDBBackup - 列表UDB实例备份信息"""

    fields = {
        "BackupId": fields.Int(
            required=False, dump_to="BackupId"
        ),  # Deprecated, will be removed at 1.0
        "BackupType": fields.Int(required=False, dump_to="BackupType"),
        "BeginTime": fields.Int(required=False, dump_to="BeginTime"),
        "ClassType": fields.Str(
            required=False, dump_to="ClassType"
        ),  # Deprecated, will be removed at 1.0
        "DBId": fields.Str(required=False, dump_to="DBId"),
        "EndTime": fields.Int(required=False, dump_to="EndTime"),
        "Limit": fields.Int(required=True, dump_to="Limit"),
        "Offset": fields.Int(required=True, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBBackupResponseSchema(schema.ResponseSchema):
    """DescribeUDBBackup - 列表UDB实例备份信息"""

    fields = {
        "DataSet": fields.List(
            models.UDBBackupSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUDBBackupBlacklist

获取UDB实例的备份黑名单
"""


class DescribeUDBBackupBlacklistRequestSchema(schema.RequestSchema):
    """DescribeUDBBackupBlacklist - 获取UDB实例的备份黑名单"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBBackupBlacklistResponseSchema(schema.ResponseSchema):
    """DescribeUDBBackupBlacklist - 获取UDB实例的备份黑名单"""

    fields = {
        "Blacklist": fields.Str(required=False, load_from="Blacklist"),
    }


"""
API: DescribeUDBBinlogBackupURL

获取UDB的Binlog备份地址
"""


class DescribeUDBBinlogBackupURLRequestSchema(schema.RequestSchema):
    """DescribeUDBBinlogBackupURL - 获取UDB的Binlog备份地址"""

    fields = {
        "BackupId": fields.Int(required=True, dump_to="BackupId"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBBinlogBackupURLResponseSchema(schema.ResponseSchema):
    """DescribeUDBBinlogBackupURL - 获取UDB的Binlog备份地址"""

    fields = {
        "BackupPath": fields.Str(required=False, load_from="BackupPath"),
        "InnerBackupPath": fields.Str(
            required=False, load_from="InnerBackupPath"
        ),
    }


"""
API: DescribeUDBInstance

获取UDB实例信息，支持两类操作：（1）指定DBId用于获取该db的信息；（2）指定ClassType、Offset、Limit用于列表操作，查询某一个类型db。
"""


class DescribeUDBInstanceRequestSchema(schema.RequestSchema):
    """DescribeUDBInstance - 获取UDB实例信息，支持两类操作：（1）指定DBId用于获取该db的信息；（2）指定ClassType、Offset、Limit用于列表操作，查询某一个类型db。"""

    fields = {
        "ClassType": fields.Str(required=False, dump_to="ClassType"),
        "DBId": fields.Str(required=False, dump_to="DBId"),
        "IncludeSlaves": fields.Bool(required=False, dump_to="IncludeSlaves"),
        "IsInUDBC": fields.Bool(required=False, dump_to="IsInUDBC"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDBCId": fields.Str(required=False, dump_to="UDBCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBInstanceResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstance - 获取UDB实例信息，支持两类操作：（1）指定DBId用于获取该db的信息；（2）指定ClassType、Offset、Limit用于列表操作，查询某一个类型db。"""

    fields = {
        "DataSet": fields.List(
            models.UDBInstanceSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUDBInstanceBackupState

获取UDB实例备份状态
"""


class DescribeUDBInstanceBackupStateRequestSchema(schema.RequestSchema):
    """DescribeUDBInstanceBackupState - 获取UDB实例备份状态"""

    fields = {
        "BackupId": fields.Int(required=True, dump_to="BackupId"),
        "BackupZone": fields.Str(required=False, dump_to="BackupZone"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDBInstanceBackupStateResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstanceBackupState - 获取UDB实例备份状态"""

    fields = {
        "BackupEndTime": fields.Int(required=False, load_from="BackupEndTime"),
        "BackupSize": fields.Int(required=False, load_from="BackupSize"),
        "State": fields.Str(required=False, load_from="State"),
    }


"""
API: DescribeUDBInstanceBackupURL

获取UDB备份下载地址
"""


class DescribeUDBInstanceBackupURLRequestSchema(schema.RequestSchema):
    """DescribeUDBInstanceBackupURL - 获取UDB备份下载地址"""

    fields = {
        "BackupId": fields.Int(required=True, dump_to="BackupId"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBInstanceBackupURLResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstanceBackupURL - 获取UDB备份下载地址"""

    fields = {
        "BackupPath": fields.Str(required=False, load_from="BackupPath"),
        "InnerBackupPath": fields.Str(
            required=False, load_from="InnerBackupPath"
        ),
    }


"""
API: DescribeUDBInstanceBinlog

获取UDB指定时间段的binlog列表
"""


class DescribeUDBInstanceBinlogRequestSchema(schema.RequestSchema):
    """DescribeUDBInstanceBinlog - 获取UDB指定时间段的binlog列表"""

    fields = {
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBInstanceBinlogResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstanceBinlog - 获取UDB指定时间段的binlog列表"""

    fields = {
        "DataSet": fields.List(
            models.UDBInstanceBinlogSetSchema(),
            required=False,
            load_from="DataSet",
        ),
    }


"""
API: DescribeUDBInstanceBinlogBackupState

获取udb实例备份状态
"""


class DescribeUDBInstanceBinlogBackupStateRequestSchema(schema.RequestSchema):
    """DescribeUDBInstanceBinlogBackupState - 获取udb实例备份状态"""

    fields = {
        "BackupId": fields.Int(required=True, dump_to="BackupId"),
        "BackupZone": fields.Str(required=False, dump_to="BackupZone"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDBInstanceBinlogBackupStateResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstanceBinlogBackupState - 获取udb实例备份状态"""

    fields = {
        "BackupSize": fields.Int(
            required=False, load_from="BackupSize"
        ),  # Deprecated, will be removed at 1.0
        "State": fields.Str(required=False, load_from="State"),
    }


"""
API: DescribeUDBInstanceLog

查询某一段时间内UDB的错误日志或慢查询日志
"""


class DescribeUDBInstanceLogRequestSchema(schema.RequestSchema):
    """DescribeUDBInstanceLog - 查询某一段时间内UDB的错误日志或慢查询日志"""

    fields = {
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "LogType": fields.Str(required=True, dump_to="LogType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBInstanceLogResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstanceLog - 查询某一段时间内UDB的错误日志或慢查询日志"""

    fields = {
        "Log": fields.Str(required=False, load_from="Log"),
        "NextTime": fields.Str(required=False, load_from="NextTime"),
    }


"""
API: DescribeUDBInstancePrice

获取UDB实例价格信息
"""


class DescribeUDBInstancePriceRequestSchema(schema.RequestSchema):
    """DescribeUDBInstancePrice - 获取UDB实例价格信息"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "Count": fields.Int(required=False, dump_to="Count"),
        "DBTypeId": fields.Str(required=True, dump_to="DBTypeId"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "MemoryLimit": fields.Int(required=True, dump_to="MemoryLimit"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSDType": fields.Str(required=False, dump_to="SSDType"),
        "UseSSD": fields.Str(required=False, dump_to="UseSSD"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDBInstancePriceResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstancePrice - 获取UDB实例价格信息"""

    fields = {
        "DataSet": fields.List(
            models.UDBInstancePriceSetSchema(),
            required=False,
            load_from="DataSet",
        ),
    }


"""
API: DescribeUDBInstanceState

获取UDB实例状态
"""


class DescribeUDBInstanceStateRequestSchema(schema.RequestSchema):
    """DescribeUDBInstanceState - 获取UDB实例状态"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBInstanceStateResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstanceState - 获取UDB实例状态"""

    fields = {
        "State": fields.Str(required=False, load_from="State"),
    }


"""
API: DescribeUDBInstanceUpgradePrice

获取UDB实例升降级价格信息
"""


class DescribeUDBInstanceUpgradePriceRequestSchema(schema.RequestSchema):
    """DescribeUDBInstanceUpgradePrice - 获取UDB实例升降级价格信息"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "MemoryLimit": fields.Int(required=True, dump_to="MemoryLimit"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSDType": fields.Str(required=False, dump_to="SSDType"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBInstanceUpgradePriceResponseSchema(schema.ResponseSchema):
    """DescribeUDBInstanceUpgradePrice - 获取UDB实例升降级价格信息"""

    fields = {
        "Price": fields.Int(required=False, load_from="Price"),
    }


"""
API: DescribeUDBLogBackupURL

获取UDB的slowlog备份地址
"""


class DescribeUDBLogBackupURLRequestSchema(schema.RequestSchema):
    """DescribeUDBLogBackupURL - 获取UDB的slowlog备份地址"""

    fields = {
        "BackupId": fields.Int(required=True, dump_to="BackupId"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBLogBackupURLResponseSchema(schema.ResponseSchema):
    """DescribeUDBLogBackupURL - 获取UDB的slowlog备份地址"""

    fields = {
        "BackupPath": fields.Str(required=False, load_from="BackupPath"),
        "UsernetPath": fields.Str(required=False, load_from="UsernetPath"),
    }


"""
API: DescribeUDBLogPackage

列表UDB实例binlog或slowlog或errorlog备份信息
"""


class DescribeUDBLogPackageRequestSchema(schema.RequestSchema):
    """DescribeUDBLogPackage - 列表UDB实例binlog或slowlog或errorlog备份信息"""

    fields = {
        "BeginTime": fields.Int(required=False, dump_to="BeginTime"),
        "DBId": fields.Str(required=False, dump_to="DBId"),
        "EndTime": fields.Int(required=False, dump_to="EndTime"),
        "Limit": fields.Int(required=True, dump_to="Limit"),
        "Offset": fields.Int(required=True, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Type": fields.Int(required=False, dump_to="Type"),
        "Types": fields.List(fields.Int()),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBLogPackageResponseSchema(schema.ResponseSchema):
    """DescribeUDBLogPackage - 列表UDB实例binlog或slowlog或errorlog备份信息"""

    fields = {
        "DataSet": fields.List(
            models.LogPackageDataSetSchema(),
            required=False,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUDBParamGroup

获取参数组详细参数信息
"""


class DescribeUDBParamGroupRequestSchema(schema.RequestSchema):
    """DescribeUDBParamGroup - 获取参数组详细参数信息"""

    fields = {
        "ClassType": fields.Str(required=False, dump_to="ClassType"),
        "GroupId": fields.Int(required=False, dump_to="GroupId"),
        "IsInUDBC": fields.Bool(required=False, dump_to="IsInUDBC"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUDBParamGroupResponseSchema(schema.ResponseSchema):
    """DescribeUDBParamGroup - 获取参数组详细参数信息"""

    fields = {
        "DataSet": fields.List(
            models.UDBParamGroupSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUDBSplittingInfo

描述读写分离功能的详细信息
"""


class DescribeUDBSplittingInfoRequestSchema(schema.RequestSchema):
    """DescribeUDBSplittingInfo - 描述读写分离功能的详细信息"""

    fields = {
        "MasterDBId": fields.Str(required=True, dump_to="MasterDBId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDBSplittingInfoResponseSchema(schema.ResponseSchema):
    """DescribeUDBSplittingInfo - 描述读写分离功能的详细信息"""

    fields = {
        "DBTypeId": fields.Str(required=False, load_from="DBTypeId"),
        "DataSet": fields.List(
            models.UDBRWSplittingSetSchema(),
            required=False,
            load_from="DataSet",
        ),
        "DelayThreshold": fields.Int(
            required=False, load_from="DelayThreshold"
        ),
        "MasterDBId": fields.Str(required=False, load_from="MasterDBId"),
        "Port": fields.Int(required=False, load_from="Port"),
        "RWIP": fields.Str(required=False, load_from="RWIP"),
        "RWState": fields.Str(required=False, load_from="RWState"),
        "ReadModel": fields.Str(required=False, load_from="ReadModel"),
        "Zone": fields.Str(required=False, load_from="Zone"),
    }


"""
API: DescribeUDBType

获取UDB支持的类型信息
"""


class DescribeUDBTypeRequestSchema(schema.RequestSchema):
    """DescribeUDBType - 获取UDB支持的类型信息"""

    fields = {
        "BackupZone": fields.Str(required=False, dump_to="BackupZone"),
        "CompatibleWithDBType": fields.Str(
            required=False, dump_to="CompatibleWithDBType"
        ),
        "DBClusterType": fields.Str(required=False, dump_to="DBClusterType"),
        "DiskType": fields.Str(required=False, dump_to="DiskType"),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDBTypeResponseSchema(schema.ResponseSchema):
    """DescribeUDBType - 获取UDB支持的类型信息"""

    fields = {
        "DataSet": fields.List(
            models.UDBTypeSetSchema(), required=False, load_from="DataSet"
        ),
    }


"""
API: DisableUDBRWSplitting

关闭DB的读写分离功能
"""


class DisableUDBRWSplittingRequestSchema(schema.RequestSchema):
    """DisableUDBRWSplitting - 关闭DB的读写分离功能"""

    fields = {
        "MasterDBId": fields.Str(required=True, dump_to="MasterDBId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DisableUDBRWSplittingResponseSchema(schema.ResponseSchema):
    """DisableUDBRWSplitting - 关闭DB的读写分离功能"""

    fields = {}


"""
API: EditUDBBackupBlacklist

编辑UDB实例的备份黑名单
"""


class EditUDBBackupBlacklistRequestSchema(schema.RequestSchema):
    """EditUDBBackupBlacklist - 编辑UDB实例的备份黑名单"""

    fields = {
        "Blacklist": fields.Str(required=True, dump_to="Blacklist"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class EditUDBBackupBlacklistResponseSchema(schema.ResponseSchema):
    """EditUDBBackupBlacklist - 编辑UDB实例的备份黑名单"""

    fields = {}


"""
API: EnableUDBRWSplitting

开启DB的读写分离功能
"""


class EnableUDBRWSplittingRequestSchema(schema.RequestSchema):
    """EnableUDBRWSplitting - 开启DB的读写分离功能"""

    fields = {
        "BackupZone": fields.Str(required=False, dump_to="BackupZone"),
        "MasterDBId": fields.Str(required=True, dump_to="MasterDBId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class EnableUDBRWSplittingResponseSchema(schema.ResponseSchema):
    """EnableUDBRWSplitting - 开启DB的读写分离功能"""

    fields = {
        "MasterDBId": fields.Str(required=False, load_from="MasterDBId"),
        "RWIp": fields.Str(required=False, load_from="RWIp"),
    }


"""
API: ExtractUDBParamGroup

获取配置文件内容
"""


class ExtractUDBParamGroupRequestSchema(schema.RequestSchema):
    """ExtractUDBParamGroup - 获取配置文件内容"""

    fields = {
        "GroupId": fields.Int(required=True, dump_to="GroupId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ExtractUDBParamGroupResponseSchema(schema.ResponseSchema):
    """ExtractUDBParamGroup - 获取配置文件内容"""

    fields = {
        "Content": fields.Str(required=True, load_from="Content"),
    }


"""
API: FetchUDBInstanceEarliestRecoverTime

获取UDB最早可回档的时间点
"""


class FetchUDBInstanceEarliestRecoverTimeRequestSchema(schema.RequestSchema):
    """FetchUDBInstanceEarliestRecoverTime - 获取UDB最早可回档的时间点"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class FetchUDBInstanceEarliestRecoverTimeResponseSchema(schema.ResponseSchema):
    """FetchUDBInstanceEarliestRecoverTime - 获取UDB最早可回档的时间点"""

    fields = {
        "EarliestTime": fields.Int(required=False, load_from="EarliestTime"),
    }


"""
API: GetUDBClientConnNum

输入一个DBID，能够获取客户端来源IP以及对应的连接数
"""


class GetUDBClientConnNumRequestSchema(schema.RequestSchema):
    """GetUDBClientConnNum - 输入一个DBID，能够获取客户端来源IP以及对应的连接数"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetUDBClientConnNumResponseSchema(schema.ResponseSchema):
    """GetUDBClientConnNum - 输入一个DBID，能够获取客户端来源IP以及对应的连接数"""

    fields = {
        "DataSet": fields.List(
            models.ConnNumMapSchema(), required=True, load_from="DataSet"
        ),
    }


"""
API: ModifyUDBInstanceName

重命名UDB实例
"""


class ModifyUDBInstanceNameRequestSchema(schema.RequestSchema):
    """ModifyUDBInstanceName - 重命名UDB实例"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ModifyUDBInstanceNameResponseSchema(schema.ResponseSchema):
    """ModifyUDBInstanceName - 重命名UDB实例"""

    fields = {}


"""
API: ModifyUDBInstancePassword

修改DB实例的管理员密码
"""


class ModifyUDBInstancePasswordRequestSchema(schema.RequestSchema):
    """ModifyUDBInstancePassword - 修改DB实例的管理员密码"""

    fields = {
        "AccountName": fields.Str(required=False, dump_to="AccountName"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "Password": fields.Str(required=True, dump_to="Password"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ModifyUDBInstancePasswordResponseSchema(schema.ResponseSchema):
    """ModifyUDBInstancePassword - 修改DB实例的管理员密码"""

    fields = {}


"""
API: PromoteUDBInstanceToHA

普通db升级为高可用(只针对mysql5.5及以上版本SSD机型的实例)  ，对于NVMe机型的单点升级高可用，虽然也能使用该操作再加上SwitchUDBInstanceToHA，但是更建议直接调用新的API接口（UpgradeUDBInstanceToHA）
"""


class PromoteUDBInstanceToHARequestSchema(schema.RequestSchema):
    """PromoteUDBInstanceToHA - 普通db升级为高可用(只针对mysql5.5及以上版本SSD机型的实例)  ，对于NVMe机型的单点升级高可用，虽然也能使用该操作再加上SwitchUDBInstanceToHA，但是更建议直接调用新的API接口（UpgradeUDBInstanceToHA）"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class PromoteUDBInstanceToHAResponseSchema(schema.ResponseSchema):
    """PromoteUDBInstanceToHA - 普通db升级为高可用(只针对mysql5.5及以上版本SSD机型的实例)  ，对于NVMe机型的单点升级高可用，虽然也能使用该操作再加上SwitchUDBInstanceToHA，但是更建议直接调用新的API接口（UpgradeUDBInstanceToHA）"""

    fields = {}


"""
API: PromoteUDBSlave

从库提升为独立库
"""


class PromoteUDBSlaveRequestSchema(schema.RequestSchema):
    """PromoteUDBSlave - 从库提升为独立库"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "IsForce": fields.Bool(required=False, dump_to="IsForce"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class PromoteUDBSlaveResponseSchema(schema.ResponseSchema):
    """PromoteUDBSlave - 从库提升为独立库"""

    fields = {}


"""
API: ResizeUDBInstance

修改（升级和降级）UDB实例的配置，包括内存和磁盘的配置，对于内存升级无需关闭实例，其他场景需要事先关闭实例。两套参数可以配置升降机：1.配置UseSSD和SSDType  2.配置InstanceType，不需要配置InstanceMode。这两套第二套参数的优先级更高
"""


class ResizeUDBInstanceRequestSchema(schema.RequestSchema):
    """ResizeUDBInstance - 修改（升级和降级）UDB实例的配置，包括内存和磁盘的配置，对于内存升级无需关闭实例，其他场景需要事先关闭实例。两套参数可以配置升降机：1.配置UseSSD和SSDType  2.配置InstanceType，不需要配置InstanceMode。这两套第二套参数的优先级更高"""

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "MemoryLimit": fields.Int(required=True, dump_to="MemoryLimit"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSDType": fields.Str(required=False, dump_to="SSDType"),
        "StartAfterUpgrade": fields.Bool(
            required=False, dump_to="StartAfterUpgrade"
        ),
        "UDBCId": fields.Str(required=False, dump_to="UDBCId"),
        "UseSSD": fields.Bool(required=False, dump_to="UseSSD"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ResizeUDBInstanceResponseSchema(schema.ResponseSchema):
    """ResizeUDBInstance - 修改（升级和降级）UDB实例的配置，包括内存和磁盘的配置，对于内存升级无需关闭实例，其他场景需要事先关闭实例。两套参数可以配置升降机：1.配置UseSSD和SSDType  2.配置InstanceType，不需要配置InstanceMode。这两套第二套参数的优先级更高"""

    fields = {}


"""
API: RestartRWSplitting

读写分离中间件重启，对应docker重启，但是ip不变
"""


class RestartRWSplittingRequestSchema(schema.RequestSchema):
    """RestartRWSplitting - 读写分离中间件重启，对应docker重启，但是ip不变"""

    fields = {
        "MasterDBId": fields.Str(required=True, dump_to="MasterDBId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RestartRWSplittingResponseSchema(schema.ResponseSchema):
    """RestartRWSplitting - 读写分离中间件重启，对应docker重启，但是ip不变"""

    fields = {}


"""
API: RestartUDBInstance

重启UDB实例
"""


class RestartUDBInstanceRequestSchema(schema.RequestSchema):
    """RestartUDBInstance - 重启UDB实例"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class RestartUDBInstanceResponseSchema(schema.ResponseSchema):
    """RestartUDBInstance - 重启UDB实例"""

    fields = {}


"""
API: SetUDBRWSplitting

设置读写分离的模式
"""


class SetUDBRWSplittingRequestSchema(schema.RequestSchema):
    """SetUDBRWSplitting - 设置读写分离的模式"""

    fields = {
        "DBIds": fields.List(fields.Str()),
        "DelayThreshold": fields.Int(required=False, dump_to="DelayThreshold"),
        "MasterDBId": fields.Str(required=True, dump_to="MasterDBId"),
        "ReadModel": fields.Str(required=True, dump_to="ReadModel"),
        "ReadPercents": fields.List(fields.Str()),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class SetUDBRWSplittingResponseSchema(schema.ResponseSchema):
    """SetUDBRWSplitting - 设置读写分离的模式"""

    fields = {}


"""
API: StartUDBInstance

启动UDB实例
"""


class StartUDBInstanceRequestSchema(schema.RequestSchema):
    """StartUDBInstance - 启动UDB实例"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class StartUDBInstanceResponseSchema(schema.ResponseSchema):
    """StartUDBInstance - 启动UDB实例"""

    fields = {}


"""
API: StopUDBInstance

关闭UDB实例
"""


class StopUDBInstanceRequestSchema(schema.RequestSchema):
    """StopUDBInstance - 关闭UDB实例"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ForceToKill": fields.Bool(required=False, dump_to="ForceToKill"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class StopUDBInstanceResponseSchema(schema.ResponseSchema):
    """StopUDBInstance - 关闭UDB实例"""

    fields = {}


"""
API: SwitchUDBHAToSentinel

UDB高可用实例从HAProxy版本升级为Sentinel版本（不带HAProxy）升级耗时5-10秒
"""


class SwitchUDBHAToSentinelRequestSchema(schema.RequestSchema):
    """SwitchUDBHAToSentinel - UDB高可用实例从HAProxy版本升级为Sentinel版本（不带HAProxy）升级耗时5-10秒"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ForceSwitch": fields.Bool(required=False, dump_to="ForceSwitch"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class SwitchUDBHAToSentinelResponseSchema(schema.ResponseSchema):
    """SwitchUDBHAToSentinel - UDB高可用实例从HAProxy版本升级为Sentinel版本（不带HAProxy）升级耗时5-10秒"""

    fields = {}


"""
API: SwitchUDBInstanceToHA

普通UDB切换为高可用(只针对mysql5.5及以上版本SSD机型的实例) ，原db状态为WaitForSwitch时，调用该api； 对于NVMe机型的单点升级高可用，虽然也能使用PromoteUDBInstanceToHA再加上该操作，但是更建议直接调用新的API接口（UpgradeUDBInstanceToHA）
"""


class SwitchUDBInstanceToHARequestSchema(schema.RequestSchema):
    """SwitchUDBInstanceToHA - 普通UDB切换为高可用(只针对mysql5.5及以上版本SSD机型的实例) ，原db状态为WaitForSwitch时，调用该api； 对于NVMe机型的单点升级高可用，虽然也能使用PromoteUDBInstanceToHA再加上该操作，但是更建议直接调用新的API接口（UpgradeUDBInstanceToHA）"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Str(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
    }


class SwitchUDBInstanceToHAResponseSchema(schema.ResponseSchema):
    """SwitchUDBInstanceToHA - 普通UDB切换为高可用(只针对mysql5.5及以上版本SSD机型的实例) ，原db状态为WaitForSwitch时，调用该api； 对于NVMe机型的单点升级高可用，虽然也能使用PromoteUDBInstanceToHA再加上该操作，但是更建议直接调用新的API接口（UpgradeUDBInstanceToHA）"""

    fields = {
        "DBId": fields.Str(required=False, load_from="DBId"),
    }


"""
API: UpdateUDBInstanceBackupStrategy

修改UDB自动备份策略
"""


class UpdateUDBInstanceBackupStrategyRequestSchema(schema.RequestSchema):
    """UpdateUDBInstanceBackupStrategy - 修改UDB自动备份策略"""

    fields = {
        "BackupDate": fields.Str(required=False, dump_to="BackupDate"),
        "BackupMethod": fields.Str(required=False, dump_to="BackupMethod"),
        "BackupTime": fields.Int(required=False, dump_to="BackupTime"),
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ForceDump": fields.Bool(required=False, dump_to="ForceDump"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class UpdateUDBInstanceBackupStrategyResponseSchema(schema.ResponseSchema):
    """UpdateUDBInstanceBackupStrategy - 修改UDB自动备份策略"""

    fields = {}


"""
API: UpdateUDBInstanceSlaveBackupSwitch

开启或者关闭UDB从库备份
"""


class UpdateUDBInstanceSlaveBackupSwitchRequestSchema(schema.RequestSchema):
    """UpdateUDBInstanceSlaveBackupSwitch - 开启或者关闭UDB从库备份"""

    fields = {
        "BackupSwitch": fields.Int(required=True, dump_to="BackupSwitch"),
        "MasterDBId": fields.Str(required=True, dump_to="MasterDBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SlaveDBId": fields.Str(required=False, dump_to="SlaveDBId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class UpdateUDBInstanceSlaveBackupSwitchResponseSchema(schema.ResponseSchema):
    """UpdateUDBInstanceSlaveBackupSwitch - 开启或者关闭UDB从库备份"""

    fields = {}


"""
API: UpdateUDBParamGroup

更新UDB配置参数项
"""


class UpdateUDBParamGroupRequestSchema(schema.RequestSchema):
    """UpdateUDBParamGroup - 更新UDB配置参数项"""

    fields = {
        "Description": fields.Str(required=False, dump_to="Description"),
        "GroupId": fields.Int(required=True, dump_to="GroupId"),
        "Key": fields.Str(required=False, dump_to="Key"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Value": fields.Str(required=False, dump_to="Value"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpdateUDBParamGroupResponseSchema(schema.ResponseSchema):
    """UpdateUDBParamGroup - 更新UDB配置参数项"""

    fields = {}


"""
API: UpgradeUDBInstanceToHA

快杰普通db升级为高可用(只针对mysql5.5及以上版本Nvme机型的实例)  
"""


class UpgradeUDBInstanceToHARequestSchema(schema.RequestSchema):
    """UpgradeUDBInstanceToHA - 快杰普通db升级为高可用(只针对mysql5.5及以上版本Nvme机型的实例)"""

    fields = {
        "DBId": fields.Str(required=True, dump_to="DBId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpgradeUDBInstanceToHAResponseSchema(schema.ResponseSchema):
    """UpgradeUDBInstanceToHA - 快杰普通db升级为高可用(只针对mysql5.5及以上版本Nvme机型的实例)"""

    fields = {}


"""
API: UploadUDBParamGroup

导入UDB配置
"""


class UploadUDBParamGroupRequestSchema(schema.RequestSchema):
    """UploadUDBParamGroup - 导入UDB配置"""

    fields = {
        "Content": fields.Str(required=True, dump_to="Content"),
        "DBTypeId": fields.Str(required=True, dump_to="DBTypeId"),
        "Description": fields.Str(required=True, dump_to="Description"),
        "GroupName": fields.Str(required=True, dump_to="GroupName"),
        "ParamGroupTypeId": fields.Int(
            required=False, dump_to="ParamGroupTypeId"
        ),  # Deprecated, will be removed at 1.0
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UploadUDBParamGroupResponseSchema(schema.ResponseSchema):
    """UploadUDBParamGroup - 导入UDB配置"""

    fields = {
        "GroupId": fields.Int(required=False, load_from="GroupId"),
    }
