""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.uvms.schemas import apis


class UVMSClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UVMSClient, self).__init__(config, transport, middleware, logger)

    def send_uvms_message(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """SendUVMSMessage - 向指定号码拨打电话

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CalledNumber** (str) - (Required) 被叫号码，采用 E.164 标准，格式为+[国家代码][用户号码]。例如：+8613512345678， 其中前面有一个+号 ，86为国家码，13512345678为手机号
        - **TemplateId** (str) - (Required) 模板 ID，在控制台审核通过的模板 ID。
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **FromNumber** (str) - 主叫号码，号码随机时不填。专属号码时传入已购买的号码，仅支持一个号码，在控制台查看已购买的号码。
        - **TemplateParams** (list) - 模板可变参数，以数组的方式填写，举例，TemplateParams.0，TemplateParams.1，... 若模板中无可变参数，则该项可不填写；若模板中有可变参数，则该项为必填项，参数个数需与变量个数保持一致，否则无法发送；
        - **UserId** (str) - 自定义的业务标识ID，字符串（ 长度不能超过32 位），不支持 单引号、表情包符号等特殊字符

        **Response**

        - **Message** (str) - 状态码的描述
        - **ReqUuid** (str) - 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 ReqUuid。
        - **SessionNo** (str) - 本次提交发送语音的唯一ID，可根据该值查询本次发送详情
        - **UserId** (str) - 本次提交的自定义业务标识ID，仅当发送时传入有效的UserId，才返回该字段。

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.SendUVMSMessageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("SendUVMSMessage", d, **kwargs)
        return apis.SendUVMSMessageResponseSchema().loads(resp)
