""" Code is generated by ucloud-model, DO NOT EDIT IT. """


from ucloud.core.typesystem import schema, fields
from ucloud.services.uphone.schemas import models

""" UPhone API Schema
"""


"""
API: CreateUPhone

创建云手机
"""


class CreateUPhoneRequestSchema(schema.RequestSchema):
    """CreateUPhone - 创建云手机"""

    fields = {
        "Bandwidth": fields.Int(required=False, dump_to="Bandwidth"),
        "BindIp": fields.Bool(required=False, dump_to="BindIp"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ImageId": fields.Str(required=True, dump_to="ImageId"),
        "IpDestRegion": fields.Str(required=False, dump_to="IpDestRegion"),
        "IpProportion": fields.Int(required=False, dump_to="IpProportion"),
        "MediaBandwidth": fields.Int(required=True, dump_to="MediaBandwidth"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Str(required=False, dump_to="Quantity"),
        "ShareBandwidthId": fields.Str(
            required=False, dump_to="ShareBandwidthId"
        ),
        "ShareBandwidthName": fields.Str(
            required=False, dump_to="ShareBandwidthName"
        ),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UPhoneCount": fields.Int(required=True, dump_to="UPhoneCount"),
        "UPhoneModelName": fields.Str(required=True, dump_to="UPhoneModelName"),
    }


class CreateUPhoneResponseSchema(schema.ResponseSchema):
    """CreateUPhone - 创建云手机"""

    fields = {
        "JobId": fields.Str(required=True, load_from="JobId"),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: CreateUPhoneApp

一个 app 对应多个 app_version。
"""


class CreateUPhoneAppRequestSchema(schema.RequestSchema):
    """CreateUPhoneApp - 一个 app 对应多个 app_version。"""

    fields = {
        "Description": fields.Str(required=False, dump_to="Description"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class CreateUPhoneAppResponseSchema(schema.ResponseSchema):
    """CreateUPhoneApp - 一个 app 对应多个 app_version。"""

    fields = {
        "AppId": fields.Str(required=True, load_from="AppId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateUPhoneAppVersion

创建云手机应用版本。
注：一个 app 对应多个 app_version。
"""


class CreateUPhoneAppVersionRequestSchema(schema.RequestSchema):
    """CreateUPhoneAppVersion - 创建云手机应用版本。
    注：一个 app 对应多个 app_version。
    """

    fields = {
        "AppId": fields.Str(required=True, dump_to="AppId"),
        "Description": fields.Str(required=False, dump_to="Description"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "URL": fields.Str(required=True, dump_to="URL"),
    }


class CreateUPhoneAppVersionResponseSchema(schema.ResponseSchema):
    """CreateUPhoneAppVersion - 创建云手机应用版本。
    注：一个 app 对应多个 app_version。
    """

    fields = {
        "AppVersionId": fields.Str(required=True, load_from="AppVersionId"),
    }


"""
API: CreateUPhoneImage

创建云手机镜像。
"""


class CreateUPhoneImageRequestSchema(schema.RequestSchema):
    """CreateUPhoneImage - 创建云手机镜像。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Description": fields.Str(required=False, dump_to="Description"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
    }


class CreateUPhoneImageResponseSchema(schema.ResponseSchema):
    """CreateUPhoneImage - 创建云手机镜像。"""

    fields = {
        "ImageId": fields.Str(required=False, load_from="ImageId"),
        "JobId": fields.Str(required=False, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateUPhoneServer

创建云手机服务器
"""


class CreateUPhoneServerParamNetworkInterfaceSchema(schema.RequestSchema):
    """CreateUPhoneServerParamNetworkInterface -"""

    fields = {}


class CreateUPhoneServerRequestSchema(schema.RequestSchema):
    """CreateUPhoneServer - 创建云手机服务器"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ImageId": fields.Str(required=True, dump_to="ImageId"),
        "IpDestRegion": fields.Str(required=False, dump_to="IpDestRegion"),
        "IpProportion": fields.Int(required=False, dump_to="IpProportion"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Str(required=False, dump_to="Quantity"),
        "ServerModelName": fields.Str(required=True, dump_to="ServerModelName"),
        "ShareBandwidth": fields.Int(required=False, dump_to="ShareBandwidth"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UPhoneModelName": fields.Str(required=True, dump_to="UPhoneModelName"),
    }


class CreateUPhoneServerResponseSchema(schema.ResponseSchema):
    """CreateUPhoneServer - 创建云手机服务器"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "ServerId": fields.Str(required=True, load_from="ServerId"),
    }


"""
API: DeleteUPhone

删除云手机
"""


class DeleteUPhoneRequestSchema(schema.RequestSchema):
    """DeleteUPhone - 删除云手机"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class DeleteUPhoneResponseSchema(schema.ResponseSchema):
    """DeleteUPhone - 删除云手机"""

    fields = {
        "JobId": fields.Str(required=True, load_from="JobId"),
    }


"""
API: DeleteUPhoneImage

删除自制云手机镜像。
"""


class DeleteUPhoneImageRequestSchema(schema.RequestSchema):
    """DeleteUPhoneImage - 删除自制云手机镜像。"""

    fields = {
        "ImageId": fields.Str(required=True, dump_to="ImageId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DeleteUPhoneImageResponseSchema(schema.ResponseSchema):
    """DeleteUPhoneImage - 删除自制云手机镜像。"""

    fields = {
        "ImageId": fields.Str(required=True, load_from="ImageId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteUPhoneServer

删除云手机服务器。
"""


class DeleteUPhoneServerRequestSchema(schema.RequestSchema):
    """DeleteUPhoneServer - 删除云手机服务器。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ReleaseEIP": fields.Bool(required=False, dump_to="ReleaseEIP"),
        "ReleaseUDisk": fields.Bool(required=False, dump_to="ReleaseUDisk"),
        "ServerId": fields.Str(required=True, dump_to="ServerId"),
    }


class DeleteUPhoneServerResponseSchema(schema.ResponseSchema):
    """DeleteUPhoneServer - 删除云手机服务器。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DescribeUPhone

获取云手机列表信息。
"""


class DescribeUPhoneRequestSchema(schema.RequestSchema):
    """DescribeUPhone - 获取云手机列表信息。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "IsAll": fields.Bool(required=False, dump_to="IsAll"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ServerId": fields.Str(required=False, dump_to="ServerId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class DescribeUPhoneResponseSchema(schema.ResponseSchema):
    """DescribeUPhone - 获取云手机列表信息。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
        "UPhones": fields.List(
            models.UPhoneInstanceSchema(), required=True, load_from="UPhones"
        ),
    }


"""
API: DescribeUPhoneApp

获取应用列表。
"""


class DescribeUPhoneAppRequestSchema(schema.RequestSchema):
    """DescribeUPhoneApp - 获取应用列表。"""

    fields = {
        "AppIds": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DescribeUPhoneAppResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneApp - 获取应用列表。"""

    fields = {
        "Apps": fields.List(
            models.AppInstanceSchema(), required=False, load_from="Apps"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeUPhoneAppVersion

获取应用版本列表。
"""


class DescribeUPhoneAppVersionRequestSchema(schema.RequestSchema):
    """DescribeUPhoneAppVersion - 获取应用版本列表。"""

    fields = {
        "AppId": fields.Str(required=False, dump_to="AppId"),
        "AppVersionIds": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneId": fields.Str(required=False, dump_to="UPhoneId"),
    }


class DescribeUPhoneAppVersionResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneAppVersion - 获取应用版本列表。"""

    fields = {
        "AppVersions": fields.List(
            models.AppVersionInstanceSchema(),
            required=True,
            load_from="AppVersions",
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeUPhoneCities

获取云手机提供服务的城市列表
"""


class DescribeUPhoneCitiesRequestSchema(schema.RequestSchema):
    """DescribeUPhoneCities - 获取云手机提供服务的城市列表"""

    fields = {
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DescribeUPhoneCitiesResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneCities - 获取云手机提供服务的城市列表"""

    fields = {
        "UPhoneCities": fields.List(
            models.CityInstanceSchema(), required=True, load_from="UPhoneCities"
        ),
    }


"""
API: DescribeUPhoneDetailByApp

根据AppId，查询安装该应用的云手机以及相关的应用版本信息
"""


class DescribeUPhoneDetailByAppRequestSchema(schema.RequestSchema):
    """DescribeUPhoneDetailByApp - 根据AppId，查询安装该应用的云手机以及相关的应用版本信息"""

    fields = {
        "AppId": fields.Str(required=True, dump_to="AppId"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DescribeUPhoneDetailByAppResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneDetailByApp - 根据AppId，查询安装该应用的云手机以及相关的应用版本信息"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
        "UPhoneDetails": fields.List(
            models.UPhoneDetailInstanceSchema(),
            required=True,
            load_from="UPhoneDetails",
        ),
    }


"""
API: DescribeUPhoneImage

获取云手机镜像信息列表。  
"""


class DescribeUPhoneImageRequestSchema(schema.RequestSchema):
    """DescribeUPhoneImage - 获取云手机镜像信息列表。"""

    fields = {
        "ImageIds": fields.List(fields.Str()),
        "Limit": fields.Str(required=False, dump_to="Limit"),
        "Offset": fields.Str(required=False, dump_to="Offset"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Type": fields.Str(required=False, dump_to="Type"),
    }


class DescribeUPhoneImageResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneImage - 获取云手机镜像信息列表。"""

    fields = {
        "Images": fields.List(
            models.UPhoneImageInstanceSchema(),
            required=True,
            load_from="Images",
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUPhoneIpRegions

获取云手机所在城市支持绑定独立IP的地域列表
"""


class DescribeUPhoneIpRegionsRequestSchema(schema.RequestSchema):
    """DescribeUPhoneIpRegions - 获取云手机所在城市支持绑定独立IP的地域列表"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class DescribeUPhoneIpRegionsResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneIpRegions - 获取云手机所在城市支持绑定独立IP的地域列表"""

    fields = {
        "Regions": fields.List(
            models.IpRegionSchema(), required=True, load_from="Regions"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUPhoneJob

查询Job的执行状态。
"""


class DescribeUPhoneJobRequestSchema(schema.RequestSchema):
    """DescribeUPhoneJob - 查询Job的执行状态。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "JobIds": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "State": fields.Str(required=False, dump_to="State"),
        "Types": fields.List(fields.Str()),
    }


class DescribeUPhoneJobResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneJob - 查询Job的执行状态。"""

    fields = {
        "Jobs": fields.List(
            models.JobSchema(), required=False, load_from="Jobs"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUPhoneModel

获取云手机规格列表。两种类型：uphone代表单云手机场景、uphone-server代表云手机服务器场景。
"""


class DescribeUPhoneModelRequestSchema(schema.RequestSchema):
    """DescribeUPhoneModel - 获取云手机规格列表。两种类型：uphone代表单云手机场景、uphone-server代表云手机服务器场景。"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneModelNames": fields.List(fields.Str()),
    }


class DescribeUPhoneModelResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneModel - 获取云手机规格列表。两种类型：uphone代表单云手机场景、uphone-server代表云手机服务器场景。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
        "UPhoneModels": fields.List(
            models.UPhoneModelInstanceSchema(),
            required=True,
            load_from="UPhoneModels",
        ),
    }


"""
API: DescribeUPhoneServer

获取云手机服务器列表信息。
"""


class DescribeUPhoneServerRequestSchema(schema.RequestSchema):
    """DescribeUPhoneServer - 获取云手机服务器列表信息。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ServerIds": fields.List(fields.Str()),
    }


class DescribeUPhoneServerResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneServer - 获取云手机服务器列表信息。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "Servers": fields.List(
            models.ServerInstanceSchema(), required=True, load_from="Servers"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeUPhoneServerModel

获取ServerModel列表。
"""


class DescribeUPhoneServerModelRequestSchema(schema.RequestSchema):
    """DescribeUPhoneServerModel - 获取ServerModel列表。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ServerModelNames": fields.List(fields.Str()),
    }


class DescribeUPhoneServerModelResponseSchema(schema.ResponseSchema):
    """DescribeUPhoneServerModel - 获取ServerModel列表。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "ServerModels": fields.List(
            models.ServerModelInstanceSchema(),
            required=False,
            load_from="ServerModels",
        ),
        "Stock": fields.List(
            models.StockInfoSchema(), required=False, load_from="Stock"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: GetUPhoneAllowance

获取云手机创建余量
"""


class GetUPhoneAllowanceRequestSchema(schema.RequestSchema):
    """GetUPhoneAllowance - 获取云手机创建余量"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class GetUPhoneAllowanceResponseSchema(schema.ResponseSchema):
    """GetUPhoneAllowance - 获取云手机创建余量"""

    fields = {
        "UPhoneAllowance": fields.List(
            models.UPhoneAllowanceSchema(),
            required=True,
            load_from="UPhoneAllowance",
        ),
    }


"""
API: GetUPhonePrice

根据云手机规格名称，获取UPhone实例的价格。
"""


class GetUPhonePriceRequestSchema(schema.RequestSchema):
    """GetUPhonePrice - 根据云手机规格名称，获取UPhone实例的价格。"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "INetBandwidth": fields.Int(required=False, dump_to="INetBandwidth"),
        "IpCount": fields.Int(required=False, dump_to="IpCount"),
        "IpDestRegion": fields.Str(required=False, dump_to="IpDestRegion"),
        "MediaBandwidth": fields.Int(required=False, dump_to="MediaBandwidth"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "UPhoneCount": fields.Int(required=False, dump_to="UPhoneCount"),
        "UPhoneModelName": fields.Int(
            required=False, dump_to="UPhoneModelName"
        ),
    }


class GetUPhonePriceResponseSchema(schema.ResponseSchema):
    """GetUPhonePrice - 根据云手机规格名称，获取UPhone实例的价格。"""

    fields = {
        "PriceSet": fields.List(
            models.UPhonePriceSetSchema(), required=True, load_from="PriceSet"
        ),
    }


"""
API: GetUPhoneRenewPrice

获取云手机续费价格，不包括独立ip价格。
"""


class GetUPhoneRenewPriceRequestSchema(schema.RequestSchema):
    """GetUPhoneRenewPrice - 获取云手机续费价格，不包括独立ip价格。"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
    }


class GetUPhoneRenewPriceResponseSchema(schema.ResponseSchema):
    """GetUPhoneRenewPrice - 获取云手机续费价格，不包括独立ip价格。"""

    fields = {
        "PriceSet": fields.List(
            models.UPhonePriceSetSchema(), required=True, load_from="PriceSet"
        ),
    }


"""
API: GetUPhoneScreenCapture

云手机截屏
"""


class GetUPhoneScreenCaptureRequestSchema(schema.RequestSchema):
    """GetUPhoneScreenCapture - 云手机截屏"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneID": fields.Str(required=True, dump_to="UPhoneID"),
    }


class GetUPhoneScreenCaptureResponseSchema(schema.ResponseSchema):
    """GetUPhoneScreenCapture - 云手机截屏"""

    fields = {
        "URL": fields.Str(required=True, load_from="URL"),
    }


"""
API: GetUPhoneServerPrice

根据服务器规格名称，获取UPhoneServer实例的价格。
"""


class GetUPhoneServerPriceRequestSchema(schema.RequestSchema):
    """GetUPhoneServerPrice - 根据服务器规格名称，获取UPhoneServer实例的价格。"""

    fields = {
        "Bandwidth": fields.Int(required=False, dump_to="Bandwidth"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "IpCount": fields.Int(required=False, dump_to="IpCount"),
        "IpDestRegion": fields.Str(required=False, dump_to="IpDestRegion"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "ServerModelName": fields.Str(required=True, dump_to="ServerModelName"),
    }


class GetUPhoneServerPriceResponseSchema(schema.ResponseSchema):
    """GetUPhoneServerPrice - 根据服务器规格名称，获取UPhoneServer实例的价格。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "PriceSet": fields.List(
            models.UPhoneServerPriceSetSchema(),
            required=True,
            load_from="PriceSet",
        ),
    }


"""
API: GetUPhoneServerRenewPrice

获取云手机服务器续费价格

提示信息: 须按照控制台服务器模型配置创建服务器。详情请参考控制台。
"""


class GetUPhoneServerRenewPriceRequestSchema(schema.RequestSchema):
    """GetUPhoneServerRenewPrice - 获取云手机服务器续费价格

    提示信息: 须按照控制台服务器模型配置创建服务器。详情请参考控制台。
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ServerId": fields.Str(required=True, dump_to="ServerId"),
    }


class GetUPhoneServerRenewPriceResponseSchema(schema.ResponseSchema):
    """GetUPhoneServerRenewPrice - 获取云手机服务器续费价格

    提示信息: 须按照控制台服务器模型配置创建服务器。详情请参考控制台。
    """

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "PriceSet": fields.List(
            models.UPhoneServerPriceSetSchema(),
            required=True,
            load_from="PriceSet",
        ),
    }


"""
API: ImportFile

上传文件到云手机目录/sdcard/Download/并自动安装APK文件
"""


class ImportFileRequestSchema(schema.RequestSchema):
    """ImportFile - 上传文件到云手机目录/sdcard/Download/并自动安装APK文件"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "FileName": fields.Str(required=True, dump_to="FileName"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
        "URL": fields.Str(required=True, dump_to="URL"),
    }


class ImportFileResponseSchema(schema.ResponseSchema):
    """ImportFile - 上传文件到云手机目录/sdcard/Download/并自动安装APK文件"""

    fields = {
        "JobId": fields.Str(required=True, load_from="JobId"),
    }


"""
API: InstallUPhoneAppVersion

在云手机中安装应用版本相关的Apk文件。系统会根据AppVersionId将对应的Apk文件下载后安装到云手机中。一次只支持安装一个Apk。
"""


class InstallUPhoneAppVersionRequestSchema(schema.RequestSchema):
    """InstallUPhoneAppVersion - 在云手机中安装应用版本相关的Apk文件。系统会根据AppVersionId将对应的Apk文件下载后安装到云手机中。一次只支持安装一个Apk。"""

    fields = {
        "AppVersionId": fields.Str(required=True, dump_to="AppVersionId"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class InstallUPhoneAppVersionResponseSchema(schema.ResponseSchema):
    """InstallUPhoneAppVersion - 在云手机中安装应用版本相关的Apk文件。系统会根据AppVersionId将对应的Apk文件下载后安装到云手机中。一次只支持安装一个Apk。"""

    fields = {
        "JobId": fields.Str(required=True, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ModifyUPhoneName

修改指定云手机实例名称。
"""


class ModifyUPhoneNameRequestSchema(schema.RequestSchema):
    """ModifyUPhoneName - 修改指定云手机实例名称。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
    }


class ModifyUPhoneNameResponseSchema(schema.ResponseSchema):
    """ModifyUPhoneName - 修改指定云手机实例名称。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "UPhoneId": fields.Str(required=True, load_from="UPhoneId"),
    }


"""
API: ModifyUPhoneRemark

修改指定云手机实例备注信息。
"""


class ModifyUPhoneRemarkRequestSchema(schema.RequestSchema):
    """ModifyUPhoneRemark - 修改指定云手机实例备注信息。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
    }


class ModifyUPhoneRemarkResponseSchema(schema.ResponseSchema):
    """ModifyUPhoneRemark - 修改指定云手机实例备注信息。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "UPhoneId": fields.Str(required=True, load_from="UPhoneId"),
    }


"""
API: ModifyUPhoneServerName

修改指定云手机服务器实例名称。
"""


class ModifyUPhoneServerNameRequestSchema(schema.RequestSchema):
    """ModifyUPhoneServerName - 修改指定云手机服务器实例名称。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "ServerId": fields.Str(required=True, dump_to="ServerId"),
    }


class ModifyUPhoneServerNameResponseSchema(schema.ResponseSchema):
    """ModifyUPhoneServerName - 修改指定云手机服务器实例名称。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "ServerId": fields.Str(required=True, load_from="ServerId"),
    }


"""
API: ModifyUPhoneServerRemark

修改指定云手机实例备注信息。
"""


class ModifyUPhoneServerRemarkRequestSchema(schema.RequestSchema):
    """ModifyUPhoneServerRemark - 修改指定云手机实例备注信息。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "ServerId": fields.Str(required=True, dump_to="ServerId"),
    }


class ModifyUPhoneServerRemarkResponseSchema(schema.ResponseSchema):
    """ModifyUPhoneServerRemark - 修改指定云手机实例备注信息。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "ServerId": fields.Str(required=True, load_from="ServerId"),
    }


"""
API: PoweroffUPhone

关闭处于运行状态的云手机实例
"""


class PoweroffUPhoneRequestSchema(schema.RequestSchema):
    """PoweroffUPhone - 关闭处于运行状态的云手机实例"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class PoweroffUPhoneResponseSchema(schema.ResponseSchema):
    """PoweroffUPhone - 关闭处于运行状态的云手机实例"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: PoweronUPhone

启动处于关闭状态的云手机实例
"""


class PoweronUPhoneRequestSchema(schema.RequestSchema):
    """PoweronUPhone - 启动处于关闭状态的云手机实例"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class PoweronUPhoneResponseSchema(schema.ResponseSchema):
    """PoweronUPhone - 启动处于关闭状态的云手机实例"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RebootUPhone

重新启动云手机实例
"""


class RebootUPhoneRequestSchema(schema.RequestSchema):
    """RebootUPhone - 重新启动云手机实例"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class RebootUPhoneResponseSchema(schema.ResponseSchema):
    """RebootUPhone - 重新启动云手机实例"""

    fields = {
        "JobId": fields.Str(required=False, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RenewUPhone

修改UPhone的device_id、imei、meid 以及其他相关配置，达到一键新机的效果
"""


class RenewUPhoneRequestSchema(schema.RequestSchema):
    """RenewUPhone - 修改UPhone的device_id、imei、meid 以及其他相关配置，达到一键新机的效果"""

    fields = {
        "AndroidID": fields.Str(required=False, dump_to="AndroidID"),
        "BSSID": fields.Str(required=False, dump_to="BSSID"),
        "BaseBand": fields.Str(required=False, dump_to="BaseBand"),
        "Board": fields.Str(required=False, dump_to="Board"),
        "BootLoader": fields.Str(required=False, dump_to="BootLoader"),
        "Brand": fields.Str(required=False, dump_to="Brand"),
        "BuildHost": fields.Str(required=False, dump_to="BuildHost"),
        "BuildID": fields.Str(required=False, dump_to="BuildID"),
        "BuildTags": fields.Str(required=False, dump_to="BuildTags"),
        "BuildVersionInc": fields.Str(
            required=False, dump_to="BuildVersionInc"
        ),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Customize": fields.Bool(required=False, dump_to="Customize"),
        "Device": fields.Str(required=False, dump_to="Device"),
        "DisplayID": fields.Str(required=False, dump_to="DisplayID"),
        "FingerPrint": fields.Str(required=False, dump_to="FingerPrint"),
        "ICCID": fields.Str(required=False, dump_to="ICCID"),
        "IMEI": fields.Str(required=False, dump_to="IMEI"),
        "IMEISV": fields.Str(required=False, dump_to="IMEISV"),
        "IMSI": fields.Str(required=False, dump_to="IMSI"),
        "Manufacture": fields.Str(required=False, dump_to="Manufacture"),
        "Model": fields.Str(required=False, dump_to="Model"),
        "PhoneNumber": fields.Str(required=False, dump_to="PhoneNumber"),
        "ProductName": fields.Str(required=False, dump_to="ProductName"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "RadioMac": fields.Str(required=False, dump_to="RadioMac"),
        "SerialNumber": fields.Str(required=False, dump_to="SerialNumber"),
        "UPhoneIds": fields.List(fields.Str()),
        "WiFiName": fields.Str(required=False, dump_to="WiFiName"),
    }


class RenewUPhoneResponseSchema(schema.ResponseSchema):
    """RenewUPhone - 修改UPhone的device_id、imei、meid 以及其他相关配置，达到一键新机的效果"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ResetUPhone

将云手机恢复为创建时的状态。
"""


class ResetUPhoneRequestSchema(schema.RequestSchema):
    """ResetUPhone - 将云手机恢复为创建时的状态。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class ResetUPhoneResponseSchema(schema.ResponseSchema):
    """ResetUPhone - 将云手机恢复为创建时的状态。"""

    fields = {
        "JobId": fields.Str(required=False, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RunAsyncCommand

在云手机中执行异步shell命令。
"""


class RunAsyncCommandRequestSchema(schema.RequestSchema):
    """RunAsyncCommand - 在云手机中执行异步shell命令。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Content": fields.Str(required=True, dump_to="Content"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class RunAsyncCommandResponseSchema(schema.ResponseSchema):
    """RunAsyncCommand - 在云手机中执行异步shell命令。"""

    fields = {
        "JobId": fields.Str(required=True, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RunSyncCommand

在云手机中执行同步shell命令。
"""


class RunSyncCommandRequestSchema(schema.RequestSchema):
    """RunSyncCommand - 在云手机中执行同步shell命令。"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Content": fields.Str(required=True, dump_to="Content"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class RunSyncCommandResponseSchema(schema.ResponseSchema):
    """RunSyncCommand - 在云手机中执行同步shell命令。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "Results": fields.List(
            models.UPhoneCommandResultSchema(),
            required=True,
            load_from="Results",
        ),
    }


"""
API: SetUPhoneCallback

设置云手机异步操作以及状态更新回调，支持云手机重置，安装应用，卸载应用，设备占用状态回调
"""


class SetUPhoneCallbackRequestSchema(schema.RequestSchema):
    """SetUPhoneCallback - 设置云手机异步操作以及状态更新回调，支持云手机重置，安装应用，卸载应用，设备占用状态回调"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
        "URL": fields.Str(required=True, dump_to="URL"),
    }


class SetUPhoneCallbackResponseSchema(schema.ResponseSchema):
    """SetUPhoneCallback - 设置云手机异步操作以及状态更新回调，支持云手机重置，安装应用，卸载应用，设备占用状态回调"""

    fields = {}


"""
API: SetUPhoneConfig

设置云手机画面参数（分辨率、DPI、帧率、码率）
"""


class SetUPhoneConfigRequestSchema(schema.RequestSchema):
    """SetUPhoneConfig - 设置云手机画面参数（分辨率、DPI、帧率、码率）"""

    fields = {
        "Async": fields.Str(required=False, dump_to="Async"),
        "Bitrate": fields.Str(required=False, dump_to="Bitrate"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Dpi": fields.Str(required=False, dump_to="Dpi"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Refresh": fields.Str(required=False, dump_to="Refresh"),
        "Resolution": fields.Str(required=False, dump_to="Resolution"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class SetUPhoneConfigResponseSchema(schema.ResponseSchema):
    """SetUPhoneConfig - 设置云手机画面参数（分辨率、DPI、帧率、码率）"""

    fields = {
        "JobId": fields.Str(required=False, load_from="JobId"),
        "Message": fields.Str(required=False, load_from="Message"),
        "RequestId": fields.Str(required=True, load_from="RequestId"),
        "Results": fields.List(
            models.ResultsSchema(), required=False, load_from="Results"
        ),
    }


"""
API: SetUPhoneGPS

设置云手机GPS信息
"""


class SetUPhoneGPSParamUPhoneGPSsSchema(schema.RequestSchema):
    """SetUPhoneGPSParamUPhoneGPSs -"""

    fields = {
        "Altitude": fields.Float(required=False, dump_to="Altitude"),
        "Latitude": fields.Float(required=False, dump_to="Latitude"),
        "Longitude": fields.Float(required=False, dump_to="Longitude"),
        "UPhoneId": fields.Str(required=False, dump_to="UPhoneId"),
    }


class SetUPhoneGPSRequestSchema(schema.RequestSchema):
    """SetUPhoneGPS - 设置云手机GPS信息"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneGPSs": fields.List(SetUPhoneGPSParamUPhoneGPSsSchema()),
    }


class SetUPhoneGPSResponseSchema(schema.ResponseSchema):
    """SetUPhoneGPS - 设置云手机GPS信息"""

    fields = {
        "JobId": fields.Str(required=False, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: SetUPhoneManagerMode

管理员模式支持所有按键，普通用户模式禁用返回桌面
"""


class SetUPhoneManagerModeRequestSchema(schema.RequestSchema):
    """SetUPhoneManagerMode - 管理员模式支持所有按键，普通用户模式禁用返回桌面"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "Mode": fields.Str(required=True, dump_to="Mode"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
    }


class SetUPhoneManagerModeResponseSchema(schema.ResponseSchema):
    """SetUPhoneManagerMode - 管理员模式支持所有按键，普通用户模式禁用返回桌面"""

    fields = {}


"""
API: SetUPhoneRootMode

设置云手机Root模式
"""


class SetUPhoneRootModeRequestSchema(schema.RequestSchema):
    """SetUPhoneRootMode - 设置云手机Root模式"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Root": fields.Bool(required=True, dump_to="Root"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class SetUPhoneRootModeResponseSchema(schema.ResponseSchema):
    """SetUPhoneRootMode - 设置云手机Root模式"""

    fields = {
        "JobId": fields.Str(required=True, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: SetUPhoneSplashScreen

设置云手机启动画面，通过DescribeUPhone接口可以查询该地址
"""


class SetUPhoneSplashScreenRequestSchema(schema.RequestSchema):
    """SetUPhoneSplashScreen - 设置云手机启动画面，通过DescribeUPhone接口可以查询该地址"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
        "URL": fields.Str(required=True, dump_to="URL"),
    }


class SetUPhoneSplashScreenResponseSchema(schema.ResponseSchema):
    """SetUPhoneSplashScreen - 设置云手机启动画面，通过DescribeUPhone接口可以查询该地址"""

    fields = {}


"""
API: SetUPhoneToken

设置云手机RTC连接Token提高安全性
"""


class SetUPhoneTokenRequestSchema(schema.RequestSchema):
    """SetUPhoneToken - 设置云手机RTC连接Token提高安全性"""

    fields = {
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Token": fields.Str(required=False, dump_to="Token"),
        "UPhoneId": fields.Str(required=True, dump_to="UPhoneId"),
    }


class SetUPhoneTokenResponseSchema(schema.ResponseSchema):
    """SetUPhoneToken - 设置云手机RTC连接Token提高安全性"""

    fields = {}


"""
API: UnInstallUPhoneAppVersion

传入应用版本Id，在云手机中根据应用版本的PackageName卸载相关应用。一次只支持卸载一个应用。
"""


class UnInstallUPhoneAppVersionRequestSchema(schema.RequestSchema):
    """UnInstallUPhoneAppVersion - 传入应用版本Id，在云手机中根据应用版本的PackageName卸载相关应用。一次只支持卸载一个应用。"""

    fields = {
        "AppVersionId": fields.Str(required=True, dump_to="AppVersionId"),
        "CityId": fields.Str(required=True, dump_to="CityId"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "UPhoneIds": fields.List(fields.Str()),
    }


class UnInstallUPhoneAppVersionResponseSchema(schema.ResponseSchema):
    """UnInstallUPhoneAppVersion - 传入应用版本Id，在云手机中根据应用版本的PackageName卸载相关应用。一次只支持卸载一个应用。"""

    fields = {
        "JobId": fields.Str(required=True, load_from="JobId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpdateUPhoneImage

更新云手机镜像信息。
"""


class UpdateUPhoneImageRequestSchema(schema.RequestSchema):
    """UpdateUPhoneImage - 更新云手机镜像信息。"""

    fields = {
        "Description": fields.Str(required=False, dump_to="Description"),
        "ImageId": fields.Str(required=True, dump_to="ImageId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
    }


class UpdateUPhoneImageResponseSchema(schema.ResponseSchema):
    """UpdateUPhoneImage - 更新云手机镜像信息。"""

    fields = {
        "ImageId": fields.Str(required=True, load_from="ImageId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }
