""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.isms.schemas import apis


class ISMSClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(ISMSClient, self).__init__(config, transport, middleware, logger)

    def get_isms_send_receipt(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetISMSSendReceipt - 获取视频短信发送记录的状态回执

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **TaskIdSet** (list) - (Required) 发送记录TaskId集合。调用SendUSMSVideoMessage时返回的TaskId的集合。以TaskIdSet.0、TaskIdSet.1...TaskIdSet.N的形式传入。每次请求最多支持100个
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Data** (list) - 见 **ReceiptPerTask** 模型定义
        - **Message** (str) - 错误信息
        - **ReqUuid** (str) - 本次请求uuid

        **Response Model**

        **ReceiptPerPhone**
        - **Phone** (str) - 手机号码
        - **ReceiptCode** (str) - 回执码
        - **ReceiptDesc** (str) - 回执结果描述
        - **ReceiptResult** (str) - 回执结果(发送成功、发送失败、状态未知)
        - **ReceiptTime** (int) - 回执返回时间
        - **SessionId** (str) - SessionId


        **ReceiptPerTask**
        - **ReceiptSet** (list) - 见 **ReceiptPerPhone** 模型定义
        - **TaskId** (str) - 发送短信时返回的TaskId


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetISMSSendReceiptRequestSchema().dumps(d)

        resp = self.invoke("GetISMSSendReceipt", d, **kwargs)
        return apis.GetISMSSendReceiptResponseSchema().loads(resp)

    def send_isms_message(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """SendISMSMessage - 发送视频短信

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **PhoneSet** (list) - (Required) 手机号码列表。暂时只支持中国大陆号码。若号码中带区号，需要将区号使用小括号包含，放在号码前面。如: (86)1851623xxxx
        - **TemplateId** (str) - (Required) 视频短信模板Id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Message** (str) - 错误信息
        - **ReqUuid** (str) - 本次请求uuid
        - **TaskId** (str) - 本次调用TaskId，使用该字段查询回执信息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.SendISMSMessageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("SendISMSMessage", d, **kwargs)
        return apis.SendISMSMessageResponseSchema().loads(resp)
