""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing




from ucloud.core.client import Client
from ucloud.services.umongodb.schemas import apis









class UMongoDBClient(Client):
    def __init__(self, config: dict, transport=None, middleware=None, logger=None):
        super(UMongoDBClient, self).__init__(config, transport, middleware, logger)

    
    
    
    
    
    
    
    def backup_umon_go_db_cluster(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ BackupUMongoDBCluster - 备份集群数据库

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **BackupName** (str) - (Required) 备份名称
        - **ClusterId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **BackupId** (str) - 备份ID
        - **ClusterId** (str) - 实例ID
        - **Message** (str) - 错误信息
        
        """
        # build request
        d = {
            'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.BackupUMongoDBClusterRequestSchema().dumps(d)
        
        resp = self.invoke("BackupUMongoDBCluster", d, **kwargs)
        return apis.BackupUMongoDBClusterResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def create_umon_go_db_config_template(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ CreateUMongoDBConfigTemplate - 创建配置模板

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **BaseTemplateId** (str) - (Required) 基础模板
        - **ClusterType** (str) - (Required) 集群类型
        - **MongodbVersion** (str) - (Required) mongo版本
        - **TemplateName** (str) - (Required) 模板名称
        - **Description** (str) - 模板描述
        
        **Response**

        - **Message** (str) - 错误信息
        - **TemplateId** (str) - 模板Id
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.CreateUMongoDBConfigTemplateRequestSchema().dumps(d)
        
        # build options
        kwargs['max_retries'] = 0 # ignore retry when api is not idempotent
        
        resp = self.invoke("CreateUMongoDBConfigTemplate", d, **kwargs)
        return apis.CreateUMongoDBConfigTemplateResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def describe_umon_go_db_backup_url(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ DescribeUMongoDBBackupURL - 获取实例备份下载链接

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **BackupId** (str) - (Required) 文件备份ID
        - **ClusterId** (str) - (Required) 集群ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ValidTime** (int) - 备份链接过期时间（单位秒）
        
        **Response**

        - **InternetAddress** (str) - 备份文件公网地址
        - **IntranetAddress** (str) - 备份文件内网地址
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.DescribeUMongoDBBackupURLRequestSchema().dumps(d)
        
        resp = self.invoke("DescribeUMongoDBBackupURL", d, **kwargs)
        return apis.DescribeUMongoDBBackupURLResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def get_umon_go_db_backup_param(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ GetUMongoDBBackupParam - 获取实例备份策略

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **DataSet** (dict) - 见 **BackupParam** 模型定义
        - **Message** (str) - 错误信息
        
        **Response Model**
        
        **BackupParam** 
        - **AutoBackupCopies** (int) - 自动备份保存份数
        - **AutoBackupToggleTime** (str) - 自动备份预期时间范围 (24小时制，精确到分钟，00:00~23:59)
        - **AutoBackupToggleWeek** (str) - 自动备份预期周几 (1-7 表示 周一到周末，多个数据用','分割，eg: 3,7)
        - **ClusterId** (str) - 实例ID
        - **ManualBackupCopies** (int) - 手动备份保存份数
        

        """
        # build request
        d = {
            'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.GetUMongoDBBackupParamRequestSchema().dumps(d)
        
        resp = self.invoke("GetUMongoDBBackupParam", d, **kwargs)
        return apis.GetUMongoDBBackupParamResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def get_umon_go_db_cfg_temp_item(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ GetUMongoDBCfgTempItem - 获取配置模板内容

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **TemplateId** (str) - (Required) 配置模板Id
        
        **Response**

        - **DataSet** (list) - 见 **ConfigTemplateItem** 模型定义
        - **Message** (str) - 错误信息
        
        **Response Model**
        
        **ConfigOptions** 
        - **AllowedApplyType** (str) - 允许应用类型
        - **Description** (str) - 描述
        - **EnableDisplay** (bool) - 是否前端展示
        - **EnableModify** (bool) - 是否可修改
        - **ForceRestart** (bool) - 是否需重启
        - **IsDefaultOption** (bool) - 是否为默认选项
        - **MongodbVersion** (str) - mongo版本
        - **OptionDefaultValue** (str) - 默认值
        - **OptionFormatType** (str) - 选项值格式
        - **OptionName** (str) - 配置选项名
        - **OptionValueType** (str) - 配置选项类型 string,int,bool
        - **OptionValues** (str) - 配置选项值范围
        

        **ConfigTemplateItem** 
        - **ConfigName** (str) - 配置名称
        - **ConfigOption** (dict) - 见 **ConfigOptions** 模型定义
        - **ConfigValue** (str) - 配置值
        - **CreateTime** (int) - 创建时间
        - **ItemId** (str) - itemId
        - **ModifyTime** (int) - 修改时间
        - **NodeType** (str) - 节点类型: DataNode:数据节点 | ConfigSrvNode:配置节点 | MongosNode:路由节点
        - **TemplateId** (str) - 模板ID
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.GetUMongoDBCfgTempItemRequestSchema().dumps(d)
        
        resp = self.invoke("GetUMongoDBCfgTempItem", d, **kwargs)
        return apis.GetUMongoDBCfgTempItemResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def get_umon_go_db_recover_time_range(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ GetUMongoDBRecoverTimeRange - 获取UMongoDB可回档时间范围

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 集群id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **EarliestTime** (int) - 最早可回档时间点
        - **LatestTime** (int) - 最晚可回档时间点
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.GetUMongoDBRecoverTimeRangeRequestSchema().dumps(d)
        
        resp = self.invoke("GetUMongoDBRecoverTimeRange", d, **kwargs)
        return apis.GetUMongoDBRecoverTimeRangeResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def list_umon_go_db_backup(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ ListUMongoDBBackup - 拉取实例备份列表

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **DataSet** (list) - 见 **BackupInfo** 模型定义
        - **Message** (str) - 错误信息
        
        **Response Model**
        
        **BackupInfo** 
        - **BackupId** (str) - 备份ID
        - **BackupName** (str) - 备份名称
        - **BackupSize** (int) - 备份数据大小
        - **BackupType** (str) - 备份类型
        - **ClusterId** (str) - 实例ID
        - **EndTime** (int) - 备份结束时间
        - **StartTime** (int) - 备份开始时间
        - **State** (str) - 备份状态
        

        """
        # build request
        d = {
            'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.ListUMongoDBBackupRequestSchema().dumps(d)
        
        resp = self.invoke("ListUMongoDBBackup", d, **kwargs)
        return apis.ListUMongoDBBackupResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def list_umon_go_db_config_template(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ ListUMongoDBConfigTemplate - 拉取配置模板

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **DataSet** (list) - 见 **ConfigTemplate** 模型定义
        - **Message** (str) - 错误信息
        
        **Response Model**
        
        **ConfigTemplate** 
        - **ClusterType** (str) - 集群类型
        - **CreateTime** (int) - 创建时间
        - **DeleteTime** (int) - 删除时间
        - **Description** (str) - 模板描述
        - **ModifyTime** (int) - 修改时间
        - **MongodbVersion** (str) - mongo版本
        - **TemplateId** (str) - 模板ID
        - **TemplateName** (str) - 模板名称
        - **TemplateType** (str) - 模板类型 UsersTemplate DefaultTemplate
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.ListUMongoDBConfigTemplateRequestSchema().dumps(d)
        
        resp = self.invoke("ListUMongoDBConfigTemplate", d, **kwargs)
        return apis.ListUMongoDBConfigTemplateResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def list_umon_go_db_machine_type(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ ListUMongoDBMachineType - 获取UmongDB支持机器类型列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **DataSet** (list) - 见 **MongodbMachineType** 模型定义
        
        **Response Model**
        
        **MongodbMachineType** 
        - **Cpu** (int) - cpu核数
        - **Description** (str) - 配置简称  2C4G
        - **Group** (str) - 配置分组，2m , 4m
        - **MachineTypeId** (str) - 机器类型ID o.mongo2m.medium，o.mongo2m.xlarge
        - **Memory** (int) - 内存用量(GB)
        - **UHhostMachineType** (str) - 机器类型，N/O
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.ListUMongoDBMachineTypeRequestSchema().dumps(d)
        
        resp = self.invoke("ListUMongoDBMachineType", d, **kwargs)
        return apis.ListUMongoDBMachineTypeResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def list_umon_go_db_version(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ ListUMongoDBVersion - 获取UMongoDB支持版本列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **DataSet** (list) - 见 **MongoDBVersion** 模型定义
        
        **Response Model**
        
        **MongoDBVersion** 
        - **DBVersion** (str) - MongoDB版本
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.ListUMongoDBVersionRequestSchema().dumps(d)
        
        resp = self.invoke("ListUMongoDBVersion", d, **kwargs)
        return apis.ListUMongoDBVersionResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def modify_umon_go_db_admin_password(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ ModifyUMongoDBAdminPassword - 修改MongoDB集群root密码

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 集群ID
        - **Password** (str) - (Required) 集群新密码(密码格式使用BASE64编码)
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **Message** (str) - 错误信息
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.ModifyUMongoDBAdminPasswordRequestSchema().dumps(d)
        
        resp = self.invoke("ModifyUMongoDBAdminPassword", d, **kwargs)
        return apis.ModifyUMongoDBAdminPasswordResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def modify_umon_go_db_attribute(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ ModifyUMongoDBAttribute - 修改MongoDB集群名称

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 集群id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **Name** (str) - 集群新名称(输入长度为6~63位名称)
        - **RemarkName** (str) - 集群备注(Name和RemarkName必传其一)
        
        **Response**

        - **Message** (str) - 返回错误信息
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.ModifyUMongoDBAttributeRequestSchema().dumps(d)
        
        resp = self.invoke("ModifyUMongoDBAttribute", d, **kwargs)
        return apis.ModifyUMongoDBAttributeResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def modify_umon_go_db_backup_param(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ ModifyUMongoDBBackupParam - 修改实例备份策略

        **Request**

        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **AutoBackupToggleTime** (str) - 自动备份预期开始时间范围(00:00~23:59),默认 5:00~6:00
        - **AutoBackupToggleWeek** (str) - 自动备份预期星期几(1～7),默认 3,7 (周三，周日)
        
        **Response**

        - **Message** (str) - 错误信息
        
        """
        # build request
        d = {
            'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.ModifyUMongoDBBackupParamRequestSchema().dumps(d)
        
        resp = self.invoke("ModifyUMongoDBBackupParam", d, **kwargs)
        return apis.ModifyUMongoDBBackupParamResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def restart_umon_go_db_cluster(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ RestartUMongoDBCluster - 重启集群

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 集群ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **ClusterId** (str) - 集群ID
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.RestartUMongoDBClusterRequestSchema().dumps(d)
        
        resp = self.invoke("RestartUMongoDBCluster", d, **kwargs)
        return apis.RestartUMongoDBClusterResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def start_umon_go_db_cluster(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ StartUMongoDBCluster - 启动集群

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 集群ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **ClusterId** (str) - 集群ID
        - **Message** (str) - 错误信息
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.StartUMongoDBClusterRequestSchema().dumps(d)
        
        resp = self.invoke("StartUMongoDBCluster", d, **kwargs)
        return apis.StartUMongoDBClusterResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def stop_umon_go_db_cluster(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ StopUMongoDBCluster - 停止集群

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **ClusterId** (str) - (Required) 集群ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **ClusterId** (str) - 集群ID
        - **Message** (str) - 错误信息
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.StopUMongoDBClusterRequestSchema().dumps(d)
        
        resp = self.invoke("StopUMongoDBCluster", d, **kwargs)
        return apis.StopUMongoDBClusterResponseSchema().loads(resp)
    


