""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing




from ucloud.core.client import Client
from ucloud.services.usms.schemas import apis









class USMSClient(Client):
    def __init__(self, config: dict, transport=None, middleware=None, logger=None):
        super(USMSClient, self).__init__(config, transport, middleware, logger)

    
    
    
    
    
    
    
    def create_usms_signature(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ CreateUSMSSignature - 调用接口CreateUSMSSignature申请短信签名

        **Request**

        - **ProjectId** (str) - (Config) 项目ID，不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **CertificateType** (int) - (Required) 签名的资质证明文件类型，需与签名类型保持一致，说明如下：0-三证合一/企业营业执照/组织机构代码证书/社会信用代码证书；1-应用商店后台开发者管理截图；2-备案服务商的备案成功截图(含域名，网站名称，备案号)；3-公众号或小程序的管理界面截图；4-商标注册证书；5-组织机构代码证书、社会信用代码证书；
        - **Description** (str) - (Required) 短信签名申请原因
        - **File** (str) - (Required) 短信签名的资质证明文件，需先进行base64编码格式转换，此处填写转换后的字符串。文件大小不超过4 MB
        - **SigContent** (str) - (Required) 签名内容
        - **SigPurpose** (int) - (Required) 签名用途，0-自用，1-他用；
        - **SigType** (int) - (Required) 签名类型，说明如下：0-公司或企业的全称或简称；1-App应用的全称或简称；2-工信部备案网站的全称或简称；3-公众号或小程序的全称或简称；4-商标名的全称或简称；5-政府/机关事业单位/其他单位的全称或简称；
        - **International** (bool) - 国内/国际短信。true:国际短信，false:国内短信，若不传值则默认该值为false
        - **ProxyFile** (str) - 短信签名授权委托文件，需先进行base64编码格式转换，此处填写转换后的字符串。文件大小不超过4 MB；当您是代理并使用第三方的签名时（也即SigPurpose为1-他用），该项为必填项；
        
        **Response**

        - **Message** (str) - 返回状态码描述，如果操作成功，默认返回为空
        - **SigId** (str) - 短信签名ID（短信签名申请时的工单ID）
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 
        }
        req and d.update(req)
        d = apis.CreateUSMSSignatureRequestSchema().dumps(d)
        
        # build options
        kwargs['max_retries'] = 0 # ignore retry when api is not idempotent
        
        resp = self.invoke("CreateUSMSSignature", d, **kwargs)
        return apis.CreateUSMSSignatureResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def create_usms_template(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ CreateUSMSTemplate - 调用接口CreateUSMSTemplate申请短信模板

        **Request**

        - **ProjectId** (str) - (Config) 项目ID，不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **Purpose** (int) - (Required) 短信模板用途类型：1-验证码类短信模板；2-系统通知类短信模板；3-会员推广类短信模板；
        - **Template** (str) - (Required) 短信模板内容，说明如下：字数不超过500，每个中文、符号、英文、数组等都计为一个字；模板中的变量填写格式：{N}，其中N为大于1的整数，有多个参数时，建议N从1开始顺次，例如：{1}、{2}等；短信模板禁止仅包括变量的情况；
        - **TemplateName** (str) - (Required) 短信模板名称，不超过32个字符，每个中文、符号、英文、数字等都计为1个字。
        - **Instruction** (str) - 模板变量属性说明
        - **International** (bool) - 标记是否为国际短信。true:国际短信，false:国内短信，若不传值则默认该值为false
        - **Remark** (str) - 短信模板申请原因说明，字数不超过128，每个中文、符号、英文、数字等都计为1个字。
        - **UnsubscribeInfo** (str) - 当Purpose为3时，也即会员推广类短信模板，该项必填。枚举值：TD退订、回T退订、回N退订、回TD退订、退订回T、退订回D、退订回TD、退订回复T、退订回复D、退订回复N、退订回复TD、拒收回T
        
        **Response**

        - **Message** (str) - 返回状态码描述，如果操作成功，默认返回为空
        - **TemplateId** (str) - 短信模板ID（短信模板申请时的工单ID）
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.CreateUSMSTemplateRequestSchema().dumps(d)
        
        # build options
        kwargs['max_retries'] = 0 # ignore retry when api is not idempotent
        
        resp = self.invoke("CreateUSMSTemplate", d, **kwargs)
        return apis.CreateUSMSTemplateResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def delete_usms_signature(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ DeleteUSMSSignature - 调用接口DeleteUSMSSignature删除短信签名

        **Request**

        - **ProjectId** (str) - (Config) 项目ID，不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **SigIds** (list) - (Required) 签名ID（也即短信签名申请时的工单ID），支持以数组的方式，举例，以SigIds.0、SigIds.1...SigIds.N方式传入
        
        **Response**

        - **Message** (str) - 返回状态码描述，如果操作成功，默认返回为空
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 
        }
        req and d.update(req)
        d = apis.DeleteUSMSSignatureRequestSchema().dumps(d)
        
        resp = self.invoke("DeleteUSMSSignature", d, **kwargs)
        return apis.DeleteUSMSSignatureResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def delete_usms_template(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ DeleteUSMSTemplate - 调用接口DeleteUSMSTemplate删除短信模板

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_ 
        - **TemplateIds** (list) - (Required) 模板ID（也即短信模板申请时的工单ID），支持以数组的方式，举例，以TemplateIds.0、TemplateIds.1...TemplateIds.N方式传入
        
        **Response**

        - **Message** (str) - 返回状态码描述，如果操作成功，默认返回为空
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.DeleteUSMSTemplateRequestSchema().dumps(d)
        
        resp = self.invoke("DeleteUSMSTemplate", d, **kwargs)
        return apis.DeleteUSMSTemplateResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def get_usms_send_receipt(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ GetUSMSSendReceipt - 调用接口GetUSMSSendReceipt短信发送状态信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **SessionNoSet** (list) - (Required) 发送短信时返回的SessionNo集合，SessionNoSet.0,SessionNoSet.1....格式，单次调用集合数需控制在100个以内
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        
        **Response**

        - **Data** (list) - 见 **ReceiptPerSession** 模型定义
        - **Message** (str) - 错误描述
        
        **Response Model**
        
        **ReceiptPerSession** 
        - **ReceiptSet** (list) - 见 **ReceiptPerPhone** 模型定义
        - **SessionNo** (str) - 发送短信时返回的SessionNo
        

        **ReceiptPerPhone** 
        - **CostCount** (int) - 消耗短信条数
        - **Phone** (str) - 手机号码
        - **ReceiptCode** (str) - 状态报告编码
        - **ReceiptDesc** (str) - 回执结果描述
        - **ReceiptResult** (str) - 回执结果，枚举值：\\ > 发送成功: 代表成功 \\ > Success: 代表成功 \\ > 发送失败: 代表失败 \\ > Fail: 代表失败 \\ > 状态未知: 代表未知 \\ > Unknow: 代表未知
        - **ReceiptTime** (int) - 回执返回时间
        - **UserId** (str) - 自定义的业务标识ID，字符串
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.GetUSMSSendReceiptRequestSchema().dumps(d)
        
        resp = self.invoke("GetUSMSSendReceipt", d, **kwargs)
        return apis.GetUSMSSendReceiptResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def query_usms_signature(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ QueryUSMSSignature - 调用接口QueryUSMSSignature查询短信签名申请状态

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **SigContent** (str) - 签名内容；签名ID和签名至少需填写1项；
        - **SigId** (str) - 已申请的短信签名ID（短信签名申请时的工单ID）；签名ID和签名至少需填写1项；
        
        **Response**

        - **Data** (dict) - 见 **OutSignature** 模型定义
        - **Message** (str) - 发生错误时，表示具体错误描述
        
        **Response Model**
        
        **OutSignature** 
        - **ErrDesc** (str) - 签名审核失败原因
        - **SigContent** (str) - 签名内容
        - **SigId** (str) - 签名ID
        - **Status** (int) - 签名状态。0-待审核 1-审核中 2-审核通过 3-审核未通过 4-被禁用
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 
        }
        req and d.update(req)
        d = apis.QueryUSMSSignatureRequestSchema().dumps(d)
        
        resp = self.invoke("QueryUSMSSignature", d, **kwargs)
        return apis.QueryUSMSSignatureResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def query_usms_template(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ QueryUSMSTemplate - 调用接口QueryUSMSTemplate查询短信模板申请状态

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **TemplateId** (str) - (Required) 模板ID
        
        **Response**

        - **Data** (dict) - 见 **OutTemplate** 模型定义
        - **Message** (str) - 当RetCode不为0时，Message中显示具体错误描述
        
        **Response Model**
        
        **OutTemplate** 
        - **CreateTime** (int) - 创建时间
        - **ErrDesc** (str) - 审核失败原因
        - **Instruction** (str) - 模板变量属性说明
        - **Purpose** (int) - 模板类型，选项：1-验证码类 2-通知类 3-会员推广类
        - **Remark** (str) - 模板说明
        - **Status** (int) - 短信模板状态；状态说明：0-待审核，1-审核中，2-审核通过，3-审核未通过，4-被禁用
        - **Template** (str) - 短信模板内容
        - **TemplateId** (str) - 短信模板ID
        - **TemplateName** (str) - 短信模板名称
        - **UnsubscribeInfo** (str) - 退订信息；一般填写方式“回T退订”，当purpose为3（也即会员推广类）时，为必填项
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 
        }
        req and d.update(req)
        d = apis.QueryUSMSTemplateRequestSchema().dumps(d)
        
        resp = self.invoke("QueryUSMSTemplate", d, **kwargs)
        return apis.QueryUSMSTemplateResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def send_batch_usms_message(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ SendBatchUSMSMessage - 调用SendBatchUSMSMessage接口批量发送短信

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **TaskContent** (str) - (Required) 批量发送内容，该参数是json数组的base64编码结果。发送内容json数组中，每个“模板+签名”组合作为一个子项，每个子项内支持多个号码，示例：发送内容json数组（base64编码前）：[{"TemplateId": "UTA20212831C85C", "SigContent": "UCloud", "Target": [{"TemplateParams": ["123456"], "Phone": "18500000123", "ExtendCode": "123", "UserId": "456"} ] } ]   。json数组中各参数的定义："TemplateId":模板ID，"SigContent"短信签名内容，"Target"具体到号码粒度的发送内容。"Target"中的具体字段有："TemplateParams"实际发送的模板参数（若使用的是无参数模板，该参数不能传值），"Phone"手机号码, "ExtendCode"短信扩展码, "UserId"自定义业务标识ID。其中必传参数为"TemplateId", "SigContent", "Target"（"Target"中必传参数为"Phone"）。实际调用本接口时TaskContent传值（发送内容base64编码后）为：W3siVGVtcGxhdGVJZCI6ICJVVEEyMDIxMjgzMUM4NUMiLCAiU2lnQ29udGVudCI6ICJVQ2xvdWQiLCAiVGFyZ2V0IjogW3siVGVtcGxhdGVQYXJhbXMiOiBbIjEyMzQ1NiJdLCAiUGhvbmUiOiAiMTg1MDAwMDAxMjMiLCAiRXh0ZW5kQ29kZSI6ICIxMjMiLCAiVXNlcklkIjogIjQ1NiJ9IF0gfSBdIA==
        
        **Response**

        - **FailContent** (list) - 见 **BatchInfo** 模型定义
        - **Message** (str) - 发生错误时表示错误描述
        - **ReqUuid** (str) - 本次请求Uuid
        - **SessionNo** (str) - 本次提交发送任务的唯一ID，可根据该值查询本次发送的短信列表。注：成功提交短信数大于0时，才返回该字段
        - **SuccessCount** (int) - 成功提交短信（未拆分）条数
        
        **Response Model**
        
        **BatchInfo** 
        - **FailureDetails** (str) - 未能成功发送的详情。注：模板/签名检验失败时，该字段有效
        - **SigContent** (str) - 签名
        - **Target** (list) - 见 **FailPhoneDetail** 模型定义
        - **TemplateId** (str) - 模板ID
        

        **FailPhoneDetail** 
        - **ExtendCode** (str) - 扩展号码
        - **FailureDetails** (str) - 发送失败原因。注：若模板/签名校验失败，该字段为空
        - **Phone** (str) - 手机号
        - **TemplateParams** (list) - 模板参数
        - **UserId** (str) - 用户自定义ID
        

        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.SendBatchUSMSMessageRequestSchema().dumps(d)
        
        # build options
        kwargs['max_retries'] = 0 # ignore retry when api is not idempotent
        
        resp = self.invoke("SendBatchUSMSMessage", d, **kwargs)
        return apis.SendBatchUSMSMessageResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def send_usms_message(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ SendUSMSMessage - 调用接口SendUSMSMessage发送短信

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **PhoneNumbers** (list) - (Required) 电话号码数组，电话号码格式为(60)1xxxxxxxx，()中为国际长途区号(如中国为86或0086，两种格式都支持)，后面为电话号码.若不传入国际区号，如1851623xxxx，则默认为国内手机号
        - **TemplateId** (str) - (Required) 模板ID（也即短信模板申请时的工单ID），请到 `USMS控制台 <https://console.ucloud.cn/usms>`_ 的模板管理页面查看；使用的短信模板必须是已申请并通过审核；
        - **ExtendCode** (str) - 短信扩展码，格式为阿拉伯数字串，默认不开通，如需开通请联系 UCloud技术支持
        - **SigContent** (str) - 短信签名内容，请到 `USMS控制台 <https://console.ucloud.cn/usms>`_ 的签名管理页面查看；使用的短信签名必须是已申请并且通过审核；
        - **TemplateParams** (list) - 模板可变参数，以数组的方式填写，举例，TemplateParams.0，TemplateParams.1，... 若模板中无可变参数，则该项可不填写；若模板中有可变参数，则该项为必填项，参数个数需与变量个数保持一致，否则无法发送；
        - **UserId** (str) - 自定义的业务标识ID，字符串（ 长度不能超过32 位），不支持 单引号、表情包符号等特殊字符
        
        **Response**

        - **Message** (str) - 发生错误时表示错误描述
        - **SessionNo** (str) - 本次提交发送的短信的唯一ID，可根据该值查询本次发送的短信列表
        - **UserId** (str) - 本次提交的自定义业务标识ID，仅当发送时传入有效的UserId，才返回该字段。
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.SendUSMSMessageRequestSchema().dumps(d)
        
        # build options
        kwargs['max_retries'] = 0 # ignore retry when api is not idempotent
        
        resp = self.invoke("SendUSMSMessage", d, **kwargs)
        return apis.SendUSMSMessageResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def update_usms_signature(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ UpdateUSMSSignature - 调用接口UpdateUSMSSignature修改未通过审核的短信签名，并重新提交审核

        **Request**

        - **ProjectId** (str) - (Config) 项目ID，不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **SigContent** (str) - (Required) 新的短信签名内容；长度为2-12个字符, 可包含中文、数字和符号；无需填写【】或[]，系统会自动添加
        - **SigId** (str) - (Required) 签名ID（也即短信签名申请时的工单ID），支持以数组的方式，举例，以SigIds.0、SigIds.1...SigIds.N方式传入
        - **SigPurpose** (int) - (Required) 签名用途，0-自用，1-他用；
        - **SigType** (int) - (Required) 签名类型，说明如下：0-公司或企业的全称或简称；1-App应用的全称或简称；2-工信部备案网站的全称或简称；3-公众号或小程序的全称或简称；4-商标名的全称或简称；5-政府/机关事业单位/其他单位的全称或简称；
        - **CertificateType** (int) - 签名的资质证明文件类型，需与签名类型保持一致，说明如下：0-三证合一/企业营业执照/组织机构代码证书/社会信用代码证书；1-应用商店后台开发者管理截图；2-备案服务商的备案成功截图(含域名，网站名称，备案号)；3-公众号或小程序的管理界面截图；4-商标注册证书；5-组织机构代码证书、社会信用代码证书；
        - **Document** (str) - 短信签名的资质证明文件URL，若未更改审核材料，则该处使用已上传审核材料的URL链接，否则使用File参数
        - **File** (str) - 短信签名的资质证明文件内容，需先进行base64编码格式转换，此处填写转换后的字符串。文件大小不超过4 MB。内容格式如下: [file type];[code type],[base64]  如：image/jpeg;base64,5YaF5a65
        - **ProxyDoc** (str) - 短信签名授权委托文件URL，若未更改授权委托文件，则该处填写已上传的授权委托文件的URL链接，否则使用ProxyFile参数
        - **ProxyFile** (str) - 短信签名授权委托文件内容，需先进行base64编码格式转换，此处填写转换后的字符串。文件大小不超过4 MB；当您是代理并使用第三方的签名时（也即SigPurpose为1-他用），该项为必填项；格式和File类似。
        
        **Response**

        - **Message** (str) - 返回状态码描述，如果操作成功，默认返回为空
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 
        }
        req and d.update(req)
        d = apis.UpdateUSMSSignatureRequestSchema().dumps(d)
        
        resp = self.invoke("UpdateUSMSSignature", d, **kwargs)
        return apis.UpdateUSMSSignatureResponseSchema().loads(resp)
    
    
    
    
    
    
    
    def update_usms_template(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ UpdateUSMSTemplate - 调用接口UpdateUSMSTemplate修改未通过审核的短信模板，并重新提交审核

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_ 
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_ 
        - **Template** (str) - (Required) 新的模板内容。模板名称和模板内容必须提供一个，否则会报错。小于等于600个字
        - **TemplateId** (str) - (Required) 短信模板ID
        - **Instruction** (str) - 模板变量属性说明
        - **Remark** (str) - 短信模板申请原因说明，字数不超过128，每个中文、符号、英文、数字等都计为1个字。
        - **TemplateName** (str) - 新的模板名称。小于等于32个字，每个中文、英文、数组、符合都计为一个字
        
        **Response**

        - **Message** (str) - 发生错误时表示错误描述
        
        """
        # build request
        d = {
            'ProjectId': self.config.project_id, 'Region': self.config.region, 
        }
        req and d.update(req)
        d = apis.UpdateUSMSTemplateRequestSchema().dumps(d)
        
        resp = self.invoke("UpdateUSMSTemplate", d, **kwargs)
        return apis.UpdateUSMSTemplateResponseSchema().loads(resp)
    


