""" Code is generated by ucloud-model, DO NOT EDIT IT. """


from ucloud.core.typesystem import schema, fields
from ucloud.services.uddb.schemas import models

""" UDDB API Schema
"""


"""
API: ChangeUDDBInstanceName

修改分布式数据库中间件名称
"""


class ChangeUDDBInstanceNameRequestSchema(schema.RequestSchema):
    """ChangeUDDBInstanceName - 修改分布式数据库中间件名称"""

    fields = {
        "NewName": fields.Str(required=True, dump_to="NewName"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ChangeUDDBInstanceNameResponseSchema(schema.ResponseSchema):
    """ChangeUDDBInstanceName - 修改分布式数据库中间件名称"""

    fields = {}


"""
API: ChangeUDDBSlaveCount

改变分布式数据库数据节点的只读实例个数
每一个UDDB的数据节点负责处理所有的写入请求。与此同时，每一个数据节点可以配置若干个该节点的只读实例。当主节点的数据写入完毕后，只读实例把这次的写入操作进行更新，从而和数据节点保持一致。
只读实例可以使得数据由多份复制，在数据节点和只读实例之间，可以做请求的读写分离, 也就是说, 主节点写入数据之后, 数据的读操作可以由数据只读实例进行分担, 这样减少主节点的压力, 增加性能
当改变了数据节点的只读实例个数之后，对于现有的和以后的每一个数据节点都采用这个配置。如果UDDB实例有现有的数据节点, 那么它会根据新配置的参数，自动创建或删除数据节点的只读实例
如下状态的UDDB实例可以进行这个操作:
Running: 系统正常运行中
当请求返回成功之后，UDDB实例的状态变成"ChangingSlaveCount"; 如果返回失败, UDDB实例状态保持不变 当UDDB更改数据分区的只读实例个数成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果更改过程中出现异常, 状态变成"Abnormal"(异常运行中)或者"Error"(运行错误)
"""


class ChangeUDDBSlaveCountRequestSchema(schema.RequestSchema):
    """ChangeUDDBSlaveCount - 改变分布式数据库数据节点的只读实例个数
    每一个UDDB的数据节点负责处理所有的写入请求。与此同时，每一个数据节点可以配置若干个该节点的只读实例。当主节点的数据写入完毕后，只读实例把这次的写入操作进行更新，从而和数据节点保持一致。
    只读实例可以使得数据由多份复制，在数据节点和只读实例之间，可以做请求的读写分离, 也就是说, 主节点写入数据之后, 数据的读操作可以由数据只读实例进行分担, 这样减少主节点的压力, 增加性能
    当改变了数据节点的只读实例个数之后，对于现有的和以后的每一个数据节点都采用这个配置。如果UDDB实例有现有的数据节点, 那么它会根据新配置的参数，自动创建或删除数据节点的只读实例
    如下状态的UDDB实例可以进行这个操作:
    Running: 系统正常运行中
    当请求返回成功之后，UDDB实例的状态变成"ChangingSlaveCount"; 如果返回失败, UDDB实例状态保持不变 当UDDB更改数据分区的只读实例个数成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果更改过程中出现异常, 状态变成"Abnormal"(异常运行中)或者"Error"(运行错误)
    """

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SlaveCount": fields.Str(required=True, dump_to="SlaveCount"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ChangeUDDBSlaveCountResponseSchema(schema.ResponseSchema):
    """ChangeUDDBSlaveCount - 改变分布式数据库数据节点的只读实例个数
    每一个UDDB的数据节点负责处理所有的写入请求。与此同时，每一个数据节点可以配置若干个该节点的只读实例。当主节点的数据写入完毕后，只读实例把这次的写入操作进行更新，从而和数据节点保持一致。
    只读实例可以使得数据由多份复制，在数据节点和只读实例之间，可以做请求的读写分离, 也就是说, 主节点写入数据之后, 数据的读操作可以由数据只读实例进行分担, 这样减少主节点的压力, 增加性能
    当改变了数据节点的只读实例个数之后，对于现有的和以后的每一个数据节点都采用这个配置。如果UDDB实例有现有的数据节点, 那么它会根据新配置的参数，自动创建或删除数据节点的只读实例
    如下状态的UDDB实例可以进行这个操作:
    Running: 系统正常运行中
    当请求返回成功之后，UDDB实例的状态变成"ChangingSlaveCount"; 如果返回失败, UDDB实例状态保持不变 当UDDB更改数据分区的只读实例个数成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果更改过程中出现异常, 状态变成"Abnormal"(异常运行中)或者"Error"(运行错误)
    """

    fields = {}


"""
API: CreateUDDBInstance

创建创建分布式数据库UDDB实例, 简称UDDB实例。
"""


class CreateUDDBInstanceRequestSchema(schema.RequestSchema):
    """CreateUDDBInstance - 创建创建分布式数据库UDDB实例, 简称UDDB实例。"""

    fields = {
        "AdminPassword": fields.Str(required=True, dump_to="AdminPassword"),
        "AdminUser": fields.Str(required=False, dump_to="AdminUser"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "DBTypeId": fields.Str(required=True, dump_to="DBTypeId"),
        "DataNodeCount": fields.Int(required=True, dump_to="DataNodeCount"),
        "DataNodeDiskSpace": fields.Int(
            required=True, dump_to="DataNodeDiskSpace"
        ),
        "DataNodeMemory": fields.Int(required=True, dump_to="DataNodeMemory"),
        "DataNodeSlaveCount": fields.Int(
            required=False, dump_to="DataNodeSlaveCount"
        ),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouterNodeNum": fields.Int(required=True, dump_to="RouterNodeNum"),
        "RouterVersion": fields.Str(required=True, dump_to="RouterVersion"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUDDBInstanceResponseSchema(schema.ResponseSchema):
    """CreateUDDBInstance - 创建创建分布式数据库UDDB实例, 简称UDDB实例。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "UDDBId": fields.Str(required=False, load_from="UDDBId"),
    }


"""
API: DeleteUDDBInstance

删除UDDB实例。
如下状态的UDDB实例可以进行这个操作:
InitFail: 初始化失败
Shutoff: 已关闭
当请求返回成功之后，UDDB实例就已经被删除, 列表上看不到对应的UDDB实例
"""


class DeleteUDDBInstanceRequestSchema(schema.RequestSchema):
    """DeleteUDDBInstance - 删除UDDB实例。
    如下状态的UDDB实例可以进行这个操作:
    InitFail: 初始化失败
    Shutoff: 已关闭
    当请求返回成功之后，UDDB实例就已经被删除, 列表上看不到对应的UDDB实例
    """

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteUDDBInstanceResponseSchema(schema.ResponseSchema):
    """DeleteUDDBInstance - 删除UDDB实例。
    如下状态的UDDB实例可以进行这个操作:
    InitFail: 初始化失败
    Shutoff: 已关闭
    当请求返回成功之后，UDDB实例就已经被删除, 列表上看不到对应的UDDB实例
    """

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DescribeUDDBInstance

获取分布式数据库UDDB的详细信息
"""


class DescribeUDDBInstanceRequestSchema(schema.RequestSchema):
    """DescribeUDDBInstance - 获取分布式数据库UDDB的详细信息"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDDBInstanceResponseSchema(schema.ResponseSchema):
    """DescribeUDDBInstance - 获取分布式数据库UDDB的详细信息"""

    fields = {
        "DataSet": fields.List(
            models.DataSetUDDBSchema(), required=False, load_from="DataSet"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DescribeUDDBInstancePrice

获取分布式数据库UDDB价格
"""


class DescribeUDDBInstancePriceRequestSchema(schema.RequestSchema):
    """DescribeUDDBInstancePrice - 获取分布式数据库UDDB价格"""

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "DataNodeCount": fields.Int(required=True, dump_to="DataNodeCount"),
        "DataNodeDiskSpace": fields.Int(
            required=True, dump_to="DataNodeDiskSpace"
        ),
        "DataNodeMemory": fields.Str(required=True, dump_to="DataNodeMemory"),
        "DataNodeSlaveCount": fields.Int(
            required=False, dump_to="DataNodeSlaveCount"
        ),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouterNodeNum": fields.Int(required=True, dump_to="RouterNodeNum"),
        "RouterVersion": fields.Str(required=True, dump_to="RouterVersion"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDDBInstancePriceResponseSchema(schema.ResponseSchema):
    """DescribeUDDBInstancePrice - 获取分布式数据库UDDB价格"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "PriceInfo": models.PriceDetailInfoSchema(),
    }


"""
API: DescribeUDDBInstanceUpgradePrice

升级UDDB时，获取升级后的价格
"""


class DescribeUDDBInstanceUpgradePriceRequestSchema(schema.RequestSchema):
    """DescribeUDDBInstanceUpgradePrice - 升级UDDB时，获取升级后的价格"""

    fields = {
        "DataNodeCount": fields.Int(required=False, dump_to="DataNodeCount"),
        "DataNodeDiskSpace": fields.Int(
            required=False, dump_to="DataNodeDiskSpace"
        ),
        "DataNodeMemory": fields.Int(required=False, dump_to="DataNodeMemory"),
        "DataNodeSlaveCount": fields.Int(
            required=False, dump_to="DataNodeSlaveCount"
        ),
        "InstanceMode": fields.Str(required=False, dump_to="InstanceMode"),
        "InstanceType": fields.Str(required=False, dump_to="InstanceType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouterNodeNum": fields.Int(required=True, dump_to="RouterNodeNum"),
        "RouterVersion": fields.Str(required=True, dump_to="RouterVersion"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUDDBInstanceUpgradePriceResponseSchema(schema.ResponseSchema):
    """DescribeUDDBInstanceUpgradePrice - 升级UDDB时，获取升级后的价格"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "PriceInfo": models.PriceInfoSchema(),
    }


"""
API: RestartUDDBInstance

重启UDDB实例，开始提供服务。

如下状态的UDDB实例可以进行这个操作:

Running: 正常运行中
Abnormal: 异常运行中
当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在重启过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭
"""


class RestartUDDBInstanceRequestSchema(schema.RequestSchema):
    """RestartUDDBInstance - 重启UDDB实例，开始提供服务。

    如下状态的UDDB实例可以进行这个操作:

    Running: 正常运行中
    Abnormal: 异常运行中
    当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在重启过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭
    """

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RestartUDDBInstanceResponseSchema(schema.ResponseSchema):
    """RestartUDDBInstance - 重启UDDB实例，开始提供服务。

    如下状态的UDDB实例可以进行这个操作:

    Running: 正常运行中
    Abnormal: 异常运行中
    当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在重启过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭
    """

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: StartUDDBInstance

启动UDDB实例，开始提供服务。

如下状态的UDDB实例可以进行这个操作:

Shutoff: 已关闭
当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在启动过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭)
"""


class StartUDDBInstanceRequestSchema(schema.RequestSchema):
    """StartUDDBInstance - 启动UDDB实例，开始提供服务。

    如下状态的UDDB实例可以进行这个操作:

    Shutoff: 已关闭
    当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在启动过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭)
    """

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class StartUDDBInstanceResponseSchema(schema.ResponseSchema):
    """StartUDDBInstance - 启动UDDB实例，开始提供服务。

    如下状态的UDDB实例可以进行这个操作:

    Shutoff: 已关闭
    当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在启动过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭)
    """

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: StopUDDBInstance

关闭UDDB实例，停止提供服务。

如下状态的UDDB实例可以进行这个操作:

Running: 正常运行中
Abnormal: 异常运行中
当请求返回成功之后，UDDB实例的状态变成"Shutdown"(关闭中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在关闭过程中, 当UDDB实例关闭成功之后, UDDB实例的状态变成"Shutoff"(已关闭); 如果关闭过程中出现异常, 根据UDDB实例的情况, 状态变成"Abnormal"(异常运行中), 或者"Running"(正常运行中)
"""


class StopUDDBInstanceRequestSchema(schema.RequestSchema):
    """StopUDDBInstance - 关闭UDDB实例，停止提供服务。

    如下状态的UDDB实例可以进行这个操作:

    Running: 正常运行中
    Abnormal: 异常运行中
    当请求返回成功之后，UDDB实例的状态变成"Shutdown"(关闭中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在关闭过程中, 当UDDB实例关闭成功之后, UDDB实例的状态变成"Shutoff"(已关闭); 如果关闭过程中出现异常, 根据UDDB实例的情况, 状态变成"Abnormal"(异常运行中), 或者"Running"(正常运行中)
    """

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class StopUDDBInstanceResponseSchema(schema.ResponseSchema):
    """StopUDDBInstance - 关闭UDDB实例，停止提供服务。

    如下状态的UDDB实例可以进行这个操作:

    Running: 正常运行中
    Abnormal: 异常运行中
    当请求返回成功之后，UDDB实例的状态变成"Shutdown"(关闭中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在关闭过程中, 当UDDB实例关闭成功之后, UDDB实例的状态变成"Shutoff"(已关闭); 如果关闭过程中出现异常, 根据UDDB实例的情况, 状态变成"Abnormal"(异常运行中), 或者"Running"(正常运行中)
    """

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpgradeUDDBDataNode

升降级分布式数据库数据节点的配置, 提高/降低数据节点的数据容量和内存

所有数据节点以及其所挂载的只读实例的配置都受到影响

升降级数据节点的配置之后之后, 会按照数据节点新的磁盘和内存大小重新计费

如下状态的数据节点实例可以进行这个操作:

Shutoff: 已关闭
当请求返回成功之后，UDDB实例的状态变成"UpgradingDataNode"，相关数据节点的状态变成"Upgrading"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级结束之后, UDDB实例的状态变成"Shutoff"
"""


class UpgradeUDDBDataNodeRequestSchema(schema.RequestSchema):
    """UpgradeUDDBDataNode - 升降级分布式数据库数据节点的配置, 提高/降低数据节点的数据容量和内存

    所有数据节点以及其所挂载的只读实例的配置都受到影响

    升降级数据节点的配置之后之后, 会按照数据节点新的磁盘和内存大小重新计费

    如下状态的数据节点实例可以进行这个操作:

    Shutoff: 已关闭
    当请求返回成功之后，UDDB实例的状态变成"UpgradingDataNode"，相关数据节点的状态变成"Upgrading"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级结束之后, UDDB实例的状态变成"Shutoff"
    """

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "DataNodeDiskSpace": fields.Int(
            required=True, dump_to="DataNodeDiskSpace"
        ),
        "DataNodeMemory": fields.Int(required=True, dump_to="DataNodeMemory"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class UpgradeUDDBDataNodeResponseSchema(schema.ResponseSchema):
    """UpgradeUDDBDataNode - 升降级分布式数据库数据节点的配置, 提高/降低数据节点的数据容量和内存

    所有数据节点以及其所挂载的只读实例的配置都受到影响

    升降级数据节点的配置之后之后, 会按照数据节点新的磁盘和内存大小重新计费

    如下状态的数据节点实例可以进行这个操作:

    Shutoff: 已关闭
    当请求返回成功之后，UDDB实例的状态变成"UpgradingDataNode"，相关数据节点的状态变成"Upgrading"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级结束之后, UDDB实例的状态变成"Shutoff"
    """

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpgradeUDDBInstance

升降级分布式数据库中间件的配置, 提高/降低请求处理的并发性

修改请求处理节点个数之后, 按照所有请求处理节点的总内存容量和CPU核数重新计费

如下状态的UDDB实例可以进行这个操作:

Running: 系统正常运行中
当请求返回成功之后，UDDB实例的状态变成"UpgradingUDDB"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级成功之后, UDDB实例的状态变成"Running"; 如果更改过程中出现异常, 状态变成"Abnormal", 或者"Error"
"""


class UpgradeUDDBInstanceRequestSchema(schema.RequestSchema):
    """UpgradeUDDBInstance - 升降级分布式数据库中间件的配置, 提高/降低请求处理的并发性

    修改请求处理节点个数之后, 按照所有请求处理节点的总内存容量和CPU核数重新计费

    如下状态的UDDB实例可以进行这个操作:

    Running: 系统正常运行中
    当请求返回成功之后，UDDB实例的状态变成"UpgradingUDDB"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级成功之后, UDDB实例的状态变成"Running"; 如果更改过程中出现异常, 状态变成"Abnormal", 或者"Error"
    """

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouterNodeNum": fields.Int(required=True, dump_to="RouterNodeNum"),
        "RouterVersion": fields.Str(required=True, dump_to="RouterVersion"),
        "UDDBId": fields.Str(required=True, dump_to="UDDBId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class UpgradeUDDBInstanceResponseSchema(schema.ResponseSchema):
    """UpgradeUDDBInstance - 升降级分布式数据库中间件的配置, 提高/降低请求处理的并发性

    修改请求处理节点个数之后, 按照所有请求处理节点的总内存容量和CPU核数重新计费

    如下状态的UDDB实例可以进行这个操作:

    Running: 系统正常运行中
    当请求返回成功之后，UDDB实例的状态变成"UpgradingUDDB"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级成功之后, UDDB实例的状态变成"Running"; 如果更改过程中出现异常, 状态变成"Abnormal", 或者"Error"
    """

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }
