""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.cube.schemas import apis


class CubeClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(CubeClient, self).__init__(config, transport, middleware, logger)

    def create_cube_deployment(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateCubeDeployment - 创建容器实例Deployment

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Deployment** (str) - (Required) Deployment yaml，使用base64编码
        - **SubnetId** (str) - (Required) Deployment所属子网
        - **VPCId** (str) - (Required) Deployment所属VPC
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ChargeType** (str) - 计费模式
        - **CpuPlatform** (str) - CPU平台
        - **Name** (str) - Deployment名称
        - **Quantity** (str) - 数量，默认为1
        - **Tag** (str) - 标签

        **Response**

        - **Deployment** (str) - Deployment yaml，使用base64编码
        - **DeploymentId** (str) - Deployment ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateCubeDeploymentRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateCubeDeployment", d, **kwargs)
        return apis.CreateCubeDeploymentResponseSchema().loads(resp)

    def create_cube_pod(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateCubePod - 创建一个容器实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Pod** (str) - (Required) Pod yaml，使用base64编码
        - **SubnetId** (str) - (Required) 容器实例所属的子网ID
        - **VPCId** (str) - (Required) 容器实例所属的VPC ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **CubeId** (str) - 容器实例ID
        - **Pod** (str) - Pod yaml，使用base64编码

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateCubePodRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateCubePod", d, **kwargs)
        return apis.CreateCubePodResponseSchema().loads(resp)

    def delete_cube_deployment(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteCubeDeployment - 删除容器实例Deployment

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DeploymentId** (str) - (Required)

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteCubeDeploymentRequestSchema().dumps(d)

        resp = self.invoke("DeleteCubeDeployment", d, **kwargs)
        return apis.DeleteCubeDeploymentResponseSchema().loads(resp)

    def delete_cube_pod(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteCubePod - 删除容器实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CubeId** (str) - 要删除的容器实例ID，若填写了Uid则可忽略
        - **ReleaseEIP** (str) - 要释放的EIP，如果容器实例绑定了EIP则可以填写，会将EIP一并释放。否则EIP会被保留。
        - **Uid** (str) - 要删除的容器实例UID，若填写了CubeId则可忽略

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteCubePodRequestSchema().dumps(d)

        resp = self.invoke("DeleteCubePod", d, **kwargs)
        return apis.DeleteCubePodResponseSchema().loads(resp)

    def get_cube_deployment(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetCubeDeployment - 获取容器实例Deployment详细信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DeploymentId** (str) - (Required) Deployment ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **Deployment** (str) - Deployment yaml，使用base64编码

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetCubeDeploymentRequestSchema().dumps(d)

        resp = self.invoke("GetCubeDeployment", d, **kwargs)
        return apis.GetCubeDeploymentResponseSchema().loads(resp)

    def get_cube_exec_token(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetCubeExecToken - 获取容器实例执行token

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ContainerName** (str) - (Required) 要执行的容器名称
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CubeId** (str) - 容器实例ID，若填写了Uid则可忽略
        - **Uid** (str) - 容器实例UID，若填写了CubeId则可忽略

        **Response**

        - **TerminalUrl** (str) - 终端url
        - **Token** (str) - 执行Token

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetCubeExecTokenRequestSchema().dumps(d)

        resp = self.invoke("GetCubeExecToken", d, **kwargs)
        return apis.GetCubeExecTokenResponseSchema().loads(resp)

    def get_cube_extend_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetCubeExtendInfo - 获取容器实例附加信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CubeIds** (str) - 容器实例ID，用逗号分割

        **Response**

        - **ExtendInfo** (list) - 见 **CubeExtendInfo** 模型定义

        **Response Model**

        **CubeExtendInfo**
        - **CubeId** (str) - Cube的Id
        - **Eip** (list) - 见 **EIPSet** 模型定义
        - **Expiration** (int) - 资源有效期
        - **Name** (str) - Cube的名称
        - **Tag** (str) - 业务组名称


        **EIPSet**
        - **Bandwidth** (int) - EIP带宽值
        - **BandwidthType** (int) - 带宽类型0标准普通带宽，1表示共享带宽
        - **CreateTime** (int) - EIP创建时间
        - **EIPAddr** (list) - 见 **EIPAddr** 模型定义
        - **EIPId** (str) - EIPId
        - **PayMode** (str) - 付费模式，带宽付费或者流量付费
        - **Resource** (str) - EIP绑定对象的资源Id
        - **Status** (str) - EIP状态，表示使用中或者空闲
        - **Weight** (int) - EIP权重


        **EIPAddr**
        - **IP** (str) - IP地址
        - **OperatorName** (str) - 线路名称BGP或者internalation


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetCubeExtendInfoRequestSchema().dumps(d)

        resp = self.invoke("GetCubeExtendInfo", d, **kwargs)
        return apis.GetCubeExtendInfoResponseSchema().loads(resp)

    def get_cube_metrics(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetCubeMetrics - 获取容器实例指标

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **BeginTime** (str) - (Required) 开始时间
        - **ContainerName** (str) - (Required) 容器名称
        - **EndTime** (str) - (Required) 结束时间
        - **MetricName** (str) - (Required) 指标名称
        - **ResourceId** (str) - (Required) 资源ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_

        **Response**

        - **DataSets** (list) - 见 **MetricDataSet** 模型定义

        **Response Model**

        **MetricDataSet**
        - **MetricName** (str) -
        - **Values** (list) - 见 **ValueSet** 模型定义


        **ValueSet**
        - **Timestamp** (int) -
        - **Value** (float) -


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetCubeMetricsRequestSchema().dumps(d)

        resp = self.invoke("GetCubeMetrics", d, **kwargs)
        return apis.GetCubeMetricsResponseSchema().loads(resp)

    def get_cube_pod(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """GetCubePod -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **CubeId** (str) -
        - **Uid** (str) -
        - **Zone** (str) -

        **Response**

        - **Pod** (str) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetCubePodRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("GetCubePod", d, **kwargs)
        return apis.GetCubePodResponseSchema().loads(resp)

    def get_cube_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetCubePrice -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **ChargeType** (str) - (Required)
        - **Count** (str) - (Required)
        - **Cpu** (str) - (Required)
        - **Mem** (str) - (Required)
        - **Quantity** (int) - (Required)
        - **Zone** (str) - (Required)

        **Response**

        - **OriginalPrice** (int) -
        - **Price** (int) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetCubePriceRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("GetCubePrice", d, **kwargs)
        return apis.GetCubePriceResponseSchema().loads(resp)

    def get_cube_token(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetCubeToken - 获取容器实例Token

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **ContainerName** (str) - (Required) 容器名称
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CubeId** (str) - 容器实例ID，若填写了Uid则可忽略
        - **Uid** (str) - 容器实例UID，若填写了CubeId则可忽略

        **Response**

        - **Token** (str) - 容器实例Token

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.GetCubeTokenRequestSchema().dumps(d)

        resp = self.invoke("GetCubeToken", d, **kwargs)
        return apis.GetCubeTokenResponseSchema().loads(resp)

    def list_cube_deployment(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ListCubeDeployment -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **Limit** (int) - (Required)
        - **Offset** (int) - (Required)
        - **Zone** (str) -

        **Response**

        - **Deployments** (list) -
        - **TotalCount** (int) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ListCubeDeploymentRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("ListCubeDeployment", d, **kwargs)
        return apis.ListCubeDeploymentResponseSchema().loads(resp)

    def list_cube_pod(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ListCubePod - 获取容器实例详细列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **DeploymentId** (str) - 容器实例所属Deployment
        - **Group** (str) - 容器实例组
        - **Limit** (int) - 返回数据长度，默认为20，最大100
        - **Offset** (int) - 列表起始位置偏移量，默认为0
        - **SubnetId** (str) - 容器实例所属子网
        - **VPCId** (str) - 容器实例所属VPC

        **Response**

        - **Pods** (list) - 容器实例yaml列表，以base64编码
        - **TotalCount** (int) - 容器实例总数

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ListCubePodRequestSchema().dumps(d)

        resp = self.invoke("ListCubePod", d, **kwargs)
        return apis.ListCubePodResponseSchema().loads(resp)

    def modify_cube_extend_info(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyCubeExtendInfo -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **CubeId** (str) - (Required)
        - **Name** (str) -
        - **Zone** (str) -

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyCubeExtendInfoRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("ModifyCubeExtendInfo", d, **kwargs)
        return apis.ModifyCubeExtendInfoResponseSchema().loads(resp)

    def modify_cube_tag(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyCubeTag -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **CubeId** (str) - (Required)
        - **Tag** (str) - (Required)
        - **Zone** (str) -

        **Response**

        - **CubeId** (str) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyCubeTagRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("ModifyCubeTag", d, **kwargs)
        return apis.ModifyCubeTagResponseSchema().loads(resp)

    def reboot_cube_pod(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RebootCubePod -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **CubeId** (str) - (Required)
        - **Zone** (str) -

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RebootCubePodRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("RebootCubePod", d, **kwargs)
        return apis.RebootCubePodResponseSchema().loads(resp)

    def renew_cube_pod(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RenewCubePod - 更新容器实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Pod** (str) - (Required) Pod yaml，以base64编码
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **CubeId** (str) - 要更新的容器实例ID

        **Response**

        - **Pod** (str) - Pod yaml，以base64编码

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RenewCubePodRequestSchema().dumps(d)

        resp = self.invoke("RenewCubePod", d, **kwargs)
        return apis.RenewCubePodResponseSchema().loads(resp)

    def update_cube_deployment(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpdateCubeDeployment -

        **Request**

        - **ProjectId** (str) - (Config)
        - **Region** (str) - (Config)
        - **Deployment** (str) - (Required)
        - **DeploymentId** (str) - (Required)
        - **Name** (str) -
        - **Zone** (str) -

        **Response**

        - **Deployment** (str) -

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpdateCubeDeploymentRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("UpdateCubeDeployment", d, **kwargs)
        return apis.UpdateCubeDeploymentResponseSchema().loads(resp)
