""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.uvms.schemas import apis


class UVMSClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UVMSClient, self).__init__(config, transport, middleware, logger)

    def get_uvms_send_record(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """GetUVMSSendRecord - 获取语音发送记录

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **BrevityCode** (str) - 国际码，国内CN
        - **CalledCityCode** (str) - 被叫城市编码
        - **CalledOperatorCode** (str) - 被叫运营商 cmcc中国移动，cucc中国联通,ctcc中国电信
        - **CallingCityCode** (str) - 主叫城市编码
        - **EndTime** (int) - 结束时间-拨打时间，默认当前
        - **ExcludeBrevityCode** (str) - 排除国际码
        - **FuzzySearch** (str) - 模糊搜索，支持 主叫号码和被叫号码
        - **NumPerPage** (int) - 每页数量，默认10
        - **OrderBy** (str) - call_start_time(拨打时间)/receive_time（回执时间）
        - **OrderType** (str) - asc\desc
        - **Page** (int) - 页码，默认0
        - **PhoneNumber** (str) - 被叫号码，精确查询
        - **Purpose** (int) - 目标1验证码2通知3营销
        - **StartTime** (int) - 开始时间-拨打时间，默认最近7天
        - **TaskNo** (str) - 任务编号
        - **TemplateId** (str) - 目标ID

        **Response**

        - **Data** (list) - 见 **SendRecordItem** 模型定义
        - **Total** (int) - 总数

        **Response Model**

        **SendRecordItem**
        - **BillPeriod** (int) - 计费周期（秒）
        - **BillSecond** (int) - 计费时长（秒）
        - **BrevityCode** (str) - 国际码
        - **CallEndTime** (int) - 呼叫结束时间(毫秒时间戳)
        - **CallStartTime** (int) - 呼叫开始时间(毫秒时间戳)
        - **CalledCityCode** (str) - 被叫所属城市码
        - **CalledOperatorCode** (str) - 被叫供应商码 cmcc中国移动，cucc中国联通,ctcc中国电信
        - **CallingCityCode** (str) - 主叫所属城市码
        - **ChannelId** (str) - 通道ID
        - **CountryCode** (str) - 国家码
        - **Duration** (int) - 呼叫持续时间
        - **GroupType** (int) - 1随机号码组2专属号码组
        - **Phone** (str) - 被叫号码
        - **PreCost** (int) - 预扣量
        - **Purpose** (int) - 目标1验证码2通知3营销
        - **ReceiptDesc** (str) - 回执描述
        - **ReceiptResult** (int) - 回执结果1成功2失败3未知
        - **ReceiveTime** (int) - 回执时间
        - **ShowNumber** (str) - 主叫号码，如果是随机，可能为空
        - **SubmitTime** (int) - 客户提交时间
        - **TaskNo** (str) - 任务编号
        - **TemplateId** (str) - 模板ID


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetUVMSSendRecordRequestSchema().dumps(d)

        resp = self.invoke("GetUVMSSendRecord", d, **kwargs)
        return apis.GetUVMSSendRecordResponseSchema().loads(resp)

    def send_uvms_message(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """SendUVMSMessage - 向指定号码拨打电话

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **CalledNumber** (str) - (Required) 被叫号码，采用 E.164 标准，格式为+[国家代码][用户号码]。例如：+8613512345678， 其中前面有一个+号 ，86为国家码，13512345678为手机号
        - **TemplateId** (str) - (Required) 模板 ID，在控制台审核通过的模板 ID。
        - **DispatchRule** (int) - 调度规则，0-默认（归属地优先），1-随机。当不指定外显号码（主叫号码为空）时生效。如不填写，默认为归属地优先。
        - **FromNumber** (str) - 主叫号码，号码随机时不填。专属号码时传入已购买的号码，仅支持一个号码，在控制台查看已购买的号码。
        - **GroupType** (int) - 号码组类型，1-随机组，2-专属组。如不填写则根据主叫号码判断，若主叫号码为空，则为随机组，若不为空，则为专属组。
        - **TemplateParams** (list) - 模板可变参数，以数组的方式填写，举例，TemplateParams.0，TemplateParams.1，... 若模板中无可变参数，则该项可不填写；若模板中有可变参数，则该项为必填项，参数个数需与变量个数保持一致，否则无法发送；
        - **UserId** (str) - 自定义的业务标识ID，字符串（ 长度不能超过32 位），不支持 单引号、表情包符号等特殊字符

        **Response**

        - **Message** (str) - 状态码的描述
        - **ReqUuid** (str) - 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 ReqUuid。
        - **SessionNo** (str) - 本次提交发送语音的唯一ID，可根据该值查询本次发送详情
        - **UserId** (str) - 本次提交的自定义业务标识ID，仅当发送时传入有效的UserId，才返回该字段。

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.SendUVMSMessageRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("SendUVMSMessage", d, **kwargs)
        return apis.SendUVMSMessageResponseSchema().loads(resp)
