""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.uddb.schemas import apis


class UDDBClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UDDBClient, self).__init__(config, transport, middleware, logger)

    def change_uddb_instance_name(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ChangeUDDBInstanceName - 修改分布式数据库中间件名称

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **NewName** (str) - (Required) 名称
        - **UDDBId** (str) - (Required) UDDB实例Id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ChangeUDDBInstanceNameRequestSchema().dumps(d)

        resp = self.invoke("ChangeUDDBInstanceName", d, **kwargs)
        return apis.ChangeUDDBInstanceNameResponseSchema().loads(resp)

    def change_uddb_slave_count(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ChangeUDDBSlaveCount - 改变分布式数据库数据节点的只读实例个数每一个UDDB的数据节点负责处理所有的写入请求。与此同时，每一个数据节点可以配置若干个该节点的只读实例。当主节点的数据写入完毕后，只读实例把这次的写入操作进行更新，从而和数据节点保持一致。只读实例可以使得数据由多份复制，在数据节点和只读实例之间，可以做请求的读写分离, 也就是说, 主节点写入数据之后, 数据的读操作可以由数据只读实例进行分担, 这样减少主节点的压力, 增加性能当改变了数据节点的只读实例个数之后，对于现有的和以后的每一个数据节点都采用这个配置。如果UDDB实例有现有的数据节点, 那么它会根据新配置的参数，自动创建或删除数据节点的只读实例如下状态的UDDB实例可以进行这个操作:Running: 系统正常运行中当请求返回成功之后，UDDB实例的状态变成"ChangingSlaveCount"; 如果返回失败, UDDB实例状态保持不变 当UDDB更改数据分区的只读实例个数成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果更改过程中出现异常, 状态变成"Abnormal"(异常运行中)或者"Error"(运行错误)

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **SlaveCount** (str) - (Required) 每个数据节点的只读实例个数, 取值必须>=0
        - **UDDBId** (str) - (Required) UDDB资源id
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ChangeUDDBSlaveCountRequestSchema().dumps(d)

        resp = self.invoke("ChangeUDDBSlaveCount", d, **kwargs)
        return apis.ChangeUDDBSlaveCountResponseSchema().loads(resp)

    def create_uddb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateUDDBInstance - 创建创建分布式数据库UDDB实例, 简称UDDB实例。

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **AdminPassword** (str) - (Required) 管理员密码, 密码需要使用base64加密
        - **DBTypeId** (str) - (Required) UDDB的数据库版本，支持版本如下：mysql-5.6 mysql-5.7. 如果不填，则默认为mysql-5.6
        - **DataNodeCount** (int) - (Required) 初始的数据节点个数 取值必须>0.
        - **DataNodeDiskSpace** (int) - (Required) 新的数据节点的磁盘大小配置. 单位: GB 具体数值参考UDB的磁盘大小取值.
        - **DataNodeMemory** (int) - (Required) 新的数据节点的内存配置, 单位：MB 具体数值参考UDB的内存取值.
        - **Name** (str) - (Required) 实例名称，至少6位
        - **RouterNodeNum** (int) - (Required) 其他版本：该参数可不填；专享版：物理机台数
        - **RouterVersion** (str) - (Required) UDDB路由节点的版本。分为三种： Trival(免费版)： 2中间件节点； QPS：1.5W FellFree(标准版)： 固定为4中间件节点，后续将根据业务请求量自动扩展，最多扩展到12个节点，QPS为3w - 10w； EnjoyAlone(物理机版)：专享物理机，节点数让客户可选
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **AdminUser** (str) - 管理员帐户名，默认root
        - **ChargeType** (str) - 付费类型，可选值如下:Year: 按年付费 Month: 按月付费 Dynamic: 按需付费(单位: 小时) Trial: 免费试用  默认值为: Dynamic
        - **CouponId** (str) - 使用的代金券id
        - **DataNodeSlaveCount** (int) - 每个数据节点的只读实例个数, 取值必须>=0. 默认取值为0.
        - **InstanceMode** (str) - 存储节点的高可用模式， 分为高可用UDB（HA）和普通UDB（Normal），如果不填， 则默认为HA
        - **InstanceType** (str) - 存储节点和只读实例的磁盘类型。分为：SSD磁盘（SATA_SSD）或普通磁盘(Normal)。 如果不填，则默认为SATA_SSD
        - **Port** (int) - 端口号，mysql默认端口为3306
        - **Quantity** (int) - 购买时长，默认值1
        - **SubnetId** (str) - 子网ID
        - **VPCId** (str) - VPC的ID

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息
        - **UDDBId** (str) - UDDB实例ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateUDDBInstanceRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateUDDBInstance", d, **kwargs)
        return apis.CreateUDDBInstanceResponseSchema().loads(resp)

    def delete_uddb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteUDDBInstance - 删除UDDB实例。如下状态的UDDB实例可以进行这个操作:InitFail: 初始化失败Shutoff: 已关闭当请求返回成功之后，UDDB实例就已经被删除, 列表上看不到对应的UDDB实例

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteUDDBInstanceRequestSchema().dumps(d)

        resp = self.invoke("DeleteUDDBInstance", d, **kwargs)
        return apis.DeleteUDDBInstanceResponseSchema().loads(resp)

    def describe_uddb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUDDBInstance - 获取分布式数据库UDDB的详细信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **DataSet** (list) - 见 **DataSetUDDB** 模型定义
        - **Message** (str) - 如果执行失败, 失败的错误消息

        **Response Model**

        **DataSetUDDB**
        - **AdminUser** (str) - 管理员帐户名，默认root
        - **ChargeType** (str) - 付费类型，可选值如下: Year: 按年付费 Month: 按月付费 Dynamic: 按需付费(单位: 小时) Trial: 免费试用
        - **CreateTime** (str) - UDDB实例创建时间，采用UTC计时时间戳
        - **DBTypeId** (str) - UDDB的数据库版本
        - **DataNodeCount** (str) - 数据节点个数
        - **DataNodeDiskSpace** (str) - 数据节点的磁盘大小配置. 单位: GB
        - **DataNodeList** (list) - 见 **DataNodeInfo** 模型定义
        - **DataNodeMemory** (str) - 数据节点的内存配置, 单位：MB
        - **DataNodeSlaveCount** (str) - 每个数据节点的只读实例个数.
        - **ExpiredTime** (str) - UDDB实例过期时间，采用UTC计时时间戳
        - **InstanceMode** (str) - 存储节点的高可用模式， 分为高可用UDB（HA）和普通UDB（Normal），如果不填， 则默认为HA
        - **InstanceType** (str) - 存储节点和只读实例的磁盘类型。分为：SSD磁盘（SATA_SSD）或普通磁盘(Normal)。 如果不填，则默认为SATA_SSD
        - **Name** (str) - UDDB实例名称
        - **Port** (str) - UDDB实例访问的端口号
        - **RefQps** (int) - 参考QPS。 免费版： 15000； 畅享版： 30000 - 100000 （根据节点数而定）； 专享版： 节点数 * 10w qps
        - **RouterNodeNum** (int) - 各版本下的节点个数。体验版： 固定为2节点； 畅享版：固定为4节点（后续可通过管理API调整）；专享版：物理机台数
        - **RouterVersion** (str) - UDDB路由节点的版本。分为三种： Trival(免费版)： 2中间件节点； QPS：1.5W FellFree(标准版)： 固定为4中间件节点，后续将根据业务请求量自动扩展，最多扩展到12个节点，QPS为3w - 10w； EnjoyAlone(物理机版)：专享物理机，节点数让客户可选
        - **State** (str) - UDDB状态, 状态列表如下: Init: 初始化中 InitFail: 初始化失败 Starting: 启动中 Running: 系统正常运行中 Abnormal: 系统运行中, 有异常, 还能提供服务 Error: 系统运行中, 但不能正常提供服务 Shutdown: 关闭中 Shutoff: 已关闭 Deleted: 已删除 UpgradingUDDB: 升降级UDDB配置中 UpgradingDataNode: 升降级UDDB节点配置中 ChangingSlaveCount: 改变只读实例数量中 ScalingOutUDDB: 水平扩展中
        - **UDDBId** (str) - UDDB实例ID
        - **VirtualIP** (str) - UDDB实例访问的虚IP
        - **Zone** (str) - UDDB实例对应的可用区


        **DataNodeInfo**
        - **CreateTime** (str) - 节点的创建时间
        - **DiskSpace** (str) - 数据节点的磁盘大小配置. 单位: GB
        - **Id** (str) - 数据节点ID
        - **LastTransTaskId** (str) - 最近一次数据迁移任务id
        - **Memory** (str) - 数据节点的内存配置, 单位：MB
        - **SlaveCount** (str) - 数据节点的只读实例个数.
        - **SlaveInfos** (list) - 见 **SlaveInfo** 模型定义
        - **State** (str) - 数据分片状态, 状态列表如下: Init: 初始化中 Fail: 安装失败 Starting: 启动中 Running: 系统正常运行中 Shutdown: 关闭中 Shutoff: 已关闭 Deleted: 已删除 Upgrading: 系统升级中


        **SlaveInfo**
        - **DataNodeId** (str) - 对应数据节点的ID
        - **Id** (str) - 只读实例ID
        - **State** (str) - 只读实例状态, 状态列表如下: Init: 初始化中 Fail: 安装失败 Starting: 启动中 Running: 系统正常运行中 Shutdown: 关闭中 Shutoff: 已关闭 Deleted: 已删除 Upgrading: 系统升级中


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUDDBInstanceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUDDBInstance", d, **kwargs)
        return apis.DescribeUDDBInstanceResponseSchema().loads(resp)

    def describe_uddb_instance_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUDDBInstancePrice - 获取分布式数据库UDDB价格

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **DataNodeCount** (int) - (Required) 初始的数据节点个数 取值必须>0.
        - **DataNodeDiskSpace** (int) - (Required) 新的数据节点的磁盘大小配置. 单位: GB 具体数值参考UDB的磁盘大小取值.
        - **DataNodeMemory** (str) - (Required) 新的数据节点的内存配置, 单位：MB 具体数值参考UDB的内存取值.
        - **RouterNodeNum** (int) - (Required) 其他版本：该参数可不填；专享版：物理机节点个数。一台物理机有2个节点
        - **RouterVersion** (str) - (Required) UDDB路由节点的版本。分为三种： Trival(免费版)： 2中间件节点； QPS：1.5WFeelFree(标准版)： 固定为4中间件节点，后续将根据业务请求量自动扩展，最多扩展到12个节点，QPS为3w - 10w；EnjoyAlone(物理机版)：专享物理机，节点数让客户可选
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **ChargeType** (str) - 付费类型，可选值如下: Year: 按年付费 Month: 按月付费 Dynamic: 按需付费(单位: 小时) Trial: 免费试用 默认值为: Dynamic
        - **DataNodeSlaveCount** (int) - 每个数据节点的只读实例个数, 取值必须>=0. 默认取值为0.
        - **InstanceMode** (str) - 存储节点的高可用模式， 分为高可用UDB（HA）和普通UDB（Normal），如果不填， 则默认为HA
        - **InstanceType** (str) - 存储节点和只读实例的磁盘类型。分为：SSD磁盘（SATA_SSD）或普通磁盘(Normal)。 如果不填，则默认为SATA_SSD
        - **Quantity** (int) - 购买时长，默认值1

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息
        - **PriceInfo** (dict) - 见 **PriceDetailInfo** 模型定义

        **Response Model**

        **PriceDetailInfo**
        - **DataNodePrice** (float) - 存储节点费用
        - **DataNodeSlavePrice** (float) - 只读实例费用
        - **MiddlewarePrice** (float) - 中间件路由节点费用


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUDDBInstancePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUDDBInstancePrice", d, **kwargs)
        return apis.DescribeUDDBInstancePriceResponseSchema().loads(resp)

    def describe_uddb_instance_upgrade_price(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeUDDBInstanceUpgradePrice - 升级UDDB时，获取升级后的价格

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **RouterNodeNum** (int) - (Required) 其他版本：该参数可不填；专享版：物理机节点的个数。一台物理机有2个节点
        - **RouterVersion** (str) - (Required) UDDB路由节点的版本。分为三种： Trival(免费版)： 2中间件节点； QPS：1.5WFeelFree(标准版)： 固定为4中间件节点，后续将根据业务请求量自动扩展，最多扩展到12个节点，QPS为3w - 10w；EnjoyAlone(物理机版)：专享物理机，节点数让客户可选
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **DataNodeCount** (int) - 新的数据节点个数 取值必须>0.
        - **DataNodeDiskSpace** (int) - 新的数据节点的磁盘大小配置. 单位: GB 具体数值参考UDB的磁盘大小取值.
        - **DataNodeMemory** (int) - 新的数据节点的内存配置, 单位：MB 具体数值参考UDB的内存取值.
        - **DataNodeSlaveCount** (int) - 每个数据节点的只读实例个数, 取值必须>=0.
        - **InstanceMode** (str) - 存储节点的高可用模式， 分为高可用UDB（HA）和普通UDB（Normal），如果不填， 则默认为HA
        - **InstanceType** (str) - 存储节点和只读实例的磁盘类型。分为：SSD磁盘（SATA_SSD）或普通磁盘(Normal)。 如果不填，则默认为SATA_SSD

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息
        - **PriceInfo** (dict) - 见 **PriceInfo** 模型定义

        **Response Model**

        **PriceInfo**
        - **DataNodePrice** (float) - 存储节点费用
        - **DataNodeSlavePrice** (float) - 只读实例费用
        - **MiddlewarePrice** (float) - 中间件路由节点费用


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeUDDBInstanceUpgradePriceRequestSchema().dumps(d)

        resp = self.invoke("DescribeUDDBInstanceUpgradePrice", d, **kwargs)
        return apis.DescribeUDDBInstanceUpgradePriceResponseSchema().loads(resp)

    def restart_uddb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """RestartUDDBInstance - 重启UDDB实例，开始提供服务。如下状态的UDDB实例可以进行这个操作:Running: 正常运行中Abnormal: 异常运行中当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在重启过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.RestartUDDBInstanceRequestSchema().dumps(d)

        resp = self.invoke("RestartUDDBInstance", d, **kwargs)
        return apis.RestartUDDBInstanceResponseSchema().loads(resp)

    def start_uddb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StartUDDBInstance - 启动UDDB实例，开始提供服务。如下状态的UDDB实例可以进行这个操作:Shutoff: 已关闭当请求返回成功之后，UDDB实例的状态变成"Starting"(启动中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在启动过程中, 当UDDB实例启动成功之后, UDDB实例的状态变成"Running"(正常运行中); 如果启动过程中出现异常, 状态变成"Abnormal"(异常运行中), 或者"Shutoff"(已关闭)

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.StartUDDBInstanceRequestSchema().dumps(d)

        resp = self.invoke("StartUDDBInstance", d, **kwargs)
        return apis.StartUDDBInstanceResponseSchema().loads(resp)

    def stop_uddb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """StopUDDBInstance - 关闭UDDB实例，停止提供服务。如下状态的UDDB实例可以进行这个操作:Running: 正常运行中Abnormal: 异常运行中当请求返回成功之后，UDDB实例的状态变成"Shutdown"(关闭中); 如果返回失败, UDDB实例状态保持不变 UDDB实例在关闭过程中, 当UDDB实例关闭成功之后, UDDB实例的状态变成"Shutoff"(已关闭); 如果关闭过程中出现异常, 根据UDDB实例的情况, 状态变成"Abnormal"(异常运行中), 或者"Running"(正常运行中)

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **Zone** (str) - (Required) 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.StopUDDBInstanceRequestSchema().dumps(d)

        resp = self.invoke("StopUDDBInstance", d, **kwargs)
        return apis.StopUDDBInstanceResponseSchema().loads(resp)

    def upgrade_uddb_data_node(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpgradeUDDBDataNode - 升降级分布式数据库数据节点的配置, 提高/降低数据节点的数据容量和内存所有数据节点以及其所挂载的只读实例的配置都受到影响升降级数据节点的配置之后之后, 会按照数据节点新的磁盘和内存大小重新计费如下状态的数据节点实例可以进行这个操作:Shutoff: 已关闭当请求返回成功之后，UDDB实例的状态变成"UpgradingDataNode"，相关数据节点的状态变成"Upgrading"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级结束之后, UDDB实例的状态变成"Shutoff"

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **DataNodeDiskSpace** (int) - (Required) 新的数据节点的磁盘大小配置. 单位: GB 具体数值参考UDB的磁盘大小取值.
        - **DataNodeMemory** (int) - (Required) 新的数据节点的内存配置, 单位：MB 具体数值参考UDB的内存取值
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **CouponId** (str) - 使用的代金券id
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpgradeUDDBDataNodeRequestSchema().dumps(d)

        resp = self.invoke("UpgradeUDDBDataNode", d, **kwargs)
        return apis.UpgradeUDDBDataNodeResponseSchema().loads(resp)

    def upgrade_uddb_instance(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """UpgradeUDDBInstance - 升降级分布式数据库中间件的配置, 提高/降低请求处理的并发性修改请求处理节点个数之后, 按照所有请求处理节点的总内存容量和CPU核数重新计费如下状态的UDDB实例可以进行这个操作:Running: 系统正常运行中当请求返回成功之后，UDDB实例的状态变成"UpgradingUDDB"; 如果返回失败, UDDB实例状态保持不变 当UDDB实例升级成功之后, UDDB实例的状态变成"Running"; 如果更改过程中出现异常, 状态变成"Abnormal", 或者"Error"

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_
        - **RouterNodeNum** (int) - (Required) 其他版本：该参数可不填；专享版：物理机台数
        - **RouterVersion** (str) - (Required) UDDB路由节点的版本。分为三种： Trival(免费版)： 2中间件节点； QPS：1.5W FellFree(标准版)： 固定为4中间件节点，后续将根据业务请求量自动扩展，最多扩展到12个节点，QPS为3w - 10w； EnjoyAlone(物理机版)：专享物理机，节点数让客户可选
        - **UDDBId** (str) - (Required) UDDB实例ID
        - **CouponId** (str) - 使用的代金券id
        - **Zone** (str) - 可用区。参见  `可用区列表 <https://docs.ucloud.cn/api/summary/regionlist.html>`_

        **Response**

        - **Message** (str) - 如果执行失败, 失败的错误消息

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.UpgradeUDDBInstanceRequestSchema().dumps(d)

        resp = self.invoke("UpgradeUDDBInstance", d, **kwargs)
        return apis.UpgradeUDDBInstanceResponseSchema().loads(resp)
