""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.urocketmq.schemas import models

""" URocketMQ API Schema
"""


"""
API: CreateURocketMQGroup

创建一个 Group, 如果同名 Group 在当前 Service 中已存在, 则会失败.
"""


class CreateURocketMQGroupRequestSchema(schema.RequestSchema):
    """CreateURocketMQGroup - 创建一个 Group, 如果同名 Group 在当前 Service 中已存在, 则会失败."""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "ServiceId": fields.Str(required=True, dump_to="ServiceId"),
    }


class CreateURocketMQGroupResponseSchema(schema.ResponseSchema):
    """CreateURocketMQGroup - 创建一个 Group, 如果同名 Group 在当前 Service 中已存在, 则会失败."""

    fields = {
        "GroupId": fields.Str(required=True, load_from="GroupId"),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DeleteURocketMQGroup

删除一个已存在的 Group
"""


class DeleteURocketMQGroupRequestSchema(schema.RequestSchema):
    """DeleteURocketMQGroup - 删除一个已存在的 Group"""

    fields = {
        "GroupName": fields.Str(required=True, dump_to="GroupName"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ServiceId": fields.Str(required=True, dump_to="ServiceId"),
    }


class DeleteURocketMQGroupResponseSchema(schema.ResponseSchema):
    """DeleteURocketMQGroup - 删除一个已存在的 Group"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ListURocketMQGroup

获取一个 RocketMQ 服务下的所有 Group
"""


class ListURocketMQGroupRequestSchema(schema.RequestSchema):
    """ListURocketMQGroup - 获取一个 RocketMQ 服务下的所有 Group"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ServiceId": fields.Str(required=True, dump_to="ServiceId"),
    }


class ListURocketMQGroupResponseSchema(schema.ResponseSchema):
    """ListURocketMQGroup - 获取一个 RocketMQ 服务下的所有 Group"""

    fields = {
        "GroupList": fields.List(
            models.GroupBaseInfoSchema(), required=False, load_from="GroupList"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }
