""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.vpc.schemas import models

""" VPC API Schema
"""


"""
API: AddSnatRule

对于绑定了多个EIP的NAT网关，您可以将一个子网下的某台云主机映射到某个特定的EIP上，规则生效后，则该云主机通过该特定的EIP访问互联网。
"""


class AddSnatRuleRequestSchema(schema.RequestSchema):
    """AddSnatRule - 对于绑定了多个EIP的NAT网关，您可以将一个子网下的某台云主机映射到某个特定的EIP上，规则生效后，则该云主机通过该特定的EIP访问互联网。"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnatIp": fields.Str(required=True, dump_to="SnatIp"),
        "SourceIp": fields.Str(required=True, dump_to="SourceIp"),
    }


class AddSnatRuleResponseSchema(schema.ResponseSchema):
    """AddSnatRule - 对于绑定了多个EIP的NAT网关，您可以将一个子网下的某台云主机映射到某个特定的EIP上，规则生效后，则该云主机通过该特定的EIP访问互联网。"""

    fields = {}


"""
API: AddVPCNetwork

添加VPC网段
"""


class AddVPCNetworkRequestSchema(schema.RequestSchema):
    """AddVPCNetwork - 添加VPC网段"""

    fields = {
        "Network": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class AddVPCNetworkResponseSchema(schema.ResponseSchema):
    """AddVPCNetwork - 添加VPC网段"""

    fields = {}


"""
API: AddWhiteListResource

添加NAT网关白名单
"""


class AddWhiteListResourceRequestSchema(schema.RequestSchema):
    """AddWhiteListResource - 添加NAT网关白名单"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceIds": fields.List(fields.Str()),
    }


class AddWhiteListResourceResponseSchema(schema.ResponseSchema):
    """AddWhiteListResource - 添加NAT网关白名单"""

    fields = {}


"""
API: AllocateBatchSecondaryIp

批量申请虚拟网卡辅助IP
"""


class AllocateBatchSecondaryIpRequestSchema(schema.RequestSchema):
    """AllocateBatchSecondaryIp - 批量申请虚拟网卡辅助IP"""

    fields = {
        "Count": fields.Int(required=False, dump_to="Count"),
        "Ip": fields.List(fields.Str()),
        "Mac": fields.Str(required=True, dump_to="Mac"),
        "ObjectId": fields.Str(required=True, dump_to="ObjectId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class AllocateBatchSecondaryIpResponseSchema(schema.ResponseSchema):
    """AllocateBatchSecondaryIp - 批量申请虚拟网卡辅助IP"""

    fields = {
        "IpsInfo": fields.List(
            models.IpsInfoSchema(), required=True, load_from="IpsInfo"
        ),
    }


"""
API: AllocateSecondaryIp

分配ip（用于uk8s使用）
"""


class AllocateSecondaryIpRequestSchema(schema.RequestSchema):
    """AllocateSecondaryIp - 分配ip（用于uk8s使用）"""

    fields = {
        "Ip": fields.Str(required=False, dump_to="Ip"),
        "Mac": fields.Str(required=True, dump_to="Mac"),
        "ObjectId": fields.Str(required=True, dump_to="ObjectId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class AllocateSecondaryIpResponseSchema(schema.ResponseSchema):
    """AllocateSecondaryIp - 分配ip（用于uk8s使用）"""

    fields = {
        "IpInfo": models.IpInfoSchema(),
    }


"""
API: AllocateVIP

根据提供信息，申请内网VIP(Virtual IP），多用于高可用程序作为漂移IP。
"""


class AllocateVIPRequestSchema(schema.RequestSchema):
    """AllocateVIP - 根据提供信息，申请内网VIP(Virtual IP），多用于高可用程序作为漂移IP。"""

    fields = {
        "BusinessId": fields.Str(required=False, dump_to="BusinessId"),
        "Count": fields.Int(required=False, dump_to="Count"),
        "Ip": fields.Str(required=False, dump_to="Ip"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class AllocateVIPResponseSchema(schema.ResponseSchema):
    """AllocateVIP - 根据提供信息，申请内网VIP(Virtual IP），多用于高可用程序作为漂移IP。"""

    fields = {
        "DataSet": fields.List(
            fields.Str(), required=False, load_from="DataSet"
        ),
        "VIPSet": fields.List(
            models.VIPSetSchema(), required=False, load_from="VIPSet"
        ),
    }


"""
API: AssociateRouteTable

绑定子网的路由表
"""


class AssociateRouteTableRequestSchema(schema.RequestSchema):
    """AssociateRouteTable - 绑定子网的路由表"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouteTableId": fields.Str(required=True, dump_to="RouteTableId"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
    }


class AssociateRouteTableResponseSchema(schema.ResponseSchema):
    """AssociateRouteTable - 绑定子网的路由表"""

    fields = {}


"""
API: AssociateSecGroup

绑定资源到安全组
"""


class AssociateSecGroupRequestSchema(schema.RequestSchema):
    """AssociateSecGroup - 绑定资源到安全组"""

    fields = {
        "PrioritySecGroup": fields.Str(
            required=True, dump_to="PrioritySecGroup"
        ),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceId": fields.Str(required=True, dump_to="ResourceId"),
    }


class AssociateSecGroupResponseSchema(schema.ResponseSchema):
    """AssociateSecGroup - 绑定资源到安全组"""

    fields = {}


"""
API: AssociateSecGroupDynamic

绑定安全组，动态调整绑定优先级
"""


class AssociateSecGroupDynamicRequestSchema(schema.RequestSchema):
    """AssociateSecGroupDynamic - 绑定安全组，动态调整绑定优先级"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceId": fields.List(fields.Str()),
        "SecGroupId": fields.Str(required=True, dump_to="SecGroupId"),
    }


class AssociateSecGroupDynamicResponseSchema(schema.ResponseSchema):
    """AssociateSecGroupDynamic - 绑定安全组，动态调整绑定优先级"""

    fields = {}


"""
API: AttachNetworkInterface

绑定网卡到云主机
"""


class AttachNetworkInterfaceRequestSchema(schema.RequestSchema):
    """AttachNetworkInterface - 绑定网卡到云主机"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "InterfaceId": fields.Str(required=True, dump_to="InterfaceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class AttachNetworkInterfaceResponseSchema(schema.ResponseSchema):
    """AttachNetworkInterface - 绑定网卡到云主机"""

    fields = {}


"""
API: CloneRouteTable

将现有的路由表复制为一张新的路由表
"""


class CloneRouteTableRequestSchema(schema.RequestSchema):
    """CloneRouteTable - 将现有的路由表复制为一张新的路由表"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouteTableId": fields.Str(required=True, dump_to="RouteTableId"),
    }


class CloneRouteTableResponseSchema(schema.ResponseSchema):
    """CloneRouteTable - 将现有的路由表复制为一张新的路由表"""

    fields = {
        "RouteTableId": fields.Str(required=False, load_from="RouteTableId"),
    }


"""
API: CreateNATGW

创建NAT网关
"""


class CreateNATGWRequestSchema(schema.RequestSchema):
    """CreateNATGW - 创建NAT网关"""

    fields = {
        "EIPIds": fields.List(fields.Str()),
        "FirewallId": fields.Str(required=True, dump_to="FirewallId"),
        "IfOpen": fields.Int(required=False, dump_to="IfOpen"),
        "NATGWName": fields.Str(required=True, dump_to="NATGWName"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SubnetworkIds": fields.List(fields.Str()),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class CreateNATGWResponseSchema(schema.ResponseSchema):
    """CreateNATGW - 创建NAT网关"""

    fields = {
        "NATGWId": fields.Str(required=False, load_from="NATGWId"),
    }


"""
API: CreateNATGWPolicy

添加NAT网关端口转发规则
"""


class CreateNATGWPolicyRequestSchema(schema.RequestSchema):
    """CreateNATGWPolicy - 添加NAT网关端口转发规则"""

    fields = {
        "DstIP": fields.Str(required=True, dump_to="DstIP"),
        "DstPort": fields.Str(required=True, dump_to="DstPort"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "PolicyName": fields.Str(required=False, dump_to="PolicyName"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Protocol": fields.Str(required=True, dump_to="Protocol"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SrcEIPId": fields.Str(required=True, dump_to="SrcEIPId"),
        "SrcPort": fields.Str(required=True, dump_to="SrcPort"),
    }


class CreateNATGWPolicyResponseSchema(schema.ResponseSchema):
    """CreateNATGWPolicy - 添加NAT网关端口转发规则"""

    fields = {
        "PolicyId": fields.Str(required=True, load_from="PolicyId"),
    }


"""
API: CreateNetworkAcl

创建网络ACL
"""


class CreateNetworkAclRequestSchema(schema.RequestSchema):
    """CreateNetworkAcl - 创建网络ACL"""

    fields = {
        "AclName": fields.Str(required=True, dump_to="AclName"),
        "Description": fields.Str(required=False, dump_to="Description"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VpcId": fields.Str(required=True, dump_to="VpcId"),
    }


class CreateNetworkAclResponseSchema(schema.ResponseSchema):
    """CreateNetworkAcl - 创建网络ACL"""

    fields = {
        "AclId": fields.Str(required=True, load_from="AclId"),
    }


"""
API: CreateNetworkAclAssociation

创建ACL的绑定关系
"""


class CreateNetworkAclAssociationRequestSchema(schema.RequestSchema):
    """CreateNetworkAclAssociation - 创建ACL的绑定关系"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetworkId": fields.Str(required=True, dump_to="SubnetworkId"),
    }


class CreateNetworkAclAssociationResponseSchema(schema.ResponseSchema):
    """CreateNetworkAclAssociation - 创建ACL的绑定关系"""

    fields = {
        "AssociationId": fields.Str(required=True, load_from="AssociationId"),
        "PrevAssociation": models.AssociationInfoSchema(),
    }


"""
API: CreateNetworkAclEntry

创建ACL的规则
"""


class CreateNetworkAclEntryRequestSchema(schema.RequestSchema):
    """CreateNetworkAclEntry - 创建ACL的规则"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "CidrBlock": fields.Str(required=True, dump_to="CidrBlock"),
        "Description": fields.Str(required=False, dump_to="Description"),
        "Direction": fields.Str(required=True, dump_to="Direction"),
        "EntryAction": fields.Str(required=True, dump_to="EntryAction"),
        "IpProtocol": fields.Str(required=True, dump_to="IpProtocol"),
        "PortRange": fields.Str(required=True, dump_to="PortRange"),
        "Priority": fields.Int(required=True, dump_to="Priority"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "TargetResourceIds": fields.List(fields.Str()),
        "TargetType": fields.Int(required=False, dump_to="TargetType"),
    }


class CreateNetworkAclEntryResponseSchema(schema.ResponseSchema):
    """CreateNetworkAclEntry - 创建ACL的规则"""

    fields = {
        "EntryId": fields.Str(required=True, load_from="EntryId"),
    }


"""
API: CreateNetworkInterface

创建虚拟网卡
"""


class CreateNetworkInterfaceParamPrioritySecGroupSchema(schema.RequestSchema):
    """CreateNetworkInterfaceParamPrioritySecGroup -"""

    fields = {
        "Priority": fields.Int(required=False, dump_to="Priority"),
        "SecGroupId": fields.Str(required=False, dump_to="SecGroupId"),
    }


class CreateNetworkInterfaceRequestSchema(schema.RequestSchema):
    """CreateNetworkInterface - 创建虚拟网卡"""

    fields = {
        "EipDirectMode": fields.Bool(required=False, dump_to="EipDirectMode"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "PrioritySecGroup": fields.List(
            CreateNetworkInterfaceParamPrioritySecGroupSchema()
        ),
        "PrivateIp": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SecurityGroupId": fields.Str(
            required=False, dump_to="SecurityGroupId"
        ),
        "SecurityMode": fields.Int(required=False, dump_to="SecurityMode"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class CreateNetworkInterfaceResponseSchema(schema.ResponseSchema):
    """CreateNetworkInterface - 创建虚拟网卡"""

    fields = {
        "NetworkInterface": models.NetworkInterfaceInfoSchema(),
    }


"""
API: CreateRouteTable

创建路由表
"""


class CreateRouteTableRequestSchema(schema.RequestSchema):
    """CreateRouteTable - 创建路由表"""

    fields = {
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class CreateRouteTableResponseSchema(schema.ResponseSchema):
    """CreateRouteTable - 创建路由表"""

    fields = {
        "RouteTableId": fields.Str(required=False, load_from="RouteTableId"),
    }


"""
API: CreateSecGroup

创建安全组
"""


class CreateSecGroupRequestSchema(schema.RequestSchema):
    """CreateSecGroup - 创建安全组"""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCID": fields.Str(required=True, dump_to="VPCID"),
    }


class CreateSecGroupResponseSchema(schema.ResponseSchema):
    """CreateSecGroup - 创建安全组"""

    fields = {
        "SecGroupId": fields.Str(required=True, load_from="SecGroupId"),
    }


"""
API: CreateSecGroupRule


"""


class CreateSecGroupRuleParamRuleSchema(schema.RequestSchema):
    """CreateSecGroupRuleParamRule -"""

    fields = {
        "Direction": fields.Str(required=True, dump_to="Direction"),
        "DstPort": fields.Str(required=True, dump_to="DstPort"),
        "IPRange": fields.Str(required=True, dump_to="IPRange"),
        "Priority": fields.Int(required=True, dump_to="Priority"),
        "ProtocolType": fields.Str(required=True, dump_to="ProtocolType"),
        "Remark": fields.Str(required=True, dump_to="Remark"),
        "RuleAction": fields.Str(required=True, dump_to="RuleAction"),
    }


class CreateSecGroupRuleRequestSchema(schema.RequestSchema):
    """CreateSecGroupRule -"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Rule": fields.List(CreateSecGroupRuleParamRuleSchema()),
        "SecGroupId": fields.Str(required=True, dump_to="SecGroupId"),
    }


class CreateSecGroupRuleResponseSchema(schema.ResponseSchema):
    """CreateSecGroupRule -"""

    fields = {
        "RuleId": fields.List(fields.Str(), required=True, load_from="RuleId"),
    }


"""
API: CreateSnatDnatRule

调用接口后会自动创建内外网IP之间的SNAT和DNAT规则，支持TCP、UDP协议全端口
"""


class CreateSnatDnatRuleRequestSchema(schema.RequestSchema):
    """CreateSnatDnatRule - 调用接口后会自动创建内外网IP之间的SNAT和DNAT规则，支持TCP、UDP协议全端口"""

    fields = {
        "EIP": fields.List(fields.Str()),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "PrivateIp": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class CreateSnatDnatRuleResponseSchema(schema.ResponseSchema):
    """CreateSnatDnatRule - 调用接口后会自动创建内外网IP之间的SNAT和DNAT规则，支持TCP、UDP协议全端口"""

    fields = {}


"""
API: CreateSubnet

创建子网
"""


class CreateSubnetRequestSchema(schema.RequestSchema):
    """CreateSubnet - 创建子网"""

    fields = {
        "Netmask": fields.Int(required=False, dump_to="Netmask"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Subnet": fields.Str(required=True, dump_to="Subnet"),
        "SubnetName": fields.Str(required=False, dump_to="SubnetName"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class CreateSubnetResponseSchema(schema.ResponseSchema):
    """CreateSubnet - 创建子网"""

    fields = {
        "SubnetId": fields.Str(required=False, load_from="SubnetId"),
    }


"""
API: CreateVPC

创建VPC
"""


class CreateVPCRequestSchema(schema.RequestSchema):
    """CreateVPC - 创建VPC"""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "Network": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "Type": fields.Int(
            required=False, dump_to="Type"
        ),  # Deprecated, will be removed at 1.0
    }


class CreateVPCResponseSchema(schema.ResponseSchema):
    """CreateVPC - 创建VPC"""

    fields = {
        "VPCId": fields.Str(required=False, load_from="VPCId"),
    }


"""
API: CreateVPCIntercom

新建VPC互通关系
"""


class CreateVPCIntercomRequestSchema(schema.RequestSchema):
    """CreateVPCIntercom - 新建VPC互通关系"""

    fields = {
        "DstProjectId": fields.Str(required=False, dump_to="DstProjectId"),
        "DstRegion": fields.Str(required=False, dump_to="DstRegion"),
        "DstVPCId": fields.Str(required=True, dump_to="DstVPCId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class CreateVPCIntercomResponseSchema(schema.ResponseSchema):
    """CreateVPCIntercom - 新建VPC互通关系"""

    fields = {}


"""
API: DeleteNATGW

删除NAT网关
"""


class DeleteNATGWRequestSchema(schema.RequestSchema):
    """DeleteNATGW - 删除NAT网关"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ReleaseEip": fields.Bool(required=False, dump_to="ReleaseEip"),
    }


class DeleteNATGWResponseSchema(schema.ResponseSchema):
    """DeleteNATGW - 删除NAT网关"""

    fields = {}


"""
API: DeleteNATGWPolicy

删除NAT网关端口转发规则
"""


class DeleteNATGWPolicyRequestSchema(schema.RequestSchema):
    """DeleteNATGWPolicy - 删除NAT网关端口转发规则"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "PolicyId": fields.Str(required=True, dump_to="PolicyId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DeleteNATGWPolicyResponseSchema(schema.ResponseSchema):
    """DeleteNATGWPolicy - 删除NAT网关端口转发规则"""

    fields = {}


"""
API: DeleteNetworkAcl

删除网络ACL
"""


class DeleteNetworkAclRequestSchema(schema.RequestSchema):
    """DeleteNetworkAcl - 删除网络ACL"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DeleteNetworkAclResponseSchema(schema.ResponseSchema):
    """DeleteNetworkAcl - 删除网络ACL"""

    fields = {}


"""
API: DeleteNetworkAclAssociation

删除网络ACL绑定关系
"""


class DeleteNetworkAclAssociationRequestSchema(schema.RequestSchema):
    """DeleteNetworkAclAssociation - 删除网络ACL绑定关系"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetworkId": fields.Str(required=True, dump_to="SubnetworkId"),
    }


class DeleteNetworkAclAssociationResponseSchema(schema.ResponseSchema):
    """DeleteNetworkAclAssociation - 删除网络ACL绑定关系"""

    fields = {}


"""
API: DeleteNetworkAclEntry

删除ACL的规则
"""


class DeleteNetworkAclEntryRequestSchema(schema.RequestSchema):
    """DeleteNetworkAclEntry - 删除ACL的规则"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "EntryId": fields.Str(required=True, dump_to="EntryId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DeleteNetworkAclEntryResponseSchema(schema.ResponseSchema):
    """DeleteNetworkAclEntry - 删除ACL的规则"""

    fields = {}


"""
API: DeleteNetworkInterface

删除网卡
"""


class DeleteNetworkInterfaceRequestSchema(schema.RequestSchema):
    """DeleteNetworkInterface - 删除网卡"""

    fields = {
        "InterfaceId": fields.Str(required=True, dump_to="InterfaceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DeleteNetworkInterfaceResponseSchema(schema.ResponseSchema):
    """DeleteNetworkInterface - 删除网卡"""

    fields = {}


"""
API: DeleteRouteTable

删除自定义路由表
"""


class DeleteRouteTableRequestSchema(schema.RequestSchema):
    """DeleteRouteTable - 删除自定义路由表"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouteTableId": fields.Str(required=True, dump_to="RouteTableId"),
    }


class DeleteRouteTableResponseSchema(schema.ResponseSchema):
    """DeleteRouteTable - 删除自定义路由表"""

    fields = {}


"""
API: DeleteSecGroup

删除安全组
"""


class DeleteSecGroupRequestSchema(schema.RequestSchema):
    """DeleteSecGroup - 删除安全组"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SecGroupId": fields.Str(required=True, dump_to="SecGroupId"),
    }


class DeleteSecGroupResponseSchema(schema.ResponseSchema):
    """DeleteSecGroup - 删除安全组"""

    fields = {}


"""
API: DeleteSecGroupRule


"""


class DeleteSecGroupRuleRequestSchema(schema.RequestSchema):
    """DeleteSecGroupRule -"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RuleId": fields.Str(required=True, dump_to="RuleId"),
        "SecGroupId": fields.Str(required=True, dump_to="SecGroupId"),
    }


class DeleteSecGroupRuleResponseSchema(schema.ResponseSchema):
    """DeleteSecGroupRule -"""

    fields = {}


"""
API: DeleteSecondaryIp

删除ip（用于uk8s使用）
"""


class DeleteSecondaryIpRequestSchema(schema.RequestSchema):
    """DeleteSecondaryIp - 删除ip（用于uk8s使用）"""

    fields = {
        "Ip": fields.Str(required=True, dump_to="Ip"),
        "Mac": fields.Str(required=True, dump_to="Mac"),
        "ObjectId": fields.Str(required=False, dump_to="ObjectId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteSecondaryIpResponseSchema(schema.ResponseSchema):
    """DeleteSecondaryIp - 删除ip（用于uk8s使用）"""

    fields = {}


"""
API: DeleteSnatDnatRule

删除NAT创建内外网IP映射规则
"""


class DeleteSnatDnatRuleRequestSchema(schema.RequestSchema):
    """DeleteSnatDnatRule - 删除NAT创建内外网IP映射规则"""

    fields = {
        "EIP": fields.List(fields.Str()),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "PrivateIp": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DeleteSnatDnatRuleResponseSchema(schema.ResponseSchema):
    """DeleteSnatDnatRule - 删除NAT创建内外网IP映射规则"""

    fields = {}


"""
API: DeleteSnatRule

删除指定的出口规则（SNAT规则）
"""


class DeleteSnatRuleRequestSchema(schema.RequestSchema):
    """DeleteSnatRule - 删除指定的出口规则（SNAT规则）"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SourceIp": fields.Str(required=True, dump_to="SourceIp"),
    }


class DeleteSnatRuleResponseSchema(schema.ResponseSchema):
    """DeleteSnatRule - 删除指定的出口规则（SNAT规则）"""

    fields = {}


"""
API: DeleteSubnet

删除子网
"""


class DeleteSubnetRequestSchema(schema.RequestSchema):
    """DeleteSubnet - 删除子网"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
    }


class DeleteSubnetResponseSchema(schema.ResponseSchema):
    """DeleteSubnet - 删除子网"""

    fields = {}


"""
API: DeleteVPC

删除VPC
"""


class DeleteVPCRequestSchema(schema.RequestSchema):
    """DeleteVPC - 删除VPC"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class DeleteVPCResponseSchema(schema.ResponseSchema):
    """DeleteVPC - 删除VPC"""

    fields = {}


"""
API: DeleteVPCIntercom

删除VPC互通关系
"""


class DeleteVPCIntercomRequestSchema(schema.RequestSchema):
    """DeleteVPCIntercom - 删除VPC互通关系"""

    fields = {
        "DstProjectId": fields.Str(required=False, dump_to="DstProjectId"),
        "DstRegion": fields.Str(required=False, dump_to="DstRegion"),
        "DstVPCId": fields.Str(required=True, dump_to="DstVPCId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class DeleteVPCIntercomResponseSchema(schema.ResponseSchema):
    """DeleteVPCIntercom - 删除VPC互通关系"""

    fields = {}


"""
API: DeleteWhiteListResource

删除NAT网关白名单列表
"""


class DeleteWhiteListResourceRequestSchema(schema.RequestSchema):
    """DeleteWhiteListResource - 删除NAT网关白名单列表"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceIds": fields.List(fields.Str()),
    }


class DeleteWhiteListResourceResponseSchema(schema.ResponseSchema):
    """DeleteWhiteListResource - 删除NAT网关白名单列表"""

    fields = {}


"""
API: DescribeInstanceNetworkInterface

展示云主机绑定的网卡信息
"""


class DescribeInstanceNetworkInterfaceRequestSchema(schema.RequestSchema):
    """DescribeInstanceNetworkInterface - 展示云主机绑定的网卡信息"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeInstanceNetworkInterfaceResponseSchema(schema.ResponseSchema):
    """DescribeInstanceNetworkInterface - 展示云主机绑定的网卡信息"""

    fields = {
        "NetworkInterfaceSet": fields.List(
            models.InstanceNetworkInterfaceSchema(),
            required=True,
            load_from="NetworkInterfaceSet",
        ),
    }


"""
API: DescribeNATGW

获取NAT网关信息
"""


class DescribeNATGWRequestSchema(schema.RequestSchema):
    """DescribeNATGW - 获取NAT网关信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWIds": fields.List(fields.Str()),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeNATGWResponseSchema(schema.ResponseSchema):
    """DescribeNATGW - 获取NAT网关信息"""

    fields = {
        "DataSet": fields.List(
            models.NatGatewayDataSetSchema(),
            required=False,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeNATGWPolicy

展示NAT网关端口转发规则
"""


class DescribeNATGWPolicyRequestSchema(schema.RequestSchema):
    """DescribeNATGWPolicy - 展示NAT网关端口转发规则"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeNATGWPolicyResponseSchema(schema.ResponseSchema):
    """DescribeNATGWPolicy - 展示NAT网关端口转发规则"""

    fields = {
        "DataSet": fields.List(
            models.NATGWPolicyDataSetSchema(),
            required=False,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeNetworkAcl

获取网络ACL
"""


class DescribeNetworkAclRequestSchema(schema.RequestSchema):
    """DescribeNetworkAcl - 获取网络ACL"""

    fields = {
        "Limit": fields.Str(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VpcId": fields.Str(required=False, dump_to="VpcId"),
    }


class DescribeNetworkAclResponseSchema(schema.ResponseSchema):
    """DescribeNetworkAcl - 获取网络ACL"""

    fields = {
        "AclList": fields.List(
            models.AclInfoSchema(), required=True, load_from="AclList"
        ),
    }


"""
API: DescribeNetworkAclAssociation

获取网络ACL的绑定关系列表
"""


class DescribeNetworkAclAssociationRequestSchema(schema.RequestSchema):
    """DescribeNetworkAclAssociation - 获取网络ACL的绑定关系列表"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "Limit": fields.Str(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeNetworkAclAssociationResponseSchema(schema.ResponseSchema):
    """DescribeNetworkAclAssociation - 获取网络ACL的绑定关系列表"""

    fields = {
        "AssociationList": fields.List(
            models.AssociationInfoSchema(),
            required=True,
            load_from="AssociationList",
        ),
    }


"""
API: DescribeNetworkAclAssociationBySubnet

获取子网的ACL绑定信息
"""


class DescribeNetworkAclAssociationBySubnetRequestSchema(schema.RequestSchema):
    """DescribeNetworkAclAssociationBySubnet - 获取子网的ACL绑定信息"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetworkId": fields.Str(required=True, dump_to="SubnetworkId"),
    }


class DescribeNetworkAclAssociationBySubnetResponseSchema(
    schema.ResponseSchema
):
    """DescribeNetworkAclAssociationBySubnet - 获取子网的ACL绑定信息"""

    fields = {
        "Association": models.AssociationInfoSchema(),
    }


"""
API: DescribeNetworkAclEntry

获取ACL的规则信息
"""


class DescribeNetworkAclEntryRequestSchema(schema.RequestSchema):
    """DescribeNetworkAclEntry - 获取ACL的规则信息"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeNetworkAclEntryResponseSchema(schema.ResponseSchema):
    """DescribeNetworkAclEntry - 获取ACL的规则信息"""

    fields = {
        "EntryList": fields.List(
            models.AclEntryInfoSchema(), required=True, load_from="EntryList"
        ),
    }


"""
API: DescribeNetworkInterface

展示虚拟网卡信息
"""


class DescribeNetworkInterfaceRequestSchema(schema.RequestSchema):
    """DescribeNetworkInterface - 展示虚拟网卡信息"""

    fields = {
        "InterfaceId": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NoRecycled": fields.Bool(required=False, dump_to="NoRecycled"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "OnlyDefault": fields.Bool(required=False, dump_to="OnlyDefault"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeNetworkInterfaceResponseSchema(schema.ResponseSchema):
    """DescribeNetworkInterface - 展示虚拟网卡信息"""

    fields = {
        "NetworkInterfaceSet": fields.List(
            models.NetworkInterfaceSchema(),
            required=True,
            load_from="NetworkInterfaceSet",
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeResourceSecGroup

查询资源绑定的安全组信息
"""


class DescribeResourceSecGroupRequestSchema(schema.RequestSchema):
    """DescribeResourceSecGroup - 查询资源绑定的安全组信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceId": fields.Str(required=False, dump_to="ResourceId"),
        "ResourceType": fields.Str(required=False, dump_to="ResourceType"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeResourceSecGroupResponseSchema(schema.ResponseSchema):
    """DescribeResourceSecGroup - 查询资源绑定的安全组信息"""

    fields = {
        "DataSet": fields.List(
            models.ResourceSecgroupInfoExSchema(),
            required=True,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeRouteTable

获取路由表详细信息(包括路由策略)
"""


class DescribeRouteTableRequestSchema(schema.RequestSchema):
    """DescribeRouteTable - 获取路由表详细信息(包括路由策略)"""

    fields = {
        "Brief": fields.Bool(required=False, dump_to="Brief"),
        "BusinessId": fields.Str(required=False, dump_to="BusinessId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "LongId": fields.Str(required=False, dump_to="LongId"),
        "OffSet": fields.Int(required=False, dump_to="OffSet"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouteTableId": fields.Str(required=False, dump_to="RouteTableId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeRouteTableResponseSchema(schema.ResponseSchema):
    """DescribeRouteTable - 获取路由表详细信息(包括路由策略)"""

    fields = {
        "RouteTables": fields.List(
            models.RouteTableInfoSchema(),
            required=False,
            load_from="RouteTables",
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSecGroup


"""


class DescribeSecGroupRequestSchema(schema.RequestSchema):
    """DescribeSecGroup -"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SecGroupId": fields.List(fields.Str()),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeSecGroupResponseSchema(schema.ResponseSchema):
    """DescribeSecGroup -"""

    fields = {
        "DataSet": fields.List(
            models.SecGroupInfoSchema(), required=True, load_from="DataSet"
        ),
    }


"""
API: DescribeSecGroupResource

获取安全组绑资源信息
"""


class DescribeSecGroupResourceRequestSchema(schema.RequestSchema):
    """DescribeSecGroupResource - 获取安全组绑资源信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SecGroupId": fields.Str(required=False, dump_to="SecGroupId"),
    }


class DescribeSecGroupResourceResponseSchema(schema.ResponseSchema):
    """DescribeSecGroupResource - 获取安全组绑资源信息"""

    fields = {
        "DataSet": fields.List(
            models.SecGroupResourceInfoSchema(),
            required=True,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSecondaryIp

查询SecondaryIp（uk8s使用）
"""


class DescribeSecondaryIpRequestSchema(schema.RequestSchema):
    """DescribeSecondaryIp - 查询SecondaryIp（uk8s使用）"""

    fields = {
        "Ip": fields.Str(required=False, dump_to="Ip"),
        "Mac": fields.Str(required=False, dump_to="Mac"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
        "Zone": fields.Str(
            required=True, dump_to="Zone"
        ),  # Deprecated, will be removed at 1.0
    }


class DescribeSecondaryIpResponseSchema(schema.ResponseSchema):
    """DescribeSecondaryIp - 查询SecondaryIp（uk8s使用）"""

    fields = {
        "DataSet": fields.List(
            models.IpInfoSchema(), required=False, load_from="DataSet"
        ),
    }


"""
API: DescribeSnatDnatRule

获取基于NAT创建的内外网IP映射规则信息
"""


class DescribeSnatDnatRuleRequestSchema(schema.RequestSchema):
    """DescribeSnatDnatRule - 获取基于NAT创建的内外网IP映射规则信息"""

    fields = {
        "EIP": fields.List(fields.Str()),
        "NATGWId": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeSnatDnatRuleResponseSchema(schema.ResponseSchema):
    """DescribeSnatDnatRule - 获取基于NAT创建的内外网IP映射规则信息"""

    fields = {
        "DataSet": fields.List(
            models.SnatDnatRuleInfoSchema(), required=False, load_from="DataSet"
        ),
    }


"""
API: DescribeSnatRule

获取Nat网关的出口规则（SNAT规则）
"""


class DescribeSnatRuleRequestSchema(schema.RequestSchema):
    """DescribeSnatRule - 获取Nat网关的出口规则（SNAT规则）"""

    fields = {
        "Limit": fields.Str(required=False, dump_to="Limit"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "Offset": fields.Str(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnatIp": fields.Str(required=False, dump_to="SnatIp"),
        "SourceIp": fields.Str(required=False, dump_to="SourceIp"),
    }


class DescribeSnatRuleResponseSchema(schema.ResponseSchema):
    """DescribeSnatRule - 获取Nat网关的出口规则（SNAT规则）"""

    fields = {
        "DataSet": fields.List(
            models.NATGWSnatRuleSchema(), required=True, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeSubnet

获取子网信息
"""


class DescribeSubnetRequestSchema(schema.RequestSchema):
    """DescribeSubnet - 获取子网信息"""

    fields = {
        "BusinessId": fields.Str(
            required=False, dump_to="BusinessId"
        ),  # Deprecated, will be removed at 1.0
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouteTableId": fields.Str(required=False, dump_to="RouteTableId"),
        "ShowAvailableIPs": fields.Bool(
            required=False, dump_to="ShowAvailableIPs"
        ),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "SubnetIds": fields.List(fields.Str()),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class DescribeSubnetResponseSchema(schema.ResponseSchema):
    """DescribeSubnet - 获取子网信息"""

    fields = {
        "DataSet": fields.List(
            models.SubnetInfoSchema(), required=True, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeSubnetResource

展示子网资源
"""


class DescribeSubnetResourceRequestSchema(schema.RequestSchema):
    """DescribeSubnetResource - 展示子网资源"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceType": fields.Str(required=False, dump_to="ResourceType"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
    }


class DescribeSubnetResourceResponseSchema(schema.ResponseSchema):
    """DescribeSubnetResource - 展示子网资源"""

    fields = {
        "DataSet": fields.List(
            models.SubnetResourceSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeVIP

获取内网VIP详细信息
"""


class DescribeVIPRequestSchema(schema.RequestSchema):
    """DescribeVIP - 获取内网VIP详细信息"""

    fields = {
        "BusinessId": fields.Str(required=False, dump_to="BusinessId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VIPId": fields.Str(required=False, dump_to="VIPId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeVIPResponseSchema(schema.ResponseSchema):
    """DescribeVIP - 获取内网VIP详细信息"""

    fields = {
        "DataSet": fields.List(
            fields.Str(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
        "VIPSet": fields.List(
            models.VIPDetailSetSchema(), required=False, load_from="VIPSet"
        ),
    }


"""
API: DescribeVPC

获取VPC信息
"""


class DescribeVPCRequestSchema(schema.RequestSchema):
    """DescribeVPC - 获取VPC信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCIds": fields.List(fields.Str()),
    }


class DescribeVPCResponseSchema(schema.ResponseSchema):
    """DescribeVPC - 获取VPC信息"""

    fields = {
        "DataSet": fields.List(
            models.VPCInfoSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeVPCIntercom

获取VPC互通信息
"""


class DescribeVPCIntercomRequestSchema(schema.RequestSchema):
    """DescribeVPCIntercom - 获取VPC互通信息"""

    fields = {
        "DstProjectId": fields.Str(required=False, dump_to="DstProjectId"),
        "DstRegion": fields.Str(required=False, dump_to="DstRegion"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class DescribeVPCIntercomResponseSchema(schema.ResponseSchema):
    """DescribeVPCIntercom - 获取VPC互通信息"""

    fields = {
        "DataSet": fields.List(
            models.VPCIntercomInfoSchema(), required=False, load_from="DataSet"
        ),
    }


"""
API: DescribeWhiteListResource

展示NAT网关白名单资源列表
"""


class DescribeWhiteListResourceRequestSchema(schema.RequestSchema):
    """DescribeWhiteListResource - 展示NAT网关白名单资源列表"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWIds": fields.List(fields.Str()),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeWhiteListResourceResponseSchema(schema.ResponseSchema):
    """DescribeWhiteListResource - 展示NAT网关白名单资源列表"""

    fields = {
        "DataSet": fields.List(
            models.NatGWWhitelistDataSetSchema(),
            required=True,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DetachNetworkInterface

解绑云主机关联网卡
"""


class DetachNetworkInterfaceRequestSchema(schema.RequestSchema):
    """DetachNetworkInterface - 解绑云主机关联网卡"""

    fields = {
        "InstanceId": fields.Str(required=True, dump_to="InstanceId"),
        "InterfaceId": fields.Str(required=True, dump_to="InterfaceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DetachNetworkInterfaceResponseSchema(schema.ResponseSchema):
    """DetachNetworkInterface - 解绑云主机关联网卡"""

    fields = {}


"""
API: DisableUniEipDirectMode

关闭虚拟网卡EIP直通功能
"""


class DisableUniEipDirectModeRequestSchema(schema.RequestSchema):
    """DisableUniEipDirectMode - 关闭虚拟网卡EIP直通功能"""

    fields = {
        "InterfaceId": fields.Str(required=True, dump_to="InterfaceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DisableUniEipDirectModeResponseSchema(schema.ResponseSchema):
    """DisableUniEipDirectMode - 关闭虚拟网卡EIP直通功能"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DisassociateSecGroup

解绑安全组和资源绑定关系
"""


class DisassociateSecGroupRequestSchema(schema.RequestSchema):
    """DisassociateSecGroup - 解绑安全组和资源绑定关系"""

    fields = {
        "Force": fields.Bool(required=False, dump_to="Force"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceId": fields.Str(required=False, dump_to="ResourceId"),
        "SecGroupId": fields.Str(required=False, dump_to="SecGroupId"),
    }


class DisassociateSecGroupResponseSchema(schema.ResponseSchema):
    """DisassociateSecGroup - 解绑安全组和资源绑定关系"""

    fields = {}


"""
API: EnableUniEipDirectMode

开启虚拟网卡EIP直通功能
"""


class EnableUniEipDirectModeRequestSchema(schema.RequestSchema):
    """EnableUniEipDirectMode - 开启虚拟网卡EIP直通功能"""

    fields = {
        "InterfaceId": fields.Str(required=True, dump_to="InterfaceId"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class EnableUniEipDirectModeResponseSchema(schema.ResponseSchema):
    """EnableUniEipDirectMode - 开启虚拟网卡EIP直通功能"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: EnableWhiteList

修改NAT网关白名单开关
"""


class EnableWhiteListRequestSchema(schema.RequestSchema):
    """EnableWhiteList - 修改NAT网关白名单开关"""

    fields = {
        "IfOpen": fields.Int(required=True, dump_to="IfOpen"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class EnableWhiteListResponseSchema(schema.ResponseSchema):
    """EnableWhiteList - 修改NAT网关白名单开关"""

    fields = {}


"""
API: GetAvailableResourceForPolicy

获取NAT网关可配置端口转发规则的资源信息
"""


class GetAvailableResourceForPolicyRequestSchema(schema.RequestSchema):
    """GetAvailableResourceForPolicy - 获取NAT网关可配置端口转发规则的资源信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class GetAvailableResourceForPolicyResponseSchema(schema.ResponseSchema):
    """GetAvailableResourceForPolicy - 获取NAT网关可配置端口转发规则的资源信息"""

    fields = {
        "DataSet": fields.List(
            models.GetAvailableResourceForPolicyDataSetSchema(),
            required=True,
            load_from="DataSet",
        ),
    }


"""
API: GetAvailableResourceForSnatRule

获取可用于添加snat规则（出口规则）的资源列表
"""


class GetAvailableResourceForSnatRuleRequestSchema(schema.RequestSchema):
    """GetAvailableResourceForSnatRule - 获取可用于添加snat规则（出口规则）的资源列表"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class GetAvailableResourceForSnatRuleResponseSchema(schema.ResponseSchema):
    """GetAvailableResourceForSnatRule - 获取可用于添加snat规则（出口规则）的资源列表"""

    fields = {
        "Action": fields.Str(required=True, load_from="Action"),
        "DataSet": fields.List(
            models.GetAvailableResourceForSnatRuleDataSetSchema(),
            required=True,
            load_from="DataSet",
        ),
        "RetCode": fields.Str(required=True, load_from="RetCode"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: GetAvailableResourceForWhiteList

获取NAT网关可添加白名单的资源
"""


class GetAvailableResourceForWhiteListRequestSchema(schema.RequestSchema):
    """GetAvailableResourceForWhiteList - 获取NAT网关可添加白名单的资源"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class GetAvailableResourceForWhiteListResponseSchema(schema.ResponseSchema):
    """GetAvailableResourceForWhiteList - 获取NAT网关可添加白名单的资源"""

    fields = {
        "DataSet": fields.List(
            models.GetAvailableResourceForWhiteListDataSetSchema(),
            required=True,
            load_from="DataSet",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: GetNetworkAclTargetResource

获取ACL规则应用目标列表
"""


class GetNetworkAclTargetResourceRequestSchema(schema.RequestSchema):
    """GetNetworkAclTargetResource - 获取ACL规则应用目标列表"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetworkId": fields.List(fields.Str()),
    }


class GetNetworkAclTargetResourceResponseSchema(schema.ResponseSchema):
    """GetNetworkAclTargetResource - 获取ACL规则应用目标列表"""

    fields = {
        "TargetResourceList": fields.List(
            models.TargetResourceInfoSchema(),
            required=True,
            load_from="TargetResourceList",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: ListSubnetForNATGW

展示NAT网关可绑定的子网列表
"""


class ListSubnetForNATGWRequestSchema(schema.RequestSchema):
    """ListSubnetForNATGW - 展示NAT网关可绑定的子网列表"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
    }


class ListSubnetForNATGWResponseSchema(schema.ResponseSchema):
    """ListSubnetForNATGW - 展示NAT网关可绑定的子网列表"""

    fields = {
        "DataSet": fields.List(
            models.NatgwSubnetDataSetSchema(),
            required=False,
            load_from="DataSet",
        ),
    }


"""
API: ModifyRouteRule

路由策略增、删、改
"""


class ModifyRouteRuleRequestSchema(schema.RequestSchema):
    """ModifyRouteRule - 路由策略增、删、改"""

    fields = {
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RouteRule": fields.List(fields.Str()),
        "RouteTableId": fields.Str(required=True, dump_to="RouteTableId"),
    }


class ModifyRouteRuleResponseSchema(schema.ResponseSchema):
    """ModifyRouteRule - 路由策略增、删、改"""

    fields = {}


"""
API: MoveSecondaryIPMac

把 Secondary IP 从旧 MAC 迁移到新 MAC
"""


class MoveSecondaryIPMacRequestSchema(schema.RequestSchema):
    """MoveSecondaryIPMac - 把 Secondary IP 从旧 MAC 迁移到新 MAC"""

    fields = {
        "Ip": fields.Str(required=True, dump_to="Ip"),
        "NewMac": fields.Str(required=True, dump_to="NewMac"),
        "OldMac": fields.Str(required=True, dump_to="OldMac"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
    }


class MoveSecondaryIPMacResponseSchema(schema.ResponseSchema):
    """MoveSecondaryIPMac - 把 Secondary IP 从旧 MAC 迁移到新 MAC"""

    fields = {}


"""
API: ReleaseVIP

释放VIP资源
"""


class ReleaseVIPRequestSchema(schema.RequestSchema):
    """ReleaseVIP - 释放VIP资源"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VIPId": fields.Str(required=True, dump_to="VIPId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ReleaseVIPResponseSchema(schema.ResponseSchema):
    """ReleaseVIP - 释放VIP资源"""

    fields = {}


"""
API: SetGwDefaultExport

设置NAT网关的默认出口
"""


class SetGwDefaultExportRequestSchema(schema.RequestSchema):
    """SetGwDefaultExport - 设置NAT网关的默认出口"""

    fields = {
        "ExportEipId": fields.Str(required=False, dump_to="ExportEipId"),
        "ExportIp": fields.Str(required=False, dump_to="ExportIp"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class SetGwDefaultExportResponseSchema(schema.ResponseSchema):
    """SetGwDefaultExport - 设置NAT网关的默认出口"""

    fields = {}


"""
API: UpdateNATGWPolicy

更新NAT网关端口转发规则
"""


class UpdateNATGWPolicyRequestSchema(schema.RequestSchema):
    """UpdateNATGWPolicy - 更新NAT网关端口转发规则"""

    fields = {
        "DstIP": fields.Str(required=True, dump_to="DstIP"),
        "DstPort": fields.Str(required=True, dump_to="DstPort"),
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "PolicyId": fields.Str(required=True, dump_to="PolicyId"),
        "PolicyName": fields.Str(required=False, dump_to="PolicyName"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Protocol": fields.Str(required=True, dump_to="Protocol"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SrcEIPId": fields.Str(required=True, dump_to="SrcEIPId"),
        "SrcPort": fields.Str(required=True, dump_to="SrcPort"),
    }


class UpdateNATGWPolicyResponseSchema(schema.ResponseSchema):
    """UpdateNATGWPolicy - 更新NAT网关端口转发规则"""

    fields = {}


"""
API: UpdateNATGWSubnet

更新NAT网关绑定的子网
"""


class UpdateNATGWSubnetRequestSchema(schema.RequestSchema):
    """UpdateNATGWSubnet - 更新NAT网关绑定的子网"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetworkIds": fields.List(fields.Str()),
    }


class UpdateNATGWSubnetResponseSchema(schema.ResponseSchema):
    """UpdateNATGWSubnet - 更新NAT网关绑定的子网"""

    fields = {}


"""
API: UpdateNetworkAcl

更改ACL
"""


class UpdateNetworkAclRequestSchema(schema.RequestSchema):
    """UpdateNetworkAcl - 更改ACL"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "AclName": fields.Str(required=True, dump_to="AclName"),
        "Description": fields.Str(required=True, dump_to="Description"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class UpdateNetworkAclResponseSchema(schema.ResponseSchema):
    """UpdateNetworkAcl - 更改ACL"""

    fields = {}


"""
API: UpdateNetworkAclEntry

更新ACL的规则
"""


class UpdateNetworkAclEntryRequestSchema(schema.RequestSchema):
    """UpdateNetworkAclEntry - 更新ACL的规则"""

    fields = {
        "AclId": fields.Str(required=True, dump_to="AclId"),
        "CidrBlock": fields.Str(required=True, dump_to="CidrBlock"),
        "Description": fields.Str(required=False, dump_to="Description"),
        "Direction": fields.Str(required=True, dump_to="Direction"),
        "EntryAction": fields.Str(required=True, dump_to="EntryAction"),
        "EntryId": fields.Str(required=True, dump_to="EntryId"),
        "IpProtocol": fields.Str(required=True, dump_to="IpProtocol"),
        "PortRange": fields.Str(required=True, dump_to="PortRange"),
        "Priority": fields.Int(required=True, dump_to="Priority"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "TargetResourceIds": fields.List(fields.Str()),
        "TargetType": fields.Int(required=False, dump_to="TargetType"),
    }


class UpdateNetworkAclEntryResponseSchema(schema.ResponseSchema):
    """UpdateNetworkAclEntry - 更新ACL的规则"""

    fields = {}


"""
API: UpdateNetworkInterfaceDefaultOutput

更新虚拟网卡默认出口(仅用于开启EIP网卡可见模式的虚拟网卡)
"""


class UpdateNetworkInterfaceDefaultOutputRequestSchema(schema.RequestSchema):
    """UpdateNetworkInterfaceDefaultOutput - 更新虚拟网卡默认出口(仅用于开启EIP网卡可见模式的虚拟网卡)"""

    fields = {
        "InterfaceId": fields.Str(required=True, dump_to="InterfaceId"),
        "Output": fields.Str(required=False, dump_to="Output"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpdateNetworkInterfaceDefaultOutputResponseSchema(schema.ResponseSchema):
    """UpdateNetworkInterfaceDefaultOutput - 更新虚拟网卡默认出口(仅用于开启EIP网卡可见模式的虚拟网卡)"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpdateRouteTableAttribute

更新路由表基本信息
"""


class UpdateRouteTableAttributeRequestSchema(schema.RequestSchema):
    """UpdateRouteTableAttribute - 更新路由表基本信息"""

    fields = {
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "RouteTableId": fields.Str(required=True, dump_to="RouteTableId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
    }


class UpdateRouteTableAttributeResponseSchema(schema.ResponseSchema):
    """UpdateRouteTableAttribute - 更新路由表基本信息"""

    fields = {}


"""
API: UpdateSecGroup

更新安全组基本信息
"""


class UpdateSecGroupRequestSchema(schema.RequestSchema):
    """UpdateSecGroup - 更新安全组基本信息"""

    fields = {
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SecGroupId": fields.Str(required=True, dump_to="SecGroupId"),
    }


class UpdateSecGroupResponseSchema(schema.ResponseSchema):
    """UpdateSecGroup - 更新安全组基本信息"""

    fields = {}


"""
API: UpdateSecGroupAssociation

仅对操作的安全组ID生效，其他已有的绑定关系不受影响。
"""


class UpdateSecGroupAssociationParamNewPrioritySecGroupSchema(
    schema.RequestSchema
):
    """UpdateSecGroupAssociationParamNewPrioritySecGroup -"""

    fields = {
        "Priority": fields.Int(required=True, dump_to="Priority"),
        "SecGroupId": fields.Str(required=True, dump_to="SecGroupId"),
    }


class UpdateSecGroupAssociationRequestSchema(schema.RequestSchema):
    """UpdateSecGroupAssociation - 仅对操作的安全组ID生效，其他已有的绑定关系不受影响。"""

    fields = {
        "NewPrioritySecGroup": fields.List(
            UpdateSecGroupAssociationParamNewPrioritySecGroupSchema()
        ),
        "OldSecGroupId": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceId": fields.Str(required=True, dump_to="ResourceId"),
    }


class UpdateSecGroupAssociationResponseSchema(schema.ResponseSchema):
    """UpdateSecGroupAssociation - 仅对操作的安全组ID生效，其他已有的绑定关系不受影响。"""

    fields = {}


"""
API: UpdateSecGroupRule


"""


class UpdateSecGroupRuleParamRuleSchema(schema.RequestSchema):
    """UpdateSecGroupRuleParamRule -"""

    fields = {
        "Direction": fields.Str(required=True, dump_to="Direction"),
        "DstPort": fields.Str(required=True, dump_to="DstPort"),
        "IPRange": fields.Str(required=True, dump_to="IPRange"),
        "Priority": fields.Int(required=True, dump_to="Priority"),
        "ProtocolType": fields.Str(required=True, dump_to="ProtocolType"),
        "Remark": fields.Str(required=True, dump_to="Remark"),
        "RuleAction": fields.Str(required=True, dump_to="RuleAction"),
        "RuleId": fields.Str(required=True, dump_to="RuleId"),
    }


class UpdateSecGroupRuleRequestSchema(schema.RequestSchema):
    """UpdateSecGroupRule -"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Rule": fields.List(UpdateSecGroupRuleParamRuleSchema()),
        "SecGroupId": fields.Str(required=True, dump_to="SecGroupId"),
    }


class UpdateSecGroupRuleResponseSchema(schema.ResponseSchema):
    """UpdateSecGroupRule -"""

    fields = {}


"""
API: UpdateSnatRule

更新指定的出口规则（SNAT规则）
"""


class UpdateSnatRuleRequestSchema(schema.RequestSchema):
    """UpdateSnatRule - 更新指定的出口规则（SNAT规则）"""

    fields = {
        "NATGWId": fields.Str(required=True, dump_to="NATGWId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnatIp": fields.Str(required=True, dump_to="SnatIp"),
        "SourceIp": fields.Str(required=True, dump_to="SourceIp"),
    }


class UpdateSnatRuleResponseSchema(schema.ResponseSchema):
    """UpdateSnatRule - 更新指定的出口规则（SNAT规则）"""

    fields = {}


"""
API: UpdateSubnetAttribute

更新子网信息
"""


class UpdateSubnetAttributeRequestSchema(schema.RequestSchema):
    """UpdateSubnetAttribute - 更新子网信息"""

    fields = {
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=True, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
    }


class UpdateSubnetAttributeResponseSchema(schema.ResponseSchema):
    """UpdateSubnetAttribute - 更新子网信息"""

    fields = {}


"""
API: UpdateVIPAttribute

更新VIP信息
"""


class UpdateVIPAttributeRequestSchema(schema.RequestSchema):
    """UpdateVIPAttribute - 更新VIP信息"""

    fields = {
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VIPId": fields.Str(required=True, dump_to="VIPId"),
    }


class UpdateVIPAttributeResponseSchema(schema.ResponseSchema):
    """UpdateVIPAttribute - 更新VIP信息"""

    fields = {}


"""
API: UpdateVPCNetwork

更新VPC网段
"""


class UpdateVPCNetworkRequestSchema(schema.RequestSchema):
    """UpdateVPCNetwork - 更新VPC网段"""

    fields = {
        "Network": fields.List(fields.Str()),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCId": fields.Str(required=True, dump_to="VPCId"),
    }


class UpdateVPCNetworkResponseSchema(schema.ResponseSchema):
    """UpdateVPCNetwork - 更新VPC网段"""

    fields = {
        "Message": fields.Str(
            required=True, load_from="Message"
        ),  # Deprecated, will be removed at 1.0
    }
