""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.umongodb.schemas import models

""" UMongoDB API Schema
"""


"""
API: BackupUMongoDBCluster

备份集群数据库
"""


class BackupUMongoDBClusterRequestSchema(schema.RequestSchema):
    """BackupUMongoDBCluster - 备份集群数据库"""

    fields = {
        "BackupName": fields.Str(required=True, dump_to="BackupName"),
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class BackupUMongoDBClusterResponseSchema(schema.ResponseSchema):
    """BackupUMongoDBCluster - 备份集群数据库"""

    fields = {
        "BackupId": fields.Str(required=True, load_from="BackupId"),
        "ClusterId": fields.Str(required=True, load_from="ClusterId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateUMongoDBConfigTemplate

创建配置模板
"""


class CreateUMongoDBConfigTemplateRequestSchema(schema.RequestSchema):
    """CreateUMongoDBConfigTemplate - 创建配置模板"""

    fields = {
        "BaseTemplateId": fields.Str(required=True, dump_to="BaseTemplateId"),
        "ClusterType": fields.Str(required=True, dump_to="ClusterType"),
        "Description": fields.Str(required=False, dump_to="Description"),
        "MongodbVersion": fields.Str(required=True, dump_to="MongodbVersion"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "TemplateName": fields.Str(required=True, dump_to="TemplateName"),
    }


class CreateUMongoDBConfigTemplateResponseSchema(schema.ResponseSchema):
    """CreateUMongoDBConfigTemplate - 创建配置模板"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "TemplateId": fields.Str(required=True, load_from="TemplateId"),
    }


"""
API: CreateUMongoDBReplSet

创建一个Mongodb副本集群
"""


class CreateUMongoDBReplSetRequestSchema(schema.RequestSchema):
    """CreateUMongoDBReplSet - 创建一个Mongodb副本集群"""

    fields = {
        "AdminPassword": fields.Str(required=True, dump_to="AdminPassword"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "DBVersion": fields.Str(required=True, dump_to="DBVersion"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "ListenPort": fields.Int(required=False, dump_to="ListenPort"),
        "MachineTypeId": fields.Str(required=True, dump_to="MachineTypeId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "NodeCount": fields.Int(required=True, dump_to="NodeCount"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUMongoDBReplSetResponseSchema(schema.ResponseSchema):
    """CreateUMongoDBReplSet - 创建一个Mongodb副本集群"""

    fields = {}


"""
API: CreateUMongoDBShardedCluster

创建一个Mongodb分片集群
"""


class CreateUMongoDBShardedClusterRequestSchema(schema.RequestSchema):
    """CreateUMongoDBShardedCluster - 创建一个Mongodb分片集群"""

    fields = {
        "AdminPassword": fields.Str(required=True, dump_to="AdminPassword"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "DBVersion": fields.Str(required=True, dump_to="DBVersion"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "ListenPort": fields.Int(required=False, dump_to="ListenPort"),
        "MachineTypeId": fields.Str(required=True, dump_to="MachineTypeId"),
        "MongosMachineTypeId": fields.Str(
            required=False, dump_to="MongosMachineTypeId"
        ),
        "MongosNodeCount": fields.Int(required=True, dump_to="MongosNodeCount"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "NodeCount": fields.Int(required=True, dump_to="NodeCount"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ShardCount": fields.Int(required=True, dump_to="ShardCount"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "TemplateId": fields.Str(required=False, dump_to="TemplateId"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateUMongoDBShardedClusterResponseSchema(schema.ResponseSchema):
    """CreateUMongoDBShardedCluster - 创建一个Mongodb分片集群"""

    fields = {}


"""
API: DescribeUMongoDBBackupURL

获取实例备份下载链接
"""


class DescribeUMongoDBBackupURLRequestSchema(schema.RequestSchema):
    """DescribeUMongoDBBackupURL - 获取实例备份下载链接"""

    fields = {
        "BackupId": fields.Str(required=False, dump_to="BackupId"),
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "PackageId": fields.Int(required=False, dump_to="PackageId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ValidTime": fields.Int(required=False, dump_to="ValidTime"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUMongoDBBackupURLResponseSchema(schema.ResponseSchema):
    """DescribeUMongoDBBackupURL - 获取实例备份下载链接"""

    fields = {
        "InternetAddress": fields.Str(
            required=True, load_from="InternetAddress"
        ),
        "IntranetAddress": fields.Str(
            required=True, load_from="IntranetAddress"
        ),
    }


"""
API: DescribeUMongoDBInstance

描述MongoDB实例
"""


class DescribeUMongoDBInstanceRequestSchema(schema.RequestSchema):
    """DescribeUMongoDBInstance - 描述MongoDB实例"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ClusterType": fields.Str(required=False, dump_to="ClusterType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUMongoDBInstanceResponseSchema(schema.ResponseSchema):
    """DescribeUMongoDBInstance - 描述MongoDB实例"""

    fields = {
        "ClusterInfo": models.ClusterInfoSchema(),
    }


"""
API: GetUMongoDBBackupParam

获取实例备份策略
"""


class GetUMongoDBBackupParamRequestSchema(schema.RequestSchema):
    """GetUMongoDBBackupParam - 获取实例备份策略"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetUMongoDBBackupParamResponseSchema(schema.ResponseSchema):
    """GetUMongoDBBackupParam - 获取实例备份策略"""

    fields = {
        "DataSet": models.BackupParamSchema(),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: GetUMongoDBCfgTempItem

获取配置模板内容
"""


class GetUMongoDBCfgTempItemRequestSchema(schema.RequestSchema):
    """GetUMongoDBCfgTempItem - 获取配置模板内容"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "TemplateId": fields.Str(required=True, dump_to="TemplateId"),
    }


class GetUMongoDBCfgTempItemResponseSchema(schema.ResponseSchema):
    """GetUMongoDBCfgTempItem - 获取配置模板内容"""

    fields = {
        "DataSet": fields.List(
            models.ConfigTemplateItemSchema(),
            required=True,
            load_from="DataSet",
        ),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: GetUMongoDBRecoverTimeRange

获取UMongoDB可回档时间范围
"""


class GetUMongoDBRecoverTimeRangeRequestSchema(schema.RequestSchema):
    """GetUMongoDBRecoverTimeRange - 获取UMongoDB可回档时间范围"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetUMongoDBRecoverTimeRangeResponseSchema(schema.ResponseSchema):
    """GetUMongoDBRecoverTimeRange - 获取UMongoDB可回档时间范围"""

    fields = {
        "EarliestTime": fields.Int(required=True, load_from="EarliestTime"),
        "LatestTime": fields.Int(required=True, load_from="LatestTime"),
    }


"""
API: ListUMongoDBBackup

拉取实例备份列表
"""


class ListUMongoDBBackupRequestSchema(schema.RequestSchema):
    """ListUMongoDBBackup - 拉取实例备份列表"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ListUMongoDBBackupResponseSchema(schema.ResponseSchema):
    """ListUMongoDBBackup - 拉取实例备份列表"""

    fields = {
        "DataSet": fields.List(
            models.BackupInfoSchema(), required=True, load_from="DataSet"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ListUMongoDBConfigTemplate

拉取配置模板
"""


class ListUMongoDBConfigTemplateRequestSchema(schema.RequestSchema):
    """ListUMongoDBConfigTemplate - 拉取配置模板"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class ListUMongoDBConfigTemplateResponseSchema(schema.ResponseSchema):
    """ListUMongoDBConfigTemplate - 拉取配置模板"""

    fields = {
        "DataSet": fields.List(
            models.ConfigTemplateSchema(), required=True, load_from="DataSet"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ListUMongoDBMachineType

获取UmongDB支持机器类型列表
"""


class ListUMongoDBMachineTypeRequestSchema(schema.RequestSchema):
    """ListUMongoDBMachineType - 获取UmongDB支持机器类型列表"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ListUMongoDBMachineTypeResponseSchema(schema.ResponseSchema):
    """ListUMongoDBMachineType - 获取UmongDB支持机器类型列表"""

    fields = {
        "DataSet": fields.List(
            models.MongodbMachineTypeSchema(),
            required=True,
            load_from="DataSet",
        ),
    }


"""
API: ListUMongoDBVersion

获取UMongoDB支持版本列表
"""


class ListUMongoDBVersionRequestSchema(schema.RequestSchema):
    """ListUMongoDBVersion - 获取UMongoDB支持版本列表"""

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ListUMongoDBVersionResponseSchema(schema.ResponseSchema):
    """ListUMongoDBVersion - 获取UMongoDB支持版本列表"""

    fields = {
        "DataSet": fields.List(
            models.MongoDBVersionSchema(), required=True, load_from="DataSet"
        ),
    }


"""
API: ModifyUMongoDBAdminPassword

修改MongoDB集群root密码
"""


class ModifyUMongoDBAdminPasswordRequestSchema(schema.RequestSchema):
    """ModifyUMongoDBAdminPassword - 修改MongoDB集群root密码"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "Password": fields.Str(required=True, dump_to="Password"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ModifyUMongoDBAdminPasswordResponseSchema(schema.ResponseSchema):
    """ModifyUMongoDBAdminPassword - 修改MongoDB集群root密码"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ModifyUMongoDBAttribute

修改MongoDB集群名称
"""


class ModifyUMongoDBAttributeRequestSchema(schema.RequestSchema):
    """ModifyUMongoDBAttribute - 修改MongoDB集群名称"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "Name": fields.Str(required=False, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RemarkName": fields.Str(required=False, dump_to="RemarkName"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ModifyUMongoDBAttributeResponseSchema(schema.ResponseSchema):
    """ModifyUMongoDBAttribute - 修改MongoDB集群名称"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ModifyUMongoDBBackupParam

修改实例备份策略
"""


class ModifyUMongoDBBackupParamRequestSchema(schema.RequestSchema):
    """ModifyUMongoDBBackupParam - 修改实例备份策略"""

    fields = {
        "AutoBackupToggleTime": fields.Str(
            required=False, dump_to="AutoBackupToggleTime"
        ),
        "AutoBackupToggleWeek": fields.Str(
            required=False, dump_to="AutoBackupToggleWeek"
        ),
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "Disabled": fields.Bool(required=False, dump_to="Disabled"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ModifyUMongoDBBackupParamResponseSchema(schema.ResponseSchema):
    """ModifyUMongoDBBackupParam - 修改实例备份策略"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RestartUMongoDBCluster

重启集群
"""


class RestartUMongoDBClusterRequestSchema(schema.RequestSchema):
    """RestartUMongoDBCluster - 重启集群"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RestartUMongoDBClusterResponseSchema(schema.ResponseSchema):
    """RestartUMongoDBCluster - 重启集群"""

    fields = {
        "ClusterId": fields.Str(required=True, load_from="ClusterId"),
    }


"""
API: StartUMongoDBCluster

启动集群
"""


class StartUMongoDBClusterRequestSchema(schema.RequestSchema):
    """StartUMongoDBCluster - 启动集群"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class StartUMongoDBClusterResponseSchema(schema.ResponseSchema):
    """StartUMongoDBCluster - 启动集群"""

    fields = {
        "ClusterId": fields.Str(required=True, load_from="ClusterId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: StopUMongoDBCluster

停止集群
"""


class StopUMongoDBClusterRequestSchema(schema.RequestSchema):
    """StopUMongoDBCluster - 停止集群"""

    fields = {
        "ClusterId": fields.Str(required=True, dump_to="ClusterId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class StopUMongoDBClusterResponseSchema(schema.ResponseSchema):
    """StopUMongoDBCluster - 停止集群"""

    fields = {
        "ClusterId": fields.Str(required=True, load_from="ClusterId"),
        "Message": fields.Str(required=True, load_from="Message"),
    }
