""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.ipv6gw.schemas import apis


class ipv6gwClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(ipv6gwClient, self).__init__(
            config, transport, middleware, logger
        )

    def allocate_ipv_6internet_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """AllocateIpv6InternetBandwidth - 分配ipv6公网带宽

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Bandwidth** (int) - (Required) 出向带宽峰值。带宽值范围[1, 2000]
        - **Ipv6AddressId** (str) - (Required) Ipv6地址ID
        - **ChargeType** (str) - 付费方式；默认值："Month";枚举值："Dynamic" -> 按时付费，"Month" -> 月付，"Year" ->年付，"Day" -> 天付
        - **Ipv6GatewayId** (str) - ipv6网关ID；与VPCId二选一必填
        - **Name** (str) - 资源名称；默认值："Ipv6InternetBandwidth"
        - **PayMode** (str) - 付费模式；默认值："Bandwidth"；枚举值："Bandwidth" -> 带宽计费
        - **Quantity** (int) - 购买数量；默认值：1。 月付时，此参数传0，代表了购买至月末。
        - **Remark** (str) - 备注
        - **Tag** (str) - 业务组名称；默认值："Default"
        - **VPCId** (str) - vpcId；与Ipv6GatewayId二选一必填

        **Response**

        - **InternetBandwidthId** (str) - 开通公网带宽后，对应的公网带宽实例 ID。
        - **Ipv6Address** (str) - ipv6地址
        - **Ipv6AddressId** (str) - ipv6地址ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.AllocateIpv6InternetBandwidthRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("AllocateIpv6InternetBandwidth", d, **kwargs)
        return apis.AllocateIpv6InternetBandwidthResponseSchema().loads(resp)

    def create_ipv_6gateway(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """CreateIpv6Gateway - 创建ipv6网关

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **VPCId** (str) - (Required) ipv6网关所属的VPCID
        - **Name** (str) - IPv6 网关的名称 默认值 Ipv6Gateway
        - **Remark** (str) - IPv6 网关的备注信息。
        - **Tag** (str) - 业务组名称；默认值："Default"

        **Response**

        - **Ipv6GatewayId** (str) - ipv6网关ID

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.CreateIpv6GatewayRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateIpv6Gateway", d, **kwargs)
        return apis.CreateIpv6GatewayResponseSchema().loads(resp)

    def delete_ipv_6gateway(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteIpv6Gateway - 删除ipv6网关

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Ipv6GatewayId** (str) - (Required) ipv6网关ID

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteIpv6GatewayRequestSchema().dumps(d)

        resp = self.invoke("DeleteIpv6Gateway", d, **kwargs)
        return apis.DeleteIpv6GatewayResponseSchema().loads(resp)

    def delete_ipv_6internet_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DeleteIpv6InternetBandwidth - 删除ipv6公网带宽

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **InternetBandwidthId** (str) - ipv6公网带宽ID；与Ipv6AddressId二选一必填
        - **Ipv6AddressId** (str) - ipv6 ID；与InternetBandwidthId二选一必填

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DeleteIpv6InternetBandwidthRequestSchema().dumps(d)

        resp = self.invoke("DeleteIpv6InternetBandwidth", d, **kwargs)
        return apis.DeleteIpv6InternetBandwidthResponseSchema().loads(resp)

    def describe_ipv_6gateway_attribute(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeIpv6GatewayAttribute - 查看指定ipv6网关详情, 该接口仅返回能开启公网带宽的ipv6信息

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Ipv6GatewayId** (str) - (Required) ipv6网关ID
        - **Limit** (int) - 返回数据长度，默认值为20，最大值为100
        - **ObjectType** (str) - ipv6地址绑定资源类型。传空则返回不按资源类型过滤。枚举值:"uhost" -> 云主机; "uni" -> 虚拟网卡; "alb" -> 应用型负载均衡; "nlb" -> 网络型负载均衡
        - **Offset** (int) - 列表起始位置偏移量，默认值为0

        **Response**

        - **CreateTime** (int) - 创建时间
        - **Ipv6AddressInfos** (list) - 见 **IPv6AddressInfo** 模型定义
        - **Ipv6GatewayId** (str) - ipv6网关ID
        - **Name** (str) - 名称
        - **Remark** (str) - 备注
        - **Tag** (str) - 业务组
        - **TotalCount** (int) - 总数
        - **VPCId** (str) - vpc ID

        **Response Model**

        **IPv6AddressInfo**
        - **AutoRenew** (str) - 是否自动续费。枚举值："Yes" -> 是; "No" -> 否; "UnKnown" -> 未知
        - **Bandwidth** (int) - 带宽值
        - **ChargeType** (str) - 收费类型
        - **Expire** (str) - 是否过期。 枚举值: "Expired" -> 过期; "UnExpired" -> 未过期; "UnKnown" -> 未知
        - **ExpireTime** (int) - 过期时间
        - **InternetBandwidthId** (str) - ipv6外网带宽Id
        - **Ipv6Address** (str) - ipv6地址
        - **Ipv6AddressId** (str) - ipv6地址ID
        - **ObjectId** (str) - 绑定的资源ID
        - **ObjectName** (str) - 绑定对象名称
        - **ObjectType** (str) - 绑定对象资源类型
        - **OperatorName** (str) - 线路名称。枚举值: "ChinaMobile" -> 移动; "BGP" -> BGP; "Unicom" -> 联通; "Telecom" -> 电信
        - **PayMode** (str) - 付费模式。枚举值："Bandwidth" -> 带宽计费
        - **Status** (str) - 状态。 枚举值:"Public" -> 已开启公网带宽; "Normal" -> 未开启公网带宽
        - **SubnetId** (str) - 子网ID


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeIpv6GatewayAttributeRequestSchema().dumps(d)

        resp = self.invoke("DescribeIpv6GatewayAttribute", d, **kwargs)
        return apis.DescribeIpv6GatewayAttributeResponseSchema().loads(resp)

    def describe_ipv_6gateways(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """DescribeIpv6Gateways - ipv6网关列表

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Ipv6GatewayIds** (list) - ipv6网关ID列表，最大长度为20。指定Ipv6GatewayIds查询时，将忽略其他条件
        - **Limit** (int) - 返回数据长度，默认值为20，最大值为100
        - **Offset** (int) - 列表起始位置偏移量，默认值为0
        - **VPCId** (str) - vpc ID

        **Response**

        - **Ipv6GatewayInfos** (list) - 见 **IPv6GateWayInfo** 模型定义
        - **TotalCount** (int) - Ipv6Gateway总数。指定Ipv6GatewayIds / VPCId时，返回数量受限

        **Response Model**

        **IPv6GateWayInfo**
        - **CreateTime** (int) - 创建时间
        - **Ipv6GatewayId** (str) - ipv6 网关 ID
        - **Name** (str) - 名称
        - **Remark** (str) - 备注
        - **Tag** (str) - 业务组
        - **VPCId** (str) - vpc ID


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.DescribeIpv6GatewaysRequestSchema().dumps(d)

        resp = self.invoke("DescribeIpv6Gateways", d, **kwargs)
        return apis.DescribeIpv6GatewaysResponseSchema().loads(resp)

    def modify_ipv_6internet_bandwidth(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ModifyIpv6InternetBandwidth - 修改ipv6公网带宽值

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list>`_
        - **Region** (str) - (Config) 地域。 参见  `地域和可用区列表 <https://docs.ucloud.cn/api/summary/regionlist>`_
        - **Bandwidth** (int) - 要修改为的出向带宽峰值。带宽值范围[1, 2000]
        - **InternetBandwidthId** (str) - ipv6公网带宽Id；与Ipv6AddressId二选一必填
        - **Ipv6AddressId** (str) - Ipv6地址 id；与InternetBandwidthId二选一必填

        **Response**


        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
            "Region": self.config.region,
        }
        req and d.update(req)
        d = apis.ModifyIpv6InternetBandwidthRequestSchema().dumps(d)

        resp = self.invoke("ModifyIpv6InternetBandwidth", d, **kwargs)
        return apis.ModifyIpv6InternetBandwidthResponseSchema().loads(resp)
