""" Code is generated by ucloud-model, DO NOT EDIT IT. """

import typing


from ucloud.core.client import Client
from ucloud.services.uhub.schemas import apis


class UHubClient(Client):
    def __init__(
        self, config: dict, transport=None, middleware=None, logger=None
    ):
        super(UHubClient, self).__init__(config, transport, middleware, logger)

    def create_repo(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ CreateRepo - 创建镜像仓库

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **RepoName** (str) - (Required) 仓库名称，不可修改
        - **Description** (str) - 仓库备注
        - **IsShared** (bool) - 镜像仓库是否公开，公开为true、不公开为false;默认为false
        
        **Response**

        - **Message** (str) - 有错误时返回内容
        
        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.CreateRepoRequestSchema().dumps(d)

        # build options
        kwargs["max_retries"] = 0  # ignore retry when api is not idempotent

        resp = self.invoke("CreateRepo", d, **kwargs)
        return apis.CreateRepoResponseSchema().loads(resp)

    def delete_repo(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ DeleteRepo - 删除镜像仓库

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **RepoName** (str) - (Required) 镜像仓库名称
        
        **Response**

        
        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteRepoRequestSchema().dumps(d)

        resp = self.invoke("DeleteRepo", d, **kwargs)
        return apis.DeleteRepoResponseSchema().loads(resp)

    def delete_repo_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ DeleteRepoImage - 删除镜像

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **ImageName** (str) - (Required) 镜像名称
        - **RepoName** (str) - (Required) 镜像仓库名称
        - **TagName** (str) - 不指定tag则删除全部tag
        
        **Response**

        
        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.DeleteRepoImageRequestSchema().dumps(d)

        resp = self.invoke("DeleteRepoImage", d, **kwargs)
        return apis.DeleteRepoImageResponseSchema().loads(resp)

    def get_image_tag(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ GetImageTag - 获取镜像tag

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **ImageName** (str) - (Required) 镜像名称
        - **RepoName** (str) - (Required) 镜像仓库名称
        - **Limit** (int) - 每次获取数量，默认为20
        - **Offset** (int) - 偏移量，默认0
        - **TagName** (str) - 默认不写，如果填写，代表查询该tag，否则查全部tag
        
        **Response**

        - **TagSet** (list) - 见 **TagSet** 模型定义
        - **TotalCount** (int) - tag总数
        
        **Response Model**
        
        **TagSet** 
        
        - **TagName** (str) - Tag名称
        - **UpdateTime** (str) - 镜像更新时间

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetImageTagRequestSchema().dumps(d)

        resp = self.invoke("GetImageTag", d, **kwargs)
        return apis.GetImageTagResponseSchema().loads(resp)

    def get_repo(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ GetRepo - 获取镜像仓库

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **Limit** (int) - 数量，默认20
        - **Offset** (int) - 偏移量，默认0
        - **Type** (str) - private私有仓库，public公共仓库，默认public
        
        **Response**

        - **RepoSet** (list) - 见 **RepoSet** 模型定义
        - **TotalCount** (int) - 总的仓库数量
        
        **Response Model**
        
        **RepoSet** 
        
        - **CreateTime** (str) - 仓库创建时间
        - **Description** (str) - 镜像仓库描述
        - **IsOutSide** (str) - 镜像仓库是否外网可以访问，可以为ture,不可以为false
        - **IsShared** (str) - 镜像仓库类型,false为私有；true为公有
        - **RepoName** (str) - 镜像仓库名称
        - **UpdateTime** (str) - 仓库更新时间

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetRepoRequestSchema().dumps(d)

        resp = self.invoke("GetRepo", d, **kwargs)
        return apis.GetRepoResponseSchema().loads(resp)

    def get_repo_image(
        self, req: typing.Optional[dict] = None, **kwargs
    ) -> dict:
        """ GetRepoImage - 获取镜像仓库下的镜像

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **RepoName** (str) - (Required) 镜像仓库名称
        - **Limit** (int) - 显示数量，默认为20
        - **Offset** (int) - 偏移量，默认0
        
        **Response**

        - **ImageSet** (list) - 见 **ImageSet** 模型定义
        - **TotalCount** (int) - 
        
        **Response Model**
        
        **ImageSet** 
        
        - **CreateTime** (str) - 创建时间
        - **ImageName** (str) - 镜像名称
        - **LatestTag** (str) - 最新push的Tag
        - **PullCount** (int) - 镜像被下载次数
        - **RepoName** (str) - 镜像仓库名称
        - **UpdateTime** (str) - 修改时间

        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.GetRepoImageRequestSchema().dumps(d)

        resp = self.invoke("GetRepoImage", d, **kwargs)
        return apis.GetRepoImageResponseSchema().loads(resp)

    def update_repo(self, req: typing.Optional[dict] = None, **kwargs) -> dict:
        """ UpdateRepo - 更新镜像仓库

        **Request**

        - **ProjectId** (str) - (Config) 项目ID。不填写为默认项目，子帐号必须填写。 请参考 `GetProjectList接口 <https://docs.ucloud.cn/api/summary/get_project_list.html>`_ 
        - **RepoName** (str) - (Required) 镜像仓库名称，不可修改
        - **Description** (str) - 备注
        - **IsShared** (str) - false设置为私有；true设置为公有。默认false
        
        **Response**

        - **Message** (str) - 错误的时候返回
        
        """
        # build request
        d = {
            "ProjectId": self.config.project_id,
        }
        req and d.update(req)
        d = apis.UpdateRepoRequestSchema().dumps(d)

        resp = self.invoke("UpdateRepo", d, **kwargs)
        return apis.UpdateRepoResponseSchema().loads(resp)
